

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetTPPMMappingForClient.sp] ---------- 

-- ==================================================================================================================
--  Author:         	Kaushal Ghai
--  Create date:        05/11/2012
--  Description:        To provide the TPPM Mapping for a client(Either the client is forwarding request or receiving request)
--
--  Input : : 		clientId
--  Output : :  	TPPM Mappings where the clientId is either the fromEntity(forwarding TPPM request to some other entity) or the toEntity(request is --			forwarded to this client by some other)
--
--			For a special case of AD Mapping, fromEntityId is always CommServe(id = 2) and toEntity is the client selected. We populate an extra --			parameter, targetHostName, which is the hostName of the AD Server (from UMDSProviders table)
-- ====================================================================================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetTPPMMappingForClient <<<'

IF EXISTS (select * from sysobjects where name='APPGetTPPMMappingForClient')
	drop procedure APPGetTPPMMappingForClient
IF EXISTS (select * from GxQscripts where name='APPGetTPPMMappingForClient')
	delete from GxQscripts where name = 'APPGetTPPMMappingForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetTPPMMappingForClient')
	delete from GXDBVersions where aliasname = 'APPGetTPPMMappingForClient'
GO
print '... Creating Procedure: APPGetTPPMMappingForClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure APPGetTPPMMappingForClient
  @clientId integer
AS
  DECLARE @o_fromId integer
  DECLARE @o_fromName nvarchar(255)
  DECLARE @o_fromHostName nvarchar(255)
  DECLARE @o_fromGUID nvarchar(255)
  DECLARE @o_fromPort integer
  DECLARE @o_toId integer
  DECLARE @o_toName nvarchar(255)
  DECLARE @o_toHostName nvarchar(255)
  DECLARE @o_toGUID nvarchar(255)
  DECLARE @o_toPort integer
  DECLARE @o_targetHostName nvarchar(4000)
  DECLARE @o_tppmType integer
select 		T.fromEntityId as fromId,
		(select name  from APP_Client where id = T.fromEntityId ) as fromName,
		(select net_hostname from APP_Client where id = T.fromEntityId) as fromHostName,
		(select GUID from APP_Client where id = T.fromEntityId) as fromGUID,
		T.fromPortNumber as fromPortNumber,
		T.toEntityId as toId,
		C2.name as toName,
		C2.net_hostname as toNetHostName,
		C2.GUID as toGUID,
		T.toPortNumber as toPortNumber,
		case T.tppmType WHEN 4 THEN
		(select case P.serviceType
when 6 then 'ldap.jumpcloud.com'
					else P.hostName end
		  from UMDSProviders P where P.id = CAST(T.tppmParams AS INT)) ELSE ''  END as targetHostName,
		T.tppmType as tppmType
	from APP_FirewallTPPM T  inner join APP_Client C2 with (nolock)
	ON T.toEntityId = C2.id
	WHERE T.fromEntityId = @clientId AND T.status = 1
UNION ALL
select 		T.fromEntityId as FromId,
		C2.name as fromName,
		C2.net_hostname as fromHostName,
		C2.GUID as fromGUID,
		T.fromPortNumber as fromPortNumber,
		T.toEntityId as toId,
		(select name  from APP_Client where id = T.toEntityId ) as toName,
		(select net_hostname from APP_Client where id = T.toEntityId) as toNetHostName,
		(select GUID from APP_Client where id = T.fromEntityId) as toGUID,
		T.toPortNumber as toPortNumber,
		case T.tppmType WHEN 4 THEN
		(select case P.serviceType
when 6 then 'ldap.jumpcloud.com'
					else P.hostName end
		  from UMDSProviders P where P.id = CAST(T.tppmParams AS INT)) ELSE ''  END as targetHostName,
		T.tppmType as tppmType
	from APP_FirewallTPPM T  inner join APP_Client C2 with (nolock)
	ON T.fromEntityId = C2.id
	WHERE T.toEntityId = @clientId AND T.status = 1
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetTPPMMappingForClient')
	delete from GxQscripts where name = 'APPGetTPPMMappingForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetTPPMMappingForClient')
	delete from GXDBVersions where aliasname = 'APPGetTPPMMappingForClient'
GO

insert into GXDBVersions values(2, 'APPGetTPPMMappingForClient',  '00000000000000000000', 'APPGetTPPMMappingForClient', '00000000000000000000')
GO

