

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetSybaseSubclientProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetSybaseSubclientProperties <<<'

IF EXISTS (select * from sysobjects where name='APPGetSybaseSubclientProperties')
	drop procedure APPGetSybaseSubclientProperties
IF EXISTS (select * from GxQscripts where name='APPGetSybaseSubclientProperties')
	delete from GxQscripts where name = 'APPGetSybaseSubclientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetSybaseSubclientProperties')
	delete from GXDBVersions where aliasname = 'APPGetSybaseSubclientProperties'
GO
print '... Creating Procedure: APPGetSybaseSubclientProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetSybaseSubclientProperties
  @subclientId INT,
  @propertyLevel INT,
  @resultXML XML OUTPUT
AS
	DECLARE	@applicationId		INT
	DECLARE	@runPostBackup		INT
	DECLARE	@databaseID			INT
	DECLARE	@databaseSize		INT
	DECLARE @creationTime		INT
	DECLARE	@options			INT
	DECLARE @options2			INT
	DECLARE @systemFlags		INT
	DECLARE @status				INT
	DECLARE @status2			BIGINT
	DECLARE @dbrecoveryOrder	INT
	DECLARE @dbowner			NVARCHAR(MAX)
	DECLARE @index			INT
	DECLARE @dbName			NVARCHAR(MAX)
	DECLARE @dbParameters	NVARCHAR(MAX)
	DECLARE @numberOfBackupStreams	INT
	DECLARE @numberOfTransactionLogStreams	INT
	DECLARE @allowMultipleDataRead INT
	DECLARE @disableAutoDiscovery INT
	DECLARE @discoverType			INT
	DECLARE @mssqlblockSize			INT
	DECLARE @mssqlbufferCount		INT
	DECLARE @mssqlmaxTransferSize	INT
	DECLARE @mssqldisableLogConsistencyCheck INT
	DECLARE @backupRules			INT
	DECLARE @SybaseDBInfo TABLE (
								databaseName NVARCHAR(MAX),
								databaseID INT,
								databaseSize INT,
								creationTime INT,
								options INT,
								options2 INT,
								systemFlags INT,
								status INT,
								status2 BIGINT,
								dbrecoveryOrder INT,
								dbowner NVARCHAR(MAX))
	DECLARE @MSSQLDBInfo TABLE (databaseName NVARCHAR(MAX),
								databaseID INT,
								discoverType INT
								)
	SET @applicationId = (SELECT appTypeId FROM APP_Application WHERE APP_Application.id = @subclientId)
	SET @runPostBackup = ISNULL((SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND attrName = 'sys: pre post option' AND modified = 0),0)
	--Gather Sybase properties
IF(@applicationId = 5 AND @propertyLevel >= 30)
	BEGIN
		SET @numberOfBackupStreams = (SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND attrName = 'Sybase Data backup streams' AND modified = 0)
		SET @numberOfTransactionLogStreams = (SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND attrName = 'Sybase Log backup streams' AND modified = 0)
		DECLARE SybaseDBCur CURSOR FOR (select attrName, attrval from APP_SubClientProp where attrtype = 116 AND componentNameId = @subclientId)
		OPEN SybaseDBCur
		FETCH SybaseDBCur INTO @dbName, @dbParameters
		SET @index = 0
		WHILE @@FETCH_STATUS = 0
		BEGIN
				select
					@databaseID = CASE WHEN Id = 1 THEN Data ELSE @databaseID END,
					@databaseSize = CASE WHEN Id = 2 THEN Data ELSE @databaseSize END,
					@creationTime = CASE WHEN Id = 3 THEN Data ELSE @creationTime END,
					@options = CASE WHEN Id = 4 THEN Data ELSE @options END,
					@options2 = CASE WHEN Id = 5 THEN Data ELSE @options2 END,
					@systemFlags = CASE WHEN Id = 6 THEN Data ELSE @systemFlags END,
					@status = CASE WHEN Id = 7 THEN Data ELSE @status END,
					@status2 = CASE WHEN Id = 8 THEN Data ELSE @status2 END,
					@dbrecoveryOrder = CASE WHEN Id = 9 THEN Data ELSE @dbrecoveryOrder END,
					@dbowner = CASE WHEN Id = 10 THEN Data ELSE @dbowner END
					FROM SplitString(@dbParameters,' ')
					SET @databaseSize = NULLIF(@databaseSize,'0')
					SET @options = NULLIF(@options,'0')
					SET @options2 = NULLIF(@options2,'0')
					SET @systemFlags = NULLIF(@systemFlags,'0')
					SET @dbrecoveryOrder = NULLIF(@dbrecoveryOrder,'0')
				INSERT	INTO @SybaseDBInfo VALUES(@dbName, @databaseID, @databaseSize, @creationTime, @options, @options2, @systemFlags, @status, @status2, @dbrecoveryOrder, @dbowner)
				SET @index = @index + 1
				FETCH SybaseDBCur INTO @dbName, @dbParameters
		END
		CLOSE SybaseDBCur
		DEALLOCATE SybaseDBCur
		--Construct output XML
		SET	@resultXML =
						(SELECT
							(SELECT	@runPostBackup AS '@runPostBackup',
									@numberOfBackupStreams AS '@numberOfBackupStreams',
									@numberOfTransactionLogStreams AS '@numberOfTransactionLogStreams',
								(SELECT databaseName AS '@databaseName',
									databaseID AS '@databaseId',
									databaseSize AS '@databaseSize',
									--creationTime AS '@creationTime',
									options AS '@options',
									options2 AS '@options2',
									systemFlags AS '@systemFlags',
									status AS '@status',
									status2 AS '@status2',
									dbrecoveryOrder AS '@dbRecoveryOrder',
									dbowner AS '@owner',
									(SELECT creationTime as '@time',
										55 AS '@_type_'
										FOR XML PATH('creationTime'), TYPE)
									FROM @SybaseDBInfo
								FOR XML PATH('sybaseDBInfo'),TYPE)
							FOR XML PATH('sybaseSubclientProp'), TYPE)
						FOR XML PATH('DBSubClientProp'), TYPE)
	END
	--Gather MSSQL properties
IF(@applicationId = 81 AND @propertyLevel >= 30)
	BEGIN
		SET @numberOfBackupStreams = (SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND attrName = 'mssql Data backup streams' AND modified = 0)
		SET @numberOfTransactionLogStreams = (SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND attrName = 'mssql Log backup streams' AND modified = 0)
		SET @allowMultipleDataRead = (SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND attrName = 'sys:UseMultipleStreamsWithinDrive' AND modified = 0)
		SET @disableAutoDiscovery = (SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND attrName = 'MSSQL Disable AutoDiscovery' AND modified = 0)
		SET @mssqlblockSize = (SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND attrName = 'MSSQL Tunable BlockSize' AND modified = 0)
		SET @mssqlbufferCount = (SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND attrName = 'MSSQL Tunable BufferCount' AND modified = 0)
		SET @mssqlmaxTransferSize = (SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND attrName = 'MSSQL Tunable Max TransferSize' AND modified = 0)
		SET @mssqldisableLogConsistencyCheck = (SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND attrName = 'MSSQL Disable Log Consistency' AND modified = 0)
		SET @backupRules = (SELECT attrVal FROM APP_SubclientProp WHERE componentNameId = @subclientId AND attrName = 'mssql Bkp Conversion' AND modified = 0)
		IF @backupRules NOT IN (1,3,5,7)
			SET @backupRules = 0
			DECLARE MSSQLDBCur CURSOR FOR (select attrName, attrval from APP_SubClientProp where attrtype = 118 AND componentNameId = @subclientId  AND modified = 0)
				OPEN MSSQLDBCur
					FETCH MSSQLDBCur INTO @dbName, @dbParameters
					SET @index = 0
					WHILE @@FETCH_STATUS = 0
					BEGIN
						select
							@databaseID = CASE WHEN Id = 1 THEN Data ELSE @databaseID END,
							@discoverType = CASE WHEN Id = 2 THEN Data ELSE @discoverType END
							FROM SplitString(@dbParameters,' ')
						INSERT	INTO @MSSQLDBInfo VALUES(@dbName, @databaseID, @discoverType)
						SET @index = @index + 1
						FETCH MSSQLDBCur INTO @dbName, @dbParameters
					END
				CLOSE MSSQLDBCur
			DEALLOCATE MSSQLDBCur
			SET	@resultXML =
								(SELECT
									(SELECT	@runPostBackup AS '@runPostBackup',
											@numberOfBackupStreams AS '@numberOfBackupStreams',
											@numberOfTransactionLogStreams AS '@numberOfTransactionLogStreams',
											@allowMultipleDataRead AS '@allowMultipleDataRead',
											@disableAutoDiscovery AS '@disableAutoDiscovery',
											@mssqlblockSize AS '@blockSize',
											@mssqlbufferCount AS '@bufferCount',
											@mssqlmaxTransferSize AS '@maxTransferSize',
											@mssqldisableLogConsistencyCheck AS '@disableLogConsistencyCheck',
											@backupRules AS '@backupRules',
											(SELECT databaseName AS '@databaseName',
												databaseID AS '@databaseId',
												discoverType AS '@discoverType'
												FROM @MSSQLDBInfo
												FOR XML PATH('mssqlDBInfo'),TYPE)
										FOR XML PATH('mssqlSubClientProp'), TYPE)
								FOR XML PATH('DBSubClientProp'), TYPE)
	END
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetSybaseSubclientProperties')
	delete from GxQscripts where name = 'APPGetSybaseSubclientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetSybaseSubclientProperties')
	delete from GXDBVersions where aliasname = 'APPGetSybaseSubclientProperties'
GO

insert into GXDBVersions values(2, 'APPGetSybaseSubclientProperties',  '00000000000000000000', 'APPGetSybaseSubclientProperties', '00000000000000000000')
GO

