

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetSubscriptionbasedAlerts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetSubscriptionbasedAlerts.sp,v $ $Id: APPGetSubscriptionbasedAlerts.sp,v 1.3.60.10 2019/09/12 21:47:13 vmishra Exp $";
--	+===================================================================+
--	| APPGetSubscriptionbasedAlerts - Get Subscriptionbased Alerts							|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetSubscriptionbasedAlerts')
BEGIN
	print '>>> Drop Stored Procedure: APPGetSubscriptionbasedAlerts <<<'
	drop procedure APPGetSubscriptionbasedAlerts
END
IF EXISTS (select * from GxQscripts where name='APPGetSubscriptionbasedAlerts')
	delete from GxQscripts where name = 'APPGetSubscriptionbasedAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetSubscriptionbasedAlerts')
	delete from GXDBVersions where aliasname = 'APPGetSubscriptionbasedAlerts'
GO
print '... Creating Procedure: APPGetSubscriptionbasedAlerts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetSubscriptionbasedAlerts
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @in_Xml XML ,
  @out_Xml XML OUTPUT
-----------------------------------------------------------
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
----------------------------------------------------------
DECLARE @errorCode INT
DECLARE @errorMessage VARCHAR(MAX)
----------------------------------------------------------
--- HERE IS WHERE WE WILL EXTRACT THE XML TO:          ---
----------------------------------------------------------
DECLARE @userId						integer = 0
DECLARE @localeId					integer = 0
DECLARE @userGUID					VARCHAR(64)
DECLARE @clientId					integer = 0
DECLARE @getAlertInfoList           integer = 0
DECLARE @getGlobalSubscriptionList	integer = 0
DECLARE @getLocalSubscriptionList	integer = 1
DECLARE @escalationLevel			integer = 1 -- For Web console
DECLARE	@entityType1				integer = 0
DECLARE	@entityId1					integer = 0
DECLARE	@entityType2				integer = 0
DECLARE	@entityId2					integer = 0
DECLARE	@entityType3				integer = 0
DECLARE	@entityId3					integer = 0
DECLARE	@entityType4				integer = 0
DECLARE	@entityId4					integer = 0
DECLARE	@entityType5				integer = 0
DECLARE	@entityId5					integer = 0
DECLARE @entityString				nvarchar(maX)=''
DECLARE @entity						xml
DECLARE @entityHierarchy			xml
DECLARE @SMSNotificationFlag		integer = 0
-----------------------------------------------
--- EXTRACT FROM THE XML                    ---
-----------------------------------------------
	SET @localeId = ISNULL (( SELECT ref.value('@localeId', 'INT')
						FROM @in_Xml.nodes ('CVGui_GetSubscriptionbasedAlertsReq/processinginstructioninfo/locale') R(ref)), 0)
	SET @userGUID = ISNULL (( SELECT ref.value('@userGUID', 'VARCHAR(64)')
                    FROM @in_Xml.nodes ('CVGui_GetSubscriptionbasedAlertsReq/processinginstructioninfo/user') R(ref)), null)
	if (@userGUID IS NOT NULL)
		SET @userId = ISNULL ((SELECT top 1 id FROM UMUsers WHERE userGuid = @userGUID), 0)
    SET @userId = ISNULL (( SELECT ref.value('@userId', 'INT')
                    FROM @in_Xml.nodes ('CVGui_GetSubscriptionbasedAlertsReq/processinginstructioninfo/user') R(ref)), @userId)
    SET @clientId = ISNULL (( SELECT ref.value('@clientId', 'INT')
                    FROM @in_Xml.nodes ('CVGui_GetSubscriptionbasedAlertsReq/client') R(ref)), 0)
    SET @getAlertInfoList = ISNULL (( SELECT ref.value('@getAlertInfoList', 'INT')
                    FROM @in_Xml.nodes ('CVGui_GetSubscriptionbasedAlertsReq') R(ref)), 0)
    SET @getGlobalSubscriptionList = ISNULL (( SELECT ref.value('@getGlobalSubscriptionList', 'INT')
                    FROM @in_Xml.nodes ('CVGui_GetSubscriptionbasedAlertsReq') R(ref)), 0)
    SET @getLocalSubscriptionList = ISNULL (( SELECT ref.value('@getLocalSubscriptionList', 'INT')
                    FROM @in_Xml.nodes ('CVGui_GetSubscriptionbasedAlertsReq') R(ref)), 1)
	SET @entity		= @in_Xml.query('CVGui_GetSubscriptionbasedAlertsReq/entity')
	-- Get SMS Notification Flag
	SET @SMSNotificationFlag = ISNULL((SELECT attrVal FROM UMUsersProp WHERE componentNameId = @userId AND modified = 0 AND attrName = 'SMS Alerts Enabled'),0)
	-- Convert entity node to CvEntities_GenericEntity
	SET @entityString = convert(nvarchar(max),@entity)
	SET @entityString = replace(@entityString,'<entity>','<CvEntities_GenericEntity>')
	SET @entityString = replace(@entityString,'</entity>','</CvEntities_GenericEntity>')
	SET @entityString = replace(@entityString,'<entity ','<CvEntities_GenericEntity ')
	SET @entity		  = @entityString
	SET @entityHierarchy = dbo.getEntityTypeHirearchyXMLFromGenericEntityXML(@entity)
	SELECT @entityType1 = IsNull(ref.value('@entityType1', 'int'),0),
		@entityId1 = IsNull(ref.value('@entityId1','int'),0),
		@entityType2 = IsNull(ref.value('@entityType2','int'),0),
		@entityId2 = IsNull(ref.value('@entityId2','int'),0),
		@entityType3 = IsNull(ref.value('@entityType3','int'),0),
		@entityId3 = IsNull(ref.value('@entityId3','int'),0),
		@entityType4 = IsNull(ref.value('@entityType4','int'),0),
		@entityId4 = IsNull(ref.value('@entityId4','int'),0),
		@entityType5 = IsNull(ref.value('@entityType5','int'),0),
		@entityId5 = IsNull(ref.value('@entityId5','int'),0)
		From @entityHierarchy.nodes('entityAssociated') R ( ref )
	if (@clientId<>0)
	begin
		SET @entityType1 = 3
		SET @entityId1 = @clientId
	end
	else if (@entityType1 = 3 AND @entityType2=0 AND @entityType3=0 AND @entityType4=0 AND @entityType5=0)
	begin
		set @clientId = @entityId1
	end
----Input
--SELECT	@localeId localeId
--		, @userGUID userGUID, @userId userId
--		, @clientId clientId
--		, @getAlertInfoList getAlertInfoList
--		, @getGlobalSubscriptionList getGlobalSubscriptionList
--		, @getLocalSubscriptionList getLocalSubscriptionList
DECLARE @alerInfotListXML XML
DECLARE @globalSubscriptionListXML XML
DECLARE @localSubscriptionListXML XML
declare @NTAlertSubScriptionsTmp table
(
   ntRuleId    integer ,
   userId      integer ,
   escalationLevel integer ,
   entityType1 				INT		DEFAULT 0,					--the 5 entity hierarchy on which association is done
	entityId1 					INT		DEFAULT 0,
	entityType2 				INT		DEFAULT 0,
	entityId2 					INT		DEFAULT 0,
	entityType3 				INT		DEFAULT 0,
	entityId3 					INT		DEFAULT 0,
	entityType4 				INT		DEFAULT 0,
	entityId4 					INT		DEFAULT 0,
	entityType5 				INT		DEFAULT 0,
	entityId5 					INT		DEFAULT 0,
    flags       integer
)
Insert into @NTAlertSubScriptionsTmp(ntRuleId,userId ,escalationLevel ,entityType1, entityId1,entityType2, entityId2,entityType3, entityId3,entityType4, entityId4,entityType5, entityId5, flags)
select ntRuleId,@userId,@escalationLevel,entityType1, entityId1,entityType2, entityId2,entityType3, entityId3,entityType4, entityId4,entityType5, entityId5, flags
from NTAlertSubScriptions with (nolock)
where userId = @userId AND escalationLevel = @escalationLevel
if object_id('tempdb.dbo.#alertList') is not null
BEGIN
    DROP TABLE #alertList
END
CREATE TABLE #alertList (NTnotificationId integer NOT NULL)
declare @planId int = 0
set @planId = dbo.AppGetPlanForUser(@userId)
DECLARE @constAttrType_Alert                INT = 262
DECLARE @constAttrName_Alert                NVARCHAR(32) = N'Alert'
-- Check via global param whether new security key is enabled or not. If not enabled, retain original behaviour. Else check for security
if exists(select 1 from Gxglobalparam where name='bEnableSecurityForSubscriptionAlerts' and value='true' and modified=0)
	OR @planId>0
begin
EXEC sec_getNonIdaObjectsForThisUser @userId, 64, 154, '#alertList'
	if (@planId>0)
	begin
		declare @AlertsForPlan table
		(
			alertId int
		)
		INSERT INTO @AlertsForPlan
SELECT  DISTINCT CONVERT (INT, RTRIM(LTRIM(SUBSTRING(attrName, LEN('Alert') + 1, 32))))
            FROM    App_PlanProp WITH (READUNCOMMITTED)
WHERE   attrName LIKE 'Alert' + '%' AND componentNameId = @planId
UNION   SELECT _ID FROM dbo.SplitIDString(dbo.AppPlanGetEntityValue(@planId, 'Alert', default))
		 Insert into #alertList
		 select distinct alertId from @AlertsForPlan
		 where alertId not in
		 (
			select NTnotificationId from #alertList
		 )
	end
end
else
begin
	-- Also include subscription based alerts which allow all users to subscribe
	Insert into #alertList
	select id from NTnotificationRule
where (NTnotificationRule.status & 128) <> 0
	-- Ensure alerts arent deleted.
and NTNotificationRule.revision = 1 and (NTNotificationRule.status& 2 )=0
end
-- Dont include hidden alerts in response to caller
DELETE alertList FROM #alertList alertList
INNER JOIN NTnotificationRule ON
alertList.NTnotificationId = NTnotificationRule.Id
AND ( NTnotificationRule.status & 262144 )>0
-- Check whether this client is a personal work station
IF @getLocalSubscriptionList = 1 AND @userId <> 0 AND  @clientId <> 0 And exists(
select  1 from App_client where (STATUS & 0x1000)>0
	and id=@clientId)
begin
	-- For global alert subscriptions list, user needs to make a choice explicitly. Else it depends on this local subscription.
	-- For local alert subscriptions list, figure out all subscription based alerts for which user hasnt made any choice yet on this client
	-- For these alerts, if any global preference has been made then preference would be given to that
	-- Else we check whether this client is part of that alerts entity list.
	-- For all such alerts, add them to NTAlertSubScriptionsTmp with flag as selected. Else they are added as not selected.
	-- So we iterate over all appropriate subscription based alerts and find them which have this client selected.
	IF ( CURSOR_STATUS('global', 'SubscriptionAlertsCursorForClient') >= 0   OR CURSOR_STATUS('local', 'SubscriptionAlertsCursorForClient') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE SubscriptionAlertsCursorForClient
	IF ( CURSOR_STATUS('global','SubscriptionAlertsCursorForClient') = -1     OR CURSOR_STATUS('local','SubscriptionAlertsCursorForClient') = -1 )
		DEALLOCATE SubscriptionAlertsCursorForClient
	declare @subscriptionAlertsForClient table
	(
		ntRuleId int,
		flag int
	)
	declare @subscripNTRuleId int
	declare @subscripNTRuleXmlEntityList xml
	DECLARE SubscriptionAlertsCursorForClient CURSOR STATIC FOR
	SELECT  id, xmlEntityList
		FROM NTNotificationRule with (nolock)
		inner join #alertList alertList on
		NTNotificationRule.id=alertList.NTnotificationId
where NTnotificationRule.status & 128 <> 0
		AND ((NTnotificationRule.status & 1) = 0) --_NT_STATUS_DISABLED.
	OPEN SubscriptionAlertsCursorForClient
	FETCH NEXT FROM SubscriptionAlertsCursorForClient INTO @subscripNTRuleId,@subscripNTRuleXmlEntityList
	WHILE @@FETCH_STATUS = 0
	BEGIN
		declare @genericEntity nvarchar(max)
		declare @resultMatch int = 0
		set @genericEntity = '<CvEntities_GenericEntity clientId="'+convert(nvarchar(10),@clientId)+'"/>'
		--declare @entityCheckResult table
		--(
		--	result int
		--)
		set @subscripNTRuleXmlEntityList = @subscripNTRuleXmlEntityList.query('CVGui_CommCellTreeNode/associations')
		set @subscripNTRuleXmlEntityList = convert(xml,replace(replace(convert(nvarchar(max),@subscripNTRuleXmlEntityList),
			'<associations','<entity'),'</associations>','</entity>'))
		set @subscripNTRuleXmlEntityList = (
			select @subscripNTRuleXmlEntityList.query('.')
			for xml path(''),root('App_Associations')
			)
		--Insert into @entityCheckResult
		--exec AppCheckEntityIncluded @genericEntity,@subscripNTRuleXmlEntityList, @subscripNTRuleId
		select @resultMatch = dbo.IsEntityInAssocList(@genericEntity,@subscripNTRuleXmlEntityList, @subscripNTRuleId)
		if @resultMatch=1
		begin
			Insert into @subscriptionAlertsForClient
			select @subscripNTRuleId,1
		end
		else
		begin
			Insert into @subscriptionAlertsForClient
			select @subscripNTRuleId,0
		end
		FETCH NEXT FROM SubscriptionAlertsCursorForClient INTO @subscripNTRuleId,@subscripNTRuleXmlEntityList
	end
	Close SubscriptionAlertsCursorForClient
	deallocate SubscriptionAlertsCursorForClient
	Insert into @NTAlertSubScriptionsTmp(ntRuleId,userId ,escalationLevel ,entityType1, entityId1,flags)
	select NTRule.ntRuleId,@userId,@escalationLevel,3, @clientId, NTRule.flag
	FROM @subscriptionAlertsForClient NTRule
	left join NTAlertSubScriptions
	on NTRule.ntRuleId = NTAlertSubScriptions.ntRuleId and
	NTAlertSubScriptions.userId = @userId AND (entityId1 = @clientId Or entityId1 = 0) AND escalationLevel = @escalationLevel AND entityType1=3
	WHERE NTAlertSubScriptions.ntRuleId is null
end
 --Now remove entries from @NTAlertSubScriptionsTmp which are not in #alertList
 delete from @NTAlertSubScriptionsTmp
 where ntRuleId not in
 (
	select AlertList.NTNotificationId from #alertList AlertList
 )
	IF @getAlertInfoList = 1 AND @userId <> 0
	BEGIN
		SET @alerInfotListXML =
		(
			SELECT description as '@description',
				(SELECT id as '@alertId', notificationName as '@alertName' FOR XML PATH('alert'), TYPE)
			FROM NTnotificationRule
			inner join #alertList AlertList
			on NTnotificationRule.id=AlertList.NTnotificationId
WHERE status & 128 <> 0
			AND ((status & 1) = 0) --_NT_STATUS_DISABLED. MR 97496 Dont show disabled alerts in WebConsole.
			-- Ensure appropriate alerts are returned for specific entityType.
			AND dbo.NTIsAlertTypeSupportedForEntity(NTnotificationRule.alertTypeId,@entityType1 )=1
			FOR XML PATH ('alerInfotList'), TYPE
		)
	END
	IF @getGlobalSubscriptionList = 1 AND @userId <> 0
	BEGIN
		SET @globalSubscriptionListXML =
		(
			SELECT (flags & 1) AS '@enabled',
				  (SELECT ntRuleId as '@alertId' FOR XML PATH('alert'), TYPE)
			FROM @NTAlertSubScriptionsTmp
			WHERE userId = @userId AND entityId1 = 0 AND escalationLevel = @escalationLevel
			FOR XML PATH ('globalSubscriptionList'), TYPE
		)
	END
	IF @getLocalSubscriptionList = 1 AND @userId <> 0 AND  @entityId1 <> 0
	BEGIN
		SET @localSubscriptionListXML =
		(
			SELECT (flags & 1) AS '@enabled',
				  (SELECT ntRuleId as '@alertId' FOR XML PATH('alert'), TYPE)
			FROM @NTAlertSubScriptionsTmp NTAlertSubScriptionsTmp
			INNER JOIN NTNotificationRule on NTAlertSubScriptionsTmp.ntRuleId = NTNotificationRule.id
			-- Ensure appropriate alerts are returned for specific entityType.
			AND dbo.NTIsAlertTypeSupportedForEntity(NTnotificationRule.alertTypeId,@entityType1 )=1
			WHERE userId = @userId AND escalationLevel = @escalationLevel
			AND entityId1 = @entityId1 AND entityType1 = @entityType1
			AND entityId2 = @entityId2 AND entityType2 = @entityType2
			AND entityId3 = @entityId3 AND entityType3 = @entityType3
			AND entityId4 = @entityId4 AND entityType4 = @entityType4
			AND entityId5 = @entityId5 AND entityType5 = @entityType5
			FOR XML PATH ('localSubscriptionList'), TYPE
		)
	END
	SET @out_Xml = (
		SELECT @errorCode AS '@errorCode', @errorMessage AS '@errorMessage', @SMSNotificationFlag AS '@IsSMSNotificationEnabled'
			, @alerInfotListXML, @globalSubscriptionListXML, @localSubscriptionListXML
		FOR XML PATH('App_GetSubscriptionbasedAlertsResp')
	)
DROP TABLE #alertList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetSubscriptionbasedAlerts')
	delete from GxQscripts where name = 'APPGetSubscriptionbasedAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetSubscriptionbasedAlerts')
	delete from GXDBVersions where aliasname = 'APPGetSubscriptionbasedAlerts'
GO

insert into GXDBVersions values(2, 'APPGetSubscriptionbasedAlerts',  '00010003006000100000', 'APPGetSubscriptionbasedAlerts', '00010003006000100000')
GO

