

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetSubclientPropertiesWithOutputParam.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetSubclientPropertiesWithOutputParam.sp,v $ $Id: APPGetSubclientPropertiesWithOutputParam.sp,v 1.1.2.39 2020/09/24 14:23:40 sravanan Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetSubclientPropertiesWithOutputParam')
BEGIN
	print '>>> Drop Stored Procedure: APPGetSubclientPropertiesWithOutputParam <<<'
	drop procedure APPGetSubclientPropertiesWithOutputParam
END
IF EXISTS (select * from GxQscripts where name='APPGetSubclientPropertiesWithOutputParam')
	delete from GxQscripts where name = 'APPGetSubclientPropertiesWithOutputParam'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetSubclientPropertiesWithOutputParam')
	delete from GXDBVersions where aliasname = 'APPGetSubclientPropertiesWithOutputParam'
GO
print '... Creating Procedure: APPGetSubclientPropertiesWithOutputParam'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetSubclientPropertiesWithOutputParam
  @xmlInput XML,	
  @userId INTEGER,
  @localeId INTEGER,
  @mode INTEGER,
  @xmlOutput XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#SubclientEntites') IS NOT NULL
	DROP TABLE #SubclientEntites
CREATE TABLE #SubclientEntites (
									subclientId				INT PRIMARY KEY,
									subclientName			NVARCHAR(256),
									backupsetId				INT,
									backupsetName			NVARCHAR(256),
									instanceId				INT,
									instanceName			NVARCHAR(1024),
									applicationId			INT,
									appName					NVARCHAR(256),
									clientId				INT,
									clientName				NVARCHAR(510),
									clientDisplayName		NVARCHAR(510),
                                    proxyClientId           INT NULL,
									proxyClientName			NVARCHAR(1024) NULL,
									planId					INT NULL,
                                    planType				INT NULL,
                                    planSubType				INT NULL,
									planName				NVARCHAR(1024) NULL,
									planParentEntityId		INT NULL,
									planParentEntityType	INT NULL,
									planParentXMLAttr       XML NULL,
									dcPlanId				INT NULL,
                                    dcPlanType				INT NULL,
                                    dcPlanSubType			INT NULL,
									dcPlanName				NVARCHAR(1024) NULL,
									isContentFromPlan		INT NULL,
									subclientStatus			INT NULL,
									commonProperties		XML,
									FsIDAProperties			XML,
									SybaseProperties		XML,
									nfsSubclientProp		XML,
									SLAProperties			XML,
									advancedIndexingProp	XML,
									errorCode				INT,
									errorString				NVARCHAR(MAX),
									guid				uniqueidentifier,
									regionId int,
									regionName nvarchar(127),
									regionDisplayName nvarchar(127),
									isEnableLMAnalytics				INT NULL DEFAULT NULL,
									analyticsMonitoringPolicyId		INT NULL DEFAULT NULL,
									useLocalArchivalRules		INT NULL DEFAULT NULL,
									replicationGroupXML		XML DEFAULT NULL
								)
IF OBJECT_ID('tempdb.dbo.#SubclientEntitesOfAssociatedEntites') IS NOT NULL
	DROP TABLE #SubclientEntitesOfAssociatedEntites
CREATE TABLE #SubclientEntitesOfAssociatedEntites (
									subclientId				INT,
									subclientName			NVARCHAR(256),
									backupsetId				INT,
									backupsetName			NVARCHAR(256),
									instanceId				INT,
									instanceName			NVARCHAR(1024),
									applicationId			INT,
									appName					NVARCHAR(256),
									clientId				INT,
									clientName				NVARCHAR(510),
									clientDisplayName		NVARCHAR(510),
									errorCode				INT,
									errorString				NVARCHAR(MAX),
									guid uniqueidentifier)
DECLARE @associationResponse TABLE(
									xmlval XML
								)
DECLARE @ErrorTable TABLE ( clientid INT,
							   clientName NVARCHAR(510),
							   applicationId int,
							   appName NVARCHAR(256),
							   instanceId int,
							   instanceName			NVARCHAR(1024),
							   backupsetId int,
							   backupsetName			NVARCHAR(256),
							   subclientId int,
							   subclientName nvarchar(256),
							   errorCode INT,
							   errorString NVARCHAR(MAX))
IF OBJECT_ID('tempdb.dbo.#SecurityTbl') IS NOT NULL
	DROP TABLE #SecurityTbl
CREATE TABLE #SecurityTbl (
	id				INT IDENTITY(1,1),
	returnedUserId	INT,
	nodeCapability	BIGINT,
	childCapability	BIGINT)
CREATE UNIQUE CLUSTERED INDEX SecurityTbl_idx ON #SecurityTbl (id DESC)
DECLARE @subClientName				NVARCHAR(256)
DECLARE @subclientId				INT
DECLARE @propertyLevel				INT
DECLARE @includeBackupInfo			INT
DECLARE @xmlCommonProperties		XML
DECLARE @xmlFsIDAProperties			XML
DECLARE @xmlDbAgentProperties		XML
DECLARE @xmlNFSProperties			XML
DECLARE @xmlAdvancedIndexingProperties			XML
DECLARE @associations				XML
DECLARE @errorCode					INT
DECLARE @errorString				NVARCHAR(MAX)
DECLARE @backupsetId				INT
DECLARE @instancetId				INT
DECLARE @appTypeId					INT
DECLARE @clientId					INT
DECLARE @xmlResultError				XML
DECLARE @includeVMPseudoSubclient   INT
DECLARE @xmlSLAProperties			XML
DECLARE @withBackup					INT = 0
DECLARE @includeDeleted			INT = 0
SET @propertyLevel = 30
SET @includeBackupInfo = 0
DECLARE @errorXML xml
DECLARE @_getArchiverSubclients INT
DECLARE @filterVendorType			INT
DECLARE @excludeVendorType			INT
IF 1 = (@xmlInput.exist('(//./filterOptions/@propertyLevel)[1]'))
BEGIN
	SET @propertyLevel = @xmlInput.value('(//./filterOptions/@propertyLevel)[1]','INT')
END
IF 1 = (@xmlInput.exist('(//./extendedFilter/@includeBackupInfo)[1]'))
BEGIN
	SET @includeBackupInfo = @xmlInput.value('(//./extendedFilter/@includeBackupInfo)[1]','INT')
END
IF 1 = (@xmlInput.exist('(//./extendedFilter/@withBackup)[1]'))
BEGIN
	SET @withBackup = @xmlInput.value('(//./extendedFilter/@withBackup)[1]','INT')
END
IF 1 = (@xmlInput.exist('(//./association/entity/flags/@deleted)[1]'))
BEGIN
	SET @includeDeleted = @xmlInput.value('(//./association/entity/flags/@deleted)[1]','INT')
END
IF 1 = (@xmlInput.exist('(//./filterOptions/@getArchiverClients)[1]'))
BEGIN
	SET @_getArchiverSubclients = @xmlInput.value('(//./filterOptions/@getArchiverClients)[1]','INT')
END
IF 1 = (@xmlInput.exist('(//./association/entity/@subclientName)[1]')) AND 0 = (@xmlInput.exist('(//./association/entity/@subclientId)[1]'))
BEGIN
SET @errorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (1774 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId)
		SET	@xmlResultError = (SELECT
(SELECT (1774 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AS '@errorCode',
										 @errorString AS '@errorString'
									FOR XML PATH('errors'), TYPE)
								FOR XML PATH(''), ROOT('App_GetSubClientPropertiesResponse'))
		SELECT @xmlResultError
		RETURN
END
SET @includeVMPseudoSubclient = ISNULL((SELECT  ref.value('@includeVMPseudoSubclients', 'INT')
                        FROM    @xmlInput.nodes('App_GetSubClientPropertiesRequest/extendedFilter') R ( ref )),1)
SET @filterVendorType = ISNULL((SELECT  ref.value('@filterVendorType', 'INT')
                        FROM    @xmlInput.nodes('App_GetSubClientPropertiesRequest/extendedFilter') R ( ref )),-1)
SET @excludeVendorType = ISNULL((SELECT  ref.value('@excludeVendorType', 'INT')
                        FROM    @xmlInput.nodes('App_GetSubClientPropertiesRequest/extendedFilter') R ( ref )),-1)
--0x4888034 means filter out subclient having any one of bits:
--CV_STATUS_DELETED,CV_STATUS_DUMMY,CV_STATUS_HIDDEN,CV_STATUS_EDC_DISCOVERED,CV_STATUS_NEEDS_MORE_CONFIG,CV_STATUS_MINING,CV_STATUS_REFERENCE_COPY
DECLARE @inSubclientId INT = @xmlInput.value('(//./association/entity/@subclientId)[1]','INT')
		--User requested properties of a set of associations. Expand those associations into associated entities.
		IF (SELECT @xmlInput.value('(//./association/entity/@subclientId)[1]','INT')) <> '' AND (SELECT @xmlInput.value('count(/App_GetSubClientPropertiesRequest/association/entity)', 'int')) = 1
		BEGIN
IF @mode = 4
			BEGIN
					SELECT @backupsetId = backupSet,
							@instancetId = instance,
							@appTypeId = appTypeId,
							@clientId = clientId
					FROM App_Application WITH(NOLOCK) WHERE id = @inSubclientId
					IF(@backupsetId IS NULL OR @instancetId IS NULL OR @appTypeId IS NULL OR @clientId IS NULL)
					BEGIN
SET @errorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (1774 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId)
						SET	@xmlResultError = (SELECT
(SELECT (1774 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AS '@errorCode',
															@errorString AS '@errorString'
													FOR XML PATH('errors'), TYPE)
												FOR XML PATH(''), ROOT('App_GetSubClientPropertiesResponse'))
						SELECT @xmlResultError
						RETURN
					END
					INSERT INTO #SecurityTbl EXEC	dbo.sec_iDaNodeAccess @userId, 2, @clientId, @appTypeId, @instancetId, @backupsetId, @inSubclientId
					IF NOT EXISTS (select returnedUserId FROM #SecurityTbl WHERE returnedUserId = @userId )
					BEGIN
SET @errorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId)
						SET @errorString = REPLACE(@errorString, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @userId))
						SET @errorString = REPLACE(@errorString, '^2%s', dbo.fn_EvFormatEventMsgText(0,@localeId, (Select tokenId from UMCapability WITH (NOLOCK) where id = 31), 0,2))
						SET @errorString = REPLACE(@errorString, '^3%s', 'subclient')
						SET	@xmlResultError = (SELECT
(SELECT (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AS '@errorCode',
															@errorString AS '@errorString'
													FOR XML PATH('errors'), TYPE)
												FOR XML PATH(''), ROOT('App_GetSubClientPropertiesResponse'))
						SELECT @xmlResultError
						RETURN
					END
			END
			INSERT INTO #SubclientEntites(clientId, clientName, clientDisplayName, applicationId, appName, instanceId, instanceName, backupsetId, backupsetName, subclientId, subclientName, guid, regionId, regionName, regionDisplayName, subclientStatus)
			(SELECT client.id,
					client.name,
					client.displayName,
					ida.type,
					ida.displayName,
					instance.id,
					instance.name,
					backupset.id,
					backupset.name,
					Subclient.id,
					Subclient.subclientName,
					Subclient.GUID,
					r.id,
					r.name,
					r.displayName,
					Subclient.subclientStatus
					FROM APP_Application Subclient WITH(NOLOCK)
					INNER JOIN APP_Client client WITH(NOLOCK) ON Subclient.clientId = client.id
					INNER JOIN App_iDatype AS ida WITH(NOLOCK) ON subclient.appTypeId = ida.type
					INNER JOIN APP_BackupSetName AS backupset WITH(NOLOCK) ON subclient.backupSet = backupSet.id
					INNER JOIN APP_InstanceName AS instance WITH(NOLOCK) ON subclient.instance = instance.id
LEFT JOIN APP_AdvanceSettings a ON entityType=7 and keyName='Region Id' and enabled=1 and deleted=0 and a.entityId=@inSubclientId AND a.sourceId=0
					LEFT join App_Region r on cast(a.value as varchar(20)) = cast(r.id as varchar(20))
					WHERE Subclient.id = @inSubclientId
			)
		END
		ELSE
		BEGIN
			SET @associations = (	SELECT	7 '@expandLevel',
									(SELECT
										(SELECT @userId '@userId'
											FOR XML PATH('user'), TYPE)
									FOR XML PATH('processinginstructioninfo'), TYPE),
									(SELECT @xmlInput.query('App_GetSubClientPropertiesRequest/association/entity'))
								FOR XML PATH('App_GetAssociatedEntities'))
			INSERT INTO @associationResponse
				EXEC dbo.GetAssociatedEntities @associations
			INSERT INTO #SubclientEntitesOfAssociatedEntites(clientId, clientName, clientDisplayName, applicationId, appName, instanceId, instanceName, backupsetId, backupsetName, subclientId, subclientName, errorCode, errorString, guid)
					SELECT  resp.col.value('@clientId', 'INT'),
						resp.col.value('@clientName', 'NVARCHAR(510)'),
						resp.col.value('@displayName', 'NVARCHAR(510)'),
						resp.col.value('@applicationId', 'INT'),
						resp.col.value('@appName', 'NVARCHAR(256)'),
						resp.col.value('@instanceId', 'INT'),
						resp.col.value('@instanceName', 'NVARCHAR(1024)'),
						resp.col.value('@backupsetId', 'INT'),
						resp.col.value('@backupsetName', 'NVARCHAR(256)'),
						resp.col.value('@subclientId', 'INT'),
						resp.col.value('@subclientName', 'NVARCHAR(256)'),
						s.ref.value('@errorCode', 'INT'),
						s.ref.value('@errorString', 'NVARCHAR(MAX)'),
						resp.col.value('@subclientGUID', 'NVARCHAR(256)')
					FROM @associationResponse AS response
					OUTER APPLY response.xmlval.nodes ('App_GenericResponse/response') as S(ref)
					OUTER APPLY ref.nodes('entity') resp(col)
					WHERE response.xmlval.exist('(/App_GenericResponse/response/entity/@subclientId)') = 1
					INSERT INTO @ErrorTable
					SELECT clientId, clientName, applicationId,appName, instanceId, instanceName, backupsetId, backupsetName, subclientId, subclientName, errorCode, errorString FROM #SubclientEntitesOfAssociatedEntites WHERE errorCode <> 0
					INSERT INTO #SubclientEntites(clientId, clientName, clientDisplayName, applicationId, appName, instanceId, instanceName, backupsetId, backupsetName, subclientId, subclientName, errorCode, errorString, guid)
					SELECT clientId, clientName, clientDisplayName, applicationId,appName, instanceId, instanceName, backupsetId, backupsetName, subclientId, subclientName, errorCode, errorString, guid
					  FROM #SubclientEntitesOfAssociatedEntites WHERE errorCode =0 OR errorCode is null
		END
	IF (( @inSubclientId IS NULL) OR ( @inSubclientId <= 0))
	BEGIN
		DELETE entities
		FROM #SubclientEntites entities
		INNER JOIN APP_Application subclient WITH (NOLOCK) ON subclient.id = entities.subclientID
		AND (subclient.subclientStatus & 0x4888034 != 0
			AND (@includeDeleted = 0
					OR (@includeDeleted = 1
AND subclient.subclientStatus & 0x00004 <> 0x00004)))
		OR entities.subclientId IS NULL
	END
	-- This filter suggest that we don't have to include PseudoClients of VM which gets created when backed up by Indexing V2
	--  this is important as one of the adminconsole request ask for all subclients of apptype 106 and doesn't want such subclients.
    -- MR - 193280
	IF (@includeVMPseudoSubclient=0)
	BEGIN
		DELETE entities
		FROM #SubclientEntites entities
		INNER JOIN APP_InstanceProp AIP WITH (NOLOCK) ON
			AIP.componentNameId = entities.instanceId AND AIP.attrName='Discovered VM Instance' AND AIP.modified=0 	-- CV_PROP_VS_DICOVEREDVM_INSTANCE
		INNER JOIN APP_InstanceName AIN
ON AIN.id=entities.instanceId AND AIN.status=0x200000
	END
	--This filter will be used to ONLY INCLUDE subcients which are associated to given vendor Type
	if(@filterVendorType <> -1)
	BEGIN
		DECLARE @filterAppTypeStr nvarchar(10) = ''
		SET @filterAppTypeStr = CAST(dbo.MapVSVendorId(@filterVendorType, -1) as nvarchar(10))	--Reverse map vendorId to appType
		--Delete all VSA subclients which are not associated to resultant appType for vendor
		DELETE A
		FROM #SubclientEntites A
		INNER JOIN APP_InstanceProp AIP WITH (NOLOCK) ON AIP.componentNameId = A.instanceId AND AIP.attrName='Virtual Server Instance Type' AND AIP.modified=0
		WHERE AIP.attrVal <> @filterAppTypeStr
	END
	--This filter will EXCLUDE ALL subcients which are associated to provided vendor Type
	if(@excludeVendorType <> -1)
	BEGIN
		DECLARE @excludeAppTypeStr nvarchar(10) = ''
		SET @excludeAppTypeStr = CAST(dbo.MapVSVendorId(@excludeVendorType, -1) as nvarchar)	--Reverse map vendorId to appType
		--Delete all VSA subclients which are not associated to resultant appType for vendor
		DELETE A
		FROM #SubclientEntites A
		INNER JOIN APP_InstanceProp AIP WITH (NOLOCK) ON AIP.componentNameId = A.instanceId AND AIP.attrName='Virtual Server Instance Type' AND AIP.modified=0
		WHERE AIP.attrVal= @excludeAppTypeStr
	END
	-- When calling from archiver solution, return only one-pass subclients. Do not return FS subclients.
	IF (@_getArchiverSubclients = 1)
	BEGIN
		-- Optimized way to do would be to avoid Inserting these entries into the table in the first place.
		-- But since that Insert is happening from Get Associated Entities which is a generic code, and this flag
		-- is coming only when querying for a single client's subclients, which is less, let us do a Delete on the table now.
		IF OBJECT_ID('tempdb.dbo.#onePassAndArchiveSubclients') IS NOT NULL
			DROP TABLE #onePassAndArchiveSubclients
		CREATE TABLE #onePassAndArchiveSubclients
		(
			subclientId INT PRIMARY KEY
		)
		INSERT INTO #onePassAndArchiveSubclients
			SELECT SP.componentNameId
			FROM APP_SubclientProp SP (NOLOCK)
				INNER JOIN #SubclientEntites entities
					ON entities.subclientId = SP.componentNameId
					AND SP.attrName = 'Turbo Mode Enable Stubbing'
					AND SP.cs_attrName = CHECKSUM(N'Turbo Mode Enable Stubbing')
					AND SP.attrVal = '1'
					AND SP.modified = 0
			UNION
			SELECT A.id
			FROM APP_Application A (NOLOCK)
				INNER JOIN #SubclientEntites entities
					ON A.id = entities.subclientId
				INNER JOIN APP_BackupsetProp BP(NOLOCK)
					ON BP.componentNameId = A.backupset
					AND BP.attrName = 'Is Archiving Enabled'
                    AND BP.attrVal = '1'
                    AND BP.modified = 0
			UNION
			SELECT SCP_ASP.componentNameId
			FROM APP_SubclientProp SCP_ASP WITH (NOLOCK)
				INNER JOIN #SubclientEntites entities
					ON entities.subclientId = SCP_ASP.componentNameId
AND SCP_ASP.attrName = N'Associated subclient Policy'
AND SCP_ASP.cs_attrName = CHECKSUM(N'Associated subclient Policy')
					AND SCP_ASP.attrVal <> '0'
					AND SCP_ASP.modified = 0
				INNER JOIN APP_SubclientProp SP
              				ON CAST(SCP_ASP.attrVal AS INT) = SP.componentNameId
AND SP.attrName = N'Turbo Mode Enable Stubbing'
AND SP.cs_attrName = CHECKSUM(N'Turbo Mode Enable Stubbing')
              				AND SP.attrVal = '1'
              				AND SP.modified = 0
				LEFT JOIN APP_SubclientProp SCP_PLAN WITH (NOLOCK)
					ON entities.subclientId = SCP_PLAN.componentNameId
AND SCP_PLAN.attrName = 'Associated Plan'
AND SCP_PLAN.cs_attrName = CHECKSUM(N'Associated Plan')
					AND SCP_PLAN.attrVal <> '0'
					AND SCP_PLAN.modified = 0
			WHERE SCP_PLAN.componentNameId IS NULL
		DELETE entities
		FROM #SubclientEntites entities
			LEFT OUTER JOIN #onePassAndArchiveSubclients validSC
				ON entities.subclientId = validSC.subclientId
		WHERE
			validSC.subclientId IS NULL
	END
	--MR 194974: Sharepoint databases backupset has default subclient with hidden flag.
	--Admin console need to show empty list insead of error. So remove following error message.
	/*
	IF NOT EXISTS(SELECT subclientId FROM #SubclientEntites ) AND NOT EXISTS(SELECT TOP 1 1 FROM @ErrorTable)
	BEGIN
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
DECLARE @retval int = (3287 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		DECLARE @xmlResultErrorInValid XML
		SET	@xmlResultErrorInValid =
										(SELECT
											(SELECT
												@retval AS '@errorCode',
												@errorString AS '@errorString'
											FOR XML PATH('errors'), TYPE)
										FOR XML PATH(''), ROOT('App_GetSubClientPropertiesResponse'))
		SELECT @xmlResultErrorInValid
		RETURN
	END*/
-- EssententialProperties
IF @propertyLevel >= 5
BEGIN
	UPDATE SCL
	SET SCL.proxyClientId=CAST(AIP.attrVal AS XML).value(('(/App_MemberServers/memberServers/client/@clientId)[1]'), 'INT'),
	SCL.proxyClientName=CAST(AIP.attrVal AS XML).value(('(/App_MemberServers/memberServers/client/@clientName)[1]'), 'NVARCHAR(1024)')
	FROM #SubclientEntites SCL
	INNER JOIN APP_InstanceProp AIP WITH(NOLOCK) ON AIP.componentNameId=SCL.instanceId AND AIP.attrName = 'Vs Member Servers' AND AIP.modified=0
	UPDATE SCL
		SET SCL.planId=AP.id,
			SCL.planType=AP.type,
			SCL.planSubType=AP.subType,
			SCL.planName=AP.name
	FROM #SubclientEntites SCL
		INNER JOIN APP_SubClientProp ACP WITH(NOLOCK) ON
			ACP.componentNameId=SCL.subclientId
AND ACP.cs_attrName = CHECKSUM(N'Associated Plan')
AND ACP.attrName = 'Associated Plan'
			AND ACP.modified=0
		INNER JOIN App_Plan AP ON
			AP.id = CAST(ACP.attrVal AS INT)
AND ((AP.flag & 0x00004) = 0)
AND ((AP.flag & 0x40000000) = 0)
		UPDATE SCL
		SET SCL.dcPlanId=AP.id,
			SCL.dcPlanType=AP.type,
			SCL.dcPlanSubType=AP.subType,
			SCL.dcPlanName=AP.name
		FROM #SubclientEntites SCL
		INNER JOIN APP_SubClientProp ACP WITH(NOLOCK) ON
			ACP.componentNameId=SCL.subclientId
AND ACP.cs_attrName = CHECKSUM(N'Associated DC Plan')
AND ACP.attrName = 'Associated DC Plan'
			AND ACP.modified=0
		INNER JOIN App_Plan AP ON
			AP.id = CAST(ACP.attrVal AS INT)
AND ((AP.flag & 0x00004) = 0)
AND ((AP.flag & 0x40000000) = 0)
	UPDATE	SCL
	SET		SCL.subclientStatus = A.subclientStatus
	FROM	#SubclientEntites SCL
	INNER JOIN	APP_Application A
		ON	SCL.subclientId = A.id
			AND SCL.subclientStatus IS NULL
	UPDATE SCL
	SET SCL.replicationGroupXML = (SELECT REP.id AS '@replicationGroupId', REP.name AS '@replicationGroupName'
									FOR XML PATH('replicationGroup'))
	FROM #SubclientEntites SCL
JOIN App_SubclientProp SUB WITH(NOLOCK) ON SUB.componentNameId = SCL.subclientId AND SUB.attrName = 'Associated Plan'
AND SUB.modified = 0 AND SUB.cs_attrName=CHECKSUM(N'Associated Plan')
JOIN App_replicationGroupProp REPPROP ON SUB.attrVal = REPPROP.attrVal AND REPPROP.attrName = 'Associated Plan'
	JOIN App_ReplicationGroup REP ON REP.id = REPPROP.componentNameId
END
IF @propertyLevel >= 20
BEGIN
	UPDATE SCL
	SET SCL.isContentFromPlan=1
	FROM #SubclientEntites SCL
	INNER JOIN APP_BackupSetProp ABP
ON	ABP.componentNameId=SCL.backupsetId AND ABP.attrName='Associated subclient Policy' AND ABP.modified=0
WHERE SCL.planId>0 AND SCL.planSubType IN (50331655, 33554437)
				AND ABP.attrVal IN (
dbo.AppPlanGetEntityValueV2(SCL.planId, 'Subclient policy 2', default),
dbo.AppPlanGetEntityValueV2(SCL.planId, 'Subclient policy 3', default),
dbo.AppPlanGetEntityValueV2(SCL.planId, 'Subclient policy 4', default)
								   )
END
IF @propertyLevel >= 30
BEGIN
	UPDATE SCL
	SET SCL.planParentEntityType=ACP1.attrVal,
    SCL.planParentEntityId=ACP2.attrVal
	FROM #SubclientEntites SCL
	INNER JOIN APP_SubClientProp ACP1 WITH(NOLOCK)
ON ACP1.componentNameId=SCL.subclientId AND ACP1.attrName = 'Associated Plan Parent EntityType' AND ACP1.modified=0 AND ACP1.cs_attrName=CHECKSUM(N'Associated Plan Parent EntityType')
	INNER JOIN APP_SubClientProp ACP2 WITH(NOLOCK)
ON ACP2.componentNameId=SCL.subclientId AND ACP2.attrName = 'Associated Plan Parent EntityId' AND ACP2.modified=0 AND ACP2.cs_attrName=CHECKSUM(N'Associated Plan Parent EntityId')
	UPDATE SCL
	SET SCL.planParentXMLAttr=
(CASE WHEN SCL.planParentEntityType=6 THEN
(SELECT 6 AS '@_type_', SCL.backupsetName AS '@backupsetName', SCL.backupsetId AS '@backupsetId',SCL.instanceName AS '@instanceName', SCL.instanceId AS '@instanceId',SCL.clientId AS '@clientId', SCL.clientDisplayName AS '@displayName'  FOR XML PATH ('planParentEntity'),TYPE)
WHEN SCL.planParentEntityType=5 THEN
(SELECT  5 AS '@_type_', SCL.instanceName AS '@instanceName', SCL.instanceId AS '@instanceId', SCL.clientId AS '@clientId', SCL.clientDisplayName AS '@displayName' FOR XML PATH ('planParentEntity'),TYPE)
WHEN SCL.planParentEntityType=3 THEN
(SELECT  3 AS '@_type_', SCL.clientId AS '@clientId', SCL.clientDisplayName AS '@displayName' FOR XML PATH ('planParentEntity'),TYPE)
WHEN SCL.planParentEntityType=61 THEN
(SELECT  61 AS '@_type_', UD.id AS '@providerId' , UD.domainName As '@providerDomainName' FOR XML PATH ('planParentEntity'),TYPE)
							END)
	FROM #SubclientEntites SCL
	LEFT OUTER JOIN UMDSProviders UD
ON UD.id=SCL.planParentEntityId AND SCL.planParentEntityType=61
END
IF @propertyLevel >= 5
BEGIN
	DECLARE @subclientCur CURSOR
	SET @subclientCur = CURSOR
		FOR	(SELECT subclientId FROM #SubclientEntites)
		OPEN @subclientCur
			FETCH NEXT FROM @subclientCur INTO @subclientId
			WHILE @@FETCH_STATUS = 0
			BEGIN
					SET @xmlCommonProperties = ''
					SET @xmlDbAgentProperties = ''
					SET @xmlFsIDAProperties = ''
					SET @xmlNFSProperties = ''
					SET @xmlSLAProperties = ''
					SET @xmlAdvancedIndexingProperties = ''
					----------Get Common properties from SP APPGetSubclientCommonProperties------------------
					EXEC [dbo].[APPGetSubclientCommonProperties] @subclientId, @propertyLevel, @userId, @xmlCommonProperties OUTPUT, @mode, @localeId,@includeBackupInfo, @withBackup
					IF @withBackup = 1 AND  (@xmlCommonProperties IS NULL OR  @xmlCommonProperties.exist('*') = 0)
					BEGIN
						DELETE FROM #SubclientEntites
						WHERE subclientId = @subclientId
					END
					ELSE
					BEGIN
						UPDATE #SubclientEntites
						SET commonProperties = @xmlCommonProperties
						WHERE subclientId = @subclientId
					END
					------------------------------------------------------------------------------------------
					----------Get DB Subclient properties from SP AppGetDBSubClientProperties-----------------
					EXEC [dbo].[AppGetDBSubClientProperties] @subclientId, @propertyLevel, @localeId, @xmlDbAgentProperties OUTPUT
					UPDATE #SubclientEntites
					SET SybaseProperties = @xmlDbAgentProperties
					WHERE subclientId = @subclientId
					------------------------------------------------------------------------------------------
					----------Get Advanced Indexing properties from SP APPGetSubclientAdvancedIndexingProperties------------------
					EXEC [dbo].[APPGetSubclientAdvancedIndexingProperties] @subclientId, @propertyLevel, @userId, @xmlAdvancedIndexingProperties OUTPUT, @mode
					UPDATE #SubclientEntites
					SET advancedIndexingProp = @xmlAdvancedIndexingProperties
					WHERE subclientId = @subclientId
					IF @propertyLevel > 5 OR @includeBackupInfo = 1
					BEGIN
						IF @includeBackupInfo = 1
						BEGIN
							------------------------------------------------------------------------------------------
							----------Get FsIDA properties from SP APPGetSubclientFsIDAProperties------------------
							EXEC [dbo].[APPGetSubclientFsIDAProperties] @subclientId, @propertyLevel, @xmlFsIDAProperties OUTPUT, @includeBackupInfo
							------------------------------------------------------------------------------------------
						END
						ELSE
						BEGIN
							------------------------------------------------------------------------------------------
							----------Get FsIDA properties from SP APPGetSubclientFsIDAProperties------------------
							EXEC [dbo].[APPGetSubclientFsIDAProperties] @subclientId, @propertyLevel, @xmlFsIDAProperties OUTPUT
							------------------------------------------------------------------------------------------
							----------Get NFS Server properties from SP APPGetNFSSubclientProperties------------------
							EXEC [dbo].[APPGetNFSSubclientProperties] @subclientId, @propertyLevel, @xmlNFSProperties OUTPUT
							UPDATE #SubclientEntites
							SET nfsSubclientProp = @xmlNFSProperties
							WHERE subclientId = @subclientId
								------------------------------------------------------------------------------------------
							----------Get SLA properties from SP RptGetSLAByVSA------------------
							IF OBJECT_ID('tempdb.dbo.#VSA_Subclient') IS NOT NULL DROP TABLE dbo.#VSA_Subclient
							CREATE TABLE #VSA_Subclient (appId INT, metSLA INT, missedSLA INT, excluded INT)
							EXEC RptGetSLAByVSA @userId,0, @subclientId, -1, 0
							SET @xmlSLAProperties = (SELECT metSLA AS '@vmMetSLACount' , missedSLA AS '@vmMissedSLACount', excluded AS '@vmExcludedCount' FROM  #VSA_Subclient
							FOR XML PATH ('vmSLAInfo'),TYPE)
							UPDATE #SubclientEntites
							SET SLAProperties= @xmlSLAProperties
							WHERE subclientId = @subclientId
							------------------------------------------------------------------------------------------
						END
							------------------------------------------------------------------------------------------
							----------Insert FsIDA properties into SubclientEntites-----------------------------------
							UPDATE #SubclientEntites
							SET FsIDAProperties = @xmlFsIDAProperties
							WHERE subclientId = @subclientId
							------------------------------------------------------------------------------------------
					END
				CONTINUE_NEXT_SUBCLIENT:
				FETCH NEXT FROM @subclientCur INTO @subclientId
			END--END cursor fetch loop
		DEALLOCATE @subclientCur
END
-- Compute Analytic settings
-- Scale Performance gain instead of performing individual inline subqueries repeatedly
UPDATE scTbl
	SET isEnableLMAnalytics = CAST(p1.attrVal AS INTEGER),
		analyticsMonitoringPolicyId = CAST(p2.attrVal AS INTEGER)
FROM #SubclientEntites scTbl
	LEFT OUTER JOIN APP_SubClientProp p1 WITH(NOLOCK) ON
		p1.componentNameId = scTbl.subclientId
		AND p1.attrName = N'EnableLMAnalytics'
		AND p1.cs_attrName = CHECKSUM(N'EnableLMAnalytics')
		AND p1.modified = 0
	LEFT OUTER JOIN APP_SubClientProp p2 WITH(NOLOCK) ON
		p2.componentNameId = scTbl.subclientId
		AND p2.attrName = N'AnalyticsMonitoringPolicyId'
		AND p2.cs_attrName = CHECKSUM(N'AnalyticsMonitoringPolicyId')
		AND p2.modified = 0
WHERE
	-- Only update if something found
	p2.id IS NOT NULL
	OR p1.id IS NOT NULL
IF (@_getArchiverSubclients = 1 OR (@inSubclientId IS NOT NULL AND @inSubclientId > 0))
BEGIN
-- Updating #SubclientEntites table for useLocalArchivalRules flag.
	UPDATE SCL
	SET SCL.useLocalArchivalRules = dbo.AppFetchLocalArchivalRulesFlag(SCL.subclientId)
	FROM #SubclientEntites SCL
END
DECLARE @commCellName NVARCHAR(256)
DECLARE @csGuid NVARCHAR(40)
SELECT @commCellName = aliasName,
		@csGuid = csGUID
FROM APP_CommCell
WHERE id = 2
DECLARE @xmlResult XML
SET	@xmlResult =
				(SELECT
					(SELECT SubclientListTBL.isContentFromPlan AS '@isContentFromPlan',
					 		ISNULL((SELECT
										CAST(attrVal as INT)
									FROM APP_SubClientProp WITH(NOLOCK)
									WHERE
attrName = 'Use Local Content'
AND cs_attrName = CHECKSUM(N'Use Local Content')
										AND componentNameId = SubclientListTBL.subclientId
										AND modified = 0
							),0) AS '@useLocalContent',
							CASE ISNULL(SubclientListTBL.useLocalArchivalRules, 0)
								WHEN 1 THEN 1
								ELSE 0
							END AS '@useLocalArchivalRules',
							SubclientListTBL.subclientStatus AS '@status',
							SubclientListTBL.commonProperties.query('/subclientCommonProperties/commonProperties'),
							SubclientListTBL.commonProperties.query('/subclientCommonProperties/content'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/mssqlSubClientProp'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/sybaseSubclientProp'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/exchangeDBSubClientProp'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/oracleSubclientProp'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/mySqlSubclientProp'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/postgreSQLSubclientProp'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/db2SubclientProp'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/sapForOracleSubclientProp'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/sapHANASubclientProp'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/content'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/vmContent'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/vmFilter'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/vmDiskFilter'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/vmBackupInfo'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/vsaSubclientProp'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/cloudAppsSubClientProp'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/cloudDbContent'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/sharepointsubclientprop'),
							SubclientListTBL.SybaseProperties.query('/DBSubClientProp/informixSubclientProp'),
							SubclientListTBL.FsIDAProperties.query('/FSSubClientProp/content'),
							SubclientListTBL.FsIDAProperties.query('/FSSubClientProp/fsSubClientProp'),
							SubclientListTBL.FsIDAProperties.query('/FSSubClientProp/impersonateUser'),
							SubclientListTBL.advancedIndexingProp.query('/subclientAdvancedIndexingProperties/indexingInfo'),
							(SELECT SubclientListTBL.FsIDAProperties.value('(/FSSubClientProp/dfsSubclientProps/@useGPFSSnapshot)[1]', 'INT') as '@useGPFSSnapshot',
									SubclientListTBL.FsIDAProperties.value('(/FSSubClientProp/dfsSubclientProps/@hadoopAppType)[1]', 'INT') as '@hadoopAppType',
									SubclientListTBL.FsIDAProperties.query('/FSSubClientProp/distributedDataAccessNodes')
									FOR XML PATH('dfsSubclientProp'), TYPE),
							CASE (Select SubclientEntitiesTable.applicationId
									FROM #SubclientEntites SubclientEntitiesTable
									WHERE SubclientEntitiesTable.subclientId = SubclientListTBL.subclientId)
							WHEN 106 THEN --FOR VSA
								(SELECT SubclientListTBL.SybaseProperties.query('/DBSubClientProp/vsaSubclientProp/hcSubclientProp')
										FOR XML PATH(''), TYPE)
							ELSE
								(SELECT SubclientListTBL.FsIDAProperties.query('/FSSubClientProp/hcSubclientProp')
										FOR XML PATH(''), TYPE)
							END,
							SubclientListTBL.nfsSubclientProp.query('.'),
							SubclientListTBL.SLAProperties.query('.'),
							(SELECT SubclientListTBL.FsIDAProperties.query('/FSSubClientProp/cassandraProps/*')
										FOR XML PATH('cassandraProps'), TYPE),
							(SELECT SubclientListTBL.FsIDAProperties.query('/FSSubClientProp/splunkProps/*')
										FOR XML PATH('splunkProps'), TYPE),
							(SELECT SubclientEntitiesTBL.subclientId AS '@subclientId',
									SubclientEntitiesTBL.subclientName AS '@subclientName',
									SubclientEntitiesTBL.backupsetId AS '@backupsetId',
									SubclientEntitiesTBL.backupsetName AS '@backupsetName',
									SubclientEntitiesTBL.instanceId AS '@instanceId',
									dbo.EncodeInvalidXMLChar(SubclientEntitiesTBL.instanceName) AS '@instanceName',
									SubclientEntitiesTBL.applicationId AS '@applicationId',
									SubclientEntitiesTBL.appName AS '@appName',
									SubclientEntitiesTBL.clientId AS '@clientId',
									SubclientEntitiesTBL.clientName AS '@clientName',
									SubclientEntitiesTBL.clientDisplayName AS '@displayName',
									SubclientEntitiesTBL.guid as '@subclientGUID',
									@commCellName AS '@commCellName',
									@csGuid as '@csGUID',
									7 AS '@_type_'
									FROM #SubclientEntites SubclientEntitiesTBL
									WHERE SubclientEntitiesTBL.subclientId = SubclientListTBL.subclientId
								FOR XML PATH('subClientEntity'),TYPE),
							(SELECT
									-- Performance gain by removing inline subqueries and queried all data needed as a full data set operation
									SubclientListTBL.isEnableLMAnalytics AS '@enableAnalytics',
									SubclientListTBL.analyticsMonitoringPolicyId AS 'monitoringPolicy/@policyId'
								FOR XML PATH('analyticsSubclientProp'),TYPE	),
							(SELECT SubclientListTBL.proxyClientId AS '@clientId',
									SubclientListTBL.proxyClientName AS '@clientName'
                                        FOR XML PATH('proxyClient'),TYPE),
							(SELECT SubclientListTBL.planId AS '@planId',
									SubclientListTBL.planType AS '@planType',
                                    SubclientListTBL.planSubType AS '@planSubtype',
									SubclientListTBL.planName AS '@planName'
                                        FOR XML PATH('planEntity'),TYPE),
							SubclientListTBL.planParentXMLAttr.query('.'),
							(SELECT SubclientListTBL.dcPlanId AS '@planId',
									SubclientListTBL.dcPlanType AS '@planType',
                                    SubclientListTBL.dcPlanSubType AS '@planSubtype',
									SubclientListTBL.dcPlanName AS '@planName'
                                        FOR XML PATH('dcPlanEntity'),TYPE),
							SubclientListTBL.replicationGroupXML.query('.'),
							(SELECT SubclientListTBL.regionId AS '@regionId',
									SubclientListTBL.regionName AS '@regionName',SubclientListTBL.regionDisplayName AS  '@displayName'
                                        FOR XML PATH('region'),TYPE)
						FROM #SubclientEntites SubclientListTBL
						WHERE SubclientListTBL.subclientId = subClientEntitesMain.subclientId
					FOR XML PATH('subClientProperties'), TYPE)
					FROM #SubclientEntites AS subClientEntitesMain
				FOR XML PATH(''), type)
IF @propertyLevel > 20 AND @xmlResult IS NOT NULL
BEGIN
	SET @xmlResult.modify('delete /subClientProperties[empty(./*) and not(./@*)]')
END
SET @errorXML = (SELECT errorString as '@errorString',
							errorCode as '@errorCode',
							(SELECT clientid as '@clientId',
									clientName as '@clientName',
									subclientId AS '@subclientId',
									subclientName AS '@subclientName',
									backupsetId AS '@backupsetId',
									backupsetName AS '@backupsetName',
									instanceId AS '@instanceId',
									instanceName AS '@instanceName',
									applicationId AS '@applicationId',
									appName AS '@appName'
									FOR XML PATH('entity'),TYPE)
					 FROM @ErrorTable
					 FOR XML PATH('errors'),TYPE)
SET @xmlResult = (SELECT @xmlResult,@errorXML
	FOR XML PATH(''),ROOT('App_GetSubClientPropertiesResponse'))
SET @xmlOutput = @xmlResult
DROP TABLE #SecurityTbl
DROP TABLE #SubclientEntitesOfAssociatedEntites
DROP TABLE #SubclientEntites
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetSubclientPropertiesWithOutputParam')
	delete from GxQscripts where name = 'APPGetSubclientPropertiesWithOutputParam'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetSubclientPropertiesWithOutputParam')
	delete from GXDBVersions where aliasname = 'APPGetSubclientPropertiesWithOutputParam'
GO

insert into GXDBVersions values(2, 'APPGetSubclientPropertiesWithOutputParam',  '00010001000200390000', 'APPGetSubclientPropertiesWithOutputParam', '00010001000200390000')
GO

