

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetSubclientProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--  Author: Andrei Loukienko
--  Date:   2/23/2015
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetSubclientProp.sp,v $ $Id: APPGetSubclientProp.sp,v 1.2.14.11 2020/08/12 06:57:10 alakra Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetSubclientProp')
BEGIN
	print '>>> Drop Stored Procedure: APPGetSubclientProp <<<'
	drop procedure APPGetSubclientProp
END
IF EXISTS (select * from GxQscripts where name='APPGetSubclientProp')
	delete from GxQscripts where name = 'APPGetSubclientProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetSubclientProp')
	delete from GXDBVersions where aliasname = 'APPGetSubclientProp'
GO
print '... Creating Procedure: APPGetSubclientProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetSubclientProp
  @i_subclientID INT,
  @i_reftime INT
AS
  DECLARE @o_id integer;
  DECLARE @o_attrName nvarchar(1024);
  DECLARE @o_attrType integer;
  DECLARE @o_modified integer;
  DECLARE @o_created integer;
  DECLARE @o_attrVal nvarchar(MAX);
BEGIN
    SET NOCOUNT ON
	DECLARE @assocSCId INT = 0
	DECLARE @planId INT = 0
	SELECT @assocSCId = attrVal FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @i_subclientID AND modified = 0 AND attrName = N'Associated subclient Policy'  AND cs_attrName = checksum(N'Associated subclient Policy')
SELECT @planId = attrVal FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @i_subclientID AND modified = 0 AND attrName = 'Associated Plan'  AND cs_attrName = checksum(N'Associated Plan')
	-- Different handling for plan
	-- Older server plan prior to SP13 won't have subclient policy as part of them. Let old code continue for those cases
	IF (@planId > 0) AND (@assocSCId > 0)
	BEGIN
		-- The values can be user overriden over associated SCP from plan
		DECLARE @LocalAttrTable TABLE (attr NVARCHAR(MAX))
		INSERT INTO @LocalAttrTable
			VALUES
				('System State'),
				('use cs setting for global filters'),
				('use global filters')
		-- Cache values in local prop table. Output will be selected from this table
DECLARE @LocalPropTable TABLE(_ID INT IDENTITY(1,1) PRIMARY KEY, id INT, attrName NVARCHAR(1024), attrType INT, modified INT, created INT, attrVal NVARCHAR(MAX),componentNameId INT, cs_attrName INT)
		-- Code to select properties is copied from the non-plan case, except we insert in to the Local prop table
		IF @i_reftime <> 0
			INSERT INTO @LocalPropTable
			SELECT id, attrName, attrType, modified, created, attrVal,componentNameId, cs_attrName FROM APP_SubClientProp WITH(NOLOCK)
			WHERE componentNameId IN( @i_subclientID, @assocSCId)
			AND ( created <= @i_reftime AND
			 ( modified = 0 OR modified > @i_reftime ))
			AND ((0 = (SELECT subclientStatus & 4 FROM APP_Application WITH(NOLOCK) WHERE id = @i_subclientID)) OR
				 (@i_reftime < ( SELECT modified FROM APP_Application WITH(NOLOCK) WHERE id = @i_subclientID)))
				 ORDER BY created DESC
		ELSE
			INSERT INTO @LocalPropTable
			SELECT id, attrName, attrType, modified, created, attrVal,componentNameId,cs_attrName FROM APP_SubClientProp WITH(NOLOCK)
			WHERE componentNameId IN( @i_subclientID, @assocSCId) AND modified = 0
			ORDER BY created DESC
		DECLARE @usingLocalContent INT = 0
SELECT @usingLocalContent = attrVal FROM @LocalPropTable WHERE componentNameId = @i_subclientID AND modified = 0 AND attrName = 'Use Local Content' AND cs_attrName=checksum(N'Use Local Content')
		--Now remove duplicate props based on whether using local content or not
		IF @usingLocalContent != 0
		BEGIN
			-- Delete subclient policy entries
			DELETE FROM @LocalPropTable
			WHERE componentNameId = @assocSCId AND attrName IN (SELECT attr FROM @LocalAttrTable)
		END
		ELSE
		BEGIN
			-- Delete subclient entries
			DELETE FROM @LocalPropTable
			WHERE componentNameId = @i_subclientID AND attrName IN (SELECT attr FROM @LocalAttrTable)
		END
IF EXISTS(SELECT 1 FROM APP_Plan P WITH (NOLOCK) WHERE P.id = @planId AND P.type = 9 AND P.subType = 150994951)
		BEGIN
			DECLARE @usingLocalArchivingRules INT = 0
IF OBJECT_ID('tempdb.dbo.#decoupledArchivalRules') IS NOT NULL
	DROP TABLE #decoupledArchivalRules
CREATE TABLE #decoupledArchivalRules
(
	attrName VARCHAR(MAX),
	cs_attrName INT
)
INSERT INTO #decoupledArchivalRules
VALUES	('Num of Days Old',							CHECKSUM(N'Num of Days Old')),
('Num of Days Old Modified',					CHECKSUM(N'Num of Days Old Modified')),
('Minimum File Size',							CHECKSUM(N'Minimum File Size')),
('Num of Days Old Created',					CHECKSUM(N'Num of Days Old Created')),
('Maximum File Size',							CHECKSUM(N'Maximum File Size')),
('DiskCleanup File Types',				CHECKSUM(N'DiskCleanup File Types')),
('Low Percent Disk Space Free',			CHECKSUM(N'Low Percent Disk Space Free')),
('Percent Disk Space Free',				CHECKSUM(N'Percent Disk Space Free')),
('Data Migrator Rule Flag',				CHECKSUM(N'Data Migrator Rule Flag')),
('Enable Redundancy For Data Backedup',	CHECKSUM(N'Enable Redundancy For Data Backedup')),
('Stub pruning Options',				CHECKSUM(N'Stub pruning Options')),
('Stub Retention Time',				CHECKSUM(N'Stub Retention Time'))
			SET @usingLocalArchivingRules = dbo.AppFetchLocalArchivalRulesFlag(@i_subclientID)
			--Now remove duplicate props based on whether using local archiving rules or not
			IF @usingLocalArchivingRules = 1
			BEGIN
				-- Delete subclient policy entries
				DELETE LPT
				FROM @LocalPropTable LPT
				INNER JOIN  #decoupledArchivalRules LART ON LPT.attrName = LART.attrName AND LPT.cs_attrName=LART.cs_attrName
				WHERE LPT.componentNameId = @assocSCId
			END
			ELSE
			BEGIN
				-- Delete subclient entries
				DELETE LPT
				FROM @LocalPropTable LPT
				INNER JOIN  #decoupledArchivalRules LART ON LPT.attrName = LART.attrName AND LPT.cs_attrName=LART.cs_attrName
				WHERE LPT.componentNameId = @i_subclientID
			END
		END
		-- Properties which are coming from subclient policy should not be returned from
        DELETE DT
        FROM @LocalPropTable  DT
        INNER JOIN @LocalPropTable DUP
            ON DUP.attrName=DT.attrName AND DUP.componentNameId<>DT.componentNameId
        WHERE DT.componentNameId=@i_subclientID AND (@i_subclientID > @assocSCId)
		--Select output
		SELECT id, attrName, attrType, modified, created, attrVal FROM @LocalPropTable
	END
	ELSE --non plan
	BEGIN
		if @assocSCId = 0
		BEGIN
			-- do we want to do a point-in-time lookup?
			if @i_reftime <> 0
				SELECT id, attrName, attrType, modified, created, attrVal FROM APP_SubClientProp WITH(NOLOCK)
				WHERE componentNameId = @i_subclientID
				AND ( created <= @i_reftime AND
					  ( modified = 0 OR modified > @i_reftime ))
				AND ((0 = (SELECT subclientStatus & 4 FROM APP_Application WITH(NOLOCK) WHERE id = @i_subclientID)) OR
					(@i_reftime < ( SELECT modified FROM APP_Application WITH(NOLOCK) WHERE id = @i_subclientID)))
			ELSE
				SELECT id, attrName, attrType, modified, created, attrVal FROM APP_SubClientProp WITH(NOLOCK)
				WHERE componentNameId = @i_subclientID AND modified = 0
		END
		ELSE
		BEGIN
			IF @i_reftime <> 0
				SELECT id, attrName, attrType, modified, created, attrVal FROM APP_SubClientProp WITH(NOLOCK)
				WHERE componentNameId IN( @i_subclientID, @assocSCId)
				AND ( created <= @i_reftime AND
				 ( modified = 0 OR modified > @i_reftime ))
				AND ((0 = (SELECT subclientStatus & 4 FROM APP_Application WITH(NOLOCK) WHERE id = @i_subclientID)) OR
					 (@i_reftime < ( SELECT modified FROM APP_Application WITH(NOLOCK) WHERE id = @i_subclientID)))
					 ORDER BY created DESC
			ELSE
				SELECT id, attrName, attrType, modified, created, attrVal FROM APP_SubClientProp WITH(NOLOCK)
WHERE ((componentNameId =@i_subclientID) OR ((componentNameId=@assocSCId) AND attrName<>'Associated Plan')) AND modified = 0
				ORDER BY created DESC
		END
	END
    SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetSubclientProp')
	delete from GxQscripts where name = 'APPGetSubclientProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetSubclientProp')
	delete from GXDBVersions where aliasname = 'APPGetSubclientProp'
GO

insert into GXDBVersions values(2, 'APPGetSubclientProp',  '00010002001400110000', 'APPGetSubclientProp', '00010002001400110000')
GO

