

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetSubclientFsIDAProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPGetSubclientFsIDAProperties')
BEGIN
	print '>>> Drop Stored Procedure: APPGetSubclientFsIDAProperties <<<'
	drop procedure APPGetSubclientFsIDAProperties
END
IF EXISTS (select * from GxQscripts where name='APPGetSubclientFsIDAProperties')
	delete from GxQscripts where name = 'APPGetSubclientFsIDAProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetSubclientFsIDAProperties')
	delete from GXDBVersions where aliasname = 'APPGetSubclientFsIDAProperties'
GO
print '... Creating Procedure: APPGetSubclientFsIDAProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPGetSubclientFsIDAProperties
  @subclientId INT,
  @propertyLevel INT,
  @xmlResult XML OUTPUT,
  @includeContentInfo INT = 0
AS
	DECLARE	@useVSS					INT = 0
	DECLARE @vssOptions				INT
	DECLARE @useVssForAllFilesOptions	INT
	DECLARE	@useVSSForSystemState	INT
	DECLARE @enableOnePass			INT
	DECLARE @diskCleanupModified	INT
	DECLARE	@unixCtime				INT
	DECLARE	@unixMtime				INT
	DECLARE	@useGlobalFilter		INT = 0
	DECLARE	@globalFilters			INT = 0
	DECLARE @includePolicyFilters	INT
	DECLARE	@useCSSettingForGF		INT = 0
	DECLARE	@applicationId			INT
	DECLARE	@runPostBackup			INT
	DECLARE	@backupSystemState		INT
	DECLARE	@impersonateUser		VARCHAR(MAX)
	DECLARE @backupSystemStateforFullBkpOnly INT = 0
	DECLARE @backupFilesQualifiedForArchive INT
	DECLARE	@isDDBSubclient			INT = NULL
	DECLARE	@oneTouchSubclient		INT = NULL
	DECLARE @oneTouchServer			INT
	DECLARE @oneTouchServerName		NVARCHAR(256)
	DECLARE @oneTouchServerDirectory	VARCHAR(MAX)
	DECLARE	@honorArchiverAgentRetention INT
	DECLARE	@retentionRule			INT
	DECLARE @keepItemsPastTheirExp	INT
	DECLARE	@daysToKeepItems		INT
	DECLARE @catalogAdditional		INT
	DECLARE @catalogACL				INT
	DECLARE @useChangeJournal		INT
	DECLARE @useClassicFileScan		INT
	DECLARE @useDCforFSbackups		INT
	DECLARE @blockLevelBackup		INT
	DECLARE @blockLevelSPOSBackup	INT
	DECLARE @createFileLevelIndexDuringBackup	INT
	DECLARE @scanOption				INT
	DECLARE @preserveFileAccessTime	INT
	DECLARE @checkArchiveBit		INT
	DECLARE @backupFilesOnOrAfter	INT
	DECLARE @backupFilesOnOrAfterDate	INT
	DECLARE @backupFileTimeZoneName	NVARCHAR(MAX)
	DECLARE @deleteArchiveJob		INT
	DECLARE @deleteArchiveJobAfterDays	INT
	DECLARE @userDeletedStubRetention	INT
	DECLARE @userDeletedStubRetentionDays	INT
	DECLARE @backupRetention INT
	DECLARE @keepOlderVersionsForDays INT
	DECLARE @keepAtLeastPreviousVersions INT
	DECLARE @extendStoragePolicyRetention INT
	DECLARE @archiverRetention INT
	DECLARE @archiverRetentionMode INT
	DECLARE @extendRetentionForNDays INT
	DECLARE @afterDeletionKeepItemsForNDays INT
	DECLARE @olderFileVersionsMode INT
	DECLARE @keepOlderVersionsForNDays INT
	DECLARE @keepVersions INT
	DECLARE @retainPerDayPeriod INT
	DECLARE @retainPerWeekPeriod INT
	DECLARE @retainPerMonthPeriod INT
	DECLARE @useSubclientPolicyRetention INT
	DECLARE @backupRetentionMode INT
	DECLARE @deletePSTFileOnly		INT
	DECLARE @enableOCSBackupOnSubclient	INT
	DECLARE @ocsUserName			NVARCHAR(MAX)
	DECLARE @useSCPFilters			INT
	DECLARE @useIncremental			INT
	DECLARE @pastExpiryDaysType		INT
	DECLARE @enableArchivingWithRules INT
	DECLARE @startCleaningIfLessThan INT
	DECLARE @stopCleaningIfupto	INT
	DECLARE @fileAccessTimeOlderThan INT
	DECLARE @fileModifiedTimeOlderThan INT
	DECLARE @fileCreatedTimeOlderThan INT
	DECLARE @fileSizeGreaterThan	INT
	DECLARE @patternMatch			NVARCHAR(MAX)
	DECLARE @entityMatch			NVARCHAR(MAX)
	DECLARE @enableRedundancyForDataBackedup	INT
	DECLARE @maximumFileSize		INT
	DECLARE @dmRulesFlag			INT
	DECLARE @afterArchivingRule		INT
	DECLARE @rulesToSatisfy			INT
	DECLARE @archiveReadOnlyFiles	INT
	DECLARE @useNativeSnapshotToPreserveFileAccessTime	INT
	DECLARE @openFileFailureAction	INT
	DECLARE @associatedPolicyId	INT = 0
	DECLARE @vssShadowCopy			NVARCHAR(MAX)
	DECLARE @daNodesStr			NVARCHAR(MAX)
	DECLARE @daNodesXml			XML
	DECLARE @hcNodesXml			XML
	DECLARE @backupConfiguration	XML
	DECLARE @backupConfigurationIDA	XML
	DECLARE @cassandraXml       XML
	DECLARE @splunkXml XML
	DECLARE @diskCleanupFileTypes	XML
	DECLARE @diskCleanupOwner		NVARCHAR(MAX)
	DECLARE @adHocRules		NVARCHAR(MAX)
	DECLARE @adHocOneTimeArchive	INT
	DECLARE @liveCrawlSubClientId	INT
	DECLARE @activateURLCriteria		NVARCHAR(MAX)
	DECLARE @stubPruningOptions		INT
	DECLARE @stubRetentionDaysOld	BIGINT
	DECLARE @isNASClient			INT = 0
	DECLARE @backupSaveFileData		INT
	DECLARE @backupSpooledFileData	INT
	DECLARE @backupQueueData		INT
	DECLARE @backupPrivateAuthority	INT
	DECLARE @targetReleaseForBackupData	NVARCHAR(MAX)
	DECLARE @saveAccessPath			NVARCHAR(128)
	DECLARE @syncAllLibForBackup	INT
	DECLARE @activeWaitTime			INT
	DECLARE @syncQueue				NVARCHAR(MAX)
	DECLARE	@txtlibSyncCheckPoint	NVARCHAR(MAX)
	DECLARE @customSubclientContentFlags INT
	DECLARE @customSubclientFlag	INT
	DECLARE @isDecoupleSCPContent	INT
	DECLARE @backupAsObjects		INT
	DECLARE @saveWhileActiveOpt		NVARCHAR(MAX)
	DECLARE @useGPFSSnapshot		INT
	DECLARE @hadoopAppType			INT
	DECLARE @SRBootServerDir		NVARCHAR(256)
	DECLARE @DVDImageFileFormat		NVARCHAR(512)
	DECLARE @backupMaxTime			INT
	DECLARE	@notifyuser				INT
	DECLARE @notifyDelay			INT
	DECLARE @notifyMessage			NVARCHAR(1024)
	DECLARE @userCommand			NVARCHAR(512)
	DECLARE @userProgram			NVARCHAR(512)
	DECLARE	@userIPLProgram			NVARCHAR(512)
	DECLARE @saveSecData			INT
	DECLARE @saveConfObject			INT
	DECLARE @printSysInfo			INT
	DECLARE @ibmiDRLibrary			XML
	DECLARE @enableFolderLevelMultiThread INT
	DECLARE @folderLevelThreadCount		INT
	DECLARE @backupFilesAsExtents	INT
	DECLARE @extentSize				INT
	DECLARE @bigFileSize			BIGINT
	DECLARE @updateHistory			NVARCHAR(10)
	DECLARE @genSignatureOnIBMi		NVARCHAR(10)
	DECLARE @ibmiCompression		NVARCHAR(10)
	DECLARE @openvmsBackupDate		INT
	DECLARE @forcedArchiving		INT
	DECLARE @isSnapCenterSubclient	NVARCHAR(16)
	DECLARE @backupHDFSACLs			INT
	DECLARE @FSContentInfo			TABLE (
											contentType INT,
											content NVARCHAR(MAX))
	DECLARE @FSSCPContentInfo		TABLE (
											contentType INT,
											content NVARCHAR(MAX))
	DECLARE @FSSymLinkContentInfo	TABLE (
											path VARCHAR(MAX),
											link VARCHAR(MAX))
	DECLARE @NASContentInfo			TABLE (
											contentType INT,
											content NVARCHAR(MAX))
	DECLARE @SQLContentInfo			TABLE (
											content NVARCHAR(MAX))
	DECLARE @WinApptypeId			TABLE ( id INT )
	DECLARE @isTrueUpOptionEnabledForFS BIT
	DECLARE @runTrueUpJobAfterDaysForFS INT
	DECLARE @runTrueUpJobAfterJobsForFS INT
	DECLARE @retentionPolicy INT
	DECLARE @enableContentIndexing BIT
	DECLARE @contentIndexingPolicy INT
	DECLARE @isSynthfullRunAfterOnePassEnabledOnSubclient BIT = 0
	DECLARE @OnePassSynthFullJobInfo TABLE ( jobid int )
	DECLARE @usedIBMIASPContent INT
	DECLARE @isLocalArchiveRulesEnabled INT = 0
	DECLARE @isAccessTimeCollected INT = 0
	DECLARE @useStoragePolicyRetention	INT
	DECLARE @deleteFilesWithoutBackup	INT
	--Edge Drive Subclient Policy Properties
	DECLARE @edIsIndefiniteRetention INT
	DECLARE	@edRetentionInDays INT
	DECLARE	@edEnableRetentionRulesForVersions INT
	DECLARE	@edMinNoOfVersions INT
	DECLARE	@edVersionsRetentionInDays INT
	DECLARE @enableNetworkShareAutoMount	INT
	DECLARE @autoMountCommandOptions	TABLE ( path NVARCHAR(MAX))
	SET @applicationId = (SELECT appTypeId FROM APP_Application WITH (NOLOCK) WHERE APP_Application.id = @subclientId)
	DECLARE @isManualDDBSubclient INT
	IF @includeContentInfo = 1
	BEGIN
		SET @propertyLevel = 30
	END
	DECLARE @isDefaultSubclient INT = 0
IF (SELECT subclientStatus FROM APP_Application WITH (NOLOCK) WHERE id = @subclientId AND (subclientStatus & 0x00008) = 0x00008) <> ''
	BEGIN
		SET @isDefaultSubclient = 1
	END
	DECLARE @planId INT = 0
	SET @planId = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_SubClientProp WITH(NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Associated Plan' AND cs_attrName = CHECKSUM(N'Associated Plan') AND modified = 0),0)
DECLARE @allowLocalContent INT = ISNULL((SELECT CAST(value as INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'AllowSubclientLocalContent' AND modified = 0),1)
	DECLARE @isLocalContentEnabled INT = 0
	IF @allowLocalContent != 0
	BEGIN
SET @isLocalContentEnabled = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE APP_SubclientProp.componentNameId = @subclientId AND APP_SubclientProp.attrName = 'Use Local Content' AND modified = 0), 0)
	END
	SET @isLocalArchiveRulesEnabled =  dbo.AppFetchLocalArchivalRulesFlag(@subclientId)
	SELECT @isAccessTimeCollected = CAST(IProp.attrVal AS INT)
	FROM APP_IdaProp IProp (NOLOCK)
		INNER JOIN APP_IdaName IName (NOLOCK)
			ON IProp.componentNameId = IName.id
		INNER JOIN APP_Application A(NOLOCK)
			ON IName.clientId = A.clientId AND IName.appTypeId = A.appTypeId
	WHERE
		A.id = @subclientId
		AND IProp.attrName = 'Enable Access Time Collection'
		AND IProp.modified = 0
	--Gather FS properties
IF( ( @applicationId = 33
OR @applicationId = 11
OR @applicationId = 34
OR @applicationId = 42
OR @applicationId = 43
OR @applicationId = 19
OR @applicationId = 20
OR @applicationId = 17
OR @applicationId = 18
OR @applicationId = 21
OR @applicationId = 29
OR @applicationId = 38
OR @applicationId = 36
OR @applicationId = 63
OR @applicationId = 64
OR @applicationId = 74
OR @applicationId = 65
OR @applicationId = 75
OR @applicationId = 1030 ) )--AND @propertyLevel >= 30)
	BEGIN
		IF @propertyLevel >= 20
		BEGIN
			SET @associatedPolicyId = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Associated subclient Policy' AND modified = 0), 0)
			IF @associatedPolicyId > 0
			BEGIN
				SET @backupSystemState = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'System State' AND modified = 0)
				--From 10.0, Use Shadow Copy is present under Use VSS Enabled (1) and Use VSS Options(1)
IF (SELECT releaseId FROM App_Client WITH (NOLOCK) WHERE id = (SELECT clientId FROM App_Application WITH (NOLOCK) WHERE id = @subclientId)) < 15
					SET @useVSS = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Use Shadow Copy' AND modified = 0)
				ELSE
				BEGIN
					SET @useVSS = ISNULL((SELECT attrVal FROM App_Subclientprop WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Use VSS Enabled' AND modified = 0), 1)
					SET @vssOptions = ISNULL((SELECT attrVal FROM App_Subclientprop WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Use VSS Options' AND modified = 0), 2)
					SET @useVssForAllFilesOptions = ISNULL((SELECT attrVal FROM App_Subclientprop WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Snap Failure Action' AND modified = 0), 3)
				END
			END
			ELSE
			BEGIN
				SET @backupSystemState = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'System State' AND modified = 0)
				--From 10.0, Use Shadow Copy is present under Use VSS Enabled (1) and Use VSS Options(1)
IF (SELECT releaseId FROM App_Client WITH (NOLOCK) WHERE id = (SELECT clientId FROM App_Application WITH (NOLOCK) WHERE id = @subclientId)) < 15
					SET @useVSS = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Use Shadow Copy' AND modified = 0)
				ELSE
				BEGIN
					SET @useVSS = (SELECT attrVal FROM App_Subclientprop WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Use VSS Enabled' AND modified = 0)
					SET @vssOptions = (SELECT attrVal FROM App_Subclientprop WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Use VSS Options' AND modified = 0)
					SET @useVssForAllFilesOptions = (SELECT attrVal FROM App_Subclientprop WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Snap Failure Action' AND modified = 0)
				END
			END
			IF @isLocalContentEnabled = 1
			BEGIN
				SET @backupSystemState = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'System State' AND cs_attrName = CHECKSUM(N'System State') AND modified = 0), 0)
			END
			--Return false on backup system state for non-default subclients in plan associated subclients
			IF @isDefaultSubclient = 0 AND @planId != 0
			BEGIN
				SET @backupSystemState = 0
			END
			SET @isDDBSubclient = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DDB Backup' AND modified = 0)
			SET @isManualDDBSubclient = (SELECT attrVal FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @subClientId AND attrName = 'DDB Backup SubClient Type' AND modified = 0)
IF (SELECT subclientStatus FROM APP_Application WITH (NOLOCK) WHERE id = @subclientId AND (subclientStatus & 0x0100) = 0x0100) <> ''
				SET @oneTouchSubclient = 1
			else
				SET @oneTouchSubclient = 0
			SET @oneTouchServer = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'SR Boot Server' AND modified = 0)
			SET @oneTouchServerName = (SELECT name FROM App_Client WITH (NOLOCK) WHERE id = @oneTouchServer)
			SET @oneTouchServerDirectory = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'SR Boot Server Dir' AND modified = 0)
			SET @blockLevelBackup = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Use block level backup' AND modified = 0)
			SET @createFileLevelIndexDuringBackup = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Enable metadata Collection' AND modified = 0)
			SET @blockLevelSPOSBackup  = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Use block level SPOS backup' AND modified = 0)
			SET @enableOnePass = (SELECT attrVal FROM App_Subclientprop WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Is Turbo Subclient' AND modified = 0)
			IF @associatedPolicyId > 0
				SET @enableOnePass = (SELECT attrVal FROM App_Subclientprop WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Is Turbo Subclient' AND modified = 0)
			IF EXISTS (SELECT attrVal FROM App_Subclientprop WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Turbo Mode Enable Stubbing')
				SET @diskCleanupModified = 1
			SET @daNodesStr = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Data Access Nodes' AND modified = 0)
			IF @daNodesStr is null
			BEGIN
				SET @daNodesStr = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Solr Index Client Id' AND modified = 0)
			end
			SET @daNodesStr =  SUBSTRING(@daNodesStr,charindex('<app',@daNodesStr),len(@daNodesStr))
			SET @daNodesXml = @daNodesStr
			-- May be mongo db in distributed apps
			IF @daNodesXml IS NULL
			BEGIN
				IF object_id('temp.dbo.#Mongo_DANodes') IS NOT null DROP TABLE #Mongo_DANodes
				SELECT	mAssoc.repsetName, mAssoc.hostName, mAssoc.portNumber,
						mAssoc.subType, mAssoc.role, mAssoc.clientId, mPrio.priority
				INTO #Mongo_DANodes
				FROM APP_MongoDbAssociation mAssoc
					JOIN APP_MongoDbSCPriority mPrio
						ON mPrio.mdbNode = mAssoc.id
				WHERE
					mPrio.subclientId = @subclientId
					AND mAssoc.modified = 0
				SET @daNodesXml =
					(SELECT
						(SELECT repsetName as '@repsetname',
							(SELECT
								hostName as '@hostName',
								portNumber as '@portNumber',
								subType as '@subType',
								role as '@role',
								repsetName as '@repsetName',
								(SELECT
									clientId as '@clientId',
									(SELECT name FROM App_Client WHERE id = clientId) as '@clientName'
								FOR XML PATH('client'), TYPE)
							FROM #Mongo_DANodes
							WHERE repsetName = outer_daNodes.repsetName
							ORDER BY priority
							FOR XML PATH('repsetClient'), TYPE)
						FROM #Mongo_DANodes as outer_daNodes
						GROUP BY repsetName
						FOR XML PATH('mongoDataAccessNodes'), TYPE)
					FOR XML PATH('App_DataAccessNodes'), TYPE)
				IF object_id('temp.dbo.#Mongo_DANodes') IS NOT null DROP TABLE #Mongo_DANodes
			END
			SET @backupSaveFileData = (SELECT attrVal FROM App_Subclientprop WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'iSeries Backup Library Object SAVFDTA' AND modified = 0)
			SET @backupSpooledFileData = (SELECT attrVal FROM App_Subclientprop WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'iSeries Backup Library Object SPLFDTA' AND modified = 0)
			SET @backupQueueData = (SELECT attrVal FROM App_Subclientprop WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'iSeries Backup Library Object QDTA' AND modified = 0)
			SET @backupPrivateAuthority = (SELECT attrVal FROM App_Subclientprop WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'iSeries Backup Library Object PVTAUT' AND modified = 0)
			SET @targetReleaseForBackupData = (SELECT attrVal FROM App_Subclientprop WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'iSeries Target Release for Backup Data' AND modified = 0)
			SET @syncAllLibForBackup = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'iSeries Subclient Synchronize Libraries Flag' AND modified = 0), 0)
			SET @activeWaitTime = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'iSeries Save Active Wait Time' AND modified = 0), 0)
			SET @syncQueue = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'iSeries Synchronization Queue' AND modified = 0), '')
			SET	@txtlibSyncCheckPoint = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'iSeries Libraries Synchronized Check Point' AND modified = 0), '')
			SET	@customSubclientContentFlags = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'iSeries Subclient Content Selection Bit Field' AND modified = 0)
			SET	@customSubclientFlag = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'iSeries Subclient Custom Flag' AND modified = 0), 1)
			SET @backupAsObjects = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'IBMi Backup Contents as Objects' AND modified = 0), 0)
			SET @saveWhileActiveOpt = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'IBMi Save while active Flag' AND modified = 0), '*LIB')
			SET @useGPFSSnapshot = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Use GPFS Snapshot' AND modified = 0)
			SET @hadoopAppType = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Hadoop App Type' AND modified = 0)
			SET @SRBootServerDir = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'SR Boot Server Dir' AND modified = 0)
			SET @DVDImageFileFormat = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'IBMi DVD Image File Format' AND modified = 0)
			SET @backupMaxTime = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'IBMi Maxium Backup Time' AND modified = 0)
			SET @notifyuser = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'IBMi Notify User for DR Backup' AND modified = 0)
			SET @notifyDelay = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'IBMi Notify Delay' AND modified = 0)
			SET @notifyMessage = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'IBMi Notify Message' AND modified = 0)
			SET @userCommand = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'IBMi User Command for Restricted State' AND modified = 0)
			SET @userProgram = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'IBMi User Program during DR Backup' AND modified = 0)
			SET @userIPLProgram = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'IBMi User IPL Program' AND modified = 0)
			SET @saveSecData = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'IBMi Save security data' AND modified = 0)
			SET @saveConfObject = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'IBMi save configuration objects' AND modified = 0)
			SET @printSysInfo = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'IBMi Print System Information' AND modified = 0)
			SET @ibmiDRLibrary = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'IBMi DR Backup Library Paths' AND modified = 0)
			SET @backupConfiguration = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Backup Configuration Nodes' AND modified = 0)
			IF(@backupConfiguration IS NULL OR @backupConfiguration.exist('/App_BackupConfigurationNodes/backupDataAccessNodes') = 0)
			BEGIN
				SET @backupConfigurationIDA = ( SELECT idaProp.attrVal FROM APP_IDAName ida
				INNER JOIN  APP_Application s ON s.appTypeId=ida.appTypeId AND s.clientId=ida.clientId
					 INNER join APP_IDAProp idaProp ON idaProp.componentNameId=ida.id AND attrName= 'Backup Configuration Nodes' AND idaprop.modified=0
				WHERE s.ID= @subclientId
			)
			END
			SET @saveAccessPath = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'IBMi Save Access Path ACCPTH' AND modified = 0)
			SET @backupFilesAsExtents = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Backup Files As Extents' AND modified = 0)
			SET @extentSize = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Extent Size' AND modified = 0)
			SET @bigFileSize = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Big File Size' AND modified = 0)
			SET @updateHistory = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'IBMi Update history (UPDHST)' AND modified = 0)
			SET @genSignatureOnIBMi = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'IBMi-Generate signature on IBMi' AND modified = 0), 0)
			SET @ibmiCompression = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'IBMi Compression' AND modified = 0)
			SET @openvmsBackupDate = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Set backup date attribute' AND modified = 0)
			SET @forcedArchiving = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Forced Archiving' AND modified = 0)
			SET @enableNetworkShareAutoMount = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Enable NAS Share Contents' AND modified = 0)
			SET @backupHDFSACLs = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Backup HDFS ACLs' AND modified = 0)
			INSERT INTO @autoMountCommandOptions
			SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'NAS Share Mount Options' AND modified = 0
			IF @associatedPolicyId > 0
			BEGIN
				SET @enableFolderLevelMultiThread = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Enable folder level multi-threading' AND modified = 0)
				SET @folderLevelThreadCount = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Folder level thread count' AND modified = 0)
			END
			ELSE
			BEGIN
				SET @enableFolderLevelMultiThread = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Enable folder level multi-threading' AND modified = 0)
				SET @folderLevelThreadCount = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Folder level thread count' AND modified = 0)
			END
			--Edge Drive Subclient Policy Properties
SET @edRetentionInDays = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Trash Can Retention' AND modified = 0)
			IF @edRetentionInDays = -1
				SET @edIsIndefiniteRetention = 1
			ELSE
				SET @edIsIndefiniteRetention = 0
SET @edMinNoOfVersions = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Versions in Drive' AND modified = 0)
SET @edVersionsRetentionInDays = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Grace Period For Versions' AND modified = 0)
			IF @edMinNoOfVersions = 0 AND @edVersionsRetentionInDays = 0
				SET @edEnableRetentionRulesForVersions = 0
			ELSE
				SET @edEnableRetentionRulesForVersions = 1
			-- Adding used IASP contents flag.
			IF @customSubclientContentFlags IS NOT NULL
			BEGIN
				DECLARE @backupset INT = (SELECT backupSet FROM APP_Application WITH (NOLOCK) WHERE id = @subclientId)
				SET @usedIBMIASPContent = 0
				SELECT @usedIBMIASPContent = @usedIBMIASPContent | ASP.attrVal
				FROM APP_SubClientProp ASP WITH (NOLOCK)
					INNER JOIN APP_Application APP WITH (NOLOCK)
					ON APP.id = ASP.componentNameId
					AND ASP.attrName = N'iSeries Subclient Content Selection Bit Field'
					AND ASP.modified = 0
					AND APP.backupSet = @backupset
					AND APP.subclientStatus <> 4
			END
			--moved from below, we need it at property level 20
			IF @associatedPolicyId > 0
			BEGIN
				SET @enableArchivingWithRules = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Turbo Mode Enable Stubbing' AND modified = 0)
				SET @useNativeSnapshotToPreserveFileAccessTime = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Use LVM/cxbf snapshot to preserve file access time' AND modified = 0)
			END
			ELSE
			BEGIN
				SET @enableArchivingWithRules = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Turbo Mode Enable Stubbing' AND modified = 0)
				SET @useNativeSnapshotToPreserveFileAccessTime = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Use LVM/cxbf snapshot to preserve file access time' AND modified = 0)
			END
			SET @cassandraXml = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Cassandra Content XML' AND modified = 0)
			SET @splunkXml = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Splunk Content XML' AND modified = 0);
		END
		IF @propertyLevel >= 30
		BEGIN
			DECLARE @clientID INT = (SELECT clientId FROM App_Application WITH (NOLOCK) WHERE id = @subclientId)
			IF EXISTS ( select os.id from simOperatingSystem os WITH (NOLOCK)
						join APP_Client c WITH (NOLOCK)
						on os.id = c.simOperatingSystemId
						join APP_Application sc WITH (NOLOCK)
						on c.id = sc.clientId
						where sc.id = @subclientId and os.SubType = 'NAS'
					  )
				SET @isNASClient = 1
			--Image IDA subclient may have invalid characters.
IF @applicationId = 65 OR @applicationId = 75
			BEGIN
				INSERT	INTO @FSContentInfo
				SELECT type, dbo.EncodeInvalidXMLChar(fileName) FROM APP_ScFilterFile WITH (NOLOCK)
				WHERE componentNameId = @subclientId and modified = 0
				AND fileName NOT IN (SELECT attrName FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrType = 124 AND modified = 0 )
			END
			ELSE
			BEGIN
				INSERT	INTO @FSContentInfo
				SELECT type, fileName FROM APP_ScFilterFile WITH (NOLOCK)
				WHERE componentNameId = @subclientId and modified = 0
				AND fileName NOT IN (SELECT attrName FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrType = 124 AND modified = 0 )
			END
			INSERT INTO @FSSymLinkContentInfo
			SELECT attrName, attrVal
			FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrType = 124 AND modified = 0
			UPDATE @FSSymLinkContentInfo
			SET link = LEFT(link, CHARINDEX(0x15, CAST(link AS VARBINARY(MAX))) - 1)
			WHERE CHARINDEX(0x15, CAST(link AS VARBINARY(MAX))) > 0
			--Transform the NAS share contents and filters from /fileserver/share to fileserver:/share
			IF @enableNetworkShareAutoMount = '1'
			BEGIN
				UPDATE @FSContentInfo
				SET content = SUBSTRING(content,2,(CHARINDEX('/', content, 2) - 2)) + ':/' + SUBSTRING(content, CHARINDEX('/', content, 2) + 1, LEN(content) - (CHARINDEX('/', content, 2)))
				WHERE SUBSTRING(content,1,1) = '/' AND CHARINDEX('/', content, 2) !=0
			END
			--Content may have UNC path(starts with 'UNC-NT_'), replace 'UNC-NT_' with '\\'
			UPDATE @FSContentInfo
			SET content = (CASE SUBSTRING(content,1,7)
								WHEN 'UNC-NT_' THEN REPLACE(content, 'UNC-NT_', '\\')
								ELSE content END)
			--Do not send SCP conten\filter if Decouple SCP Content is set.
			SET @isDecoupleSCPContent = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE APP_SubclientProp.componentNameId = @subclientId AND APP_SubclientProp.attrName = 'Decouple SCP Content'  AND modified = 0), 0)
			IF @isDecoupleSCPContent = 0 AND @isLocalContentEnabled = 0
			BEGIN
					--Get contents of Subclient Policy
					INSERT	INTO @FSSCPContentInfo
					SELECT SCF.type, SCF.fileName
					FROM APP_ScFilterFile AS SCF WITH(NOLOCK)
					INNER JOIN APP_SubClientProp AS SCP WITH(NOLOCK)
					ON SCP.componentNameId = @subclientId AND SCP.attrName = 'Associated subclient Policy' AND SCP.modified = 0
						AND CAST(SCP.attrVal AS INT) = SCF.componentNameId AND SCF.modified = 0
			END
			INSERT INTO @WinApptypeId
			SELECT appTypeId FROM APP_AppTypeGroupAssoc WITH (NOLOCK) where appGroupId = 57
			IF @associatedPolicyId > 0
			BEGIN
				SET @useVSSForSystemState = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Use VSS for System State' AND modified = 0)
				SET @backupSystemStateforFullBkpOnly = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'System State on Full Backup Only' AND modified = 0)
				SET @impersonateUser = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'UNCPath user name' AND modified = 0)
				SET @globalFilters = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'use global filters' AND modified = 0), 0)
				SET @useCSSettingForGF = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'use cs setting for global filters' AND modified = 0), 1)
				SET @backupFilesQualifiedForArchive = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Backup Only Files qualified for archiving' AND modified = 0)
				--includePolicyFilters is a special case for check box Include Policy Filters. If subclient is associated to a subclient policy then return following property from subclient instead of policy subclient.
				SET @includePolicyFilters = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'use SCP filters' AND modified = 0), 1)
			END
			ELSE
			BEGIN
				SET @useVSSForSystemState = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Use VSS for System State' AND modified = 0)
				SET @backupSystemStateforFullBkpOnly = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'System State on Full Backup Only' AND modified = 0)
				SET @impersonateUser = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'UNCPath user name' AND modified = 0)
				SET @globalFilters = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'use global filters' AND modified = 0), 0)
				SET @useCSSettingForGF = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'use cs setting for global filters' AND modified = 0), 1)
				SET @backupFilesQualifiedForArchive = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Backup Only Files qualified for archiving' AND modified = 0)
			END
			--If using local content get system state flag,filters from subclient instead of SCP
			IF @isLocalContentEnabled = 1
			BEGIN
				SET @globalFilters = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'use global filters' AND cs_attrName = CHECKSUM(N'use global filters') AND modified = 0), 0)
				SET @useCSSettingForGF = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'use cs setting for global filters' AND cs_attrName = CHECKSUM(N'use cs setting for global filters') AND modified = 0), 1)
			END
			-- Filters should be honored from plan SCP content is driven via plan
			-- Follows same logic as present in InitContent in SCInterfaceDB.cpp
			IF (@isLocalContentEnabled = 0) AND (@associatedPolicyId > 0) AND (@planId > 0)
			BEGIN
				SET @includePolicyFilters = 1
			END
			SET @unixCtime = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Unix ctime flag' AND modified = 0), 1)
			SET @unixMtime = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Unix mtime flag' AND modified = 0), 1)
			DECLARE @isIndexingV2Client INT = ISNULL((SELECT TOP 1 attrVal FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientID AND attrName = 'IndexingV2' AND modified = 0), 0)
			DECLARE @isLaptopClient INT = ISNULL((SELECT 1 FROM APP_Client WHERE id = @clientID AND (status & 0x1000) = 0x1000), 0)
			DECLARE @defaultOlderVersionsForDays INT
			DECLARE @retentionAvailableOnSubclient INT = @subclientId
			IF @associatedPolicyId > 0
					SET @useSubclientPolicyRetention = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Subclient Policy Has Retention' AND modified = 0), 0)
			IF @associatedPolicyId > 0 AND @useSubclientPolicyRetention > 0
			BEGIN
				SET @retentionAvailableOnSubclient = @associatedPolicyId
			END
			--To support retention on plan we need to send these extended retention properties
IF @isIndexingV2Client = 1 OR @applicationId = 1030
			BEGIN
				SET @extendStoragePolicyRetention = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @retentionAvailableOnSubclient AND attrName = 'Is Turbo Subclient' AND modified = 0)
				SET @archiverRetention = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @retentionAvailableOnSubclient AND attrName = 'Is Archive Retention Mode Enabled' AND modified = 0)
				IF @associatedPolicyId > 0 AND @useSubclientPolicyRetention > 0
				BEGIN
					SET @extendRetentionForNDays = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'User deleted stubs expiration days' AND modified = 0), -1)
				END
				ELSE
				BEGIN
					SET @extendRetentionForNDays = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'User deleted stubs expiration days' AND modified = 0), -1)
				END
				IF @extendRetentionForNDays = -1
					SET @archiverRetentionMode = 2 --NEVER
				ELSE
					SET @archiverRetentionMode = 1 --AFTER
				SET @backupRetention = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @retentionAvailableOnSubclient AND attrName = 'Is Backup Retention Mode Enabled' AND modified = 0)
				SET @afterDeletionKeepItemsForNDays = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @retentionAvailableOnSubclient AND attrName = 'Days to keep items past their expiration' AND modified = 0), 0)
				IF @afterDeletionKeepItemsForNDays >= 0
					SET @backupRetentionMode = 1 --AFTER
				ELSE
					SET @backupRetentionMode = 2 --NEVER
				SET @olderFileVersionsMode = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @retentionAvailableOnSubclient AND attrName = 'Keep older Synth Full Versions' AND modified = 0), 2)
				SET @keepOlderVersionsForNDays = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @retentionAvailableOnSubclient AND attrName = 'Number of Days of Synth Full Versions' AND modified = 0), 30)
				SET @keepVersions = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @retentionAvailableOnSubclient AND attrName = 'Number of Synth Full Versions' AND modified = 0), 0)
				SET @retainPerDayPeriod = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @retentionAvailableOnSubclient AND attrName = 'Retain daily version period' AND modified = 0), 1)
				SET @retainPerWeekPeriod = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @retentionAvailableOnSubclient AND attrName = 'Retain weekly version period' AND modified = 0), 1)
				SET @retainPerMonthPeriod = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @retentionAvailableOnSubclient AND attrName = 'Retain monthly version period' AND modified = 0), 6)
			END
			ELSE
			BEGIN
				SET @keepAtLeastPreviousVersions = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @retentionAvailableOnSubclient AND attrName = 'Number of Synth Full Versions' AND modified = 0)
				SET @keepItemsPastTheirExp = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @retentionAvailableOnSubclient AND attrName = 'Keep items past their expiration' AND modified = 0), 1)
				SET @daysToKeepItems = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @retentionAvailableOnSubclient AND attrName = 'Days to keep items past their expiration' AND modified = 0), 730)
			    SET @useSubclientPolicyRetention = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @retentionAvailableOnSubclient AND attrName = 'Subclient Policy Has Retention' AND modified = 0)
				SET @deleteArchiveJobAfterDays = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @retentionAvailableOnSubclient AND attrName = 'Archived expiration days' AND modified = 0)
				IF @deleteArchiveJobAfterDays <> ''
				BEGIN
					IF @deleteArchiveJobAfterDays = -1
					BEGIN
						SET @deleteArchiveJobAfterDays = 0
						SET @deleteArchiveJob = 2
					END
					ELSE
					BEGIN
						SET @deleteArchiveJob = 1
					END
				END
				SET @userDeletedStubRetentionDays = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @retentionAvailableOnSubclient AND attrName = 'User deleted stubs expiration days' AND modified = 0), -1)
				IF @userDeletedStubRetentionDays = -1
				BEGIN
					SET @userDeletedStubRetention = 2
					SET @userDeletedStubRetentionDays = 0
				END
				ELSE
				BEGIN
					SET @userDeletedStubRetention = 1
				END
			END
			SET @catalogAdditional = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'SRM Data Collection Options' AND modified = 0), 0)
			IF @catalogAdditional = 513
				SET @catalogAdditional = 1
			IF @associatedPolicyId > 0
				SET @catalogACL = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Enable ACL Collection' AND modified = 0)
			ELSE
				SET @catalogACL = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Enable ACL Collection' AND modified = 0)
			SET @useChangeJournal = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Use Change Journal' AND modified = 0), 0)
			SET @useClassicFileScan    = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Use Classic File Scan' AND modified = 0), 0)
			SET @useDCforFSbackups = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Use DC for FS backups' AND modified = 0),0)
			-- set defaults
			IF  @useDCforFSbackups = 0 AND @useClassicFileScan = 0 AND @useChangeJournal = 0
			BEGIN
				IF (EXISTS(SELECT id FROM @WinApptypeId WHERE id = @applicationId ) AND @isNASClient <> 1)
				BEGIN
					IF (SELECT releaseId FROM App_Client WITH (NOLOCK) WHERE id = (SELECT clientId FROM App_Application WITH (NOLOCK) WHERE id = @subclientId)) < 15
						SET @useChangeJournal = 1
					ELSE
						SET @useDCforFSbackups = 1
				END
				ELSE
                    SET @useClassicFileScan = 1
			END
			IF @useChangeJournal = 1 AND @useClassicFileScan = 0 AND @useDCforFSbackups = 0
				SET @scanOption = 0
			IF @useChangeJournal = 0 AND @useClassicFileScan = 1 AND @useDCforFSbackups = 0
			BEGIN
				SET @scanOption = 1
				SET @preserveFileAccessTime	= (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Preserve File Access Times' AND modified = 0)
				SET @checkArchiveBit = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Use Archive Bit' AND modified = 0), @isNASClient)
			END
			IF @useChangeJournal = 0 AND @useClassicFileScan = 0 AND @useDCforFSbackups = 1
				SET @scanOption = 2
			SET @honorArchiverAgentRetention = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Honor Archiver Agent Retention' AND modified = 0)
			IF @keepItemsPastTheirExp = 1 AND @daysToKeepItems = 0			--IMMEDIATELY
			BEGIN
				SET @retentionRule = 1
			END
			ELSE IF @keepItemsPastTheirExp = 1 AND @daysToKeepItems > 0		--AFTER
			BEGIN
				SET @retentionRule = 2
			END
			ELSE IF @keepItemsPastTheirExp = 0								--NEVER
			BEGIN
				SET @retentionRule = 3
			END
			IF @globalFilters = 0 AND @useCSSettingForGF = 0
				SET @useGlobalFilter = 0
			ELSE IF @globalFilters = 1 AND @useCSSettingForGF = 0
				SET @useGlobalFilter = 1
			ELSE IF @globalFilters = 0 AND @useCSSettingForGF = 1
				SET @useGlobalFilter = 2
			SET @backupFilesOnOrAfter = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Only Backup files created or modified on and after' AND modified = 0)
			SET @backupFilesOnOrAfterDate = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Only Backup files created or modified on and after Date' AND modified = 0)
			SET @backupFileTimeZoneName = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Backup File TimeZone Name' AND modified = 0)
			IF @associatedPolicyId > 0
			BEGIN
				SET @deletePSTFileOnly = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Delete PST file only' AND modified = 0)
				SET @enableOCSBackupOnSubclient = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'OCS' AND modified = 0)
				SET @ocsUserName = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'OCS User Name' AND modified = 0)
			END
			ELSE
			BEGIN
				SET @deletePSTFileOnly = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Delete PST file only' AND modified = 0)
				SET @enableOCSBackupOnSubclient = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'OCS' AND modified = 0)
				SET @ocsUserName = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'OCS User Name' AND modified = 0)
			END
			SET @useSCPFilters = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'use SCP filters' AND modified = 0)
			SET @useIncremental = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Use Incremental' AND modified = 0)
			SET @pastExpiryDaysType = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Type of Days to keep items past their expiration' AND modified = 0)
			IF @associatedPolicyId > 0 AND @isLocalArchiveRulesEnabled > 1
			BEGIN
				SET @fileModifiedTimeOlderThan = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Num of Days Old Modified' AND modified = 0)
				SET @fileAccessTimeOlderThan = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Num of Days Old' AND modified = 0)
				SET @fileSizeGreaterThan = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Minimum File Size' AND modified = 0)
				SET @fileCreatedTimeOlderThan = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Num of Days Old Created' AND modified = 0)
				SET @maximumFileSize = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Maximum File Size' AND modified = 0)
				SET @diskCleanupFileTypes = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'DiskCleanup File Types' AND modified = 0)
				SET @enableRedundancyForDataBackedup = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Enable Redundancy For Data Backedup' AND modified = 0)
				SET @startCleaningIfLessThan = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Low Percent Disk Space Free' AND modified = 0)
				SET @stopCleaningIfupto = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Percent Disk Space Free' AND modified = 0)
				SET @dmRulesFlag = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Data Migrator Rule Flag' AND modified = 0)
			END
			ELSE --Plan not associated or local archive rules option set.
			BEGIN
				SET @fileAccessTimeOlderThan = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Num of Days Old' AND modified = 0)
				SET @fileModifiedTimeOlderThan = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Num of Days Old Modified' AND modified = 0)
				SET @fileSizeGreaterThan = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Minimum File Size' AND modified = 0)
				SET @fileCreatedTimeOlderThan = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Num of Days Old Created' AND modified = 0)
				SET @maximumFileSize = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Maximum File Size' AND modified = 0)
				SET @diskCleanupFileTypes = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DiskCleanup File Types' AND modified = 0)
				SET @enableRedundancyForDataBackedup = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Enable Redundancy For Data Backedup' AND modified = 0)
				SET @startCleaningIfLessThan = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Low Percent Disk Space Free' AND modified = 0)
				SET @stopCleaningIfupto = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Percent Disk Space Free' AND modified = 0)
				SET @dmRulesFlag = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Data Migrator Rule Flag' AND modified = 0)
			END
			IF @associatedPolicyId > 0 AND @isLocalArchiveRulesEnabled = 2
			BEGIN
					-- If Archival plan is attached to subclient and useLocalArchivalRules is not enabled then get below properties from plan otherwise from subclient level.
SET @stubRetentionDaysOld = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Stub Retention Time' AND cs_attrName = CHECKSUM(N'Stub Retention Time') AND modified = 0),0)
SET @stubPruningOptions = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Stub pruning Options' AND cs_attrName = CHECKSUM(N'Stub pruning Options') AND modified = 0),0)
			END
			ELSE
			BEGIN
SET @stubRetentionDaysOld = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Stub Retention Time' AND cs_attrName = CHECKSUM(N'Stub Retention Time') AND modified = 0),0)
SET @stubPruningOptions = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Stub pruning Options' AND cs_attrName = CHECKSUM(N'Stub pruning Options') AND modified = 0),0)
			END
			SET @patternMatch = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DiskCleanup Pattern Match' AND modified = 0),'')
			SET @entityMatch = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DiskCleanup Entity Match' AND modified = 0),'')
			SET @diskCleanupOwner = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'DiskCleanup File Owner Info' AND modified = 0)
SET @adHocRules = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'adHoc Archive Rules' AND modified = 0)
SET @adHocOneTimeArchive = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'adHoc One Time Archive' AND modified = 0)
SET @liveCrawlSubClientId = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Live Crawl SubClientId' AND modified = 0)
SET @activateURLCriteria = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Activate URL Criteria' AND modified = 0)
SET @useStoragePolicyRetention = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Use Storage Policy Retention' AND cs_attrName = CHECKSUM(N'Use Storage Policy Retention') AND modified = 0),0)
			IF (@dmRulesFlag & 0x040000) = 0x040000
				SET @archiveReadOnlyFiles = 1
			IF (@dmRulesFlag & 4) = 4
				SET @afterArchivingRule = 2
			ELSE
				SET @afterArchivingRule = 1
			IF ( (@dmRulesFlag IS NULL) OR ((@dmRulesFlag & 2) = 2)) --CV_DM_USE_EITHER_AGE_OR_SIZE_RULE
				SET @rulesToSatisfy = 0 --USE_ALL_RULES
			ELSE
				SET @rulesToSatisfy = 1	--USE_ANY_RULE
			SET @openFileFailureAction = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Snap Failure Action' AND modified = 0)
			SET @vssShadowCopy = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'VSS Destination Volume' AND modified = 0)
			IF @associatedPolicyId > 0
			BEGIN
				SET @isTrueUpOptionEnabledForFS = ISNULL((SELECT attrval FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'Is true up enabled for FS' AND modified = 0),0)
				SET @runTrueUpJobAfterDaysForFS = ISNULL((SELECT attrval FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'run true up after days for FS' AND modified = 0),30)
				SET @runTrueUpJobAfterJobsForFS = ISNULL((SELECT attrval FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @associatedPolicyId AND attrName = 'run true up after jobs for FS' AND modified = 0),0)
			END
			ELSE
			BEGIN
				SET @isTrueUpOptionEnabledForFS = ISNULL((SELECT attrval FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Is true up enabled for FS' AND modified = 0),0)
				SET @runTrueUpJobAfterDaysForFS = ISNULL((SELECT attrval FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'run true up after days for FS' AND modified = 0),30)
				SET @runTrueUpJobAfterJobsForFS = ISNULL((SELECT attrval FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'run true up after jobs for FS' AND modified = 0),0)
			END
			SET @retentionPolicy = ISNULL((SELECT attrval FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Fs Retention Policy ID' AND modified = 0),0)
			SET @enableContentIndexing = ISNULL((SELECT attrval FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Enable Content Indexing' AND modified = 0),0)
			SET @contentIndexingPolicy = ISNULL((SELECT attrval FROM APP_SubClientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Content Indexing Policy ID' AND modified = 0),0)
			SET @hcNodesXml = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Healthcare Systems' AND modified = 0)
			-- Set if synthfull jobs are run after Onepass is enabled. Classic archiver does not support synthfull jobs.
			IF @enableOnePass = 1
			BEGIN
			        INSERT INTO @OnePassSynthFullJobInfo
			                SELECT  jobId
			                FROM JMBkpStats JS
			                JOIN APP_SubClientProp SP
			                ON JS.appId = SP.componentNameId
			                WHERE JS.appId = @subclientId AND SP.created < JS.servStartDate AND SP.modified = 0 AND JS.opType = 14 AND SP.attrName = 'Is turbo Subclient'
			        IF EXISTS ( SELECT * FROM @OnePassSynthFullJobInfo )
			                SET @isSynthfullRunAfterOnePassEnabledOnSubclient = 1
			END
			SET @isSnapCenterSubclient = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Snap Center Subclient' AND modified = 0)
			SET @deleteFilesWithoutBackup = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'NoBackupOnlyDelete' AND cs_attrName = CHECKSUM(N'NoBackupOnlyDelete') AND modified = 0)
		END
		IF @propertyLevel >= 20
		BEGIN
			SELECT @clientID = clientId FROM App_Application WITH (NOLOCK) WHERE id = @subclientId
			--Construct output XML
			SET	@xmlResult =
							(SELECT
									(SELECT	@useVSS AS '@useVSS',
											@vssOptions AS '@vssOptions',
											@useVssForAllFilesOptions AS '@useVssForAllFilesOptions',
											@unixCtime As '@unixCtime',
											@unixMtime As '@unixMtime',
											@backupSystemState AS '@backupSystemState',
											@backupSystemStateforFullBkpOnly  AS '@backupSystemStateforFullBkpOnly',
											@backupFilesQualifiedForArchive AS '@backupFilesQualifiedForArchive',
											@useVSSForSystemState AS '@useVSSForSystemState',
											@useGlobalFilter AS '@useGlobalFilters',
											@includePolicyFilters AS '@includePolicyFilters',
											@isDDBSubclient As '@isDDBSubclient',
											@oneTouchSubclient AS '@oneTouchSubclient',
											@oneTouchServerDirectory AS '@oneTouchServerDirectory',
											@honorArchiverAgentRetention AS '@honorArchiverAgentRetention',
											@retentionRule AS '@retentionRule',
											@enableOnePass AS '@enableOnePass',
											@daysToKeepItems AS '@daysToKeepItems',
											@deleteArchiveJobAfterDays AS '@deleteArchiveJobAfterDays',
											@deleteArchiveJob AS '@deleteArchiveJob',
											@userDeletedStubRetentionDays AS '@userDeletedStubRetentionDays',
											@userDeletedStubRetention AS '@userDeletedStubRetention',
											@catalogAdditional AS '@catalogAdditional',
											@catalogACL AS '@catalogACL',
											@scanOption AS '@scanOption',
											@preserveFileAccessTime AS '@preserveFileAccessTime',
											@checkArchiveBit AS '@checkArchiveBit',
											@backupFilesOnOrAfter AS '@backupFilesOnOrAfter',
											@backupFileTimeZoneName AS '@backupFileTimeZoneName',
											@keepAtLeastPreviousVersions AS '@keepAtLeastPreviousVersions',
                                            @useSubclientPolicyRetention AS '@useSubclientPolicyRetention',
											@extendStoragePolicyRetention AS '@extendStoragePolicyRetention',
											@archiverRetention AS '@archiverRetention',
											@archiverRetentionMode AS '@archiverRetentionMode',
											@extendRetentionForNDays AS '@extendRetentionForNDays',
											@useStoragePolicyRetention AS '@useStoragePolicyRetention',
											@backupRetention AS '@backupRetention',
											@backupRetentionMode AS '@backupRetentionMode',
											@afterDeletionKeepItemsForNDays AS '@afterDeletionKeepItemsForNDays',
											@olderFileVersionsMode AS '@olderFileVersionsMode',
											@keepOlderVersionsForNDays AS '@keepOlderVersionsForNDays',
											@keepVersions AS '@keepVersions',
											@retainPerDayPeriod AS '@retainPerDayPeriod',
											@retainPerWeekPeriod AS '@retainPerWeekPeriod',
											@retainPerMonthPeriod AS '@retainPerMonthPeriod',
											@deletePSTFileOnly AS '@deletePSTFileOnly',
											@enableOCSBackupOnSubclient AS '@enableOCSBackupOnSubclient',
											@useSCPFilters AS '@useSCPFilters',
											@useIncremental AS '@useIncremental',
											@pastExpiryDaysType AS '@pastExpiryDaysType',
											@diskCleanupModified AS '@diskCleanupModified',
											@vssShadowCopy AS '@vssShadowCopy',
											@blockLevelBackup AS '@blockLevelBackup',
											@createFileLevelIndexDuringBackup AS '@createFileLevelIndexDuringBackup',
											@blockLevelSPOSBackup AS '@blockLevelSPOSBackup',
											@backupSaveFileData AS '@backupSaveFileData',
											@backupSpooledFileData AS '@backupSpooledFileData',
											@backupQueueData AS '@backupQueueData',
											@backupPrivateAuthority AS '@backupPrivateAuthority',
											@targetReleaseForBackupData AS '@targetReleaseForBackupData',
											@syncAllLibForBackup AS '@syncAllLibForBackup',
											@activeWaitTime	AS '@activeWaitTime',
											@syncQueue AS '@syncQueue',
											@txtlibSyncCheckPoint AS '@txtlibSyncCheckPoint',
											@customSubclientFlag AS '@customSubclientFlag',
											@customSubclientContentFlags AS '@customSubclientContentFlags',
											@isTrueUpOptionEnabledForFS AS '@isTrueUpOptionEnabledForFS',
											@runTrueUpJobAfterDaysForFS AS '@runTrueUpJobAfterDaysForFS',
											@runTrueUpJobAfterJobsForFS AS	'@runTrueUpJobAfterJobsForFS',
											@retentionPolicy AS '@retentionPolicy',
											@enableContentIndexing AS '@enableContentIndexing',
											@contentIndexingPolicy AS '@contentIndexingPolicy',
											@backupAsObjects AS '@backupAsObjects',
											@saveWhileActiveOpt AS '@saveWhileActiveOpt',
											@isSynthfullRunAfterOnePassEnabledOnSubclient AS '@isSynthfullRunAfterOnePassEnabledOnSubclient',
											@saveAccessPath AS '@saveAccessPath',
											@enableFolderLevelMultiThread AS '@enableFolderLevelMultiThread',
											@folderLevelThreadCount AS '@folderLevelThreadCount',
											@backupFilesAsExtents AS '@backupFilesAsExtents',
											@extentSize AS '@extentSize',
											@bigFileSize AS '@bigFileSize',
											@updateHistory AS '@updateHistory',
											@genSignatureOnIBMi AS '@genSignatureOnIBMi',
											@ibmiCompression AS '@ibmiCompression',
											@openvmsBackupDate AS '@openvmsBackupDate',
											@usedIBMIASPContent AS '@usedIBMIASPContent',
											@forcedArchiving AS '@forcedArchiving',
											@isSnapCenterSubclient AS '@isSnapCenterSubclient',
											@isManualDDBSubclient AS '@isManualDDBSubclient',
											@enableNetworkShareAutoMount AS '@enableNetworkShareAutoMount',
											@backupHDFSACLs AS '@backupHdfsACLs',
											@isAccessTimeCollected AS '@isAccessTimeCollected',
											@deleteFilesWithoutBackup AS '@deleteFilesWithoutBackup',
											(SELECT path AS '@val'
													FROM @autoMountCommandOptions
													FOR XML PATH('autoMountCommandOptions'),TYPE),
											(SELECT @enableArchivingWithRules AS '@enableArchivingWithRules',
													@startCleaningIfLessThan AS '@startCleaningIfLessThan',
													@stopCleaningIfupto AS '@stopCleaningIfupto',
													@fileAccessTimeOlderThan AS '@fileAccessTimeOlderThan',
													@fileModifiedTimeOlderThan AS '@fileModifiedTimeOlderThan',
													@fileCreatedTimeOlderThan AS '@fileCreatedTimeOlderThan',
													@fileSizeGreaterThan AS '@fileSizeGreaterThan',
													@maximumFileSize AS '@maximumFileSize',
													@archiveReadOnlyFiles AS '@archiveReadOnlyFiles',
													@afterArchivingRule AS '@afterArchivingRule',
													@rulesToSatisfy	AS '@rulesToSatisfy' ,
													@stubRetentionDaysOld AS '@stubRetentionDaysOld',
													@stubPruningOptions AS '@stubPruningOptions',
													@useNativeSnapshotToPreserveFileAccessTime AS '@useNativeSnapshotToPreserveFileAccessTime',
													@patternMatch AS '@patternMatch',
													@entityMatch AS '@entityMatch',
													@enableRedundancyForDataBackedup AS '@enableRedundancyForDataBackedup',
													@diskCleanupOwner AS '@diskCleanupOwner',
													@adHocRules AS '@adHocRules',
													@adHocOneTimeArchive AS '@adHocOneTimeArchive',
													@liveCrawlSubClientId AS '@liveCrawlSubClientId',
													@activateURLCriteria AS '@activateURLCriteria',
													(SELECT @diskCleanupFileTypes.query('/App_DiskCleanupFileTypes/*')
														FOR XML PATH('diskCleanupFileTypes'), TYPE)
												FOR XML PATH('diskCleanupRules'),TYPE),
											(SELECT @ocsUserName AS '@userName'
												FOR XML PATH('ocsUserName'),TYPE),
											(SELECT @backupFilesOnOrAfterDate as '@time',
													55 AS '@_type_'
												FOR XML PATH('backupFilesOnOrAfterDate'), TYPE),
											(SELECT	@oneTouchServer AS '@clientId',
													@oneTouchServerName AS '@clientName',
													3 AS '@_type_'
													FOR XML PATH('oneTouchServer'),TYPE),
											(SELECT @SRBootServerDir AS '@SRBootServerDir',
													@DVDImageFileFormat AS '@DVDImageFileFormat',
													@backupMaxTime AS '@backupMaxTime',
													@notifyuser AS '@notifyuser',
													@notifyDelay AS '@notifyDelay',
													@notifyMessage AS '@notifyMessage',
													@userCommand AS '@userCommand',
													@userProgram AS '@userProgram',
													@userIPLProgram AS '@userIPLProgram',
													@saveSecData AS '@saveSecData',
													@saveConfObject AS '@saveConfObject',
													@printSysInfo AS '@printSysInfo',
													(SELECT
														x.App_IBMIDRBackupLibraryPath.value('@path', 'varchar(max)') AS '@path'
														from @ibmiDRLibrary.nodes('*') x(App_IBMIDRBackupLibraryPath)
														FOR XML PATH('library'), TYPE)
												FOR XML PATH('ibmiSubclientprop'),TYPE),
											(SELECT @edIsIndefiniteRetention AS '@isIndefiniteRetention',
													@edRetentionInDays AS '@retentionInDays',
													@edEnableRetentionRulesForVersions AS '@enableRetentionRulesForVersions',
													@edMinNoOfVersions AS '@minNoOfVersions',
													@edVersionsRetentionInDays AS '@versionsRetentionInDays'
												FOR XML PATH('edgeSubclientPolicyProp'),TYPE),
											(SELECT @backupConfiguration.query('/App_BackupConfigurationNodes/*')
												FOR XML PATH('backupConfiguration'), TYPE),
											(SELECT @backupConfigurationIDA.query('/App_BackupConfigurationNodes/*')
												FOR XML PATH('backupConfigurationIDA'), TYPE),
											(SELECT
													SUBS.SubStoreId AS '@SubStoreId',
													SUBS.SIDBStoreId AS 'subStoreAssociations/@sidbStoreId',
													SUBS.ClientId AS 'subStoreAssociations/@clientId',
													SUBS.DDBSubclientId AS 'subStoreAssociations/@subclientId',
													IAP.path AS 'path/@path'
											FROM IdxSIDBSubStore SUBS WITH (NOLOCK) INNER JOIN IdxAccessPath IAP WITH (NOLOCK) ON IAP.IdxAccessPathId = SUBS.IdxAccessPathId
											WHERE SUBS.DDBSubClientId =  @subclientId AND SUBS.ClientId = @clientID AND SUBS.SealedTime = 0 AND @isManualDDBSubclient = 1
											FOR XML PATH('assignedDDBStores'), TYPE),
											(SELECT
													SUBS.SubStoreId AS '@SubStoreId',
													SUBS.SIDBStoreId AS 'subStoreAssociations/@sidbStoreId',
													SUBS.ClientId AS 'subStoreAssociations/@clientId',
													SUBS.DDBSubclientId AS 'subStoreAssociations/@subclientId',
													IAP.path AS 'path/@path'
											FROM IdxSIDBSubStore SUBS WITH (NOLOCK) INNER JOIN IdxAccessPath IAP WITH (NOLOCK) ON IAP.IdxAccessPathId = SUBS.IdxAccessPathId
											WHERE SUBS.DDBSubClientId =  0 AND SUBS.ClientId = @clientID AND SUBS.SealedTime = 0 AND @isDDBSubclient = 1
											FOR XML PATH('availableDDBStores'), TYPE)
										FOR XML PATH('fsSubClientProp'),TYPE),
										(SELECT content AS '@path'
												FROM @FSContentInfo AS fsContentInfo
												WHERE fsContentInfo.contentType = 1
										FOR XML PATH('content'),TYPE),
										(SELECT content AS '@excludePath'
												FROM @FSContentInfo AS fsContentInfo
												WHERE fsContentInfo.contentType = 3
										FOR XML PATH('content'),TYPE),
										(SELECT content AS '@includePath'
												FROM @FSContentInfo AS fsContentInfo
												WHERE fsContentInfo.contentType = 2
										FOR XML PATH('content'),TYPE),
										(SELECT content AS '@subclientPolicyPath'
												FROM @FSSCPContentInfo AS fsScpContentInfo
												WHERE fsScpContentInfo.contentType = 1
										FOR XML PATH('content'),TYPE),
										(SELECT content AS '@subclientPolicyExcludePath'
												FROM @FSSCPContentInfo AS fsScpContentInfo
												WHERE fsScpContentInfo.contentType = 3
										FOR XML PATH('content'),TYPE),
										(SELECT content AS '@subclientPolicyIncludePath'
												FROM @FSSCPContentInfo AS fsScpContentInfo
												WHERE fsScpContentInfo.contentType = 2
										FOR XML PATH('content'),TYPE),
										(SELECT
											(SELECT symLink.path AS '@path',
														(SELECT symLink.link AS '@val'
														FOR XML PATH('symbolicLinks'),TYPE)
												FOR XML PATH('symLinkContent'),TYPE)
												FROM @FSSymLinkContentInfo AS symLink
										FOR XML PATH('content'),TYPE),
										(SELECT
												@impersonateUser AS '@userName'
										FOR XML PATH('impersonateUser'),TYPE),
										(SELECT
												@useGPFSSnapshot as '@useGPFSSnapshot',
												@hadoopAppType as '@hadoopAppType'
										FOR XML PATH('dfsSubclientProps'), TYPE),
										(SELECT @daNodesXml.query('/App_DataAccessNodes/*')
										FOR XML PATH('distributedDataAccessNodes'), TYPE),
										(SELECT @hcNodesXml.query('/App_HCSubclientProp/*')
										FOR XML PATH('hcSubclientProp'), TYPE),
										(SELECT @cassandraXml.query('/App_CassandraSubclientProps/*')
										FOR XML PATH('cassandraProps'), TYPE),
										(SELECT @splunkXml.query('/App_SplunkSubclientProps/*')
										FOR XML PATH('splunkProps'), TYPE)
							FOR XML PATH('FSSubClientProp'), TYPE)
		END
	END
	--Gather NAS FS properties
IF( ( @applicationId = 13 OR  @applicationId = 41 ) AND @propertyLevel >= 30)
	BEGIN
			SET @backupConfiguration = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = 'Backup Configuration Nodes' AND modified = 0)
			IF(@backupConfiguration IS NULL OR @backupConfiguration.exist('/App_BackupConfigurationNodes/backupDataAccessNodes') = 0)
			BEGIN
				SET @backupConfigurationIDA = ( SELECT idaProp.attrVal FROM APP_IDAName ida
				INNER JOIN  APP_Application s ON s.appTypeId=ida.appTypeId AND s.clientId=ida.clientId
					 INNER join APP_IDAProp idaProp ON idaProp.componentNameId=ida.id AND attrName= 'Backup Configuration Nodes' AND idaprop.modified=0
				WHERE s.ID= @subclientId
			)
			END
			INSERT	INTO @NASContentInfo
			SELECT type, fileName FROM APP_ScFilterFile WITH (NOLOCK)
			WHERE componentNameId = @subclientId and modified = 0
			--Construct output XML
			SET	@xmlResult =
							(SELECT
									(SELECT
										(SELECT content AS '@path'
												FROM @NASContentInfo AS nasContentInfo
												WHERE nasContentInfo.contentType = 1
										FOR XML PATH('content'),TYPE),
										(SELECT content AS '@excludePath'
												FROM @NASContentInfo AS nasContentInfo
												WHERE nasContentInfo.contentType = 3
										FOR XML PATH('content'),TYPE),
										(SELECT
												@impersonateUser AS '@userName'
										FOR XML PATH('impersonateUser'),TYPE),
										(SELECT (SELECT @backupConfiguration.query('/App_BackupConfigurationNodes/*')
										FOR XML PATH('backupConfiguration'), TYPE),
										(SELECT @backupConfigurationIDA.query('/App_BackupConfigurationNodes/*')
										FOR XML PATH('backupConfigurationIDA'), TYPE)
										FOR XML PATH('fsSubClientProp'), TYPE)
							FOR XML PATH('FSSubClientProp'), TYPE))
	END
	--Gather FS properties Reused by SQL, we only use excludePath (APP_ScFilterFile.type = 3) at present.
IF(@applicationId = 81 AND @propertyLevel >= 30)
	BEGIN
			INSERT	INTO @SQLContentInfo
			SELECT fileName FROM APP_ScFilterFile WITH (NOLOCK)
			WHERE componentNameId = @subclientId and type = 3 and modified = 0
			--Construct output XML
			SET	@xmlResult =
							(SELECT
								(SELECT content AS '@excludePath'
								 FROM @SQLContentInfo AS sqlContentInfo
								 FOR XML PATH('content'),TYPE)
							FOR XML PATH('FSSubClientProp'), TYPE)
	END
--SET @xmlResult.modify('delete /FSSubClientProp[empty(./*) and not(./@*)]')
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetSubclientFsIDAProperties')
	delete from GxQscripts where name = 'APPGetSubclientFsIDAProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetSubclientFsIDAProperties')
	delete from GXDBVersions where aliasname = 'APPGetSubclientFsIDAProperties'
GO

insert into GXDBVersions values(2, 'APPGetSubclientFsIDAProperties',  '00000000000000000000', 'APPGetSubclientFsIDAProperties', '00000000000000000000')
GO

