

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetSubclientAdvancedIndexingProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetSubclientAdvancedIndexingProperties')
BEGIN
	print '>>> Drop Stored Procedure: APPGetSubclientAdvancedIndexingProperties <<<'
	drop procedure APPGetSubclientAdvancedIndexingProperties
END
IF EXISTS (select * from GxQscripts where name='APPGetSubclientAdvancedIndexingProperties')
	delete from GxQscripts where name = 'APPGetSubclientAdvancedIndexingProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetSubclientAdvancedIndexingProperties')
	delete from GXDBVersions where aliasname = 'APPGetSubclientAdvancedIndexingProperties'
GO
print '... Creating Procedure: APPGetSubclientAdvancedIndexingProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetSubclientAdvancedIndexingProperties
  @subclientId INT,
  @propertyLevel INT,
  @userId INT,
  @xmlResult XML OUTPUT, 
  @mode INTEGER
AS
--Gather SubClient Advanced Indexing properties------------------------------------------------------------------------
	DECLARE @indexServerId				INT
	DECLARE @indexServerName			NVARCHAR(MAX)
	DECLARE @ciPolicyId					INT
	DECLARE @isAdvancedIndexingEnabled	INT
	DECLARE @indexingMessage			NVARCHAR(MAX)
	DECLARE @ciPolicyName				NVARCHAR(MAX)
	SET @isAdvancedIndexingEnabled = (SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Advanced indexing status' AND modified = 0 AND cs_attrName=CHECKSUM(N'Advanced indexing status'))
	--IF @propertyLevel>=5
	--BEGIN
	--
	--
	--END
	--
	--IF @propertyLevel >= 10
	--BEGIN
	--
	--
    --
	--END
	--IF @propertyLevel >= 20
	--
	--
	--END
	IF @propertyLevel >= 30
	BEGIN
		-- APP.x - AdvancedIndexingInfo->Indexingstatus->ENABLED
		IF (@isAdvancedIndexingEnabled = 1)
		BEGIN
			SET @indexServerId = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Associated index server id' AND modified = 0 AND cs_attrName=CHECKSUM(N'Associated index server id')), 0)
			SELECT @indexServerName=displayName FROM APP_Client WITH (NOLOCK) WHERE id=@indexServerId
			SET @ciPolicyId = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Indexing Configuration Policy' AND modified = 0 AND cs_attrName=CHECKSUM(N'Indexing Configuration Policy')), 0)
			SET @ciPolicyName = ISNULL((SELECT policyName FROM APP_ConfigurationPolicy WITH (NOLOCK) WHERE policyId = @ciPolicyId), 0)
		END
		ELSE IF (@isAdvancedIndexingEnabled IN (0,2))
		BEGIN
			-- SETUP_IN_PROGRESS OR NOT_APPLICABLE
			SET @indexingMessage = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @subclientId AND attrName = N'Advanced indexing status message' AND modified = 0 AND cs_attrName=CHECKSUM(N'Advanced indexing status message')), '')
		END
	END
	SET @xmlResult = (SELECT CASE WHEN @isAdvancedIndexingEnabled IS NOT NULL THEN
				(SELECT
				(SELECT
					@isAdvancedIndexingEnabled AS '@indexingStatus', @indexingMessage AS '@indexingStatusMessage',
					(SELECT
							@indexServerId AS '@clientId',
							@indexServerName AS '@displayName'
						FOR XML PATH('indexServer'),TYPE),
(SELECT  @ciPolicyId AS '@policyId', @ciPolicyName AS '@policyName', 154 AS '@_type_'
											FOR XML PATH('configPolicy'), TYPE)
				FOR XML PATH('indexingInfo'),TYPE)
		FOR XML PATH('subclientAdvancedIndexingProperties'),TYPE)
			ELSE NULL END)
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetSubclientAdvancedIndexingProperties')
	delete from GxQscripts where name = 'APPGetSubclientAdvancedIndexingProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetSubclientAdvancedIndexingProperties')
	delete from GXDBVersions where aliasname = 'APPGetSubclientAdvancedIndexingProperties'
GO

insert into GXDBVersions values(2, 'APPGetSubclientAdvancedIndexingProperties',  '00000000000000000000', 'APPGetSubclientAdvancedIndexingProperties', '00000000000000000000')
GO

