

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetSubClientPolicies.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   04/04/2008
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetSubClientPolicies.sp,v $ $Id: APPGetSubClientPolicies.sp,v 1.9.190.2 2018/03/22 01:51:23 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetSubClientPolicies <<<'

IF EXISTS (select * from sysobjects where name='APPGetSubClientPolicies')
	drop procedure APPGetSubClientPolicies
IF EXISTS (select * from GxQscripts where name='APPGetSubClientPolicies')
	delete from GxQscripts where name = 'APPGetSubClientPolicies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetSubClientPolicies')
	delete from GXDBVersions where aliasname = 'APPGetSubClientPolicies'
GO
print '... Creating Procedure: APPGetSubClientPolicies'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetSubClientPolicies
  @i_xmlText XML,
  @i_userId INT=0,
  @i_localId INT=0,
  @o_xmlText XML	OUTPUT
AS
	DECLARE	@o_ErrorCode		INT=0
	DECLARE	@o_ErrorString		NVARCHAR(1024)
BEGIN
	DECLARE @i_clientId		INT
	DECLARE @i_instanceId	INT
	DECLARE @allAssociations int
	DECLARE @policyTable TABLE (backupSet int, name nvarchar(128), scpId int, spName nvarchar(128), allow int)
	if @i_userId = 0
	begin
		set @i_userId = 1
	end
	SET @i_clientId = ISNULL (( SELECT ref.value('@clientId', 'INT')
					FROM @i_xmlText.nodes ('EVGui_GetBackupsetSCPolicyAssociation/client') R(ref)), 0)
	SET @i_instanceId = (SELECT TOP 1 id from APP_InstanceName where name = 'DefaultInstanceName')
	SET @i_instanceId = ISNULL (( SELECT ref.value('@instanceId', 'INT')
					FROM @i_xmlText.nodes ('EVGui_GetBackupsetSCPolicyAssociation/client') R(ref)), @i_instanceId)
	IF @i_clientId > 0
	BEGIN
		INSERT INTO @policyTable
		EXEC APPGetTreeViewForSCP @i_clientId, @i_instanceId, 0, 1
		set @allAssociations = 0
		-- Now filter entities which user cant see.
		IF OBJECT_ID('tempdb.dbo.#ScEntitiesWithCapability') IS NOT null
			DROP TABLE #ScEntitiesWithCapability
create table  #ScEntitiesWithCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		EXEC sec_getUserObjects @i_userId, 0, 0, '#ScEntitiesWithCapability'
		if exists(select 1 from #ScEntitiesWithCapability sec
WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
				)
		begin
			SET @allAssociations = 1
		end
		-- Nothing to delete if the user has all associations set.
		if @allAssociations = 0
		begin
			declare @tempSPOutputTable table
			(
				output xml
			)
			declare @allBackupsets table
			(
				backupsetID int
			)
			--Execute getAssociatedEntities proc to find out all backupsets which user can access
			declare @getAssociatedEntities xml
			declare @entity xml
			declare @processingInstructionInfo xml
			set @entity = '<entity clientId = "'+convert(nvarchar(max),@i_clientId) + '" appGroupId = "35"/>' -- for retreiving file system backupsets
			set @processingInstructionInfo = '<processinginstructioninfo><user userId="'+convert(nvarchar(max),@i_userId)+'"/>'+
				'<locale localeId="'+convert(nvarchar(max),@i_localId)+'"/></processinginstructioninfo>'
			set @getAssociatedEntities = (
					select 6 '@expandLevel', --DB_EntityType_BACKUPSET_ENTITY
						@entity,
						@processingInstructionInfo
					for xml path ('App_GetAssociatedEntities')
				)
			Insert into @tempSPOutputTable
			exec dbo.GetAssociatedEntities @getAssociatedEntities
			--Retreive backupsets for this client.
			set @getAssociatedEntities = ISNull((select top 1 output from @tempSPOutputTable),'<App_GenericResponse/>')
			Insert into @allBackupsets
			SELECT ISNULL(Tbl.Col.value('@backupsetId', 'int'),0) as BackupsetId
			FROM @getAssociatedEntities.nodes('App_GenericResponse/response/entity') as Tbl(Col)
			-- Now delete backupsets returned from APPGetTreeViewForSCP which are not visible
			delete from @policyTable
			where backupset not in
			(
				select backupsetID from @allBackupsets
			)
			-- Also delete subclient policies which are not visible.
			delete from @policyTable
			where backupset not in
			(
				select backupsetID from @allBackupsets
			)
		end
		/*
		select componentnameId from App_backupsetprop
				where attrname='Subclient Policy Create UserId'
				and attrval = convert(nvarchar(max),@i_userId)
				and modified = 0
		*/
		SET @o_xmlText = (
			SELECT T.allow '@associationAllowed', (
SELECT 7 '@_type_', T.id '@backupsetId', T.name '@backupsetName', T.clientId '@clientId',
						T.instance '@instanceId', T.appTypeId '@applicationId'
						FOR XML PATH ('subClientInfo'), TYPE),
(SELECT 65 '@_type_', BP.attrVal '@subclientPolicyId', T.spName '@subclientPolicyName'
						FROM APP_BackupSetProp BP
						WHERE BP.attrName='Associated subclient Policy' AND BP.componentNameId=T.backupSet AND BP.modified=0
						FOR XML PATH ('scPolicy'), TYPE)
				FROM (SELECT DISTINCT BS.id, BS.name, APP.clientId, APP.instance , APP.appTypeId, PT.allow, PT.spName, PT.backupSet
						FROM @policyTable AS PT
						INNER JOIN APP_Application APP ON APP.backupSet=PT.backupSet
				 INNER JOIN APP_BackupSetName BS ON BS.id=APP.backupSet
					 ) T
		FOR XML PATH('associations'),
		ROOT('EVGui_GetBackupsetSCPolicyAssociationResp'))
		IF @o_xmlText IS NULL
			SET @o_xmlText = '<EVGui_GetBackupsetSCPolicyAssociationResp/>'
	END
	ELSE
	BEGIN
SET @o_ErrorString = DBO.fn_EvFormatEventMsgText(0, @i_localId, (33 | (CAST(POWER(2, 24) AS BIGINT) * 4)), 0, 2)
		SET @o_xmlText = ( SELECT
				( SELECT @o_ErrorCode '@errorCode', @o_ErrorString '@errorString'
					FOR XML PATH('error'), TYPE
				)
		FOR XML PATH(''),
		ROOT('EVGui_GenericResp'))
	END
EXIT_PROC:
	SELECT @o_xmlText
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'APPGetSubClientPolicies')
	delete from GxQscripts where name = 'APPGetSubClientPolicies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetSubClientPolicies')
	delete from GXDBVersions where aliasname = 'APPGetSubClientPolicies'
GO

insert into GXDBVersions values(2, 'APPGetSubClientPolicies',  '00010009019000020000', 'APPGetSubClientPolicies', '00010009019000020000')
GO

