

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetServerClientList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetServerClientList.sp,v $ $Id: APPGetServerClientList.sp,v 1.1.2.10 2020/05/06 16:15:52 xsui Exp $";
--	+===================================================================+
--	| APPGetServerClientList - Get Server Client list 					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetServerClientList')
BEGIN
	print '>>> Drop Stored Procedure: APPGetServerClientList <<<'
	drop procedure APPGetServerClientList
END
IF EXISTS (select * from GxQscripts where name='APPGetServerClientList')
	delete from GxQscripts where name = 'APPGetServerClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetServerClientList')
	delete from GXDBVersions where aliasname = 'APPGetServerClientList'
GO
print '... Creating Procedure: APPGetServerClientList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetServerClientList
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @xmlString XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN TRY
	DECLARE @userId INT
	DECLARE @i_clientId INT
	DECLARE @errorCode AS INTEGER = 0
	DECLARE @errorString AS VARCHAR(2048) = ''
	DECLARE @packages AS NVARCHAR(1024) = ''
	DECLARE @isProxyRequired AS INT
	DECLARE @ifIncludeOnlyPackageInstalledMachines AS INT
	SET @userId = ISNULL((
				SELECT ref.value('@userId', 'INT')
				FROM @xmlString.nodes('Api_GetServerClientRequest/user') R(ref)
				), 0)
	SET @i_clientId = ISNULL((
				SELECT ref.value('@clientId', 'INT')
				FROM @xmlString.nodes('Api_GetServerClientRequest') R(ref)
				), 0)
	SET @packages = ISNULL((
				SELECT ref.value('@packageIds', 'nvarchar(max)')
				FROM @xmlString.nodes('Api_GetServerClientRequest') R(ref)
				), '20,23,51,726,251,252,255,257')
	SET @isProxyRequired = ISNULL((
				SELECT ref.value('@ifIncludeProxy', 'INT')
				FROM @xmlString.nodes('Api_GetServerClientRequest') R(ref)
				), 1)
	SET @ifIncludeOnlyPackageInstalledMachines = ISNULL((
				SELECT ref.value('@ifIncludeOnlyPackageInstalledMachines', 'INT')
				FROM @xmlString.nodes('Api_GetServerClientRequest') R(ref)
				), 0)
	DECLARE @r_clientId INTEGER
	DECLARE @r_appTypeID INTEGER
	DECLARE @xmlText XML;
	DECLARE @r_simLicenseAppType INT;
	DECLARE @r_AgentVersion NVARCHAR(MAX);
	DECLARE @r_installDate NVARCHAR(MAX);
	DECLARE @associatedEntitiesReq XML
	IF object_id('tempdb.dbo.#FinalAgentPropList') IS NOT NULL
		DROP TABLE #FinalAgentPropList
	CREATE TABLE #FinalAgentPropList (
		appTypeID INT,
		appName VARCHAR(255),
		AgentVersion NVARCHAR(MAX),
		installDate NVARCHAR(MAX),
		patchStatus INT,
		isMarkedDeleted INT,
		clientId INT,
		clientName NVARCHAR(255),
		simLicenseAppType INT,
		IdaActivityControl XML
		)
	CREATE CLUSTERED INDEX FileAgentPropList_idx1 ON #FinalAgentPropList (clientId, appTypeID)
	DECLARE @VersionAndPatch TABLE (
		Release NVARCHAR(MAX),
		Build NVARCHAR(MAX),
		ReleaseAndBuild NVARCHAR(MAX),
		releaseId INT,
		installDate INT
		)
	IF object_id('tempdb.dbo.#i_clientList') IS NOT NULL
		DROP TABLE #i_clientList
	CREATE TABLE #i_clientList (
		id INT IDENTITY(1, 1) ,--PRIMARY KEY,
		clientId INT,
		clientName NVARCHAR(510),
		appTypeId INT,
		appTypeName NVARCHAR(255),
		errorCode INT,
		errorString NVARCHAR(max)
		)
	IF object_id('tempdb.dbo.#FinalServerClientList') IS NOT NULL
		DROP TABLE #FinalServerClientList
	CREATE TABLE #FinalServerClientList (
		cId INT NOT NULL,
		cName NVARCHAR(255),
		cHostName NVARCHAR(255),
		roleName VARCHAR(50),
		isClientDeconfigured    int not null,
		isMAForClientDeconfigured       int not null
		PRIMARY KEY(cId, roleName)
		)
	DECLARE @isAllAssociationsSet BIGINT
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF object_id('tempdb.dbo.#ClientCap') IS NOT NULL
		DROP TABLE #ClientCap
create table  #ClientCap ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 0, 0, '#ClientCap'
	DELETE #ClientCap
		WHERE clientGroupId <> 0 OR mediaAgentId <> 0 OR libraryID <> 0 OR archGroupID <> 0 OR vtContainerId <> 0 OR vtPolicyId <> 0 OR vtShelfId <> 0
			  OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0 OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0  OR taskId <> 0
			  OR workflowId <> 0 OR logMonitoringPolicyId <> 0 OR arrayId <> 0
			  OR cloudId <> 0 OR userGroupId <> 0 OR providerId <> 0 OR entityId1 <> 0
			  OR entityId2 <> 0 OR entityId3 <> 0 OR entityId4 <> 0 OR entityId5 <> 0
			  OR entityId6 <> 0 OR entityId7 <> 0 OR entityId8 <> 0 OR entityId9 <> 0
	IF EXISTS(
	SELECT 1 FROM #ClientCap sec
	WHERE
((sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
	)
	BEGIN
		SET @isAllAssociationsSet = 1
	END
IF (0 = @i_clientId)
	BEGIN
		--to get CommServe,Web Server,Web Console,VWeb PackageGroups.
		INSERT INTO #FinalServerClientList
		SELECT c.id,
			c.NAME,
			c.net_hostname,
			sp.DisplayName,
			ISNULL(CAST(acpcs.attrVal AS INT), 2),
			ISNULL(CAST(acpma.attrVal AS INT), 2)
		FROM APP_Client c
		INNER JOIN App_Platform P ON C.id = P.clientId
AND P.platformType = 4
			AND (C.specialClientFlags = 0)
		-- and status & 4096 <> 4096
		INNER JOIN simInstalledPackages sim ON c.id = sim.ClientId
			AND sim.simPackageID IN (
				SELECT _ID
				FROM SplitIDString(@packages)
				)
		INNER JOIN simPackage sp ON sp.id = sim.simPackageID
		LEFT OUTER JOIN APP_ClientProp acpcs ON
			acpcs.componentNameId = c.id
			AND acpcs.modified = 0
			AND acpcs.attrName = 'PlatformDeleted 4'
			AND ISNUMERIC(acpcs.attrVal) = 1
		LEFT OUTER JOIN APP_ClientProp acpma ON
			acpma.componentNameId = c.id
			AND acpma.modified = 0
			AND acpma.attrName = 'PlatformDeleted 2'
			AND ISNUMERIC(acpma.attrVal) = 1
		WHERE (
				(@isAllAssociationsSet = 1)
				OR EXISTS (
					SELECT 1
					FROM #ClientCap sec
					WHERE sec.clientId = c.Id
					)
				)
			AND sim.simPackageID IS NOT NULL
			AND sp.DisplayName IS NOT NULL
		UNION ALL
		SELECT c.id,
			c.NAME,
			c.net_hostname,
			CASE
				WHEN isDMZ = 1
					THEN 'FireWall Proxy'
				END AS ServerRole,
			ISNULL(CAST(acpcs.attrVal AS INT), 2),
			ISNULL(CAST(acpma.attrVal AS INT), 2)
		FROM APP_Client c
		INNER JOIN App_Platform P ON C.id = P.clientId
AND P.platformType = 4
			AND (
				(
					@ifIncludeOnlyPackageInstalledMachines = 1
					AND C.specialClientFlags = 0
					)
				OR (@ifIncludeOnlyPackageInstalledMachines = 0)
				)
		INNER JOIN App_FirewallOptions f ON f.clientId = c.Id
			AND isDMZ = 1
			AND @isProxyRequired = 1
		LEFT OUTER JOIN APP_ClientProp acpcs ON
			acpcs.componentNameId = c.id
			AND acpcs.modified = 0
			AND acpcs.attrName = 'PlatformDeleted 4'
			AND ISNUMERIC(acpcs.attrVal) = 1
		LEFT OUTER JOIN APP_ClientProp acpma ON
			acpma.componentNameId = c.id
			AND acpma.modified = 0
			AND acpma.attrName = 'PlatformDeleted 2'
			AND ISNUMERIC(acpma.attrVal) = 1
		WHERE (
				(@isAllAssociationsSet = 1)
				OR EXISTS (
					SELECT 1
					FROM #ClientCap sec
					WHERE sec.clientId = c.Id
					)
				)
			AND f.clientId IS NOT NULL
-- AEB - isDMZ always 1 so no roleName is not null check
	END
	ELSE
	BEGIN
		--to get CommServe,Web Server,Web Console,VWeb PackageGroups.
		INSERT INTO #FinalServerClientList
		SELECT c.id,
			c.NAME,
			c.net_hostname,
			sp.DisplayName,
			ISNULL(CAST(acpcs.attrVal AS INT), 2),
			ISNULL(CAST(acpma.attrVal AS INT), 2)
		FROM APP_Client c
		INNER JOIN App_Platform P ON C.id = P.clientId
AND P.platformType = 4
			AND (C.specialClientFlags = 0)
		-- and status & 4096 <> 4096
		INNER JOIN simInstalledPackages sim ON c.id = sim.ClientId
			AND sim.simPackageID IN (
				20,
				23,
				51,
				726,
				251,
				252,
				255,
				257
				)
		INNER JOIN simPackage sp ON sp.id = sim.simPackageID
		LEFT OUTER JOIN APP_ClientProp acpcs ON
			acpcs.componentNameId = c.id
			AND acpcs.modified = 0
			AND acpcs.attrName = 'PlatformDeleted 4'
			AND ISNUMERIC(acpcs.attrVal) = 1
		LEFT OUTER JOIN APP_ClientProp acpma ON
			acpma.componentNameId = c.id
			AND acpma.modified = 0
			AND acpma.attrName = 'PlatformDeleted 2'
			AND ISNUMERIC(acpma.attrVal) = 1
		WHERE (
				(
					(@isAllAssociationsSet = 1)
					OR EXISTS (
						SELECT 1
						FROM #ClientCap sec
						WHERE sec.clientId = c.Id
						)
					)
				AND sim.simPackageID IS NOT NULL
				)
			AND c.id = @i_clientId
			AND sp.DisplayName IS NOT NULL
		UNION ALL
		SELECT c.id,
			c.NAME,
			c.net_hostname,
			CASE
				WHEN isDMZ = 1
					THEN 'FireWall Proxy'
				END AS ServerRole,
			ISNULL(CAST(acpcs.attrVal AS INT), 2),
			ISNULL(CAST(acpma.attrVal AS INT), 2)
		FROM APP_Client c
		INNER JOIN App_Platform P ON C.id = P.clientId
AND P.platformType = 4
		-- and (C.specialClientFlags=0)
		-- and status & 4096 <> 4096
		INNER JOIN App_FirewallOptions f ON f.clientId = c.Id
			AND isDMZ = 1
		LEFT OUTER JOIN APP_ClientProp acpcs ON
			acpcs.componentNameId = c.id
			AND acpcs.modified = 0
			AND acpcs.attrName = 'PlatformDeleted 4'
			AND ISNUMERIC(acpcs.attrVal) = 1
		LEFT OUTER JOIN APP_ClientProp acpma ON
			acpma.componentNameId = c.id
			AND acpma.modified = 0
			AND acpma.attrName = 'PlatformDeleted 2'
			AND ISNUMERIC(acpma.attrVal) = 1
		WHERE (
				(
					(@isAllAssociationsSet = 1)
					OR EXISTS (
						SELECT 1
						FROM #ClientCap sec
						WHERE sec.clientId = c.Id
						)
					)
				AND f.clientId IS NOT NULL
				)
			AND c.id = @i_clientId
-- AEB - isDMZ always 1 so no roleName is not null check
	END
	---- Process for  Agent Info
	SET @associatedEntitiesReq = (
			SELECT 4 '@expandLevel',
				(
					SELECT f.cId AS '@clientId',
						4 '@_type_',
						1 '@clientSidePackage',
						1 '@consumeLicense',
						0 '@srmReportSet',
						0 '@srmReportType',
						0 '@type'
					FROM #FinalServerClientList F
					GROUP BY cId
					FOR XML PATH('entity'),
						TYPE
					)
			FOR XML PATH('App_GetAssociatedEntities'),
				TYPE
			)
	IF object_id('tempdb.dbo.#associatedEntitiesTable') IS NOT NULL
		DROP TABLE #associatedEntitiesTable
	CREATE TABLE #associatedEntitiesTable (xmlval XML)
	INSERT INTO #associatedEntitiesTable
		EXEC dbo.GetAssociatedEntities @associatedEntitiesReq
	INSERT INTO #i_clientList
		SELECT
			d.value('@clientId', 'INT'),
			d.value('@clientName', 'NVARCHAR(255)'),
			d.value('@applicationId', 'INT'),
			d.value('@appName', 'NVARCHAR(255)'),
			ISNULL(d.value('@errorCode', 'INT'), 0),
			ISNULL(d.value('../@errorString', 'NVARCHAR(MAX)'), '')
		FROM #associatedEntitiesTable aet
			CROSS APPLY aet.xmlval.nodes('//App_GenericResponse/response/entity') aer(d)
	DECLARE @IdaActivityControl XML
	INSERT INTO #FinalAgentPropList (clientId, clientName, appTypeID, appName, isMarkedDeleted, patchStatus, simLicenseAppType)
		SELECT
			cl.clientId,
			cl.clientName,
			cl.appTypeId,
			ISNULL((
				SELECT TOP 1 displayName
				FROM app_idaType it
				WHERE it.type = cl.appTypeId
			), N'Default Application Type Name'),
			CASE
				WHEN (idan.status & 2) = 2 THEN 1
				ELSE 0
			END,
			ISNULL((
						SELECT TOP 1 dbo.simGetBaseline(p.Baseline)
						FROM simInstalledPackages p
						WHERE p.ClientId = cl.clientId
							AND p.simPackageID = cl.appTypeId
			), 0),
			(
				SELECT TOP 1 LU.LicType
				FROM LicUsage LU,
					simLicApptypeV2 SL
				WHERE LU.CId = cl.clientId
					AND LU.LicType NOT IN (
						71,
						10,
						26
						)
					AND LU.appType = cl.appTypeId
					AND LU.opType = 'Install'
					AND SL.id = LU.LicType
				ORDER BY LU.id DESC
			)
		FROM #i_clientList cl
			LEFT OUTER JOIN APP_IDAName idan ON
				idan.clientId = cl.clientId
				AND idan.appTypeId = cl.appTypeId
		WHERE
			cl.errorCode = 0
			AND LEN(cl.errorString) = 0
			AND cl.clientId > 1
	DECLARE @indexIdForAgentsInfo INTEGER = 0
	SET @indexIdForAgentsInfo = (
			SELECT TOP 1 MIN(id)
			FROM #i_clientList
			WHERE id > 0
			)
	WHILE (@indexIdForAgentsInfo > 0)
	BEGIN
		SELECT @r_clientId = cl.clientId,
			@r_appTypeID = cl.appTypeId,
			@r_simLicenseAppType = al.simLicenseAppType
		FROM #i_clientList cl
			INNER JOIN #FinalAgentPropList al ON
				al.clientId = cl.clientId
				AND al.appTypeID = cl.appTypeId
		WHERE cl.id = @indexIdForAgentsInfo
			AND cl.clientId >= 2
			AND cl.errorCode = 0
			AND LEN(cl.errorString) = 0
		BEGIN
			IF @r_clientId IS NULL
			BEGIN
				GOTO CONTINUE_NEXT_AGENT
			END
			DELETE @VersionAndPatch -- Deleting any rows already inserted. Otherwise it will always get top 1 row which will have the same result for all the app type
			INSERT INTO @VersionAndPatch
			EXEC simGetVersionInfo @r_clientId,
				@r_appTypeID,
				@r_simLicenseAppType
			SELECT TOP 1 @r_AgentVersion = REPLACE((
						CASE
							WHEN releaseId > 14
								THEN (Release + Build)
							ELSE (Release + '.' + Build)
							END
						), ' ', ''),
				@r_installDate = ISNULL((CAST(installDate AS NVARCHAR(MAX))), '0')
			FROM @VersionAndPatch
			--Get activity control
			SET @IdaActivityControl = '<entity clientId="' + STR(@r_clientId) + '" appTypeId="' + STR(@r_appTypeID) + '"/>'
			EXEC [dbo].[APPGetActivityControlXML] @xmlText = @IdaActivityControl OUTPUT
			UPDATE #FinalAgentPropList
				SET AgentVersion = @r_AgentVersion,
					installDate = @r_installDate,
					IdaActivityControl = @IdaActivityControl
			WHERE
				appTypeID = @r_appTypeID
				AND clientId = @r_clientId
			CONTINUE_NEXT_AGENT:
			SET @indexIdForAgentsInfo = (
					SELECT TOP 1 MIN(id)
					FROM #i_clientList
					WHERE id > @indexIdForAgentsInfo
					)
		END
	END
	-- Till here
	SET @xmlString = (
			SELECT (
					SELECT sl.cHostName AS '@hostName',
						(
							SELECT
								CASE
									WHEN sl.isClientDeconfigured = 2 THEN NULL
									ELSE sl.isClientDeconfigured
							END
						) AS '@isClientDeconfigured',
						(
							SELECT
								CASE
									WHEN sl.isMAForClientDeconfigured = 2 THEN NULL
									ELSE sl.isMAForClientDeconfigured
							END
						) AS '@isMAForClientDeconfigured',
						(
							SELECT SUM(CASE
										WHEN appType < 1000
											THEN 1
										WHEN (
												apptype = 1002
												AND lictype NOT IN (
													71,
													10,
													26,
													33554432
													)
												)
											THEN 1
										ELSE 0
										END) AS agents
							FROM licUsage
							WHERE optype = 'Install'
								AND InstallFlag = 0
								AND cId = sl.cId
							GROUP BY Cid
							) AS '@iLicenses',
						(
							SELECT sl.cid AS '@clientId',
								sl.cname '@clientName'
							FOR XML PATH('client'),
								TYPE
							),
						(
							SELECT TEMP.roleName AS '@val'
							FROM #FinalServerClientList TEMP
							WHERE TEMP.cId = sl.cId
							FOR XML path('roles'),
								type
							),
						(
							SELECT (
									SELECT AgentVersion '@agentVersion',
										installDate '@installDate',
										isMarkedDeleted '@isMarkedDeleted'
									FROM #FinalAgentPropList
									WHERE appTypeID = FinalList.appTypeId
										AND clientId = FinalList.clientId
									FOR XML PATH('AgentProperties'),
										TYPE
									),
								FinalList.idaActivityControl,
								(
									SELECT clientId '@clientId',
										F.appTypeId '@applicationId',
										F.appName '@appName',
										clientName '@clientName',
										2 '@commCellId'
									FROM #FinalAgentPropList F
									WHERE appTypeID = FinalList.appTypeId
										AND F.clientId = FinalList.clientId
									FOR XML PATH('idaEntity'),
										TYPE
									)
							FROM #FinalAgentPropList AS FinalList
							WHERE clientId = sl.cid
							FOR XML PATH('agentProperties'),
								TYPE
							),
						(
							SELECT (
									SELECT S.id AS '@osId',
										S.Type AS '@Type',
										S.SubType AS '@SubType',
										(
											SELECT dbo.GetClientOSName(sl.cid, NULL) AS '@OSName',
												--(SELECT TmpFinalClientList3.OSName AS '@OSName',
												dbo.GetClientHardwareName(sl.cid, NULL) AS '@ProcessorType' --Fix me
											FOR XML PATH('OsDisplayInfo'),
												TYPE
											)
									FROM simOperatingSystem AS S
									WHERE S.id = (
											SELECT simOperatingSystemId
											FROM APP_Client
											WHERE id = sl.cid
											)
									FOR XML PATH('osInfo'),
										TYPE
									)
							FOR XML PATH('serverOSInfo'),
								TYPE
							)
					FOR XML PATH('serverInfo'),
						type
					)
			FROM #FinalServerClientList sl
			GROUP BY sl.cid,
				sl.cname,
				sl.cHostName,
				sl.isClientDeconfigured,
				sl.isMAForClientDeconfigured
			FOR XML PATH(''),
				ROOT('Api_GetServerClientResponse')
			)
	IF (@xmlString IS NULL)
		SET @xmlString = '<Api_GetServerClientResponse/>'
	DROP TABLE #FinalServerClientList
END TRY
----=====================================================================
----==============  COME HERE IF THERE WAS A PROBLEM!     ===============
----=====================================================================
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode    = ERROR_NUMBER()
    SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
    SET @xmlString = ( SELECT
                ( SELECT @errorCode '@errorCode', @errorString '@errorMessage'
                      FOR XML PATH('error'), TYPE
                )
    FOR XML PATH(''),
    ROOT('Api_GetServerClientResponse'))
END CATCH
SELECT @xmlString
-- drop temp table
IF object_id('tempdb.dbo.#ServerClientList') IS NOT NULL
	DROP TABLE #ServerClientList
IF object_id('tempdb.dbo.#FinalServerClientList') IS NOT NULL
	DROP TABLE #FinalServerClientList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetServerClientList')
	delete from GxQscripts where name = 'APPGetServerClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetServerClientList')
	delete from GXDBVersions where aliasname = 'APPGetServerClientList'
GO

insert into GXDBVersions values(2, 'APPGetServerClientList',  '00010001000200100000', 'APPGetServerClientList', '00010001000200100000')
GO

