

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetSCGScopeEntitiesForUserSQL.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
--	| 	Procedure : "APPGetSCGScopeEntitiesForUserSQL.sp"
--	|	Description: Loads list of Scope entities of a particular type for an user.
--	|				 This SP was previously under AppGetSCGScopeEntitiesForUser. Since when calling from SP, we need output as param and not
--	|				 as Select, we wrote this new one. It returns output as param and does not Select output. Makes easy to call from SPs.
--	|	Inputs:		i_userId(user Id for whom scope entities are being fetched),
--	|				i_localeId,
--	|				i_xmlRequest (contains details of entities of what scope type is being requested, property level, etc. )
--	|	Outputs:	o_XMLStr (contains scope entities of that particular entity type)
-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPGetSCGScopeEntitiesForUserSQL')
BEGIN
	print '>>> Drop Stored Procedure: APPGetSCGScopeEntitiesForUserSQL <<<'
	drop procedure APPGetSCGScopeEntitiesForUserSQL
END
IF EXISTS (select * from GxQscripts where name='APPGetSCGScopeEntitiesForUserSQL')
	delete from GxQscripts where name = 'APPGetSCGScopeEntitiesForUserSQL'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetSCGScopeEntitiesForUserSQL')
	delete from GXDBVersions where aliasname = 'APPGetSCGScopeEntitiesForUserSQL'
GO
print '... Creating Procedure: APPGetSCGScopeEntitiesForUserSQL'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPGetSCGScopeEntitiesForUserSQL
  @i_userId INT,
  @i_localeId INT,
  @i_xmlRequest XML,
  @o_XmLStr XML OUTPUT
AS
BEGIN
	--This will turn off message: "xxx rows affected".
	SET NOCOUNT ON
	DECLARE @property INT
	DECLARE @requestedScopeType INT
	SELECT
		@property = r.value('@property', 'INT'),
		@requestedScopeType = r.value('@scopeType', 'INT')
	FROM @i_xmlRequest.nodes('/App_GetSCGScopeEntitiesUserRequest') d(r)
	IF (@i_userId < 1)
	BEGIN
		SELECT
			@i_userId = r.value('@userId', 'INT')
		FROM @i_xmlRequest.nodes('/App_GetSCGScopeEntitiesUserRequest/processinginstructioninfo/user') d(r)
		SELECT
			@i_localeId = r.value('@localeId', 'INT')
		FROM @i_xmlRequest.nodes('/App_GetSCGScopeEntitiesUserRequest/processinginstructioninfo/locale') d(r)
	END
	IF (@property NOT IN (10, 20))
	BEGIN
		RAISERROR('App_GetSCGScopeEntitiesUserRequest invalid property attribute.', 16, 1)
	END
	DECLARE @includeUsersFlags INT = CAST(0x001 AS INT)		-- USERS_VALID
	DECLARE @excludeUsersFlags INT = CAST(0x200 AS INT) | CAST(0x004 AS INT) | CAST(0x080 AS INT) | CAST(0x100 AS INT)	-- USERS_QNET|USERS_HIDE|USERS_MMC_SSO|USERS_MMC_COMMON_SSO
	DECLARE @includeGroupsFlags INT = CAST(0x0001 AS INT)		-- GF_GROUP_ENABLED
	DECLARE @excludeGroupsFlags INT = CAST(0x0002 AS INT) | CAST(0x0010 AS INT)		-- GF_GROUP_DELETED |GF_GROUP_HIDDEN
	DECLARE @scopeType INT = NULL
	DECLARE @scopeId INT = NULL
	DECLARE @scopeName NVARCHAR(1024) = NULL
	-- Get User default SCG Scope level
	EXEC AppComputeClientGroupScope @i_userId, @scopeType OUTPUT, @scopeId OUTPUT
	IF (@property = 10)
	BEGIN
		DECLARE @scopeLevels TABLE (
			entityType INT
		)
		IF (@scopeType = 1)
		BEGIN
			INSERT INTO @scopeLevels VALUES
				(1),
				(13),
				(15),
				(61)
			SELECT
				@scopeName = cc.aliasName
			FROM APP_CommCell cc WITH(NOLOCK)
			WHERE
				cc.id = @scopeId
		END
		ELSE IF (@scopeType = 61)
		BEGIN
			INSERT INTO @scopeLevels VALUES
				(13),
				(15),
				(61)
			SELECT
				@scopeName = p.domainName
			FROM UMDSProviders p WITH(NOLOCK)
			WHERE
				p.id = @scopeId
				AND p.enabled = 1
				AND (p.flags & 2) = 0	-- not deleted	UMDS_PROVIDER_FLAGS_MARKED_FOR_DELETE
		END
		ELSE IF (@scopeType = 13)
		BEGIN
			INSERT INTO @scopeLevels VALUES
				(13)
			SELECT
				@scopeName = u.login		-- converting to use login only
			FROM UMUsers u WITH(NOLOCK)
			WHERE
				u.id = @scopeId
		END
		ELSE IF (@scopeType = 15)
		BEGIN
			INSERT INTO @scopeLevels VALUES
				(15),
				(13)
			SELECT
				@scopeName = CASE
								WHEN p.id IS NULL THEN g.name
								ELSE p.domainName + '\' + g.name
							END
			FROM UMGroups g WITH(NOLOCK)
				LEFT OUTER JOIN UMDSProviders p ON
					p.id = g.umdsProviderId
					AND g.umdsProviderId > 0
			WHERE
				g.id = @scopeId
		END
		SET @o_XmLStr = (
			SELECT
				@i_userId '@userId',
				(
					-- Default Recommended Scope Level
					SELECT
						@scopeType '@entityType',
						@scopeId '@entityId',
						@scopeName '@entityName'
					FOR XML PATH('defaultScope'), TYPE
				),
				(
					SELECT
						(
							SELECT
								entityType '@entityType'
							FROM @scopeLevels
							WHERE
								entityType = 1
							FOR XML PATH('entities'), TYPE
						),
						(
							SELECT
								entityType '@entityType'
							FROM @scopeLevels
							WHERE
								entityType = 13
							FOR XML PATH('entities'), TYPE
						),
						(
							SELECT
								entityType '@entityType'
							FROM @scopeLevels
							WHERE
								entityType = 15
							FOR XML PATH('entities'), TYPE
						),
						(
							SELECT
								entityType '@entityType'
							FROM @scopeLevels
							WHERE
								entityType = 61
							FOR XML PATH('entities'), TYPE
						)
					FOR XML PATH('scopeEntities'), TYPE
				),
				(
					SELECT
						0 '@errorCode',
						'Success' '@errorMessage'
					FOR XML PATH('error'), TYPE
				)
			FOR XML PATH('App_GetSCGScopeEntitiesUserResponse'), TYPE
		)
		--SELECT @o_XmLStr
		RETURN
	END
	IF (@property = 20)
	BEGIN
		IF OBJECT_ID('TempDb..#ScopeEntities') IS NOT NULL
			DROP TABLE #ScopeEntities
		CREATE TABLE #ScopeEntities (
			entityType		INT,
			entityId		INT,
			entityName		NVARCHAR(1024),
			PRIMARY KEY(entityType, entityId)
		)
		IF OBJECT_ID('tempdb.dbo.#UsersSec_getUsersNewTbl')  IS NOT NULL
			DROP TABLE #UsersSec_getUsersNewTbl
		CREATE TABLE  #UsersSec_getUsersNewTbl  (
			userId	INT PRIMARY KEY
		)
		IF OBJECT_ID('tempdb.dbo.#UsersSec_getUserGroupsNewTbl')  IS NOT NULL
			DROP TABLE #UsersSec_getUserGroupsNewTbl
		CREATE TABLE  #UsersSec_getUserGroupsNewTbl  (
			userGroupId	INT PRIMARY KEY
		)
		IF OBJECT_ID('tempdb.dbo.#UsersSec_getUsersNewTbl_userEdit')  IS NOT NULL
			DROP TABLE #UsersSec_getUsersNewTbl_userEdit
		-- CAT_USER_MANAGMENT_USER_MANAGEMENT
		CREATE TABLE  #UsersSec_getUsersNewTbl_userEdit  (
			userId	INT PRIMARY KEY
		)
		IF OBJECT_ID('tempdb.dbo.#userGroupId') IS NOT NULL
			DROP TABLE #userGroupId
		CREATE TABLE #userGroupId
		(
			userGroupId INT
		)
		IF (@scopeType = 1)
		BEGIN
			-- No Security Checks - user is Commcell Admin see all entities
			-- Commcell Scope
			IF (@requestedScopeType = 1)
			BEGIN
				INSERT INTO #ScopeEntities
					SELECT
						1,		-- COMMCELL_ENTITY
						cc.id,
						cc.aliasName
					FROM APP_Commcell cc WITH(NOLOCK)
					WHERE
						cc.id = 2		-- default CSId
			END
			ELSE IF (@requestedScopeType = 61)
			BEGIN
				INSERT INTO #ScopeEntities
					SELECT
						61,		--PROVIDER_ENTITY
						p.id,
						p.domainName
					FROM UMDSProviders p WITH(NOLOCK)
					WHERE
						p.serviceType = 5		-- UMDS_PROVIDER_ORGANIZATIONS
						AND p.enabled = 1
						AND (p.flags & 2) = 0	-- not deleted	UMDS_PROVIDER_FLAGS_MARKED_FOR_DELETE
			END
			ELSE IF (@requestedScopeType = 13)
			BEGIN
				INSERT INTO #ScopeEntities
					SELECT
						13,		-- USER_ENTITY
						u.id,
						u.login
					FROM UMUsers u WITH(NOLOCK)
					WHERE
						u.enabled = 1
						AND (u.flags & @excludeUsersFlags) = 0
						AND (u.flags & @includeUsersFlags) <> 0
			END
			ELSE IF (@requestedScopeType = 15)
			BEGIN
				INSERT INTO #ScopeEntities
					SELECT
						15,		-- USERGROUP_ENTITY
						g.id,
						g.name
					FROM UMGroups g WITH(NOLOCK)
					WHERE
						(g.groupFlags & @excludeGroupsFlags) = 0
						AND (g.groupFlags & @includeGroupsFlags) <> 0
			END
		END
		ELSE IF (@scopeType = 13)
		BEGIN
			-- User Scope
			IF (@requestedScopeType = 13)
			BEGIN
				-- Get users allowed to set
				-- EXEC sec_getUsersForThisUser '#UsersSec_getUsersNewTbl', @i_userId
				-- with permission CAT_USER_MANAGMENT_USER_MANAGEMENT
				EXEC sec_getNonIdaObjectsForThisUser @i_userId, @requestedScopeType, 101, '#UsersSec_getUsersNewTbl_userEdit'
				INSERT INTO #ScopeEntities
					SELECT
						@scopeType,	-- USER_ENTITY
						u.id,
						u.login
					FROM UMUsers u WITH(NOLOCK)
						INNER JOIN #UsersSec_getUsersNewTbl_userEdit ue ON
							ue.userId = u.id
					--WHERE
					--	u.id = @scopeId
					UNION
					SELECT			-- any user should be able to choose himself in Scope, irrespective of rights.
						13,	-- USER_ENTITY
						u.id,
						u.login
					FROM UMUsers u WITH(NOLOCK)
					WHERE
						u.id = @i_userId
						AND (u.flags & @excludeUsersFlags) = 0
						AND (u.flags & @includeUsersFlags) <> 0
			END
		END
		ELSE IF (@scopeType = 15)
		BEGIN
			-- User Group Scope
			IF (@requestedScopeType = 13)
			BEGIN
				-- Get users allowed to set
				--EXEC sec_getUsersForThisUser '#UsersSec_getUsersNewTbl', @i_userId
				-- with permission CAT_USER_MANAGMENT_USER_MANAGEMENT
				EXEC sec_getNonIdaObjectsForThisUser @i_userId, @requestedScopeType, 101, '#UsersSec_getUsersNewTbl_userEdit'
				INSERT INTO #ScopeEntities
					SELECT
						13,		-- USER_ENTITY
						u.id,
						u.login
					FROM UMUsers u WITH(NOLOCK)
						INNER JOIN #UsersSec_getUsersNewTbl_userEdit ue ON
							ue.userId = u.id
					--WHERE
					--	u.id = @scopeId
					UNION
					SELECT		-- any user should be able to choose himself in Scope, irrespective of rights.
						13,	-- USER_ENTITY
						u.id,
						u.login
					FROM UMUsers u WITH(NOLOCK)
					WHERE
						u.id = @i_userId
						AND (u.flags & @excludeUsersFlags) = 0
						AND (u.flags & @includeUsersFlags) <> 0
			END
			ELSE IF (@requestedScopeType = 15)
			BEGIN
				-- Get User Groups allowed to set
				--EXEC sec_getUserGroupsForThisUser '#UsersSec_getUserGroupsNewTbl', @i_userId
				-- Get User Groups that userId is a member of
				EXEC sec_getMemberUserGroups @i_userId
				INSERT INTO #ScopeEntities
					SELECT
						15,		-- USERGROUP_ENTITY
						g.id,
						g.name
					FROM UMGroups g WITH(NOLOCK)
						INNER JOIN #userGroupId m ON
							m.userGroupId = g.id
					WHERE
						(g.groupFlags & @excludeGroupsFlags) = 0
						AND (g.groupFlags & @includeGroupsFlags) <> 0
			END
		END
		ELSE IF (@scopeType = 61)
		BEGIN
			-- Company Scope
			IF OBJECT_ID('TempDb..#ProviderEntities') IS NOT NULL
				DROP TABLE #ProviderEntities
			CREATE TABLE #ProviderEntities (
				entityType		INT,
				entityId		INT,
				entityName		NVARCHAR(1024),
				PRIMARY KEY(entityType, entityId)
			)
			IF OBJECT_ID('tempdb.dbo.#getNameServers_AgentMgmt') IS NOT NULL
				DROP TABLE #getNameServers_AgentMgmt
			CREATE TABLE #getNameServers_AgentMgmt
			(
				entityId INT PRIMARY KEY
			)
			IF OBJECT_ID('tempdb.dbo.#getNameServers_UserMgmt') IS NOT NULL
				DROP TABLE #getNameServers_UserMgmt
			CREATE TABLE #getNameServers_UserMgmt
			(
				entityId INT PRIMARY KEY
			)
			-- Get only those Companies on which User has both the permissions. We need to call the Security SP twice to get this, no other way arnd.
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 61, 2, '#getNameServers_AgentMgmt'
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 61, 107, '#getNameServers_UserMgmt'
			INSERT INTO #ProviderEntities
				SELECT
					61,		-- PROVIDER_ENTITY
					p.id,
					p.domainName
				FROM UMDSProviders p WITH(NOLOCK)
					INNER JOIN #getNameServers_AgentMgmt AMNS ON
						AMNS.entityId = p.id AND P.serviceType = 5
					INNER JOIN #getNameServers_UserMgmt UMNS ON
						UMNS.entityId = AMNS.entityId
				WHERE
					p.enabled = 1
					AND (p.flags & 2) = 0	-- not deleted	UMDS_PROVIDER_FLAGS_MARKED_FOR_DELETE
			IF (@requestedScopeType = 61)
			BEGIN
				INSERT INTO #ScopeEntities
					SELECT
						entityType,
						entityId,
						entityName
					FROM #ProviderEntities
			END
			ELSE IF (@requestedScopeType = 13)
			BEGIN
				--EXEC sec_getUsersForThisUser '#UsersSec_getUsersNewTbl', @i_userId
				-- with both permissions CAT_USER_MANAGMENT_USER_MANAGEMENT
				EXEC sec_getNonIdaObjectsForThisUser @i_userId, @requestedScopeType, 101, '#UsersSec_getUsersNewTbl_userEdit'
				INSERT INTO #ScopeEntities
					SELECT
						13,		-- USER_ENTITY
						u.id,
						u.login
					FROM UMUsers u WITH(NOLOCK)
						INNER JOIN #UsersSec_getUsersNewTbl_userEdit au ON
							au.userId = u.id
						-- Do NOT filter by providers return all the users this user has access rights for
					WHERE
						u.enabled = 1
						AND (u.flags & @excludeUsersFlags) = 0
						AND (u.flags & @includeUsersFlags) <> 0
					UNION
					SELECT		-- any user should be able to choose himself in Scope, irrespective of rights.
						13,	-- USER_ENTITY
						u.id,
						u.login
					FROM UMUsers u WITH(NOLOCK)
					WHERE
						u.id = @i_userId
						AND (u.flags & @excludeUsersFlags) = 0
						AND (u.flags & @includeUsersFlags) <> 0
			END
			ELSE IF (@requestedScopeType = 15)
			BEGIN
				-- Get User Groups allowed to set
				-- Since the scope type = Company, we should get all the UGs of the companies on which user has AM + UM rights.
				-- And the individual UGs to which user is member of.
				EXEC sec_getMemberUserGroups @i_userId
				INSERT INTO #ScopeEntities
					SELECT
						15,		-- USERGROUP_ENTITY
						g.id,
						g.name
					FROM UMGroups g WITH(NOLOCK)
						INNER JOIN #ProviderEntities P
							ON G.umdsProviderID = P.entityId
					WHERE
						(g.groupFlags & @excludeGroupsFlags) = 0
						AND (g.groupFlags & @includeGroupsFlags) <> 0
					UNION
					SELECT
						15,
						G.id,
						G.name
					FROM UMGroups G WITH(NOLOCK)
						INNER JOIN UMDSProviders P WITH(NOLOCK)
							ON G.umdsProviderId = P.id
						INNER JOIN #ProviderEntities P1
							ON P.ownerCompany = P1.entityId
					WHERE
						(g.groupFlags & @excludeGroupsFlags) = 0
						AND (g.groupFlags & @includeGroupsFlags) <> 0
					UNION
					SELECT
						15,		-- USERGROUP_ENTITY
						g.id,
						g.name
					FROM UMGroups g WITH(NOLOCK)
						INNER JOIN #userGroupId m ON
							m.userGroupId = g.id
					WHERE
						(g.groupFlags & @excludeGroupsFlags) = 0
						AND (g.groupFlags & @includeGroupsFlags) <> 0
			END
		END
		SET @o_XmLStr = (
			SELECT
				@i_userId '@userId',
				(
					SELECT
						(
							-- Commcell Scope Level Listing
							SELECT
								1 '@entityType',		-- COMMCELL_ENTITY
								(SELECT COUNT(*) FROM #ScopeEntities WHERE entityType = 1) '@count',
								(
									SELECT
										se.entityType '@entityType',
										se.entityId '@entityId',
										se.entityName '@entityName'
									FROM #ScopeEntities se
									WHERE
										se.entityType = 1		-- COMMCELL_ENTITY
									FOR XML PATH('entity'), TYPE
								)
							WHERE EXISTS (SELECT 1 FROM #ScopeEntities WHERE entityType = 1)
							FOR XML PATH('entities'), TYPE
						),
						(
							-- Company Scope Level Listing
							SELECT
								61 '@entityType',		-- PROVIDER_ENTITY
								(SELECT COUNT(*) FROM #ScopeEntities WHERE entityType = 61) '@count',
								(
									SELECT
										se.entityType '@entityType',
										se.entityId '@entityId',
										se.entityName '@entityName'
									FROM #ScopeEntities se
									WHERE
										se.entityType = 61		-- PROVIDER_ENTITY
									FOR XML PATH('entity'), TYPE
								)
							WHERE EXISTS (SELECT 1 FROM #ScopeEntities WHERE entityType = 61)
							FOR XML PATH('entities'), TYPE
						),
						(
							-- User Group Scope Level Listing
							SELECT
								15 '@entityType',		-- USERGROUP_ENTITY
								(SELECT COUNT(*) FROM #ScopeEntities WHERE entityType = 15) '@count',
								(
									SELECT
										se.entityType '@entityType',
										se.entityId '@entityId',
										CASE
											WHEN p.id IS NULL THEN se.entityName
											ELSE p.domainName + '\' + se.entityName
										END '@entityName'
									FROM #ScopeEntities se
										INNER JOIN UMGroups g WITH(NOLOCK) ON
											g.id = se.entityId
										LEFT OUTER JOIN UMDSProviders p ON
											p.id = g.umdsProviderId
											AND g.umdsProviderId > 0
									WHERE
										se.entityType = 15		-- USERGROUP_ENTITY
									FOR XML PATH('entity'), TYPE
								)
							WHERE EXISTS (SELECT 1 FROM #ScopeEntities WHERE entityType = 15)
							FOR XML PATH('entities'), TYPE
						),
						(
							-- User Scope Level Listing
							SELECT
								13 '@entityType',		-- USER_ENTITY
								(SELECT COUNT(*) FROM #ScopeEntities WHERE entityType = 13) '@count',
								(
									SELECT
										se.entityType '@entityType',
										se.entityId '@entityId',
										se.entityName '@entityName'
									FROM #ScopeEntities se
										INNER JOIN UMUsers u WITH(NOLOCK) ON
											u.id = se.entityId
										LEFT OUTER JOIN UMDSProviders p ON
											p.id = u.umdsProviderId
											AND u.umdsProviderId > 0
									WHERE
										se.entityType = 13		-- USER_ENTITY
									FOR XML PATH('entity'), TYPE
								)
							WHERE EXISTS (SELECT 1 FROM #ScopeEntities WHERE entityType = 13)
							FOR XML PATH('entities'), TYPE
						)
					FOR XML PATH('scopeEntities'), TYPE
				),
				(
					SELECT
						0 '@errorCode',
						'Success' '@errorMessage'
					FOR XML PATH('error'), TYPE
				)
			FOR XML PATH('App_GetSCGScopeEntitiesUserResponse'), TYPE
		)
		--SELECT @o_XmLStr
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetSCGScopeEntitiesForUserSQL')
	delete from GxQscripts where name = 'APPGetSCGScopeEntitiesForUserSQL'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetSCGScopeEntitiesForUserSQL')
	delete from GXDBVersions where aliasname = 'APPGetSCGScopeEntitiesForUserSQL'
GO

insert into GXDBVersions values(2, 'APPGetSCGScopeEntitiesForUserSQL',  '00000000000000000000', 'APPGetSCGScopeEntitiesForUserSQL', '00000000000000000000')
GO

