

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetRDSSubclientContentList.sp] ---------- 

-- Additional header files can be included for constants used in this stored procedure.
-- Stored procedure has to be rebuilt if any constant value changed in those header file.
-- This will generate the revision for the stored procedure. Dont remove this line!!!
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetRDSSubclientContentList.sp,v $ $Id: APPGetRDSSubclientContentList.sp,v 1.1.2.9.20.1 2021/02/26 22:13:32 csharma Exp $";
-- Name of the stored procedure
-- It must match with the name of the .sp file
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPGetRDSSubclientContentList')
BEGIN
	print '>>> Drop Stored Procedure: APPGetRDSSubclientContentList <<<'
	drop procedure APPGetRDSSubclientContentList
END
IF EXISTS (select * from GxQscripts where name='APPGetRDSSubclientContentList')
	delete from GxQscripts where name = 'APPGetRDSSubclientContentList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetRDSSubclientContentList')
	delete from GXDBVersions where aliasname = 'APPGetRDSSubclientContentList'
GO
print '... Creating Procedure: APPGetRDSSubclientContentList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPGetRDSSubclientContentList
-- Input variables of the stored procedure
  @i_xml XML
-- Tell the AWK processor that body of query starts here
AS
	DECLARE @errorCode INT = 0
	DECLARE @errorMsg NVARCHAR(MAX) = N''
	DECLARE @subclientId INTEGER = (SELECT @i_xml.value('(/App_RDSSubclientContentListReq/rdsSubclient/scEntity/@subclientId)[1]','INT'))
	DECLARE @optype INTEGER = (SELECT @i_xml.value('(/App_RDSSubclientContentListReq/@opType)[1]','INT'))
	DECLARE @subclientName NVARCHAR(MAX) = (ISNULL((SELECT subclientName FROM APP_Application WHERE id = @subclientId),'Unknown'))
	DECLARE @currentTime INTEGER = CommServ.dbo.GetUnixTime(GETUTCDATE())
	DECLARE @pit INTEGER = (ISNULL((SELECT @i_xml.value('(/App_RDSSubclientContentListReq/@pointInTime)[1]','INT')), @currentTime))
	IF @pit = 0
		SET @pit = @currentTime
	DECLARE @xmlResult	XML
	IF @optype = 1  -- CloudAppsOperationType.GET
	BEGIN
		SET @xmlResult =
						(SELECT
							(SELECT
								@subclientId as '@subclientId',
								@subclientName as '@subclientName'
							FOR XML PATH('scEntity'), TYPE),
							(SELECT
								id as '@id',
								tag as '@tag',
								dbName as '@dbName',
								regionId as '@regionId',
								(SELECT RegionCode FROM App_CloudVendorRegion WHERE id = regionId) as '@regionName',
								dbType as '@dbType',
								securityGroup as '@securityGroup',
								(SELECT
									rds.attributes.value('(/App_RDSAttributes/@availabilityZone)[1]', 'NVARCHAR(1024)') as '@availabilityZone',
									rds.attributes.value('(/App_RDSAttributes/@dbSubnetGroup)[1]', 'NVARCHAR(1024)') as '@dbSubnetGroup',
									rds.attributes.value('(/App_RDSAttributes/@instanceType)[1]', 'NVARCHAR(1024)') as '@instanceType',
									rds.attributes.value('(/App_RDSAttributes/@service)[1]', 'NVARCHAR(1024)') as '@service',
									rds.attributes.value('(/App_RDSAttributes/@parameterGroup)[1]', 'NVARCHAR(1024)') as '@parameterGroup',
									rds.attributes.value('(/App_RDSAttributes/@tags)[1]', 'NVARCHAR(1024)') as '@tags',
									rds.attributes.value('(/App_RDSAttributes/@optionGroup)[1]', 'NVARCHAR(1024)') as '@optionGroup',
									rds.attributes.value('(/App_RDSAttributes/@iops)[1]', 'NVARCHAR(1024)') as '@iops',
									rds.attributes.value('(/App_RDSAttributes/@size)[1]', 'NVARCHAR(1024)') as '@size',
									rds.attributes.value('(/App_RDSAttributes/@numberOfNodes)[1]', 'NVARCHAR(1024)') as '@numberOfNodes',
									rds.attributes.value('(/App_RDSAttributes/@snapshotSize)[1]', 'NVARCHAR(1024)') as '@snapshotSize'
								FROM (SELECT CAST(rsdAttributes AS XML)) as rds(attributes)
								FOR XML PATH('rdsAttributesObj'), TYPE)
							FROM APP_RDSSubclientContentMap
							WHERE subclientId = @subclientId AND created <= @pit AND (modified = 0 OR modified > @pit)
							FOR XML PATH('rdsDynamicContentProperty'), TYPE)
						FOR XML PATH('rdsSubclient'), TYPE)
	END
	IF @optype = 2  -- CloudAppsOperationType.MODIFY
	BEGIN
		----------------------------------------------------
		--	 Set modified time to deleted nodes 		----
		----------------------------------------------------
		UPDATE rdsMap
		SET modified = @currentTime
		FROM @i_xml.nodes('App_RDSSubclientContentListReq/rdsSubclient/rdsDynamicContentProperty') as propertyList(content)
			RIGHT JOIN
			( SELECT in_rdsMap.dbName, in_rdsMap.modified, CR.RegionCode, in_rdsMap.dbType
			  FROM APP_RDSSubclientContentMap in_rdsMap
			  LEFT JOIN
				App_CloudVendorRegion as CR
				ON CR.id = in_rdsMap.regionId
			  WHERE subclientId = @subclientId
						  AND modified = 0
			) as rdsMap
			ON propertyList.content.value('@dbName', 'NVARCHAR(MAX)') = rdsMap.dbName
			AND propertyList.content.value('@regionName', 'NVARCHAR(MAX)') = rdsmap.RegionCode
			AND propertyList.content.value('@dbType', 'NVARCHAR(MAX)') = rdsMap.dbType
		WHERE
			propertyList.content.value('@dbName', 'NVARCHAR(MAX)') IS null
		--------------------------------------------------------
		---		Filter contents which are modified			----
		--------------------------------------------------------
		SET @i_xml =(SELECT
						(SELECT
							(SELECT
								(SELECT
									propertyList.content.value('@tag', 'NVARCHAR(MAX)') as '@tag',
									propertyList.content.value('@dbName', 'NVARCHAR(MAX)') as '@dbName',
									propertyList.content.value('@regionId', 'INT') as '@regionId',
									propertyList.content.value('@regionName', 'NVARCHAR(MAX)') as '@regionName',
									propertyList.content.value('@dbType', 'NVARCHAR(MAX)') as '@dbType',
									propertyList.content.value('@securityGroup','NVARCHAR(MAX)') as '@securityGroup',
									propertyList.content.query('rdsAttributesObj')
								FROM
									@i_xml.nodes('App_RDSSubclientContentListReq/rdsSubclient/rdsDynamicContentProperty') as propertyList(content)
									LEFT JOIN
									( SELECT in_rdsMap.tag, in_rdsMap.dbType, in_rdsMap.securityGroup, in_rdsMap.rsdAttributes, in_rdsMap.dbName, CR.RegionCode
									  FROM APP_RDSSubclientContentMap in_rdsMap
									  LEFT JOIN
										App_CloudVendorRegion as CR
										ON CR.id = in_rdsMap.regionId
									  WHERE subclientId = @subclientId
												  AND modified = 0
									) as rdsMap
									ON propertyList.content.value('@dbName', 'NVARCHAR(MAX)') = rdsMap.dbName
									AND propertyList.content.value('@regionName', 'NVARCHAR(MAX)') = rdsMap.RegionCode
									AND propertyList.content.value('@dbType', 'NVARCHAR(MAX)') = rdsMap.dbType
								WHERE
									propertyList.content.value('@tag', 'NVARCHAR(MAX)') <> ISNULL(rdsMap.tag, '') OR
									propertyList.content.value('@dbType', 'NVARCHAR(MAX)') <> ISNULL(rdsMap.dbType, '') OR
									propertyList.content.value('@securityGroup','NVARCHAR(MAX)') <> ISNULL(rdsmap.securityGroup, '') OR
									CAST (propertyList.content.query('rdsAttributesObj') AS NVARCHAR(MAX)) <> ISNULL(rdsMap.rsdAttributes, '')
								FOR XML PATH('rdsDynamicContentProperty'), TYPE)
							FOR XML PATH('rdsSubclient'), TYPE)
						FOR XML PATH('App_RDSSubclientContentListReq'), TYPE)
					)
		------------------------------------------------------------
		--- SET modified value for contents to be modified   	 ---
		------------------------------------------------------------
		UPDATE rdsMap
		SET modified = @currentTime
		FROM (
				SELECT in_rdsMap.dbName, in_rdsMap.modified, CR.RegionCode, in_rdsMap.dbType
				 FROM APP_RDSSubclientContentMap in_rdsMap
				 LEFT JOIN
					App_CloudVendorRegion as CR
					ON CR.id = in_rdsMap.regionId
				WHERE subclientId = @subclientId
					  AND modified = 0
			 ) as rdsMap
			 JOIN @i_xml.nodes('App_RDSSubclientContentListReq/rdsSubclient/rdsDynamicContentProperty') as propertyList(content)
			 ON propertyList.content.value('@dbName', 'NVARCHAR(MAX)') = rdsMap.dbName
			 	AND propertyList.content.value('@regionName', 'NVARCHAR(MAX)') = rdsMap.RegionCode
				AND propertyList.content.value('@dbType', 'NVARCHAR(MAX)') = rdsMap.dbType
		SET @opType = 3
	END
	IF @optype = 3  -- CloudAppsOperationType.ADD
	BEGIN
		------------------------------------------------------------
		--		Insert new/updated content        				  --
		------------------------------------------------------------
		INSERT INTO APP_RDSSubclientContentMap
		SELECT 	@subclientId,
				propertyList.content.value('@tag', 'NVARCHAR(MAX)'),
				propertyList.content.value('@dbName', 'NVARCHAR(MAX)'),
				CR.id,
				propertyList.content.value('@dbType', 'NVARCHAR(MAX)'),
				propertyList.content.value('@securityGroup','NVARCHAR(MAX)'),
				CAST((SELECT
						rds.attributes.value('(/rdsAttributesObj/@availabilityZone)[1]', 'NVARCHAR(1024)') as '@availabilityZone',
						rds.attributes.value('(/rdsAttributesObj/@dbSubnetGroup)[1]', 'NVARCHAR(1024)') as '@dbSubnetGroup',
						rds.attributes.value('(/rdsAttributesObj/@instanceType)[1]', 'NVARCHAR(1024)') as '@instanceType',
						rds.attributes.value('(/rdsAttributesObj/@service)[1]', 'NVARCHAR(1024)') as '@service',
						rds.attributes.value('(/rdsAttributesObj/@parameterGroup)[1]', 'NVARCHAR(1024)') as '@parameterGroup',
						rds.attributes.value('(/rdsAttributesObj/@tags)[1]', 'NVARCHAR(1024)') as '@tags',
						rds.attributes.value('(/rdsAttributesObj/@optionGroup)[1]', 'NVARCHAR(1024)') as '@optionGroup',
						rds.attributes.value('(/rdsAttributesObj/@iops)[1]', 'NVARCHAR(1024)') as '@iops',
						rds.attributes.value('(/rdsAttributesObj/@size)[1]', 'NVARCHAR(1024)') as '@size',
						rds.attributes.value('(/rdsAttributesObj/@numberOfNodes)[1]', 'NVARCHAR(1024)') as '@numberOfNodes',
						rds.attributes.value('(/rdsAttributesObj/@snapshotSize)[1]', 'NVARCHAR(1024)') as '@snapshotSize'
					FROM (SELECT propertyList.content.query('rdsAttributesObj')) as rds(attributes)
					FOR XML PATH('App_RDSAttributes'), TYPE) AS NVARCHAR(MAX)),
				@currentTime,
				0,
				0
		FROM @i_xml.nodes('/App_RDSSubclientContentListReq/rdsSubclient/rdsDynamicContentProperty') as propertyList(content)
			 LEFT JOIN App_CloudVendorRegion CR
			 ON CR.RegionCode = propertyList.content.value('@regionName', 'NVARCHAR(MAX)')
	END
	SELECT	@xmlResult,
			(SELECT
				@errorCode as '@errorCode',
				@errorMsg as '@errorMessage'
				FOR XML PATH('response'), TYPE)
	FOR XML PATH('App_RDSSubclientContentListResp'), TYPE
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetRDSSubclientContentList')
	delete from GxQscripts where name = 'APPGetRDSSubclientContentList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetRDSSubclientContentList')
	delete from GXDBVersions where aliasname = 'APPGetRDSSubclientContentList'
GO

insert into GXDBVersions values(2, 'APPGetRDSSubclientContentList',  'v1.1.2.9.20.1', 'APPGetRDSSubclientContentList', 'v1.1.2.9.20.1')
GO

