

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetProxyRoleForClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetProxyRoleForClient.sp,v $ $Id: APPGetProxyRoleForClient.sp,v 1.1.2.5 2020/08/05 00:52:48 rkulkarni Exp $";
--	+===================================================================+
--	| APPGetProxyRoleForClient -  ???
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetProxyRoleForClient')
BEGIN
	print '>>> Drop Stored Procedure: APPGetProxyRoleForClient <<<'
	drop procedure APPGetProxyRoleForClient
END
IF EXISTS (select * from GxQscripts where name='APPGetProxyRoleForClient')
	delete from GxQscripts where name = 'APPGetProxyRoleForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetProxyRoleForClient')
	delete from GXDBVersions where aliasname = 'APPGetProxyRoleForClient'
GO
print '... Creating Procedure: APPGetProxyRoleForClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetProxyRoleForClient
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
-----------------------------------------------------------
  @clientId int,
  @filerName VARCHAR(1024),
  @isPseudoClient VARCHAR(10)
-----------------------------------------------------------
AS
  DECLARE @ProxyRole VARCHAR(MAX)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @PRIMARY_CLIENT_ATTR  NVARCHAR(80) = N'FPOLICY PRIMARY CLIENT'
DECLARE @SECONDARY_CLIENT_ATTR  NVARCHAR(80) = N'FPOLICY SECONDARY CLIENT'
DECLARE @ATTRVAL            NVARCHAR(10)
DECLARE @IS_ARCHIVER        INTEGER
--
SET @ATTRVAL = (CONVERT(NVARCHAR(10), @clientId))
SET @IS_ARCHIVER = 0
	IF OBJECT_ID('TEMPDB.DBO.#TEMPCLIENT') IS NOT NULL  DROP TABLE #TEMPCLIENT
		CREATE TABLE #TEMPCLIENT (CLIENTID INTEGER)
	IF OBJECT_ID('TEMPDB.DBO.#TEMPPROXYROLE') IS NOT NULL  DROP TABLE #TEMPPROXYROLE
		CREATE TABLE #TEMPPROXYROLE (PROXYROLE VARCHAR(15))
	IF @isPseudoClient = 'true'
		BEGIN
		-- IF INPUT CLIENT ID IS A PSEUDO CLIENT ID GET CORRESPONDING CLIENT ID(S) AND STORE IN TEMP TABLE
			INSERT INTO #TEMPCLIENT(CLIENTID)
				SELECT DS.CLIENTID AS CLIENTID FROM DM2SEARCHSERVERCOREINFO DS
				JOIN DM2CLOUD DC ON DC.CLOUDID = DS.CLOUDID
				AND DC.PSEUDOCLIENTID = @clientId
		END
	ELSE
		BEGIN
		-- IF INPUT CLIENT ID IS ACCESS NODE ID THEN STORE INPUIT PARAM VALUE IN TEMP TABLE
			INSERT INTO #TEMPCLIENT(CLIENTID) VALUES (@clientId)
		END
	 --GET IF PRIMARY FPOLICY FOR CLIENT
	 IF EXISTS (SELECT 1
		 FROM APP_SubClientProp SCP
		 JOIN
		 (
		 SELECT APP.id, APP.clientId FROM APP_IDAProp PROP
		 JOIN APP_IDAName IDA ON IDA.id=PROP.componentNameId
		 JOIN APP_Application APP ON APP.clientId=IDA.clientId
		 WHERE PROP.attrName=@PRIMARY_CLIENT_ATTR
			 AND PROP.attrVal IN (SELECT CLIENTID FROM #TEMPCLIENT)
			 AND PROP.modified = 0
			 AND APP.appTypeId IN ( SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(22, 0)) --APPGRP_W2KFileSystem
			 AND APP.subclientStatus&54=0    --CV_STATUS_UNINSTALLED, CV_STATUS_DELETED, CV_STATUS_DUMMY, CV_STATUS_HIDDEN
		 ) P ON P.id = SCP.componentNameId
		 JOIN APP_Client C ON C.id=P.clientId AND C.net_hostname = @filerName
	 )
	 BEGIN
		SET @IS_ARCHIVER = 1
	 END
	IF @IS_ARCHIVER = 0
		BEGIN
			--GET IF SECONDARY FPOLICY FOR CLIENT
			IF EXISTS (SELECT 1
				 FROM APP_SubClientProp SCP WITH (NOLOCK)
				 JOIN
				(
				SELECT APP.id, APP.clientId FROM APP_IDAProp PROP WITH (NOLOCK)
				 JOIN APP_IDAName IDA WITH (NOLOCK) ON IDA.id=PROP.componentNameId
				 JOIN APP_Application APP WITH (NOLOCK) ON APP.clientId=IDA.clientId
				 WHERE PROP.attrName=@SECONDARY_CLIENT_ATTR
					 AND PROP.attrVal IN (SELECT CLIENTID FROM #TEMPCLIENT)
					 AND PROP.modified = 0
					 AND APP.appTypeId IN ( SELECT appTypeId FROM dbo.GetAppTypesForAppGroup(22, 0)) --APPGRP_W2KFileSystem
					 AND APP.subclientStatus&54=0    --CV_STATUS_UNINSTALLED, CV_STATUS_DELETED, CV_STATUS_DUMMY, CV_STATUS_HIDDEN
				 ) P ON P.id = SCP.componentNameId
				 JOIN APP_Client C WITH (NOLOCK) ON C.id=P.clientId AND C.net_hostname = @filerName
			)
			BEGIN
				SET @IS_ARCHIVER = 1
			END
		END
		IF @IS_ARCHIVER = 1
			BEGIN
				SELECT 'ARCHIVER' AS ProxyRole
			END
		ELSE IF @IS_ARCHIVER = 0
			BEGIN
				;WITH CTE1 AS
				(
					SELECT dsp.DataSourceId
					FROM SEDataSourceProperty DSP join
						SEProperty P
						on P.PropertyId = DSP.PropertyId and P.PropertyName = 'hostname' and DSP.PropertyValue = @filerName
				),
				CTE AS (
						SELECT DataSourceId AS DataSourceId, [accessnodeclientid] 'accessClientId' , [enablemonitoring] 'EnableMonitoring', [pseudoclientid] 'Clientid'
						FROM
						(   SELECT DSP.DataSourceId, DSP.PropertyValue 'Value', p.PropertyName
							FROM SEDataSourceProperty DSP  WITH (NOLOCK)  INNER JOIN
									CTE1 ON CTE1.DataSourceId = DSP.DataSourceId
								INNER JOIN  SEProperty P ON DSP.PropertyId = P.PropertyId
								WHERE P.PropertyName IN ('accessnodeclientid', 'enablemonitoring', 'pseudoclientid')
						) AS SourceTable
						PIVOT
						( MIN(Value) FOR PropertyName IN ([accessnodeclientid], [enablemonitoring], [pseudoclientid]) ) AS PivotTable
					)
				INSERT INTO #TEMPPROXYROLE
					SELECT ProxyRole = 'MONITORING' FROM CTE
					INNER JOIN APP_Client A ON CTE.Clientid = A.id
					WHERE accessClientId = @clientId and EnableMonitoring = 'True'
				IF EXISTS (SELECT 1 FROm #TEMPPROXYROLE)
					SELECT 'MONITORING' AS ProxyRole
				ELSE
					SELECT 'NONE' AS ProxyRole
			END
			IF OBJECT_ID('tempdb.dbo.#tempClient') IS NOT NULL 	DROP TABLE #tempClient
			IF OBJECT_ID('tempdb.dbo.#TEMPPROXYROLE') IS NOT NULL 	DROP TABLE #TEMPPROXYROLE
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetProxyRoleForClient')
	delete from GxQscripts where name = 'APPGetProxyRoleForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetProxyRoleForClient')
	delete from GXDBVersions where aliasname = 'APPGetProxyRoleForClient'
GO

insert into GXDBVersions values(2, 'APPGetProxyRoleForClient',  '00010001000200050000', 'APPGetProxyRoleForClient', '00010001000200050000')
GO

