

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetProxyClientInfoXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetProxyClientInfoXML.sp,v $ $Id: APPGetProxyClientInfoXML.sp,v 1.1.2.1 2019/05/03 07:01:05 dkraplanee Exp $";
-- =============================================
-- Author:		Dinesh Kriplani
-- Create date: 04/10/2011
-- Description:	Get the xml response for pseudo proxy client
-- =============================================
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "APPGetProxyClientInfoXML"						|
--	|																		|
--	|THIS PROCEDURE WILL return proxy xml repsonse							|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS	                                                |
--  | Tinku:CCM:Archive File Id's are no longer unique						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetProxyClientInfoXML')
BEGIN
	print '>>> Drop Stored Procedure: APPGetProxyClientInfoXML <<<'
	drop procedure APPGetProxyClientInfoXML
END
IF EXISTS (select * from GxQscripts where name='APPGetProxyClientInfoXML')
	delete from GxQscripts where name = 'APPGetProxyClientInfoXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetProxyClientInfoXML')
	delete from GXDBVersions where aliasname = 'APPGetProxyClientInfoXML'
GO
print '... Creating Procedure: APPGetProxyClientInfoXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetProxyClientInfoXML
  @input xml,
  @in_isaddResources integer
AS
  DECLARE @o_ProxyInfo NVARCHAR(MAX)
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#tmpClient') IS NOT NULL drop table #tmpClient
create table #tmpClient
	(	ClientId		integer,
		subclientId		integer,
		INSTANCE		integer,
		appTypeId		integer
	)
INSERT INTO #tmpClient
SELECT
	csInfo.n.value('@clientId', 'INT'),
	ISNULL(csInfo.n.value('@subclientId', 'INT'),0),
	ISNULL(csInfo.n.value('@instance', 'INT'),0),
	ISNULL(csInfo.n.value('@appTypeId', 'INT'),0)
FROM  @input.nodes('/App_GetProxyClientsInfoReq/pseudoClient') AS csInfo(n)
 where @input.exist('/App_GetProxyClientsInfoReq/pseudoClient/@_type_') =1
IF object_id('tempdb.dbo.#tmpClientProxyPairs') IS NOT NULL drop table #tmpClientProxyPairs
create table #tmpClientProxyPairs(ClientId		integer,
						instanceId			integer,
						proxyClientId			integer,
						ClientAppType				integer,
						isIndexServer				integer DEFAULT 0,  --0 meaning proxyclient, 1 meaning index server
						iscloudindexServer 	integer DEFAULT 0,    -- 1 meaning cloud index server
						cloudindexServer 	integer DEFAULT 0,
						isproxyclientGroup 	integer DEFAULT 0 , -- 1 meaning client Group
						clientGroup		 	integer DEFAULT 0,
						subclientId		 	integer DEFAULT 0
						)
IF exists (select * from #tmpClient)
	EXEC APPGetProxyClientInfo '#tmpClient','#tmpClientProxyPairs',@in_isaddResources
DECLARE @xmloutput xml =(
  SELECT
	(SELECT ClientId as '@clientId',
		3 as '@_type_',
		C1.name as '@clientName'
		FROM APP_CLIENT C1 (NOLOCK) WHERE ID  =  ClientId
		for xml path('pseudoClient'), TYPE
    ),
    (SELECT
		3 as '@_type_',
		proxyClientId as '@clientId',
		C1.name as '@clientName'
		FROM APP_CLIENT C1 (NOLOCK) WHERE ID  =  proxyClientId
		for xml path('proxyClient'), TYPE
    )
FROM  (SELECT DISTINCT ClientId,proxyClientId FROM #tmpClientProxyPairs ) sub
 FOR XML PATH ('proxyClientInfo'))
DECLARE @OUT XML=( select @xmloutput for xml path( 'App_GetProxyClientsInfoResp'))
SELECT @OUT
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetProxyClientInfoXML')
	delete from GxQscripts where name = 'APPGetProxyClientInfoXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetProxyClientInfoXML')
	delete from GXDBVersions where aliasname = 'APPGetProxyClientInfoXML'
GO

insert into GXDBVersions values(2, 'APPGetProxyClientInfoXML',  '00010001000200010000', 'APPGetProxyClientInfoXML', '00010001000200010000')
GO

