

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetProxyClientInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetProxyClientInfo.sp,v $ $Id: APPGetProxyClientInfo.sp,v 1.1.2.13.8.3 2021/04/05 18:43:04 anarde Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "MMS2UpdateSlotNBayConfig"								|
--	|																		|
--	|THIS PROCEDURE WILL TEST TO SEE IF THE STRING "NEWSTRING" IS ALREADY A	|
--	| NAME IN THE TABLE, AND IF NOT INSERTS IT BEFORE RETURNING ALL ROWS 	|
--	| THAT MATCH THE SEARCH CRITERIA "ID < compVal".						|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A STORED PROCEDURE		|
--	| AND RETURNING RESULTS	                                                |
--  | Tinku:CCM:Archive File Id's are no longer unique						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPGetProxyClientInfo')
BEGIN
	print '>>> Drop Stored Procedure: APPGetProxyClientInfo <<<'
	drop procedure APPGetProxyClientInfo
END
IF EXISTS (select * from GxQscripts where name='APPGetProxyClientInfo')
	delete from GxQscripts where name = 'APPGetProxyClientInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetProxyClientInfo')
	delete from GXDBVersions where aliasname = 'APPGetProxyClientInfo'
GO
print '... Creating Procedure: APPGetProxyClientInfo'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPGetProxyClientInfo
  @tableInput NVARCHAR(MAX),
  @tableOutput NVARCHAR(MAX),
  @in_isaddResources integer
AS
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#tmpClientInputInternal') IS NOT NULL drop table #tmpClientInputInternal
create table #tmpClientInputInternal
						(	ClientId		integer,
							subclientId		integer,
							INSTANCE		integer,
							appTypeId		integer
						)
CREATE CLUSTERED INDEX tmpClientInputInternal_idx ON #tmpClientInputInternal (appTypeId, clientId)
CREATE NONCLUSTERED INDEX tmpClientInputInternal_idx2 ON #tmpClientInputInternal (ClientId, subclientId)
IF (LEN(@tableInput)>0)
BEGIN
	DECLARE @SQLStatement NVARCHAR(MAX)
	SET @SQLStatement = 'INSERT INTO #tmpClientInputInternal (clientId,subclientId, INSTANCE ,appTypeId) '
	SET @SQLStatement += ' SELECT DISTINCT A.clientId, A.id, A.INSTANCE ,A.appTypeId FROM ' + @tableInput+ ' C'
	SET @SQLStatement += ' INNER JOIN APP_Application A (NOLOCK)  ON C.ClientId = A.CLIENTID   AND (A.id = C.subclientId OR C.subclientId  = 0) AND (A.INSTANCE = C.INSTANCE OR C.INSTANCE  = 0) AND (A.appTypeId = C.appTypeId OR C.appTypeId  = 0)
	And (A.subclientStatus & 6) = 0'
	EXEC (@SQLStatement)
	SET @SQLStatement = 'INSERT INTO #tmpClientInputInternal (clientId,subclientId, INSTANCE ,appTypeId) '
	SET @SQLStatement += ' SELECT DISTINCT i.clientId, 0, 0 ,i.appTypeId FROM ' + @tableInput+ ' C'
	SET @SQLStatement += ' INNER JOIN  APP_IDAName I (NOLOCK)  ON (C.ClientId = i.CLIENTID) AND (I.appTypeId = C.appTypeId OR C.appTypeId  = 0)'
	SET @SQLStatement += ' LEFT OUTER JOIN #tmpClientInputInternal input ON input.clientId = C.ClientId  WHERE  input.clientId IS NULL'
	EXEC (@SQLStatement)
END
ELSE
BEGIN
	INSERT INTO #tmpClientInputInternal (clientId,subclientId, INSTANCE ,appTypeId)
	SELECT DISTINCT A.CLIENTID,id, A.INSTANCE ,A.appTypeId
	FROM APP_Application A (NOLOCK)
	WHERE (A.subclientStatus & 6) = 0  	-- uninstalled OR deleted
	UNION
	SELECT DISTINCT I.clientId, 0, 0 , I.appTypeId
	FROM APP_IDAName I (NOLOCK)
	WHERE (I.status & 6) = 0
END
IF object_id('tempdb.dbo.#tmpClientProxyPairsinternal') IS NOT NULL drop table #tmpClientProxyPairsinternal
create table #tmpClientProxyPairsinternal(ClientId		integer,
						instanceId			integer,
						proxyClientId			integer,
						ClientAppType				integer,
						isIndexServer				integer DEFAULT 0,  --0 meaning proxyclient, 1 meaning index server
						iscloudindexServer 	integer DEFAULT 0,    -- 1 meaning cloud index server
						cloudindexServer 	integer DEFAULT 0,
						isproxyclientGroup 	integer DEFAULT 0 , -- 1 meaning client Group
						clientGroup		 	integer DEFAULT 0,
						subclientId		 	integer DEFAULT 0
						)
CREATE CLUSTERED INDEX tmpClientProxyPairsinternal_idx ON #tmpClientProxyPairsinternal (proxyClientId)
-- Get the Client and proxy pairs here (AMAZON CLOUD)
IF EXISTS((SELECT 1 FROM #tmpClientInputInternal WHERE appTypeId = 134 ))
BEGIN
	IF object_id('tempdb.dbo.#tmpcloudproxyClientInfo') IS NOT NULL drop table #tmpcloudproxyClientInfo
	create table #tmpcloudproxyClientInfo(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer,
					cloudAppsInstType	integer,
					ProxyClientXml XML
					)
	insert into #tmpcloudproxyClientInfo (ClientId,instanceId,ClientAppType)
	SELECT DISTINCT CLIENTID, INSTANCE ,appTypeId
	FROM #tmpClientInputInternal C (NOLOCK)
WHERE C.appTypeId = 134
	UPDATE C
	SET cloudAppsInstType = ISNULL(prop.attrVal, 0)
	FROM #tmpcloudproxyClientInfo C
	INNER JOIN APP_InstanceProp prop (NOLOCK)
	ON	prop.componentNameId = C.instanceId
	AND prop.attrName = 'Cloud Apps Instance Type'
	AND prop.modified = 0
	UPDATE C
	SET ProxyClientXml = ISNULL(prop.attrVal, '')
	FROM #tmpcloudproxyClientInfo C
	INNER JOIN APP_InstanceProp prop (NOLOCK)
	ON	prop.componentNameId = C.instanceId AND prop.modified = 0
	AND ((prop.attrName = 'Proxy Clients' AND C.cloudAppsInstType IN (1, 2, 35/*D365*/, 36/*Teams*/))
			OR (prop.attrName = 'Amazon S3 Proxy Clients' AND C.cloudAppsInstType =5)
			OR (prop.attrName = 'Azure Proxy Clients' AND C.cloudAppsInstType =6)
			OR (prop.attrName = 'Proxy Clients' AND C.cloudAppsInstType =7)
			OR (prop.attrName = 'Oracle Cloud Proxy Clients' AND C.cloudAppsInstType =14)
			OR (prop.attrName = 'Openstack Proxy Clients' AND C.cloudAppsInstType =15)
			OR (prop.attrName = 'Google Cloud Proxy Clients' AND C.cloudAppsInstType =20)
			OR (prop.attrName = 'Azure DL Proxy Clients' AND C.cloudAppsInstType =21)
			OR (prop.attrName = 'Vs Member Servers' AND C.cloudAppsInstType =4)
			OR (prop.attrName = 'IBM COS Proxy Clients' AND C.cloudAppsInstType =24)
			OR (prop.attrName = 'Ali OSS Proxy Clients' AND C.cloudAppsInstType =25)
			)
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,instanceId,proxyClientId,ClientAppType)
	SELECT DISTINCT c.ClientId,C.instanceId, a.value('(@clientId)[1]', 'int') as proxy,C.ClientAppType
	FROM #tmpcloudproxyClientInfo C
	CROSS APPLY C.ProxyClientXml.nodes('App_GeneralCloudProperties/proxyServers') rc(a)
	WHERE
       a.value('@clientId', 'int') IS NOT NULL
	UNION
	SELECT distinct c.ClientId,C.instanceId, a.value('(@clientId)[1]', 'int') as proxy,C.ClientAppType
	FROM #tmpcloudproxyClientInfo C
	CROSS APPLY C.ProxyClientXml.nodes('App_MemberServers/memberServers/client') rc(a)
	WHERE
       a.value('@clientId', 'int') IS NOT NULL
	UNION
	SELECT c.ClientId, C.instanceId, cast(prop.attrVal as int ),C.ClientAppType
	FROM #tmpcloudproxyClientInfo C
		INNER JOIN APP_InstanceProp prop (NOLOCK)
		ON	prop.componentNameId = C.instanceId AND prop.modified = 0
		AND (prop.attrName = 'Salesforce backup client' AND C.cloudAppsInstType =3)
	UNION
	SELECT DISTINCT C.ClientId, C.instanceId, a.value('(@clientId)[1]', 'int'), C.ClientAppType
	FROM #tmpcloudproxyClientInfo C
	CROSS APPLY C.ProxyClientXml.nodes('App_GeneralCloudProperties/memberServers/client') rc(a)
	WHERE a.value('@clientId', 'int') IS NOT NULL
	INSERT INTO #tmpClientProxyPairsinternal(ClientId, instanceId, proxyClientId, clientGroup, isproxyclientGroup, ClientAppType)
	SELECT DISTINCT C.ClientId, C.instanceID, CG.clientId, a.value('(@clientGroupId)[1]', 'int'), 1, C.ClientAppType
	FROM #tmpcloudproxyClientInfo C
	CROSS APPLY C.ProxyClientXml.nodes('App_GeneralCloudProperties/memberServers/client') rc(a)
	INNER JOIN APP_ClientGroupAssoc(NOLOCK) CG ON CG.clientGroupId = a.value('(@clientGroupId)[1]', 'int')
	WHERE a.value('(@clientGroupId)[1]', 'int') IS NOT NULL AND a.value('(@clientGroupId)[1]', 'int') > 0
	IF @in_isaddResources = 1 -- add CloudApps index server details
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#tempCloudIndexServerInfo') IS NOT NULL
				DROP TABLE #tempCloudIndexServerInfo
			CREATE TABLE #tempCloudIndexServerInfo
			(
				psuedoClientId INT,
				instanceId INT,
				indexServer INT,
				isCloudIndexServer INT
			)
			-- insert OneDrive/Teams/D365 index server
			INSERT INTO #tempCloudIndexServerInfo (psuedoClientId, instanceId, indexServer, isCloudIndexServer)
			SELECT T.ClientId, T.instanceId, CAST(I.attrVal AS INT), 1
			FROM #tmpcloudproxyClientInfo T
			INNER JOIN APP_InstanceProp(NOLOCK) I ON T.instanceId = I.componentNameId
			AND attrName IN ('OneDrive Index Server', 'V2CloudApps Index Server') AND I.modified = 0
			UPDATE T
			SET T.isCloudIndexServer = 0
			FROM #tempCloudIndexServerInfo T
			INNER JOIN simInstalledPackages(NOLOCK) I ON T.indexServer = I.ClientId
			IF OBJECT_ID('tempdb.dbo.#tempCloudIndexServerClient') IS NOT NULL
				DROP TABLE #tempCloudIndexServerClient
			CREATE TABLE #tempCloudIndexServerClient
			(
				pseudoClientId INT,
				instanceId INT,
				indexServer INT,
				isCloudIndexServer INT,
				cloudIndexServer INT
			)
			INSERT INTO #tempCloudIndexServerClient (pseudoClientId, instanceId, indexServer, isCloudIndexServer, cloudIndexServer)
			SELECT T.psuedoClientId, T.instanceId, T.indexServer, T.isCloudIndexServer, 0
			FROM #tempCloudIndexServerInfo T
			WHERE T.isCloudIndexServer = 0
			UNION
			SELECT I.psuedoClientId, I.instanceId, DS.ClientId, I.isCloudIndexServer, I.indexServer
			FROM DM2SearchServerCoreInfo DS
			INNER JOIN DM2Cloud DC ON DS.CloudId = DC.cloudId
			INNER JOIN #tempCloudIndexServerInfo I ON I.indexServer = DC.pseudoClientId AND I.isCloudIndexServer = 1
			UPDATE T
			SET T.isIndexServer = 1, T.iscloudindexServer = I.isCloudIndexServer, T.cloudindexServer = I.cloudIndexServer, T.isproxyclientGroup = 0, T.clientGroup = 0
			FROM #tmpClientProxyPairsinternal T
			INNER JOIN #tempCloudIndexServerClient I ON T.ClientId = I.pseudoClientId AND T.proxyClientId = I.indexServer
			INSERT INTO #tmpClientProxyPairsinternal (ClientId, instanceId, proxyClientId, ClientAppType, isIndexServer, iscloudindexServer, cloudindexServer)
SELECT DISTINCT I.pseudoClientId, I.instanceId, I.indexServer, 134, 1, I.iscloudindexServer, I.cloudindexServer
			FROM #tempCloudIndexServerClient I
			LEFT OUTER JOIN #tmpClientProxyPairsinternal T ON T.ClientId = I.pseudoClientId  AND T.proxyClientId = I.indexServer  AND T.instanceId = I.instanceId
			WHERE T.proxyClientId IS NULL
			IF OBJECT_ID('tempdb.dbo.#tempCloudIndexServerClient') IS NOT NULL
				DROP TABLE #tempCloudIndexServerClient
			IF OBJECT_ID('tempdb.dbo.#tempCloudIndexServerInfo') IS NOT NULL
				DROP TABLE #tempCloudIndexServerInfo
		END
	IF OBJECT_ID('tempdb.dbo.#tmpcloudproxyClientInfo') IS NOT NULL
		DROP TABLE #tmpcloudproxyClientInfo
END
IF EXISTS((SELECT 1 FROM #tmpClientInputInternal WHERE appTypeId = 64 ))
			-- Get the Client and proxy pairs here (green plum ,HADOOP, GPFS, UXFS)
BEGIN
	IF object_id('tempdb.dbo.#tmpproxyClientInfo') IS NOT NULL drop table #tmpproxyClientInfo
	create table #tmpproxyClientInfo(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer,
					DistributedAppsInstType	integer
					)
	insert into #tmpproxyClientInfo (ClientId,instanceId,ClientAppType)
	SELECT DISTINCT CLIENTID, INSTANCE,appTypeId
	FROM #tmpClientInputInternal
WHERE appTypeId = 64
	UPDATE C
	SET DistributedAppsInstType = ISNULL(prop.attrVal, 0)
	FROM #tmpproxyClientInfo C
	INNER JOIN APP_InstanceProp prop (NOLOCK)
	ON	prop.componentNameId = C.instanceId
	AND prop.attrName = 'Distributed Cluster Type'
	AND prop.modified = 0
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,instanceId,proxyClientId,ClientAppType)
	SELECT DISTINCT tmp.ClientId,tmp.instanceId,CAST(prop.attrVal AS INT), tmp.ClientAppType FROM #tmpproxyClientInfo tmp
	INNER JOIN APP_InstanceProp prop (NOLOCK)
	ON	prop.componentNameId = tmp.instanceId
	AND prop.attrName = 'Greenplum Master Client Id'
	AND tmp.DistributedAppsInstType =1  --GREENPLUM
	AND prop.modified = 0
	UNION
	SELECT DISTINCT tmp.ClientId,tmp.instanceId,CAST(prop.attrVal AS INT),tmp.ClientAppType FROM #tmpproxyClientInfo tmp
	INNER JOIN APP_InstanceProp prop (NOLOCK)
	ON	prop.componentNameId = tmp.instanceId
	AND prop.attrName = 'Coordinator Node'
	AND tmp.DistributedAppsInstType <>1  --GREENPLUM
	AND prop.modified = 0
	UNION
	SELECT DISTINCT subclient.clientid, tmp.instanceId,mongoDbAssociation.clientId, tmp.ClientAppType FROM #tmpproxyClientInfo tmp
	INNER JOIN App_MongoDbAssociation mongoDbAssociation WITH (NOLOCK) ON mongoDbAssociation.instanceId = tmp.instanceId
	INNER JOIN APP_Application subclient WITH (NOLOCK) ON subclient.instance = tmp.instanceId
	AND tmp.DistributedAppsInstType =8 --MONGODB
	IF object_id('tempdb.dbo.#tmpproxyClientXML') IS NOT NULL drop table #tmpproxyClientXML
	create table #tmpproxyClientXML(ClientId		integer,
				instanceId			integer,
				proxystandbyxml XML,
				ClientAppType				integer
				)
	INSERT INTO #tmpproxyClientXML (ClientId,instanceId,proxystandbyxml,ClientAppType)
	SELECT tmp.ClientId,tmp.instanceId,CAST ( substring (prop.attrVal, CHARINDEX('<App_DataAccessNodes>',prop.attrVal ), LEN(prop.attrVal)-CHARINDEX('<App_DataAccessNodes>',prop.attrVal) +1)  AS XML) ,A.APPTYPEID  FROM #tmpproxyClientInfo tmp
	INNER JOIN #tmpClientInputInternal A (NOLOCK)
ON	tmp.ClientId = A.CLIENTID AND A.APPTYPEID = 64
	INNER JOIN APP_SubClientProp prop (NOLOCK)
	ON	prop.componentNameId = A.subclientid
	AND prop.attrName = 'Data Access Nodes'
	AND prop.cs_attrName = CHECKSUM(N'Data Access Nodes')
	AND tmp.DistributedAppsInstType <>1  ---HADOOP, GPFS, UXFS
	AND prop.modified = 0
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,instanceId,proxyClientId,ClientAppType)
	SELECT distinct c.ClientId,C.instanceId, a.value('(@clientId)[1]', 'int') as proxy,C.ClientAppType
	FROM #tmpproxyClientXML C
	CROSS APPLY C.proxystandbyxml.nodes('App_DataAccessNodes/dataAccessNodes') rc(a)
	  WHERE
       a.value('@clientId', 'int') IS NOT NULL
END
IF EXISTS((SELECT 1 FROM #tmpClientInputInternal WHERE appTypeId = 137   ))
			-- Get the Client and proxy pairs here (EXCHANGE ONE PASS)
BEGIN
	IF object_id('tempdb.dbo.#tmpexchproxyClientxml') IS NOT NULL drop table #tmpexchproxyClientxml
	create table #tmpexchproxyClientxml(ClientId		integer,
					instanceId INT,
					AppsType	integer,
					ProxyClientXml XML
					)
	IF object_id('tempdb.dbo.#tmpexchproxyClientInfo') IS NOT NULL drop table #tmpexchproxyClientInfo
	create table #tmpexchproxyClientInfo(pseudoClientId		integer,
										instanceId INT,
										entityType integer,
										clientId integer ,
										clientgroupId integer,
										ClientAppType  integer
					)
	insert into #tmpexchproxyClientxml (ClientId,AppsType,instanceId)
	SELECT DISTINCT CLIENTID, appTypeId,instance
	FROM #tmpClientInputInternal
WHERE appTypeId = 137
	UPDATE t
	SET ProxyClientXml = CAST ( replace (P.attrVal, 'UTF-8', 'UTF-16')  AS XML)
	FROM APP_IDAProp P (NOLOCK)
	INNER JOIN APP_IDAName N (NOLOCK) ON  P.componentNameId = N.id
	INNER JOIN #tmpexchproxyClientxml t (NOLOCK) ON  t.AppsType = N.appTypeId
	AND N.clientId = t.ClientId
	AND attrName = 'OnePass Member Servers' AND p.modified = 0
	INSERT INTO #tmpexchproxyClientInfo(pseudoClientId,entityType,clientId,clientgroupId,ClientAppType,instanceId)
	SELECT c.ClientId,
		ISNULL(a.value('@_type_', 'int'),0) ,
		ISNULL(a.value('@clientId', 'int'),0),
		ISNULL(a.value('@clientGroupId', 'int'),0),
		C.AppsType,
		C.instanceId
	FROM #tmpexchproxyClientxml C
	 CROSS APPLY C.ProxyClientXml.nodes('App_MemberServers/memberServers/client') rc(a)
	  WHERE
       a.value('@clientId', 'int') IS NOT NULL
	  OR a.value('@clientGroupId', 'int') IS NOT NULL
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT DISTINCT  c.pseudoClientId, C.clientId as proxy,C.ClientAppType,C.instanceId
	FROM #tmpexchproxyClientInfo C
	  WHERE
C.entityType = 3 AND  C.clientId>1
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,isproxyclientGroup,clientGroup,instanceId)
	SELECT DISTINCT  c.pseudoClientId, ACG.clientId as proxy,C.ClientAppType,1,ACG.clientGroupId,C.instanceId
	FROM #tmpexchproxyClientInfo C
	INNER JOIN APP_ClientGroupAssoc ACG
	ON  ACG.clientGroupId = C.clientgroupId
	INNER JOIN simInstalledPackages P
ON P.ClientId =  ACG.clientId AND P.simPackageID IN ( 152, 151 )
	  WHERE
C.entityType =28 and C.clientId = 0
	-- Backup Proxy List : So delete clients with deconfigured/deleted  agents.
	delete E FROM  #tmpClientProxyPairsinternal E
	INNER JOIN App_IdaName Ida WITH (READUNCOMMITTED) ON E.proxyClientId = Ida.clientId where
Ida.appTypeId = 54 and (status & 6) > 0 and isproxyclientGroup>0
	if(@in_isaddResources=1)
	BEGIN
		IF object_id('tempdb.dbo.#tmpexchIndexServerInfo') IS NOT NULL drop table #tmpexchIndexServerInfo
		create table #tmpexchIndexServerInfo(pseudoClientId		integer,
									instanceId			integer,
									indexServer 	integer,
									iscloudindexServer 	integer
									)
		INSERT INTO #tmpexchIndexServerInfo(pseudoClientId,instanceId,indexServer,iscloudindexServer)
		 SELECT T.clientId ,T.instanceId,cast(attrVal as integer),1
				FROM  APP_iDAName N INNER JOIN #tmpexchproxyClientxml T  ON T.clientId = N.clientId
				INNER JOIN APP_IDAProp P ON N.apptypeId = T.AppsType AND P.componentNameId = N.id AND
				P.attrname = 'OnePass Index Server' AND P.modified = 0
		UPDATE I
		SET iscloudindexServer = 0
		FROM #tmpexchIndexServerInfo I
		INNER JOIN simInstalledPackages P
		ON P.ClientId = I.indexServer
		IF object_id('tempdb.dbo.#tmpexchIndexServerClient') IS NOT NULL drop table #tmpexchIndexServerClient
		create table #tmpexchIndexServerClient(pseudoClientId		integer,
									instanceId INTEGER,
									indexServer 	integer,
									iscloudindexServer 	integer,
									cloudindexServer 	integer
									)
		INSERT INTO #tmpexchIndexServerClient(pseudoClientId,instanceId,indexServer,iscloudindexServer,cloudindexServer)
		SELECT I.pseudoClientId,I.instanceId,I.indexServer,I.iscloudindexServer,0
		FROM #tmpexchIndexServerInfo I
		WHERE iscloudindexServer = 0
		UNION
		SELECT I.pseudoClientId,I.instanceId, DS.ClientId,I.iscloudindexServer,I.indexServer
		FROM DM2SearchServerCoreInfo DS
		INNER JOIN Dm2Cloud DC ON
		DS.cloudid = DC.cloudId
		INNER JOIN #tmpexchIndexServerInfo I ON
		I.indexServer  = DC.pseudoClientId
		AND I.iscloudindexServer =1
		update t
		SET T.isIndexServer =  1 ,
			T.iscloudindexServer = I.iscloudindexServer,
			T.cloudindexServer = I.cloudindexServer,
			T.isproxyclientGroup = 0,
			T.clientGroup =0
		FROM #tmpClientProxyPairsinternal T
		INNER JOIN  #tmpexchIndexServerClient I
		ON T.ClientId = I.pseudoClientId  AND T.proxyClientId = I.indexServer
		INSERT INTO #tmpClientProxyPairsinternal(ClientId,instanceId,proxyClientId,ClientAppType,isIndexServer,iscloudindexServer,cloudindexServer)
SELECT DISTINCT  I.pseudoClientId,I.instanceId,I.indexServer,137,1,I.iscloudindexServer,I.cloudindexServer
		 FROM #tmpexchIndexServerClient I
		 LEFT OUTER JOIN #tmpClientProxyPairsinternal T ON T.ClientId = I.pseudoClientId  AND T.proxyClientId = I.indexServer  AND T.instanceId = I.instanceId
		 WHERE T.proxyClientId IS NULL
		 drop table #tmpexchIndexServerInfo
		 drop table #tmpexchIndexServerClient
	 END
	 drop table #tmpexchproxyClientxml
	 drop table #tmpexchproxyClientInfo
END
IF EXISTS((SELECT 1 FROM #tmpClientInputInternal WHERE appTypeId = 80 ))
			-- Get the Client and proxy pairs here (CV_APPTYPE_ORACLE_RAC)
BEGIN
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT DISTINCT  c.ClientId, orcl.ClientId as proxy,C.appTypeId,instance
	FROM #tmpClientInputInternal C
	INNER JOIN APP_OracleRacInstance as orcl WITH (READUNCOMMITTED)
	 ON C.instance = orcl.InstaceId
WHERE C.appTypeId = 80
END
IF EXISTS((SELECT 1 FROM #tmpClientInputInternal WHERE appTypeId = 53 ))
			-- Get the Client and proxy pairs here (CV_APPTYPE_MSEXCHANGE_DATABASE)
BEGIN
INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT DISTINCT
		ip.clientId,
		C.id ,
		ip.appTypeId ,
		a.instance
	from APP_ClientProp CP WITH (READUNCOMMITTED)
		join #tmpClientInputInternal  ip WITH (READUNCOMMITTED) on
			CP.componentnameId = ip.clientId
			AND cp.attrType = 125--PROPERTY_DAG_MEMBERSERVER
			and cp.modified = 0
		join APP_Client C WITH (READUNCOMMITTED) on
			c.net_hostname like CP.attrName
		INNER JOIN APP_Application  A (NOLOCK) ON
			A.ID = ip.SubClientId
			AND A.appTypeId = ip.appTypeId
END
IF EXISTS ((SELECT 1 FROM #tmpClientInputInternal WHERE appTypeId = 106  ))
			-- Get the Client and proxy pairs here (CV_APPTYPE_VIRTUAL_SERVER)
BEGIN
	DECLARE @pseudoVSAClients XML;
		 SET @pseudoVSAClients =  (SELECT DISTINCT
		IDA.clientId '@id'
		FROM APP_IDAName IDA WITH (READUNCOMMITTED)
		INNER JOIN #tmpClientInputInternal I ON I.clientId = IDA.clientId
		WHERE
IDA.appTypeId = 106
			AND IDA.clientId IN (SELECT clientId FROM #tmpClientInputInternal)
		FOR XML PATH('client'), ROOT('pseudoVSAClients'), TYPE)
	IF object_id('tempdb.dbo.#AppGetVSMemberServersXML_InputTbl') IS NOT null	DROP TABLE #AppGetVSMemberServersXML_InputTbl
	CREATE TABLE #AppGetVSMemberServersXML_InputTbl(pseudoClient int, clientId int, clientGroupId int,instanceId integer,subClientId integer)
	EXEC AppGetVSMemberServersXML @pseudoVSAClients,1,'#AppGetVSMemberServersXML_InputTbl'
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId,subclientId)
SELECT  distinct pseudoClient, clientId,106 ,C.instanceId,C.subclientId
	from #AppGetVSMemberServersXML_InputTbl C
	where clientId>0
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,isproxyclientGroup,clientGroup,instanceId,subclientId)
SELECT DISTINCT  c.pseudoClient, ACG.clientId as proxy,106,1,ACG.clientGroupId,C.instanceId,C.subclientId
	FROM #AppGetVSMemberServersXML_InputTbl C
	INNER JOIN APP_ClientGroupAssoc ACG
	ON  ACG.clientGroupId = C.clientgroupId
	LEFT OUTER JOIN #tmpClientProxyPairsinternal T ON T.ClientId = c.pseudoClient  AND T.proxyClientId = ACG.clientId  AND T.instanceId = C.instanceId	 AND T.subclientId = C.subclientId
	  WHERE
       C.clientGroupId>0 and C.clientId=0 and  T.proxyClientId IS NULL
	-- Backup Proxy List : delete clients with no VSA packages. 713 is VSA package.
	DELETE t
	FROM #tmpClientProxyPairsinternal t
		LEFT OUTER JOIN simInstalledPackages SIP WITH (READUNCOMMITTED) ON
			SIP.ClientId = t.proxyClientId
AND SIP.simPackageId IN (713,1136 )
	WHERE
t.ClientAppType = 106
		AND SIP.ClientId IS NULL
	-- Backup Proxy List : So delete clients with deconfigured/deleted VSA agents.
	DELETE E
	FROM #tmpClientProxyPairsinternal E
		INNER JOIN App_IdaName Ida WITH (READUNCOMMITTED) ON
			E.proxyClientId = Ida.ClientId
AND Ida.appTypeId = 106
			AND (Ida.status & 4) = 4
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
		SELECT  DISTINCT
			C.pseudoClient,
			prop.attrVal,
			106 ,
			C.instanceId
		FROM #AppGetVSMemberServersXML_InputTbl C
			INNER JOIN APP_InstanceProp prop (NOLOCK) ON
				prop.componentNameId = C.instanceId
				AND prop.ATTRNAME = N'FBR Unix MA'
				AND prop.modified = 0
				AND LEN(prop.attrVal) < 12
				AND ISNUMERIC(prop.attrVal) = 1
				AND CAST(prop.attrVal AS INT) > 1
			INNER JOIN APP_Client cl WITH(NOLOCK) ON
				cl.id = CAST(prop.attrVal AS INT)
	IF object_id('tempdb.dbo.#AppGetVSMemberServersXML_InputTbl') IS NOT null	DROP TABLE #AppGetVSMemberServersXML_InputTbl
END
IF EXISTS((SELECT 1 FROM #tmpClientInputInternal WHERE appTypeId = 103 ))
			-- Get the Client and proxy pairs here (CV_APPTYPE_DB2_DPF )
BEGIN
	IF object_id('tempdb.dbo.#tmpDB2multinodeproxyClientInfo') IS NOT NULL drop table #tmpDB2multinodeproxyClientInfo
	create table #tmpDB2multinodeproxyClientInfo(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer
					)
	insert into #tmpDB2multinodeproxyClientInfo (ClientId,instanceId,ClientAppType)
	SELECT DISTINCT CLIENTID, INSTANCE ,appTypeId
	FROM #tmpClientInputInternal WHERE
appTypeId = 103
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT  DISTINCT C.ClientId, members.t_pClientId,C.ClientAppType,C.instanceId
	FROM #tmpDB2multinodeproxyClientInfo C
	INNER JOIN   (
					SELECT distinct t_instance = IP.componentNameId, t_pClientId = substring(T1.Data, CHARINDEX(',', T1.Data)+1, LEN(T1.Data))
							FROM    APP_InstanceProp IP WITH (NOLOCK) CROSS APPLY dbo.SplitString(IP.attrVal, ' ') T1
							WHERE   IP.attrName = 'DB2 Partition Clients' and IP.modified = 0
            )members
			ON  members.t_instance = C.instanceId
	IF object_id('tempdb.dbo.#tmpDB2multinodeproxyClientInfo') IS NOT NULL drop table #tmpDB2multinodeproxyClientInfo
END
IF EXISTS((SELECT 1 FROM #tmpClientInputInternal WHERE appTypeId = 135  ))
			-- Get the Client and proxy pairs here (CV_APPTYPE_SAP_HANA )
BEGIN
	IF object_id('tempdb.dbo.#tmpSapHanaProxyClientInfo') IS NOT NULL drop table #tmpSapHanaProxyClientInfo
	create table #tmpSapHanaProxyClientInfo(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer
					)
	insert into #tmpSapHanaProxyClientInfo (ClientId,instanceId,ClientAppType)
	SELECT DISTINCT CLIENTID, INSTANCE ,appTypeId
FROM #tmpClientInputInternal WHERE appTypeId = 135
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT  DISTINCT C.ClientId, members.t_pClientId,C.ClientAppType,C.instanceId
	FROM #tmpSapHanaProxyClientInfo C
	INNER JOIN   (
					SELECT distinct t_instance = IP.componentNameId, t_pClientId = substring(T1.Data, CHARINDEX(',', T1.Data)+1, LEN(T1.Data))
							FROM    APP_InstanceProp IP WITH (NOLOCK) CROSS APPLY dbo.SplitString(IP.attrVal, '+') T1
							WHERE   IP.attrName = 'Database Clients' and IP.modified = 0
            )members
			ON  members.t_instance = C.instanceId
	IF object_id('tempdb.dbo.#tmpSapHanaProxyClientInfo') IS NOT NULL drop table #tmpSapHanaProxyClientInfo
END
IF EXISTS((SELECT 1 FROM #tmpClientInputInternal WHERE appTypeId = 81 ))
			-- Get the Client and proxy pairs here (CV_APPTYPE_MSSQL )
BEGIN
	IF object_id('tempdb.dbo.#tmpsqlProxyClientInfo') IS NOT NULL drop table #tmpsqlProxyClientInfo
	create table #tmpsqlProxyClientInfo(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer,
					ProxyClientXml XML
					)
	CREATE CLUSTERED INDEX tmpsqlProxyClientInfo_idx ON #tmpsqlProxyClientInfo (instanceId, ClientId)
	INSERT INTO #tmpsqlProxyClientInfo (ClientId, instanceId, ClientAppType, ProxyClientXml)
		SELECT DISTINCT
			t.CLIENTID,
			t.INSTANCE,
			t.appTypeId,
			ip.attrVal
		FROM #tmpClientInputInternal t
			INNER JOIN APP_InstanceProp ip WITH(NOLOCK) ON
t.appTypeId = 81
				AND ip.componentNameId = t.instance
				AND ip.modified = 0
				AND ip.attrName = N'Availability Replicas'
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,instanceId,proxyClientId,ClientAppType)
	SELECT DISTINCT c.ClientId,C.instanceId, a.value('(@clientId)[1]', 'int') as proxy,C.ClientAppType
	FROM #tmpsqlProxyClientInfo C
	CROSS APPLY C.ProxyClientXml.nodes('/App_SQLAvailabilityReplicas/SQLAvailabilityReplicasList/replicaClient') rc(a)
	WHERE
       a.value('@clientId', 'int') IS NOT NULL
	   -- Add cloud MSSQL
    INSERT INTO #tmpsqlProxyClientInfo (ClientId, instanceId, ClientAppType, ProxyClientXml)
    SELECT DISTINCT
	        t.CLIENTID,
	        t.INSTANCE,
	        t.appTypeId,
	        IDP.attrVal
	    FROM #tmpClientInputInternal t
INNER JOIN APP_IDAName IDN WITH(NOLOCK) ON t.appTypeId = 81
	            AND IDN.appTypeId = t.appTypeId
	            AND IDN.clientId = t.ClientId
	        INNER JOIN APP_IDAProp IDP WITH(NOLOCK) ON IDP.componentNameId = IDN.id
	            AND IDP.attrName = N'Cloud Proxy Servers'
	            AND IDP.modified = 0
	    INSERT INTO #tmpClientProxyPairsinternal(ClientId,instanceId,proxyClientId,ClientAppType)
	    SELECT DISTINCT c.ClientId,C.instanceId, a.value('(@clientId)[1]', 'int') as proxy,C.ClientAppType
	    FROM #tmpsqlProxyClientInfo C
	    CROSS APPLY C.ProxyClientXml.nodes('App_MemberServers/memberServers/client') rc(a)
	    WHERE
	       a.value('@clientId', 'int') IS NOT NULL
	IF object_id('tempdb.dbo.#tmpsqlProxyClientInfo') IS NOT NULL drop table #tmpsqlProxyClientInfo
END
IF EXISTS((SELECT 1 FROM #tmpClientInputInternal WHERE appTypeId = 78   ))
			-- Get the Client and proxy pairs here (CV_APPTYPE_MS_SHAREPOINTV2_DOC )
BEGIN
	IF object_id('tempdb.dbo.#tmpsharepointProxyClientInfo') IS NOT NULL drop table #tmpsharepointProxyClientInfo
	create table #tmpsharepointProxyClientInfo(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer,
					ProxyClientXml XML
					)
	INSERT INTO #tmpsharepointProxyClientInfo (ClientId, instanceId, ClientAppType)
	SELECT DISTINCT C.CLIENTID, C.INSTANCE, C.appTypeId
	FROM #tmpClientInputInternal   C
	LEFT OUTER JOIN simInstalledPackages sim WITH(NOLOCK) ON sim.ClientId = C.CLIENTID
WHERE sim.ClientId IS NULL AND C.appTypeId = 78
	-- SharePoint V1 member servers
	UPDATE C
	SET ProxyClientXml = ISNULL(P.stringVal, '')
	FROM #tmpsharepointProxyClientInfo C
	INNER JOIN APP_ComponentProp P ON C.ClientId = P.componentId
	WHERE P.componentType = 3 /*CV_COMPONENT_TYPE_CLIENT*/ AND P.propertyTypeId = 1046 /*CV_COMPONENT_SHAREPOINT_SECONDARY_MEMBER_SERVERS*/
AND P.modified = 0 AND C.ClientAppType = 78
	-- SharePoint V2 member servers
	UPDATE C
	SET ProxyClientXml =  ISNULL(CAST (AP.attrVal AS VARCHAR(MAX)) , '')
	FROM #tmpsharepointProxyClientInfo C
    INNER JOIN  APP_IDAName AI ON AI.clientId = C.clientId
    INNER JOIN APP_IDAProp (NOLOCK) AP ON AP.componentNameId = AI.id
    WHERE AP.attrName = 'Sharepoint Member Servers' AND AP.modified = 0 AND AP.attrType = 1
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,instanceId,proxyClientId,ClientAppType)
	SELECT DISTINCT c.ClientId,C.instanceId, a.value('(@clientId)[1]', 'int') as proxy,C.ClientAppType
	FROM #tmpsharepointProxyClientInfo C
	CROSS APPLY C.ProxyClientXml.nodes('/App_MemberServers/memberServers/client') rc(a)
	WHERE
       a.value('@clientId', 'int') IS NOT NULL AND a.value('(@_type_)[1]', 'int') = 3 AND a.value('(@clientId)[1]', 'int') > 0
	UNION
	SELECT DISTINCT c.ClientId,C.instanceId, ISNULL(prop.attrVal, '') as proxy,C.ClientAppType
	FROM #tmpsharepointProxyClientInfo C
	INNER JOIN APP_ClientProp prop (NOLOCK)
	ON	prop.componentNameId = C.ClientId AND prop.modified = 0
	AND prop.attrName = 'SharePoint Primary Member Server'
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,instanceId,proxyClientId,clientGroup,isproxyclientGroup, ClientAppType)
	SELECT DISTINCT c.ClientId,C.instanceId,CG.clientId,a.value('(@clientGroupId)[1]', 'int'),1,C.ClientAppType
	FROM #tmpsharepointProxyClientInfo C
	CROSS APPLY C.ProxyClientXml.nodes('/App_MemberServers/memberServers/client') rc(a)
	INNER JOIN APP_ClientGroupAssoc CG ON CG.clientGroupId = a.value('(@clientGroupId)[1]', 'int')
	WHERE
       a.value('@clientGroupId', 'int') IS NOT NULL AND a.value('(@_type_)[1]', 'int') = 28 AND a.value('(@clientGroupId)[1]', 'int') > 0
	IF @in_isaddResources = 1 -- add sharepoint index server details
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#tempSPIndexServerInfo') IS NOT NULL
				DROP TABLE #tempSPIndexServerInfo
			CREATE TABLE #tempSPIndexServerInfo
			(
				psuedoClientId INT,
				instanceId INT,
				indexServer INT,
				isCloudIndexServer INT
			)
			INSERT INTO #tempSPIndexServerInfo
			SELECT T.ClientId, T.instanceId, CAST(P.attrVal AS INT), 1
			FROM APP_IDAName(NOLOCK) N
			INNER JOIN #tmpsharepointProxyClientInfo T ON N.clientId = T.ClientId
			INNER JOIN APP_IDAProp(NOLOCK) P ON N.id = P.componentNameId AND T.ClientAppType = N.appTypeId
			WHERE P.attrName = 'Sharepoint Index Server' AND P.modified = 0
			UPDATE T
			SET T.isCloudIndexServer = 0
			FROM #tempSPIndexServerInfo T
			INNER JOIN simInstalledPackages(NOLOCK) I ON T.indexServer = I.ClientId
			IF OBJECT_ID('tempdb.dbp.#tempSPIndexServerClient') IS NOT NULL
				DROP TABLE #tempSPIndexServerClient
			CREATE TABLE #tempSPIndexServerClient
			(
				pseudoClientId INT,
				instanceId INT,
				indexServer INT,
				isCloudIndexServer INT,
				cloudIndexServer INT
			)
			INSERT INTO #tempSPIndexServerClient (pseudoClientId, instanceId, indexServer, isCloudIndexServer, cloudIndexServer)
			SELECT T.psuedoClientId, T.instanceId, T.indexServer, T.isCloudIndexServer, 0
			FROM #tempSPIndexServerInfo T
			WHERE T.isCloudIndexServer = 0
			UNION
			SELECT I.psuedoClientId, I.instanceId, DS.ClientId, I.isCloudIndexServer, I.indexServer
			FROM DM2SearchServerCoreInfo DS
			INNER JOIN DM2Cloud DC ON DS.CloudId = DC.cloudId
			INNER JOIN #tempSPIndexServerInfo I ON I.indexServer = DC.pseudoClientId AND I.isCloudIndexServer = 1
			UPDATE T
			SET T.isIndexServer = 1, T.iscloudindexServer = I.isCloudIndexServer, T.cloudindexServer = I.cloudIndexServer, T.isproxyclientGroup = 0, T.clientGroup = 0
			FROM #tmpClientProxyPairsinternal T
			INNER JOIN #tempSPIndexServerClient I ON T.ClientId = I.pseudoClientId AND T.proxyClientId = I.indexServer
			INSERT INTO #tmpClientProxyPairsinternal (ClientId, instanceId, proxyClientId, ClientAppType, isIndexServer, iscloudindexServer, cloudindexServer)
SELECT DISTINCT I.pseudoClientId, I.instanceId, I.indexServer, 78, 1, I.iscloudindexServer, I.cloudindexServer
			FROM #tempSPIndexServerClient I
			LEFT OUTER JOIN #tmpClientProxyPairsinternal T ON T.ClientId = I.pseudoClientId  AND T.proxyClientId = I.indexServer  AND T.instanceId = I.instanceId
			WHERE T.proxyClientId IS NULL
			IF OBJECT_ID('tempdb.dbp.#tempSPIndexServerClient') IS NOT NULL
				DROP TABLE #tempSPIndexServerClient
			IF OBJECT_ID('tempdb.dbo.#tempSPIndexServerInfo') IS NOT NULL
				DROP TABLE #tempSPIndexServerInfo
		END
	IF OBJECT_ID('tempdb.dbo.#tmpsharepointProxyClientInfo') IS NOT NULL
		DROP TABLE #tmpsharepointProxyClientInfo
END
DECLARE @nasFlags INT = CAST(0x8000000 AS INT) | CAST(0x0080 AS INT)
IF EXISTS ((SELECT 1 FROM  #tmpClientInputInternal S INNER JOIN APP_Client C (NOLOCK) ON  S.clientid= C.id AND (C.Status & @nasFlags) > 0))
			-- Get the Client and proxy pairs here (CV_STATUS_NON_NDMP ) Networkshare
			-- Get the Client and proxy pairs here (CV_STATUS_NAS ) NAS
BEGIN
	IF object_id('tempdb.dbo.#tmpNASNetworkShareProxyClientInfo') IS NOT NULL drop table #tmpNASNetworkShareProxyClientInfo
	create table #tmpNASNetworkShareProxyClientInfo(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer,
					ProxyClientXml XML
					PRIMARY KEY (clientId, instanceId,ClientAppType)
					)
	INSERT INTO #tmpNASNetworkShareProxyClientInfo (ClientId, instanceId, ClientAppType, ProxyClientXml)
		SELECT DISTINCT
			C.CLIENTID,
			C.INSTANCE,
			C.appTypeId,
			ISNULL(P.attrVal, '')
		FROM  #tmpClientInputInternal  C
			INNER JOIN APP_Client C1 WITH(NOLOCK) ON
				C1.Id = C.CLIENTID
				AND (C1.status & @nasFlags) > 0
			INNER JOIN APP_IDAName N WITH(NOLOCK) ON
				C.appTypeId = N.appTypeId
				AND N.clientId = C.ClientId
			LEFT OUTER JOIN APP_IDAProp P WITH(NOLOCK) ON
				P.componentNameId = N.id
				AND p.attrName = N'Backup Configuration Nodes'
				AND p.modified = 0
	IF object_id('tempdb.dbo.#tmpNASNetworkShareAllClientInfo') IS NOT NULL drop table #tmpNASNetworkShareAllClientInfo
	create table #tmpNASNetworkShareAllClientInfo(pseudoClientId		integer,
										instanceId INT,
										entityType integer,
										clientId integer ,
										clientgroupId integer,
										ClientAppType  integer
					)
	INSERT INTO #tmpNASNetworkShareAllClientInfo(pseudoClientId,entityType,clientId,clientgroupId,ClientAppType,instanceId)
	SELECT c.ClientId,
		ISNULL(a.value('@_type_', 'int'),0) ,
		ISNULL(a.value('@clientId', 'int'),0),
		ISNULL(a.value('@clientGroupId', 'int'),0),
		C.ClientAppType,
		C.instanceId
	FROM #tmpNASNetworkShareProxyClientInfo C
	 CROSS APPLY C.ProxyClientXml.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') rc(a)
	  WHERE
       a.value('@clientId', 'int') IS NOT NULL
	  OR a.value('@clientGroupId', 'int') IS NOT NULL
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT DISTINCT  c.pseudoClientId, C.clientId as proxy,C.ClientAppType,C.instanceId
	FROM #tmpNASNetworkShareAllClientInfo C
	  WHERE
C.entityType = 3 AND  C.clientId>1
	UNION
	SELECT DISTINCT t.ClientId,ISNULL(P.attrVal, '')as proxy ,t.ClientAppType,t.instanceId
	FROM APP_IDAProp P (NOLOCK)
	INNER JOIN APP_IDAName N (NOLOCK) ON  P.componentNameId = N.id
	INNER JOIN #tmpNASNetworkShareProxyClientInfo t (NOLOCK) ON  t.ClientAppType = N.appTypeId
	AND N.clientId = t.ClientId  AND P.attrVal <> '0'
	AND (P.attrName = 'FPOLICY PRIMARY CLIENT' OR P.attrName = 'FPOLICY SECONDARY CLIENT') AND P.modified = 0
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,isproxyclientGroup,clientGroup,instanceId)
	SELECT DISTINCT  c.pseudoClientId, ACG.clientId as proxy,C.ClientAppType,1,ACG.clientGroupId,C.instanceId
	FROM #tmpNASNetworkShareAllClientInfo C
	INNER JOIN APP_ClientGroupAssoc ACG
	ON  ACG.clientGroupId = C.clientgroupId
	INNER JOIN simInstalledPackages P
ON P.ClientId =  ACG.clientId AND ((P.simPackageID = 51 AND C.ClientAppType = 13) OR
(P.simPackageID = 1 AND C.ClientAppType = 33 )OR
(P.simPackageID = 1002 ))
	  WHERE
C.entityType =28 and C.clientId = 0
	IF object_id('tempdb.dbo.#tmpNASNetworkShareSubClientInfo') IS NOT NULL drop table #tmpNASNetworkShareSubClientInfo
	create table #tmpNASNetworkShareSubClientInfo(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer,
					subClientId				integer,
					ProxyClientXml XML ,
					SnapBackupsEnabled int DEFAULT 0,
					Snapcopyproxy	   int DEFAULT 0,
					Snaptotapeproxy	   int DEFAULT 0
					)
	INSERT INTO #tmpNASNetworkShareSubClientInfo(ClientId,instanceId,ClientAppType,subClientId)
	SELECT N.ClientId ,N.instanceId, N.ClientAppType,A.ID FROM
	APP_Application A (NOLOCK)
	INNER JOIN	#tmpNASNetworkShareProxyClientInfo N
		ON A.clientId =  N.ClientId AND A.appTypeId = N.ClientAppType AND A.instance = N.instanceId
		And (A.subclientStatus & 6) = 0  	-- uninstalled OR deleted
	UPDATE t
	SET SnapBackupsEnabled = prop.attrVal
	FROM APP_ClientProp prop (NOLOCK)
	INNER JOIN #tmpNASNetworkShareSubClientInfo t (NOLOCK) ON  prop.componentNameId =  T.ClientId
    AND prop.modified = 0 AND prop.attrName = 'Snap Backups Enabled' AND LEN(prop.ATTRVAL)>0
	UPDATE t1
	SET SnapBackupsEnabled = ISNULL(prop.SnapBackupsEnabled, 0)	,
		Snapcopyproxy =  ISNULL(prop.Snapcopyproxy, 0)	,
		Snaptotapeproxy = CASE WHEN ISNULL(prop.SnaptotapeproxyEnabled, 0) = 1 THEN ISNULL(prop.Snaptotapeproxy, 0)	ELSE 0 END
	FROM (
			SELECT
				P.componentNameId,
				[Snap copy : proxy to use] AS Snapcopyproxy,
				[Enable Snap Backups] AS SnapBackupsEnabled ,
				[Snap to tape : proxy to use] AS Snaptotapeproxy,
				[Snap to tape : proxy enabled] AS SnaptotapeproxyEnabled
			FROM
				(
					SELECT
						p.componentNameId,
						P.attrName,
						CAST(P.attrVal AS BIGINT) AS size
					FROM APP_SubClientProp p
						INNER JOIN #tmpNASNetworkShareSubClientInfo T ON
							P.componentNameId= T.subClientId
							AND T.SnapBackupsEnabled =1
					WHERE attrName IN (
							'Snap copy : proxy to use',
							'Enable Snap Backups',
							'Snap to tape : proxy to use',
							'Snap to tape : proxy enabled'
						)
						AND cs_attrName IN (
							CHECKSUM(N'Snap copy : proxy to use'),
							CHECKSUM(N'Enable Snap Backups'),
							CHECKSUM(N'Snap to tape : proxy to use'),
							CHECKSUM(N'Snap to tape : proxy enabled')
						)
						AND modified =0 ) S
					PIVOT (MAX(size) FOR
						attrName IN (
							[Snap copy : proxy to use],
							[Enable Snap Backups],
							[Snap to tape : proxy to use],
							[Snap to tape : proxy enabled]
						)
					) AS P
		)  prop
		INNER JOIN #tmpNASNetworkShareSubClientInfo t1 (NOLOCK) ON
			prop.componentNameId =  T1.subClientId
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId,subclientId)
	SELECT DISTINCT  c.ClientId, C.Snapcopyproxy as proxy,C.ClientAppType,C.instanceId,C.subclientId
	FROM #tmpNASNetworkShareSubClientInfo C
	WHERE
	C.SnapBackupsEnabled = 1 AND C.Snapcopyproxy>0
	UNION
	SELECT DISTINCT  c.ClientId, C.Snaptotapeproxy as proxy,C.ClientAppType,C.instanceId,C.subclientId
	FROM #tmpNASNetworkShareSubClientInfo C
	WHERE
	C.SnapBackupsEnabled = 1 AND C.Snaptotapeproxy>0
	UPDATE t
		SET ProxyClientXml = prop.attrVal
	FROM APP_SubClientProp prop (NOLOCK)
		INNER JOIN #tmpNASNetworkShareSubClientInfo t (NOLOCK) ON
			prop.componentNameId =  T.subClientId
			AND prop.modified = 0
			AND prop.attrName = 'Backup Configuration Nodes'
			AND prop.cs_attrName = CHECKSUM(N'Backup Configuration Nodes')
			AND LEN(prop.ATTRVAL) > 0
	DELETE FROM #tmpNASNetworkShareSubClientInfo WHERE subClientId NOT IN ( SELECT DISTINCT C.subClientId
	FROM #tmpNASNetworkShareSubClientInfo C
	CROSS APPLY C.ProxyClientXml.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') rc(a)
	WHERE
       a.value('@clientId', 'int') IS NOT  NULL
	     OR a.value('@clientGroupId', 'int') IS NOT  NULL	)
	IF EXISTS((SELECT 1 FROM	#tmpNASNetworkShareSubClientInfo   ))
	BEGIN
		IF object_id('tempdb.dbo.#tmpNASNetworkShareAllSubClientInfo') IS NOT NULL drop table #tmpNASNetworkShareAllSubClientInfo
			create table #tmpNASNetworkShareAllSubClientInfo(pseudoClientId		integer,
										instanceId INT,
										entityType integer,
										clientId integer ,
										clientgroupId integer,
										ClientAppType  integer,
										subclientId  integer
					)
		INSERT INTO #tmpNASNetworkShareAllSubClientInfo(pseudoClientId,entityType,clientId,clientgroupId,ClientAppType,instanceId,subclientId)
		SELECT c.ClientId,
		ISNULL(a.value('@_type_', 'int'),0) ,
		ISNULL(a.value('@clientId', 'int'),0),
		ISNULL(a.value('@clientGroupId', 'int'),0),
		C.ClientAppType,
		C.instanceId,
		C.subclientId
		FROM #tmpNASNetworkShareSubClientInfo C
		CROSS APPLY C.ProxyClientXml.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') rc(a)
		WHERE
		a.value('@clientId', 'int') IS NOT NULL
		OR a.value('@clientGroupId', 'int') IS NOT NULL
		INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId,subclientId)
		SELECT DISTINCT  c.pseudoClientId, C.clientId as proxy,C.ClientAppType,C.instanceId,subclientId
		FROM #tmpNASNetworkShareAllSubClientInfo C
		WHERE
C.entityType = 3 AND  C.clientId>1
		INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,isproxyclientGroup,clientGroup,instanceId,subclientId)
		SELECT DISTINCT  c.pseudoClientId, ACG.clientId as proxy,C.ClientAppType,1,ACG.clientGroupId,C.instanceId,subclientId
		FROM #tmpNASNetworkShareAllSubClientInfo C
		INNER JOIN APP_ClientGroupAssoc ACG
		ON  ACG.clientGroupId = C.clientgroupId
		INNER JOIN simInstalledPackages P
ON P.ClientId =  ACG.clientId AND ((P.simPackageID = 51 AND C.ClientAppType = 13) OR
(P.simPackageID = 1 AND C.ClientAppType = 33 )OR
(P.simPackageID = 1002 ))
		WHERE
C.entityType =28 and C.clientId = 0
		IF object_id('tempdb.dbo.#tmpNASNetworkShareAllSubClientInfo') IS NOT NULL drop table #tmpNASNetworkShareAllSubClientInfo
	END
	IF object_id('tempdb.dbo.#tmpNASNetworkShareAllClientInfo') IS NOT NULL drop table #tmpNASNetworkShareAllClientInfo
	IF object_id('tempdb.dbo.#tmpNASNetworkShareProxyClientInfo') IS NOT NULL drop table #tmpNASNetworkShareProxyClientInfo
END
IF EXISTS(
	SELECT 1
	FROM #tmpClientInputInternal S (NOLOCK)
		INNER JOIN APP_ClientProp prop (NOLOCK) ON
			S.clientid= prop.componentNameId
			AND prop.modified = 0
			AND prop.attrName = 'Open VMS proxy client')
			-- OPEN VMS
			-- IBMI
BEGIN
	IF object_id('tempdb.dbo.#TMPOpenVMSproxyclientlist') IS NOT NULL drop table #TMPOpenVMSproxyclientlist
	create table #TMPOpenVMSproxyclientlist(ClientId		integer,
					instanceId			integer,
					ClientAppType				integer,
					ProxyClientXml XML
					)
	insert into #TMPOpenVMSproxyclientlist (ClientId,instanceId,ClientAppType)
	SELECT DISTINCT C.CLIENTID, C.INSTANCE ,C.appTypeId
	FROM  #tmpClientInputInternal  C
	LEFT OUTER JOIN simInstalledPackages sim (NOLOCK) ON sim.ClientId = C.CLIENTID
AND C.appTypeId = 38
	WHERE sim.ClientId IS NULL
	UPDATE C
		SET ProxyClientXml = ISNULL(prop.attrVal, '')
	FROM #TMPOpenVMSproxyclientlist C
		INNER JOIN APP_ClientProp prop (NOLOCK) ON
			 prop.componentNameId = C.ClientId
			AND prop.modified = 0
			AND prop.attrName ='Open VMS proxy client list'
	IF object_id('tempdb.dbo.#TMPOpenVMSproxyAllClientInfo') IS NOT NULL drop table #TMPOpenVMSproxyAllClientInfo
	create table #TMPOpenVMSproxyAllClientInfo(pseudoClientId		integer,
										instanceId INT,
										entityType integer,
										clientId integer ,
										clientgroupId integer,
										ClientAppType  integer
					)
	INSERT INTO #TMPOpenVMSproxyAllClientInfo(pseudoClientId,entityType,clientId,clientgroupId,ClientAppType,instanceId)
	SELECT c.ClientId,
		ISNULL(a.value('@_type_', 'int'),0) ,
		ISNULL(a.value('@clientId', 'int'),0),
		ISNULL(a.value('@clientGroupId', 'int'),0),
		C.ClientAppType,
		C.instanceId
	FROM #TMPOpenVMSproxyclientlist C
	 CROSS APPLY C.ProxyClientXml.nodes('App_BackupConfigurationNodes/backupDataAccessNodes') rc(a)
	  WHERE
		C.ProxyClientXml IS NOT NULL
		AND (
       a.value('@clientId', 'int') IS NOT NULL
	  OR a.value('@clientGroupId', 'int') IS NOT NULL
	  )
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT DISTINCT  c.pseudoClientId, C.clientId as proxy,C.ClientAppType,C.instanceId
	FROM #TMPOpenVMSproxyAllClientInfo C
	  WHERE
C.entityType = 3 AND  C.clientId>1
	UNION
	SELECT  DISTINCT S.CLIENTID,CAST (prop.attrVal AS INT ) attrVal, S.appTypeId, S.INSTANCE FROM  #tmpClientInputInternal S (NOLOCK)  INNER JOIN APP_ClientProp prop (NOLOCK) ON
	 S.clientid = prop.componentNameId AND prop.attrName = 'Open VMS proxy client' AND  prop.modified = 0
	AND ISNUMERIC (prop.attrVal) =1
	AND CAST (prop.attrVal AS INT )>1
	AND prop.attrVal <> N'0'
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,isproxyclientGroup,clientGroup,instanceId)
	SELECT DISTINCT  c.pseudoClientId, ACG.clientId as proxy,C.ClientAppType,1,ACG.clientGroupId,C.instanceId
	FROM #TMPOpenVMSproxyAllClientInfo C
	INNER JOIN APP_ClientGroupAssoc ACG
	ON  ACG.clientGroupId = C.clientgroupId
	INNER JOIN simInstalledPackages P
ON P.ClientId =  ACG.clientId AND ((P.simPackageID = 1137) OR
(P.simPackageID = 1138)
									   )
	  WHERE
C.entityType =28 and C.clientId = 0
	IF object_id('tempdb.dbo.#TMPOpenVMSproxyclientlist') IS NOT NULL drop table #TMPOpenVMSproxyclientlist
	IF object_id('tempdb.dbo.#TMPOpenVMSproxyAllClientInfo') IS NOT NULL drop table #TMPOpenVMSproxyAllClientInfo
END
IF EXISTS(
	SELECT 1
	FROM #tmpClientInputInternal S (NOLOCK)
		INNER JOIN APP_ClientProp prop (NOLOCK) ON
			S.clientid = prop.componentNameId
			AND prop.modified = 0
			AND prop.attrName ='HAC Cluster Nodes'
)
			--HAC Cluster Nodes
BEGIN
	IF object_id('tempdb.dbo.#tmpproxyHACClientXML') IS NOT NULL drop table #tmpproxyHACClientXML
	CREATE TABLE #tmpproxyHACClientXML(ClientId		integer,
				proxynodesxml XML
				)
	INSERT INTO #tmpproxyHACClientXML (ClientId,proxynodesxml)
	SELECT DISTINCT  S.ClientId,  SUBSTRING(attrVal, CHARINDEX('>', attrVal)+1, LEN(attrVal)) AS nodes
    FROM #tmpClientInputInternal S (NOLOCK)
	  INNER JOIN APP_ClientProp prop(NOLOCK)
	ON prop.componentNameId = S.ClientId AND attrName = 'HAC Cluster Nodes'  AND prop.modified =0
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
		SELECT DISTINCT proxyInfo.ClientId, proxyInfo.proxy,clientInfo.appTypeId,clientInfo.INSTANCE
	FROM (SELECT DISTINCT c.ClientId, a.value('(@val)[1]', 'int') as proxy
	FROM #tmpproxyHACClientXML C
	CROSS APPLY C.proxynodesxml.nodes('App_ClientList/clientId') rc(a)
	WHERE
       a.value('@val', 'int') IS NOT NULL	) AS proxyInfo
	INNER JOIN  (SELECT DISTINCT A.CLIENTID, A.INSTANCE,C.appTypeId
FROM #tmpClientInputInternal WHERE appTypeId = 64
	)
	AS clientInfo
	ON clientInfo.CLIENTID =  proxyInfo.ClientId
	DROP TABLE #tmpproxyHACClientXML
END
IF EXISTS(
	SELECT 1
	FROM #tmpClientInputInternal S
		INNER JOIN APP_VMToPMMap C (NOLOCK) ON
			S.clientid= C.vmclientid
		INNER JOIN APP_Client A WITH(NOLOCK) ON
			A.id= S.ClientId
			AND A.simOperatingSystemId <> 16
)
			-- Get the Cluster nodes pairs and exclude NAS Cluster client
BEGIN
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT DISTINCT C.vmclientid,C.pmclientid,S.APPTYPEID,S.INSTANCE
	FROM #tmpClientInputInternal S (NOLOCK) INNER JOIN APP_VMToPMMap C (NOLOCK) ON  S.clientid= C.vmclientid
	INNER JOIN APP_Client AC ON AC.ID = S.ClientId and AC.simOperatingSystemId <> 16
END
IF EXISTS (SELECT 1  FROM #tmpClientInputInternal WHERE appTypeId = 124 )
			-- PSEUDO_CLIENT_OBJECT_LINK
BEGIN
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT  DISTINCT S.CLIENTID,CAST (prop.attrVal AS INT ), S.appTypeId, S.INSTANCE
	FROM #tmpClientInputInternal S (NOLOCK) INNER JOIN APP_ClientProp prop (NOLOCK) ON
	 S.clientid = prop.componentNameId AND prop.attrName = 'Object Server Member Servers List' AND  prop.modified = 0
and S.appTypeId = 124
	AND ISNUMERIC (prop.attrVal) =1
	AND CAST (prop.attrVal AS INT )>1
END
IF EXISTS((SELECT 1 FROM #tmpClientInputInternal S (NOLOCK) INNER JOIN DM2Cloud C (NOLOCK) ON  S.clientid=  C.pseudoClientId AND C.CloudType IN ( 1,4,5) ))
			----index server
BEGIN
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT  DISTINCT  C.pseudoClientId ,S.ClientId,ip.appTypeId,ip.instance
		FROM   DM2SearchServerCoreInfo S (nolock)
		INNER JOIN DM2Cloud C (nolock) on c.cloudId = s.CloudId
		INNER JOIN #tmpClientInputInternal ip (NOLOCK) ON ip.clientid=  C.pseudoClientId
	WHERE S.CloudType IN ( 1,4,5) AND C.CloudType IN ( 1,4,5)
END
IF EXISTS(SELECT 1 FROM #tmpClientInputInternal S (NOLOCK) INNER JOIN app_client Cl (nolock) on S.clientId =cl.id INNER JOIN DM2Cloud C (NOLOCK) ON  c.name = Cl.name AND C.CloudType = 2 )
			----Content analyzer
BEGIN
	IF object_id('tempdb.dbo.#tmpContentAnalyzer') IS NOT NULL drop table #tmpContentAnalyzer
	create table #tmpContentAnalyzer(
								ClientId		integer,
								proxyClientId	integer,
								ClientAppType				integer,
								instanceId			integer,
								CLOUDID 	integer DEFAULT 0
								)
	INSERT INTO #tmpContentAnalyzer(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT DISTINCT  Cl.id ,S.ClientId,A.appTypeId,A.instance
		FROM  #tmpClientInputInternal A (nolock)
		INNER JOIN app_client Cl (nolock) on a.clientId =cl.id
		INNER JOIN DM2Cloud C (nolock) on   c.name = Cl.name
		INNER JOIN DM2SearchServerCoreInfo S (nolock) ON c.cloudId = s.CloudId
	WHERE S.CloudType = 2 AND C.CloudType = 2
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
	SELECT  DISTINCT  ClientId,proxyClientId,ClientAppType,instanceId
	FROM #tmpContentAnalyzer
	UNION
	SELECT  DISTINCT  ClientId ,CAST (prop.attrVal AS INT ),ClientAppType,instanceId
	FROM #tmpContentAnalyzer c
	INNER JOIN APP_ClientProp prop (NOLOCK)
	ON	prop.componentNameId = C.proxyClientId AND prop.modified = 0
	AND prop.attrName IN('MessageQueue ClientId','Content Extractor ClientId')
	AND ISNUMERIC (prop.attrVal) =1
	AND CAST (prop.attrVal AS INT )>1
	UPDATE C
	SET C.CLOUDID = CAST (prop.attrVal AS INT )
	FROM #tmpContentAnalyzer c
	INNER JOIN APP_ClientProp prop (NOLOCK)
	ON	prop.componentNameId = C.ClientId AND prop.modified = 0
	AND prop.attrName IN('Analytics CACloudId')
	AND ISNUMERIC (prop.attrVal) =1
	INSERT INTO #tmpClientProxyPairsinternal(ClientId,instanceId,proxyClientId,ClientAppType,isIndexServer,iscloudindexServer,cloudindexServer)
	SELECT  DISTINCT  ip.ClientId ,ip.instanceID, S.clientId,ip.ClientAppType,1,1,c.pseudoClientId
		FROM  DM2SearchServerCoreInfo S (nolock)
		INNER JOIN DM2Cloud C (nolock) on c.cloudId = s.CloudId
		INNER JOIN #tmpContentAnalyzer ip (NOLOCK) ON ip.CLOUDID=  C.CloudId
	WHERE S.CloudType IN ( 1,4,5) AND C.CloudType IN ( 1,4,5)	AND c.pseudoClientId>0
	DROP TABLE #tmpContentAnalyzer
END
--For Usercentric client, use the actual physical client
INSERT INTO #tmpClientProxyPairsinternal(ClientId,proxyClientId,ClientAppType,instanceId)
SELECT I.ClientId, C.id, I.appTypeId, I.INSTANCE
FROM    (SELECT DISTINCT componentNameId, attrVal FROM APP_ClientProp WITH (NOLOCK)
        WHERE    attrName = 'Physical Client Id' AND modified = 0
            AND ISNUMERIC(attrVal) = 1) T
    INNER JOIN (SELECT DISTINCT ClientId, INSTANCE, appTypeId FROM #tmpClientInputInternal C
            INNER JOIN APP_ClientProp P WITH (NOLOCK) ON C.ClientId = P.componentNameId AND P.modified = 0 AND P.attrName = 'User Centric Client'
            WHERE P.attrVal = N'1'
            ) I ON I.ClientId = T.componentNameId
    INNER JOIN APP_Client C WITH (NOLOCK) ON C.id = T.attrVal
--NFS objectstore pseudo client and 3DNFS server. 3DNFS server uses the pseudo client  for backing up the NFS share
INSERT INTO #tmpClientProxyPairsinternal(ClientId, proxyClientId, ClientAppType, instanceId)
SELECT DISTINCT subquery.ClientId, AC.id, subquery.appTypeId, subquery.INSTANCE
	FROM APP_Client AC WITH(NOLOCK)
		INNER JOIN APP_SubclientProp SubP WITH(NOLOCK) ON
			AC.name = SubP.attrVal
			AND SubP.attrName = N'3dfs NFS Servers'
			AND SubP.cs_attrName = CHECKSUM(N'3dfs NFS Servers')
			AND SubP.modified = 0
		INNER JOIN (
			SELECT
				CAST(sp.attrVal AS INT) scpId,
				I.appTypeId,
				I.INSTANCE,
				I.ClientId
			FROM APP_SubClientProp SP WITH(NOLOCK)
				INNER JOIN APP_Application APP WITH(NOLOCK) ON
					SP.componentNameId = APP.ID
					AND SP.modified = 0
					AND SP.attrName = N'Associated subclient Policy'
					AND SP.cs_attrName = CHECKSUM(N'Associated subclient Policy')
					INNER JOIN  #tmpClientInputInternal I ON
					I.ClientId = APP.clientid
		) subquery on
					SubP.componentNameId  = subquery.scpId
IF (LEN(@tableOutput)>0)
BEGIN
  DECLARE @outputSQLStatement NVARCHAR(MAX)
  SET @outputSQLStatement = 'INSERT INTO '+ @tableOutput +'(clientId, proxyClientId,ClientAppType,isIndexServer,iscloudindexServer,cloudindexServer,isproxyclientGroup ,clientGroup	,instanceId,subclientId) '
  SET @outputSQLStatement += ' SELECT DISTINCT clientId, proxyClientId,ClientAppType,isIndexServer,iscloudindexServer ,cloudindexServer ,isproxyclientGroup ,clientGroup ,instanceId,subclientId FROM #tmpClientProxyPairsinternal'
  EXEC (@outputSQLStatement)
 END
 ELSE
 BEGIN
	SELECT DISTINCT clientId, proxyClientId ,ClientAppType,isIndexServer
	,iscloudindexServer
	,cloudindexServer
	,isproxyclientGroup
	,clientGroup
	,instanceId
	,subclientId
	 FROM #tmpClientProxyPairsinternal
	 order by instanceId
 END
IF object_id('tempdb.dbo.#tmpClientProxyPairsinternal') IS NOT NULL drop table #tmpClientProxyPairsinternal
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetProxyClientInfo')
	delete from GxQscripts where name = 'APPGetProxyClientInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetProxyClientInfo')
	delete from GXDBVersions where aliasname = 'APPGetProxyClientInfo'
GO

insert into GXDBVersions values(2, 'APPGetProxyClientInfo',  'v1.1.2.13.8.3', 'APPGetProxyClientInfo', 'v1.1.2.13.8.3')
GO

