

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetPerformanceParameters.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetPerformanceParameters.sp,v $ $Id: AppGetPerformanceParameters.sp,v 1.1.2.7 2018/06/29 02:55:14 vdevassy Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetPerformanceParameters')
BEGIN
	print '>>> Drop Stored Procedure: APPGetPerformanceParameters <<<'
	drop procedure APPGetPerformanceParameters
END
IF EXISTS (select * from GxQscripts where name='APPGetPerformanceParameters')
	delete from GxQscripts where name = 'APPGetPerformanceParameters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetPerformanceParameters')
	delete from GXDBVersions where aliasname = 'APPGetPerformanceParameters'
GO
print '... Creating Procedure: APPGetPerformanceParameters'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetPerformanceParameters
  @clientId INT,
  @storagePolicyId INT
AS
	--Performance Tab Options
	--Client params
	DECLARE		@perfClientName 					NVARCHAR(MAX)
DECLARE		@lookAheadReaderSlots				INT = 4
DECLARE		@numOfPipelineBuffers				INT = 90
DECLARE		@pipelineBufferSize			 		INT = ((64*1024)/1024)
	--copy dependent params
	DECLARE 	@copyId								INT = 0
	DECLARE		@multiplexingValid					NVARCHAR(MAX)
	DECLARE		@enableMultiplexing					NVARCHAR(MAX)
	DECLARE		@muxFactor							INT = 0
	DECLARE		@streamsOverMux						NVARCHAR(MAX)
	DECLARE		@perfSPName							NVARCHAR(MAX)
	DECLARE		@perfCopyName 						NVARCHAR(MAX)
	DECLARE 	@perfMaList                			TABLE
													(perfMaId INT,
													 perfMa NVARCHAR(MAX),
													 crcOverNetwork NVARCHAR(MAX),
													 crcOverMedia NVARCHAR(MAX))
		--Performance Tab Variables
	SELECT TOP 1 @copyId 		=	ISNULL(AGC.id,0),
				 @perfCopyName 	= 	AGC.name,
				 @perfSPName	=	AG.name
				 FROM archGroup AG WITH(READUNCOMMITTED)
				 JOIN	archGroupCopy AGC WITH(READUNCOMMITTED) ON AG.defaultCopy = AGC.id
				 WHERE AG.id = @storagePolicyId
	SELECT @perfClientName = name from APP_Client where id = @clientId
	INSERT 	INTO @perfMaList
	SELECT	AC.id AS perfMaId,
			AC.name AS perfMa,
(CASE WHEN (MH.Attribute&256 = 256) THEN 1 ELSE 0 END) AS crcOverNetwork,
(CASE WHEN (MH.Attribute&512 = 512) THEN 1 ELSE 0 END) AS crcOverMedia
	FROM	MMHost MH
	JOIN	APP_Client AC ON MH.ClientId = AC.id
	WHERE	clientid IN (SELECT DISTINCT HostClientId FROM MMDataPath WHERE CopyId = @copyId)
	IF @copyId > 0
	BEGIN
		SELECT	@multiplexingValid				=	(CASE WHEN (ISNULL(dedupeFlags,0) > 0) THEN 0 ELSE 1 END),
				@muxFactor						= 	ISNULL(maxMultiplex,0),
@streamsOverMux 				=   (CASE WHEN (ISNULL(flags,0) & 268435456 = 268435456) THEN 1 ELSE 0 END)
													FROM archGroupCopy WITH(READUNCOMMITTED)
													WHERE id = @copyId
		IF @muxFactor = 0
			SET @enableMultiplexing = 0
		ELSE
			SET @enableMultiplexing = 1
SELECT @lookAheadReaderSlots			=	CASE WHEN COUNT(*) <> 1 THEN 4 ELSE SUM(VALUE) END
													FROM
(SELECT	DISTINCT ISNULL(CAST(CAST(value AS NVARCHAR(MAX)) AS INT),4) AS value
													FROM	MMHost WITH(READUNCOMMITTED)
LEFT	OUTER JOIN APP_AdvanceSettings WITH(READUNCOMMITTED) ON ClientId = entityId AND	keyName = 'DataMoverLookAheadLinkReaderSlots' AND enabled = 1
													WHERE	clientid IN (SELECT DISTINCT HostClientId FROM MMDataPath WHERE CopyId = @copyId)) VALS
		--For current design, shows default value when all clients don't have the same value set for the regKey
SELECT @numOfPipelineBuffers			=	CASE WHEN COUNT(*) <> 1 THEN 90 ELSE SUM(VALUE) END
													FROM
(SELECT	DISTINCT ISNULL(CAST(CAST(value AS NVARCHAR(MAX)) AS INT),90) AS value
													FROM	MMHost WITH(READUNCOMMITTED)
LEFT	OUTER JOIN APP_AdvanceSettings WITH(READUNCOMMITTED) ON ClientId = entityId AND	keyName = 'nNumPipelineBuffers' AND enabled = 1
													WHERE	clientid IN (SELECT DISTINCT HostClientId FROM MMDataPath WHERE CopyId = @copyId UNION SELECT @clientId)) VALS
SELECT	@pipelineBufferSize				=	CASE WHEN COUNT(*) <> 1 THEN ((64*1024)/1024) ELSE (SUM(VALUE)/1024) END
													FROM
(SELECT	DISTINCT ISNULL(CAST(CAST(value AS NVARCHAR(MAX)) AS INT),(64*1024)) AS value
													FROM	MMHost WITH(READUNCOMMITTED)
LEFT	OUTER JOIN APP_AdvanceSettings WITH(READUNCOMMITTED) ON ClientId = entityId AND	keyName = 'nPipelineBufferSize' AND enabled = 1
													WHERE	clientid IN (SELECT DISTINCT HostClientId FROM MMDataPath WHERE CopyId = @copyId UNION SELECT @clientId)) VALS
	END
--Construct output XML
DECLARE @xmlResult XML
SET	@xmlResult =	(SELECT	@multiplexingValid AS '@multiplexingValid',
							@enableMultiplexing AS '@enableMultiplexing',
							@muxFactor AS '@muxFactor',
							@streamsOverMux AS '@streamsOverMux',
							@lookAheadReaderSlots AS '@lookAheadReaderSlots',
							@numOfPipelineBuffers AS '@numOfPipelineBuffers',
							@pipelineBufferSize AS '@pipelineBufferSize',
							@perfSPName AS '@perfSPName',
							@perfCopyName AS '@perfCopyName',
							@perfClientName AS '@perfClientName',
							(SELECT perfMaId AS '@perfMaId',
								perfMa AS '@perfMa',
								crcOverNetwork AS '@crcOverNetwork',
								crcOverMedia AS '@crcOverMedia'
								FROM @perfMaList
							FOR XML PATH('perfCRCDetails'),TYPE)
                        FOR XML PATH('performanceMode'),ROOT('App_GetPerfParamsResp'))
SELECT @xmlResult
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetPerformanceParameters')
	delete from GxQscripts where name = 'APPGetPerformanceParameters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetPerformanceParameters')
	delete from GXDBVersions where aliasname = 'APPGetPerformanceParameters'
GO

insert into GXDBVersions values(2, 'APPGetPerformanceParameters',  '00010001000200070000', 'APPGetPerformanceParameters', '00010001000200070000')
GO

