

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetNonSmartTopologiesForClientGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- $Id: APPGetNonSmartTopologiesForClientGroup.sp,v 1.1.2.1 2018/09/24 17:07:44 kmokshagundam Exp $;
--
--  +====================================================================================================================+
--  |   Procedure:  APPGetNonSmartTopologiesForClientGroup
--  |
--  | Description:  This procedure is used to get the ids of non-smart network topologies the client group is part of.
--  |
--  |       Input:  clientGroupId
--  |
--  |      Output:  Topology Ids of the non-smart network topologies, the client group is part of.
-- 	|
--  |      Return:  xxxxxxxxxxxxxxxx
--  |
--  |   Revision	Author					Description
--  |   ---------  	-------					--------------------------------
--  |   1.1        	kmokshagundam   		Initial Edit
--  +======================================================================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetNonSmartTopologiesForClientGroup <<<'

IF EXISTS (select * from sysobjects where name='APPGetNonSmartTopologiesForClientGroup')
	drop procedure APPGetNonSmartTopologiesForClientGroup
IF EXISTS (select * from GxQscripts where name='APPGetNonSmartTopologiesForClientGroup')
	delete from GxQscripts where name = 'APPGetNonSmartTopologiesForClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetNonSmartTopologiesForClientGroup')
	delete from GXDBVersions where aliasname = 'APPGetNonSmartTopologiesForClientGroup'
GO
print '... Creating Procedure: APPGetNonSmartTopologiesForClientGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetNonSmartTopologiesForClientGroup
  @clientGroupId INTEGER
AS
  DECLARE @topologyId INTEGER
SET NOCOUNT ON
BEGIN
SELECT AFTA.topologyId FROM APP_FirewallTopologyAssoc AFTA WITH (NOLOCK) INNER JOIN APP_FirewallTopology AFT WITH (NOLOCK) ON AFTA.topologyId = AFT.topologyId WHERE AFT.flag & 1 = 0 AND AFTA.groupId = @clientGroupId
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetNonSmartTopologiesForClientGroup')
	delete from GxQscripts where name = 'APPGetNonSmartTopologiesForClientGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetNonSmartTopologiesForClientGroup')
	delete from GXDBVersions where aliasname = 'APPGetNonSmartTopologiesForClientGroup'
GO

insert into GXDBVersions values(2, 'APPGetNonSmartTopologiesForClientGroup',  '00010001000200010000', 'APPGetNonSmartTopologiesForClientGroup', '00010001000200010000')
GO

