

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetNetworkThrottleRestrictionFrom.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppGetNetworkThrottleRestrictionFrom.sp,v $ $Id: AppGetNetworkThrottleRestrictionFrom.sp,v 1.11.86.3 2018/03/22 01:35:14 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  APPGetNetworkThrottleRestrictionFrom()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:  Returns list of clients to which the given client is restricted
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetNetworkThrottleRestrictionFrom')
BEGIN
	print '>>> Drop Stored Procedure: APPGetNetworkThrottleRestrictionFrom <<<'
	drop procedure APPGetNetworkThrottleRestrictionFrom
END
IF EXISTS (select * from GxQscripts where name='APPGetNetworkThrottleRestrictionFrom')
	delete from GxQscripts where name = 'APPGetNetworkThrottleRestrictionFrom'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetNetworkThrottleRestrictionFrom')
	delete from GXDBVersions where aliasname = 'APPGetNetworkThrottleRestrictionFrom'
GO
print '... Creating Procedure: APPGetNetworkThrottleRestrictionFrom'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure APPGetNetworkThrottleRestrictionFrom
  @clientId integer
AS
  DECLARE @o_clientId integer
  DECLARE @o_clientName nchar(255)
  DECLARE @o_clientHostName nchar(255)
  DECLARE @o_clientGUID nchar(255)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
CREATE TABLE #restrictionTbl (clientId INT)
INSERT INTO #restrictionTbl
SELECT NT.clientId
FROM APP_NetworkThrottle NT INNER JOIN APP_ClientProp CP ON NT.clientId = CP.componentNameId
WHERE NT.forClientId = @clientId AND NT.clientId <> 0 AND CP.attrName='Network Throttle Enabled' AND CP.modified = 0
UNION
SELECT CG.clientId
FROM APP_NetworkThrottle NT INNER JOIN APP_ClientGroupAssoc CG ON NT.clientGroupId = CG.clientGroupId
INNER JOIN APP_ClientGroup ACG ON CG.clientGroupId = ACG.id
WHERE NT.forClientId = @clientId AND (ACG.flag & 0x0800) = 0x0800
UNION
SELECT NT.clientId
FROM APP_NetworkThrottle NT INNER JOIN APP_ClientGroupAssoc CG ON NT.forClientGroupId = CG.clientGroupId
INNER JOIN APP_ClientProp CP ON NT.clientId = CP.componentNameId
WHERE CG.clientId = @clientId and NT.clientId <> 0  AND CP.attrName='Network Throttle Enabled' AND CP.modified = 0
UNION
SELECT CGA.clientId from App_ClientGroupAssoc CGA where CGA.clientGroupId in
(SELECT   NT.clientGroupId
FROM APP_NetworkThrottle NT INNER JOIN APP_ClientGroupAssoc CG ON NT.forClientGroupId = CG.clientGroupId
INNER JOIN APP_ClientGroup ACG ON ACG.id = NT.ClientGroupId
WHERE (CG.clientId =@clientId and NT.clientId = 0 and NT.forClientId=0 AND (ACG.flag & 0x0800) = 0x0800))
SELECT DISTINCT rest.clientId, name, net_hostname, (case when releaseId < 15 then NULL else GUID end)
FROM #restrictionTbl as rest INNER JOIN APP_CLIENT ON rest.clientId = id AND releaseId >= 14
DROP TABLE #restrictionTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetNetworkThrottleRestrictionFrom')
	delete from GxQscripts where name = 'APPGetNetworkThrottleRestrictionFrom'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetNetworkThrottleRestrictionFrom')
	delete from GXDBVersions where aliasname = 'APPGetNetworkThrottleRestrictionFrom'
GO

insert into GXDBVersions values(2, 'APPGetNetworkThrottleRestrictionFrom',  '00010011008600030000', 'APPGetNetworkThrottleRestrictionFrom', '00010011008600030000')
GO

