

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetNetworkThrottleOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetNetworkThrottleOptions.sp,v $ $Id: APPGetNetworkThrottleOptions.sp,v 1.7.86.1 2018/03/22 01:51:38 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  APPGetNetworkThrottleOptions()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:  Returns list of throttle client list for a given client
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Suraj Bharech					Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetNetworkThrottleOptions <<<'

IF EXISTS (select * from sysobjects where name='APPGetNetworkThrottleOptions')
	drop procedure APPGetNetworkThrottleOptions
IF EXISTS (select * from GxQscripts where name='APPGetNetworkThrottleOptions')
	delete from GxQscripts where name = 'APPGetNetworkThrottleOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetNetworkThrottleOptions')
	delete from GXDBVersions where aliasname = 'APPGetNetworkThrottleOptions'
GO
print '... Creating Procedure: APPGetNetworkThrottleOptions'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure APPGetNetworkThrottleOptions
  @i_clientId integer
AS
  DECLARE @o_networkThrottleOptions XML
SET NOCOUNT ON
BEGIN
CREATE TABLE #networkThrottleOptionsTable ( t_throttleOptions XML ) ;
DECLARE @nwEnabled		integer
SET @nwEnabled = 0
IF EXISTS(SELECT * FROM APP_clientProp WHERE attrName='Network Throttle Enabled' AND componentNameId =  @i_clientId AND modified = 0)
SET @nwEnabled = (SELECT attrVal FROM APP_clientProp WHERE attrName='Network Throttle Enabled' AND componentNameId =  @i_clientId AND modified = 0)
IF @nwEnabled <> 0
BEGIN
INSERT INTO #networkThrottleOptionsTable
SELECT NW.NetworkThrottleOptions
FROM APP_networkthrottleoptions NW
WHERE NW.clientId = @i_clientId
END
INSERT INTO #networkThrottleOptionsTable
SELECT NW.NetworkThrottleOptions
FROM APP_networkthrottleoptions NW
	 INNER JOIN APP_ClientGroupAssoc CG
	 ON NW.clientGroupId = CG.clientGroupId INNER JOIN APP_ClientGroup ACG ON CG.clientGroupId = ACG.id
	 WHERE CG.clientId = @i_clientId AND
		(ACG.flag & 0x0800) = 0x0800
SELECT t_throttleOptions
FROM #networkThrottleOptionsTable
DROP TABLE #networkThrottleOptionsTable
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetNetworkThrottleOptions')
	delete from GxQscripts where name = 'APPGetNetworkThrottleOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetNetworkThrottleOptions')
	delete from GXDBVersions where aliasname = 'APPGetNetworkThrottleOptions'
GO

insert into GXDBVersions values(2, 'APPGetNetworkThrottleOptions',  '00010007008600010000', 'APPGetNetworkThrottleOptions', '00010007008600010000')
GO

