

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetNetworkThrottleClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetNetworkThrottleClient.sp,v $ $Id: APPGetNetworkThrottleClient.sp,v 1.9.180.2 2018/03/22 01:39:50 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  APPGetNetworkThrottleClient()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:  Returns list of throttle client list for a given client
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Suraj Bharech					Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetNetworkThrottleClient <<<'

IF EXISTS (select * from sysobjects where name='APPGetNetworkThrottleClient')
	drop procedure APPGetNetworkThrottleClient
IF EXISTS (select * from GxQscripts where name='APPGetNetworkThrottleClient')
	delete from GxQscripts where name = 'APPGetNetworkThrottleClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetNetworkThrottleClient')
	delete from GXDBVersions where aliasname = 'APPGetNetworkThrottleClient'
GO
print '... Creating Procedure: APPGetNetworkThrottleClient'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure APPGetNetworkThrottleClient
  @clientId integer
AS
  DECLARE @o_clientId integer
  DECLARE @o_clientName nchar(255)
  DECLARE @o_clientHostName nchar(255)
  DECLARE @o_clientGUID nchar(255)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE 	@clientGroupTbl 	TABLE(clientGroup_id INT)
DECLARE	@clientTbl		TABLE(forClientId INT)
DECLARE @nwEnabled		integer
SET @nwEnabled = 0
IF EXISTS(SELECT * FROM APP_clientProp WHERE attrName='Network Throttle Enabled' AND componentNameId =  @clientId AND modified = 0)
SET @nwEnabled = (SELECT attrVal FROM APP_clientProp WHERE attrName='Network Throttle Enabled' AND componentNameId =  @clientId AND modified = 0)
IF @nwEnabled <> 0
BEGIN
INSERT INTO @clientTbl
SELECT forClientId
FROM APP_NetworkThrottle as NW
WHERE NW.clientId = @clientId
AND forClientId <> 0
INSERT INTO @clientGroupTbl
SELECT forClientGroupId
FROM	APP_NetworkThrottle as NW
WHERE	NW.clientId = @clientId
AND forClientGroupId <> 0
END
INSERT INTO @clientGroupTbl
SELECT forClientGroupId
FROM APP_NetworkThrottle as NW INNER JOIN APP_ClientGroupAssoc CG
	ON NW.clientGroupId = CG.clientGroupId AND CG.clientId = @clientId INNER JOIN APP_ClientGroup ACG ON CG.clientGroupId = ACG.id
WHERE forClientGroupId <> 0 AND (ACG.flag & 0x0800) = 0x0800
INSERT INTO @clientTbl
SELECT assoc.clientId
FROM APP_ClientGroupAssoc as assoc INNER JOIN @clientGroupTbl as cg ON assoc.clientGroupId = cg.clientGroup_id
INSERT INTO @clientTbl
SELECT forClientId
FROM APP_NetworkThrottle as nw INNER JOIN APP_ClientGroupAssoc CG
	ON nw.clientGroupId = CG.clientGroupId AND CG.clientId = @clientId INNER JOIN APP_ClientGroup ACG ON CG.clientGroupId = ACG.id
WHERE forClientId <> 0 AND (ACG.flag & 0x0800) = 0x0800
SELECT DISTINCT CT.forClientId, name, net_hostname, (case when releaseId < 15 then NULL else GUID end)
FROM @clientTbl as CT INNER JOIN APP_CLIENT ON CT.forClientId = id AND releaseId >= 14
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetNetworkThrottleClient')
	delete from GxQscripts where name = 'APPGetNetworkThrottleClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetNetworkThrottleClient')
	delete from GXDBVersions where aliasname = 'APPGetNetworkThrottleClient'
GO

insert into GXDBVersions values(2, 'APPGetNetworkThrottleClient',  '00010009018000020000', 'APPGetNetworkThrottleClient', '00010009018000020000')
GO

