

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetNFSSubclientProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--   [APPGetNFSSubclientProperties   - Add content in the APPGetNFSSubclientProperties.sp
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetNFSSubclientProperties')
BEGIN
	print '>>> Drop Stored Procedure: APPGetNFSSubclientProperties <<<'
	drop procedure APPGetNFSSubclientProperties
END
IF EXISTS (select * from GxQscripts where name='APPGetNFSSubclientProperties')
	delete from GxQscripts where name = 'APPGetNFSSubclientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetNFSSubclientProperties')
	delete from GXDBVersions where aliasname = 'APPGetNFSSubclientProperties'
GO
print '... Creating Procedure: APPGetNFSSubclientProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetNFSSubclientProperties
  @subclientId INT,
  @propertyLevel INT,
  @resultXML XML OUTPUT
AS
	SET NOCOUNT ON
	DECLARE	@applicationId			INT
	DECLARE @pseudoSCId				INT
	DECLARE @clientId				INT
	DECLARE @systemDrive			INT
	SELECT @applicationId = appTypeId FROM APP_Application WITH(NOLOCK) WHERE APP_Application.id = @subclientId
	-- AEB preformance fixed high CPU usage, 4 CPUs, on query below from 500ms to 5ms with 1 CPU used with to select the proper index and eliminated cardinality estimate.
	SET @pseudoSCId = (
		SELECT TOP 1
			componentNameId
		FROM APP_SubclientProp WITH(NOLOCK)
		where
			attrName = N'Associated subclient Policy'
			AND cs_attrName = CHECKSUM(N'Associated subclient Policy')		-- corrects the INDEX Scan op and selects the proper index to use
			AND attrVal = CAST(@subclientId AS NVARCHAR(12))				-- corrects the INDEX Scan op and fixes cardinality estimate for implicit cast of attrVal to Integer
			AND modified = 0
	)
	SET @clientId = (SELECT clientId FROM  APP_Application WITH(NOLOCK) WHERE id = @pseudoSCId)
	SET @systemDrive = (SELECT attrVal FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId AND attrName = 'System Drive Type' AND modified = 0)
	--Gather NFS Server properties
	IF(@applicationId = 1030 AND @systemDrive = 4)
	BEGIN
		IF OBJECT_ID('TempDb..#scProps') IS NOT NULL
			DROP TABLE #scProps
		CREATE TABLE #scProps (
			scId					INT PRIMARY KEY,
			useVersions				TINYINT,
			reuseArchiveFile		TINYINT,
			accessType				TINYINT,
			nfsServer				NVARCHAR(MAX),
			nfsClients				NVARCHAR(MAX),
			nfsUsers				NVARCHAR(MAX),
			nfsGroups				NVARCHAR(MAX),
			squashType				INT,
			enableAcls				INT,
			anonUID					BIGINT,
			anonGID					BIGINT,
			nfsObjBackupFilter		NVARCHAR(MAX),
			isCaseSensitive			TINYINT,
			protocols				XML,
			versionInterval			INT
		)
		INSERT INTO #scProps
			SELECT
				@subclientId,
				[3dfs version support needed],
				[3dfs Reuse Archive File],
				[3dfs Access Permission],
				[3dfs NFS Servers],
				[3dfs Allowed NFS Clients],
				[3dfs Users],
				[3dfs Groups],
				ISNULL([3dfs Squash Type], 4),			--CV_TDFS_NO_ROOT_SQUASH
				[3dfs ACL enable flag],
				ISNULL([3dfs Anonymous UID], -2),
				ISNULL([3dfs Anonymous GID], -2),
				ISNULL([3dfs Backup Filter], ''),
				[3dfs Case Sensitive],
				[3dfs Supported Protocols],
				[3dfs Version Interval Minutes]
			FROM (
					SELECT
						attrName,
						attrVal
					FROM
						APP_SubClientProp scp WITH(NOLOCK)
					WHERE
						scp.componentNameId = @subclientId
						AND scp.modified = 0
						AND scp.attrName IN (
							N'3dfs version support needed',		--CV_PROP_3DFS_VERSION_SUPPORT_NEEDED
							N'3dfs Reuse Archive File',			--CV_PROP_3DFS_REUSE_ARCHIVE_FILE
							N'3dfs Access Permission',			--CV_PROP_3DFS_ACCESS_PERMISSION
							N'3dfs NFS Servers',				--CV_PROP_3DFS_NFS_SERVERS
							N'3dfs Allowed NFS Clients',		--CV_PROP_3DFS_ALLOWED_NFS_CLIENTS
							N'3dfs Users',						--CV_PROP_3DFS_USERS
							N'3dfs Groups',						--CV_PROP_3DFS_GROUPS
							N'3dfs Squash Type',				--CV_PROP_3DFS_SQUASH_TYPE
							N'3dfs ACL enable flag',			--CV_PROP_3DFS_ACL_ENABLE_FLAG
							N'3dfs Anonymous UID',				--CV_PROP_3DFS_ANON_UID
							N'3dfs Anonymous GID',				--CV_PROP_3DFS_ANON_GID
							N'3dfs Backup Filter',				--CV_PROP_3DFS_BACKUP_FILTER
							N'3dfs Case Sensitive',				--CV_PROP_3DFS_CASE_SENSITIVE
							N'3dfs Supported Protocols',		--CV_PROP_3DFS_SUPPORTED_PROTOCOLS
							N'3dfs Version Interval Minutes'	--CV_PROP_3DFS_VERSION_INTERVAL
						)
						AND scp.cs_attrName IN (
							CHECKSUM(N'3dfs version support needed'),
							CHECKSUM(N'3dfs Reuse Archive File'),
							CHECKSUM(N'3dfs Access Permission'),
							CHECKSUM(N'3dfs NFS Servers'),
							CHECKSUM(N'3dfs Allowed NFS Clients'),
							CHECKSUM(N'3dfs Users'),
							CHECKSUM(N'3dfs Groups'),
							CHECKSUM(N'3dfs Squash Type'),
							CHECKSUM(N'3dfs ACL enable flag'),
							CHECKSUM(N'3dfs Anonymous UID'),
							CHECKSUM(N'3dfs Anonymous GID'),
							CHECKSUM(N'3dfs Backup Filter'),
							CHECKSUM(N'3dfs Case Sensitive'),
							CHECKSUM(N'3dfs Supported Protocols'),
							CHECKSUM(N'3dfs Version Interval Minutes')
						)
				) s
				PIVOT (
					MAX(s.attrVal) FOR s.attrName IN (
						[3dfs version support needed],
						[3dfs Reuse Archive File],
						[3dfs Access Permission],
						[3dfs NFS Servers],
						[3dfs Allowed NFS Clients],
						[3dfs Users],
						[3dfs Groups],
						[3dfs Squash Type],
						[3dfs ACL enable flag],
						[3dfs Anonymous UID],
						[3dfs Anonymous GID],
						[3dfs Backup Filter],
						[3dfs Case Sensitive],
						[3dfs Supported Protocols],
						[3dfs Version Interval Minutes]
					)
				) p
		SET	@resultXML = (
			SELECT
				(
					SELECT
						p.useVersions AS '@useVersions',
						p.reuseArchiveFile AS '@reuseArchiveFile',
						p.accessType AS '@accessType',
						p.squashType AS '@squashType',
						p.enableAcls AS '@enableAcls',
						p.anonUID AS '@anonUID',
						p.anonGID AS '@anonGID',
						p.nfsObjBackupFilter AS '@nfsObjBackupFilter',
						p.isCaseSensitive AS '@isCaseSensitive',
						p.versionInterval AS '@versionInterval',
						(SELECT
							(SELECT protocolTypeList.protocolTypes.value('@val', 'int')  '@val'
								FROM  p.protocols.nodes('/App_HybridFileStorageProtocols/protocolTypes') as protocolTypeList(protocolTypes)
								FOR XML PATH('protocolTypes'), TYPE
							)
						FOR XML PATH('protocols'), TYPE),
						p.nfsServer AS 'nfsServer/@mediaAgentName',
						(
							 SELECT
								d.Data '@val'
							 FROM dbo.Split(p.nfsClients, ',') d
							 FOR XML PATH('nfsClients'), TYPE
						),
						(
							 SELECT
								d.Data '@val'
							 FROM dbo.Split(p.nfsUsers, ',') d
							 FOR XML PATH('userIds'), TYPE
						),
						(
							 SELECT
								d.Data '@val'
							 FROM dbo.Split(p.nfsGroups, ',') d
							 FOR XML PATH('groupIds'), TYPE
						)
					FROM #scProps p
					WHERE
						p.scId = @subclientId
					FOR XML PATH('serverInfo'), TYPE
				)
			FOR XML PATH('nfsSubclientProp'), TYPE
		)
	END
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetNFSSubclientProperties')
	delete from GxQscripts where name = 'APPGetNFSSubclientProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetNFSSubclientProperties')
	delete from GXDBVersions where aliasname = 'APPGetNFSSubclientProperties'
GO

insert into GXDBVersions values(2, 'APPGetNFSSubclientProperties',  '00000000000000000000', 'APPGetNFSSubclientProperties', '00000000000000000000')
GO

