

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetMongoConnectionString.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetMongoConnectionString.sp,v $ $Id: APPGetMongoConnectionString.sp,v 1.1.2.8 2020/09/30 02:34:05 xsui Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetMongoConnectionString')
BEGIN
	print '>>> Drop Stored Procedure: APPGetMongoConnectionString <<<'
	drop procedure APPGetMongoConnectionString
END
IF EXISTS (select * from GxQscripts where name='APPGetMongoConnectionString')
	delete from GxQscripts where name = 'APPGetMongoConnectionString'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetMongoConnectionString')
	delete from GXDBVersions where aliasname = 'APPGetMongoConnectionString'
GO
print '... Creating Procedure: APPGetMongoConnectionString'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetMongoConnectionString
  @clientId INTEGER
AS
  DECLARE @r_errorCode INTEGER
  DECLARE @r_errorMessage NVARCHAR(1024)
  DECLARE @r_port integer
  DECLARE @r_host nvarchar(256)
  DECLARE @r_authCred NVARCHAR(1024)
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET @r_errorCode = 0
	SET @r_errorMessage = ''
	SET @r_port = 0
	SET @r_host = ''
	SET @r_authCred = ''
	declare @mongoClientId int = 0
	-- Check if MongoDB is installed on CS
IF @clientId <= 0 AND Exists(select 1 from simInstalledPackages where simPackageID IN (952, 1604) and clientId = 2)
	BEGIN
		-- TAKE COMMSERV BY DEFAULT
		SET @mongoClientId = 2
	END
	ELSE -- Figure out where else MongoDB may be installed.
	BEGIN
		declare @MongoConnectionInfo table
		(
			errorCode integer,
			clientId integer
		)
		insert into @MongoConnectionInfo exec AppGetMongoDbClientId @clientId
		select @mongoClientId = clientId from @MongoConnectionInfo
	END
	IF(@mongoClientId > 1)
	BEGIN
		DELETE FROM @MongoConnectionInfo
		--For clustered environment, pick mongodb information from mapped machine
        IF EXISTS(SELECT 1 FROM APP_VMToPMMap WHERE PMClientId = @mongoClientId)
        BEGIN
            select top 1 @mongoClientId = VMClientId from APP_VMToPMMap WHERE PMClientId = @mongoClientId
        END
select @r_port = Convert(int, attrval) from app_clientprop where componentNameId = @mongoClientId and modified = 0 and attrName = 'Mongo DB port' and ISNUMERIC(attrval) = 1
		select @r_host = net_hostname from App_Client with (nolock) where id = @mongoClientId;
select @r_authCred = attrval from app_clientprop where componentNameId = @mongoClientId and attrName = 'Mongo DB Access' and modified = 0
	END
	ELSE
	BEGIN
		SET @r_errorCode = 1
		SET @r_errorMessage = 'MongoDB is not installed'
	END
	IF @r_errorCode = 0 AND (@r_port = 0 OR @r_host = '' OR @r_authCred = '')
	BEGIN
		SET @r_errorCode = 1
		SET @r_errorMessage = 'MongoDB details not found in CS'
	END
	SELECT @r_errorCode as r_errorCode, @r_errorMessage as r_errorMessage, @r_port as r_port, @r_host as r_host, @r_authcred as r_authcred
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetMongoConnectionString')
	delete from GxQscripts where name = 'APPGetMongoConnectionString'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetMongoConnectionString')
	delete from GXDBVersions where aliasname = 'APPGetMongoConnectionString'
GO

insert into GXDBVersions values(2, 'APPGetMongoConnectionString',  '00010001000200080000', 'APPGetMongoConnectionString', '00010001000200080000')
GO

