

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetMediaAgentsForTopology.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- $Id: APPGetMediaAgentsForTopology.sp,v 1.1.2.6 2018/08/30 22:52:05 pnara Exp $;
--
--  +===================================================================================+
--  |   Procedure:  APPGetMediaAgentsForTopology
--  |
--  | Description:  This procedure is used to fetch media agents in a smart topology
--  |
--  |       Input:  topologyId
--  |
--  |      Output:  List of media agents for the given topology
-- 	|
--  |      Return:  xxxxxxxxxxxxxxxx
--  |
--  |   Revision	Author					Description
--  |   ---------  	-------					--------------------------------
--  |   1.1        	kmokshagundam   		Initial Edit
--  +===================================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetMediaAgentsForTopology')
BEGIN
	print '>>> Drop Stored Procedure: APPGetMediaAgentsForTopology <<<'
	drop procedure APPGetMediaAgentsForTopology
END
IF EXISTS (select * from GxQscripts where name='APPGetMediaAgentsForTopology')
	delete from GxQscripts where name = 'APPGetMediaAgentsForTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetMediaAgentsForTopology')
	delete from GXDBVersions where aliasname = 'APPGetMediaAgentsForTopology'
GO
print '... Creating Procedure: APPGetMediaAgentsForTopology'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetMediaAgentsForTopology
  @i_topologyId integer
AS
  DECLARE @mediaAgentId integer
SET NOCOUNT ON
BEGIN
	-- Check if the passed topology is infact a smart topology and it has 'My Media Agents' or 'My Commserve and Media Agents' or 'My Infrastructure' as one of its groups.
	IF EXISTS(SELECT 1 FROM APP_FirewallTopology WHERE topologyId = @i_topologyId AND (flag & 1) = 1)
	BEGIN
		DECLARE @clientGroupId INT = ISNULL((SELECT groupId FROM APP_FirewallTopologyAssoc WHERE topologyId = @i_topologyId AND fwGroupType IN (1,2) AND groupId > 0),0)
		IF @clientGroupId <> 0
		BEGIN
--Code Below Here is From AppGetClientMediaAgentMap.spb
BEGIN
	IF OBJECT_ID('tempdb.dbo.#ClientMediaAgentMap') IS NOT NULL
		DROP TABLE #ClientMediaAgentMap
	CREATE TABLE #ClientMediaAgentMap
	(
		clientId INT,
		mediaAgentId INT,
		PRIMARY KEY(clientId,mediaAgentId)
	);
	IF OBJECT_ID('tempdb..#lt_Clients') IS NOT NULL DROP TABLE #lt_Clients
	CREATE TABLE #lt_Clients
	(
		clientId	INT
		PRIMARY KEY(clientId)
	)
	IF OBJECT_ID('tempdb.dbo.#tempArchGrp') IS NOT NULL
		DROP TABLE #tempArchGrp
	CREATE TABLE #tempArchGrp
	(
		clientId	INT,
		archGroupId	INT,
		primaryCopyId smallint,
		primarySnapCopyId smallint
	)
	CREATE CLUSTERED INDEX  tempArchGrp_idx1 ON #tempArchGrp(primaryCopyId)
	CREATE NONCLUSTERED INDEX  tempArchGrp_idx2 ON #tempArchGrp(primarySnapCopyId, clientId)
DECLARE @cs_assocPlan INT = checksum('Associated Plan')
	-- Get all index servers
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
	CREATE TABLE #getIndexServers
						(     serverURL NVARCHAR(512),
								clientId INT,
								clientName NVARCHAR(256),
								cloudId INT,
								hostName NVARCHAR(256),
								basePort INT,
								engineName  NVARCHAR(256),
								serverType INT,
								indexServerClientId INT,
								internalCloudName NVARCHAR(256)
						)
	EXEC DM2GetIndexServers
	-- Get Source Clients
		INSERT 	INTO #lt_Clients
		SELECT	CN.id
		FROM	App_Client CN WITH(READUNCOMMITTED)
		WHERE	CN.id > 1
				AND EXISTS(SELECT 1 FROM APP_ClientGroupAssoc CGA WITH(READUNCOMMITTED) WHERE CN.Id = CGA.clientId AND CGA.clientGroupId = @clientGroupId)
	--
	--Find destination clients
	--
	IF @@ROWCOUNT > 0
	BEGIN
		-- Get all the storage policies
		INSERT INTO #tempArchGrp
		SELECT 	distinct APP.clientId, AG.id, AG.defaultCopy, AG.defaultSnapCopy
		FROM	#lt_Clients CN
				INNER JOIN App_Application APP WITH(READUNCOMMITTED)
				ON CN.clientId = APP.clientId
				INNER JOIN 	archGroup AAG WITH(READUNCOMMITTED)
				ON APP.dataArchGrpId = AAG.id,
				archGroup AG
		WHERE 	AG.id in (AAG.id, AAG.incrSP)
				AND AG.id > 1
		UNION
		SELECT 	distinct APP.clientId, AG.id, AG.defaultCopy, AG.defaultSnapCopy
		FROM	#lt_Clients CN
				INNER JOIN App_Application APP WITH(READUNCOMMITTED)
				ON CN.clientId = APP.clientId
				INNER JOIN 	archGroup AAG WITH(READUNCOMMITTED)
				ON APP.logArchGrpId = AAG.id,
				archGroup AG
		WHERE 	AG.id in (AAG.id, AAG.incrSP)
				AND AG.id > 1
		--Get client to infrastructure map
		INSERT INTO #ClientMediaAgentMap
		-- MediaAgents
		SELECT 	TA.clientId, DPool.clientId
		FROM 	#tempArchGrp TA,
				MMDataPath DPath WITH(READUNCOMMITTED),
				MMDrivePool DPool WITH(READUNCOMMITTED)
		WHERE	TA.primarySnapCopyId = DPath.copyId
				AND DPath.copyId > 0
				AND DPath.DrivePoolId = DPool.DrivePoolId
		UNION
		SELECT 	TA.clientId, DPool.clientId
		FROM 	#tempArchGrp TA,
				MMDataPath DPath WITH(READUNCOMMITTED),
				MMDrivePool DPool WITH(READUNCOMMITTED)
		WHERE	TA.primaryCopyId = DPath.copyId
				AND DPath.copyId > 0
				AND DPath.DrivePoolId = DPool.DrivePoolId
		UNION
		-- DDB Engines
		SELECT 	TA.clientId, SS.clientId
		FROM 	#tempArchGrp TA,
				archCopySIDBStore CPS WITH(READUNCOMMITTED),
				IdxSIDBStore S WITH(READUNCOMMITTED),
				IdxSIDBSubStore SS WITH(READUNCOMMITTED)
		WHERE	TA.primaryCopyId = CPS.copyId
				AND CPS.SIDBStoreId = S.SIDBStoreId
				AND S.sealedTime = 0 --ActiveStores
				AND S.SIDBStoreId = SS.SIDBStoreId
		UNION
		-- IndexServers: Exchange
		SELECT 	CN.clientId, S.clientId
		FROM 	#lt_Clients CN,
				APP_IDAName IDN WITH(READUNCOMMITTED),
				App_IdaProp IP WITH(READUNCOMMITTED), #getIndexServers S
		WHERE  	CN.clientId = IDN.clientId
				AND IP.componentNameId = IDN.ID
				AND IP.attrName = 'OnePass Index Server'
				AND IP.modified = 0
				AND S.indexServerClientId = CAST (IP.AttrVal AS INT)
		UNION
		-- IndexServers: Edge
		SELECT  CN.clientId, S.clientId
		FROM  	#lt_Clients CN,
				App_EdgeDriveAssociation EDGE WITH(READUNCOMMITTED), #getIndexServers S
		WHERE  	CN.clientId = EDGE.clientId
AND S.indexServerClientId = EDGE.entityId AND EDGE.entityType = 3
		UNION
		-- IndexServers: Edge Laptop clients
		SELECT	CN.clientId, EDW.webserverId
		FROM 	#lt_Clients CN
				INNER JOIN App_Client CL  WITH(READUNCOMMITTED) ON CN.clientId = CL.id
				INNER JOIN App_SyncCloudConfig SC  WITH(READUNCOMMITTED) ON CL.id = SC.clientId
				INNER JOIN App_SyncCloudFolder SF  WITH(READUNCOMMITTED) ON SC.syncWebFolderId = SF.syncWebFolderId
				INNER JOIN APP_Application APP  WITH(READUNCOMMITTED) ON APP.id = SC.subclientId
				INNER JOIN AppEdgeDriveWebserverAssociation EDW  WITH(READUNCOMMITTED) ON EDW.edgeClientId = APP.clientId
WHERE 	CL.status & 0x1000 > 0
AND SF.flag &  0x10 > 0
AND APP.subclientStatus & 0x20000 > 0
		UNION
		-- IndexServers: FileSystem
		SELECT  CN.clientId, S.clientId
		FROM  	#lt_Clients CN,
				App_Application APP WITH(READUNCOMMITTED),
				App_IndexDBInfo idx WITH(READUNCOMMITTED), #getIndexServers S
		WHERE	CN.clientId = APP.clientId
				AND idx.backupSetId = APP.backupSet
				AND S.indexServerClientId = idx.currentIdxServer
		UNION
		-- IndexServers: Plan VSA
		SELECT  T.clientId, S.clientId
		FROM  	(
					SELECT 	CN.clientId, CAST(CP.attrVal AS INT) PlanId
					FROM 	#lt_Clients CN,
							App_clientProp CP WITH(READUNCOMMITTED)
					WHERE 	CN.clientId = CP.componentNameId
AND CP.attrName = 'Associated Plan'
							AND CP.modified = 0
					UNION
					SELECT 	CN.clientId, CAST(SCP.attrVal AS INT) PlanId
					FROM 	#lt_Clients CN,
							App_Application SC WITH(READUNCOMMITTED),
							App_SubclientProp SCP WITH(READUNCOMMITTED)
					WHERE 	CN.clientId = SC.clientId
							AND SCP.componentNameId = SC.id
							AND SCP.cs_attrName = @cs_assocPlan
AND SCP.attrName = 'Associated Plan'
							AND SCP.modified = 0
				) AS T,
				App_PlanProp PROP WITH(READUNCOMMITTED), #getIndexServers S
		WHERE	PROP.componentNameId = T.PlanId
				AND PROP.attrName = 'Analytics Index Server Id'
				AND PROP.modified = 0
				AND S.indexServerClientId = CAST (PROP.AttrVal AS INT)
		UNION
		-- Remote SoftwareCache: Client Level
		SELECT  CN.clientId, UA.clientId
		FROM  	#lt_Clients CN,
				App_clientProp CP WITH(READUNCOMMITTED),
				PatchUpdateAgentInfo UA WITH(READUNCOMMITTED)
		WHERE 	CN.clientId = CP.componentNameId
				AND CP.attrName = N'UPDATE CACHE AGENT ID'
				AND CP.modified = 0
				AND CAST(CP.attrVal AS INT) = UA.id
		UNION
		-- Remote SoftwareCache: ClientGroup Level
		SELECT  CN.clientId, UA.clientId
		FROM  	#lt_Clients CN,
				App_ClientGroupAssoc CGA WITH(READUNCOMMITTED),
				APP_ComponentProp CP WITH(READUNCOMMITTED),
				PatchUpdateAgentInfo UA WITH(READUNCOMMITTED)
		WHERE 	CN.clientId = CGA.clientId
				AND CGA.clientGroupId = CP.componentId
AND CP.componentType = 8
AND CP.propertyTypeId = 1300
				AND CP.modified = 0
				AND CP.longVal = UA.id
		--
		--Remove entries if source and dest are same
		--
		DELETE 	#ClientMediaAgentMap
		WHERE	clientId = mediaAgentId
		-- Remove entries for invalid MAs.
		-- Example: On deleting a DDB MA without deleting relevant partition info (feature introduced in SP19), a MA entry with clientid=1 (NOCLIENT) is used as a placeholder.
		-- Such MA ids are invalid for general processing
		DELETE 	#ClientMediaAgentMap
		WHERE	mediaAgentId < 2
	END
	IF OBJECT_ID('tempdb..#lt_Clients') IS NOT NULL 			DROP TABLE #lt_Clients
	IF OBJECT_ID('tempdb.dbo.#tempArchGrp') IS NOT NULL 		DROP TABLE #tempArchGrp
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
END
			SELECT DISTINCT mediaAgentId
			FROM #ClientMediaAgentMap
		END
	END
END
IF OBJECT_ID('tempdb.dbo.#ClientMediaAgentMap') IS NOT NULL
					DROP TABLE #ClientMediaAgentMap
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetMediaAgentsForTopology')
	delete from GxQscripts where name = 'APPGetMediaAgentsForTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetMediaAgentsForTopology')
	delete from GXDBVersions where aliasname = 'APPGetMediaAgentsForTopology'
GO

insert into GXDBVersions values(2, 'APPGetMediaAgentsForTopology',  '00010001000200060000', 'APPGetMediaAgentsForTopology', '00010001000200060000')
GO

