

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetLastModifiedContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetLastModifiedContent.sp,v $ $Id: APPGetLastModifiedContent.sp,v 1.13.34.22 2020/03/12 01:31:48 abilbrey Exp $";
--	+===================================================================+
--	| APPGetLastModifiedContent - Get modified content for backup job	|
--	+===================================================================+
-- XML Template for saving File Types and Extensions History in App_extendedproperties
--<FileTypesAndExtensions><Moniker typeName ="" extension=""/><FileTypesAndExtensions/>
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetLastModifiedContent')
BEGIN
	print '>>> Drop Stored Procedure: APPGetLastModifiedContent <<<'
	drop procedure APPGetLastModifiedContent
END
IF EXISTS (select * from GxQscripts where name='APPGetLastModifiedContent')
	delete from GxQscripts where name = 'APPGetLastModifiedContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetLastModifiedContent')
	delete from GXDBVersions where aliasname = 'APPGetLastModifiedContent'
GO
print '... Creating Procedure: APPGetLastModifiedContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetLastModifiedContent
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlString XML
-----------------------------------------------------------
AS
--== IMPORTANT NOTE! ==========================================================================
--==
--== If this SP is modified and changes impact Laptop Backups then similar changes need to
--== done in the AppMgr/CCSDb/AdaptersInterfaceCCSDb.cpp file in method:
--==
--==	AdaptersInterfaceCCSDB::getModifiedFileList(...) where this SP is implemented as CPP
--==	and SQLite code inline directly.
--==
--==	Last NCVS V11 Version Sync'd: 1.13.34.22
--==
--== IMPORTANT NOTE! ==========================================================================
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
-----------------------------------------------------------
--- LOCALS                                              ---
-----------------------------------------------------------
DECLARE @errorCode				AS integer			= 0								-- BE OPTIMISTIC
DECLARE @errorString			AS varchar(2048)	= ''
DECLARE @o_xmlString			XML
DECLARE @lastSuccessBkupTime	AS INT				= 0
DECLARE @ATTR_NAME				AS nvarchar(100)	= N'Associated subclient Policy'
DECLARE @DECOUPLE_ATTR			AS NVARCHAR(100)	= N'Decouple SCP Content'
DECLARE @GLOBAL_FILTER_ALL_ATTR	AS NVARCHAR(100)	= N'Use Global Filters for all Subclients'
DECLARE @GLOBAL_FILTER_ATTR		AS NVARCHAR(100)	= N'use global filters'
DECLARE @CS_GLOBAL_FILTER_ATTR	AS NVARCHAR(100)	= N'use cs setting for global filters'
DECLARE @WIN_FILTER_ATTR		AS NVARCHAR(100)	= N'Windows FS Exclude Filters'
DECLARE @UNIX_FILTER_ATTR		AS NVARCHAR(100)	= N'Unix FS Exclude Filters'
DECLARE @OBJ_STORE_TYPE_ATTR	AS NVARCHAR(100)	= N'System Drive Type'
DECLARE @currentBkupLevel		AS INT				= 0								-- INCR
DECLARE @inputTime				AS INT				= 0
DECLARE @clientId				AS INT				= 0
DECLARE @osType					AS INT				= 0
DECLARE @useGlobalFiltersTime	AS INT				= 0	--TIME SC PROPERTY FOR GLOBAL FILTER THAT GOT REMOVE WAS CREATED
DECLARE @useGlobalFilterSetTime	AS INT				= 0	--TIME SC PROPERTY FOR GLOBAL FILTER THAT GOT WAS CREATED
DECLARE @useGlobalFilters		AS INT					--SC PROPERTY FOR GLOBAL FILTER THAT GOT REMOVED
DECLARE @useGlobalFilterSet		AS INT					--SC PROPERTY FOR GLOBAL FILTER THAT GOT ADDED
DECLARE @useCSGlobalFilters		AS INT
DECLARE @useGlobalForAll		AS INT
DECLARE @fileName               AS nvarchar(max)    = ''
DECLARE @created                AS INT              = 0
Declare @oldxmlstring           AS nvarchar(max) =''
Declare @newxmlstring           AS nvarchar(max) =''
Declare @oldxml					XML
Declare @newxml				    XML
DECLARE @isRecordManager		INT = 0
DECLARE @isEdgeDrive			INT = 0
DECLARE @storeType				INT = 0
DECLARE @edgeLaptopClientId			INT = 0
DECLARE @ContentTable TABLE (fileName NVARCHAR(MAX))
DECLARE @globalContentTable TABLE (id INT PRIMARY KEY IDENTITY(1,1), fileName NVARCHAR(MAX), created INT, modified INT)
DECLARE @activeGlobalContentTable TABLE (id INT PRIMARY KEY IDENTITY(1,1), fileName NVARCHAR(MAX), created INT, modified INT)
DECLARE @oldFileTypesExtensions TABLE ( typeName NVARCHAR(MAX), extension  NVARCHAR(MAX))
DECLARE @newFileTypesExtensions TABLE ( typeName NVARCHAR(MAX), extension  NVARCHAR(MAX))
DECLARE @diffFileTypesExtensions TABLE ( typeName NVARCHAR(MAX), extension  NVARCHAR(MAX))
DECLARE @oldSelectiveSyncContent TABLE(fileName NVARCHAR(MAX))
DECLARE @newSelectiveSyncContent TABLE(fileName NVARCHAR(MAX))
-----------------------------------------------------------
--		The New Client Content info we need is:
--			1)	Each subclient content item that was not previously in subclient content. For purposes of any existing item being edited, the new version of it is what is to be provided.
--			2)	Each filter item that is removed. For purposes of anything changed, the old version is what is removed.
--			3)	Each exception item that is added. For purposes of an item that is changed, the new version of it is what is added.
--		We do not want the new version/newly added filter, nor do we want any old version of an exception or any exception that is removed.
-----------------------------------------------------------
BEGIN TRY
----------------------------------------------------------
---	HERE IS WHERE WE WILL EXTRACT THE XML TO:		   ---
----------------------------------------------------------
DECLARE @subClientId			integer = 0
DECLARE @inJobId				integer = 0
-----------------------------------------------
--- EXTRACT FROM THE XML					---
----------------------------------------------
	-- GET THE SUBCLIENT ID
	SELECT @subClientId = ISNULL (ref.value('@subclientId', 'INT'), 0), @currentBkupLevel = ISNULL (ref.value('@currentBkupLevel', 'INT'), 0),
			@inputTime = ISNULL (ref.value('@timeStamp', 'INT'), 0), @inJobId = ISNULL (ref.value('@jobId', 'INT'), 0)
					FROM @i_xmlString.nodes ('App_GetModifiedFileListReq') R(ref)
	-- IF TIME IS NOT SET THEN CHECK TILL CURRENT TIME, AKA ALL RECENT CHANGES
	IF @inputTime = 0
		SET @inputTime = dbo.GetUnixTime(GETUTCDATE())
	SET @isEdgeDrive = ISNULL((SELECT 1
							FROM APP_Application APP
							WHERE APP.subclientStatus & 0x20000 = 0x20000  -- CV_STATUS_EDGEDRIVE_SUB
							AND APP.id = @subClientId), 0)
	IF @isEdgeDrive = 1
	BEGIN
		SET @storeType = ISNULL((SELECT CAST (attrVal AS INT)
							FROM APP_Application APP
							LEFT OUTER JOIN APP_ClientProp CP ON APP.clientId = CP.componentNameId AND CP.attrName = @OBJ_STORE_TYPE_ATTR AND CP.modified = 0
							WHERE APP.id = @subClientId), 0)
		IF @storeType = 3
		BEGIN
			SET @isRecordManager = 1
		END
		IF @storeType <> 0
		BEGIN
			SET @isEdgeDrive = 0
		END
	END
	IF @inJobId = 0
		IF @currentBkupLevel = 0x1000000 --ANALYTICS_INCR
		BEGIN
			SET @lastSuccessBkupTime = ISNULL((SELECT TOP 1 JMAdminJobStatsTable.servStart
											   FROM JMAdminJobStatsTable
											   WHERE JMAdminJobStatsTable.jobId = (select TOP 1 JMA.jobId
																					FROM JMAdminJobStatsTable JMA
																					INNER JOIN JMJobStats JMS ON JMS.jobId = JMA.jobId AND JMS.commCellId = JMA.commCellId
																					WHERE JMA.status in (1,3,16) AND JMA.appId = @subClientId AND JMA.opType = 53 -- OFFLINECONTENTINDEX
																					AND JMS.subOpType IN (112, 130) -- DATA_ANALYTICS2, ONLINE_CRAWL
																					ORDER BY JMA.servEnd DESC
																					)
											   ), 0)
		END
		-- IF time is not set let's get last successfull backup time
		ELSE IF @currentBkupLevel = 4     -- DIFF
			SET @lastSuccessBkupTime = ISNULL((SELECT TOP 1 servStartDate FROM JMBkpStats WHERE servEndDate = (select MAX(servEndDate) FROM JMBkpStats WHERE status in (1, 3,16) AND appId = @subClientId AND bkpLevel in (1,64,128, 16384) ) AND status in (1, 3,16)  AND bkpLevel in (1,64,128, 16384) AND appId = @subClientId ORDER BY servStartDate DESC), 0)
		ELSE
			SET @lastSuccessBkupTime = ISNULL(( SELECT TOP 1 servStartDate FROM JMBkpStats WHERE servEndDate = (SELECT MAX(servEndDate) FROM JMBkpStats WHERE status in (1, 3,16) AND appId = @subClientId) AND status in (1, 3,16) AND appId = @subClientId ORDER BY servStartDate DESC), 0)
	ELSE
	BEGIN
		IF @isEdgeDrive = 1
		BEGIN
			-- Figure out the laptop client from jobid and use it to check selective sync filters.
			SET @edgeLaptopClientId = ISNULL((SELECT targetClientId FROM JMBkpJobInfo WHERE jobId = @inJobId AND commcellId = 2), 0)
			-- Treat it as incremental job
			SET @lastSuccessBkupTime = ISNULL(( SELECT TOP 1 servStartDate FROM JMBkpStats WHERE servEndDate = (SELECT MAX(servEndDate) FROM JMBkpStats WHERE status in (1, 3,16) AND appId = @subClientId AND targetClientId = @edgeLaptopClientId) AND status in (1, 3,16) AND appId = @subClientId  AND targetClientId = @edgeLaptopClientId ORDER BY servStartDate DESC), 0)
		END
		ELSE
			SET @lastSuccessBkupTime = ISNULL(( SELECT servStartDate FROM JMBkpStats WHERE jobId = @inJobId AND appId = @subClientId), 0)
	END
DECLARE @allowLocalContent INT = ISNULL((SELECT CAST(value as INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'AllowSubclientLocalContent' AND modified = 0),1)
	DECLARE @subClientIdPolicy INT = 0
	DECLARE @localContentEnabled INT = 0
	IF @allowLocalContent = 1
	BEGIN
SET @localContentEnabled = ISNULL((SELECT CAST(attrVal as INT) FROM APP_SubClientProp WITH (NOLOCK) WHERE attrName = 'Use Local Content' AND componentNameId = @subClientId AND modified = 0),0)
	END
	IF @localContentEnabled != 1
	BEGIN
	--GET THE CONTENT FROM THE SUBCLIENT POLICY IF ANY
		SET @subClientIdPolicy = ISNULL((SELECT TOP 1 attrVal FROM APP_SubClientProp WHERE componentNameId =@subClientId AND attrName =  @ATTR_NAME AND modified=0 AND NOT EXISTS(SELECT 1 FROM APP_SubClientProp WHERE attrName=@DECOUPLE_ATTR AND componentNameId=@subClientId AND modified=0)), -1)
	END
---------------------------------------------------
--- GET latest DIFF OF FILE TYPES AND EXTENSIONS---
---------------------------------------------------
set @newxmlstring = ISNULL((select top(1) attrval from App_extendedproperties where clientid=1 and attrtype=129  and attrName = 'File Type And Extension History' and created >@lastSuccessBkupTime order by created desc ),'')
set @oldxmlstring = ISNULL((select top(1) attrval from App_extendedproperties where clientid=1 and attrtype=129  and attrName='File Type And Extension History' and created <@lastSuccessBkupTime order by created desc ),'')
 if(@newxmlstring <> '')
  BEGIN
  set @newxml=@newxmlstring
  set @oldxml=@oldxmlstring
  Insert into @newFileTypesExtensions
       SELECT  ref.value('@typeName', 'nvarchar(max)') AS typeName,
			   ref.value('@extension', 'nvarchar(max)') AS extension
			       			FROM    @newxml.nodes('FileTypesAndExtensions/Moniker') R ( ref )
  Insert into @oldFileTypesExtensions
       SELECT  ref.value('@typeName', 'nvarchar(max)') AS typeName,
			   ref.value('@extension', 'nvarchar(max)') AS extension
			       			FROM    @oldxml.nodes('FileTypesAndExtensions/Moniker') R ( ref )
  Insert into @diffFileTypesExtensions
		Select * from @newFileTypesExtensions
		except
		Select * from @oldFileTypesExtensions
  END
---------------------------------------------------------------------------------------
-- Check for files & extensions in smart content added after last back up time
---------------------------------------------------------------------------------------
	--CV_FILESYSTEM_BACKUP_SPECS    = 1,
	--CV_YESDIRS_BACKUP_FILTERS     = 2,	--EXCEPTION
	--CV_NODIRS_BACKUP_FILTERS      = 3,	--FILTER
	--CV_YESFILES_BACKUP_FILTERS    = 4,	--EXCEPTION
	--CV_NOFILES_BACKUP_FILTERS     = 5,	--FILTER
	--CONTENT
	Insert into @ContentTable
	SELECT fileName
	FROM APP_ScFilterFile
	WHERE (componentNameId=@subClientId OR componentNameId=@subClientIdPolicy)
	AND type in (1)
	AND modified=0
	AND created > @lastSuccessBkupTime
	AND created < @inputTime
	UNION
	SELECT SUBSTRING(extension,1,LEN(extension)-4)
	FROM App_FileTypeANDExtensions WHERE typeName IN
		(
			SELECT SUBSTRING(filename,3,ISNULL((LEN(filename)-3),0))
			FROM APP_ScFilterFile
			WHERE (componentNameId=@subClientId OR componentNameId=@subClientIdPolicy)
			AND type in (1)
			AND modified=0
			AND created > @lastSuccessBkupTime
			AND created < @inputTime
			AND SUBSTRING(filename,1,2) = '\%'
			AND SUBSTRING(filename,LEN(filename),1) = '%'
			AND SUBSTRING(filename,3,ISNULL((LEN(filename)-3),0)) IN(SELECT DISTINCT typeName FROM App_FileTypeANDExtensions)
		)
	--RECORD MGR CONTENT
	IF @isRecordManager = 1
	BEGIN
		Insert into @ContentTable
		SELECT folderPath
		FROM App_RMFolder RF
		INNER JOIN App_RMRecord R ON R.recordId = RF.recordId
		INNER JOIN APP_SubClientProp SP ON attrName = 'Edge Drive User Id' AND attrVal = CAST(R.ownerId AS NVARCHAR(MAX))
		WHERE SP.componentNameId = @subClientId
		AND RF.createdTime > @lastSuccessBkupTime
		AND RF.createdTime < @inputTime
	END
	ELSE IF @isEdgeDrive = 1
	BEGIN
		DECLARE @syncPath NVARCHAR(MAX)
		SELECT @syncPath = syncPath
		FROM  App_SyncCloudConfig
		WHERE subclientId = @subclientId AND clientId = @edgeLaptopClientId
		AND flag & 0x100 = 0x100 -- SYNC_IS_SELECTIVE_SYNC
		IF (@syncPath <> '' OR @syncPath IS NOT NULL )
		BEGIN
			-- See history and send any changed selective sync filters
			SET @newxmlstring = ''
			SET @oldxmlstring = ''
SET @newxmlstring = ISNULL((SELECT TOP 1 stringVal FROM App_ComponentProp WHERE componentType = 19 AND componentId = @subclientId AND propertyTypeId = @edgeLaptopClientId AND created > @lastSuccessBkupTime ORDER BY created DESC),'')
set @oldxmlstring = ISNULL((SELECT TOP 1 stringVal FROM App_ComponentProp WHERE componentType = 19 AND componentId = @subclientId AND propertyTypeId = @edgeLaptopClientId AND created <@lastSuccessBkupTime ORDER BY created DESC),'')
			if(@newxmlstring <> '')
			BEGIN
					SET @newxml = @newxmlstring
					SET @oldxml = @oldxmlstring
					INSERT INTO @oldSelectiveSyncContent
					SELECT ref.value('@itemPath', 'NVARCHAR(MAX)')
					FROM
					@oldxml.nodes('/syncOptions/destinationOptions/selectiveItemsToSync') doc(ref)
					INSERT INTO @newSelectiveSyncContent
					SELECT ref.value('@itemPath', 'NVARCHAR(MAX)')
					FROM
					@newxml.nodes('/syncOptions/destinationOptions/selectiveItemsToSync') doc(ref)
					INSERT INTO @ContentTable
					SELECT * FROM @newSelectiveSyncContent
					EXCEPT
					SELECT * FROM @oldSelectiveSyncContent
					-- Remove trailing slashes in the path if any
					SET @syncPath = REVERSE(SUBSTRING(REVERSE(@syncPath), PATINDEX('%[^\/]%', REVERSE(@syncPath)), DATALENGTH(@syncPath)))
					-- Replace by laptop path
					UPDATE @ContentTable
					SET fileName = REPLACE(fileName, '\%EDGEDRIVE%',@syncPath)
			END
		END
	END
	--EXCEPTION TO FILTERS ADDED
	Insert into @ContentTable
	SELECT fileName
	FROM APP_ScFilterFile
	WHERE (componentNameId=@subClientId OR componentNameId=@subClientIdPolicy)
	AND type in (2, 4)
	AND (
			modified=0 AND created >= @lastSuccessBkupTime	--WHAT GOT ADDED AFTER LAST BACKUP
		)
	AND created < @inputTime
	UNION
	SELECT SUBSTRING(extension,1,LEN(extension)-4)
	FROM App_FileTypeANDExtensions WHERE typeName IN
		(
			SELECT SUBSTRING(filename,3,ISNULL((LEN(filename)-3),0))
			FROM APP_ScFilterFile
			WHERE (componentNameId=@subClientId OR componentNameId=@subClientIdPolicy)
			AND type in (2, 4)
			AND (
					modified=0 AND created >= @lastSuccessBkupTime	--WHAT GOT ADDED AFTER LAST BACKUP
				)
			AND created < @inputTime
			AND SUBSTRING(filename,1,2) = '\%'
			AND SUBSTRING(filename,LEN(filename),1) = '%'
			AND SUBSTRING(filename,3,ISNULL((LEN(filename)-3),0)) IN(SELECT DISTINCT typeName FROM App_FileTypeANDExtensions)
		)
	--INCLUSION FILTERS
    Insert into @ContentTable
	SELECT fileName
	FROM APP_ScFilterFile
	WHERE (componentNameId=@subClientId OR componentNameId=@subClientIdPolicy)
	AND type in (3, 5)
	AND (
			modified > 0 AND modified >= @lastSuccessBkupTime	--WHAT GOT REMOVED AFTER LAST BACKUP
		)
	AND created < @inputTime
	UNION
	SELECT SUBSTRING(extension,1,LEN(extension)-4)
	FROM App_FileTypeANDExtensions WHERE typeName IN
	(
		SELECT SUBSTRING(filename,3,ISNULL((LEN(filename)-3),0))
		FROM APP_ScFilterFile
		WHERE (componentNameId=@subClientId OR componentNameId=@subClientIdPolicy)
		AND type in (3, 5)
		AND (
				modified > 0 AND modified >= @lastSuccessBkupTime	--WHAT GOT REMOVED AFTER LAST BACKUP
			)
		AND created < @inputTime
		AND SUBSTRING(filename,1,2) = '\%'
		AND SUBSTRING(filename,LEN(filename),1) = '%'
		AND SUBSTRING(filename,3,ISNULL((LEN(filename)-3),0)) IN(SELECT DISTINCT typeName FROM App_FileTypeANDExtensions)
	)
	--CONTENT FROM SUBCLIENT POLICY
	Insert into @ContentTable
	SELECT SUBSTRING(extension,1,LEN(extension)-4)
	FROM @diffFileTypesExtensions WHERE typeName IN
		(
			SELECT SUBSTRING(filename,3,ISNULL((LEN(filename)-3),0))
			FROM APP_ScFilterFile
			WHERE (componentNameId=@subClientId OR componentNameId=@subClientIdPolicy)
			AND type in (1)
			AND modified=0
			AND created < @lastSuccessBkupTime
			AND created < @inputTime
			AND SUBSTRING(filename,1,2) = '\%' AND SUBSTRING(filename,LEN(filename),1) = '%' AND SUBSTRING(filename,3,ISNULL((LEN(filename)-3),0)) in(select distinct typeName from App_FileTypeANDExtensions)
		)
	--EXCEPTION TO FILTERS ADDED FROM SUBCLIENT POLICY
	Insert into @ContentTable
	SELECT SUBSTRING(extension,1,LEN(extension)-4)
	FROM @diffFileTypesExtensions WHERE typeName IN
		(
			SELECT SUBSTRING(filename,3,ISNULL((LEN(filename)-3),0))
			FROM APP_ScFilterFile
			WHERE (componentNameId=@subClientId OR componentNameId=@subClientIdPolicy)
			AND type in (2, 4)
			AND (
					modified=0 AND created >= @lastSuccessBkupTime	--WHAT GOT ADDED AFTER LAST BACKUP
				)
			AND created < @inputTime
			AND SUBSTRING(filename,1,2) = '\%' AND SUBSTRING(filename,LEN(filename),1) = '%' AND SUBSTRING(filename,3,ISNULL((LEN(filename)-3),0)) in(select distinct typeName from App_FileTypeANDExtensions)
		)
	--INCLUSION FILTERS ADDED FROM SUBCLIENT POLICY
	Insert into @ContentTable
	SELECT SUBSTRING(extension,1,LEN(extension)-4)
	FROM @diffFileTypesExtensions WHERE typeName IN
		(
			SELECT SUBSTRING(filename,3,ISNULL((LEN(filename)-3),0))
			FROM APP_ScFilterFile
			WHERE (componentNameId=@subClientId OR componentNameId=@subClientIdPolicy)
			AND type in (3, 5)
			AND (
					modified > 0 AND modified >= @lastSuccessBkupTime	--WHAT GOT REMOVED AFTER LAST BACKUP
				)
			AND created < @inputTime
			AND SUBSTRING(filename,1,2) = '\%' AND SUBSTRING(filename,LEN(filename),1) = '%' AND SUBSTRING(filename,3,ISNULL((LEN(filename)-3),0)) in(select distinct typeName from App_FileTypeANDExtensions)
		)
	--NO NEED TO SEND FILTER INFORMATION ON FIRST BACKUP
	IF @lastSuccessBkupTime = 0
		GOTO BUILD_RESPONSE
	SELECT  TOP 1 @useGlobalFilters = attrVal, @useGlobalFiltersTime = created FROM APP_SubClientProp (NOLOCK) WHERE (componentNameId=@subClientId OR componentNameId=@subClientIdPolicy)
		AND attrName =  @GLOBAL_FILTER_ATTR
		AND (
				modified > 0 AND modified >= @lastSuccessBkupTime	--WHAT GOT REMOVED AFTER LAST BACKUP
		)
		AND created < @inputTime
		ORDER BY created
	IF @useGlobalFilters IS NULL
	BEGIN
		SELECT  @useGlobalFilters = attrVal, @useGlobalFiltersTime = created FROM APP_SubClientProp (NOLOCK) WHERE (componentNameId=@subClientId OR componentNameId=@subClientIdPolicy)
			AND attrName =  @GLOBAL_FILTER_ATTR
			AND (
					modified = 0 AND attrVal = '1'	--ALWAYS CHECK FOR GLOBAL FILTER CONTENT CHANGE IF GLOBAL FILTER IS ON
			)
			AND created < @inputTime
	END
	--GET THE CURRENT VALUE
	SELECT  TOP 1 @useGlobalFilterSet = attrVal, @useGlobalFilterSetTime = created FROM APP_SubClientProp (NOLOCK) WHERE (componentNameId=@subClientId OR componentNameId=@subClientIdPolicy)
		AND attrName =  @GLOBAL_FILTER_ATTR
		AND (
				modified=0 AND created >= @lastSuccessBkupTime	--WHAT GOT ADDED AFTER LAST BACKUP
			)
		AND created < @inputTime
		ORDER BY created
	SELECT TOP 1 @useGlobalForAll = value FROM GXGlobalParam (NOLOCK) WHERE name = @GLOBAL_FILTER_ALL_ATTR
		AND (
				modified > 0 AND modified >= @lastSuccessBkupTime	--WHAT GOT REMOVED AFTER LAST BACKUP
			)
		AND created < @inputTime
		ORDER BY created
	IF @useGlobalForAll IS NULL
	BEGIN
		SELECT @useGlobalForAll = value FROM GXGlobalParam (NOLOCK) WHERE name = @GLOBAL_FILTER_ALL_ATTR
			AND (
					modified = 0 AND value = '1'	--ALWAYS CHECK FOR GLOBAL FILTER CONTENT CHANGE IF GLOBAL FILTER IS ON
				)
			AND created < @inputTime
	END
	SELECT TOP 1 @useCSGlobalFilters = attrVal FROM APP_SubClientProp (NOLOCK) WHERE (componentNameId=@subClientId OR componentNameId=@subClientIdPolicy)
		AND attrName =  @CS_GLOBAL_FILTER_ATTR
		AND (
				modified > 0 AND modified >= @lastSuccessBkupTime	--WHAT GOT REMOVED AFTER LAST BACKUP
			)
		AND created < @inputTime
		ORDER BY created
	IF @useCSGlobalFilters IS NULL
	BEGIN
		SELECT @useCSGlobalFilters = attrVal FROM APP_SubClientProp (NOLOCK) WHERE (componentNameId=@subClientId OR componentNameId=@subClientIdPolicy)
			AND attrName =  @CS_GLOBAL_FILTER_ATTR
			AND (
					modified = 0 AND attrVal = '1'	--ALWAYS CHECK FOR GLOBAL FILTER CONTENT CHANGE IF GLOBAL FILTER IS ON
				)
			AND created < @inputTime
	END
	SELECT @clientId=clientId FROM APP_Application (NOLOCK) WHERE id = @subClientId
	DECLARE @cgGlobalFilterChanged INT =
	(
		SELECT TOP 1 1 FROM APP_ComponentProp prop
		INNER JOIN APP_ClientGroupAssoc association ON association.clientGroupId= prop.componentId
		WHERE association.clientId = @clientId
AND prop.propertyTypeId IN(3620, 3621)
		AND
		(
			(prop.created >= @lastSuccessBkupTime)
			OR
			(prop.modified > 0 AND prop.modified >= @lastSuccessBkupTime)
		)
		AND prop.created < @inputTime
	)
	DECLARE @useCGGlobalFilterDisabled INT =
	(
		SELECT TOP 1 1 FROM APP_ComponentProp prop
		INNER JOIN APP_ClientGroupAssoc association ON association.clientGroupId= prop.componentId
		WHERE association.clientId = @clientId
AND prop.propertyTypeId = 3622
		AND prop.longVal = 0
		AND
		(
			(prop.created >= @lastSuccessBkupTime)
		)
		AND prop.created < @inputTime
	)
	--GLOBAL FILTER SELECTION HAS CHANGED
	IF @useGlobalForAll IS NOT NULL OR @useCSGlobalFilters IS NOT NULL OR @useGlobalFilters IS NOT NULL OR @useGlobalFilterSet IS NOT NULL OR @cgGlobalFilterChanged IS NOT NULL OR @useCGGlobalFilterDisabled IS NOT NULL
	BEGIN
		SELECT @osType = dbo.scgGetClientOSType(@clientId)
		Insert into @globalContentTable
		--Insert into @ContentTable
		SELECT REPLACE(S.Data, '+1', ' '), created, modified
		FROM
		(
			--GET ENTRIES WHICH HAVE BEEN ADDED AFTER LAST BACKUP
			SELECT value, created, modified
			FROM GXGlobalParam
			WHERE
			(
				(name = @WIN_FILTER_ATTR AND @osType = 1)
				OR
				(name = @UNIX_FILTER_ATTR AND @osType = 2)
			)
			AND created >= @lastSuccessBkupTime
			UNION
			--GET ENTRIES WHICH HAVE BEEN REMOVE AFTER LAST BACKUP
			SELECT value, created, modified
			FROM GXGlobalParam
			WHERE
			(
				(name = @WIN_FILTER_ATTR AND @osType = 1)
				OR
				(name = @UNIX_FILTER_ATTR AND @osType = 2)
			)
			AND modified >= @lastSuccessBkupTime
			UNION
			--WHEN GLOBAL FILTER IS TURNED OFF ON SUBCLIENT IS LIKE ALL FILTERS WERE REMOVE. RETURN ALL THE FILTERS
			SELECT value, created, modified
			FROM GXGlobalParam
			WHERE
			(
				(name = @WIN_FILTER_ATTR AND @osType = 1)
				OR
				(name = @UNIX_FILTER_ATTR AND @osType = 2)
			)
			AND @useGlobalFilterSet = 0
			AND modified = 0
		) T
		CROSS APPLY dbo.SplitString(T.value, ' ') S
		ORDER BY created
		Insert into @globalContentTable
		SELECT REPLACE(S.Data, '+1', ' '), created, modified
		FROM
		(
			--GET CG ENTRIES WHICH HAVE BEEN ADDED AFTER LAST BACKUP
			SELECT prop.stringVal, created, modified
			FROM APP_ComponentProp prop
			INNER JOIN APP_ClientGroupAssoc association ON association.clientGroupId= prop.componentId
			WHERE association.clientId = @clientId
			AND
			(
(prop.propertyTypeId = 3620 AND @osType = 1)
				OR
(prop.propertyTypeId = 3621 AND @osType = 2)
			)
			AND prop.created >= @lastSuccessBkupTime
			UNION
			--GET CG ENTRIES WHICH HAVE BEEN REMOVE AFTER LAST BACKUP
			SELECT prop.stringVal, created, modified
			FROM APP_ComponentProp prop
			INNER JOIN APP_ClientGroupAssoc association ON association.clientGroupId= prop.componentId
			WHERE association.clientId = @clientId
			AND
			(
(prop.propertyTypeId = 3620 AND @osType = 1)
				OR
(prop.propertyTypeId = 3621 AND @osType = 2)
			)
			AND prop.modified >= @lastSuccessBkupTime
			UNION
			--WHEN CG GLOBAL FILTER IS TURNED OFF ON SUBCLIENT IS LIKE ALL FILTERS WERE REMOVE. RETURN ALL THE FILTERS
			SELECT prop.stringVal, created, modified
			FROM APP_ComponentProp prop
			INNER JOIN APP_ClientGroupAssoc association ON association.clientGroupId= prop.componentId
			WHERE association.clientId = @clientId
			AND
			(
(prop.propertyTypeId = 3620 AND @osType = 1)
				OR
(prop.propertyTypeId = 3621 AND @osType = 2)
			)
			AND EXISTS (
				SELECT 1 FROM APP_ComponentProp cp
				WHERE cp.componentId = prop.componentId
AND cp.propertyTypeId = 3622
				AND cp.longVal = 0
				AND cp.created >= @lastSuccessBkupTime AND cp.modified = 0)
		) T
		CROSS APPLY dbo.SplitString(T.stringVal, ' ') S
		ORDER BY created
		Insert into @activeGlobalContentTable
		SELECT REPLACE(S.Data, '+1', ' '), created, modified
		FROM
		(
			SELECT prop.stringVal, created, modified
			FROM APP_ComponentProp prop
			INNER JOIN APP_ClientGroupAssoc association ON association.clientGroupId= prop.componentId
			WHERE association.clientId = @clientId
			AND
			(
(prop.propertyTypeId = 3620 AND @osType = 1)
								OR
(prop.propertyTypeId = 3621 AND @osType = 2)
			)
			AND prop.modified = 0 AND prop.created < @lastSuccessBkupTime
			AND
			EXISTS (
				SELECT 1 FROM APP_ComponentProp cp
				WHERE cp.componentId = prop.componentId
AND cp.propertyTypeId = 3622
				AND cp.longVal = 1
				AND cp.modified = 0)
		) T
		CROSS APPLY dbo.SplitString(T.stringVal, ' ') S
		--WHEN GLOBAL FILTERS CHANGE THE ORIGINAL ENTRY GETS DUPLICATED MULTIPLE TIMES
		--GET THE ORIGINAL TIME WHEN THE ENTRY WAS ADDED BY FIRST
			--SET ALL MODIFIED TIMES TO 0 MAKING SURE WE KEEP ENTRY WITH CORRECT MODIFIED TIME
			UPDATE @globalContentTable
			SET modified = 0
			FROM
			(
				SELECT id i, created c, modified m
				FROM @globalContentTable G
				WHERE EXISTS	--THERE'S IS AN ENTRY WHICH APPEARS MULTIPLE TIME
				(
					SELECT 1 FROM @globalContentTable T
					WHERE T.fileName = G.fileName AND T.created = G.modified	--ENTRY WAS DUPLICATED
					AND
					EXISTS --AND THERE IS A MODIFIED TIME THAT IS 0 SO THE ENTRY IS STILL CONSIDERED AS BEING ADDED
					(
						SELECT 1 FROM @globalContentTable C WHERE C.fileName = T.fileName AND C.modified = 0
					)
				)
			) T
			WHERE id = T.i
			--REMOVE DUPLICATE ENTRY.  IF ENTRY IS THERE TWICE IT MEANS THAT IT WAS THERE WHEN GLOBAL FILTER CHANGE
			--SO WE WANT TO ONLY KEEP ORIGINAL ENTRY
			DELETE @globalContentTable
			FROM
			(
				SELECT fileName name, COUNT(fileName) c, MIN(id) minId
				FROM @globalContentTable
				GROUP BY fileName
			) T
			WHERE T.c > 1 AND T.minId <> id AND T.name = fileName
			IF @useGlobalFilterSet = 1 AND @useGlobalFiltersTime IS NOT NULL AND @useGlobalFiltersTime > 0
			BEGIN
				--DELETE @globalContentTable
				DELETE @globalContentTable WHERE modified > @useGlobalFiltersTime
			END
		DELETE @globalContentTable where fileName = ''
		DELETE @globalContentTable WHERE fileName IN(SELECT fileName FROM @activeGlobalContentTable)
		--GLOBAL FILTER ARE INCLUSION FILTERS SO APPLY SAME CHECK TO MODIFY AND CREATED COLUMN
		INSERT INTO @ContentTable
		SELECT fileName
		FROM @globalContentTable
		WHERE (@useGlobalFilterSet = 0 OR @useCGGlobalFilterDisabled = 1)
		OR
		(
			(
				modified > 0 AND modified >= @lastSuccessBkupTime	--WHAT GOT REMOVED AFTER LAST BACKUP
			)
			AND created < @inputTime
		)
	END
BUILD_RESPONSE:
	--BUILD XML STRING RESPONSE
	SET @o_xmlString = (SELECT DISTINCT fileName AS '@val'
		FROM @ContentTable
		FOR XML PATH('files'),
		ROOT('App_GetModifiedFileListResp'))
END TRY
--=====================================================================
--==============  COME HERE IF THERE WAS A PROBLEM!     ===============
--=====================================================================
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = ERROR_NUMBER()
	SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	PRINT @errorString
	--SET @o_xmlString = ( SELECT @errorCode '@errorCode', @errorString '@errorMessage'
	--	FOR XML PATH('App_GenericResp'))
	SET @o_xmlString = '<App_GetModifiedFileListResp/>'
END CATCH
SELECT @o_xmlString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetLastModifiedContent')
	delete from GxQscripts where name = 'APPGetLastModifiedContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetLastModifiedContent')
	delete from GXDBVersions where aliasname = 'APPGetLastModifiedContent'
GO

insert into GXDBVersions values(2, 'APPGetLastModifiedContent',  '00010013003400220000', 'APPGetLastModifiedContent', '00010013003400220000')
GO

