

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetLaptopClientsWithBackup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetLaptopClientsWithBackup.sp,v $ $Id: APPGetLaptopClientsWithBackup.sp,v 1.1.2.4.68.2 2021/03/20 06:59:56 someshkumar Exp $";
--	+===================================================================+
--	| APPGetLaptopClientsWithBackup - Get Laptop Client list with backup|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPGetLaptopClientsWithBackup')
BEGIN
	print '>>> Drop Stored Procedure: APPGetLaptopClientsWithBackup <<<'
	drop procedure APPGetLaptopClientsWithBackup
END
IF EXISTS (select * from GxQscripts where name='APPGetLaptopClientsWithBackup')
	delete from GxQscripts where name = 'APPGetLaptopClientsWithBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetLaptopClientsWithBackup')
	delete from GXDBVersions where aliasname = 'APPGetLaptopClientsWithBackup'
GO
print '... Creating Procedure: APPGetLaptopClientsWithBackup'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPGetLaptopClientsWithBackup
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @xmlString XML
-----------------------------------------------------------
AS
DECLARE @xmlResult XML
DECLARE @userId	integer = 0
DECLARE @userName NVARCHAR(1024) = ''
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET @userId = ISNULL (( SELECT ref.value('@userId', 'INT')
							FROM @xmlString.nodes ('App_LapTopCLientsWithBackupReq/user') R(ref)), @userId)
	SET @userName = ISNULL (( SELECT ref.value('@userName', 'NVARCHAR(1024)')
							FROM @xmlString.nodes ('App_LapTopCLientsWithBackupReq/user') R(ref)), @userName)
	IF @userId = 0 AND LEN(@userName) > 0
    BEGIN
        SELECT TOP 1 @userId = id FROM UMUsers WHERE ((login=@userName) OR (email=@userName)) and @userName<> '' AND enabled=1
        IF @userId = 0
        BEGIN
            SELECT TOP 1 @userId = id FROM UMUsers WHERE name=@userName AND enabled=1
        END
    END
SET	@xmlResult =
			(SELECT
				(SELECT
					CASE SOS.type
					WHEN 'Any' 	THEN 1
					WHEN 'Windows' THEN 2
					ELSE (CASE SOS.subtype
					      WHEN 'Darwin' THEN 4
						  ELSE 3
						  END)
					END as '@OSType',
(SELECT CO.clientId as '@clientId', C.name as '@clientName', C.displayname AS '@displayName', 3 '@_type_'
					FOR XML PATH ('client'), TYPE)
				FROM sec_getClientOwnersExpandUG CO
JOIN APP_Client C (READUNCOMMITTED) ON C.id = CO.clientId AND C.status&0x1000=0x1000 AND CO.userId = @userId
				INNER JOIN simOperatingSystem SOS ON SOS.id = C.simOperatingSystemId
				WHERE EXISTS(
						SELECT 1 FROM JMBkpStats BS (READUNCOMMITTED)
						JOIN APP_Application A (READUNCOMMITTED) ON A.clientId = C.id
						WHERE BS.appId = A.id AND BS.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
						)
				FOR XML PATH ('clientsFileSystem'), TYPE)
			FOR XML PATH ('App_LapTopCLientsWithBackupResp')
		)
SELECT @xmlResult
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetLaptopClientsWithBackup')
	delete from GxQscripts where name = 'APPGetLaptopClientsWithBackup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetLaptopClientsWithBackup')
	delete from GXDBVersions where aliasname = 'APPGetLaptopClientsWithBackup'
GO

insert into GXDBVersions values(2, 'APPGetLaptopClientsWithBackup',  'v1.1.2.4.68.2', 'APPGetLaptopClientsWithBackup', 'v1.1.2.4.68.2')
GO

