

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetLaptopClientList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetLaptopClientList.sp,v $ $Id: APPGetLaptopClientList.sp,v 1.147.2.58 2020/07/17 23:49:50 cnaik Exp $";
--	+===================================================================+
--	| APPGetLaptopClientList - Get Laptop Client list 					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetLaptopClientList')
BEGIN
	print '>>> Drop Stored Procedure: APPGetLaptopClientList <<<'
	drop procedure APPGetLaptopClientList
END
IF EXISTS (select * from GxQscripts where name='APPGetLaptopClientList')
	delete from GxQscripts where name = 'APPGetLaptopClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetLaptopClientList')
	delete from GXDBVersions where aliasname = 'APPGetLaptopClientList'
GO
print '... Creating Procedure: APPGetLaptopClientList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetLaptopClientList
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @xmlString XML OUTPUT,
  @in_userGroupGUIDs NVARCHAR(max) =''
-----------------------------------------------------------
AS
DECLARE     @function       AS varchar(80)                        = 'APPGetLaptopClientList'
DECLARE @errorCode            AS integer                          = 0                                             -- BE OPTIMISTIC
DECLARE @errorString    AS varchar(2048)              = ''
DECLARE @brAlertTrace   AS varchar(256)                     = (select value from gxglobalParam Where name = 'bralertTrace')
DECLARE @dateTime       AS DATETIME                         = getDate()
DECLARE @nowTimeUnix	AS INT								= datediff(second, '01/01/1970', @dateTime)
DECLARE @nowUTCTimeUnix	AS INT								= datediff(second, '01/01/1970', GETUTCDATE())
DECLARE @ATTR_NAME            AS nvarchar(80)                     = N'Associated subclient Policy'
DECLARE @DECOUPLE_SCP_CONTENT_ATTR_NAME   AS Nvarchar(80)   = N'Decouple SCP Content'
DECLARE @ATTR_USE_SCP_FILTERS             AS nvarchar(80)   = N'use SCP filters'
DECLARE @ATTR_CLIENT_GEO_LOCATION         AS nvarchar(80)   = N'Client Geo Location'
DECLARE @ATTR_GEO_LOCATION_DISPLAY_MODE   AS nvarchar(80)   = N'Geo Location Display Mode'
DECLARE @excludeStatusMask int = (cast(0x00010 as int) | cast(0x00020 as int))
DECLARE @excludeStatusMaskForSync int = (cast(0x00002 as int) | cast(0x00004 as int) | cast(0x00010 as int) | cast(0x00020 as int))
DECLARE @ATTR_USE_CS_SETTING_FOR_GF       	AS NVARCHAR(80)   = N'use cs setting for global filters'
DECLARE @ATTR_USE_GLOBAL_FILTERS			AS NVARCHAR(80)   = N'use global filters'
DECLARE @ATTR_USE_QNET_GLOBAL_FILTERS		AS NVARCHAR(80)	= N'Use QNET Global Filters'
DECLARE @ATTR_USE_GLOBAL_FILTERS_FOR_SC		AS NVARCHAR(80)	= N'Use Global Filters for all Subclients'
DECLARE @QNET_GLOBAL_FILTER_PREFIX			AS NVARCHAR(80)	= N'CN_'
DECLARE @ATTR_UNIX_FS_EXCLUDE_FILTERS		AS NVARCHAR(80)	= N'Unix FS Exclude Filters'
DECLARE @ATTR_WIN_FS_EXCLUDE_FILTERS		AS NVARCHAR(80)	= N'Windows FS Exclude Filters'
DECLARE @constAttrType_Feature              INT = 261
DECLARE @constAttrName_Feature				NVARCHAR(32) = N'Feature'
IF object_id('tempdb.dbo.#clientList') IS NOT NULL
	DROP TABLE #clientList
--DECLARE #clientList table (
CREATE TABLE  #clientList (
                        cId                           int not null,
            clientName				nvarchar(255) DEFAULT '',
            hostName				nvarchar(255)  DEFAULT '',
            appId               int  DEFAULT 0,
            instId              int DEFAULT 0,
            bSet                    int DEFAULT 0,
            subId                   int DEFAULT 0,
            assocBset               int DEFAULT 0,
            assocSubC               int DEFAULT 0,
            useSCPfilters           int DEFAULT 0,
            lastbkupTime            int DEFAULT 0,
            lastSuccessBkupTime     int DEFAULT 0,
            nextBkupTime            int DEFAULT 0,
			lastDataProtectedTime   INT DEFAULT 0,
            backupSize              bigint DEFAULT 0,
            capabilities            bigint DEFAULT 0,
            totalbackupsize         bigint DEFAULT 0,
            isOwner                       int DEFAULT 1,
            vCid                    int DEFAULT 0,
            isArchived              int DEFAULT 0,
            flag                    int DEFAULT 0,
            isDRalertEnabled  int DEFAULT NULL,
            isDPalertEnabled  int DEFAULT NULL,
            decoupleSCPcontent      int DEFAULT 0, --Being used for not returning schedule for non-backup VM
            lastOnlineTime			int DEFAULT 0,
            lastOfflineTime			int DEFAULT 0,
            lastGeoLocation			xml DEFAULT NULL,
            vmJobId					int DEFAULT -1,
            contentIndexingEnabled  int DEFAULT NULL,
            useGlobalFilter			int DEFAULT 0,
            lastGeoLocationTime		int DEFAULT NULL,
			geoLocationDisplayMode	int DEFAULT NULL,
			isSyncAllowed			int DEFAULT 0,
			isSyncUserProfilePresent int DEFAULT 0,
			clientStatus			int DEFAULT 0,
			isLockedClient			int DEFAULT 0,
			cloudId					int DEFAULT 0,
			isFLA					int DEFAULT 0,
			isIndexingV2			int DEFAULT 0,
			isUserCentricClient		int DEFAULT 0,
			physicalClientID		int DEFAULT 0,
			planId					int DEFAULT 0,
			planName				nvarchar(255) DEFAULT '',
			isClientDeconfigured	INT DEFAULT NULL,
			planPermissions			XML DEFAULT NULL,
			hasEdgeDriveEnabledLaptop INT DEFAULT 0,
			hasSyncBlackListedLaptop INT DEFAULT 0,
			subTaskId				INT DEFAULT 0,
			freq_type				INT DEFAULT 0,
			bsetName			NVARCHAR(255) DEFAULT '',
			features			XML DEFAULT NULL,
			totalbackupSizeSubClient BIGINT DEFAULT 0,
			totalbackupSizeBackupset BIGINT DEFAULT 0,
			isCloudLaptop			INT DEFAULT 0,
			showDLP INT DEFAULT 0,  -- The default is to hide DLP unless set in plan or clientgroup as per checks in AppGetDLPProps.spb
			restoreAuthUsersXML		XML DEFAULT NULL
            )
--When adding more columns to #clientList table, make sure to make a change in the insert query for AllowLaptopClassicSecurity
CREATE CLUSTERED INDEX ClientList_cId_IDX on #clientList(cId);
DECLARE @defaultGeoLocatoinDisplayMode  INT = 2
IF object_id('tempdb.dbo.#taskInfo') IS NOT NULL
	DROP TABLE #taskInfo
CREATE TABLE #taskInfo
(
      taskId int,
      taskName nvarchar(1024),
      subTaskId int,
      subTaskName nvarchar(1024),
      clientId int,
      patternId int,
      patternInfo nvarchar(1024),
      ownerId int,
      ownerName nvarchar(1024),
      subtaskType int
)
CREATE CLUSTERED INDEX TaskInfo_clientId_patternId_subTaskId_Idx on #taskInfo(clientId, patternId, subTaskId);
IF object_id('tempdb.dbo.#runTimeInfo') IS NOT NULL
	DROP TABLE #runTimeInfo
CREATE TABLE #runTimeInfo
(
      subTaskId int,
	  subclientId int,
	  frequencyType int,
	  nextBackupTime int
)
CREATE CLUSTERED INDEX runTimeInfo_subclientId_nextBackupTime_Idx on #runTimeInfo(subclientId, nextBackupTime);
DECLARE @vmEntity table
(
	vCid                    int not null,
	vmGUID nvarchar(1024),
	vmName	nvarchar(1024),
	vmHostName	nvarchar(1024),
	vmDirDelim varchar(255),
	vmDisplayName varchar(255),
	vendorType int
)
DECLARE @proxyEntities table
(
	instanceId int,
	clientId int,
	clientName nvarchar(255)
)
DECLARE @assocSubClient table
(
	assocSubClientId int,
	clientId      int,
	applicationId  int,
	backupsetId int,
	instanceId int,
	subclientId int
)
DECLARE @content table
(
	subId  int,
	created      int,
	modified  int,
	fileName nvarchar(1024),
	type int
)
DECLARE @SCPcontent table
(
	assocSubId  int,
	created      int,
	modified  int,
	fileName nvarchar(1024),
	type int
)
DECLARE @DLPProperties table
(
	dlpClientId      int,
	isDLPEnabledOnClient int,
	isDLPEnabledOnGroup int,
	isDLPRMEnabledOnGroup int,
	isDLPRMEnabledOnClient int,
	propertiesXML      XML
)
DECLARE @syncFolderInfo TABLE
(
	syncFolderId INT,
	syncFolderName NVARCHAR(MAX)
)
-----------------------------------------------------------
if @brAlertTrace <> 0
BEGIN
      DECLARE @input varchar(MAX) = CONVERT(varchar(MAX), @xmlString)
      exec br_ntTrace '.. APPGetLaptopClientList', 0, @dateTime, 0, 0, @input
END
BEGIN TRY
----------------------------------------------------------
---   HERE IS WHERE WE WILL EXTRACT THE XML TO:          ---
----------------------------------------------------------
DECLARE @userId                           integer = 0
DECLARE @clientId                   integer = 0
DECLARE     @scope                              integer = 1
DECLARE @localeId                   integer = 0
DECLARE @subClientId                integer = 0
DECLARE     @userGUID                     VARCHAR(255)
DECLARE     @mailBoxGuid                  VARCHAR(255)
DECLARE     @clientName                   NVARCHAR(1024)
DECLARE @isUserAdmin            integer =0
DECLARE     @getContent                 integer = 0
DECLARE     @getSchedules                 integer = 0
DECLARE @userMailBox integer = 1
DECLARE @getAllProperties integer = 0
DECLARE @getVMs integer = 0
DECLARE @getEndUserClient integer = 0
DECLARE @vmsExist integer = 0
DECLARE @defaultCommcellId integer = 2
DECLARE @clientListType integer = 3 -- Unique Clients
DECLARE @filterUserId integer = 0
DECLARE @fsLikeClientsForDistributedApps integer = 0
DECLARE @distributedAppClients integer= 0
DECLARE @userCompanyId      INT = -1
DECLARE @isGeolocationDisabledForCompany     INT = 0
-----------------------------------------------
--- EXTRACT FROM THE XML                              ---
-----------------------------------------------
      SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
      SET @userId = ISNULL (( SELECT ref.value('@userId', 'INT')
                              FROM @xmlString.nodes ('App_LapTopClientListReq/user') R(ref)), @userId)
	  SET @userGUID = (SELECT TOP 1 userGuid FROM UMUsers where id = @userId)
      SET @mailBoxGuid = ISNULL (( SELECT ref.value('@mailBoxGuid', 'VARCHAR(64)')
                              FROM @xmlString.nodes ('App_LapTopClientListReq') R(ref)), @userGUID)
      SET @clientName = ISNULL (( SELECT ref.value('@clientName', 'NVARCHAR(1024)')
                              FROM @xmlString.nodes ('App_LapTopClientListReq/client') R(ref)), '')
      IF @clientName <> ''
            SET @clientId = (SELECT id FROM APP_Client WHERE name = @clientName)
      SET @clientId = ISNULL (( SELECT ref.value('@clientId', 'INT')
                              FROM @xmlString.nodes ('App_LapTopClientListReq/client') R(ref)), @clientId)
      SET @scope = ISNULL (( SELECT ref.value('@scope', 'INT')
                              FROM @xmlString.nodes ('App_LapTopClientListReq') R(ref)), 1)
      SET @getAllProperties = ISNULL (( SELECT ref.value('@getAllProperties', 'INT')
		FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), 0)
      -- If getContent=0 disable Global Filters and SCP Filters
      SET @getContent = ISNULL (( SELECT ref.value('@getContent', 'INT')
                              FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), @getAllProperties)
      SET @getSchedules = ISNULL (( SELECT ref.value('@getSchedules', 'INT')
                              FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), @getAllProperties)
      SET @localeId = ISNULL (( SELECT ref.value('@localeId', 'INT')
                              FROM @xmlString.nodes ('App_LapTopClientListReq/locale') R(ref)), 0)
      SET @subClientId = ISNULL (( SELECT ref.value('@subclientId', 'INT')
                              FROM @xmlString.nodes ('App_LapTopClientListReq/filter/subclient') R(ref)), 1)
	  SET @userCompanyId      = ISNULL(dbo.AppGetCompanyForUserOrUserGroup(@userId, 1), -1)
      DECLARE @getFsLikeClients int
      DECLARE @getMailBoxClients int
      DECLARE @getSharePointClients int
	  DECLARE @getOneDriveClients int
      SET @getFsLikeClients = ISNULL (( SELECT ref.value('@getFsLikeClients', 'INT')
		FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), 0)
      SET @getMailBoxClients = ISNULL (( SELECT ref.value('@getMailBoxClients', 'INT')
		FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), 0)
      SET @getSharePointClients = ISNULL (( SELECT ref.value('@getSharePointClients', 'INT')
		FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), 0)
	  SET @getOneDriveClients = ISNULL (( SELECT ref.value('@getOneDriveClients', 'INT')
		FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), 0)
--    select step='debug1', userId=@userId, clientId=@clientId,
--      scope=@scope, skipContent=@skipContent, skipSchedules=@skipSchedules
	SET @getVMs = ISNULL (( SELECT ref.value('@getVMs', 'INT')
		FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), 0)
	SET @getEndUserClient = ISNULL (( SELECT ref.value('@getEndUserClient', 'INT')
		FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), 0)
	SET @clientListType =  ISNULL (( SELECT ref.value('@clientListType', 'INT')
		FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), 3)
	SET @filterUserId = ISNULL (( SELECT ref.value('@userId', 'INT')
                        FROM @xmlString.nodes ('App_LapTopClientListReq/filter/userFilter') R(ref)), 0)
	SET @fsLikeClientsForDistributedApps = ISNULL (( SELECT ref.value('@fsLikeClientsForDistributedApps', 'INT')
		FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), 0)
	SET @distributedAppClients = ISNULL (( SELECT ref.value('@distributedAppClients', 'INT')
		FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), 0)
	--If the request is for details of a client(scope=0) do not look up for mailbox and sharepoint details.
	IF(@scope=0)
	BEGIN
		SET @getMailBoxClients = 0
		SET @getSharePointClients = 0
		SET @getOneDriveClients = 0
	END
	DECLARE @enableBackupSetOwnership int = 0
	SELECT @enableBackupSetOwnership=value FROM GXGlobalParam WHERE name='enableBackupSetOwnership' AND modified=0
	DECLARE @allowLaptopClassicSecurity int = 0
	SELECT @allowLaptopClassicSecurity=value FROM GXGlobalParam WITH(READUNCOMMITTED) WHERE name = N'AllowLaptopClassicSecurity' AND value = '1'
-----------------------------------------------
-------------------------------------------------------------------------
--  FETCH THE LIST OF CLIENTS WE WILL BE REPORTING ON BASED ON 'SCOPE' --
-- 0-Specified Client (ClientEntity client), 1-AllClients,             --
-- 2-MyClients, 4-ManagedClients, 5-VMClient from Vcenter plugin                                      --
-------------------------------------------------------------------------
      IF object_id('tempdb.dbo.#tempLaptopSecurityObjects') IS NOT Null DROP TABLE #tempLaptopSecurityObjects
create table  #tempLaptopSecurityObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	  EXEC sec_getUserObjects @userId, 2013, 0, '#tempLaptopSecurityObjects'
	   DECLARE @CCLevelSec BIGINT = 0
       SELECT
              @CCLevelSec = sec.capabilities
       FROM #tempLaptopSecurityObjects AS sec
       WHERE
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
	  DECLARE @edgeSubclientId INT = 0
	-- Performance: converted from var table to temp table
	IF object_id('tempdb.dbo.#edgeClientsWithCapabilities') IS NOT NULL
		DROP TABLE #edgeClientsWithCapabilities
	CREATE TABLE #edgeClientsWithCapabilities (
		clientId INT PRIMARY KEY,
		clientStatus INT,
		capabilities BIGINT,
		userAssociationType INT
	)
	  SET @edgeSubclientId = ISNULL((SELECT TOP 1 AAP.id FROM APP_BackupSetProp ABP INNER JOIN App_Application AAP ON ABP.componentNameId = AAP.backupset WHERE ABP.attrName = 'Edge Drive User Id' AND ABP.attrVal = CAST(@userId AS NVARCHAR(256)) AND ABP.modified =0) ,0)
	DECLARE @appType35Table TABLE (
		appTypeId		INT PRIMARY KEY
	)
	IF @fsLikeClientsForDistributedApps = 1
	BEGIN
		SET @getFsLikeClients = 1
	END
	INSERT INTO @appType35Table
		SELECT DISTINCT appTypeId
		FROM GetAppTypesForAppGroup(35,0)
		WHERE @getFsLikeClients = 1
	DECLARE @appType55Table TABLE (
		appTypeId		INT PRIMARY KEY
	)
	INSERT INTO @appType55Table
		SELECT DISTINCT appTypeId
		FROM GetAppTypesForAppGroup(55,0)
		WHERE @getSharePointClients = 1
	DECLARE @appType135Table TABLE ( appTypeId	INT PRIMARY KEY	)
	INSERT INTO @appType135Table SELECT DISTINCT appTypeId FROM GetAppTypesForAppGroup(135,0) WHERE @getOneDriveClients = 1
	DECLARE @onedriveV2ClientTbl TABLE ( clientId INT PRIMARY KEY)
	INSERT INTO @onedriveV2ClientTbl
		SELECT DISTINCT APP.clientId FROM APP_Application APP
			INNER JOIN APP_ClientProp CL on APP.clientId = CL.componentNameId
			INNER JOIN APP_InstanceProp INST on APP.instance = INST.componentNameId
			WHERE CL.attrName = 'Office 365 Pseudo Client' and CL.attrVal = 1  and INST.attrName = 'Cloud Apps Instance Type' and INST.attrVal = 7
			and CL.modified = 0 and INST.modified = 0 and @getOneDriveClients = 1
	--Remove distributed apptypes from the list
	IF @fsLikeClientsForDistributedApps = 1
	BEGIN
	DELETE @appType35Table WHERE appTypeId = 64
	END
	--Only have distributed apptypes
	ELSE IF @distributedAppClients = 1
	BEGIN
	DELETE @appType35Table WHERE appTypeId <> 64
	END
      IF @scope = 0
      BEGIN
           IF OBJECT_ID('tempdb.dbo.#appLaptopClientListTemp') IS NOT NULL DROP TABLE #appLaptopClientListTemp
			CREATE TABLE #appLaptopClientListTemp(clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT)
			EXEC sec_getIdaObjectsForUser @userId, 3  /*CLIENT_ENTITY */ , 0 /*View*/, 0, '#appLaptopClientListTemp'
		INSERT INTO #clientList(cId,clientName,hostName,appId,instId,bSet,subId,flag,clientStatus,bsetName)
		SELECT CL.clientId, c.displayName, c.net_hostname,ida.appTypeId, sc.instance, BS.id, sc.id, sc.subclientStatus,c.status,bs.name
				FROM #appLaptopClientListTemp CL
				INNER JOIN APP_Client c on c.id=CL.clientId
				INNER JOIN APP_IDAName ida on ida.clientId = CL.clientId
				INNER JOIN @appType35Table Tbl35 ON ida.appTypeId = Tbl35.appTypeId AND ida.appTypeId <> 13
				INNER JOIN APP_Application SC ON SC.clientId= C.id AND SC.appTypeId = IDA.appTypeId AND  (subClientStatus & 0x00008 = 0x00008 ) AND subclientStatus&@excludeStatusMask = 0
				INNER JOIN APP_BackupSetName BS ON BS.id = SC.backupSet AND BS.status & 0x00008 = 0x00008
			WHERE
				CL.clientId = @clientID
		--this code will not be called as for scope 0 @getSharePointClients is set to 0
		IF(@getSharePointClients = 1)
		BEGIN
			INSERT INTO #clientList(cId,clientName,hostName,appId,instId,bSet,subId,flag,clientStatus,bsetName)
			SELECT DISTINCT CL.clientId, c.displayName, c.net_hostname,app.appTypeId, app.instance, b.id, app.id, app.subclientStatus,c.status,b.name
				FROM #appLaptopClientListTemp CL
					INNER JOIN APP_Client c on c.id=CL.clientId
					INNER JOIN APP_APPLICATION app on app.clientid= cL.clientid and app.appTypeId in (SELECT appTypeId FROM @appType55Table) and (subClientStatus & 0x00008 = 0x00008 ) AND subclientStatus&@excludeStatusMask = 0 -- and releaseId>15
				INNER JOIN app_backupsetname b on app.backupset = b.id and (b.status & 0x80000 =0x80000  or b.status & 0x00008 = 0x00008  )
					WHERE
				CL.clientId = @clientID
		END
		IF(@getOneDriveClients = 1)
		BEGIN
			INSERT INTO #clientList(cId,clientName,hostName,appId,instId,bSet,subId,flag,clientStatus,bsetName)
			SELECT DISTINCT CL.clientId, c.displayName, c.net_hostname,app.appTypeId, app.instance, b.id, app.id, app.subclientStatus,c.status,b.name
				FROM #appLaptopClientListTemp CL
					INNER JOIN APP_Client c on c.id=CL.clientId and c.id in ( SELECT clientId from @onedriveV2ClientTbl )
					INNER JOIN APP_APPLICATION app on app.clientid= cL.clientid and app.appTypeId in (SELECT appTypeId FROM @appType135Table) and (subClientStatus & 0x00008 = 0x00008 ) AND subclientStatus&@excludeStatusMask = 0 -- and releaseId>15
				INNER JOIN app_backupsetname b on app.backupset = b.id and (b.status & 0x80000 =0x80000  or b.status & 0x00008 = 0x00008  )
					WHERE
				CL.clientId = @clientID
		END
            IF(@getVMs = 1)
            BEGIN
				INSERT INTO #clientList(cId,clientName,hostName,appId,capabilities,vCid,clientStatus)
SELECT um.clientId, c.displayName, c.net_hostname,106, um.capabilities, um.ClientId,c.status
						FROM UMOwnerCredentials um
					INNER JOIN APP_Client c on c.id=um.clientId
						INNER JOIN App_ClientProp prop on prop.componentNameId = um.clientId
					WHERE attrName = 'Virtual Server Discovered Clients' AND prop.modified = 0 AND attrVal='1'
						AND um.userId = @userId and um.clientId = @clientId
				IF (@@ROWCOUNT > 0)
				BEGIN
					SET @vmsExist = 1
				END
			END
			-- Insert Edge Client
				DELETE cl
				FROM #clientList cl
				INNER JOIN APP_CLIENT C WITH (NOLOCK) on  C.id = cId and C.status & 0x10000000 > 0
WHERE EXISTS (SELECT * FROM APP_CLIENT C WITH (NOLOCK) WHERE  C.id = cId and C.status & 0x10000000 > 0)
			EXEC AppGetEdgeCapabilties @userId, '#edgeClientsWithCapabilities'
			INSERT INTO #clientList(cId,clientName,hostName,appId,instId, clientStatus)
			SELECT TOP 1 EC.clientId,  c.displayName, c.net_hostname, SC.apptypeId, SC.instance, c.status
			FROM APP_Client c
			INNER JOIN  #edgeClientsWithCapabilities EC on ec.clientId=c.id
			INNER JOIN APP_Application SC ON EC.clientId = SC.clientId
			WHERE c.Id = @clientId
			ORDER BY EC.userAssociationType DESC
			UPDATE #clientList
			SET bSet = ISNULL(bs.backupSetId, -1), flag= ISNULL(bs.subclientStatus, 0), subId = ISNULL(bs.subclientId, -1),bsetName=bs.name
			FROM  #clientList cl
			LEFT OUTER JOIN ( SELECT componentNameId AS backupSetId, a.id AS subclientId, a.clientId, a.subclientStatus, bsn.name FROM APP_BackupSetProp bs
							INNER JOIN APP_Application a ON bs.componentNameId = a.backupSet
							INNER JOIN APP_backupsetName bsn on bsn.id = bs.componentNameId
							WHERE  bs.attrName = 'Edge Drive User Id' AND bs.modified = 0 AND bs.attrVal = @userId
							)bs ON bs.clientId = cl.cId
WHERE cl.clientStatus &  0x10000000  <> 0 -- Only for edge clients
			-- Add other client rows if using laptop classic security
			IF (@allowLaptopClassicSecurity = 1)
			BEGIN
				IF OBJECT_ID('tempdb.dbo.#WSSecClients') IS NOT NULL
					DROP TABLE #WSSecClients
				CREATE TABLE #WSSecClients (
					clientId		INT,
					appTypeId		INT,
					caps			BIGINT,
					PRIMARY KEY (clientId, appTypeId, caps)
				)
				INSERT #WSSecClients
					SELECT
						ida.clientId, ida.appTypeId, dbo.BitwiseOR(t.capabilities)
					FROM #tempLaptopSecurityObjects t
						INNER JOIN APP_IDAName ida WITH (NOLOCK) ON
(ida.clientId = t.clientId  OR (t.commCellId=2 AND t.clientGroupId=0 AND t.clientId=0 AND t.appTypeId=0 AND t.instanceId=0 AND t.backupsetId=0 AND t.subClientId=0 AND t.mediaAgentId=0 AND t.libraryId=0 AND t.archGroupId=0 AND t.vtContainerId=0 AND t.vtPolicyId=0 AND t.vtShelfId=0 AND t.reviewSetId=0 AND t.querySetId=0 AND t.downloadSetId=0 AND t.ermId=0 AND t.legalHoldId=0 AND t.tagId=0 AND t.cdPolicyId=0 AND t.complianceReportId=0 AND t.taskId=0 AND t.workflowId=0 AND t.logMonitoringPolicyId=0 AND t.arrayId=0 AND t.cloudId=0 AND t.userGroupId=0 AND t.providerId=0 AND t.entityId1=0 AND t.entityId2=0 AND t.entityId3=0 AND t.entityId4=0 AND t.entityId5=0									AND t.entityId6=0 AND t.entityId7=0 AND t.entityId8=0 AND t.entityId9=0))
							AND (ida.appTypeId = t.appTypeId OR t.appTypeId=0)
							AND (
								(
									ida.appTypeId in (SELECT appTypeId FROM @appType35Table)
									AND @getFsLikeClients = 1
									AND ida.appTypeId <> 13
								)
								OR  (
									@getSharePointClients = 1--share point clients are already fetched using classic security so not making a change for office365
									AND ida.appTypeId in (SELECT appTypeId FROM @appType55Table)
								)
								OR  (
									@getOneDriveClients = 1-- onedrive clients are already fetched using classic security so not making a change for office365
									AND ida.appTypeId in (SELECT appTypeId FROM @appType135Table)
								)
							)
					WHERE
						ida.clientId = @clientId
					group by ida.clientId, ida.appTypeId
					UNION
					SELECT
						cp.componentNameId, 106, dbo.BitwiseOR(t.capabilities)
					FROM #tempLaptopSecurityObjects t
						INNER JOIN App_ClientProp cp WITH (NOLOCK) ON
cp.componentNameId = t.clientId OR (t.commCellId=2 AND t.clientGroupId=0 AND t.clientId=0 AND t.appTypeId=0 AND t.instanceId=0 AND t.backupsetId=0 AND t.subClientId=0 AND t.mediaAgentId=0 AND t.libraryId=0 AND t.archGroupId=0 AND t.vtContainerId=0 AND t.vtPolicyId=0 AND t.vtShelfId=0 AND t.reviewSetId=0 AND t.querySetId=0 AND t.downloadSetId=0 AND t.ermId=0 AND t.legalHoldId=0 AND t.tagId=0 AND t.cdPolicyId=0 AND t.complianceReportId=0 AND t.taskId=0 AND t.workflowId=0 AND t.logMonitoringPolicyId=0 AND t.arrayId=0 AND t.cloudId=0 AND t.userGroupId=0 AND t.providerId=0 AND t.entityId1=0 AND t.entityId2=0 AND t.entityId3=0 AND t.entityId4=0 AND t.entityId5=0									AND t.entityId6=0 AND t.entityId7=0 AND t.entityId8=0 AND t.entityId9=0 )
						WHERE
							@getVMs = 1
							AND cp.componentNameId=@clientId
							AND cp.attrName = 'Virtual Server Discovered Clients'
							AND modified = 0
							AND attrVal = '1'
					group by cp.componentNameId
					IF (@@ROWCOUNT > 0)
					BEGIN
						-- merge the additional rows into the clientlist
						--other than VMs
						MERGE #clientList cl
						USING (SELECT ws.clientId, ws.appTypeId, ws.caps, c.displayName,c.net_hostname, c.status ,app.instance as instanceId, b.id as backupsetId, app.id as subclientId, app.subclientStatus,b.name
						FROM #WSSecClients ws
						INNER JOIN app_client c WITH (NOLOCK)  on c.id=ws.clientId AND ws.appTypeId <> 106
						INNER JOIN APP_APPLICATION app WITH (NOLOCK) on app.clientid= c.id and (subClientStatus & 0x00008 = 0x00008 ) AND subclientStatus&@excludeStatusMask = 0  and app.appTypeId = ws.appTypeId
						INNER JOIN app_backupsetname b WITH (NOLOCK) on app.backupset = b.id and (b.status & 0x80000 =0x80000  or b.status & 0x00008 = 0x00008  )) fs ON (
								fs.clientId = cl.cId
								AND fs.appTypeId = cl.appId
							)
						WHEN NOT MATCHED BY TARGET THEN		-- not found insert row
						INSERT  (cId, clientName, hostName,appId, instId,bSet, subId,capabilities,flag,clientStatus, bsetName)  VALUES (fs.clientId, fs.displayName,fs.net_hostname,fs.appTypeId, fs.instanceId, fs.backupsetId, fs.subclientId, fs.caps,fs.subclientStatus,fs.status,fs.name)
						WHEN MATCHED THEN		-- if found update capabilities
							UPDATE
								SET cl.capabilities = (cl.capabilities | fs.caps);
						--Vms
						IF(	@getVMs = 1)
						BEGIN
							MERGE #clientList cl
							USING #WSSecClients fs ON (
                                fs.clientId = cl.cId
                                AND fs.appTypeId = cl.appId AND fs.appTypeId = 106
                            )
							WHEN NOT MATCHED BY TARGET THEN     -- not found insert row
							INSERT  (cId, appId, capabilities,vCid )  VALUES (fs.clientId, fs.appTypeId, fs.caps,fs.clientId)
							WHEN MATCHED THEN       -- if found update capabilities
								UPDATE
                                SET cl.capabilities = (cl.capabilities | fs.caps);
						END
					END
					IF EXISTS(SELECT TOP 1 1 FROM #WSSecClients where appTypeId=106)
						SET @vmsExist = 1
					IF OBJECT_ID('tempdb.dbo.#WSSecClients') IS NOT NULL
						DROP TABLE #WSSecClients
			END
--
      END
      ELSE IF @scope = 2
      BEGIN
            IF @distributedAppClients = 1
			BEGIN
				INSERT INTO #clientList(cId,clientName,hostName,appId,instId,bSet,subId,capabilities,flag,clientStatus,bsetName)
				SELECT DISTINCT um.clientId, c.displayName, c.net_hostname,APP.appTypeId, app.instance, BS.id, app.id, um.capabilities, app.subclientStatus,c.status,BS.NAME
				FROM   UMOwnerCredentials um
					INNER JOIN APP_Client c on c.id=um.clientId
					INNER JOIN APP_Application APP ON APP.appTypeId = 64 AND APP.clientId = um.clientId and  (subClientStatus & 0x00008 = 0x00008 ) AND subclientStatus&@excludeStatusMask = 0
					INNER JOIN APP_InstanceProp INST ON INST.componentNameId = APP.instance
					INNER JOIN APP_BackupSetName BS ON BS.id = APP.backupSet AND BS.status & 0x00008 = 0x00008
				WHERE um.userId = @userId AND INST.attrName = 'Distributed Cluster Type' AND INST.attrVal IN
																(select attrval from APP_InstanceProp inst
																				join app_application app on app.instance  = inst.componentNameId and app.clientId = @clientId
																				where inst.attrName = 'Distributed Cluster Type')
			END
			ELSE
			BEGIN
			INSERT #clientList(cId,clientName,hostName,appId,instId,bSet,subId,capabilities,flag,clientStatus,bsetName)
			SELECT DISTINCT um.clientId, c.displayName, c.net_hostname,SC.appTypeId, SC.instance, BS.id, SC.id,um.capabilities, sc.subclientStatus,c.status,BS.NAME
				FROM   UMOwnerCredentials um
					INNER JOIN APP_Client c on c.id=um.clientId
					INNER JOIN APP_IDAName ida on ida.clientId = um.clientId
					INNER JOIN @appType35Table Tbl35 ON ida.appTypeId = Tbl35.appTypeId AND ida.appTypeId <> 13
					INNER JOIN APP_Application SC ON SC.clientId= C.id AND SC.appTypeId = IDA.appTypeId AND  (subClientStatus & 0x00008 = 0x00008 ) AND subclientStatus&@excludeStatusMask = 0
					INNER JOIN APP_BackupSetName BS ON BS.id = SC.backupSet AND BS.status & 0x00008 = 0x00008
				WHERE um.userId = @userId
			END
            DELETE CL
			FROM #clientList CL
			LEFT JOIN APP_CLIENT C ON C.ID = CL.CID
			WHERE C.ID IS NULL
			IF(@getSharePointClients = 1) --FOR SHAREPOINT GET ALL THE CLIENT ON WHICH USER HAS RIGHTS
			BEGIN
			INSERT INTO #clientList(cId,clientName,hostName,appId,instId,bSet,subId,flag,clientStatus,bsetName)
			SELECT distinct C.id,  c.displayName, c.net_hostname, app.appTypeId, app.instance, b.id, app.id,app.subclientStatus,c.status,b.name
				FROM APP_Client C
				INNER JOIN APP_APPLICATION app on app.clientid= c.id and app.appTypeId in (SELECT appTypeId FROM @appType55Table)  and releaseId>15 and (subClientStatus & 0x00008 = 0x00008 ) AND subclientStatus&@excludeStatusMask = 0
INNER JOIN app_backupsetname b on app.backupset = b.id and (b.status & 0x80000 =0x80000  or b.status & 0x00008 = 0x00008  )
				INNER JOIN #tempLaptopSecurityObjects sec on
				(sec.clientId=c.id	AND (sec.appTypeId=app.appTypeId OR sec.appTypeId=0)  AND (sec.instanceId=app.instance OR sec.instanceId=0) AND (sec.backupsetid = b.id OR sec.backupsetid = 0))
				 OR--CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
				(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
				)
			END
			IF(@getOneDriveClients = 1) --FOR ONEDRIVE GET ALL THE CLIENT ON WHICH USER HAS RIGHTS
			BEGIN
			INSERT INTO #clientList(cId,clientName,hostName,appId,instId,bSet,subId,flag,clientStatus,bsetName)
			SELECT distinct C.id,  c.displayName, c.net_hostname, app.appTypeId, app.instance, b.id, app.id,app.subclientStatus,c.status,b.name
				FROM APP_Client C
				INNER JOIN APP_APPLICATION app on app.clientid= c.id and app.appTypeId in (SELECT appTypeId FROM @appType135Table)  and app.clientid in (SELECT clientId from @onedriveV2ClientTbl) and releaseId>15 and (subClientStatus & 0x00008 = 0x00008 ) AND subclientStatus&@excludeStatusMask = 0
				INNER JOIN app_backupsetname b on app.backupset = b.id and (b.status & 0x80000 =0x80000  or b.status & 0x00008 = 0x00008  )
				INNER JOIN #tempLaptopSecurityObjects sec on
				(sec.clientId=c.id	AND (sec.appTypeId=app.appTypeId OR sec.appTypeId=0)  AND (sec.instanceId=app.instance OR sec.instanceId=0) AND (sec.backupsetid = b.id OR sec.backupsetid = 0))
				 OR--CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
				(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
				)
			END
			IF(@getVMs = 1)
            BEGIN
				IF EXISTS(SELECT um.clientId
							FROM UMOwnerCredentials um
							INNER JOIN App_ClientProp prop on prop.componentNameId = um.clientId
							WHERE attrName = 'Virtual Server Discovered Clients' AND modified = 0 AND attrVal = '1'
							AND um.userId = @userId)
				BEGIN
					SET @vmsExist = 1
				INSERT INTO #clientList(cId,clientName,hostName,appId,capabilities,vCid, clientStatus)
				SELECT um.clientId,c.displayName, c.net_hostname, 106, um.capabilities, um.clientId,c.status
					FROM UMOwnerCredentials um
					INNER JOIN APP_client c on c.id= um.clientId
					INNER JOIN App_ClientProp prop on prop.componentNameId = um.clientId
				WHERE attrName = 'Virtual Server Discovered Clients' AND prop.modified = 0 AND um.userId = @userId AND attrVal = '1'
			END
				END
			-- Insert Edge Client
			DELETE CL
			FROM #clientList CL
INNER JOIN APP_CLIENT C ON C.ID = CL.CID AND C.status & 0x10000000 > 0
			IF @edgeSubclientId <> 0
			BEGIN
			INSERT #clientList(cId,clientName,hostName,appId,instId,bSet,subId,flag,clientStatus,bsetName)
			SELECT DISTINCT SC.clientId, c.displayName, c.net_hostname,SC.appTypeId, SC.instance, BS.id, SC.id, sc.subclientStatus,c.status,BS.NAME
				FROM APP_Application SC
			INNER JOIN app_client c on c.id = sc.clientId
			INNER JOIN app_backupsetname bs on bs.id = sc.backupset
			WHERE sc.id = @edgeSubclientId
			END
			ELSE
			BEGIN
				EXEC AppGetEdgeCapabilties @userId, '#edgeClientsWithCapabilities'
			INSERT INTO #clientList(cId,clientName,hostName,appId,instId, clientStatus)
			SELECT TOP 1 EC.clientId,  c.displayName, c.net_hostname, SC.apptypeId, SC.instance, c.status
			FROM APP_Client c
			INNER JOIN   #edgeClientsWithCapabilities EC ON EC.clientId=c.id
				INNER JOIN APP_Application SC ON EC.clientId = SC.clientId
			INNER JOIN App_EdgeDriveAssociation EDA ON EDA.clientId = EC.clientId AND EDA.entityType = 3 AND EDA.entityId > 1
				WHERE  EC.capabilities & 4112  = 4112 -- Clients with upload and browse capability
AND EC.clientStatus & 0x40000000 = 0 -- Dont send system drives.
				order by EC.userAssociationType desc
			UPDATE #clientList
			SET bSet = ISNULL(bs.backupSetId, -1), flag= ISNULL(bs.subclientStatus, 0), subId = ISNULL(bs.subclientId, -1),bsetName=bs.name
			FROM  #clientList cl
			LEFT OUTER JOIN ( SELECT componentNameId AS backupSetId, a.id AS subclientId, a.clientId, a.subclientStatus, bsn.name FROM APP_BackupSetProp bs
							INNER JOIN APP_Application a ON bs.componentNameId = a.backupSet
							INNER JOIN APP_backupsetName bsn on bsn.id = bs.componentNameId
							WHERE  bs.attrName = 'Edge Drive User Id' AND bs.modified = 0 AND bs.attrVal = @userId
							)bs ON bs.clientId = cl.cId
WHERE cl.clientStatus &  0x10000000  <> 0 -- Only for edge clients
			END
			-- Add other client rows if using laptop classic security
			IF (@allowLaptopClassicSecurity = 1)
			BEGIN
				IF OBJECT_ID('tempdb.dbo.#WSSecClients2') IS NOT NULL
					DROP TABLE #WSSecClients2
				CREATE TABLE #WSSecClients2 (
					clientId		INT,
					appTypeId		INT,
					caps			BIGINT,
					PRIMARY KEY (clientId, appTypeId, caps)
				)
				--correct change, verify other places
				INSERT #WSSecClients2
					SELECT
						ida.clientId, ida.appTypeId,dbo.BitwiseOR(t.capabilities)
					FROM #tempLaptopSecurityObjects t
						INNER JOIN APP_IDAName ida ON
(ida.clientId = t.clientId OR (t.commCellId=2 AND t.clientGroupId=0 AND t.clientId=0 AND t.appTypeId=0 AND t.instanceId=0 AND t.backupsetId=0 AND t.subClientId=0 AND t.mediaAgentId=0 AND t.libraryId=0 AND t.archGroupId=0 AND t.vtContainerId=0 AND t.vtPolicyId=0 AND t.vtShelfId=0 AND t.reviewSetId=0 AND t.querySetId=0 AND t.downloadSetId=0 AND t.ermId=0 AND t.legalHoldId=0 AND t.tagId=0 AND t.cdPolicyId=0 AND t.complianceReportId=0 AND t.taskId=0 AND t.workflowId=0 AND t.logMonitoringPolicyId=0 AND t.arrayId=0 AND t.cloudId=0 AND t.userGroupId=0 AND t.providerId=0 AND t.entityId1=0 AND t.entityId2=0 AND t.entityId3=0 AND t.entityId4=0 AND t.entityId5=0									AND t.entityId6=0 AND t.entityId7=0 AND t.entityId8=0 AND t.entityId9=0))
							AND (ida.appTypeId = t.appTypeId OR t.appTypeId=0)
							AND (
								@getFsLikeClients = 1
								AND ida.appTypeId IN (SELECT appTypeId FROM @appType35Table)
								AND ida.appTypeId <> 13
							)
							group by ida.clientId, ida.appTypeId
					UNION
					SELECT cp.componentNameId, 106, dbo.BitwiseOR(t.capabilities)
					FROM #tempLaptopSecurityObjects t
						INNER JOIN App_ClientProp cp WITH (NOLOCK) ON
cp.componentNameId = t.clientId OR  (t.commCellId=2 AND t.clientGroupId=0 AND t.clientId=0 AND t.appTypeId=0 AND t.instanceId=0 AND t.backupsetId=0 AND t.subClientId=0 AND t.mediaAgentId=0 AND t.libraryId=0 AND t.archGroupId=0 AND t.vtContainerId=0 AND t.vtPolicyId=0 AND t.vtShelfId=0 AND t.reviewSetId=0 AND t.querySetId=0 AND t.downloadSetId=0 AND t.ermId=0 AND t.legalHoldId=0 AND t.tagId=0 AND t.cdPolicyId=0 AND t.complianceReportId=0 AND t.taskId=0 AND t.workflowId=0 AND t.logMonitoringPolicyId=0 AND t.arrayId=0 AND t.cloudId=0 AND t.userGroupId=0 AND t.providerId=0 AND t.entityId1=0 AND t.entityId2=0 AND t.entityId3=0 AND t.entityId4=0 AND t.entityId5=0									AND t.entityId6=0 AND t.entityId7=0 AND t.entityId8=0 AND t.entityId9=0)
						WHERE
							@getVMs = 1
							AND cp.attrName = 'Virtual Server Discovered Clients'
							AND modified = 0
							AND attrVal = '1'
					group by cp.componentNameId
					IF (@@ROWCOUNT > 0)
					BEGIN
						--other than VMs
						MERGE #clientList cl
						USING (SELECT c.id as clientId, app.appTypeId, ws.caps, c.displayName,c.net_hostname, c.status ,app.instance as instanceId, b.id as backupsetId, app.id as subclientId, app.subclientStatus,b.name
						FROM #WSSecClients2 ws
						INNER JOIN app_client c WITH (NOLOCK) on c.id=ws.clientId
						INNER JOIN APP_APPLICATION app WITH (NOLOCK) on app.clientid= c.id and (subClientStatus & 0x00008 = 0x00008 ) AND subclientStatus&@excludeStatusMask = 0  and app.appTypeId = ws.appTypeId
						INNER JOIN app_backupsetname b WITH (NOLOCK) on app.backupset = b.id and (b.status & 0x80000 =0x80000  or b.status & 0x00008 = 0x00008  )) fs ON (
                                fs.clientId = cl.cId
                                AND fs.appTypeId = cl.appId
                            )
                        WHEN NOT MATCHED BY TARGET and fs.appTypeId <> 106 THEN     -- not found insert row
                        INSERT  (cId, clientName, hostName,appId, instId,bSet, subId,capabilities,flag,clientStatus, bsetName)  VALUES (fs.clientId, fs.displayName,fs.net_hostname,fs.appTypeId, fs.instanceId, fs.backupsetId, fs.subclientId, fs.caps,fs.subclientStatus,fs.status,fs.name)
						WHEN MATCHED THEN       -- if found update capabilities
                            UPDATE
                                SET cl.capabilities = (cl.capabilities | fs.caps);
						--for VMs
						MERGE #clientList cl
                        USING #WSSecClients2 fs ON (
                                fs.clientId = cl.cId
                                AND fs.appTypeId = cl.appId
                            )
                        WHEN NOT MATCHED BY TARGET AND fs.appTypeId = 106 THEN     -- not found insert row
                        INSERT  (cId, appId, capabilities,vCid )  VALUES (fs.clientId, fs.appTypeId, fs.caps,fs.clientId)
                        WHEN MATCHED THEN       -- if found update capabilities
                            UPDATE
                                SET cl.capabilities = (cl.capabilities | fs.caps);
					END
					IF EXISTS(SELECT TOP 1 1 FROM #WSSecClients2 where appTypeId=106)
						SET @vmsExist = 1
					IF OBJECT_ID('tempdb.dbo.#WSSecClients2') IS NOT NULL
						DROP TABLE #WSSecClients2
				END
      END
	  ELSE  IF @scope = 5--THIS IS VM PLUGIN REQUEST AND NO NEED TO CHECK FOR OWNERSHIP OR SECURITY HERE
      BEGIN
		SET @vmsExist = 1
		INSERT INTO #clientList(cId,clientName,hostName,appId,vCid, clientStatus)                                      -- Scope 1, 4, ?
		SELECT c.Id, c.displayName, c.net_hostname, 106, c.Id,c.status
		FROM APP_Client c
		INNER JOIN App_ClientProp prop ON prop.componentNameId = c.id
		WHERE attrName = 'Virtual Server Discovered Clients' AND prop.modified = 0 AND prop.attrVal='1' AND c.id = @clientId
	END
 -- FILL IN MISSING COLUMNS OF CLIENT TABLE
	--Exclude psuedo client which are created for solr cloud & content analyzer cloud
	--from analytics report, my data section
	--these are dummy clients which does not needs be shown in the webconsole page
	DELETE T
	FROM #clientList T
	WHERE dbo.IsDistributedPseudoClient(T.cId) =1
	--delete pseudoclients created by data source
	IF EXISTS (SELECT TOP 1 1 FROM GXGlobalParam (NOLOCK) WHERE NAME ='HideDataSourcePseudoClient' AND VALUE ='1')
	BEGIN
		DELETE T
		FROM #clientList T
		JOIN SEDataSource S (NOLOCK) ON T.clientName =  S.dataSourceName + '_' + CAST (dataSourceId AS NVARCHAR(100))
		DELETE T
		FROM #clientList T
		JOIN 	(
					SELECT CONVERT(INT, attrVal) ClientId
					FROM APP_ClientProp(NOLOCK)
					WHERE attrName = 'Indexing datasource id' AND modified = 0
					UNION
					SELECT CONVERT(INT, attrVal) ClientId
					FROM APP_SubClientProp (NOLOCK)
					WHERE attrName = 'Indexing datasource id' AND modified = 0
					UNION
					SELECT CONVERT(INT, attrVal)
					FROM APP_BackupSetProp (NOLOCK)
					WHERE attrName = 'Indexing datasource id' AND modified = 0
				 ) temp ON T.cId = temp.ClientId
	END
     	--Delete the duplicate instances, this is done as Hadoop IDA will return multiple instances
  DELETE A
 FROM #clientList A
 LEFT JOIN (SELECT MIN(instId) as instanceId FROM #clientList B group by cId, appId) tokeep
 ON A.instId = tokeep.instanceId
 WHERE tokeep.instanceId is null;
 -- FILL IN MISSING COLUMNS OF CLIENT TABLE
      -- FILL IN MISSING COLUMNS OF CLIENT TABLE
-- User Centric Client and Plan Details
UPDATE #clientList
SET planId = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_ClientProp WHERE modified = 0 AND componentNameId = cId AND attrName='Associated Plan' ), 0),
isUserCentricClient = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_ClientProp WHERE modified = 0 AND componentNameId = cId AND attrName='User Centric Client' ), 0),
physicalClientID = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_ClientProp WHERE modified = 0 AND componentNameId = cId AND attrName='Physical Client Id' ), cId),
		isClientDeconfigured = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_ClientProp WHERE componentNameId = cId AND attrName='PlatformDeleted 4' ), NULL)
UPDATE #clientList
		SET planName = ISNULL((SELECT name FROM APP_Plan WHERE id=planId), '')
IF @clientListType = 1	-- User Only Want Physical Client  - App.x - enum ClientListType
BEGIN
		DELETE #clientList WHERE isUserCentricClient <> 0		-- Physical client don't have UserCentric Client Value Set in App_clientProp
END
ELSE IF  @clientListType = 2 -- User Only Want User Centric Client  - App.x - enum ClientListType
BEGIN
		DELETE #clientList WHERE isUserCentricClient = 0		-- User Centric client have UserCentric Client Value Set in App_clientProp
END
ELSE IF  @clientListType = 3 -- Only Unique Client - Remove all clientId which are present as Physical Client Id's in user centric client
BEGIN
		DELETE #clientList WHERE cId in (select cl.physicalClientID from #clientList cl where cl.isUserCentricClient <> 0)		-- Delete all physical clients for which there is atleaset 1 user centric client
END
	-------------------------
	-- Update FLA flag.
	-------------------------
	UPDATE #clientList
	SET isFLA = 1
	FROM #clientList cl1
	WHERE EXISTS(
		SELECT fla.archFileId FROM
		archFLAIndexingInfo FLA WITH (NOLOCK) ,
		ARCHFILE AF WITH (NOLOCK),
		APP_Application APP WITH (NOLOCK)
		WHERE AF.Id = FLA.archFileId AND AF.commCellId = FLA.commCellId AND ((FLA.flags & 64) >0)
		AND APP.ID=AF.appId  AND AF.archGroupId = APP.dataArchGrpID
		and cl1.CID = app.clientId
		AND cl1.APPID= APP.appTypeId)
-----------------------------------------------
--- Summary                              ---
-----------------------------------------------
IF(@getVMs = 1 AND @vmsExist = 1)--For VM
BEGIN
UPDATE #clientList
		SET
		vmJobId = T.JobId
		FROM ( SELECT max(bkpStats.jobId) as JobId,  vmProp.VMclientId  as vmid  FROM #clientList vmList
		INNER JOIN	JMBkpStats bkpStats WITH (NOLOCK)
ON appType = 106 AND bkpStats.status in ( 1,3,14)
		INNER JOIN APP_VMProp vmProp WITH (NOLOCK)
		ON vmProp.jobId = bkpStats.jobId
		AND vmProp.VMclientId = vmList.cId
		AND vmProp.attrName = 'vmStatus'
		AND (vmProp.attrVal ='0' OR vmProp.attrVal ='3')
AND vmList.appId = 106
		group by vmProp.VMclientId  ) T
where  cId = T.vmid and appId = 106
UPDATE #clientList
		SET subId = T.subclientId,
		bSet = T.backupsetId,
		instId = T.instanceId
		FROM ( SELECT bkpSet.id as backupsetId ,
		app.id as subclientId, instance.id as instanceId,vmList.cId as clientId  FROM #clientList vmList
		INNER JOIN	JMBkpStats bkpStats WITH (NOLOCK)
		ON  bkpStats.jobId = vmList.vmJobId
AND vmList.appId = 106
		INNER JOIN  APP_Application app WITH (NOLOCK)
		ON app.id = bkpStats.appId
		INNER JOIN APP_BackupSetName bkpSet WITH (NOLOCK)
		ON bkpSet.id = app.backupSet
		INNER JOIN APP_InstanceName instance WITH (NOLOCK)
		ON instance.id = app.instance) T
		where T.clientId = cid
and appId =106
		INSERT INTO @vmEntity
		SELECT vCid,cp.attrVal, name,C.net_hostname, NULL,displayName ,  dbo.MapVSVendorId(cast(i.attrVal as int),-1)
		FROM APP_Client C INNER JOIN #clientList cl ON cl.vCid = c.id
		LEFT JOIN APP_ClientProp cp on cp.componentNameId=cl.vCid and attrName ='Virtual Machine Instance UUID' AND CP.modified=0
			 AND
		((SELECT attrVal FROM APP_InstanceProp WHERE attrName='Use VM Instance GUID' and componentNameId = CL.instId AND modified=0) = 1)
		LEFT JOIN APP_InstanceProp i ON i.attrName='Virtual Server Instance Type' and i.componentNameId=cl.instId and i.modified=0
		UPDATE @vmEntity SET vmGUID=
		 CP.attrVal
		FROM APP_ClientProp CP
		WHERE  CP.componentNameId = vCid AND (attrName ='Virtual Machine Instance UUID' OR attrName ='Virtual Machine GUID')
		AND modified=0 AND vmGUID IS NULL
		--Get top 1 client from a list
		INSERT INTO @proxyEntities
		SELECT distinct i.componentNameId, cast(i.attrVal as xml) .value(('(/App_MemberServers/memberServers/client/@clientId)[1]'), 'int') ,cast(i.attrVal as xml) .value(('(/App_MemberServers/memberServers/client/@clientName)[1]'), 'nvarchar(1024)')
		FROM APP_InstanceProp i
		INNER JOIN #clientList cl on cl.instId = i.componentNameId and modified = 0 AND attrName = 'Vs Member Servers'
		AND cast(i.attrVal as xml) .value(('(/App_MemberServers/memberServers/client/@clientId)[1]'), 'int')  is not null
		--Get top 1 clients for a top 1 clientgroup
		INSERT INTO @proxyEntities
		SELECT TOP 1 cl.instId, cg.clientId,c.name
		FROM APP_InstanceProp i
		INNER JOIN #clientList cl on cl.instId = i.componentNameId and modified = 0 AND attrName = 'Vs Member Servers'
		INNER JOIN APP_ClientGroupAssoc cg on cast(i.attrVal as xml) .value(('(/App_MemberServers/memberServers/client/@clientGroupId)[1]'), 'int')  = cg.clientGroupId
		INNER JOIN APP_Client c on c.id=cg.clientId
		LEFT JOIN @proxyEntities pe ON pe.clientId = cl.cId
		WHERE pe.clientId IS NULL
		UPDATE  @vmEntity SET vmDirDelim = ida.dirDelim FROM APP_iDAType ida
		INNER JOIN APP_Application app ON app.appTypeId = ida.type
		WHERE app.clientId=vcid AND dirDelim <> 'Invalid Property'
		--If no package was installed need to check for simOperatingSystem
		UPDATE  @vmEntity SET vmDirDelim =
		CASE WHEN S.type != 'Windows' THEN '/' else '\' END FROM APP_CLIENT C
		INNER JOIN simOperatingSystem S ON S.ID=C.simOperatingSystemId
		WHERE C.id=vcid AND vmDirDelim IS NULL
END
IF @getEndUserClient != 1
	DELETE #clientList WHERE subId = 0
UPDATE #clientList
    SET cId = ISNULL((Select clientId FROM APP_Application where id = subId), 0)
WHERE clientStatus & 0x10000000 = 0 -- Not for edge clients
IF (@getVMs = 1 AND @vmsExist = 1)
BEGIN
	UPDATE #clientList
			SET lastSuccessBkupTime = ISNULL((select CAST(vmProp.attrVal as BIGINT) from APP_VMProp vmProp
												WHERE vmProp.vmClientId = vCid
												AND vmProp.jobId = vmJobId
												AND vmProp.attrName = 'vmBackupEndTime'
), -1) 	where appId  = 106 -- Synth full job will update this property. We still want to return this VM.
	UPDATE #clientList
			SET lastbkupTime = ISNULL((select CAST(vmProp.attrVal as BIGINT) from APP_VMProp vmProp
												WHERE vmProp.vmClientId = vCid
												AND vmProp.jobId = vmJobId
AND vmProp.attrName = 'vmBackupEndTime'), 0)	where appId  = 106
		UPDATE #clientList
			SET backupSize = ISNULL((select CAST(vmProp.attrVal as BIGINT) from APP_VMProp vmProp
												WHERE vmProp.vmClientId = vCid
												AND vmProp.jobId = vmJobId
												AND vmProp.attrName = 'vmUsedSpace'
), 0) 	where appId  = 106
		UPDATE #clientList
			SET totalbackupsize = ISNULL((select CAST(vmProp.attrVal as BIGINT) from APP_VMProp vmProp
												WHERE vmProp.vmClientId = vCid
												AND vmProp.jobId = vmJobId
												AND vmProp.attrName = 'vmSize'
), 0) 	where appId  = 106
	IF @getEndUserClient != 1
DELETE #clientList WHERE lastSuccessBkupTime = -1 and appId =106
	END
	UPDATE CT
	SET CT.lastDataProtectedTime = ISNULL(CAST(ASCP.attrval AS INT), 0),
	CT.backupSize = ISNULL(CAST(ASCP1.attrval AS BIGINT), 0),
	CT.totalbackupSizeSubClient =  ISNULL(CAST(ASCP2.attrval AS BIGINT), 0),
	CT.totalbackupSizeBackupset = ISNULL(CAST(ABP.attrval AS BIGINT), 0)
	FROM #clientList CT
	LEFT OUTER JOIN APP_SubClientProp ASCP
				ON ASCP.componentNameId=CT.subid AND ASCP.attrname='Last Data Protected Time' AND ASCP.modified=0  AND ASCP.modified=0 AND ASCP.cs_attrName = CHECKSUM(N'Last Data Protected Time')
             LEFT OUTER JOIN APP_SubClientProp ASCP1
                 ON ASCP1.componentNameId=CT.subid AND ASCP1.attrname='Last Backup Size' AND ASCP1.modified=0 AND ASCP1.cs_attrName = CHECKSUM(N'Last Backup Size')
             LEFT OUTER JOIN APP_SubClientProp ASCP2
                 ON ASCP2.componentNameId=CT.subid AND ASCP2.attrname='Application Size' AND ASCP2.modified=0 AND ASCP2.cs_attrName = CHECKSUM(N'Application Size')
             LEFT OUTER JOIN APP_BackupSetProp ABP
                 ON ABP.componentNameId=ct.bSet AND ABP.attrname='Application Size' AND ABP.modified=0
WHERE CT.appId <>  106 AND CT.clientStatus & 0x10000000 = 0
UPDATE #clientList SET totalbackupsize = totalbackupSizeSubClient + totalbackupSizeBackupset WHERE lastDataProtectedTime > 0
		UPDATE #clientList
			SET lastOnlineTime = ISNULL(T.maxlastOnlineTime, 0),
			lastOfflineTime = ISNULL(T.maxlastOfflineTime, 0)
			FROM
			(
				SELECT MAX(CC.lastOfflineTime) maxlastOfflineTime,
				MAX(CC.lastOnlineTime) maxlastOnlineTime,
				CC.ToClientId
				FROM CCRClientToClient CC
				JOIN #clientList CL ON CC.ToClientId = CL.physicalClientID AND FromClientId = 2
				GROUP BY CC.ToClientId
			) T
			WHERE physicalClientID = T.ToClientId
	--1. First start with the next runtime populated by the client.
	--2. From the list of schedules, use the next runtime from the client for the OSC schedules that are enabled.
	--   And use the nextRuntime value for the time schedules.  Then get the MIN of those times as the next backup time.
	--3. If there are no schedules for the client set the value back to 0
	--4. For after job complete schedule set value to -1 since next run time will not get populated anywhere
    --Step 1.
	UPDATE #clientList
            SET nextBkupTime = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_ClientProp
                                                      WHERE componentNameId=cId AND attrName='Next Run Time In'
													 AND modified=0 AND ISNUMERIC(attrVal) = 1
                                                      ), nextBkupTime)
    --Step 2.
	INSERT INTO #runTimeInfo
	(subTaskId, subclientId, frequencyType, nextBackupTime)
		SELECT
		stId,
		u.subId,
		fqType,
		u.nextBkupTime
	FROM #clientList AS cl
	INNER JOIN
		(SELECT
			T.subId AS subId, T.subTaskId AS stId, T.freq_type AS fqType,
			ROW_NUMBER() OVER (PARTITION BY T.subId ORDER BY T.nextBkupTime) AS nextTimeNum, MIN(T.nextBkupTime) AS nextBkupTime
			FROM
			(SELECT
				cl.subId,
CASE WHEN p.freq_type = 1024	--Automatic_Schedule
					AND t.disabled = 0					-- Make sure we only pick schedules that are enabled
					THEN CASE WHEN cl.nextBkupTime > 0 AND  cl.nextBkupTime > @nowUTCTimeUnix	-- And a next runtime that is in the future
						THEN cl.nextBkupTime			-- Use time set by client
						ELSE -1							-- Pseudo clients will not have entry in property table
						END
				ELSE rt.nextTime						-- Use time set by scheduler
				END AS nextBkupTime,
				st.subTaskId,
				p.freq_type
				FROM #clientList cl
				INNER JOIN TM_AssocEntity ae ON
					--CHECK USER HAVING ASSOCIATION FOR THE ENTITY
					(ae.subclientId = cl.subId)
					OR (ae.clientId = cl.cId AND ae.apptypeId = cl.appId AND ae.instanceId = cl.instId  AND ae.backupsetId = cl.bSet AND ae.subclientId = 0)
					OR (ae.clientId = cl.cId AND ae.apptypeId = cl.appId AND ae.instanceId = cl.instId AND ae.backupsetId = 0 AND ae.subclientId = 0)
					OR (ae.clientId = cl.cId AND ae.apptypeId = cl.appId AND ae.instanceId = 0 AND ae.backupsetId = 0 AND ae.subclientId = 0)
					OR (ae.clientId = cl.cId AND ae.apptypeId = 0 AND ae.instanceId = 0 AND ae.backupsetId = 0 AND ae.subclientId = 0)
					OR (ae.clientGroupId in (select clientGroupId FROM APP_ClientGroupAssoc WHERE clientId = cl.cId) and ae.clientId = 0 AND ae.apptypeId = 0 AND ae.instanceId = 0 AND ae.backupsetId = 0 AND ae.subclientId = 0)
				INNER JOIN TM_Task t ON
					t.taskId = ae.taskId AND t.disabled = 0
				INNER JOIN TM_SubTask st ON
					ae.taskId = st.taskId
				INNER JOIN TM_SubTaskOptions sto ON
					sto.subTaskId = st.subTaskId
					AND sto.optionId = 458405394
					AND sto.value IN (1, 2)
				INNER JOIN TM_PatternAssoc pa ON
					pa.subTaskId = st.subTaskId
				JOIN TM_Pattern p ON
					p.patternId = pa.patternId
				LEFT OUTER JOIN TM_RunTime rt ON
					rt.patternId = pa.patternId
					AND rt.processed = 0
			) T
			GROUP BY T.subId, T.subTaskId, T.freq_type, T.nextBkupTime
		) AS u ON u.subId = cl.subId
	--FIX FOR SUBCLIENTS WITH MULTIPLE SCHEDULES
	UPDATE cl
		SET nextBkupTime = RT.nextTime,
		subTaskId = ST.subTaskId,
		freq_type = ST.frequencyType
	FROM #clientList AS cl
	JOIN
	(
		SELECT ROW_NUMBER() OVER (PARTITION BY T.subclientId ORDER BY T.nextBackupTime) AS rowNum, MIN(nextBackupTime) nextTime, subclientId
		FROM #runTimeInfo T
		GROUP BY subclientId, nextBackupTime
	) RT ON RT.subclientId = cl.subId AND RT.rowNum = 1
	JOIN #runTimeInfo ST ON ST.subclientId = RT.subclientId AND ST.nextBackupTime = RT.nextTime
/*
            UPDATE #clientList
                  SET nextBkupTime = ISNULL((select min(nextTime) from TM_RunTime WITH (NOLOCK) where patternId in (
                                          select patternId from TM_PatternAssoc WITH (NOLOCK) where subTaskId in (
select st.subTaskId from TM_SubTask st WITH (NOLOCK) INNER JOIN TM_SubTaskOptions sto ON sto.subTaskId = st.subTaskId AND sto.optionId = 458405394 AND sto.value IN (1, 2)  where taskId in (
                                                      select taskId from TM_AssocEntity WITH (NOLOCK) where
                                                      --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
						(dbo.TM_AssocEntity.subclientId = subId)
						OR
						(TM_AssocEntity.backupsetId = bSet AND dbo.TM_AssocEntity.subclientId =0 )
						OR
						(TM_AssocEntity.instanceId = instId AND dbo.TM_AssocEntity.backupsetId =0 AND dbo.TM_AssocEntity.subclientId =0)
						OR
						(TM_AssocEntity.apptypeId = appId AND TM_AssocEntity.instanceId = 0 AND dbo.TM_AssocEntity.backupsetId =0 AND dbo.TM_AssocEntity.subclientId =0)
                         OR
						(TM_AssocEntity.clientId = cId AND TM_AssocEntity.apptypeId = 0 AND TM_AssocEntity.instanceId = 0 AND dbo.TM_AssocEntity.backupsetId =0 AND dbo.TM_AssocEntity.subclientId =0)
						 OR
						(TM_AssocEntity.clientGroupId in (select clientGroupId from APP_ClientGroupAssoc where clientId = cId) and   TM_AssocEntity.clientId = 0 AND TM_AssocEntity.apptypeId = 0 AND TM_AssocEntity.instanceId = 0 AND dbo.TM_AssocEntity.backupsetId =0 AND dbo.TM_AssocEntity.subclientId =0)
                                          )and processed=0))), 0) WHERE cId <> 0
*/
    --Step 3.
      UPDATE #clientList
            SET nextBkupTime = 0
			WHERE subTaskId = 0
    --Step 4.
      UPDATE #clientList
            SET nextBkupTime = -1
WHERE freq_type = 4096	--After_Job_Completes
		-- Consider only clients which are laptops and not deleted
		UPDATE #clientList
		SET isSyncAllowed = ISNULL((SELECT TOP 1 1 FROM APP_Client WITH (NOLOCK) WHERE id = cId AND (status & 4096 = 4096) AND (status & @excludeStatusMaskForSync = 0 ) ),0)
		UPDATE #clientList
		SET isSyncUserProfilePresent = ISNULL((SELECT TOP 1 1 FROM UMClientUserMap WHERE clientId = cId AND umUserId = @userId),0)
		UPDATE #clientList
		SET isLockedClient = ISNULL((
SELECT CASE attrVal WHEN 'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a' THEN 1
												ELSE 0
												END
											FROM APP_CLIENTPROP
											WHERE componentNameId = cId
AND attrName = '7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807' AND modified = 0
								),0)
		UPDATE #clientList
		SET isIndexingV2 = ISNULL((SELECT attrVal FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = cId AND modified=0 AND attrName='IndexingV2'),0)
DECLARE @cvDefaultStatus INT = 0x00008
		UPDATE #clientList
		SET isCloudLaptop  = ISNULL(CAST(cloudAPP.attrVal AS INT), 0)
		FROM  #clientList CL
		INNER JOIN APP_Application AAP ON CL.cId = AAP.clientId
		INNER JOIN APP_BackupSetName B ON AAP.backupSet = B.id
		LEFT OUTER JOIN APP_SubClientProp cloudAPP ON
cloudAPP.componentNameId = AAP.id AND cloudAPP.modified = 0 AND cloudAPP.attrName = 'Cloud Mode Enabled' AND cloudAPP.cs_attrName = CHECKSUM(N'Cloud Mode Enabled')
		WHERE (B.status & @cvDefaultStatus) <> 0
		AND    B.id = AAP.backupset
		AND    (AAP.subclientStatus & @cvDefaultStatus) = @cvDefaultStatus
		AND AAP.clientId = CL.cId
--
		UPDATE #clientList
		SET cloudId = ISNULL((SELECT     CASE WHEN CHARINDEX('SOLR',cp.stringVal) = 0
											  THEN -1
											  ELSE ISNULL(archContentIndexingRules.cloudId, 0)
										  END
							  FROM         APP_Application WITH (NOLOCK)
INNER JOIN    archContentIndexingRules  WITH (NOLOCK) ON archContentIndexingRules.archGroupId = APP_Application.dataArchGrpID  AND archContentIndexingRules.operationType = 1
											AND APP_Application.clientId = cId AND APP_Application.subclientStatus & @cvDefaultStatus > 0 AND APP_Application.appTypeId = appId AND APP_Application.instance = instId
							  INNER JOIN	APP_BackupSetName WITH (NOLOCK) ON APP_BackupSetName.id = APP_Application.backupset AND APP_BackupSetName.status & @cvDefaultStatus > 0
							  INNER JOIN APP_ComponentProp cp WITH (NOLOCK) ON  cp.componentId = archContentIndexingRules.cloudId AND cp.modified = 0 AND propertyTypeId = 1014 -- CV_COMPONENT_CI_ENGINE_VERSION_PROP
                      ),0)
WHERE clientStatus & 0x10000000 = 0
--
		IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
		CREATE TABLE #getIndexServers
				(     serverURL NVARCHAR(512),
					  clientId INT,
					  clientName NVARCHAR(256),
					  cloudId INT,
					  hostName NVARCHAR(256),
					  basePort INT,
					  engineName  NVARCHAR(256),
					  serverType INT,
					  indexServerClientId INT,
					  internalCloudName NVARCHAR(256)
				)
		exec DM2GetIndexServers 'EDGE Drive'
		UPDATE #clientList
		SET cloudId = ISNULL((SELECT TOP 1 DM.CloudId
							  FROM #getIndexServers DM
							  WHERE DM.indexServerClientId IN (SELECT entityId
													FROM App_EdgeDriveAssociation AE
													WHERE AE.clientId = cId AND AE.entityType = 3
													) -- MediaAgent
							  ),0)
WHERE clientStatus & 0x10000000 > 0
		IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
--
		INSERT INTO @syncFolderInfo
		SELECT syncWebFolderId, syncWebFolderName
		FROM App_SyncCloudFolder
WHERE ownerId = @userId AND flag & 0x10 <> 0
		UPDATE #clientList SET hasEdgeDriveEnabledLaptop = 1
WHERE clientStatus & 0x10000000 > 0
	                AND
	                EXISTS(
	                                SELECT 1 FROM App_SyncCloudConfig CF
	                                JOIN @syncFolderInfo SF ON SF.syncFolderId = CF.syncWebFolderId
	                                        AND CF.syncType & 3 = 3
	                                        --AND CF.clientId = #clientList.cId
	                                JOIN APP_Client C ON C.id = CF.clientId AND C.releaseId >= 16
	                                WHERE CF.syncWebFolderId = SF.syncFolderId
	                                AND
	                                EXISTS(SELECT 1 FROM simInstalledPackages P WHERE P.ClientId = C.id AND C.releaseId > 16 OR (C.releaseId = 16 AND P.HighestSP >= 4))    --ALL CLIENTS ARE AT 11.0 SP5 OR LARGER
	                        )
		UPDATE #clientList SET hasSyncBlackListedLaptop = 1
WHERE clientStatus & 0x10000000 > 0
	                AND
	                EXISTS(
								SELECT 1 FROM App_SyncCloudConfig CF
	                            INNER JOIN @syncFolderInfo SF ON SF.syncFolderId = CF.syncWebFolderId
AND CF.syncType & 3 = 3 AND CF.FLAG & 0x20 = 0x20
	                        )
/*
		IF NOT EXISTS(SELECT 1 FROM @syncFolderInfo)
		BEGIN
			INSERT INTO @syncFolderInfo
			SELECT CAST(value AS XML).value('data(/syncInfos/syncWebFolder/@syncWebFolderId)[1]', 'INT'), CAST(value AS XML).value('data(/syncInfos/syncWebFolder/@syncWebFolderName)[1]', 'NVARCHAR(MAX)')
			FROM GXGlobalParam
			WHERE name = 'Sync Folder Template'
			AND CAST(value AS XML).value('data(/syncInfos/syncWebFolder/@syncWebFolderId)[1]', 'INT') = -3
		END
*/
      UPDATE #clientList
            SET vCid = cId
            FROM #clientList
            WHERE vCid = 0
    --Conditions to get capabilities
	--1) For client that are not VM get the capabilities of a client.
	--2) For request from webconsole, return the capabilities of a VM
	--3) For request from vcenter plugin, return the capabilities of a proxy(When @scope = 5)
	--4) For Edge Client, read the capabilities from UMUserCredentials
	DECLARE @clientCaps Table (clientId INT PRIMARY KEY, caps BIGINT)
	INSERT INTO @clientCaps
	SELECT  sec.clientId, SUM(distinct t2.Value) Total
		FROM #tempLaptopSecurityObjects sec
		INNER JOIN #clientList ON #clientList.cId = sec.clientId
		CROSS APPLY
			bitWiseOrV1(sec.capabilities) t2
WHERE clientStatus & 0x10000000 = 0
		GROUP BY sec.clientId
	IF(@getVMs = 1 AND @vmsExist = 1)
	BEGIN
			--Delete all the VMs frist so we have capabilities for vcenter only
			DELETE caps
			FROM @clientCaps caps
INNER JOIN  #clientList c ON caps.clientid=c.cid AND c.appId= 106
			Merge @clientCaps target using
			(SELECT  c.vCid as cid , SUM(distinct t2.Value) as Total
			FROM #tempLaptopSecurityObjects sec
INNER JOIN #clientList C ON (sec.clientId = vCid AND appId =  106)
				CROSS APPLY
				bitWiseOrV1(sec.capabilities) t2
			GROUP BY c.vCid) as source
			ON target.clientId = source.cid
			WHEN NOT MATCHED THEN
			INSERT (clientId, caps) values(cid, Total);
	END
	UPDATE C
    SET capabilities = @CCLevelSec | ISNULL(sec.caps,0)
	FROM #clientList C
	LEFT JOIN @clientCaps sec ON
	(sec.clientId = C.cId OR sec.clientId = vCid)
WHERE clientStatus & 0x10000000 = 0
    --Edge drive capabilities
	UPDATE #clientList
	SET capabilities = ISNULL(@CCLevelSec,0) |  ISNULL((SELECT TOP 1 capabilities FROM #tempLaptopSecurityObjects WHERE subClientId = subId),0)
WHERE clientStatus & 0x10000000 <> 0
	-------------------------
	--		Get Details
	-------------------------
    if(@getAllProperties = 1)
    BEGIN
		UPDATE #clientList
			SET isArchived = ISNULL((SELECT CAST(attrVal as int) FROM App_ClientProp
                            WHERE modified = 0 AND attrName = 'Is Client Archived'
                                AND componentNameId = vCid), 0)            FROM #clientList
        WHERE  vCid <> 0
		--UPDATE #clientList
		--      set bSet = ISNULL((Select backupSet FROM APP_Application where id = subId), 0)
		UPDATE #clientList
			Set assocBset = ISNULL((Select attrVal from app_backupsetProp where componentNameId = bSet and attrName = @ATTR_NAME AND modified = 0), 0)
		UPDATE #clientList
			Set assocSubC = ISNULL((Select attrVal from app_subClientProp where componentNameId = subId and attrName = @ATTR_NAME AND modified = 0  AND cs_attrName = checksum(@ATTR_NAME)), 0)
		UPDATE #clientList
			Set decoupleSCPcontent =  ISNULL((Select attrVal from app_subClientProp where componentNameId = subId and attrName = @DECOUPLE_SCP_CONTENT_ATTR_NAME AND modified = 0  AND cs_attrName = checksum(@DECOUPLE_SCP_CONTENT_ATTR_NAME)), 0)
		IF (@getcontent = 1)
		BEGIN
			----------------------------------------------------------SCPFilter----------------------------------------------------------------------
			UPDATE #clientList
				SET useSCPfilters = ISNULL((SELECT attrVal
											FROM app_subClientProp
											WHERE componentNameId = subId
												AND attrName = @ATTR_USE_SCP_FILTERS
												AND modified = 0
												AND cs_attrName = checksum(@ATTR_USE_SCP_FILTERS)), 1)
			----------------------------------------------------------GlobalFilter----------------------------------------------------------------------
			DECLARE @useGlobalFilterForAllSubClients INT = 0
			SET @useGlobalFilterForAllSubClients  = ISNULL((SELECT value FROM GXGlobalParam WHERE name = @ATTR_USE_GLOBAL_FILTERS_FOR_SC AND modified = 0), 0)
			DECLARE @useQNetGlobalFilters INT = 0
			SET @useQNetGlobalFilters  = ISNULL((SELECT value FROM GXGlobalParam WHERE name = @ATTR_USE_QNET_GLOBAL_FILTERS AND modified = 0), 0)
			DECLARE @WindowsGlobalExcludeFilters TABLE
			(
				value NVARCHAR(MAX)
			)
			DECLARE @UnixGlobalExcludeFilters TABLE
			(
				value NVARCHAR(MAX)
			)
			DECLARE @strWindowsGlobalExcludeFilters NVARCHAR(MAX) = N''
			DECLARE @strUnixGlobalExcludeFilters NVARCHAR(MAX) = N''
			SET @strWindowsGlobalExcludeFilters = ISNULL((select value from GXGlobalParam where modified = 0 and name = @ATTR_WIN_FS_EXCLUDE_FILTERS), N'')
			SET @strUnixGlobalExcludeFilters = ISNULL((select value from GXGlobalParam where modified = 0 and name = @ATTR_UNIX_FS_EXCLUDE_FILTERS), N'')
			INSERT @WindowsGlobalExcludeFilters
				SELECT Data FROM SplitString(@strWindowsGlobalExcludeFilters, N' ')  where Data != N''
			INSERT @UnixGlobalExcludeFilters
				SELECT Data FROM SplitString(@strUnixGlobalExcludeFilters, N' ')  where Data != N''
			DECLARE @strQNetWindowsGlobalExcludeFilters NVARCHAR(MAX) = N''
			DECLARE @strQNetUnixGlobalExcludeFilters NVARCHAR(MAX) = N''
			IF (@useQNetGlobalFilters = 1)
			BEGIN
				SET @strQNetWindowsGlobalExcludeFilters = ISNULL((select value from GXGlobalParam where modified = 0 and name = @QNET_GLOBAL_FILTER_PREFIX + @ATTR_WIN_FS_EXCLUDE_FILTERS), N'')
				SET @strQNetUnixGlobalExcludeFilters = ISNULL((select value from GXGlobalParam where modified = 0 and name = @QNET_GLOBAL_FILTER_PREFIX + @ATTR_UNIX_FS_EXCLUDE_FILTERS), N'')
				INSERT @WindowsGlobalExcludeFilters
					SELECT Data FROM SplitString(@strQNetWindowsGlobalExcludeFilters, N' ')  where Data != N''
				INSERT @UnixGlobalExcludeFilters
					SELECT Data FROM SplitString(@strQNetUnixGlobalExcludeFilters, N' ')  where Data != N''
			END
			UPDATE #clientList
			SET useGlobalFilter = ISNULL((SELECT attrVal
											FROM app_subClientProp
											WHERE ((assocSubC = 0 AND componentNameId = subId) OR (assocSubC <> 0 AND componentNameId = assocSubC))
												AND attrName = @ATTR_USE_CS_SETTING_FOR_GF
												AND modified = 0
												AND cs_attrName = checksum(@ATTR_USE_CS_SETTING_FOR_GF)), 1)
			UPDATE #clientList
				SET useGlobalFilter = @useGlobalFilterForAllSubClients
			where useGlobalFilter = 1
			UPDATE #clientList
				SET useGlobalFilter = ISNULL((SELECT attrVal
												FROM app_subClientProp
												WHERE ((assocSubC = 0 AND componentNameId = subId) OR (assocSubC <> 0 AND componentNameId = assocSubC))
													AND attrName = @ATTR_USE_GLOBAL_FILTERS
													AND modified = 0
													AND cs_attrName = checksum(@ATTR_USE_GLOBAL_FILTERS)), @useGlobalFilterForAllSubClients)
			where useGlobalFilter = 0
			--------------------------------------------------------------------------------------------------------------------------------------------------------------
		END -- End of filtering
-----------------------------------------GeoLocatoin----------------------------------------------------------------------------------------------------------
		DECLARE @globalGeoLocatoinDisplayMode   INT
		SET @globalGeoLocatoinDisplayMode = ISNULL((SELECT TOP 1 value FROM GXGlobalParam WHERE modified = 0  AND name = @ATTR_GEO_LOCATION_DISPLAY_MODE), @defaultGeoLocatoinDisplayMode);
SET @isGeolocationDisabledForCompany = ISNULL((SELECT 1 FROM APP_CompanyProp where componentNameID=@userCompanyId AND attrname='Geo Location Display Mode' AND modified=0 AND attrval='0' AND cs_attrName=checksum('Geo Location Display Mode')), 0)
		IF @isGeolocationDisabledForCompany = 0
		BEGIN
			IF (@globalGeoLocatoinDisplayMode IS NULL OR @globalGeoLocatoinDisplayMode < 0 OR @globalGeoLocatoinDisplayMode > 2)
				SET @globalGeoLocatoinDisplayMode = @defaultGeoLocatoinDisplayMode
			UPDATE T1
              SET T1.geoLocationDisplayMode= CASE WHEN T1.isUserCentricClient=1 THEN  ISNULL(ACP2.attrVal, @globalGeoLocatoinDisplayMode)
                                                ELSE ISNULL(ACP4.attrVal, @globalGeoLocatoinDisplayMode) END,
                T1.lastGeoLocation= CASE WHEN T1.isUserCentricClient=1 THEN  REPLACE(ACP1.attrVal, N'App_GeoLocation', 'lastGeoLocation')
                                        ELSE  REPLACE(ACP3.attrVal, N'App_GeoLocation', 'lastGeoLocation') END,
              T1.lastGeoLocationTime= CASE WHEN T1.isUserCentricClient=1 THEN ISNULL(ACP1.created, 0)
                                      ELSE ISNULL(ACP1.created, 0) END
          FROM #clientList T1
           LEFT OUTER JOIN APP_ClientProp ACP1 ON
				((ACP1.componentNameId=T1.physicalClientID AND T1.isUserCentricClient=1)) AND ACP1.attrName = @ATTR_CLIENT_GEO_LOCATION
                     AND ACP1.modified = 0 AND  ACP1.attrVal LIKE '<App_GeoLocation%status_code=''SUCCESS''%'
			LEFT OUTER JOIN APP_ClientProp ACP3 ON
				((ACP3.componentNameId=T1.cId AND T1.isUserCentricClient=0)) AND ACP3.attrName = @ATTR_CLIENT_GEO_LOCATION AND ACP3.modified = 0 AND  ACP3.attrVal LIKE '<App_GeoLocation%status_code=''SUCCESS''%'
           LEFT OUTER JOIN APP_ClientProp ACP2 ON
				((ACP2.componentNameId=T1.physicalClientID AND T1.isUserCentricClient=1)) AND ACP2.attrName = @ATTR_GEO_LOCATION_DISPLAY_MODE AND ACP2.modified = 0
           LEFT OUTER JOIN APP_ClientProp ACP4 ON
				((ACP4.componentNameId=T1.cId AND T1.isUserCentricClient=0)) AND ACP4.attrName = @ATTR_GEO_LOCATION_DISPLAY_MODE AND ACP4.modified = 0
		END
--------------------------------------------------------------------------------------------------------------------------------------------------------------
      DROP TABLE #tempLaptopSecurityObjects
      INSERT INTO @assocSubClient
      SELECT a.id, clientId,  a.appTypeId , instId , assocBset , subId
      FROM APP_Application a
      INNER JOIN #clientList cl on cl.assocSubC = a.id
      UPDATE #clientList
      SET contentIndexingEnabled =
      ISNULL((select top 1 CAST(attrVal AS INT) From APP_ClientProp where attrName = 'Content Indexing Enabled' and modified = 0 and componentNameId = cId),0)
--    select debug='Tbld clientList', * from #clientList
      IF (@getSchedules = 1)
      BEGIN
            INSERT INTO #taskInfo
            SELECT DISTINCT ST.taskId, TK.taskName, ST.subTaskId, ST.subTaskName, CL.cId, PT.patternId, '', US.id, US.login,taskType
            FROM #clientList AS CL
            INNER JOIN TM_AssocEntity TA ON TA.subclientId = CL.subId OR TA.clientId = 0 OR (TA.clientId=CL.cId AND TA.subclientId=0)
            LEFT OUTER JOIN APP_ClientGroupAssoc CA ON CA.clientId = CL.cId
            INNER JOIN TM_Task TK WITH (NOLOCK) ON TK.taskId = TA.taskId
            INNER JOIN TM_SubTask ST WITH (NOLOCK) ON ST.taskId = TA.taskId
            INNER JOIN TM_PatternAssoc PA WITH (NOLOCK) ON PA.subTaskId = ST.subTaskId
INNER JOIN TM_SubTaskOptions STP WITH (NOLOCK) ON PA.subTaskId = STP.subTaskId AND optionId = 458405394 AND STP.value IN (1, 2)
            INNER JOIN TM_Pattern PT WITH (NOLOCK) ON PT.patternId = PA.patternId
            INNER JOIN UMUsers US WITH (NOLOCK) ON US.id = TK.ownerId
            WHERE (TA.clientId = CL.cId OR (TA.clientId = 0 AND TA.clientGroupId = CA.clientGroupId))
AND ST.subTaskType = 2        --ONLY BACKUP SCHEDULES
			AND TK.disabled = 0 AND TK.deleted = 0 AND TK.uninstalled = 0 -- Only Valid enabled Schedules
AND TK.taskType in (4, 2)
            AND (PT.freq_type&4=4 OR PT.freq_type&8=8 OR PT.freq_type&1024=1024)    --ONLY RETURN DAILY, WEEKLY AND AUTOMATIC SCHEDULES
            AND (CL.flag & 1) = 0 and CL.cId <> 0 --VM CLIENT THAT ARE NOT PART OF ANY SUBCLIENT
			--Removing associations which have been excluded, no need of adding Client Group check as client id check would take care of this
			DELETE TI
			FROM #taskInfo TI
			INNER JOIN TM_AssocEntity TE ON TE.taskId = TI.taskId
			INNER JOIN #clientList CL ON
			(
				CL.cId = TE.clientId
				AND (TE.subclientId = CL.subId OR TE.subclientId = 0)
				AND (TE.instanceId = CL.instId OR TE.instanceId = 0)
				AND (TE.backupsetId = CL.bSet OR TE.backupsetId = 0)
				AND (TE.apptypeId = CL.appId OR TE.apptypeId = 0)
			)
			WHERE TE.exclude = 1
            DECLARE @patternId int
            DECLARE @patternInfo TABLE (Info nvarchar(1024))
            DECLARE updatePatternCur CURSOR FOR
                  SELECT patternId FROM #taskInfo
            OPEN updatePatternCur
            FETCH NEXT FROM updatePatternCur INTO @patternId
            WHILE @@FETCH_STATUS = 0
            BEGIN
                  DELETE @patternInfo
                  INSERT INTO @patternInfo
                  EXEC GetSchedulePattern @patternId, @localeId, 1
                  UPDATE #taskInfo SET patternInfo = (SELECT TOP 1 Info FROM @patternInfo)
                  WHERE patternId = @patternId
                  FETCH NEXT FROM updatePatternCur INTO @patternId
            END
            CLOSE updatePatternCur
            DEALLOCATE updatePatternCur
      END
      IF(@getContent=1)
      BEGIN
		INSERT INTO @content
		SELECT subId,created,modified,fileName,
		 CASE WHEN (assocSubC <> 0 AND type = 1) THEN 18
                    WHEN (assocSubC <> 0 AND type = 3) THEN 20   -- ADDED TO SUPPORT EXCLUDE FILTERS
                    ELSE  type END as '@valueType'
		 FROM APP_ScFilterFile sff
		INNER JOIN #clientList cl on sff.componentNameId = cl.subId AND modified = 0
		--associated policy client
		INSERT INTO @SCPcontent
		SELECT assocSubC,created,modified,fileName, type
		 FROM APP_ScFilterFile sff
		INNER JOIN #clientList cl on sff.componentNameId = cl.assocSubC AND modified = 0
		AND (type = 1 OR useSCPfilters <> 0)               -- Conditionally return filters (09May2011)
      END
	  ------------------------------------DLPProperties------------------------------------------------------------------------------------------------------
    -- Below sp body is used to fetch dlp properties
BEGIN
	-- The default is to hide DLP unless set in clientgroup or plan.
	-- These checks are added below after considering the code in [https:--cvs.commvault.com/source/xref/11.0-win/vaultcxWeb/src/commvault/web/summary/SummaryHandler.java?a=true&h=1008#1033]
	DECLARE @showDLPFlag int = 0
	DECLARE @planId int = 0
	-- Step1: If there is global registry setting to not show DLP from webconsole, honor it. No need to check at client group/client level
	IF(EXISTS(SELECT 1 FROM GXGlobalParam WHERE name = 'WebconsoleDisableDLP' AND modified = 0 AND value ='1'))
		SET @showDLPFlag = 0
	ELSE
	BEGIN
SET @planId = ISNULL((SELECT CONVERT(int,attrVal) FROM App_ClientProp WITH(NOLOCK) WHERE attrName = 'Associated Plan' AND componentNameId = @clientId AND modified = 0),0)
		-- Step2: If Client has plan and plan has DLP enabled, then
		--				check if atleast one clientgroup belonging to client has "allow owners to enable Data encryption" set to 1. If present then showDLP. Else don't showDLP.
		IF (@planId <> 0 AND
			EXISTS(SELECT  1
			FROM UMPermissions permission INNER JOIN
				 UMRolesPermissions roleToPermissionMap ON roleToPermissionMap.permissionId =  permission.id
WHERE       roleToPermissionMap.roleId = dbo.AppPlanGetEntityValue(@planId, 'Feature',  default)
					AND permission.permissionName = 'DLP')
			)
		BEGIN
			IF (EXISTS(SELECT 1 FROM APP_ComponentProp CP WITH(NOLOCK) JOIN APP_ClientGroupAssoc CGA WITH(NOLOCK)
					ON CP.componentid = CGA.clientGroupId AND CGA.clientId = @clientId
					AND CP.modified = 0
					AND CP.longval = 1 -- Enabled on a group
AND CP.propertytypeid = 3623))
			BEGIN
				SET @showDLPFlag = 1
			END
		END
		-- Step3: If client has NO plan
		IF (@planId = 0)
		BEGIN
			DECLARE @enableDLPClient int = ISNULL((SELECT CONVERT(int, attrVal) FROM APP_ClientProp WITH(NOLOCK) WHERE attrName = 'enableDLP' AND modified = 0 AND componentNameId = @clientId),0)
			-- Step3a: Check if "enableDLP" is set to 1 at client level, then we showDLP - This is to allow exisiting customers who were using
			--			dlp before update continue to see that option in webconsole
			IF @enableDLPClient = 1
			BEGIN
				SET @showDLPFlag = 1
			END
			-- Step3b: If registry "WebconsoleUseClientDLPSettings" is set then reflect value of "enableDLP" in app_clientprop table
ELSE IF EXISTS(SELECT 1 FROM APP_AdvanceSettings WHERE entityId = @clientId AND entityType = 3 AND keyName = N'WebconsoleUseClientDLPSettings'
					AND enabled = 1 AND deleted = 0 AND CONVERT(NVARCHAR(16),value) = N'TRUE')
			BEGIN
				SET @showDLPFlag = @enableDLPClient
			END
			-- Step3c: Check if atleast one clientgroup has "allow owners to enable data encryption" set to true. If yes, then showDLP else no.
			ELSE IF (EXISTS(SELECT 1 FROM APP_ComponentProp CP WITH(NOLOCK) JOIN APP_ClientGroupAssoc CGA WITH(NOLOCK)
					ON CP.componentid = CGA.clientGroupId AND CGA.clientId = @clientId
					AND CP.modified = 0
					AND CP.longval = 1 -- Enabled on a group
AND CP.propertytypeid = 3623)
					)
			BEGIN
				SET @showDLPFlag = 1
			END
		END
	END
	IF(@showDLPFlag = 1)
	BEGIN
		UPDATE #ClientList SET showDLP = 1
		--Need to check for DLP flags.
		DECLARE @IsWebconsoleDisableDLP int = 0
		DECLARE @IsWebconsoleDisableSecureErase int = 0
		SET @IsWebconsoleDisableSecureErase  = ISNULL((SELECT top 1 value FROM GXGlobalParam WHERE name = 'WebconsoleDisableSecureErase' AND modified = 0), 0)
		IF(@IsWebconsoleDisableDLP=0 OR @IsWebconsoleDisableSecureErase=0)
		BEGIN
INSERT INTO @DLPProperties
		SELECT cId, ISNULL(cp.attrVal,0),0,0,0,''
		FROM #clientList cl
		INNER JOIN APP_ClientProp cp on cp.componentNameId=cl.cId and attrName='enableDLP' and modified=0
WHERE appId in (SELECT appTypeId FROM GetAppTypesForAppGroup(22,0))  or appId = 63
UPDATE @DLPProperties
		SET isDLPRMEnabledOnClient = (SELECT ISNULL(attrVal,0) FROM APP_ClientProp WHERE componentNameId=dlpClientId and attrName='enableRmDLP' and modified=0)
UPDATE @DLPProperties
		SET isDLPEnabledOnGroup =
			ISNULL( ( SELECT top 1 1 FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
																											WHERE CGA.clientId = dlpClientId
																												AND CGA.clientGroupId = CG.id )
																										AND attrName = 'enableDLP'
																										AND attrVal = '1' ),0)
UPDATE @DLPProperties
		SET isDLPRMEnabledOnGroup =
			ISNULL( ( SELECT top 1 1 FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
																											WHERE CGA.clientId = dlpClientId
																												AND CGA.clientGroupId = CG.id )
																										AND attrName = 'enableRmDLP'
																										AND attrVal = '1' ),0)
			DECLARE @c_id INT
		DECLARE DLPCur CURSOR FOR
SELECT distinct dlpClientId FROM @DLPProperties WHERE isDLPEnabledOnClient = 1 OR isDLPEnabledOnGroup=1 OR isDLPRMEnabledOnClient=1 or isDLPRMEnabledOnGroup=1
				OPEN DLPCur
				FETCH NEXT FROM DLPCur INTO @c_id
				WHILE @@FETCH_STATUS = 0
				BEGIN
					DECLARE @dlpProp XML
					exec GetDLPPropXML @c_id,@IsWebconsoleDisableDLP,@IsWebconsoleDisableSecureErase, @dlpProp output
UPDATE @DLPProperties set propertiesXML = @dlpProp where dlpClientId= @c_id
					FETCH NEXT FROM DLPCur INTO @c_id
				END
				CLOSE DLPCur
				DEALLOCATE DLPCur
			END
		END
END
--    select debug='Tbld taskInfo', * from #taskInfo
------------------------------------------------------
--    SET THE ENABLE/DISABLE MEMBERS BASED ON THE           --
--  .. XMLENTITIES LIST OF THE APPROPRIATE ALERT:     --
------------------------------------------------------
--    Assumption here is that there is only one laptop alert per alertType!
      DECLARE @alertId int
      DECLARE @entities XML
--  DATA PROTECTION:
      SET @alertId = (select top 1 ID from NTnotificationRule where (status & 128) <> 0 and alertTypeId =3)   -- 'NT_STATUS_LAPTOP_ALERT, NT_ALERTTYPE_DATA_PROT
      SET @entities     = (select xmlentityList from NTnotificationRule where id = @alertId)
      UPDATE #clientList
            SET isDPalertEnabled = 1
                  WHERE subId in (
                              SELECT ref.value('@subclientId', 'integer')
                                    FROM @entities.nodes ('/CVGui_CommCellTreeNode[1]/clients[1]/clients[@subclientId!=0]') R(ref)
                                          )
--  DATA RECOVERY:
      SET @alertId = (select top 1 ID from NTnotificationRule where (status & 128) <> 0 and alertTypeId =4)   -- 'NT_STATUS_LAPTOP_ALERT, NT_ALERTTYPE_DATA_RECOV
      SET @entities     = (select xmlentityList from NTnotificationRule where id = @alertId)
      UPDATE #clientList
            SET isDRalertEnabled = 1
                  WHERE subId in (
                              SELECT ref.value('@subclientId', 'integer')
                                    FROM @entities.nodes ('/CVGui_CommCellTreeNode[1]/clients[1]/clients[@subclientId!=0]') R(ref)
                                          )
--Plan features
	UPDATE #clientList set planPermissions=( SELECT UP.id AS '@permissionId', UP.permissionName AS '@permissionName'
						                     FROM   UMRolesPermissions URP INNER JOIN UMPermissions UP ON URP.permissionId = UP.id
WHERE  URP.roleId = CAST(dbo.AppPlanGetEntityValue(planId, 'Feature', default) AS INT)
						                     FOR XML PATH ('permissions'),TYPE) where planId <> 0
	-- Already Existing Features per Client
   UPDATE #clientList set features = (
		SELECT F.Value AS '@featureType',1 AS '@enable'
		FROM
		dbo.cte_split_inline((SELECT CP.attrVal FROM App_ClientProp CP WHERE CP.componentNameId = cId AND attrName = @constAttrName_Feature),',') F
		WHERE F.Value <> 0
		FOR XML PATH ('features'),TYPE
	)
    -- Populate the privacy settings for given device (Passkey feature)
    DECLARE @authType       integer=1
    DECLARE @enableAuthorizeForRestore integer=0
    DECLARE @expirationTimeStamp integer = 0
IF EXISTS(SELECT 1 FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @clientId AND attrName='AuthorizationType' AND attrVal = '2' AND modified = 0)
    BEGIN
        SET @authType = 2  -- USE_PASSKEY (attrVal = '2')
        DECLARE @authUsers XML = ISNULL((SELECT cast(attrVal as xml) FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId
AND attrName='AuthorizedUsersForRestore' AND modified = 0),'')
        SET @expirationTimeStamp = ISNULL((select T.c.query('..').value('(/authorizedUsers/@expirationTime)[1]','integer') from @authUsers.nodes('/App_AuthorizedUsersForRestore/authorizedUsers/user') AS T(c)
                                        WHERE T.c.value('@userId','int') = @userId),0)
        IF @expirationTimeStamp > dbo.GetUnixTime(GETUTCDATE())
        BEGIN
            SET @enableAuthorizeForRestore = 1
        END
    END
    UPDATE #clientList SET restoreAuthUsersXML = (SELECT @authType AS '@authType',
                                                    (SELECT @enableAuthorizeForRestore as '@enableAuthorizeForRestore',
                                                    (SELECT @expirationTimeStamp as '@time'
                                                        FOR XML PATH('expirationTime'), TYPE)
                                                    FOR XML PATH('passkeySettings'), TYPE)
                                                    FOR XML PATH('advancedPrivacySettings'),TYPE)
        WHERE cId = @clientId
	END
DECLARE @outputXmlStringFS XML
DECLARE @outputXmlStringMB XML
DECLARE @outputXmlStringSP XML
DECLARE @outputXmlStringVM XML
DECLARE @outputXMLString1Drive XML
SET @outputXmlStringFS =
            (SELECT backupSize as '@backupSize', capabilities as '@capabilities', isOwner as '@isOwner', totalbackupsize as '@totalBackupSize', showDLP AS '@showDLP',
                    isArchived as '@isVMArchived', isDRalertEnabled as '@isDRalertEnabled', isDPalertEnabled as '@isDPalertEnabled', isSyncUserProfilePresent as '@isSyncUserProfilePresent',
                    decoupleSCPcontent as '@isDecoupledContent', contentIndexingEnabled as '@contentIndexingEnabled', isSyncAllowed as '@isSyncAllowed', flag as '@subclientStatus', clientStatus as '@clientStatus', (SELECT isDLPEnabledOnClient FROM @DLPProperties WHERE dlpClientId=cl.cid) as '@isDLPEnabledOnClient',(SELECT isDLPRMEnabledOnClient FROM @DLPProperties WHERE dlpClientId=cl.cId) as '@isDLPRMEnabledOnClient',
					isLockedClient as '@isLocked', isIndexingV2 as '@isIndexingV2', cloudId as '@cloudId', isFLA as '@isFLA', isClientDeconfigured as '@isClientDeconfigured', hasEdgeDriveEnabledLaptop '@hasEdgeDriveEnabledLaptop', hasSyncBlackListedLaptop '@hasSyncBlackListedLaptop', isCloudLaptop '@isCloudLaptop',
                                   (select dirDelim  from APP_iDAType where APP_iDAType.type =  cl.appId) as '@dirDelim'
                                    , (CASE WHEN lastGeoLocation IS NULL
												THEN NULL
											WHEN (geoLocationDisplayMode IS NULL OR geoLocationDisplayMode < 0 OR geoLocationDisplayMode > 2)
												THEN @defaultGeoLocatoinDisplayMode
											ELSE
													geoLocationDisplayMode
											END) as '@geoLocationDisplayMode' ,
                  (SELECT lastbkupTime AS '@time', 55 '@_type_' FOR XML PATH ('lastBackupTime'), TYPE),
                  (SELECT lastSuccessBkupTime AS '@time', 55 '@_type_' FOR XML PATH ('lastSuccessBackupTime'), TYPE),
				  (SELECT lastDataProtectedTime AS '@time', 55 '@_type_' FOR XML PATH('lastDataProtectedTime'),TYPE),
                  (SELECT lastGeoLocation),
                  (SELECT CASE WHEN lastGeoLocation IS NULL THEN NULL
								ELSE
								  (SELECT  lastGeoLocationTime as '@time', 55 '@_type_' FOR XML PATH ('lastGeoLocationTime'), TYPE)
								END),
				  (SELECT lastOnlineTime AS '@time', 55 '@_type_' FOR XML PATH ('lastOnlineTime'), TYPE),
                  (SELECT lastOfflineTime AS '@time', 55 '@_type_' FOR XML PATH ('lastOfflineTime'), TYPE),
                  (SELECT nextBkupTime AS '@time', 55 '@_type_' FOR XML PATH ('nextBackupTime'), TYPE),
                  (SELECT ST.patternInfo AS '@patternInfo', ST.subtaskType AS '@taskType',
                        (SELECT ST.subTaskId AS '@subtaskId', ST.subTaskName AS '@subtaskName',
                              ST.taskId AS '@taskId', ST.taskName AS '@taskName'
                              FOR XML PATH ('subTask'), TYPE
                        ),
                        (SELECT ST.ownerId AS '@userId', ST.ownerName AS '@userName'
                              FOR XML PATH ('owner'), TYPE
                        )
                        FROM #taskInfo ST WHERE ST.clientId=cId
                        FOR XML PATH ('subTasks'), TYPE),
                  (SELECT cId as '@clientId', clientName as '@clientName', hostname as '@hostName', appId as '@applicationId', instId as '@instanceId', bSet as '@backupsetId',bsetName as '@backupsetName', subId as '@subclientId', 7 '@_type_'
                  FOR XML PATH ('subClient'), TYPE),
                  (SELECT clientId as '@clientId',  appId as '@applicationId', instanceId as '@instanceId', assocBset as '@backupsetId', subId as '@subclientId', 7 '@_type_'
                        FROM @assocSubClient
                        WHERE assocSubClientId = assocSubC
                        FOR XML PATH ('assocSPsubclient'), TYPE),
 -- CONTENTS:
				CASE (SELECT COUNT(*) FROM @content c WHERE c.subId = cl.subId)
					WHEN 0 THEN NULL
					ELSE
						(SELECT
							(SELECT
								created as '@createTime', modified AS '@modifyTime', fileName AS '@value',
								type as '@valueType'
								FROM @content c WHERE c.subId = cl.subId
							FOR XML PATH ('content'), TYPE)
						FOR XML PATH ('contents'), TYPE)
				END,
				CASE @getContent
					WHEN 1 THEN
						(
							--          FOLLOWING ADDED SO WE CAN "RESTORE" TO SCP CONTENTS
							CASE (SELECT COUNT(*) FROM @SCPcontent c WHERE c.assocSubId = assocSubC)
								WHEN 0 THEN NULL
								ELSE
									(SELECT
										(SELECT
											created as '@createTime', modified AS '@modifyTime', fileName AS '@value', type as '@valueType'
											FROM @SCPcontent c WHERE c.assocSubId = assocSubC
											--AND decoupleSCPcontent = 0
										FOR XML PATH ('content'), TYPE)
									FOR XML PATH ('SCPcontents'), TYPE)
							END
						)
					ELSE NULL
				END,
				-- global Filters --'CV_GLOBAL_FILTER = 13,     -- Global filer
				CASE @getContent
					WHEN 1 THEN
						(
							CASE
								WHEN cl.useGlobalFilter = 1
									AND (
										EXISTS( SELECT appTypeId FROM GetAppTypesForAppGroup(22,0) where appTypeId = cl.appId )
										OR EXISTS( SELECT appTypeId FROM GetAppTypesForAppGroup(34,0) where appTypeId = cl.appId)
									)
								THEN
									(SELECT CASE
										WHEN cl.useGlobalFilter = 1 AND EXISTS( SELECT appTypeId FROM GetAppTypesForAppGroup(22,0) where appTypeId = cl.appId ) --'APPGRP_W2KFileSystem
											THEN   (SELECT [@WindowsGlobalExcludeFilters].value '@value', 13 as '@valueType' FROM @WindowsGlobalExcludeFilters FOR XML PATH('content'), TYPE)
										WHEN  cl.useGlobalFilter = 1 AND EXISTS( SELECT appTypeId FROM GetAppTypesForAppGroup(34,0) where appTypeId = cl.appId) --'APPGRP_UnixFileSystem
											THEN   (SELECT [@UnixGlobalExcludeFilters].value '@value', 13 as '@valueType' FROM @UnixGlobalExcludeFilters FOR XML PATH('content'), TYPE)
										END
									FOR XML PATH('globalContents'), TYPE)
								ELSE NULL
							END
						)
					ELSE NULL
				END,
                  (SELECT propertiesXML from @DLPProperties d WHERE d.dlpClientId=cl.cId),
				  (SELECT features),
				  (SELECT syncFolderId AS '@syncWebFolderId', syncFolderName AS '@syncWebFolderName'
FROM @syncFolderInfo WHERE clientStatus & 0x10000000 <> 0
				   FOR XML PATH('edgeDrive'), TYPE)
				   	,(SELECT CASE WHEN planId = 0 THEN NULL ELSE (SELECT planId AS '@planId', 158 '@_type_', planName as '@planName' FOR XML PATH ('plan'), TYPE) END)
				   ,(select top 1 planPermissions from #clientList cl2 where cl2.cid=cl.cid),
				   (SELECT restoreAuthUsersXML)
                  FROM #clientList cl
                  WHERE bSet <> 0 and cl.appId in (SELECT appTypeId FROM GetAppTypesForAppGroup(35,0))
				  ORDER BY clientName
                  FOR XML PATH ('clientsFileSystem'))
SET @outputXmlStringSP =
            (SELECT backupSize as '@backupSize', capabilities as '@capabilities', isOwner as '@isOwner', totalbackupsize as '@totalBackupSize',
                              isArchived as '@isVMArchived', contentIndexingEnabled as '@contentIndexingEnabled',isDRalertEnabled as '@isDRalertEnabled', isDPalertEnabled as '@isDPalertEnabled',  flag as '@subclientStatus', clientStatus as '@clientStatus',
                                   (select dirDelim  from APP_iDAType where APP_iDAType.type =  cl.appId) as '@dirDelim', isFLA as '@isFLA',
                  (SELECT lastbkupTime AS '@time', 55 '@_type_' FOR XML PATH ('lastBackupTime'), TYPE),
                  (SELECT lastSuccessBkupTime AS '@time', 55 '@_type_' FOR XML PATH ('lastSuccessBackupTime'), TYPE),
                  (SELECT lastOnlineTime AS '@time', 55 '@_type_' FOR XML PATH ('lastOnlineTime'), TYPE),
                  (SELECT lastOfflineTime AS '@time', 55 '@_type_' FOR XML PATH ('lastOfflineTime'), TYPE),
                  (SELECT nextBkupTime AS '@time', 55 '@_type_' FOR XML PATH ('nextBackupTime'), TYPE),
                  (SELECT ST.patternInfo AS '@patternInfo', ST.subtaskType AS '@taskType',
                        (SELECT ST.subTaskId AS '@subtaskId', ST.subTaskName AS '@subtaskName',
                              ST.taskId AS '@taskId', ST.taskName AS '@taskName'
                              FOR XML PATH ('subTask'), TYPE
                        ),
                        (SELECT ST.ownerId AS '@userId', ST.ownerName AS '@userName'
                              FOR XML PATH ('owner'), TYPE
                        )
                        FROM #taskInfo ST WHERE ST.clientId=cId
                        FOR XML PATH ('subTasks'), TYPE),
                  (SELECT cId as '@clientId', clientName as '@clientName', hostname as '@hostName',  appId as '@applicationId', instId as '@instanceId', bSet as '@backupsetId', bsetName as '@backupsetName', subId as '@subclientId', 7 '@_type_'
                  FOR XML PATH ('subClient'), TYPE),
                  (SELECT clientId as '@clientId',  appId as '@applicationId', instanceId as '@instanceId', assocBset as '@backupsetId', subId as '@subclientId', 7 '@_type_'
                        FROM @assocSubClient
                        WHERE assocSubClientId = assocSubC
                        FOR XML PATH ('assocSPsubclient'), TYPE),
            (SELECT
                (SELECT
                    created as '@createTime', modified AS '@modifyTime', fileName AS '@value',
                    type as '@valueType'
                    FROM @content c WHERE c.subId = cl.subId
                FOR XML PATH ('content'), TYPE)
            FOR XML PATH ('contents'), TYPE),
			CASE @getContent
				WHEN 1 THEN
					(
						--          FOLLOWING ADDED SO WE CAN "RESTORE" TO SCP CONTENTS
						(SELECT
							(SELECT
									created as '@createTime', modified AS '@modifyTime', fileName AS '@value', type as '@valueType'
									FROM @SCPcontent c WHERE c.assocSubId = assocSubC
							FOR XML PATH ('content'), TYPE)
						FOR XML PATH ('SCPcontents'), TYPE)
					)
				ELSE NULL
			END
		,(SELECT CASE WHEN planId = 0 THEN NULL ELSE (SELECT planId AS '@planId', 158 '@_type_', planName as '@planName' FOR XML PATH ('plan'), TYPE) END)
        FROM #clientList cl
        WHERE bSet <> 0 and cl.appId in (SELECT appTypeId FROM GetAppTypesForAppGroup(55,0))
		ORDER BY clientName
        FOR XML PATH ('clientsSharePointDoc'))
SET @outputXMLString1Drive =
            (SELECT backupSize as '@backupSize', capabilities as '@capabilities', isOwner as '@isOwner', totalbackupsize as '@totalBackupSize',
                              isArchived as '@isVMArchived', contentIndexingEnabled as '@contentIndexingEnabled',isDRalertEnabled as '@isDRalertEnabled', isDPalertEnabled as '@isDPalertEnabled',  flag as '@subclientStatus', clientStatus as '@clientStatus',
                                   (select dirDelim  from APP_iDAType where APP_iDAType.type =  cl.appId) as '@dirDelim', isFLA as '@isFLA',
                  (SELECT lastbkupTime AS '@time', 55 '@_type_' FOR XML PATH ('lastBackupTime'), TYPE),
                  (SELECT lastSuccessBkupTime AS '@time', 55 '@_type_' FOR XML PATH ('lastSuccessBackupTime'), TYPE),
                  (SELECT lastOnlineTime AS '@time', 55 '@_type_' FOR XML PATH ('lastOnlineTime'), TYPE),
                  (SELECT lastOfflineTime AS '@time', 55 '@_type_' FOR XML PATH ('lastOfflineTime'), TYPE),
                  (SELECT nextBkupTime AS '@time', 55 '@_type_' FOR XML PATH ('nextBackupTime'), TYPE),
                  (SELECT ST.patternInfo AS '@patternInfo', ST.subtaskType AS '@taskType',
                        (SELECT ST.subTaskId AS '@subtaskId', ST.subTaskName AS '@subtaskName',
                              ST.taskId AS '@taskId', ST.taskName AS '@taskName'
                              FOR XML PATH ('subTask'), TYPE
                        ),
                        (SELECT ST.ownerId AS '@userId', ST.ownerName AS '@userName'
                              FOR XML PATH ('owner'), TYPE
                        )
                        FROM #taskInfo ST WHERE ST.clientId=cId
                        FOR XML PATH ('subTasks'), TYPE),
                  (SELECT cId as '@clientId', clientName as '@clientName', hostname as '@hostName',  appId as '@applicationId', instId as '@instanceId', bSet as '@backupsetId', bsetName as '@backupsetName', subId as '@subclientId', 7 '@_type_'
                  FOR XML PATH ('subClient'), TYPE),
                  (SELECT clientId as '@clientId',  appId as '@applicationId', instanceId as '@instanceId', assocBset as '@backupsetId', subId as '@subclientId', 7 '@_type_'
                        FROM @assocSubClient
                        WHERE assocSubClientId = assocSubC
                        FOR XML PATH ('assocSPsubclient'), TYPE),
            (SELECT
                (SELECT
                    created as '@createTime', modified AS '@modifyTime', fileName AS '@value',
                    type as '@valueType'
                    FROM @content c WHERE c.subId = cl.subId
                FOR XML PATH ('content'), TYPE)
            FOR XML PATH ('contents'), TYPE),
			CASE @getContent
				WHEN 1 THEN
					(
						--          FOLLOWING ADDED SO WE CAN "RESTORE" TO SCP CONTENTS
						(SELECT
							(SELECT
									created as '@createTime', modified AS '@modifyTime', fileName AS '@value', type as '@valueType'
									FROM @SCPcontent c WHERE c.assocSubId = assocSubC
							FOR XML PATH ('content'), TYPE)
						FOR XML PATH ('SCPcontents'), TYPE)
					)
				ELSE NULL
			END
		,(SELECT CASE WHEN planId = 0 THEN NULL ELSE (SELECT planId AS '@planId', 158 '@_type_', planName as '@planName' FOR XML PATH ('plan'), TYPE) END)
        FROM #clientList cl
        WHERE bSet <> 0 and cl.appId in (SELECT appTypeId FROM GetAppTypesForAppGroup(135,0))
		ORDER BY clientName
        FOR XML PATH ('clientsOneDrive'))
DECLARE @userMailBoxXML XML
DECLARE @userDelegatedMailBoxXML XML
IF(@userMailBox = 1 AND @getMailBoxClients = 1)
BEGIN
 EXEC    [dbo].AppGetLaptopUserMailBox @mailBoxGuid ,@userid, @userMailBoxXML OUTPUT
 EXEC    [dbo].AppGetLaptopUserDelegatedMailBox @mailBoxGuid ,@userid, @userDelegatedMailBoxXML OUTPUT
END
 --VM
 IF (@vmsExist = 1)
 BEGIN
 SET @outputXmlStringVM =
            (SELECT backupSize as '@backupSize', capabilities as '@capabilities', isOwner as '@isOwner', totalbackupsize as '@totalBackupSize',
                              isArchived as '@isVMArchived', isDRalertEnabled as '@isDRalertEnabled', isDPalertEnabled as '@isDPalertEnabled', flag as '@subclientStatus', clientStatus as '@clientStatus',
                                    decoupleSCPcontent as '@isDecoupledContent',  isFLA as '@isFLA', isUserCentricClient as '@isUserCentricClient', showDLP AS '@showDLP',
									 (SELECT vmDirDelim  FROM @vmEntity vm  WHERE vm.vCid = cl.vCid) AS '@dirDelim',
									  (SELECT  vendortype   FROM @vmEntity vm WHERE vm.vCid = cl.vCid) AS '@vendorType',
           --     if(@getDetailProperties = 1)
                  (SELECT  vmGUID as '@vmGUID', vmName as  '@clientName', vCid as '@clientId', vmHostName as '@hostName', vmDisplayName as '@displayName'  FROM @vmEntity vm WHERE vm.vCid = cl.vCid
                        FOR XML PATH ('vmEntity'), TYPE),
					(SELECT  clientId as '@clientId', clientName as  '@clientName' FROM @proxyEntities vm WHERE vm.instanceId = cl.instId
                        FOR XML PATH ('proxyClient'), TYPE),
                   (SELECT CASE WHEN planId = 0 THEN NULL ELSE (SELECT planId AS '@planId', 158 '@_type_', planName as '@planName' FOR XML PATH ('plan'), TYPE) END),
                   (SELECT CASE WHEN physicalClientID = 0 THEN NULL ELSE (SELECT physicalClientID AS '@clientId', 3 '@_type_', ISNULL((select AC.name from  APP_Client AC where AC.id=physicalClientID),'') as '@clientName' FOR XML PATH ('physicalClient'), TYPE) END),
                   (SELECT lastbkupTime AS '@time', 55 '@_type_' FOR XML PATH ('lastBackupTime'), TYPE),
				   (SELECT lastSuccessBkupTime AS '@time', 55 '@_type_' FOR XML PATH ('lastSuccessBackupTime'), TYPE),
                   (SELECT lastOnlineTime AS '@time', 55 '@_type_' FOR XML PATH ('lastOnlineTime'), TYPE),
                   (SELECT lastOfflineTime AS '@time', 55 '@_type_' FOR XML PATH ('lastOfflineTime'), TYPE),
                   (SELECT nextBkupTime AS '@time', 55 '@_type_' FOR XML PATH ('nextBackupTime'), TYPE),
                  (SELECT ST.patternInfo AS '@patternInfo',
                        (SELECT ST.subTaskId AS '@subtaskId', ST.subTaskName AS '@subtaskName',
                              ST.taskId AS '@taskId', ST.taskName AS '@taskName'
                              FOR XML PATH ('subTask'), TYPE
                        ),
                        (SELECT ST.ownerId AS '@userId', ST.ownerName AS '@userName'
                              FOR XML PATH ('owner'), TYPE
                        )
                        FROM #taskInfo ST WHERE ST.clientId=cId
                        FOR XML PATH ('subTasks'), TYPE),
                  (SELECT cId as '@clientId', clientName as '@clientName', appId as '@applicationId', instId as '@instanceId', bSet as '@backupsetId', bsetName as '@backupsetName', subId as '@subclientId', 7 '@_type_'
                  FOR XML PATH ('subClient'), TYPE),
                  (SELECT clientId as '@clientId',  appId as '@applicationId', instanceId as '@instanceId', assocBset as '@backupsetId', subId as '@subclientId', 7 '@_type_'
                        FROM @assocSubClient
                        WHERE assocSubClientId = assocSubC
                        FOR XML PATH ('assocSPsubclient'), TYPE),
 -- CONTENTS:
				CASE (SELECT COUNT(*) FROM @content c WHERE c.subId = cl.subId)
					WHEN 0 THEN NULL
					ELSE
						(SELECT
							(SELECT
								created as '@createTime', modified AS '@modifyTime', fileName AS '@value',
								type as '@valueType'
								FROM @content c WHERE c.subId = cl.subId
							FOR XML PATH ('content'), TYPE)
						FOR XML PATH ('contents'), TYPE)
				END,
				CASE @getContent
					WHEN 1 THEN
						(
							--          FOLLOWING ADDED SO WE CAN "RESTORE" TO SCP CONTENTS
							CASE (SELECT COUNT(*) FROM @SCPcontent c WHERE c.assocSubId = assocSubC)
								WHEN 0 THEN NULL
								ELSE
									(SELECT
										(SELECT
											created as '@createTime', modified AS '@modifyTime', fileName AS '@value', type as '@valueType'
											FROM @SCPcontent c WHERE c.assocSubId = assocSubC
											--AND decoupleSCPcontent = 0
										FOR XML PATH ('content'), TYPE)
									FOR XML PATH ('SCPcontents'), TYPE)
							END
						)
					ELSE NULL
				END
					,(SELECT CASE WHEN planId = 0 THEN NULL ELSE (SELECT planId AS '@planId', 158 '@_type_', planName as '@planName' FOR XML PATH ('plan'), TYPE) END),
					(SELECT restoreAuthUsersXML)
                  FROM #clientList cl
WHERE  appId=106--and cl.appTypeId in (SELECT appTypeId FROM GetAppTypesForAppGroup(35,0))
				   ORDER BY clientName
                  FOR XML PATH ('clientsVMs'))
 END
 ELSE
 BEGIN
	 SET @outputXmlStringVM = NULL
 END
 SET @xmlString = (select @outputXmlStringFS,@outputXmlStringMB,@outputXmlStringSP, @outputXMLString1Drive, @userMailBoxXML, @userDelegatedMailBoxXML, @outputXmlStringVM FOR XML PATH(''),ROOT('App_LapTopClientLstResp'))
 if(@xmlString IS NOT NULL)
	SET @xmlString.modify('delete (//*[empty(./*) and not(./@*)])')
if(@xmlString.exist('/App_LapTopClientLstResp') = 0)
	SET @xmlString = ('<App_LapTopClientLstResp/>')
END TRY
----=====================================================================
----==============  COME HERE IF THERE WAS A PROBLEM!     ===============
----=====================================================================
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode    = ERROR_NUMBER()
    SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
	   --Close cursor
    IF ( CURSOR_STATUS('global', 'DLPCur') >= 0  /* cursor is open */
        OR CURSOR_STATUS('local', 'DLPCur') >= 0 )
    CLOSE DLPCur
    IF ( CURSOR_STATUS('global','DLPCur') = -1  /* cursor is closed */
        OR CURSOR_STATUS('local','DLPCur') = -1 )
    DEALLOCATE DLPCur
	IF ( CURSOR_STATUS('global', 'updatePatternCur') >= 0  /* cursor is open */
        OR CURSOR_STATUS('local', 'updatePatternCur') >= 0 )
    CLOSE updatePatternCur
    IF ( CURSOR_STATUS('global','updatePatternCur') = -1  /* cursor is closed */
        OR CURSOR_STATUS('local','updatePatternCur') = -1 )
    DEALLOCATE updatePatternCur
    SET @xmlString = ( SELECT
                ( SELECT @errorCode '@errorCode', @errorString '@errorMessage'
                      FOR XML PATH('error'), TYPE
                )
    FOR XML PATH(''),
    ROOT('App_LapTopClientLstResp'))
END CATCH
SELECT @xmlString
-- drop temp table
IF object_id('tempdb.dbo.#edgeClientsWithCapabilities') IS NOT NULL
	DROP TABLE #edgeClientsWithCapabilities
IF object_id('tempdb.dbo.#clientList') IS NOT NULL
	DROP TABLE #clientList
IF object_id('tempdb.dbo.#taskInfo') IS NOT NULL
	DROP TABLE #taskInfo
IF object_id('tempdb.dbo.#runTimeInfo') IS NOT NULL
	DROP TABLE #runTimeInfo
IF object_id('tempdb.dbo.#jobInfo') IS NOT NULL
	DROP TABLE #jobInfo
--------------------------------------------
-- SOME CODE, FOR STANDALONE DEBUGGING  ----
--------------------------------------------
/*
IF EXISTS (Select * from sysObjects where name = 'APPGetLaptopClientList')
      Drop proc APPGetLaptopClientList
GO
DECLARE @xml XML
DECLARE @xmltext nvarchar(max)=
'<App_LapTopClientListReq scope="2">
	<locale localeId="0" />
	<user userId="24" />
	<filter getMailBoxClients="1" getContent="0" getSchedules="0" getSharePointClients="1" getFsLikeClients="1" />
</App_LapTopClientListReq>'SET @xml = @xmltext
exec APPGetLaptopClientProperties @xml
*/
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetLaptopClientList')
	delete from GxQscripts where name = 'APPGetLaptopClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetLaptopClientList')
	delete from GXDBVersions where aliasname = 'APPGetLaptopClientList'
GO

insert into GXDBVersions values(2, 'APPGetLaptopClientList',  '00010147000200580000', 'APPGetLaptopClientList', '00010147000200580000')
GO

