

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetIndexingProxyClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	| APPGetIndexingProxyClient
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPGetIndexingProxyClient')
BEGIN
	print '>>> Drop Stored Procedure: APPGetIndexingProxyClient <<<'
	drop procedure APPGetIndexingProxyClient
END
IF EXISTS (select * from GxQscripts where name='APPGetIndexingProxyClient')
	delete from GxQscripts where name = 'APPGetIndexingProxyClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetIndexingProxyClient')
	delete from GXDBVersions where aliasname = 'APPGetIndexingProxyClient'
GO
print '... Creating Procedure: APPGetIndexingProxyClient'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPGetIndexingProxyClient
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
-----------------------------------------------------------
  @indexingSubclientId INT
-----------------------------------------------------------
AS
  DECLARE @proxyClientId INT
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--
BEGIN
	SELECT TOP 1 @proxyClientId = CAST(DSP.PropertyValue AS INT)
	FROM SEDataSourceProperty DSP
	JOIN APP_SubClientProp SCP ON SCP.componentNameId = @indexingSubclientId
		AND DSP.datasourceId = CAST(SCP.attrval AS INT)
		AND ISNUMERIC(DSP.PropertyValue) = 1
		AND SCP.attrName = N'Indexing datasource id'
		AND SCP.modified=0
		AND SCP.cs_attrName = CHECKSUM(N'Indexing datasource id')
		AND ISNUMERIC(SCP.attrVal) = 1
	JOIN SEProperty SEP ON DSP.PropertyId = SEP.PropertyId
		AND SEP.PropertyName = 'accessnodeclientid'
	SELECT @proxyClientId proxyClientId
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetIndexingProxyClient')
	delete from GxQscripts where name = 'APPGetIndexingProxyClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetIndexingProxyClient')
	delete from GXDBVersions where aliasname = 'APPGetIndexingProxyClient'
GO

insert into GXDBVersions values(2, 'APPGetIndexingProxyClient',  '00000000000000000000', 'APPGetIndexingProxyClient', '00000000000000000000')
GO

