

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetIndexServerProperties.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetIndexServerProperties')
BEGIN
	print '>>> Drop Stored Procedure: APPGetIndexServerProperties <<<'
	drop procedure APPGetIndexServerProperties
END
IF EXISTS (select * from GxQscripts where name='APPGetIndexServerProperties')
	delete from GxQscripts where name = 'APPGetIndexServerProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetIndexServerProperties')
	delete from GXDBVersions where aliasname = 'APPGetIndexServerProperties'
GO
print '... Creating Procedure: APPGetIndexServerProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetIndexServerProperties
  @inxml XML
AS
DECLARE @dbName NVARCHAR(36) =  @inXML.value('(/App_GetIndexServerProperties/@dbName)[1]', 'NVARCHAR(36)')
DECLARE @backupsetId INT = @inXML.value('(/App_GetIndexServerProperties/@backupSetId)[1]', 'INT')
DECLARE @isSubclientIndex INT = CASE WHEN @dbName IS NOT NULL THEN 1 ELSE 0 END
DECLARE @clientId INT, @instanceId INT, @appTypeId INT, @subclientId INT, @isSubClientEntity INT
IF @isSubclientIndex = 1
	SELECT @subclientId = APP.id, @appTypeId = APP.appTypeId, @instanceId = APP.instance, @backupsetId = APP.backupSet, @clientId = APP.clientId
	FROM APP_Application APP WITH (NOLOCK)
	WHERE APP.GUID = @dbName
ELSE
	SELECT TOP 1 @subclientId = APP.id, @appTypeId = APP.appTypeId, @instanceId = APP.instance, @clientId = APP.clientId
	FROM APP_Application APP WITH (NOLOCK)
	WHERE @backupSetId = APP.backupSet
DECLARE @pruningEnabled INT = 0
SELECT @pruningEnabled = CAST(ISNULL(value,0) AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'Enable Index Pruning' AND modified = 0
DECLARE @outXML XML =
(SELECT @pruningEnabled AS '@isPruningEnabled',
props.indexPruning AS '@overrideIndexPruning',
props.retDays AS '@indexRetDays',
props.retCycles AS '@indexRetCycle',
props.pruningType AS '@indexPruningType',
props.curIdxServer.query('/currentIndexServer'),
props.indexMAs.query('/indexMAs/qualifyingIndexServers'),
props.indexBkpSp.query('/currentIndexBackupSP'),
props.indexBkpEligibleSPs.query('/indexBackupSPs/eligibleIndexBackupSP')
FROM dbo.GetIndexServerOptions (@clientId, @instanceId, @appTypeId, @backupsetId, @subclientId, @isSubclientIndex, 30) props
FOR XML PATH ('App_IndexServerBackupsetProps'), TYPE)
SELECT @outXML
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetIndexServerProperties')
	delete from GxQscripts where name = 'APPGetIndexServerProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetIndexServerProperties')
	delete from GXDBVersions where aliasname = 'APPGetIndexServerProperties'
GO

insert into GXDBVersions values(2, 'APPGetIndexServerProperties',  '00000000000000000000', 'APPGetIndexServerProperties', '00000000000000000000')
GO

