

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetIDAProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetIDAProperties.sp,v $ $Id: APPGetIDAProperties.sp,v 1.52.14.85.4.1 2021/02/04 05:25:06 jswaminathan Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPGetIDAProperties')
BEGIN
	print '>>> Drop Stored Procedure: APPGetIDAProperties <<<'
	drop procedure APPGetIDAProperties
END
IF EXISTS (select * from GxQscripts where name='APPGetIDAProperties')
	delete from GxQscripts where name = 'APPGetIDAProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetIDAProperties')
	delete from GXDBVersions where aliasname = 'APPGetIDAProperties'
GO
print '... Creating Procedure: APPGetIDAProperties'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPGetIDAProperties
  @xmlTxt XML	
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @dateTime		AS DATETIME = getDate()
DECLARE @brAlertTrace	 AS varchar(256)               = ISNULL((select value from gxglobalParam Where name = 'bralertTrace'),'0')
if @brAlertTrace > 1						-- Since this is is called often, raise debug level
BEGIN
     DECLARE @messBuf AS nvarchar(max) = CONVERT(nvarchar(max), @xmlTxt)
		exec br_ntTrace '.. APPGetIDAProperties', 0, @dateTime, 0, 0, @messBuf
END
IF object_id('tempdb.dbo.#LicenseAppSizeTbl') IS NOT null DROP TABLE #LicenseAppSizeTbl
CREATE TABLE #LicenseAppSizeTbl	(subclientId INT PRIMARY KEY,AppSizeMB	BIGINT)
DECLARE @i_clientList TABLE (
	clientId		int,
    clientName		nvarchar(510),
    appTypeId		int,
    appTypeName		nvarchar(255),
    errorCode INT,
	errorString NVARCHAR(max))
DECLARE @allAgent INT
DECLARE @r_clientId INTEGER
DECLARE @r_appTypeID 	INTEGER
DECLARE @r_excludeExtendedProperties	INTEGER
DECLARE @r_clientName	NVARCHAR(MAX)
DECLARE @r_appTypeName NVARCHAR(MAX)
DECLARE @errorCode int
DECLARE @errorString nvarchar(max)
DECLARE @r_capabilityId int
DECLARE @r_isAgentIndexingV2 INTEGER
DECLARE @r_getArchiverAgents	INTEGER = 0
SET @r_excludeExtendedProperties = 0
DECLARE @userId int
DECLARE @localeId int
DECLARE @totalAgents int
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS Agent
			FROM    @xmlTxt.nodes('App_GetAgentPropertiesRequest/processinginstructioninfo/user') R ( ref )),0)
			SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
			FROM    @xmlTxt.nodes('App_GetAgentPropertiesRequest/processinginstructioninfo/locale') R ( ref )),0)
IF	object_id('tempdb.dbo.#TEMP_APP_AgentPROP') is not null DROP TABLE #TEMP_APP_AgentPROP
IF	object_id('tempdb.dbo.#TEMP_APP_AgentPROPS') is not null DROP TABLE #TEMP_APP_AgentPROPS
DECLARE @FinalAgentPropList TABLE (	appTypeID			INT,
									appName				NVARCHAR(MAX),
									enableOCS 			NVARCHAR(MAX),
									createIndexOnFull	NVARCHAR(MAX),
									createIndexOnFail	NVARCHAR(MAX),
									userDescription		NVARCHAR(MAX),
									isSRMEnabled		NVARCHAR(MAX),
									requiresMoreConfig	NVARCHAR(MAX),
									appTypePriority		NVARCHAR(MAX),
									isNDMPRestore		NVARCHAR(MAX),
									archiveGroup		NVARCHAR(MAX),
									maxSimultaneousStubRecoveries	NVARCHAR(MAX),
									timeBetweenRecalls	NVARCHAR(MAX),
									timeToWaitAfterMax	NVARCHAR(MAX),
									qsnapMaxCacheSize	NVARCHAR(MAX),
									qsnapMinCacheSize	NVARCHAR(MAX),
									agentArchivePropertiesFlag	NVARCHAR(MAX),
									AgentVersion			NVARCHAR(MAX),
									installDate			NVARCHAR(MAX),
									appTypePathnameOrder	NVARCHAR(MAX),
									appTypePathnameSeperator	NVARCHAR(MAX),
									appTypepathnameCaseSensitive	NVARCHAR(MAX),
									patchStatus			INT,
									isMarkedDeleted	INT,
									isSRMdataCollectionEnabled	NVARCHAR(MAX),
									clientId			INT,
									clientName			NVARCHAR(MAX),
									archiverStoragepolicy NVARCHAR(MAX),
									archiverStoragepolicyId int,
									useSnapShotWriter INT,
									objectServerInterval NVARCHAR(MAX),
									prepostUsername NVARCHAR(MAX),
									isArchiverDriverEnabled NVARCHAR(MAX),
									isExplorerBasedRecall NVARCHAR(MAX),
									isAccessTimeCollected NVARCHAR(MAX),
									honorArchiverRetention NVARCHAR(MAX),
									disableHonorArchiverRetention NVARCHAR(MAX),
									recallMPFlag INT,
									recallMP INT,
									MPname NVARCHAR(MAX),
									isTrueUpOptionEnabledForOnePass NVARCHAR(MAX),
									runTrueUpJobAfterDaysForOnePass NVARCHAR(MAX),
									backupConfigXML					XML,
									isAgentIndexingV2			INTEGER,
									--,OSType NVARCHAR(MAX),
									cloudDBConfigXML		XML,
									lastBackupTime             INT DEFAULT(NULL),
									firstBackupTime			INT DEFAULT(NULL),
									applicationSize            BIGINT DEFAULT(NULL),
									totalBackupSize            BIGINT DEFAULT(NULL),
									dedupeRatio		FLOAT DEFAULT(NULL),
									sizeOnMedia				   BIGINT DEFAULT(NULL),
									lastBackupJobInfo				XML,
									SLAStatus					INT DEFAULT(3),
									SLACategory					INT DEFAULT(0),
									SLACategoryDescription		NVARCHAR(255) DEFAULT ''
									)
DECLARE @NDMPEnabler TABLE (
							propValue	INT,
							errorCode	INT,
							errorString	NVARCHAR(MAX)
							)
DECLARE @VersionAndPatch TABLE (
							Release		NVARCHAR(MAX),
							Build		NVARCHAR(MAX),
							ReleaseAndBuild		NVARCHAR(MAX),
							releaseId		INT,
							installDate		INT)
DECLARE @ActivityControl TABLE (
								appTypeID int,
								idaActivityControl XML
								)
DECLARE @AgentList	TABLE (appType	INT)
DECLARE @NetwareProperties	TABLE(
										appTypeID			INT,
										username	NVARCHAR(MAX),
										passwd	NVARCHAR(MAX)
									)
DECLARE @NASProperties	TABLE(
										appTypeID			INT,
										username	NVARCHAR(MAX),
										passwd	NVARCHAR(MAX),
										ListenPort	INT,
										FirmwareRevision	NVARCHAR(MAX),
										Vendor	NVARCHAR(MAX)
									)
DECLARE @NDSProperties	TABLE(
										appTypeID			INT,
										username	NVARCHAR(MAX),
										NDSTreeName	NVARCHAR(MAX)
									)
DECLARE @NTAPDMProperties	TABLE (
									appTypeID			INT,
									username	NVARCHAR(MAX),
									NTAPDMFilerName	NVARCHAR(MAX),
									stubLocation	NVARCHAR(MAX)
								 )
DECLARE @FSDataMigratorProperties	TABLE (
											appTypeId	INT,
											releaseId	INT,
											ADServerName	NVARCHAR(MAX),
											ADUsername	NVARCHAR(MAX),
											proxyFileExpiration	NVARCHAR(MAX),
											proxyFilePruneInterval	NVARCHAR(MAX),
											isEnableNFSShareForEMC	NVARCHAR(MAX),
											proxyUsername	NVARCHAR(MAX),
											isEndUserEraseEnabled	NVARCHAR(MAX),
											EndUserFolderList	NVARCHAR(MAX)
										   )
DECLARE @DataClassificationProperties	TABLE (
											appTypeId	INT,
											ADServerName	NVARCHAR(MAX),
											ADUsername	NVARCHAR(MAX),
											MetaDataFileLocation	NVARCHAR(MAX),
											isDataClassificationEnabled	NVARCHAR(MAX),
											isOnline	NVARCHAR(MAX),
											clientPriority	NVARCHAR(MAX),
											updateInterval	NVARCHAR(MAX),
											InactivityPeriod	NVARCHAR(MAX),
											DataClassificationTagList NVARCHAR(MAX)
										   )
DECLARE @NetwareDMProperties	TABLE(
										appTypeID			INT,
										username	NVARCHAR(MAX)
									)
DECLARE @Win2KProperties	TABLE (
									appTypeID			INT,
									OnlineCILocationShareName	NVARCHAR(MAX),
									OWAURLList	NVARCHAR(MAX)
									)
DECLARE @TurboNASProperties	TABLE (
									appTypeID			INT,
									http_cifs_addr		NVARCHAR(MAX),
									nas_http_port  		NVARCHAR(MAX),
									proxyStubPath 		NVARCHAR(MAX),
									primaryClientId		NVARCHAR(MAX),
									primaryClientName	NVARCHAR(MAX),
									secondaryClientId	NVARCHAR(MAX),
									secondaryClientName	NVARCHAR(MAX),
									proxyClientId		NVARCHAR(MAX),
									proxyClientName		NVARCHAR(MAX)
									)
DECLARE @onePassProperties TABLE (
									componentNameId					INT,
									appTypeID						INT,
									memberServers			NVARCHAR(MAX),
									indexServerId					INT,
									indexServerName			NVARCHAR(MAX),
									recallService			NVARCHAR(MAX)
									)
DECLARE @onePassServersTBL TABLE(
									appTypeID			INT,
									serverName			NVARCHAR(MAX)
								)
DECLARE @exchangeOnePassProperties TABLE (
											id int				IDENTITY(1,1) PRIMARY KEY,
											appTypeID			INT,
											servers				NVARCHAR(MAX),
											accounts			XML,
											azureAppList		XML,
											azureAppId			NVARCHAR(MAX),
											azureSecretKey		NVARCHAR(MAX),
											azureTentanName		NVARCHAR(MAX),
											environmentType		INT,
											msCloudRegion		INT,
											discoveryFilter		NVARCHAR(256),
											modernAuthEnabled	INT,
											useEWS				INT,
											ewsConnectionUri    NVARCHAR(256),
											discoverInfo		XML
											)
DECLARE @LotusNotesDocProperties	TABLE (
											appTypeID			INT,
											RestoreToRecoveredItems	NVARCHAR(MAX)
											)
DECLARE	@GranADProperties	TABLE	(
										appTypeID			INT,
										username	NVARCHAR(MAX)
									)
DECLARE	@FLRProperties	TABLE	(
									appTypeID	INT,
									userAccount	NVARCHAR(MAX),
									fileLogPath	NVARCHAR(MAX),
									logVolThrottlePercent	NVARCHAR(MAX),
									logVolStopLogsPercent	NVARCHAR(MAX),
									flrReplicationOptions	NVARCHAR(MAX),
									srcLogVolAbortPercent	NVARCHAR(MAX),
									flrDefualtOSPriority	NVARCHAR(MAX),
									flrLogFlushWaitTime		NVARCHAR(MAX),
									flrTransferRate			NVARCHAR(MAX),
									flrONTAPAccount		NVARCHAR(MAX)
									--	OpWindowRule Fields
									--id	INT,
									--clientId	INT,
									--appTypeId	INT,
									--OpType		INT,
									--daysOfWeek	INT,
									--startTime	INT,
									--endTime		INT,
									--enable		INT,
									--description	NVARCHAR(MAX),
									--utilization	INT,
									--clientGroupId	INT,
									--instanceId		INT,
      								--backupsetId		INT,
      								--subclientId		INT,
									--startDate	INT,
									--endDate		INT
								)
DECLARE	@Credentials	TABLE	(
									id			INT,
									appName		NVARCHAR(MAX),
									Username	NVARCHAR(MAX),
									Servername	NVARCHAR(MAX)
								)
DECLARE @SharePointProp	TABLE	(
									appTypeId	INT,
									Username	NVARCHAR(MAX),
									ServerName	NVARCHAR(MAX),
									StubRetentionTime	NVARCHAR(MAX),
									ReleaseTopologyLock	NVARCHAR(MAX),
									RestorePath	NVARCHAR(MAX),
									isRemoteSQLServer	NVARCHAR(MAX),
									sqlUserName			NVARCHAR(MAX),
									spVersion			NVARCHAR(16)
								)
DECLARE @ExchangePublicFolderProp	TABLE	(
												appTypeId	INT,
												UserName	NVARCHAR(MAX),
												ServerName	NVARCHAR(MAX),
												ProfileName	NVARCHAR(MAX),
												MailBoxName	NVARCHAR(MAX),
												BackupDeleted	NVARCHAR(MAX),
												UseCSVDEDiscovery	NVARCHAR(MAX),
												BackupHiddenMailBox	NVARCHAR(MAX),
												MagneticLib	NVARCHAR(MAX),
												TapeLib	NVARCHAR(MAX),
												OfflineMedia	NVARCHAR(MAX),
												JournalThreshold	NVARCHAR(MAX),
												ADServerList		NVARCHAR(MAX),
												isForceRecallOutlookAddin	NVARCHAR(MAX),
												isForceRecallOWAUser	NVARCHAR(MAX),
												isAutoDiscoveryEnabled	NVARCHAR(MAX),
												canManageContentAutomatically	NVARCHAR(MAX),
												isOptimizeDataForSearchEnabled	NVARCHAR(MAX),
												AgentVersion	NVARCHAR(MAX),
												isHostedExchange	NVARCHAR(MAX),
												OnlineCILocShare	NVARCHAR(MAX),
												CIOWAUrlList		NVARCHAR(MAX)
											)
DECLARE @DataMigratorProp	TABLE	(
												appTypeId	INT,
												UserName	NVARCHAR(MAX),
												ServerName	NVARCHAR(MAX),
												ProfileName	NVARCHAR(MAX),
												MailBoxName	NVARCHAR(MAX),
												BackupDeleted	NVARCHAR(MAX),
												UseCSVDEDiscovery	NVARCHAR(MAX),
												BackupHiddenMailBox	NVARCHAR(MAX),
												MagneticLib	NVARCHAR(MAX),
												TapeLib	NVARCHAR(MAX),
												OfflineMedia	NVARCHAR(MAX),
												JournalThreshold	NVARCHAR(MAX),
												ADServerList		NVARCHAR(MAX),
												isForceRecallOutlookAddin	NVARCHAR(MAX),
												isForceRecallOWAUser	NVARCHAR(MAX),
												isAutoDiscoveryEnabled	NVARCHAR(MAX),
												canManageContentAutomatically	NVARCHAR(MAX),
												isOptimizeDataForSearchEnabled	NVARCHAR(MAX),
												AgentVersion	NVARCHAR(MAX),
												isHostedExchange	NVARCHAR(MAX),
												OnlineCILocShare	NVARCHAR(MAX),
												CIOWAUrlList		NVARCHAR(MAX)
											)
DECLARE @ExchangeArchiverProp	TABLE	(
												appTypeId	INT,
												UserName	NVARCHAR(MAX),
												ServerName	NVARCHAR(MAX),
												ProfileName	NVARCHAR(MAX),
												MailBoxName	NVARCHAR(MAX),
												BackupDeleted	NVARCHAR(MAX),
												UseCSVDEDiscovery	NVARCHAR(MAX),
												BackupHiddenMailBox	NVARCHAR(MAX),
												MagneticLib	NVARCHAR(MAX),
												TapeLib	NVARCHAR(MAX),
												OfflineMedia	NVARCHAR(MAX),
												JournalThreshold	NVARCHAR(MAX),
												ADServerList		NVARCHAR(MAX),
												isForceRecallOutlookAddin	NVARCHAR(MAX),
												isForceRecallOWAUser	NVARCHAR(MAX),
												isAutoDiscoveryEnabled	NVARCHAR(MAX),
												canManageContentAutomatically	NVARCHAR(MAX),
												isOptimizeDataForSearchEnabled	NVARCHAR(MAX),
												AgentVersion	NVARCHAR(MAX),
												isHostedExchange	NVARCHAR(MAX),
												OnlineCILocShare	NVARCHAR(MAX),
												CIOWAUrlList		NVARCHAR(MAX)
											)
DECLARE @ExchangeMBProp	TABLE	(
												appTypeId	INT,
												UserName	NVARCHAR(MAX),
												ServerName	NVARCHAR(MAX),
												ProfileName	NVARCHAR(MAX),
												MailBoxName	NVARCHAR(MAX),
												BackupDeleted	NVARCHAR(MAX),
												UseCSVDEDiscovery	NVARCHAR(MAX),
												BackupHiddenMailBox	NVARCHAR(MAX),
												MagneticLib	NVARCHAR(MAX),
												TapeLib	NVARCHAR(MAX),
												OfflineMedia	NVARCHAR(MAX),
												JournalThreshold	NVARCHAR(MAX),
												ADServerList		NVARCHAR(MAX),
												isForceRecallOutlookAddin	NVARCHAR(MAX),
												isForceRecallOWAUser	NVARCHAR(MAX),
												isAutoDiscoveryEnabled	NVARCHAR(MAX),
												canManageContentAutomatically	NVARCHAR(MAX),
												isOptimizeDataForSearchEnabled	NVARCHAR(MAX),
												AgentVersion	NVARCHAR(MAX),
												isHostedExchange	NVARCHAR(MAX),
												OnlineCILocShare	NVARCHAR(MAX),
												CIOWAUrlList		NVARCHAR(MAX)
											)
DECLARE @ExchangeDBProp	TABLE	(
									appTypeId	INT,
									Username	NVARCHAR(MAX),
									ExchDBThrottling	NVARCHAR(MAX),
									ServerName	NVARCHAR(MAX),
									isOptimizeDataForSearchEnabled	NVARCHAR(MAX),
									AgentVersion	NVARCHAR(MAX),
									DagName	NVARCHAR(MAX),
									generateExchActivityLog	NVARCHAR(MAX),
									exchMBLogLocation	NVARCHAR(MAX),
									manageContentAutomatically	NVARCHAR(MAX),
									exchJournalLogUsername	NVARCHAR(MAX),
									releaseTopologyLock	NVARCHAR(MAX),
									remoteIndexBackupRestorePath	NVARCHAR(MAX),
									isRemoteSQLServer	NVARCHAR(MAX),
									RemoteSQLServerUsername	NVARCHAR(MAX),
									backupLevel	NVARCHAR(MAX),
									appTypeFlag	INT
								)
DECLARE	@NetwareGroupWise	TABLE	(
										appTypeId			INT,
										username	NVARCHAR(MAX)
									)
DECLARE	@FastraxForExch	TABLE (
								appTypeId	INT,
								Username	NVARCHAR(MAX),
								ServerName	NVARCHAR(MAX),
								backupLevel	NVARCHAR(MAX)
							  )
DECLARE	@SharepointDBProp	TABLE (
								appTypeId	INT,
								Username	NVARCHAR(MAX),
								ServerName	NVARCHAR(MAX),
								backupLevel	NVARCHAR(MAX)
							  )
DECLARE	@Oracle8Prop	TABLE (
								 appTypeId	INT,
								 isAutoDiscoveredEnabled	NVARCHAR(MAX),
								 dataSP		INT,
								 logSP		INT
								)
DECLARE	@db2Prop	TABLE (
								 appTypeId	INT,
								 isAutoDiscoveredEnabled	NVARCHAR(MAX)
	)
DECLARE	@MySQLProp	TABLE (
								 appTypeId	INT,
								 isAutoDiscoverEnabled	NVARCHAR(MAX)
	)
DECLARE	@PostgreSQLProp	TABLE (
								 appTypeId	INT,
								 isAutoDiscoverEnabled	NVARCHAR(MAX)
	)
DECLARE @SQL61Prop	TABLE	(
								appTypeId	INT,
								overrideGlobalAuthentication NVARCHAR(MAX),
								useLocalSystemAccount	NVARCHAR(MAX),
								impersonateUser    NVARCHAR(MAX),
								userName	NVARCHAR(MAX), -- For Azure, AD Authentication UserName is stored here
								password	NVARCHAR(MAX),
								isAutoDiscoverSQLInstances	NVARCHAR(MAX),
								isStagingPathForRestoresEnabled NVARCHAR(MAX),
								stagingPath	NVARCHAR(MAX),
								canManageContentAutomaticallyFlag	NVARCHAR(MAX),
								isAzureConfigured	NVARCHAR(MAX),
								azureTenantId	NVARCHAR(MAX),
								azureClientId	NVARCHAR(MAX),
								azureSubscriptionId	NVARCHAR(MAX),
								azureStorageConnectionString	NVARCHAR(MAX),
								azureAuthenticationMethod	NVARCHAR(MAX),
								azureUsername	NVARCHAR(MAX),
								azurePassword	NVARCHAR(MAX),
								azureSQLUsername	NVARCHAR(MAX), -- For Azure, SQL Authentication UserName is stored here
								azureSQLPassword	NVARCHAR(MAX),
								thumbprint	NVARCHAR(MAX),
								isAwsConfigured	NVARCHAR(MAX),
								awsAccessKey	NVARCHAR(MAX),
								awsSecretKey	NVARCHAR(MAX),
								s3BucketName	NVARCHAR(MAX),
								awsSqlInstanceUsername	NVARCHAR(MAX),
								awsSqlInstancePassword	NVARCHAR(MAX),
								proxies NVARCHAR(MAX),
								EntityID	INT,
								DisplayName	NVARCHAR(MAX),
      							AssocLevel	INT
      						)
DECLARE @AzureADProperties TABLE (
									appTypeID			INT,
									azureAppList		XML,
									serviceAccounts		XML,
									memberServers		NVARCHAR(MAX),
									indexServerId		INT,
									indexServerName		NVARCHAR(255),
									msCloudRegion		INT
								)
IF OBJECT_ID('tempdb.dbo.#archiveClientInfo') IS NOT NULL
	DROP TABLE #archiveClientInfo
CREATE TABLE #archiveClientInfo
(
	r_clientID INT PRIMARY KEY,
	r_DSCLientID VARCHAR(10),
	r_DSListSubclient VARCHAR(MAX),
	r_DSListBackupSet VARCHAR(MAX),
	r_DSFullList VARCHAR(MAX)
)
DECLARE @userGroups TABLE (	appTypeID INT,	idaSecurity XML, idaSecurityNew XML)
DECLARE @propertyList TABLE (attrName NVARCHAR(MAX), attrVal NVARCHAR(MAX))
------------------------
 SET @r_capabilityId = ISNULL((SELECT  ref.value('@capabilityFlags', 'int') AS Agent
                              FROM    @xmlTxt.nodes('App_GetAgentPropertiesRequest/filterOptions') R ( ref )),0)
     if @r_capabilityId=6
     begin
     	set @r_capabilityId = 2
     end
IF 1 = @xmlTxt.exist('//App_GetAgentPropertiesRequest/association/entity')
				BEGIN
						-- first send a request to GetAssociatedEntities
declare @associatedEntitiesRequest xml
declare @associatedEntitiesRequestP xml
declare @associatedEntitiesResponse xml
select @associatedEntitiesRequest =ISNULL(@xmlTxt.query('App_GetAgentPropertiesRequest/association/entity'),'')
select @associatedEntitiesRequestP = ISNULL(@xmlTxt.query('App_GetAgentPropertiesRequest/processinginstructioninfo'),'')
select @associatedEntitiesRequest =CAST(( CAST(@associatedEntitiesRequest as nvarchar(max)) + CAST(@associatedEntitiesRequestP as nvarchar(max)) ) as xml)
--if @associatedEntitiesRequest='<entity _type_="6" applicationId="16" clientId="3" instanceId="16"/>'
--begin
	--set @associatedEntitiesRequest='<entity _type_="6" applicationId="37" clientId="3" instanceId="16"/>'
--end
set @associatedEntitiesRequest = ( select 4 '@expandLevel', @associatedEntitiesRequest --APPTYPE_ENTITY
for xml path('App_GetAssociatedEntities'), TYPE)
declare @associatedEntitiesTable table
(
	xmlval xml
)
DECLARE @idoc int
--select @associatedEntitiesRequest
Insert into @associatedEntitiesTable
exec dbo.GetAssociatedEntities @associatedEntitiesRequest
set @associatedEntitiesResponse = ISNULL((select top 1 xmlval from @associatedEntitiesTable),'<App_GenericResponse/>')
EXEC sp_xml_preparedocument @idoc OUTPUT, @associatedEntitiesResponse
INSERT  INTO @i_clientList
SELECT *
FROM OPENXML(@idoc, '//App_GenericResponse/response', 0)
WITH
(
	clientId		int				'entity/@clientId',
	clientName		nvarchar(255)	'entity/@clientName',
	appTypeId		int				'entity/@applicationId',
	appTypeName		varchar(255)	'entity/@appName',
	errorCode		int		'@errorCode',
	errorString		nvarchar(MAX)	'@errorString'
)
EXEC sp_xml_removedocument @idoc
END
SELECT @totalAgents = COUNT(*) from @i_clientList
BEGIN
 DECLARE @IdaActivityControl XML
 SET @r_excludeExtendedProperties = (SELECT  ref.value('@propertyLevel', 'int') AS Agent
                            FROM    @xmlTxt.nodes('App_GetAgentPropertiesRequest/filterOptions') R ( ref ))
 SET @r_getArchiverAgents = ISNULL((SELECT  ref.value('@getArchiverClients', 'int') AS Agent
                            FROM    @xmlTxt.nodes('App_GetAgentPropertiesRequest/filterOptions') R ( ref )), 0)
DECLARE @archiveAndOnePassSubclients TABLE (id INT)			-- This count is quite less, hardly 2-3. So table variable is fine.
DECLARE @clientStatus INTEGER = 0, @clientOSId INTEGER = 0;
--get application size from license table as a fallback
IF (@r_excludeExtendedProperties>=20)
BEGIN
	INSERT INTO #LicenseAppSizeTbl
	SELECT subclientid, AppSizeMB
	FROM (
			SELECT subclientid, AppsizeMB,
			ROW_NUMBER() OVER(PARTITION BY subclientid ORDER BY rankOrder ASC) AS rownum
			FROM(
					SELECT LC.subclientid,
						   LC.AppsizeMB,
						   (CASE LC.UsageType WHEN 1 THEN 1 WHEN 2 THEN 2 WHEN 4 THEN 3 WHEN 3 THEN 4 END) as rankOrder
				    FROM App_Application AAP WITH(NOLOCK)
						INNER JOIN JMBkpStats JB  WITH(NOLOCK)
							ON JB.appId=AAP.id AND JB.status IN (1,3,14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
							AND JB.dataStatus = 0 -- DATA_STATUS_VALID
						INNER JOIN 	Lic_CurrentUsage LC WITH(NOLOCK)
							ON LC.subclientid = AAP.ID
					WHERE LC.UsageType in (1,2,3,4)
			) TMP
		)LIC
	WHERE LIC.rownum=1
END
DECLARE @AgentCur CURSOR
SET @AgentCur = CURSOR
	FOR	(SELECT clientId,clientName,appTypeId, appTypeName,errorCode,errorString  FROM @i_clientList)
		OPEN @AgentCur
			FETCH NEXT FROM @AgentCur INTO @r_clientId , @r_clientName	, @r_appTypeID , @r_appTypeName,@errorCode,@errorString
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SELECT @clientStatus = status,
					   @clientOSId = simOperatingSystemId
				FROM APP_Client
				WHERE
					id = @r_clientId
IF	(@r_appTypeId = 22 OR @r_apptypeId = 80)
			BEGIN
				--running concurrent jobs introduced duplicates in APP_ClientProp table
				--adding DISTINCT is a temporary fix so that customers can browse and restore their data
				--correct fix is to make AppGetIndexingVersionForThisClient.sp execution mutually exclusive which will be made for next SP keeping in mind the regression
				SET @r_isAgentIndexingV2 =  ISNULL((SELECT DISTINCT (CASE WHEN ISNUMERIC(attrVal) = 1 THEN CAST(attrVal AS INT) ELSE 0 END) FROM APP_ClientProp WHERE componentNameId = @r_clientId AND attrName = 'IndexingV2_Oracle' AND modified = 0), 0)
			END
ELSE IF	(@r_appTypeId = 106)
			BEGIN
				SET @r_isAgentIndexingV2 =  ISNULL((SELECT DISTINCT (CASE WHEN ISNUMERIC(attrVal) = 1 THEN CAST(attrVal AS INT) ELSE 0 END) FROM APP_ClientProp WHERE componentNameId = @r_clientId AND attrName = 'IndexingV2_VSA' AND modified = 0), 0)
			END
			declare @associationEntity xml
		 	set @associationEntity = (select
    										@r_appTypeName as '@appName',
											@r_appTypeID as '@applicationId',
											@r_clientId as '@clientId',
											@r_clientName as '@clientName'
										for xml path('entity'), TYPE)
			if ( (len(@errorString)>0) Or @errorCode>0)
	begin
		-- Error Agent lookup failed from GetAssociatedEntities. So log it in output xml and proceed to next entry
		-- print 'Going to enditem'
		GOTO CONTINUE_NEXT_AGENT
	end
			declare @securityCheckError nvarchar(max)
			set @securityCheckError = ''
			exec [dbo].[Sec_DoesUserHaveRightsOnEntity] @associationEntity,@userId,@r_capabilityId,0,@localeId,@securityCheckError OUTPUT
			if (len(@securityCheckError)>0)
			BEGIN
     		-- Error instance lookup failed
     		set @errorCode = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			update @i_clientList set errorCode=@errorCode, errorString=@securityCheckError where clientId=@r_clientId and appTypeId=@r_appTypeID
     			GOTO CONTINUE_NEXT_AGENT
     		END
				IF @r_clientId < 2
                BEGIN
	              RETURN 1
                END
                SET  @r_clientName  = ISNULL((select name FROM APP_Client WHERE id = @r_clientId), '')
--IF @r_appTypeID <> CV_APPTYPE_COMMNET_SERVER AND @r_appTypeID <> CV_APPTYPE_COMMNET_AGENT
--BEGIN
DECLARE @id INTEGER;
DECLARE	@status INTEGER;
DECLARE @xmlText XML;
DECLARE @r_archiveGroup	INT;
DECLARE @r_simLicenseAppType INT;
DECLARE	@r_AgentVersion	NVARCHAR(MAX);
DECLARE @r_installDate	NVARCHAR(MAX);
DECLARE @r_appTypePathnameOrder	NVARCHAR(MAX);
DECLARE @r_appTypePathnameSeperator	NVARCHAR(MAX);
DECLARE	@r_appTypepathnameCaseSensitive	NVARCHAR(MAX);
DECLARE	@r_patchStatus	INT;
DECLARE	@r_appName	NVARCHAR(MAX);
--DECLARE @r_OSType	INT;
DECLARE @r_appTypePriority	NVARCHAR(MAX)
DECLARE @r_isMarkedDeleted	INT;
DECLARE @r_archiverStoragepolicy  NVARCHAR(MAX);
DECLARE @r_DataArchiveGroupId INT;
DECLARE @r_MonitorPolicyName NVARCHAR(MAX)
SET @id = (SELECT id
			FROM APP_IDAName
			WHERE clientId = @r_clientId
			AND appTypeId = @r_appTypeID)
SELECT 	ISNULL([Enable OCS],N'0') as enableOCS,
		ISNULL([new index if fail],N'0') as createIndexOnFail,
		ISNULL([create new index],N'1') as createIndexOnFull,
		ISNULL([IDA Description],N'') as userDescription,
		ISNULL([Enable Agent for SRM],'0') as isSRMEnabled, -- Common
		ISNULL([DM Max Simultaneous Data Recovery],'0') as maxSimultaneousStubRecoveries,
		ISNULL([DM Time Btw Recall],'0') as	timeBetweenRecalls,
		ISNULL([DM Time to wait after max],'0') as	timeToWaitAfterMax,
		ISNULL([Max cache size],'0') as	qsnapMaxCacheSize,
		ISNULL([Min cache size],'0') as	qsnapMinCacheSize,
		ISNULL([Enable Archive],0) as agentArchivePropertiesFlag,
		ISNULL([SRM Data Collection Enabled],'0') as isSRMdataCollectionEnabled,
		ISNULL([USER Snapshot Writer], '0') as useSnapShotWriter,
		ISNULL([Object Server Interval In Minutes], '5') as objectServerInterval,
		ISNULL([prepost username], '') as prepostUsername,
		ISNULL([Use Archiver Driver],'0') as isArchiverDriverEnabled,
		ISNULL([Explorer Based End User Recall Enabled],'0') as isExplorerBasedRecall,
		ISNULL([Enable Access Time Collection],'0') as isAccessTimeCollected,
		ISNULL([FS Honor Archiver Retention],'0') as honorArchiverRetention,
		ISNULL([Is Recall MP enabled],'0') as recallMPFlag,
		ISNULL([Recall MP],'0') as recallMP,
		ISNULL([Is true up enabled for Onepass],'0') as isTrueUpOptionEnabledForOnePass,
		ISNULL([Run true up after days for Onepass],'0') as runTrueUpJobAfterDaysForOnePass,
		ISNULL([Backup Configuration Nodes], '<App_BackupConfigurationNodes />') as backupConfigXML,
		ISNULL([Cloud DB Config],'<App_CloudDBConfig />') as cloudDBConfigXML
		INTO	#TEMP_APP_AgentPROP
FROM
(
		SELECT componentNameId, attrName, attrVal
			FROM APP_IDAProp
			WHERE componentNameId = @id
			AND	modified = 0
)	AS	Agents
PIVOT
(
		MAX(attrVal)
		FOR attrName IN
		(
			[Enable OCS],
			[new index if fail],
			[create new index],
			[IDA Description],
			[Enable Agent for SRM],
			[DM Max Simultaneous Data Recovery],
			[DM Time Btw Recall],
			[DM Time to wait after max],
			[Max cache size],
			[Min cache size],
			[Enable Archive],
			[SRM Data Collection Enabled],
			[USER Snapshot Writer],
			[Object Server Interval In Minutes],
			[prepost username],
			[Use Archiver Driver],
			[Explorer Based End User Recall Enabled],
			[Enable Access Time Collection],
			[FS Honor Archiver Retention],
			[Is Recall MP enabled],
			[Recall MP],
			[Is true up enabled for Onepass],
			[Run true up after days for Onepass],
			[Backup Configuration Nodes],
			[Cloud DB Config])
) AS pvt
SET @r_appTypePriority = ISNULL((SELECT priority
								FROM APP_IDAType
								WHERE type = @r_appTypeID AND priority <> N'Invalid Property'),'6')
-- Check if need to insert default values for the IDA
IF (SELECT COUNT(*) from #TEMP_APP_AgentPROP) = 0
BEGIN
	CREATE TABLE #TEMP_APP_AgentPROPS (
		enableOCS	NVARCHAR(MAX),
		createIndexOnFail	NVARCHAR(MAX),
		createIndexOnFull 	NVARCHAR(MAX),
		userDescription	NVARCHAR(MAX),
		isSRMEnabled	NVARCHAR(MAX), -- Common
		maxSimultaneousStubRecoveries	NVARCHAR(MAX),
		timeBetweenRecalls	NVARCHAR(MAX),
		timeToWaitAfterMax	NVARCHAR(MAX),
		qsnapMaxCacheSize	NVARCHAR(MAX),
		qsnapMinCacheSize	NVARCHAR(MAX),
		agentArchivePropertiesFlag	NVARCHAR(MAX),
		isSRMdataCollectionEnabled	NVARCHAR(MAX),
		useSnapShotWriter INT,
		objectServerInterval NVARCHAR(MAX),
		prepostUsername NVARCHAR(MAX),
        isArchiverDriverEnabled NVARCHAR(MAX),
		isExplorerBasedRecall NVARCHAR(MAX),
		isAccessTimeCollected NVARCHAR(MAX),
		honorArchiverRetention NVARCHAR(MAX),
		recallMPFlag INT,
		recallMP INT,
		isTrueUpOptionEnabledForOnePass NVARCHAR(MAX),
		runTrueUpJobAfterDaysForOnePass NVARCHAR(MAX),
		backupConfigXML					NVARCHAR(MAX),
		cloudDBConfigXML		NVARCHAR(MAX))
	-- No entry in APP_IDAProp table. SO we need to set the defualt values
	INSERT INTO #TEMP_APP_AgentPROPS values ('0','0','1','','0','0','0','0','0','0','0', '0','0','5','','0', '0', '0', '0','0','0','0','0','<App_BackupConfigurationNodes />','<App_CloudDBConfig />')
END
SET @status = ISNULL((SELECT status from APP_IDAName where clientId = @r_clientId and appTypeId = @r_appTypeID),0)
--Get Patch Info
SET @r_patchStatus = ISNULL((SELECT TOP 1 dbo.simGetBaseline(Baseline)
						FROM simInstalledPackages
						WHERE ClientId = @r_clientId
						AND simPackageID = @r_appTypeID),0)
--Windows FS property to indicate if NRDS or NRS is installed
IF @r_appTypeID = 1 OR
@r_appTypeID = 11 OR
@r_appTypeID = 42 OR
@r_appTypeID = 43 OR
@r_appTypeID = 33 OR
@r_appTypeID = 34 OR
@r_appTypeID = 19 OR
@r_appTypeID = 20 OR
@r_appTypeID = 21 OR
@r_appTypeID = 29
BEGIN
	-- Check if NDMP enabler is installed (NRDS = NDMP remote data server)
	-- * Duncan 2012/01/23: For 10.0, NRE is installed as part of the FS iDA advanced package. So all FS iDA will need
	--   to be valid NAS restore targets.
	-- * The errorString field of NDMPEnabler table is set to '' by AppGetLicense on success, so do the same for
	--   10.0 clients
	-- * The call to AppGetLicense was hard coding the clientId (first param) to 2. Not sure if this has worked for non CS clients
IF ((SELECT releaseId from APP_Client where id = @r_clientId) >= 15)
		insert into @NDMPEnabler values (1, 0, '')
	ELSE
insert into @NDMPEnabler exec AppGetLicense @r_clientId,1009
-- NAS archiving properties
-- * CV_STATUS_NAS bit is set when the NDMP agent is added to a client
-- * CV_STATUS_NON_NDMP bit is set when the FS agent is added under a NAS client
-- Technically here it might be fine to just check for the CV_STATUS_NON_NDMP bit, but it does not hurt to check both - the agent is checked also so we are covered.
-- And many years ago the CV_STATUS_NON_NDMP bit may not have been set properly always. So good to check both bits to determine if it is a NAS client.
	IF (EXISTS( SELECT appTypeId FROM GetAppTypesForAppGroup(22,0) where appTypeId = @r_appTypeId ) --'APPGRP_W2KFileSystem
	    OR EXISTS( SELECT appTypeId FROM GetAppTypesForAppGroup(34,0) where appTypeId = @r_appTypeId)) --'APPGRP_UnixFileSystem
AND (@clientStatus & (cast(0x8000000 as int) | cast(0x0080 as int))) <> 0
	BEGIN
		INSERT @TurboNASProperties VALUES(@r_appTypeId, N'', N'', N'', N'', N'', N'', N'', N'', N'')
		UPDATE @TurboNASProperties
		  SET http_cifs_addr     = ISNULL((Select attrval FROM APP_IDAProp where attrName=N'CELERA_CIFS_PATH' AND componentNameId = @id and modified = 0), N''),
		       nas_http_port     = ISNULL((Select attrval FROM APP_IDAProp where attrName=N'CELERA NAS HTTP PORT' AND componentNameId = @id and modified = 0), N'0'),
		       proxyStubPath     = ISNULL((Select attrval FROM APP_IDAProp where attrName=N'Proxy Stub Path' AND componentNameId = @id and modified = 0), N''),
		       primaryClientId   = ISNULL((Select attrval FROM APP_IDAProp where attrName=N'FPOLICY PRIMARY CLIENT' AND componentNameId = @id and modified = 0), N'0'),
		       secondaryClientId = ISNULL((Select attrval FROM APP_IDAProp where attrName=N'FPOLICY SECONDARY CLIENT' AND componentNameId = @id and modified = 0), N'0'),
		       proxyClientId	 = ISNULL((Select attrval FROM APP_IDAProp where attrName=N'Turbo NAS Proxy Client' AND componentNameId = @id and modified = 0), N'0')
				WHERE appTypeID = @r_appTypeID
		UPDATE @TurboNASProperties
				SET primaryClientName = ISNULL(( Select name from app_client where id = primaryClientId), N''),
				    secondaryClientNAme   = ISNULL(( Select name from app_client where id = secondaryClientId), N''),
				    proxyClientName   = ISNULL(( Select name from app_client where id = proxyClientId), N'')
				    WHERE appTypeID = @r_appTypeID
--				select * from @TurboNASProperties
	END
END
SET @r_archiveGroup = ISNULL((select TOP 1 id
							FROM APP_Application
							WHERE clientId = @r_clientId
							AND appTypeId = @r_appTypeID AND subclientName = 'IndexingSubclient' ),0)
SET @r_DataArchiveGroupId = ISNULL((select TOP 1 dataArchGrpID
							FROM APP_Application
							WHERE clientId = @r_clientId
							AND appTypeId = @r_appTypeID AND subclientName = 'IndexingSubclient' ),0)
SET @r_archiverStoragepolicy  = ISNULL((SELECT name from ArchGroup where id = @r_DataArchiveGroupId), '')
SET @r_MonitorPolicyName = ISNULL((SELECT MonitorPolicyName FROM APP_MonitoringPolicy WHERE monitorPolicyId =
									(Select cast (attrval as int) FROM APP_IDAProp where attrName=N'Recall MP' AND componentNameId = @id and modified = 0)), N'')
-- Get License and version info
SET @r_simLicenseAppType = (SELECT TOP 1 LU.LicType
      		FROM LicUsage LU, simLicApptypeV2 SL
      			WHERE LU.CId = @r_clientId AND LU.LicType NOT IN (71, 10, 26) AND LU.appType = @r_appTypeID AND LU.opType = 'Install'
      				AND SL.id = LU.LicType
      		ORDER BY LU.id DESC)
--getVersionAndPatchInfoForAppType() EXTENDED
DELETE @VersionAndPatch -- Deleting any rows already inserted. Otherwise it will always get top 1 row which will have the same result for all the app type
INSERT INTO @VersionAndPatch
EXEC simGetVersionInfo @r_clientId,@r_appTypeID,@r_simLicenseAppType
SELECT TOP 1 @r_AgentVersion = REPLACE((CASE WHEN releaseId > 14 THEN (Release + Build) ELSE (Release + '.' + Build) END),' ',''),
				@r_installDate = ISNULL((CAST(installDate as NVARCHAR(MAX))),'0')
					FROM @VersionAndPatch
SELECT @r_AgentVersion = ISNULL((SELECT attrval FROM APP_ClientProp WHERE componentNameId = @r_clientId AND attrName = 'SP Version Info' AND modified = 0),@r_AgentVersion)
-- Get Directory Order, Demiliter and IsCaseSensitive flags
SELECT
		@r_appTypePathnameOrder = CASE WHEN dirOrder <> N'Invalid Property' THEN dirOrder END,
		@r_appTypePathnameSeperator = CASE WHEN dirDelim <> N'Invalid Property' THEN dirDelim END,
		@r_appTypepathnameCaseSensitive = CASE WHEN caseSensitivity <> N'Invalid Property' THEN caseSensitivity END
			FROM APP_iDAType
			WHERE type = @r_appTypeID
IF (0x00002 = (@status & 0x00002))
	SET @r_isMarkedDeleted = 1
ELSE
	SET @r_isMarkedDeleted = 0
	--Get activity control
	SET @IdaActivityControl = '<entity clientId="' + STR(@r_clientId) + '" appTypeId="' + STR(@r_appTypeID) + '"/>'
	EXEC [dbo].[APPGetActivityControlXML]
	@xmlText = @IdaActivityControl OUTPUT
	INSERT INTO @ActivityControl values(@r_appTypeID,@IdaActivityControl)
-- GET OS type
--SET @r_OSType = ISNULL((SELECT attrVal FROM APP_ClientProp WHERE attrName = 'Sim OS Info' and componentNameId = @r_clientId) ,0)
------------------------------------------------------------
-------  GET AGENT SPECIFIC INFORMATION  -------------------
-------  START EXTENDED PROPERTIES FETCH -------------------
------------------------------------------------------------
IF @r_excludeExtendedProperties = 10
	GOTO SKIP_EXTENDED
--Get security user groups
DECLARE @idaSecurity XML
				SET @idaSecurity = '<entity clientId="' + STR(@r_clientId) + '" appTypeId="' + STR(@r_appTypeID) + '"/>'
				EXEC [dbo].[APPGetEntitySecurityXML]
				@xmlText = @idaSecurity OUTPUT
--Get new security XML
DECLARE @idaSecurityNewXML XML
--We need to pass the APP_Idaname id instead of r_apptypeid
EXEC sec_getSecurityForEntity @userId, @idaSecurityNewXML OUTPUT, 3, @r_clientId, 4, @r_appTypeId
INSERT INTO @userGroups VALUES (@r_appTypeID, @idaSecurity, @idaSecurityNewXML)
-- lookupNASProperties: (NDMP properties)
-- * CV_APP_TYPE_NAS_FS is the NDMP agent.
-- * CV_STATUS_NAS bit is set when the NDMP agent is added to a client
-- * CV_STATUS_NON_NDMP bit is set when the FS agent is added under a NAS client
-- The call to APPGetAgentProperties is using the NDMP agent, so here checking just the CV_STATUS_NAS bit seems correct.
-- The check for CV_APPTYPE_WINDOWS_FILESYSTEM and CV_APPTYPE_WINDOWS_FILESYSTEM is not necessary and can be removed.
IF	((@r_appTypeId = 13)
	OR		-- For archiving solution, we need to send NAS related properties (vendor, firmware revision, etc.) along with Win / Linux FS to show in Details page.
(@r_getArchiverAgents = 1 AND ((@clientStatus & CAST(0x8000000 AS INT) <> 0) OR (@clientStatus & 0x0080 <> 0)) AND @r_appTypeID IN (33, 29)))
BEGIN
	INSERT INTO @NASProperties
EXEC APPGetAgentProperties @r_clientId,13,2
	UPDATE @NASProperties
	SET appTypeId = @r_appTypeId		-- Set against FS so that response is against FS agent.
END
-- lookupNonNDMPAgentFSProperties (only for Archiver solution).
IF (@r_getArchiverAgents = 1) AND (@clientOSId = 19) AND (@r_appTypeID IN (33, 29))
		INSERT INTO @NASProperties (appTypeId, vendor)
			VALUES (@r_appTypeID, 'Generic')
--lookupNetwareFSProperties
IF	@r_appTypeId = 86 OR
@r_appTypeId = 12
BEGIN
	INSERT INTO @NetwareProperties
		EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupNDSProperties
IF	@r_appTypeId = 10
BEGIN
	INSERT INTO @NDSProperties
		EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupNTAPDMProperties
IF @r_appTypeId = 73
BEGIN
	INSERT INTO @NTAPDMProperties
		EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupFSDataMigratorProperties
IF @r_appTypeId = 58
BEGIN
	INSERT INTO @FSDataMigratorProperties
		EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupDataClassificationProperties
IF @r_appTypeId = 85
BEGIN
		INSERT INTO @DataClassificationProperties
			EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
-- lookupUNIXDataMigratorProperties
--IF @r_appTypeId = CV_APPTYPE_UNIX_FS_DATA_MIGRATOR
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
--lookupNetwareDataMigratorProperties
IF @r_appTypeId = 83
BEGIN
		INSERT INTO @NetwareDMProperties
			EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupWin2KProperties
IF	@r_appTypeId = 11 OR
@r_appTypeId = 91	OR
@r_apptypeId = 93
BEGIN
	INSERT INTO @Win2KProperties
		EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
-- lookupWinDotNet32Properties
--IF	@r_appTypeId = LEGACY_CV_APPTYPE_WIN2003_32BIT
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupWinDotNet64Properties
--IF	@r_appTypeId = LEGACY_CV_APPTYPE_WIN2003_64BIT
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupWinXP32Properties
--IF	@r_appTypeId = CV_APPTYPE_WINDOWS_FILESYSTEM
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupWinXP64Properties
--IF	@r_appTypeId = LEGACY_CV_APPTYPE_XP64_BIT
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupRecoveryDirectorProperties
--IF	@r_appTypeId = CV_APPTYPE_RECOVERY_DIRECTOR
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupProxyHostProperties
--IF	@r_appTypeId = LEGACY_CV_APPTYPE_PROXYHOST OR
--		@r_appTypeId = CV_APPTYPE_PROXYHOST_IMAGELEVEL
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupSanVolProperties
--IF	@r_appTypeId = UNUSED_CV_APPTYPE_24
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupSanVolUnixProperties
--IF	@r_appTypeId = UNUSED_CV_APPTYPE_48
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupReplicationProperties
IF	@r_appTypeId = 50	OR
@r_appTypeId = 47
BEGIN
	INSERT INTO @Credentials
		EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
	UPDATE @Credentials
	SET	Servername = (case appName
WHEN 9 THEN Servername
WHEN 15 THEN Servername
WHEN 53 THEN Servername
						ELSE	N'' END)
END
--lookupLotusNotesDocProperties
IF	@r_appTypeId = 7 OR
@r_appTypeId = 52 OR
@r_appTypeId = 60 OR
@r_appTypeId = 90
BEGIN
	INSERT INTO @LotusNotesDocProperties
		EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupLotusNotesDbProperties
--IF	@r_appTypeId = UNUSED_CV_APPTYPE_6 OR
--		@r_appTypeId = UNUSED_CV_APPTYPE_51 OR
--		@r_appTypeId = CV_APPTYPE_LOTUS_DOMINO6_DATABASE OR
--		@r_appTypeId = CV_APPTYPE_UNIX_LOTUSNOTES6_DB
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupGranADProperties
IF	@r_appTypeId = 41
BEGIN
	INSERT INTO @GranADProperties
		EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
-- lookupFileSystemProperties
--IF	@r_appTypeId = UNUSED_CV_APPTYPE_1
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupFileReplicationProperties
IF 	@r_appTypeId = 84 OR
@r_appTypeId = 107
BEGIN
	INSERT INTO @FLRProperties
		EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
	INSERT INTO @Credentials
		SELECT	id,(LEFT(attrName,PATINDEX('% %',attrName)-1)),
				(LEFT(attrVal, charindex(CHAR(0x15),attrVal)-1) ),
				(RIGHT(attrVal, LEN(attrVal) - charindex(CHAR(0x15), attrVal, charindex(CHAR(0x15),attrVal)+1)))
				 FROM APP_IDAProp
			WHERE attrName like '%credentials%' AND modified = 0
	UPDATE @Credentials
	SET	Servername = (case appName
WHEN 9 THEN Servername
WHEN 15 THEN Servername
WHEN 53 THEN Servername
						ELSE	N'' END)
END
--lookupSharepointDocProperties
IF 	@r_appTypeId = 46 OR
@r_appTypeId = 78 OR
@r_appTypeId = 89
BEGIN
	INSERT INTO @SharePointProp
		EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupExchangePublicFolderProperties
IF	@r_appTypeId = 82 OR
@r_appTypeId = 35 OR
@r_appTypeId = 44 OR
@r_appTypeId = 55
BEGIN
	INSERT INTO @ExchangePublicFolderProp
		EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupDataMigratorProperties
IF	@r_appTypeId = 45 OR
@r_appTypeId = 56 OR
@r_appTypeId = 57
BEGIN
	INSERT INTO @DataMigratorProp
		EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupExchangeArchiverProperties
IF	@r_appTypeId = 67 OR
@r_appTypeId = 68
BEGIN
	INSERT INTO @ExchangeArchiverProp
		EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupExchangeMBProperties
IF	@r_appTypeId = 8 OR
@r_appTypeId = 14 OR
@r_appTypeId = 54 OR
@r_appTypeId = 105 OR
@r_appTypeId = 137 OR
@r_appTypeId = 53
BEGIN
IF @r_appTypeId <> 53
BEGIN
	INSERT INTO @ExchangeMBProp
		EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
	--REMOVE EMPTY VALUE MARKER
	UPDATE @ExchangeMBProp SET ADServerList = '' WHERE ADServerList = '`'
    END
IF  @r_appTypeId = 137 OR
@r_appTypeId = 53
	BEGIN
		INSERT @onePassProperties VALUES(@id, @r_appTypeId, N'', 0, N'', N'')
		UPDATE @onePassProperties
			SET memberServers = (SELECT REPLACE(attrVal,'UTF-8','UTF-16') FROM APP_IDAProp WHERE attrName=N'OnePass Member Servers' AND componentNameId = @id and modified = 0),
			indexServerId = (SELECT REPLACE(attrVal,'UTF-8','UTF-16') FROM APP_IDAProp WHERE attrName=N'OnePass Index Server' AND componentNameId = @id and modified = 0)
		WHERE appTypeID = @r_appTypeId AND componentNameId = @id
		UPDATE	@onePassProperties
			SET memberServers = CAST((
		SELECT C.id 'client/@clientId', C.name 'client/@clientName', G.id 'client/@clientGroupId', G.name 'client/@clientGroupName', ref.value('client[1]/@_type_', 'INT') 'client/@_type_'
		FROM @onePassProperties
		JOIN
		(
			SELECT CAST(memberServers AS XML) ms, componentNameId id
			FROM @onePassProperties
		) T ON T.id = componentNameId AND componentNameId = @id
		CROSS APPLY T.ms.nodes('App_MemberServers/memberServers') R(ref)
LEFT OUTER JOIN APP_Client C (NOLOCK) ON C.id = ref.value('client[1]/@clientId', 'INT') AND ref.value('client[1]/@_type_', 'INT') = 3
LEFT OUTER JOIN APP_ClientGroup G (NOLOCK) ON G.id = ref.value('client[1]/@clientGroupId', 'INT') AND ref.value('client[1]/@_type_', 'INT') = 28
		FOR XML PATH('memberServers'),
		ROOT('App_MemberServers')) AS NVARCHAR(MAX))
		WHERE componentNameId = @id
		UPDATE @onePassProperties
			SET indexServerName = ( SELECT name FROM app_client WHERE id = indexServerId)
		WHERE appTypeID = @r_appTypeId AND componentNameId = @id
		UPDATE @onePassProperties
			SET recallService = (SELECT attrval FROM APP_IDAProp WHERE attrName=N'Recall Service' AND componentNameId = @id and modified = 0)
		WHERE appTypeID = @r_appTypeId AND componentNameId = @id
		INSERT @exchangeOnePassProperties VALUES(@r_appTypeId, N'', N'', N'', N'', N'', N'', N'', NULL, N'', 0, 0, N'', N'')
		UPDATE @exchangeOnePassProperties
			SET servers = ISNULL((SELECT attrval FROM APP_IDAProp(NOLOCK) WHERE attrName=N'Exchange OnePass Servers' AND componentNameId = @id and modified = 0), ''),	--CANNOT HAVE NULL VALUE OR SPLITSTRING WILL HANG
azureAppId =  ISNULL((SELECT attrVal FROM App_IDAProp(NOLOCK) WHERE attrName= 'Azure App Id'  AND componentNameId = @id and modified = 0), ''),
azureSecretKey =  ISNULL((SELECT attrVal FROM App_IDAProp(NOLOCK) WHERE attrName='Azure App Secret Key'  AND componentNameId = @id and modified = 0), ''),
azureTentanName =  ISNULL((SELECT attrVal FROM App_IDAProp(NOLOCK) WHERE attrName='Azure Tenant URL'  AND componentNameId = @id and modified = 0), ''),
environmentType = ISNULL((SELECT attrVal FROM App_IDAProp(NOLOCK) WHERE attrName='Exchange Environment Type' AND  componentNameId = @id and modified = 0), ''),
msCloudRegion = ISNULL((SELECT attrVal FROM App_IDAProp(NOLOCK) WHERE attrName ='MSCloud Region Type' AND componentNameId = @id and modified = 0), msCloudRegion),
discoveryFilter = ISNULL((SELECT attrVal FROM APP_IDAProp(NOLOCK) WHERE attrName ='Discovery Regex Filter'AND componentNameId = @id and modified = 0), ''),
modernAuthEnabled  = ISNULL((SELECT attrVal FROM APP_IDAProp(NOLOCK) WHERE attrName ='Exchange Modern Auth'AND componentNameId = @id and modified = 0), 0)
		WHERE appTypeID = @r_appTypeId
		--REMOVE EMPTY VALUE MARKER
		UPDATE @exchangeOnePassProperties
			SET servers = '' WHERE servers = '`'
		UPDATE @exchangeOnePassProperties
			SET accounts = (SELECT (
				SELECT po.query('.')
				FROM
				(
					SELECT CAST(REPLACE(attrVal,'UTF-8','UTF-16') AS XML) attrVal
					FROM APP_IDAProp(NOLOCK) WHERE attrName=N'Exchange OnePass Admin Accounts' AND componentNameId = @id and modified = 0
				) PROP
				CROSS APPLY PROP.attrVal.nodes('./App_ExchangeAdminAccounts/adminAccounts') P(po)
				FOR XML PATH(''),TYPE))
		WHERE appTypeID = @r_appTypeId
		AND accounts IS NOT NULL
		--ADD DUMMY DATA WHEN ACCOUNTS IS EMPTY TO PREVENT ERROR IN XML MODIFY
		UPDATE @exchangeOnePassProperties
			SET accounts = '<App_ExchangeAdminAccounts></App_ExchangeAdminAccounts>'
		WHERE accounts IS NULL
		--REMOVE PASSWORD FIELDS
		UPDATE @exchangeOnePassProperties
			SET accounts.modify('delete //@password')
		WHERE appTypeID = @r_appTypeId
	    --Update EWS connection settings
	    UPDATE @exchangeOnePassProperties
	            SET useEWS = po.value('@bUseEWS[1]', 'int'),
					ewsConnectionUri = po.value('@ewsConnectionUrl[1]', 'varchar(256)')
	            FROM
	            (
	                SELECT CAST(REPLACE(attrVal,'UTF-8','UTF-16') AS XML) attrVal
	                FROM APP_IDAProp(NOLOCK)
	                WHERE attrName=N'EWS Connection Details' AND componentNameId = @id and modified = 0
	            ) PROP
	            CROSS APPLY PROP.attrVal.nodes('./App_EWSConnectionDetails') P(po)
	    WHERE	appTypeID = @r_appTypeId
				AND useEWS IS NOT NULL
				AND ewsConnectionUri IS NOT NULL
		--ADD DUMMY DATA WHEN CONNECTION INFO IS EMPTY
		UPDATE @exchangeOnePassProperties
	            SET useEWS = '0',
					ewsConnectionUri = ''
		WHERE 	useEWS IS NULL
				AND ewsConnectionUri IS NULL
		--Update DiscoveryInfo
		UPDATE @exchangeOnePassProperties
			set discoverInfo =
			(SELECT (
				SELECT po.query('.')
				FROM
				(
					SELECT CAST(REPLACE(attrVal,'UTF-8','UTF-16') AS XML) attrVal
					FROM APP_IDAProp(NOLOCK) WHERE attrName=N'Discovery State' AND componentNameId = @id and modified = 0
				) PROP
				CROSS APPLY PROP.attrVal.nodes('./App_Office365DiscoverState') P(po)
			FOR XML PATH(''),TYPE))
		--ADD DUMMY DATA WHEN discovery state is empty
		UPDATE @exchangeOnePassProperties
			SET discoverInfo = '<App_Office365DiscoverState></App_Office365DiscoverState>'
		WHERE discoverInfo IS NULL
		--Update Azure Connections here
		UPDATE @exchangeOnePassProperties
			SET azureAppList = (SELECT (
				SELECT po.query('.')
				FROM
				(
					SELECT CAST(REPLACE(attrVal,'UTF-8','UTF-16') AS XML) attrVal
					FROM APP_IDAProp(NOLOCK) WHERE attrName=N'Exchange Azure Connections' AND componentNameId = @id and modified = 0
				) PROP
				CROSS APPLY PROP.attrVal.nodes('./App_Office365AzureConnections/azureApps') P(po)
				FOR XML PATH(''),TYPE))
		WHERE appTypeID = @r_appTypeId
		--ADD DUMMY DATA WHEN azure connections IS EMPTY TO PREVENT ERROR IN XML MODIFY
		UPDATE @exchangeOnePassProperties
			SET azureAppList = '<azureAppList></azureAppList>'
		WHERE azureAppList IS NULL
		--REMOVE PASSWORD FIELDS
		UPDATE @exchangeOnePassProperties
			SET azureAppList.modify('delete //@azureAppKeyValue')
		WHERE appTypeID = @r_appTypeId
	END
END
-- lookupImageWinFSProperties
--IF	@r_appTypeId = CV_APPTYPE_IMAGE_WINFS_IDA
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupImageUNIXFSProperties
--IF	@r_appTypeId = CV_APPTYPE_IMAGE_UNIXFS_IDA
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
--lookupNetwareGroupwiseProperties
IF	@r_appTypeId = 71
BEGIN
	INSERT INTO @NetwareGroupWise
		EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupSybaseProperties
--IF	@r_appTypeId = CV_APPTYPE_SYBASE OR
--		@r_appTypeId = CV_APPTYPE_POSTGRESS OR
--		@r_appTypeId = CV_APPTYPE_SYBASE_IQ OR
--		@r_appTypeId = CV_APPTYPE_EXTERNAL_DATA_CONNECTOR
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
--lookupMySqlProperties
IF	@r_appTypeId = 104
BEGIN
	INSERT INTO @MySQLProp
	EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupPostgreSqlProperties
IF	@r_appTypeId = 125
BEGIN
	INSERT INTO @PostgreSQLProp
	EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupExchangeDBProperties
IF	@r_appTypeId = 9 OR
@r_appTypeId = 15 OR
@r_appTypeId = 53 OR
@r_appTypeId = 69
BEGIN
		INSERT INTO @ExchangeDBProp
			EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupFastraxForExchangeProperties
IF	@r_appTypeId = 27 OR
@r_appTypeId = 31
BEGIN
		INSERT INTO @FastraxForExch
			EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupSharePointDBProperties
IF	@r_appTypeId = 32
BEGIN
		INSERT INTO @SharepointDBProp
			EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupVirtualServerProperties
--IF	@r_appTypeId = CV_APPTYPE_VIRTUAL_SERVER
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
--lookupInformixProperties
--IF	@r_appTypeId = CV_APPTYPE_INFORMIX
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
--lookupOracle8Properties
IF	@r_appTypeId = 22 OR
@r_apptypeId = 80
BEGIN
	INSERT INTO @Oracle8Prop
			EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupDb2Properties
IF	@r_appTypeId = 37 OR
@r_appTypeId = 62 OR
@r_appTypeId = 103
BEGIN
	--Currently there are no agent specific properties, so empty
	INSERT INTO  @db2Prop
		EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupSQL61Properties
IF	@r_appTypeId = 81
BEGIN
	INSERT INTO @SQL61Prop
			EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
END
--lookupDistributedClusterIdaProperties
DECLARE @distributedClusterType NVARCHAR(MAX)
DECLARE @clusterTypeAttrName NVARCHAR(64) = 'Distributed Cluster Type'
IF @r_appTypeId = 64
BEGIN
	SELECT	@distributedClusterType = attrVal
	FROM	APP_IDAName N INNER JOIN APP_IDAProp P
		ON	N.id = P.componentNameId
	WHERE	N.clientId = @r_clientId
		AND	N.appTypeId = @r_appTypeId
		AND	P.modified = 0
		AND P.attrName = @clusterTypeAttrName
	IF ISNULL(@distributedClusterType,0) = 0
		SELECT @distributedClusterType = CAST(ATTRVAL  AS INT)
		FROM APP_ClientProp (NOLOCK)
		WHERE componentNameId = @r_clientId AND attrName = 'Index Server Type'
	INSERT INTO @propertyList
	VALUES(@clusterTypeAttrName, @distributedClusterType)
END
--lookupCloudAppType
DECLARE @cloudInstacneTypeVal NVARCHAR(MAX)
DECLARE @cloudInstacneTypeName NVARCHAR(64) = 'Cloud Type of the Insatcne'
IF @r_appTypeId = 134
BEGIN
	SELECT	@cloudInstacneTypeVal = attrVal
	FROM	APP_IDAName N INNER JOIN APP_IDAProp P
		ON	N.id = P.componentNameId
	WHERE	N.clientId = @r_clientId
		AND	N.appTypeId = @r_appTypeId
		AND	P.modified = 0
		AND P.attrName = @cloudInstacneTypeName
	INSERT INTO @propertyList
	VALUES(@cloudInstacneTypeName, @cloudInstacneTypeVal)
END
--lookupUnixProxyHostProperties
--IF	@r_appTypeId = LEGACY_CV_APPTYPE_UNIX_PROXYHOST OR
--	@r_appTypeId = CV_APPTYPE_PROXYHOST_IMAGELEVEL_UNIX OR
--BEGIN
		--Currently there are no agent specific properties, so empty
--END
--lookupLINUXProperties
--IF	@r_appTypeId = CV_APPTYPE_LINUX_FS
--BEGIN
		--Currently there are no agent specific properties, so empty
--END
--lookupSolarisProperties
--IF	@r_appTypeId = CV_APPTYPE_SOLARIS_FS OR
--		@r_appTypeId = CV_APPTYPE_FREE_BSD
--BEGIN
		--Currently there are no agent specific properties, so empty
--END
--lookupSGIProperties
--IF	@r_appTypeId = CV_APPTYPE_SGI_FS
--BEGIN
		--Currently there are no agent specific properties, so empty
--END
--lookupAppleProperties
--IF	@r_appTypeId = CV_APPTYPE_APPLEMAC_FS
--BEGIN
		--Currently there are no agent specific properties, so empty
--END
--lookupHPUXProperties
--IF	@r_appTypeId = CV_APPTYPE_HPUX_FS
--BEGIN
		--Currently there are no agent specific properties, so empty
--END
--lookupAIXProperties
--IF	@r_appTypeId = CV_APPTYPE_AIX_FS
--BEGIN
		--Currently there are no agent specific properties, so empty
--END
--lookupUNIXTru64Properties
--IF	@r_appTypeId = CV_APPTYPE_UNIX_TRU64_FS_64
--BEGIN
		--Currently there are no agent specific properties, so empty
--END
-- lookupAzureADProperties
IF	@r_appTypeId = 139
BEGIN
	INSERT INTO @AzureADProperties
		EXEC APPGetAgentProperties @r_clientId,@r_apptypeID,2
	--ADD DUMMY DATA WHEN azure connections IS EMPTY TO PREVENT ERROR IN XML MODIFY
	UPDATE @AzureADProperties
		SET azureAppList = '<azureAppList></azureAppList>'
	WHERE azureAppList IS NULL
	--REMOVE PASSWORD FIELDS
	UPDATE @AzureADProperties
		SET azureAppList.modify('delete //@azureAppKeyValue')
	--ADD DUMMY DATA WHEN ACCOUNTS IS EMPTY TO PREVENT ERROR IN XML MODIFY
	UPDATE @AzureADProperties
		SET serviceAccounts = '<serviceAccounts></serviceAccounts>'
	WHERE serviceAccounts IS NULL
	--REMOVE PASSWORD FIELDS
	UPDATE @AzureADProperties
		SET serviceAccounts.modify('delete //@password')
END
IF @r_getArchiverAgents = 1
BEGIN
	DECLARE @r_DSClientId VARCHAR(10) = ''
	DECLARE @r_DSListSubclient VARCHAR(MAX) = ''
	DECLARE @r_DSListBackupset VARCHAR(MAX) = ''
	SELECT @r_DSClientId = attrVal
	FROM APP_ClientProp (NOLOCK)
	WHERE
		componentNameId = @r_clientId
		AND attrName = N'Indexing datasource id'
		AND modified = 0
	SET @r_DSListSubclient = ISNULL((
										SELECT DISTINCT SP.attrVal + ','
										FROM APP_SubclientProp SP(NOLOCK)
											INNER JOIN APP_Application A(NOLOCK)
												ON SP.componentNameId = A.id
												AND SP.attrName = N'Indexing datasource id'
												AND SP.cs_attrName = CHECKSUM(N'Indexing datasource id')
												AND SP.modified = 0
												AND A.clientId = @r_clientId
										FOR XML PATH('')
									), '')
	SET @r_DSListBackupSet = ISNULL((
										SELECT DISTINCT BP.attrVal + ','
										FROM APP_BackupsetProp BP(NOLOCK)
											INNER JOIN APP_Application A(NOLOCK)
												ON BP.componentNameId = A.backupset
												AND BP.attrName = N'Indexing datasource id'
												AND BP.modified = 0
												AND A.clientId = @r_clientId
										FOR XML PATH('')
									), '')
	INSERT INTO #archiveClientInfo
		VALUES (@r_clientId, @r_DSClientId, @r_DSListSubclient, @r_DSListBackupSet, (@r_DSListSubclient + @r_DSListBackupSet + @r_DSClientId))
END
------------------------------------------------------------
-------  END EXTENDED PROPERTIES FETCH ---------------------
------------------------------------------------------------
SKIP_EXTENDED:
-- If NAS CLIENT then update r_appNAme to name and not display name
IF @r_appTypeID IN (33,29) AND EXISTS(SELECT id from App_client where id = @r_clientId and  (status & ( cast(0x8000000 as int) | cast(0x0080 as int) ) ) > 0)
BEGIN
	SET @r_appName = ISNULL((SELECT TOP 1 name
							FROM app_idaType
							WHERE Type  = @r_appTypeID),N'Default Application Type Name')
END
ELSE
BEGIN
	SET @r_appName = ISNULL((SELECT  TOP 1 displayName
							FROM app_idaType
							WHERE Type  = @r_appTypeID),N'Default Application Type Name')
END
IF (SELECT COUNT(*) from #TEMP_APP_AgentPROP) > 0
BEGIN
	INSERT INTO @FinalAgentPropList
		select @r_appTypeID,@r_appName,I.enableOCS,I.createIndexOnFull,I.createIndexOnFail,I.userDescription,
		I.isSRMEnabled,'',@r_appTypePriority,'',@r_archiveGroup,I.maxSimultaneousStubRecoveries,
		I.timeBetweenRecalls,I.timeToWaitAfterMax,I.qsnapMaxCacheSize,I.qsnapMinCacheSize,
		I.agentArchivePropertiesFlag,@r_AgentVersion,@r_installDate,
		(@r_appTypePathnameOrder),@r_appTypePathnameSeperator, @r_appTypepathnameCaseSensitive,@r_patchStatus,
		@r_isMarkedDeleted,I.isSRMdataCollectionEnabled, @r_clientId, @r_clientName,@r_archiverStoragepolicy,@r_DataArchiveGroupId, I.useSnapShotWriter, I.objectServerInterval, I.prepostUsername, I.isArchiverDriverEnabled, I.isExplorerBasedRecall, I.isAccessTimeCollected, I.honorArchiverRetention, ''
		, I.recallMPFlag ,I.recallMP,@r_MonitorPolicyName,I.isTrueUpOptionEnabledForOnePass,I.runTrueUpJobAfterDaysForOnePass, I.backupConfigXML, @r_isAgentIndexingV2,
		--, @r_OSType
		I.cloudDBConfigXML, 0, 0, 0, 0, 0, 0, NULL,3,0,''
		 FROM #TEMP_APP_AgentPROP I
END
ELSE
BEGIN
	INSERT INTO @FinalAgentPropList
		select @r_appTypeID,@r_appName,I.enableOCS,I.createIndexOnFull,I.createIndexOnFail,I.userDescription,
		I.isSRMEnabled,'',@r_appTypePriority,'',@r_archiveGroup,I.maxSimultaneousStubRecoveries,
		I.timeBetweenRecalls,I.timeToWaitAfterMax,I.qsnapMaxCacheSize,I.qsnapMinCacheSize,
		I.agentArchivePropertiesFlag,@r_AgentVersion,@r_installDate,
		(@r_appTypePathnameOrder),@r_appTypePathnameSeperator, @r_appTypepathnameCaseSensitive,@r_patchStatus,
		@r_isMarkedDeleted,I.isSRMdataCollectionEnabled, @r_clientId, @r_clientName, @r_archiverStoragepolicy, @r_DataArchiveGroupId,I.useSnapShotWriter, I.objectServerInterval, I.prepostUsername, I.isArchiverDriverEnabled, I.isExplorerBasedRecall, I.isAccessTimeCollected, I.honorArchiverRetention, ''
		,I.recallMPFlag ,I.recallMP,@r_MonitorPolicyName,I.isTrueUpOptionEnabledForOnePass,I.runTrueUpJobAfterDaysForOnePass, I.backupConfigXML, @r_isAgentIndexingV2,
		--, @r_OSType
		I.cloudDBConfigXML, 0, 0, 0, 0, 0, 0, NULL,3,0,''
		 FROM #TEMP_APP_AgentPROPS I
END
UPDATE @FinalAgentPropList
--SET enableOCS = (case enableOCS
--     		WHEN '1' THEN 'true'
--     		ELSE 'false' END),
--      createIndexOnFail = (case	createIndexOnFail
--     		WHEN '1' THEN 'true'
--     		ELSE 'false' END),
--      createIndexOnFull = (case	createIndexOnFull
--     		WHEN '1' THEN 'true'
--     		ELSE 'false' END),
--      isSRMEnabled = (case	isSRMEnabled
--     		WHEN '1' THEN 'true'
--     		ELSE 'false' END),
    SET requiresMoreConfig = (case
     		WHEN (@status & 0x08000) = 0x08000 THEN '1'
     		ELSE '0' END),
     isNDMPRestore = (case
     		WHEN (SELECT TOP 1 propValue from @NDMPEnabler) = 1 THEN '1'
     		ELSE '0' END),
	 disableHonorArchiverRetention = (case
			WHEN honorArchiverRetention = '1' THEN '1'
			WHEN	(SELECT count(*) FROM jmbkpstats(nolock) WHERE bkpAttributes & 0x80000000000000 = 0x80000000000000/*Turbo BkpAttribute*/ and opType = 14/*SynthFull*/ and
					appId in(SELECT id FROM App_Application(nolock) WHERE clientId = @r_clientId/*ClientId to check*/ and appTypeId= @r_appTypeID/*AppTypeToCheck*/) ) > 0 THEN '1'
			ELSE '0' END)
--     agentArchivePropertiesFlag = (case	agentArchivePropertiesFlag
--     		WHEN '1' THEN '2'
--     		ELSE '0' END)
 WHERE appTypeID = @r_appTypeID
IF (@totalAgents = 1 OR (@clientStatus & (cast(0x8000000 as int) | cast(0x0080 as int))) > 0) AND (@r_excludeExtendedProperties >= 20)
 BEGIN
	IF(@r_getArchiverAgents = 1)
	BEGIN
		DELETE FROM @archiveAndOnePassSubclients
		INSERT INTO @archiveAndOnePassSubclients			-- This will be very less in number. So using table variable.
			SELECT APP.id FROM APP_Application APP WITH(NOLOCK)
					INNER JOIN APP_BackupsetProp ABP WITH(NOLOCK)
					ON APP.backupset = ABP.componentNameId
						WHERE APP.clientId = @r_clientId
							AND APP.appTypeId = @r_appTypeID
							AND ABP.attrName = 'Is Archiving Enabled'
							AND ABP.attrVal = '1'
							AND ABP.modified = 0
			UNION
			SELECT SP.componentNameId
			FROM APP_SubclientProp SP
				INNER JOIN APP_Application A
					ON SP.componentNameId = A.id
					AND A.clientID = @r_clientId
					AND A.appTypeId = @r_appTypeId
			WHERE
				SP.attrName = 'Turbo Mode Enable Stubbing'
				AND SP.cs_attrName = CHECKSUM(N'Turbo Mode Enable Stubbing')
				AND SP.attrVal = '1'
				AND SP.modified = 0
	END
UPDATE IDA
		SET IDA.lastBackupTime = JBS.lastBackupTime,
		IDA.firstBackupTime = JBS.firstBackupTime,
		IDA.totalBackupSize = JBS.totalBackupSize,
		IDA.applicationSize = JBS.applicationSize
	FROM @FinalAgentPropList IDA
	INNER JOIN (SELECT MAX(JB.servEndDate) lastBackupTime,
					   MIN(JB.servEndDate) firstBackupTime,
					   SUM(JB.totalUncompBytes) totalBackupSize,
					   SUM( DISTINCT
							ISNULL(
									NULLIF((CAST(ISNULL(ABP.attrval,0) AS BIGINT) + CAST(ISNULL(ASP.attrval,0) AS BIGINT)),0)
									,ISNULL(LIC.AppSizeMB * 1024 * 1024, 0) -- to bytes
									)
							) applicationSize,
					   clientId, appTypeId
				FROM APP_Application AAP  WITH(NOLOCK)
					INNER JOIN JMBkpStats JB  WITH(NOLOCK)
						ON JB.appId=AAP.id AND JB.status IN (1,3,14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
						AND JB.dataStatus = 0 -- DATA_STATUS_VALID
					LEFT OUTER JOIN APP_BackupSetProp ABP  WITH(NOLOCK)
						ON AAP.backupSet=ABP.componentNameId
						AND ABP.attrName=N'Application Size'
						AND ABP.modified=0
						AND ISNUMERIC(ABP.attrVal) = 1
					LEFT OUTER JOIN APP_SubclientProp ASP WITH(NOLOCK)
						ON AAP.id = ASP.componentNameId
						AND ASP.modified = 0
						AND ASP.cs_attrName = CHECKSUM(N'Application Size')
						AND ASP.attrName = N'Application Size'
					LEFT OUTER JOIN #LicenseAppSizeTbl LIC ON AAP.id = LIC.subclientid
					LEFT OUTER JOIN APP_SubClientProp ASCP WITH(NOLOCK) ON ASCP.componentNameId = AAP.id
						AND ASCP.attrName IN (N'DDB Backup', N'Index SubClient')
						AND ASCP.cs_attrName IN (CHECKSUM(N'DDB Backup'), CHECKSUM(N'Index SubClient'))
						AND ASCP.modified = 0
					LEFT OUTER JOIN @archiveAndOnePassSubclients ASUB ON AAP.id = ASUB.id
					LEFT OUTER JOIN APP_BackupsetProp ARCHBKSTPROP WITH(NOLOCK)
          				ON  ARCHBKSTPROP.componentNameId = AAP.backupSet
              				AND ARCHBKSTPROP.attrName = 'Is Archiving Enabled'
              				AND ARCHBKSTPROP.attrVal = '1'
              				AND ARCHBKSTPROP.modified = 0
				WHERE ASCP.componentNameId IS NULL
					AND (
							 -- For FS solution, we need to skip ONLY archiver sets. One-pass and regular FS backupsets / subclients can be shown.
							 (@r_getArchiverAgents = 0 AND ARCHBKSTPROP.componentNameId IS NULL)
							 OR
							 -- For archiver solution, we need to show one-pass and archiver set subclients. Regular FS backupsets to be skipped.
							 (@r_getArchiverAgents = 1 AND ASUB.id IS NOT NULL)
						 )
				GROUP BY clientId, appTypeId) JBS
		ON JBS.clientId = IDA.clientId AND JBS.appTypeId = IDA.appTypeID
DECLARE @sizeONMEdia FLOAT=0
	   DECLARE @totalUncompBytes FLOAT=0
	   DECLARE @dedupePer FLOAT=0
		SELECT @sizeONMEdia= ISNULL(SUM(SM.attributeValueInt),0), @totalUncompBytes = ISNULL(SUM(JMB.totalUncompBytes),0)
	    FROM JMBkpStats JMB WITH(NOLOCK)
		INNER JOIN JMJobOptions SM WITH(NOLOCK) ON JMB.jobId = SM.jobId
		AND JMB.commCellId = SM.commCellId
		AND SM.attributeId = 73
		AND JMB.status IN (1,3,14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
		INNER JOIN APP_Application App on App.id=appId and App.clientId= @r_clientId and  App.appTypeId=@r_appTypeID
		LEFT OUTER JOIN APP_SubClientProp ASCP WITH(NOLOCK) ON ASCP.componentNameId = App.id
		AND ASCP.attrName IN (N'DDB Backup', N'Index SubClient')
		AND ASCP.cs_attrName IN (CHECKSUM(N'DDB Backup'), CHECKSUM(N'Index SubClient'))
		AND ASCP.modified = 0
		LEFT OUTER JOIN @archiveAndOnePassSubclients ASUB ON APP.id = ASUB.id
		LEFT OUTER JOIN APP_BackupsetProp ARCHBKSTPROP WITH(NOLOCK)
			ON  ARCHBKSTPROP.componentNameId = APP.backupSet
				AND ARCHBKSTPROP.attrName = 'Is Archiving Enabled'
				AND ARCHBKSTPROP.attrVal = '1'
				AND ARCHBKSTPROP.modified = 0
		WHERE ASCP.componentNameId IS NULL
				AND (
							 -- For FS solution, we need to skip ONLY archiver sets. One-pass and regular FS backupsets / subclients can be shown.
							 (@r_getArchiverAgents = 0 AND ARCHBKSTPROP.componentNameId IS NULL)
							 OR
							 -- For archiver solution, we need to show one-pass and archiver set subclients. Regular FS backupsets to be skipped.
							 (@r_getArchiverAgents = 1 AND ASUB.id IS NOT NULL)
					 )
	IF(@totalUncompBytes<>0)
	BEGIN
		SELECT  @dedupePer = ((@totalUncompBytes-@sizeONMEdia)/@totalUncompBytes)*100
	END
UPDATE @FinalAgentPropList
SET dedupeRatio=@dedupePer,
	sizeOnMedia=@sizeONMEdia
WHERE clientId=@r_clientId and appTypeId=@r_appTypeID
UPDATE AL
SET lastBackupJobInfo = AP.attrVal
FROM @FinalAgentPropList AL
	INNER JOIN  APP_IDAName(NOLOCK) A
		ON A.clientId = AL.clientid AND A.apptypeid = AL.appTypeId AND AL.clientId = @r_clientId and AL.appTypeId=@r_appTypeID
	INNER JOIN APP_IDAProp (NOLOCK) AP
		ON AP.componentNameId = A.id AND AP.attrname = N'Last Backup Job Info' AND AP.modified = 0
END
IF	object_id('tempdb.dbo.#TEMP_APP_AgentPROP') is not null DROP TABLE #TEMP_APP_AgentPROP
IF	object_id('tempdb.dbo.#TEMP_APP_AgentPROPS') is not null DROP TABLE #TEMP_APP_AgentPROPS
--END
CONTINUE_NEXT_AGENT:
		FETCH NEXT FROM @AgentCur INTO @r_clientId , @r_clientName	, @r_appTypeID , @r_appTypeName,@errorCode,@errorString
		END
	DEALLOCATE @AgentCur
	DELETE FROM @AgentList
-- Compute SLA
IF object_id('tempdb..#SLA_EntityInfo') IS NOT NULL DROP TABLE #SLA_EntityInfo
CREATE TABLE #SLA_EntityInfo (
clientId INT, appTypeId INT, instanceId INT, backupsetId INT, appId INT, -- entity IDs to set
status INT, category INT, slaDays INT)
insert into #SLA_EntityInfo(clientId, appTypeId)
SELECT  clientId, appTypeId
FROM @FinalAgentPropList
exec RptGetSLAOfEntities 2
UPDATE AL
SET AL.SLAStatus = (CASE WHEN SLA.status = 1 THEN 1 WHEN SLA.status = 2 THEN 2 ELSE 3 END),
	AL.SLACategory = SLA.Category,
	AL.SLACategoryDescription = dbo.WR_GetSLACategoryString(@localeId,SLA.Category)
FROM @FinalAgentPropList AL
	INNER JOIN #SLA_EntityInfo SLA
		ON AL.clientId = SLA.clientId and AL.appTypeId = SLA.appTypeId
IF @r_excludeExtendedProperties > 10
BEGIN
SET	@xmlText =(SELECT	(SELECT
--(SELECT
						(SELECT	enableOCS '@enableOCSOnBackupAgent',
						createIndexOnFull '@createIndexOnFull',
						createIndexOnFail '@createIndexOnFail',
						userDescription '@userDescription',
						isSRMEnabled	'@isSRMAgentEnabled',
						requiresMoreConfig	'@isNeedMoreconfig',
						appTypePriority			'@appPriority',
						isNDMPRestore			'@isNDMPRestore',
						archiveGroup			'@archiveGroup',
						maxSimultaneousStubRecoveries	'@maxSimultaneousStubRecoveries',
						timeBetweenRecalls		'@timeBetweenRecalls',
						timeToWaitAfterMax		'@timeToWaitAfterMax',
						qsnapMaxCacheSize		'@qsnapMaxCacheSize',
						qsnapMinCacheSize		'@qsnapMinCacheSize',
						agentArchivePropertiesFlag	'@agentArchivePropertiesFlag',
						AgentVersion				'@agentVersion',
						installDate				'@installDate',
						appTypePathnameOrder	'@appTypePathnameOrder',
						appTypePathnameSeperator	'@appTypePathnameSeperator',
						appTypepathnameCaseSensitive	'@appTypepathnameCaseSensitive',
						patchStatus				'@patchStatus',
						isMarkedDeleted		'@isMarkedDeleted',
						isSRMdataCollectionEnabled	'@isSRMdataCollectionEnabled',
						useSnapShotWriter '@useSnapShotWriter',
						objectServerInterval '@objectServerInterval',
						prepostUsername '@prepostUsername',
						isArchiverDriverEnabled '@isArchiverDriverEnabled',
						isExplorerBasedRecall '@isExplorerBasedRecall',
						isAccessTimeCollected '@isAccessTimeCollected',
						honorArchiverRetention '@honorArchiverRetention',
						disableHonorArchiverRetention '@disableHonorArchiverRetention',
						recallMPFlag  AS '@recallMPFlag',
						isTrueUpOptionEnabledForOnePass '@isTrueUpOptionEnabledForOnePass',
						runTrueUpJobAfterDaysForOnePass '@runTrueUpJobAfterDaysForOnePass',
						isAgentIndexingV2 '@isAgentIndexingV2',
						(SELECT recallMP      AS '@policyId',
						MPname AS '@policyName'
						FOR XML PATH('recallMP'),TYPE),
						(SELECT
						archiverStoragepolicyId AS '@storagePolicyId',
     					archiverStoragepolicy AS '@storagePolicyName'
     					FOR XML PATH('indexStoragePolicy'), TYPE),
						(SELECT
							lastBackupTime as		'@lastBackupTime',
							firstBackupTime as		'@firstBackupTime',
							applicationSize as		'@applicationSize',
							dedupeRatio as '@dedupeRatio',
							sizeOnMedia as '@sizeOnMedia',
							totalBackupSize as '@totalBackupSize',
							SLAStatus AS '@slaStatus',
							SLACategory AS '@slaCategory',
							SLACategoryDescription AS '@slaCategoryDescription',
							(SELECT s.n.query('.') FROM lastBackupJobInfo.nodes('lastBackupJobInfo') s(n))
						 FOR XML PATH('commonProperties'),TYPE)
						--OSType '@OSType'
						FROM @FinalAgentPropList
						WHERE appTypeID = FinalList.appTypeId
						FOR XML PATH('AgentProperties'),TYPE),
						--security user groups
						(select idaSecurity  FROM @userGroups AS ug --modified
									WHERE ug.appTypeID = FinalList.appTypeId
											FOR XML PATH (''),TYPE),
						(SELECT attrName AS '@name',
								attrVal AS '@value'
						 FROM @propertyList
						 FOR XML PATH('propertyList'), TYPE),
						(SELECT idasecuritynew AS 'securityAssociations'
						 FROM @userGroups AS ug
						 WHERE ug.appTypeID = FinalList.appTypeID
						 FOR XML PATH(''), TYPE),
						(SELECT @r_clientId '@clientId',
							 F.appTypeId	'@applicationId',
							 F.appName		'@appName',
							 clientName	'@clientName',
							 2 '@commCellId'
							FROM @FinalAgentPropList F
							WHERE appTypeID = FinalList.appTypeId
						FOR XML PATH('idaEntity'),TYPE),
                        (SELECT idaActivityControl
                                FROM @ActivityControl
                                WHERE appTypeID = FinalList.appTypeID
                                FOR XML PATH (''),TYPE),
						(SELECT
							ListenPort	'@listenPort',
							FirmwareRevision	'@firmwareRevision',
							Vendor		'@vendor',
							(SELECT username	'@userName'
							FOR XML PATH ('nasAccount'), TYPE)
								FROM @NASProperties
								WHERE appTypeID = FinalList.appTypeId
							FOR XML PATH('nasProperties'),TYPE),
						(SELECT
							username	'@username',
							passwd		'@password'
								FROM @NetwareProperties
								WHERE appTypeID = FinalList.appTypeId
							FOR XML PATH('netwareProperties'),TYPE),
						(SELECT
							username	'@username',
							NDSTreeName	'@NDSTreeName'
								FROM @NDSProperties
								WHERE appTypeID = FinalList.appTypeId
							FOR XML PATH('ndsProperties'),TYPE),
						(SELECT
							username	'@SiteAccount',
							NTAPDMFilerName	'@SiteAccountServer',
							stubLocation	'@StubLocation'
								FROM @NTAPDMProperties
								WHERE appTypeID = FinalList.appTypeId
							FOR XML PATH('ntapDMProperties'),TYPE),
						(SELECT
							releaseId	'@releaseId',
							ADServerName '@ADServerName',
							ADUsername	'@ADUsername',
							proxyFileExpiration	'@proxyFileExpiration',
							proxyFilePruneInterval '@proxyFilePruneInterval',
							isEnableNFSShareForEMC	'@isEnableNFSShareForEMC',
							proxyUsername	'@proxyUsername',
							isEndUserEraseEnabled	'@isEndUserEraseEnabled',
							EndUserFolderList	'@EndUserFolderList'
								FROM @FSDataMigratorProperties
								WHERE appTypeID = FinalList.appTypeId
							FOR XML PATH('fsdmProperties'),TYPE),
						(SELECT
							ADServerName	'@ADServerName',
							ADUsername	'@ADUsername',
							MetaDataFileLocation	'@MetaDataFileLocation',
							isDataClassificationEnabled	'@isDataClassificationEnabled',
							isOnline	'@isOnline',
							clientPriority	'@clientPriority',
							updateInterval	'@updateInterval',
							InactivityPeriod	'@InactivityPeriod',
							DataClassificationTagList '@DataClassificationTagList'
								FROM @DataClassificationProperties
								WHERE appTypeID = FinalList.appTypeId
							FOR XML PATH('dataclassificationProperties'),TYPE),
						(SELECT
							username	'@username'
								FROM @NetwareDMProperties
								WHERE appTypeID = FinalList.appTypeId
							FOR XML PATH('netwareDMProperties'),TYPE),
							(SELECT
								http_cifs_addr		'@http_cifs_addr',
								nas_http_port		'@nas_http_port',
								proxyStubPath		'@proxyStubPath',
								(SELECT primaryClientId as '@clientId',  primaryClientName AS '@clientName'
								FROM @TurboNASProperties
								WHERE appTypeID = FinalList.appTypeId
									FOR XML PATH ('primaryClient'), TYPE
								),
								(SELECT proxyClientId as '@clientId',  proxyClientName AS '@clientName'
								FROM @TurboNASProperties
								WHERE appTypeID = FinalList.appTypeId
									FOR XML PATH ('proxyClient'), TYPE
								),
								(SELECT secondaryClientId as '@clientId',  secondaryClientName AS '@clientName'
								FROM @TurboNASProperties
								WHERE appTypeID = FinalList.appTypeId
									FOR XML PATH ('secondaryClient'), TYPE
								)
								FROM @TurboNASProperties
								WHERE appTypeID = FinalList.appTypeId
							FOR XML PATH('turboNasProperties'),TYPE),
							(SELECT OP.recallService '@recallService',
								(SELECT MP.ProfileName '@profileName', EO.environmentType '@environmentType', EO.msCloudRegion '@cloudRegion', EO.discoveryFilter '@userDiscoveryFilter',
										EO.modernAuthEnabled '@isModernAuthEnabled',
									(SELECT S.Data '@val'
									FROM @onePassProperties OP
									CROSS APPLY dbo.SplitString(servers, ' ') S
									WHERE FinalList.appTypeID = OP.appTypeID
									FOR XML PATH('servers'),TYPE),
									(SELECT S.Data '@val'
										FROM @ExchangeMBProp MB
										CROSS APPLY dbo.SplitString(ADServerList, ' ') S
										WHERE FinalList.appTypeID = MB.appTypeId
										FOR	XML PATH('adServerList'),TYPE),
									EO.accounts,
									(
										SELECT
											EO.useEWS AS '@bUseEWS',
											EO.ewsConnectionUri AS '@ewsConnectionUrl'
										FOR XML PATH('ewsDetails') , TYPE
									),
									(
										select cast(replace(cast(EO.discoverInfo as varchar(max)), 'App_Office365DiscoverState', 'discoverState') as xml)
									),
									EO.azureAppList,
									CASE WHEN (EO.azureAppId != '' OR EO.azureSecretKey !='' OR EO.azureTentanName != '' )
									THEN
										(	SELECT EO.azureAppId '@azureAppKeyID', /*EO.azureSecretKey '@azureAppKeySecret',*/ EO.azureTentanName '@azureTenantName'
											FOR XML PATH('azureDetails'),TYPE
										)
									END
									FOR XML PATH('onePassProp'),TYPE),
									(SELECT
										OP.indexServerId AS '@mediaAgentId',
										OP.indexServerName AS '@mediaAgentName',
11 as '@_type_'
										FOR XML PATH('indexServer') , TYPE
									),
									(
										SELECT
										(
											SELECT po.query('.')
											FROM
											(
												SELECT CAST(OP.memberServers AS XML) memberServers
											) PROP
											CROSS APPLY PROP.memberServers.nodes('./App_MemberServers/memberServers') P(po)
											FOR XML PATH(''),TYPE
										)
										FOR XML PATH('memberServers'),TYPE
									)
									FROM @exchangeOnePassProperties EO
									JOIN @onePassProperties OP ON OP.appTypeID = EO.appTypeID AND FinalList.appTypeID = OP.appTypeID
									LEFT OUTER JOIN @ExchangeMBProp MP ON MP.appTypeId = EO.appTypeID
							FOR XML PATH('onePassProperties'),TYPE),
						(SELECT
							OnlineCILocationShareName	'@OnlineCILocationShareName',
							OWAURLList	'@OWAURLList'
								FROM @Win2KProperties
								WHERE appTypeID = FinalList.appTypeId
							FOR XML PATH('win2KProperties'),TYPE),
						(SELECT
								id			'@id',
								appName		'@appName',
								Username	'@Username',
								Servername	'@Servername'
								FROM @Credentials
								WHERE appTypeID = FinalList.appTypeId
							FOR XML PATH('replicationCredentials'),TYPE),
						(SELECT
							RestoreToRecoveredItems	'@RestoreToRecoveredItems'
								FROM @LotusNotesDocProperties
								WHERE appTypeID = FinalList.appTypeId
							FOR XML PATH('LNDocProperties'),TYPE),
						(SELECT
							(SELECT
								username	'@userName',
									13 AS '@_type_'
								FROM @GranADProperties
								WHERE appTypeID = FinalList.appTypeId
								FOR XML PATH('granularADAccount'),TYPE)
							FOR XML PATH('granularADProperties'),TYPE),
						(SELECT
							userAccount	'@userAccount',
							fileLogPath	'@fileLogPathh',
							logVolThrottlePercent	'@logVolThrottlePercent',
							logVolStopLogsPercent	'@logVolStopLogsPercent',
							flrReplicationOptions	'@flrReplicationOptions',
							srcLogVolAbortPercent	'@srcLogVolAbortPercent',
							flrDefualtOSPriority	'@flrDefualtOSPriority',
							flrLogFlushWaitTime		'@flrLogFlushWaitTime',
							flrTransferRate			'@flrTransferRate',
							flrONTAPAccount		'@flrONTAPAccount'
							FROM @FLRProperties
								WHERE appTypeID = FinalList.appTypeId
								FOR XML PATH('FLRProperties'),TYPE),
						(SELECT
							id	'@ruleId',
							opType		'@opType',
							daysOfWeek	'@daysOfWeek',
							startTime	'@startTime',
							endTime		'@endTime',
							enable		'@enable',
							description	'@description',
							utilization	'@utilization',
							clientGroupId	'@clientGroupId',
							startDate	'@startDate',
							endDate		'@endDate'
								FROM APP_OpWindowRule
								WHERE clientId = @r_clientId AND
								appTypeId = FinalList.appTypeId
							FOR XML PATH('opWindowRule'),TYPE),
						( SELECT
							Username	'@Username',
							ServerName	'@ServerName',
							StubRetentionTime	'@StubRetentionTime',
							ReleaseTopologyLock	'@ReleaseTopologyLock',
							RestorePath		'@RestorePath',
							isRemoteSQLServer	'@isRemoteSQLServer',
							sqlUserName		'@sqlUserName',
							spVersion		'@version'
								FROM @SharePointProp
								WHERE appTypeId = FinalList.appTypeId
							FOR XML PATH('sharePointProp'),TYPE),
						(SELECT
							UserName	'@UserName',
							ServerName	'@ServerName',
							ProfileName	'@profileName',
							MailBoxName	'@MailBoxName',
							BackupDeleted	'@BackupDeleted',
							UseCSVDEDiscovery	'@UseCSVDEDiscovery',
							BackupHiddenMailBox	'@BackupHiddenMailBox',
							MagneticLib	'@MagneticLib',
							TapeLib	'@TapeLib',
							OfflineMedia	'@OfflineMedia'
								FROM @ExchangePublicFolderProp
								WHERE appTypeId = FinalList.appTypeId
							FOR XML PATH('exchangePublicFolderProp'),TYPE),
						(SELECT
							UserName	'@UserName',
							ServerName	'@ServerName',
							ProfileName	'@profileName',
							MailBoxName	'@MailBoxName',
							BackupDeleted	'@BackupDeleted',
							UseCSVDEDiscovery	'@UseCSVDEDiscovery',
							BackupHiddenMailBox	'@BackupHiddenMailBox',
							MagneticLib	'@MagneticLib',
							TapeLib	'@TapeLib',
							OfflineMedia	'@OfflineMedia',
							JournalThreshold	'@JournalThreshold',
							ADServerList	'@ADServerList',
							isForceRecallOutlookAddin	'@isForceRecallOutlookAddin',
							isForceRecallOWAUser	'@isForceRecallOWAUser',
							isAutoDiscoveryEnabled	'@isAutoDiscoveryEnabled',
							canManageContentAutomatically	'@canManageContentAutomatically',
							isOptimizeDataForSearchEnabled	'@isOptimizeDataForSearchEnabled',
							AgentVersion		'@AgentVersion'
								FROM @DataMigratorProp
								WHERE appTypeId = FinalList.appTypeId
							FOR XML PATH('dataMigratorProp'),TYPE),
						(SELECT
							UserName	'@UserName',
							ServerName	'@ServerName',
							ProfileName	'@profileName',
							MailBoxName	'@MailBoxName',
							BackupDeleted	'@BackupDeleted',
							UseCSVDEDiscovery	'@UseCSVDEDiscovery',
							BackupHiddenMailBox	'@BackupHiddenMailBox',
							MagneticLib	'@MagneticLib',
							TapeLib	'@TapeLib',
							OfflineMedia	'@OfflineMedia',
							JournalThreshold	'@JournalThreshold',
							ADServerList	'@ADServerList',
							canManageContentAutomatically	'@canManageContentAutomatically',
							isOptimizeDataForSearchEnabled	'@isOptimizeDataForSearchEnabled',
							isHostedExchange	'@isHostedExchange',
							AgentVersion		'@AgentVersion'
								FROM @ExchangeArchiverProp
								WHERE appTypeId = FinalList.appTypeId
							FOR XML PATH('exchangeArchiverProp'),TYPE),
						(SELECT
							UserName	'@UserName',
							ServerName	'@ServerName',
							ProfileName	'@profileName',
							MailBoxName	'@MailBoxName',
							BackupDeleted	'@BackupDeleted',
							UseCSVDEDiscovery	'@UseCSVDEDiscovery',
							BackupHiddenMailBox	'@BackupHiddenMailBox',
							MagneticLib	'@MagneticLib',
							TapeLib	'@TapeLib',
							OfflineMedia	'@OfflineMedia',
							JournalThreshold	'@JournalThreshold',
							canManageContentAutomatically	'@canManageContentAutomatically',
							isOptimizeDataForSearchEnabled	'@isOptimizeDataForSearchEnabled',
							isHostedExchange	'@isHostedExchange',
							AgentVersion		'@AgentVersion',
							OnlineCILocShare	'@OnlineCILocShare',
							CIOWAUrlList	'@CIOWAUrlList',
							(SELECT S.Data '@val'
								FROM dbo.SplitString(ADServerList, ' ') S
								FOR	XML PATH('adServerList'),TYPE
							)
								FROM @ExchangeMBProp
WHERE appTypeId = FinalList.appTypeId AND appTypeId != 137
							FOR XML PATH('exchangeMBProp'),TYPE),
						(SELECT
							Username	'@Username'
								FROM @NetwareGroupWise
								WHERE appTypeId = FinalList.appTypeId
							FOR XML PATH('netwareGroupWise'),TYPE),
						(SELECT
								--Username	'@Username',
								ExchDBThrottling	'@ExchDBThrottling',
								ServerName	'@serverName',
								isOptimizeDataForSearchEnabled	'@isOptimizeDataForSearchEnabled',
								AgentVersion	'@idaVersion',
								DagName		'@DagName',
								generateExchActivityLog	'@generateExchActivityLog',
								exchMBLogLocation	'@exchMBLogLocation',
								manageContentAutomatically	'@manageContentAutomatically',
								exchJournalLogUsername	'@exchJournalLogUsername',
								releaseTopologyLock	'@releaseTopologyLock',
								remoteIndexBackupRestorePath	'@remoteIndexBackupRestorePath',
								isRemoteSQLServer	'@isRemoteSQLServer',
								RemoteSQLServerUsername	'@RemoteSQLServerUsername',
								backupLevel	'@backupType',
								appTypeFlag	'@appTypeFlag',
								(SELECT
										Username	'@userName',
										13 AS '@_type_'
									FROM @ExchangeDBProp
									WHERE appTypeID = FinalList.appTypeId
									FOR XML PATH('userAccount'),TYPE)
								FROM @ExchangeDBProp
								WHERE appTypeId = FinalList.appTypeId
							FOR XML PATH('exchangeDBProp'),TYPE),
						(SELECT
								Username	'@Username',
								ServerName	'@ServerName',
								backupLevel	'@backupLevel'
									FROM @FastraxForExch
									WHERE appTypeId = FinalList.appTypeId
							FOR XML PATH('fastraxForExchProp'),TYPE),
						(SELECT
								Username	'@Username',
								ServerName	'@ServerName',
								backupLevel	'@backupLevel'
									FROM @SharepointDBProp
									WHERE appTypeId = FinalList.appTypeId
							FOR XML PATH('sharepointDBProp'),TYPE),
						(SELECT
								isAutoDiscoveredEnabled	'@isAutoDiscoveredEnabled',
								(SELECT dataSP AS '@storagePolicyId',
17 AS '@_type_'
									FROM @Oracle8Prop
									FOR XML PATH('dataStoragePolicy'),TYPE),
								(SELECT logSP AS '@storagePolicyId',
17 AS '@_type_'
									FROM @Oracle8Prop
									FOR XML PATH('logStoragePolicy'),TYPE)
									FROM @Oracle8Prop
									WHERE appTypeId = FinalList.appTypeId
							FOR XML PATH('oracle8Prop'),TYPE),
						(SELECT
								isAutoDiscoveredEnabled	'@isAutoDiscoveredEnabled'
									FROM @db2Prop
									WHERE appTypeId = FinalList.appTypeId
							FOR XML PATH('db2Prop'),TYPE),
						(SELECT
								isAutoDiscoverEnabled	'@isAutoDiscoverEnabled'
									FROM @MySQLProp
									WHERE appTypeId = FinalList.appTypeId
							FOR XML PATH('mySQLProp'),TYPE),
						(SELECT
								isAutoDiscoverEnabled	'@isAutoDiscoverEnabled'
									FROM @PostgreSQLProp
									WHERE appTypeId = FinalList.appTypeId
							FOR XML PATH('postgresProp'),TYPE),
						(SELECT
						        isAutoDiscoverSQLInstances	'@isAutoDiscoverSQLInstances',
								isStagingPathForRestoresEnabled	'@isStagingPathForRestoresEnabled',
								stagingPath '@stagingPath',
								canManageContentAutomaticallyFlag	'@canManageContentAutomaticallyFlag',
								isAzureConfigured	'@isAzureConfigured',
								isAwsConfigured	'@isAwsConfigured',
								EntityID	'@EntityID',
								DisplayName	'@DisplayName',
								AssocLevel	'@AssocLevel',
								(SELECT
									(SELECT po.query('.')
										FROM(SELECT CAST(proxies AS XML) memberServers) PROP
										CROSS APPLY PROP.memberServers.nodes('./App_MemberServers/memberServers') P(po)
									FOR XML PATH(''),TYPE)
								FOR XML PATH('proxies'),TYPE),
								(SELECT	azureTenantId	'@azureTenantId',
										azureClientId	'@azureClientId',
										azureSubscriptionId	'@azureSubscriptionId',
										azureStorageConnectionString	'@azureStorageConnectionString',
										azureAuthenticationMethod	'@azureAuthenticationMethod',
										thumbprint	'@thumbprint',
								      (SELECT azureUsername as '@userName'
												 --azurePassword as '@password'
                                                 FOR XML PATH('azureCredentials'),TYPE),
									  (SELECT NULLIF(azureSQLUsername,userName) as '@userName' -- If SQL Authentication Credentials are missing, get it from AD Authentication
												 --azureSQLPassword as '@password'
                                                 FOR XML PATH('azureSqlInstanceCredentials'),TYPE)
									     FOR XML PATH('azureInfo'),TYPE),
								(SELECT	awsAccessKey	'@accessKey',
										awsSecretKey	'@secretKey',
										s3BucketName	'@s3BucketName',
								      (SELECT awsSqlInstanceUsername as '@userName'
												 --azurePassword as '@password'
                                                 FOR XML PATH('sqlInstanceCredentials'),TYPE)
									     FOR XML PATH('awsSqlInfo'),TYPE),
								(SELECT  overrideGlobalAuthentication	'@overrideGlobalAuthentication',
								         useLocalSystemAccount	'@useLocalSystemAccount',
								      (SELECT userName as '@userName'
								                 --password as '@password'
                                                 FOR XML PATH('userAccount'),TYPE)
									     FOR XML PATH('overrideHigherLevelSettings'),TYPE)
							    FROM @SQL61Prop
									WHERE appTypeId = FinalList.appTypeId
							FOR XML PATH('sql61Prop'),TYPE),
						(SELECT 	msCloudRegion  '@cloudRegion', azureAppList,
									(SELECT
										indexServerId AS '@clientId',
										indexServerName AS '@clientName',
3 as '@_type_'
										FOR XML PATH('indexServer') , TYPE
									),
									(
										SELECT
										(
											SELECT po.query('.')
											FROM
											(
												SELECT CAST(REPLACE(memberServers,'UTF-8','UTF-16') AS XML) memberServers
											) PROP
											CROSS APPLY PROP.memberServers.nodes('./App_MemberServers/memberServers') P(po)
											FOR XML PATH(''),TYPE
										)
										FOR XML PATH('memberServers'),TYPE
									),
									serviceAccounts
									FROM @AzureADProperties
							FOR XML PATH('azureADProperties'),TYPE),
						(SELECT backupConfigXML.query('/App_BackupConfigurationNodes/*')
							FOR XML PATH('backupConfiguration'), TYPE ),
						(SELECT cloudDBConfigXML.query('/App_CloudDBConfig/*')
							FOR XML PATH('cloudDbConfig'), TYPE ),
						(
							SELECT  r_DSClientId AS '@DataSourceId',
									r_DSFullList AS '@DataSourceList',
									1 AS '@IsArchiveEnabled'			-- Always 1 since we are getting only archive enabled clients.
							FROM #archiveClientInfo ACI
							WHERE
								ACI.r_clientId = Finallist.clientId
							FOR XML PATH ('archiveClientInfo'), TYPE
						)
						FROM @FinalAgentPropList AS FinalList
							FOR XML PATH('agentProperties'),TYPE)
					--	FOR XML PATH('agents'), TYPE)
--FOR XML PATH(''), ROOT('App_GetAgentPropertiesResponse')
)
END
ELSE
BEGIN
	SET	@xmlText =(SELECT	(SELECT
	--(SELECT
	                   (SELECT AgentVersion				'@agentVersion',
                               installDate				'@installDate',
                               isMarkedDeleted		'@isMarkedDeleted'
							FROM @FinalAgentPropList
						WHERE appTypeID = FinalList.appTypeId
						FOR XML PATH('AgentProperties'),TYPE),
						(SELECT idaActivityControl
                                FROM @ActivityControl
                                WHERE appTypeID = FinalList.appTypeID
                                FOR XML PATH (''),TYPE),
						(SELECT clientId '@clientId',
							 F.appTypeId	'@applicationId',
							 F.appName		'@appName',
							 clientName	'@clientName',
							 2 '@commCellId'
							FROM @FinalAgentPropList F
							WHERE appTypeID = FinalList.appTypeId
						FOR XML PATH('idaEntity'),TYPE)
							FROM @FinalAgentPropList AS FinalList
						FOR XML PATH('agentProperties'),TYPE)
							--FOR XML PATH('agents'), TYPE)
--FOR XML PATH(''), ROOT('App_GetAgentPropertiesResponse')
)
END
DECLARE @errorXML XML
SET @errorXML = 	(SELECT errorCode AS '@errorCode', errorString AS '@errorString',
(SELECT
    					appTypeName as '@appName',
						appTypeID as '@applicationId',
						clientId as '@clientId',
						clientName as '@clientName'
					FOR XML PATH('entity'),type)  FROM @i_clientList WHERE errorCode >0 FOR XML PATH('errors'), TYPE)
SELECT @xmlText,@errorXML FOR XML PATH(''), ROOT('App_GetAgentPropertiesResponse');
END
/*
DECLARE @id as int = 4
DECLARE @xmlText as nvarchar(max) = (select message from tracknotificationProcs where ID=@id)
DECLARE @xml as xml = CONVERT(xml, @xmlText)
select @xml
exec APPGetIDAProperties @xml
*/

IF EXISTS (select * from GxQscripts where name = 'APPGetIDAProperties')
	delete from GxQscripts where name = 'APPGetIDAProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetIDAProperties')
	delete from GXDBVersions where aliasname = 'APPGetIDAProperties'
GO

insert into GXDBVersions values(2, 'APPGetIDAProperties',  'v1.52.14.85.4.1', 'APPGetIDAProperties', 'v1.52.14.85.4.1')
GO

