

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetGeoLocations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2014  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	| APPGetGeoLocations - Get Geo Locations of all clients accessible to the given user |
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetGeoLocations <<<'

IF EXISTS (select * from sysobjects where name='APPGetGeoLocations')
	drop procedure APPGetGeoLocations
IF EXISTS (select * from GxQscripts where name='APPGetGeoLocations')
	delete from GxQscripts where name = 'APPGetGeoLocations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetGeoLocations')
	delete from GXDBVersions where aliasname = 'APPGetGeoLocations'
GO
print '... Creating Procedure: APPGetGeoLocations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetGeoLocations
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @userId INT,
  @minLat INT,
  @maxLat INT,
  @minLon INT, 
  @maxLon INT,
  @index INT,
  @rows INT,
  @xmlString XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
DECLARE @errorCode		AS INT			= 0
DECLARE @errorString	AS VARCHAR(2048)= ''
BEGIN TRY
IF object_id('tempdb.dbo.#tempClientIds') IS NOT NULL DROP TABLE #tempClientIds
create table  #tempClientIds ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId, 2009, 0, '#tempClientIds'
IF EXISTS(SELECT 1 FROM #tempClientIds sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))
BEGIN
SET @xmlString = ( SELECT
	T.componentNameId '@id',
	T.name '@name',
	xmlblob.value('@latitude', 'NVARCHAR(MAX)') '@lat',
	xmlblob.value('@longitude', 'NVARCHAR(MAX)') '@lon',
	T.created '@created'
	FROM (
		SELECT APPCP.componentNameId, APPC.name, CAST(attrVal AS XML) as xmlValue, APPCP.created
		FROM APP_ClientProp APPCP WITH(NOLOCK)
		JOIN APP_Client APPC WITH(NOLOCK) ON APPC.id = APPCP.componentNameId
		WHERE APPCP.attrName = 'Client Geo Location' AND APPCP.modified = 0 AND APPCP.attrVal like '<App_GeoLocation%' AND APPCP.componentNameId > 0
	) T
	CROSS APPLY T.xmlValue.nodes('App_GeoLocation') M(xmlblob)
	WHERE xmlblob.value('@status_code', 'NVARCHAR(MAX)') = 'SUCCESS'
	FOR XML PATH ('geo'),
	ROOT ('App_GeoLocationsResponse')
)
END
ELSE
BEGIN
SET @xmlString = ( SELECT
	T.componentNameId '@id',
	T.name '@name',
	xmlblob.value('@latitude', 'NVARCHAR(MAX)') '@lat',
	xmlblob.value('@longitude', 'NVARCHAR(MAX)') '@lon',
	T.created '@created'
	FROM (
		SELECT APPCP.componentNameId, APPC.name, CAST(attrVal AS XML) as xmlValue, APPCP.created
		FROM APP_ClientProp APPCP WITH(NOLOCK)
		JOIN APP_Client APPC WITH(NOLOCK) ON APPC.id = APPCP.componentNameId
		WHERE APPCP.attrName = 'Client Geo Location' and APPCP.modified = 0 AND APPCP.attrVal like '<App_GeoLocation%' AND APPCP.componentNameId > 0
			AND
			(
				APPCP.componentNameId IN (SELECT clientId FROM #tempClientIds WHERE clientId > 0)
				OR
				APPCP.componentNameId IN (SELECT clientId FROM APP_ClientGroupAssoc WITH(NOLOCK) WHERE clientGroupId IN (SELECT clientGroupId FROM #tempClientIds WHERE clientGroupId > 0))
			)
	) T
	CROSS APPLY T.xmlValue.nodes('App_GeoLocation') M(xmlblob)
	WHERE xmlblob.value('@status_code', 'NVARCHAR(MAX)') = 'SUCCESS'
	FOR XML PATH ('geo'),
	ROOT ('App_GeoLocationsResponse')
)
END
IF @xmlString IS NULL
	SET @xmlString = '<App_GeoLocationsResponse/>'
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' + Convert(VARCHAR(5), ERROR_LINE()) + ']. ' + ERROR_MESSAGE()
	SET @xmlString = (SELECT @errorCode '@errorCode', @errorString '@errorMessage' FOR XML PATH('App_GeoLocationsResponse'))
END CATCH
IF object_id('tempdb.dbo.#tempClientIds') IS NOT NULL DROP TABLE #tempClientIds
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetGeoLocations')
	delete from GxQscripts where name = 'APPGetGeoLocations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetGeoLocations')
	delete from GXDBVersions where aliasname = 'APPGetGeoLocations'
GO

insert into GXDBVersions values(2, 'APPGetGeoLocations',  '00000000000000000000', 'APPGetGeoLocations', '00000000000000000000')
GO

