

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetFirewallPortRange.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  APPGetFirewallPortRange()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:  Returns firewall additional ports for a given client if they exist.
--	|				Otherwise returns the firewall additional ports specified on ALL parent groups.
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Srilatha Neralla			  Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetFirewallPortRange <<<'

IF EXISTS (select * from sysobjects where name='APPGetFirewallPortRange')
	drop procedure APPGetFirewallPortRange
IF EXISTS (select * from GxQscripts where name='APPGetFirewallPortRange')
	delete from GxQscripts where name = 'APPGetFirewallPortRange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFirewallPortRange')
	delete from GXDBVersions where aliasname = 'APPGetFirewallPortRange'
GO
print '... Creating Procedure: APPGetFirewallPortRange'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetFirewallPortRange
  @i_clientId integer
AS
  DECLARE @o_startPort integer
  DECLARE @o_endPort integer
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN
DECLARE @FWAddtionalPorts TABLE (startPort INTEGER,
									endPort INTEGER)
INSERT INTO @FWAddtionalPorts
SELECT startPort, endPort
FROM APP_FWPortRange
WHERE clientId=@i_clientId
DECLARE @rCnt INT = @@ROWCOUNT
IF (@rCnt=0)
BEGIN
--Portrange of the client group is considered when no port range is set for client
	INSERT INTO @FWAddtionalPorts
	SELECT FWPR.startPort, FWPR.endPort
	FROM APP_FWPortRange FWPR
	JOIN APP_ClientGroupAssoc CGA
	ON FWPR.clientGroupId=CGA.clientGroupId
	WHERE CGA.clientId=@i_clientId
END
SELECT startPort, endPort
FROM @FWAddtionalPorts
END

IF EXISTS (select * from GxQscripts where name = 'APPGetFirewallPortRange')
	delete from GxQscripts where name = 'APPGetFirewallPortRange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFirewallPortRange')
	delete from GXDBVersions where aliasname = 'APPGetFirewallPortRange'
GO

insert into GXDBVersions values(2, 'APPGetFirewallPortRange',  '00000000000000000000', 'APPGetFirewallPortRange', '00000000000000000000')
GO

