

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetFirewallOptions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetFirewallOptions.sp,v $ $Id: APPGetFirewallOptions.sp,v 1.11.86.13 2019/05/13 22:17:14 sneralla Exp $";
--
--  +========================================================================+
--  |   Procedure:  APPGetFirewallOptions()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:  Returns firewall options for a
-- 	|				given client.
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Bhavyan Mehta   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetFirewallOptions')
BEGIN
	print '>>> Drop Stored Procedure: APPGetFirewallOptions <<<'
	drop procedure APPGetFirewallOptions
END
IF EXISTS (select * from GxQscripts where name='APPGetFirewallOptions')
	delete from GxQscripts where name = 'APPGetFirewallOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFirewallOptions')
	delete from GXDBVersions where aliasname = 'APPGetFirewallOptions'
GO
print '... Creating Procedure: APPGetFirewallOptions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetFirewallOptions
  @i_clientId integer,
  @i_clientGroupId integer=0
AS
  DECLARE @o_isDMZ integer
  DECLARE @o_tunnelconnectionPort integer
  DECLARE @o_keepAliveSeconds integer
  DECLARE @o_tunnelInitSeconds integer
  DECLARE @o_foreceSSL integer
  DECLARE @o_lockDown integer
  DECLARE @o_bindOpenPortsOnly integer
  DECLARE @o_isRoamingClient integer
  DECLARE @o_isExternalOfViaProxyTopology integer
  DECLARE @o_isProxyOfViaProxyTopology integer
  DECLARE @o_extendedprop XML
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
DECLARE @isExternalOfViaProxyTopology integer = 0
DECLARE @isProxyOfViaProxyTopology integer = 0
BEGIN
IF object_id('tempdb.dbo.#fwOptionsTable') IS NOT NULL
	DROP TABLE #fwOptionsTable
CREATE TABLE #fwOptionsTable( t_isDMZ integer,
							   t_tunnelconnectionPort integer,
							   t_keepAliveSeconds integer,
							   t_tunnelInitSeconds integer,
							   t_foreceSSL integer,
							   t_lockDown integer,
							   t_bindOpenPortsOnly integer,
							   t_isRoamingClient integer,
							   t_isExternalOfViaProxyTopology integer,
							   t_isProxyOfViaProxyTopology integer,
							   t_extendedProperties	xml,
							   t_parentEntityId integer
							 )
IF EXISTS (SELECT 1 FROM APP_FirewallTopologyAssoc AFTA INNER JOIN App_FirewallTopology AFT ON AFTA.topologyId = AFT.topologyId WHERE AFT.topologyType = 1 AND AFT.flag & 1 <> 1 AND AFTA.fwGroupType = 2 AND AFTA.groupId = @i_clientGroupId)
	SELECT @isExternalOfViaProxyTopology = 1
IF EXISTS (SELECT 1 FROM APP_FirewallTopologyAssoc AFTA INNER JOIN App_FirewallTopology AFT ON AFTA.topologyId = AFT.topologyId WHERE AFT.topologyType = 1 AND AFT.flag & 1 <> 1 AND AFTA.fwGroupType = 3 AND AFTA.groupId = @i_clientGroupId)
	SET @isProxyOfViaProxyTopology = 1
INSERT INTO #fwOptionsTable
SELECT isDMZ,tunnelconnectionPort,keepAliveSeconds,tunnelInitSeconds,foreceSSL,lockDown,bindOpenPortsOnly,isRoamingClient, @isExternalOfViaProxyTopology,
							   @isProxyOfViaProxyTopology,extendedProperties, CASE @i_clientId WHEN NULL THEN @i_clientGroupId ELSE @i_clientId END
FROM APP_FirewallOptions AFO
WHERE ((@i_clientId <> 0 AND AFO.clientId = @i_clientId) OR (@i_clientId = 0 AND @i_clientGroupId <> 0 AND AFO.clientGroupId = @i_clientGroupId)) AND (AFO.flag & 4<>4)
DECLARE @configureAutomatically integer = 0
DECLARE @defaultTunnelPort integer = 8403
IF EXISTS ( SELECT * FROM #fwOptionsTable )
BEGIN
	IF EXISTS (SELECT 1 FROM #fwOptionsTable WHERE (SELECT ISNULL(EP.value('@configureAutomatically','INT'),0) FROM t_extendedProperties.nodes ('App_FirewallExtendedProperties') ref (EP)) = 1)
		SET @configureAutomatically = 1
	SELECT t_isDMZ,
			CASE @configureAutomatically
				WHEN 1
					THEN
					ISNULL((SELECT
								CASE cvdPort
									WHEN 0
										THEN @defaultTunnelPort
									ELSE
										cvdPort + 3
									END
							 FROM App_Client
							 WHERE id=@i_clientId), 0)
				ELSE
					t_tunnelconnectionPort
				END
			, t_keepAliveSeconds, t_tunnelInitSeconds, t_foreceSSL, t_lockDown, t_bindOpenPortsOnly, t_isRoamingClient, t_isExternalOfViaProxyTopology,
							   t_isProxyOfViaProxyTopology, t_extendedProperties
			FROM #fwOptionsTable
END
ELSE
BEGIN
	INSERT INTO #fwOptionsTable
    SELECT isDMZ,tunnelconnectionPort,keepAliveSeconds,tunnelInitSeconds,foreceSSL,lockDown,bindOpenPortsOnly,isRoamingClient, @isExternalOfViaProxyTopology,
							   @isProxyOfViaProxyTopology,extendedProperties, CG.clientGroupId
    FROM APP_FirewallOptions FW JOIN APP_ClientGroupAssoc CG
ON FW.clientGroupId = CG.clientGroupId AND CG.clientId = @i_clientId AND ( FW.flag =0 OR ((FW.flag & (~4)) <> 0))
	--Getting preferable values out of multiple configurations from client groups the client is associated to
	DECLARE @isRoamingClient integer = 0
	DECLARE @isDMZ integer = 0
	DECLARE @forceSSL integer = 0
	DECLARE @defaultOutgoingProtocol integer = 0
	DECLARE @extendedProperties xml
	DECLARE @overrideTunnelPort INT = 0
	SELECT @isRoamingClient=MAX(t_isRoamingClient), @isDMZ=MAX(t_isDMZ), @forceSSL=MAX(t_foreceSSL)
	FROM #fwOptionsTable
	-- By default, we do not consider Firewall Options from Smart topologies
	-- But we want to consider the proxy flag (isDMZ) irrespective of the level configured at
	SELECT top 1 @isDMZ = 1
	FROM App_FirewallOptions FW
	INNER JOIN App_ClientGroupAssoc ACGA
	ON FW.clientGroupid = ACGA.clientGroupId AND ACGA.clientId = @i_clientId WHERE FW.isDMZ<>0
	/*
	*	Ignore entries where configureAutomatically attribute is not present.
	*	configureAutomatically was introduced only on V11 SP4. The clients configured before that, do not have this attribute
	*/
	IF EXISTS (SELECT 1 FROM #fwOptionsTable WHERE (SELECT ISNULL(EP.value('@configureAutomatically','INT'),0) FROM t_extendedProperties.nodes ('App_FirewallExtendedProperties') ref (EP)) = 0)
		SET @overrideTunnelPort = 1
	DECLARE @tunnelPort INT
	IF @overrideTunnelPort = 1
	BEGIN
		SELECT TOP 1 @tunnelPort = FW.t_tunnelconnectionPort
		FROM #fwOptionsTable FW
		CROSS APPLY FW.t_extendedProperties.nodes('App_FirewallExtendedProperties') nodes(f)
		INNER JOIN APP_ClientGroup ACG
		ON FW.t_parentEntityId = ACG.id
		WHERE ISNULL(nodes.f.value('@configureAutomatically', 'INT'), 0) = 0
	END
IF EXISTS (SELECT 1 FROM #fwOptionsTable WHERE (SELECT ISNULL(EP.value('@defaultOutgoingProtocol','INT'),0) FROM t_extendedProperties.nodes ('App_FirewallExtendedProperties') ref (EP)) = 1)
SET @defaultOutgoingProtocol = 1
ELSE IF EXISTS (SELECT 1 FROM #fwOptionsTable WHERE (SELECT ISNULL(EP.value('@defaultOutgoingProtocol','INT'),0) FROM t_extendedProperties.nodes ('App_FirewallExtendedProperties') ref (EP)) = 2)
SET @defaultOutgoingProtocol = 2
ELSE IF EXISTS (SELECT 1 FROM #fwOptionsTable WHERE (SELECT ISNULL(EP.value('@defaultOutgoingProtocol','INT'),0) FROM t_extendedProperties.nodes ('App_FirewallExtendedProperties') ref (EP)) = 0)
SET @defaultOutgoingProtocol = 0
	ELSE
SET @defaultOutgoingProtocol = 3
	SET @extendedProperties = (SELECT @defaultOutgoingProtocol as '@defaultOutgoingProtocol', @configureAutomatically as '@configureAutomatically' FOR XML PATH ('App_FirewallExtendedProperties'))
		SELECT TOP 1 @isDMZ AS isDMZ,
					CASE @overrideTunnelPort
						WHEN 0
							THEN
							ISNULL((SELECT
										CASE cvdPort
											WHEN 0
												THEN  @defaultTunnelPort
											ELSE
												cvdPort + 3
											END
									FROM App_Client
									WHERE id=@i_clientId), 0)
						ELSE
							@tunnelPort
						END		AS tunnelConnectionPort
		 , t_keepAliveSeconds, t_tunnelInitSeconds, @forceSSL AS forceSSL, t_lockDown, t_bindOpenPortsOnly, @isRoamingClient AS isRoamingClient, t_isExternalOfViaProxyTopology,
								   t_isProxyOfViaProxyTopology, @extendedProperties
	    FROM #fwOptionsTable
END
END
DROP TABLE #fwOptionsTable
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetFirewallOptions')
	delete from GxQscripts where name = 'APPGetFirewallOptions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFirewallOptions')
	delete from GXDBVersions where aliasname = 'APPGetFirewallOptions'
GO

insert into GXDBVersions values(2, 'APPGetFirewallOptions',  '00010011008600130000', 'APPGetFirewallOptions', '00010011008600130000')
GO

