

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetFileMonitoringClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+===================================================================+
--	| APPGetFileMonitoringClients
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetFileMonitoringClients')
BEGIN
	print '>>> Drop Stored Procedure: APPGetFileMonitoringClients <<<'
	drop procedure APPGetFileMonitoringClients
END
IF EXISTS (select * from GxQscripts where name='APPGetFileMonitoringClients')
	delete from GxQscripts where name = 'APPGetFileMonitoringClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFileMonitoringClients')
	delete from GXDBVersions where aliasname = 'APPGetFileMonitoringClients'
GO
print '... Creating Procedure: APPGetFileMonitoringClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetFileMonitoringClients
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
-----------------------------------------------------------
  @filerName VARCHAR(1024)
-----------------------------------------------------------
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--
BEGIN
	;WITH CTE1 AS
	(
		SELECT dsp.DataSourceId
		FROM SEDataSourceProperty DSP join
			SEProperty P
			on P.PropertyId = DSP.PropertyId and P.PropertyName = 'hostname' and DSP.PropertyValue = @filerName
	),
	CTE AS (
			SELECT DataSourceId AS DataSourceId, [accessnodeclientid] 'accessClientId' , [enablemonitoring] 'EnableMonitoring'
			FROM
			(   SELECT DSP.DataSourceId, DSP.PropertyValue 'Value', p.PropertyName
				FROM SEDataSourceProperty DSP  WITH (NOLOCK)  INNER JOIN
						CTE1 ON CTE1.DataSourceId = DSP.DataSourceId
					INNER JOIN  SEProperty P ON DSP.PropertyId = P.PropertyId
					WHERE P.PropertyName IN ('accessnodeclientid', 'enablemonitoring')
			) AS SourceTable
			PIVOT
			( MIN(Value) FOR PropertyName IN ([accessnodeclientid], [enablemonitoring]) ) AS PivotTable
		)
		SELECT distinct accessClientId as ClientId FROM CTE WHERE EnableMonitoring = 'True'
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetFileMonitoringClients')
	delete from GxQscripts where name = 'APPGetFileMonitoringClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFileMonitoringClients')
	delete from GXDBVersions where aliasname = 'APPGetFileMonitoringClients'
GO

insert into GXDBVersions values(2, 'APPGetFileMonitoringClients',  '00000000000000000000', 'APPGetFileMonitoringClients', '00000000000000000000')
GO

