

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetFWTrivialFirewallDetails.sp] ---------- 

-- ==================================================================================================================
--  Author:         	Kaushal Ghai
--  Create date:        22/06/2012
--  Description:        To provide the Trivial Firewall Details of a client.
--
--  Input : : 		clientId
--  Output : :  	If FW Conf is set for the client, then give the trivial details of the client itself.
--					Otherwise look for the clientGroup it inherits and FW Config is set for it. Five those details.
--					At last give the default details.
--
-- ====================================================================================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetFWTrivialFirewallDetails <<<'

IF EXISTS (select * from sysobjects where name='APPGetFWTrivialFirewallDetails')
	drop procedure APPGetFWTrivialFirewallDetails
IF EXISTS (select * from GxQscripts where name='APPGetFWTrivialFirewallDetails')
	delete from GxQscripts where name = 'APPGetFWTrivialFirewallDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFWTrivialFirewallDetails')
	delete from GXDBVersions where aliasname = 'APPGetFWTrivialFirewallDetails'
GO
print '... Creating Procedure: APPGetFWTrivialFirewallDetails'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure APPGetFWTrivialFirewallDetails
  @clientId integer
AS
  DECLARE @o_isTrivialConfig integer
  DECLARE @o_connectionTypeCS integer
  DECLARE @o_connectionTypeMA integer
  DECLARE @o_networkTypeCS integer
  DECLARE @o_networkTypeMA integer
  DECLARE @o_proxyClientIdCS integer
  DECLARE @o_proxyClientIdMA integer
  DECLARE @o_proxyNameCS nchar(255)
  DECLARE @o_proxyNameMA nchar(255)
  DECLARE @o_proxyHostNameCS nchar(255)
  DECLARE @o_proxyHostNameMA nchar(255)
  DECLARE @o_proxyGUIDCS nchar(255)
  DECLARE @o_proxyGUIDMA nchar(255)
DECLARE @clientGroupId integer
DECLARE @releaseIdProxyCS integer
DECLARE @releaseIdProxyMA integer
DECLARE @outTable TABLE(
  isTrivialConfig integer,
  connectionTypeCS integer,
  connectionTypeMA integer,
  networkTypeCS integer,
  networkTypeMA integer,
  proxyClientIdCS integer,
  proxyClientIdMA integer,
  proxyNameCS nchar(255),
  proxyNameMA nchar(255),
  proxyHostNameCS nchar(255),
  proxyHostNameMA nchar(255),
  proxyGUIDCS nchar(255),
  proxyGUIDMA nchar(255)
)
SET  @clientGroupId = ( select TOP 1 CG.id
	 FROM APP_ClientGroupAssoc CGA, APP_ClientGroup CG
	 WHERE @clientId <> 0 and CGA.clientId = @clientId	and CG.id = CGA.clientGroupId AND
	 CGA.clientGroupId IN (select clientGroupId from App_FWTrivialConfig where clientId = 0 and isTrivialConfig <> 0))
  IF Exists (select * from App_FWTrivialConfig where clientId = @clientId and isTrivialConfig <> 0)
  BEGIN
  SELECT @o_isTrivialConfig = isTrivialConfig, @o_connectionTypeCS = connectionWithCS, @o_connectionTypeMA = connectionWithMA, @o_networkTypeCS = networkWithCS,
		 @o_networkTypeMA = networkWithMA, @o_proxyClientIdCS = proxyClientIdCS, @o_proxyClientIdMA = proxyClientIdMA
		 FROM App_FWTrivialConfig
		 WHERE
		 clientId = @clientId AND isTrivialConfig <> 0
  SELECT @o_proxyNameCS = name, @o_proxyHostNameCS = net_hostname, @o_proxyGUIDCS = GUID, @releaseIdProxyCS = releaseId
		 FROM APP_Client with (nolock)
		 WHERE
		 id = @o_proxyClientIdCS
  SELECT @o_proxyNameMA = name, @o_proxyHostNameMA = net_hostname, @o_proxyGUIDMA = GUID, @releaseIdProxyMA = releaseId
		 FROM APP_Client with (nolock)
		 WHERE
		 id = @o_proxyClientIdMA
 END
 ELSE IF @clientGroupId > 0
 BEGIN
 SELECT @o_isTrivialConfig = isTrivialConfig, @o_connectionTypeCS = connectionWithCS, @o_connectionTypeMA = connectionWithMA, @o_networkTypeCS = networkWithCS,
		 @o_networkTypeMA = networkWithMA, @o_proxyClientIdCS = proxyClientIdCS, @o_proxyClientIdMA = proxyClientIdMA
		 FROM App_FWTrivialConfig
		 WHERE
		 clientGroupId = @clientGroupId AND isTrivialConfig <> 0
  SELECT @o_proxyNameCS = name, @o_proxyHostNameCS = net_hostname, @o_proxyGUIDCS = GUID, @releaseIdProxyCS = releaseId
		 FROM APP_Client with (nolock)
		 WHERE
		 id = @o_proxyClientIdCS
  SELECT @o_proxyNameMA = name, @o_proxyHostNameMA = net_hostname, @o_proxyGUIDMA = GUID, @releaseIdProxyMA = releaseId
		 FROM APP_Client with (nolock)
		 WHERE
		 id = @o_proxyClientIdMA
  END
  ELSE
  BEGIN
  SELECT @o_isTrivialConfig = 0, @o_connectionTypeCS = 1, @o_connectionTypeMA = 1, @o_networkTypeCS = 1, @o_networkTypeMA = 1, @o_proxyClientIdCS = 1, @o_proxyClientIdMA = 1, @o_proxyNameCS = '',
		 @o_proxyNameMA = '',  @o_proxyHostNameCS = '', @o_proxyHostNameMA = '', @o_proxyGUIDCS = '', @o_proxyGUIDMA = '', @releaseIdProxyCS = 0, @releaseIdProxyMA = 0
  END
  INSERT INTO @outTable
  SELECT @o_isTrivialConfig , @o_connectionTypeCS , @o_connectionTypeMA , @o_networkTypeCS , @o_networkTypeMA , @o_proxyClientIdCS , @o_proxyClientIdMA ,
			@o_proxyNameCS , @o_proxyNameMA , @o_proxyHostNameCS , @o_proxyHostNameMA , CASE  WHEN @releaseIdProxyCS >= 14 Then @o_proxyGUIDCS Else '' END, CASE  WHEN @releaseIdProxyMA >= 14 Then @o_proxyGUIDMA Else '' END
 SELECT isTrivialConfig , connectionTypeCS ,connectionTypeMA ,networkTypeCS ,networkTypeMA ,proxyClientIdCS ,proxyClientIdMA ,proxyNameCS ,proxyNameMA ,proxyHostNameCS ,proxyHostNameMA ,proxyGUIDCS ,proxyGUIDMA
 FROM @outTable
 WHERE isTrivialConfig > 0
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetFWTrivialFirewallDetails')
	delete from GxQscripts where name = 'APPGetFWTrivialFirewallDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFWTrivialFirewallDetails')
	delete from GXDBVersions where aliasname = 'APPGetFWTrivialFirewallDetails'
GO

insert into GXDBVersions values(2, 'APPGetFWTrivialFirewallDetails',  '00000000000000000000', 'APPGetFWTrivialFirewallDetails', '00000000000000000000')
GO

