

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetFWRestrictionToForTopology.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +============================================================================================================+
--  |   Procedure	:  APPGetFWRestrictionToForTopology
--  |
--  | 	Description	:  xxxxxxxxxxx
--  |
--  |   Input		:  clientId
--  |
--  |   Output		:  List of clientIds and the restriction type for clients that have restriction TO this client
--  |
--	|	Return		:  xxxxxxxxxxx
--  |
--  |   Revision	Author					Description
--  |   --------  	-------					--------------------------------
--  |   1.1        	kmokshagundam   		Initial Edit
--  +=============================================================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetFWRestrictionToForTopology <<<'

IF EXISTS (select * from sysobjects where name='APPGetFWRestrictionToForTopology')
	drop procedure APPGetFWRestrictionToForTopology
IF EXISTS (select * from GxQscripts where name='APPGetFWRestrictionToForTopology')
	delete from GxQscripts where name = 'APPGetFWRestrictionToForTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFWRestrictionToForTopology')
	delete from GXDBVersions where aliasname = 'APPGetFWRestrictionToForTopology'
GO
print '... Creating Procedure: APPGetFWRestrictionToForTopology'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure APPGetFWRestrictionToForTopology
  @clientId integer
AS
  DECLARE @o_clientId integer
  DECLARE @o_clientName nchar(255)
  DECLARE @o_clientHostName nchar(255)
  DECLARE @o_clientGUID nchar(255)
  DECLARE @o_restrictionType integer
  DECLARE @o_clientCVDPort integer
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @restrictionTbl TABLE (clientId INT,restrictionType INT)
INSERT INTO @restrictionTbl
SELECT forClientId, restrictionType
FROM APP_SmartTopologyClientAssoc
WHERE clientId = @clientId
SELECT DISTINCT rest.clientId, name, net_hostname, (case when releaseId < 15 then NULL else GUID end), restrictionType, cvdPort
FROM @restrictionTbl as rest INNER JOIN APP_Client ON rest.clientId = id AND releaseId >= 14
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetFWRestrictionToForTopology')
	delete from GxQscripts where name = 'APPGetFWRestrictionToForTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFWRestrictionToForTopology')
	delete from GXDBVersions where aliasname = 'APPGetFWRestrictionToForTopology'
GO

insert into GXDBVersions values(2, 'APPGetFWRestrictionToForTopology',  '00000000000000000000', 'APPGetFWRestrictionToForTopology', '00000000000000000000')
GO

