

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetFWRestrictionTo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetFWRestrictionTo.sp,v $ $Id: APPGetFWRestrictionTo.sp,v 1.8.180.5 2018/05/30 09:50:22 kmokshagundam Exp $";
--
--  +========================================================================+
--  |   Procedure:  APPGetFWRestrictionTo()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:  Returns list of restricted clients and the restriction type for a given client
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Krishna Dhakshinamoorthy   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetFWRestrictionTo <<<'

IF EXISTS (select * from sysobjects where name='APPGetFWRestrictionTo')
	drop procedure APPGetFWRestrictionTo
IF EXISTS (select * from GxQscripts where name='APPGetFWRestrictionTo')
	delete from GxQscripts where name = 'APPGetFWRestrictionTo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFWRestrictionTo')
	delete from GXDBVersions where aliasname = 'APPGetFWRestrictionTo'
GO
print '... Creating Procedure: APPGetFWRestrictionTo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetFWRestrictionTo
  @clientId integer
AS
  DECLARE @o_clientId integer
  DECLARE @o_clientName nchar(255)
  DECLARE @o_clientHostName nchar(255)
  DECLARE @o_clientGUID nchar(255)
  DECLARE @o_restrictionType integer
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @clientGroupTbl TABLE(clientGroup_id INT, restriction INT)
DECLARE @restrictionTbl TABLE (clientId INT,restriction INT)
INSERT INTO @clientGroupTbl
SELECT forClientGroupId, restrictionType
FROM	APP_Firewall as fw
WHERE	fw.clientId = @clientId
AND forClientGroupId <> 0
INSERT INTO @restrictionTbl
SELECT assoc.clientId forClientId,cg.restriction restrictionType
FROM APP_ClientGroupAssoc as assoc INNER JOIN @clientGroupTbl as cg ON assoc.clientGroupId =  cg.clientGroup_id
UNION
SELECT forClientId, restrictionType FROM APP_Firewall as fw
WHERE fw.clientId = @clientId AND forClientId<>0
UNION
SELECT forClientId, restrictionType
FROM APP_Firewall as FW INNER JOIN APP_ClientGroupAssoc CG
	ON FW.clientGroupId = CG.clientGroupId AND CG.clientId = @clientId
WHERE forClientId NOT IN (SELECT R.clientId FROM @restrictionTbl R) AND forClientId <> 0
UNION
SELECT AC.clientId, CG.restrictionType
FROM (
	SELECT forClientGroupId, restrictionType
	FROM APP_Firewall as FW INNER JOIN APP_ClientGroupAssoc CG
				ON FW.clientGroupId = CG.clientGroupId AND CG.clientId = @clientId
	WHERE forClientGroupId <> 0
) CG INNER JOIN APP_ClientGroupAssoc AC ON CG.forClientGroupId = AC.clientGroupId
WHERE AC.clientId NOT IN (SELECT R.clientId FROM @restrictionTbl R)
SELECT DISTINCT rest.clientId, name, net_hostname, (case when releaseId < 15 then NULL else GUID end), restriction
FROM @restrictionTbl as rest INNER JOIN APP_CLIENT ON rest.clientId = id AND releaseId >= 14
 SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetFWRestrictionTo')
	delete from GxQscripts where name = 'APPGetFWRestrictionTo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFWRestrictionTo')
	delete from GXDBVersions where aliasname = 'APPGetFWRestrictionTo'
GO

insert into GXDBVersions values(2, 'APPGetFWRestrictionTo',  '00010008018000050000', 'APPGetFWRestrictionTo', '00010008018000050000')
GO

