

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetFWRestrictionFromForTopology.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- $Id: APPGetFWRestrictionFromForTopology.sp,v 1.1.2.3 2018/03/22 01:36:41 jiechen Exp $;
--
--  +================================================================================================================+
--  |   Procedure	:  APPGetFWRestrictionFromForTopology
--  |
--  | 	Description	:  xxxxxxxxxxx
--  |
--  |   Input		:  clientId
--  |
--  |   Output		:  List of clientIds and the restriction type for clients that have restriction FROM this client
--  |
--	|	Return		:  xxxxxxxxxxx
--  |
--  |   Revision  	Author					Description
--  |   --------  	-------					--------------------------------
--  |   1.1        	kmokshagundam   		Initial Edit
--  +================================================================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetFWRestrictionFromForTopology <<<'

IF EXISTS (select * from sysobjects where name='APPGetFWRestrictionFromForTopology')
	drop procedure APPGetFWRestrictionFromForTopology
IF EXISTS (select * from GxQscripts where name='APPGetFWRestrictionFromForTopology')
	delete from GxQscripts where name = 'APPGetFWRestrictionFromForTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFWRestrictionFromForTopology')
	delete from GXDBVersions where aliasname = 'APPGetFWRestrictionFromForTopology'
GO
print '... Creating Procedure: APPGetFWRestrictionFromForTopology'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure APPGetFWRestrictionFromForTopology
  @clientId integer
AS
  DECLARE @o_clientId integer
  DECLARE @o_clientName nchar(255)
  DECLARE @o_clientHostName nchar(255)
  DECLARE @o_clientGUID nchar(255)
  DECLARE @o_restrictionType integer
  DECLARE @o_clientCVDPort integer
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @restrictionTbl TABLE (clientId INT,restrictionType INT)
INSERT INTO @restrictionTbl
SELECT clientId, restrictionType
FROM APP_SmartTopologyClientAssoc
WHERE forClientId = @clientId
SELECT DISTINCT rest.clientId, name, net_hostname, (case when releaseId < 15 then NULL else GUID end), restrictionType, cvdPort
FROM @restrictionTbl as rest INNER JOIN APP_Client ON rest.clientId = id AND releaseId >= 14
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetFWRestrictionFromForTopology')
	delete from GxQscripts where name = 'APPGetFWRestrictionFromForTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFWRestrictionFromForTopology')
	delete from GXDBVersions where aliasname = 'APPGetFWRestrictionFromForTopology'
GO

insert into GXDBVersions values(2, 'APPGetFWRestrictionFromForTopology',  '00010001000200030000', 'APPGetFWRestrictionFromForTopology', '00010001000200030000')
GO

