

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetFWRestrictionFrom.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetFWRestrictionFrom.sp,v $ $Id: APPGetFWRestrictionFrom.sp,v 1.11.180.5 2018/05/28 15:01:00 kmokshagundam Exp $";
--
--  +========================================================================+
--  |   Procedure:  APPGetFWRestrictionFrom()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:  Returns list of clients to which the given client is restricted
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Krishna Dhakshinamoorthy   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetFWRestrictionFrom <<<'

IF EXISTS (select * from sysobjects where name='APPGetFWRestrictionFrom')
	drop procedure APPGetFWRestrictionFrom
IF EXISTS (select * from GxQscripts where name='APPGetFWRestrictionFrom')
	delete from GxQscripts where name = 'APPGetFWRestrictionFrom'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFWRestrictionFrom')
	delete from GXDBVersions where aliasname = 'APPGetFWRestrictionFrom'
GO
print '... Creating Procedure: APPGetFWRestrictionFrom'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetFWRestrictionFrom
  @clientId integer
AS
  DECLARE @o_clientId integer
  DECLARE @o_clientName nchar(255)
  DECLARE @o_clientHostName nchar(255)
  DECLARE @o_clientGUID nchar(255)
  DECLARE @o_restrictionType integer
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @restrictionTbl TABLE (clientId INT,restrictionType INT)
INSERT INTO @restrictionTbl
SELECT FW.clientId, FW.restrictionType
FROM APP_Firewall FW
WHERE FW.forClientId = @clientId AND @clientId <> 0
UNION
SELECT CG.clientId, FW.restrictionType
FROM APP_Firewall FW INNER JOIN APP_ClientGroupAssoc CG ON FW.clientGroupId = CG.clientGroupId
WHERE FW.forClientId = @clientId and @clientId <> 0
UNION
SELECT FW.clientId, restrictionType
FROM APP_Firewall FW INNER JOIN APP_ClientGroupAssoc CG ON FW.forClientGroupId = CG.clientGroupId
WHERE CG.clientId = @clientId
UNION
SELECT CG.clientId,FW.restrictionType
FROM (SELECT FW.clientGroupId,FW.restrictionType
      FROM APP_Firewall FW INNER JOIN APP_ClientGroupAssoc CG ON FW.forClientGroupId = CG.clientGroupId
      WHERE CG.clientId = @clientId ) FW INNER JOIN APP_ClientGroupAssoc CG ON FW.clientGroupId = CG.clientGroupId
SELECT DISTINCT rest.clientId, name, net_hostname, (case when releaseId < 15 then NULL else GUID end), restrictionType
FROM @restrictionTbl as rest INNER JOIN APP_CLIENT ON rest.clientId = id AND releaseId >= 14
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetFWRestrictionFrom')
	delete from GxQscripts where name = 'APPGetFWRestrictionFrom'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFWRestrictionFrom')
	delete from GXDBVersions where aliasname = 'APPGetFWRestrictionFrom'
GO

insert into GXDBVersions values(2, 'APPGetFWRestrictionFrom',  '00010011018000050000', 'APPGetFWRestrictionFrom', '00010011018000050000')
GO

