

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetFLASummary.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetFLASummary.sp,v $ $Id: APPGetFLASummary.sp,v 1.1.2.5 2018/07/21 22:32:10 pankajkumar Exp $";
SET NOCOUNT ON
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "APPGetFLASummary"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetFLASummary <<<'

IF EXISTS (select * from sysobjects where name='APPGetFLASummary')
	drop procedure APPGetFLASummary
IF EXISTS (select * from GxQscripts where name='APPGetFLASummary')
	delete from GxQscripts where name = 'APPGetFLASummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFLASummary')
	delete from GXDBVersions where aliasname = 'APPGetFLASummary'
GO
print '... Creating Procedure: APPGetFLASummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetFLASummary
  @i_userId int = 0,
  @i_capability bigint = 13,
  @o_XMLText XML OUTPUT
AS
SET NOCOUNT ON
DECLARE @tblApptypes    TABLE (t_appTypeId int)
--Supported apptypes for file anlaytics
	--Windows FS apptypes
	INSERT INTO @tblAppTypes
VALUES (11), 	(42),	(43),	(33),	(43)
	--NAS apptypes
INSERT INTO @tblAppTypes VALUES (13)
	--Unix FS apptypes
	INSERT INTO @tblAppTypes
VALUES	(17), 		(18),		(17),		(19),		(19),
(20),		(21),		(29),		(38),		(36),
(63),		(64),		(74)
--
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
BEGIN
		DECLARE @isAllAssociationsSetBrowse INT = 0
		DECLARE @isAllAssociationsSetEnduser INT = 0
		IF object_id('tempdb.dbo.#clientEntity') IS NOT null DROP TABLE #clientEntity
		create table  #clientEntity	(
				clientId	integer,
				hasBrowse	integer,   --1-Browse, 0 - Enduser
				Primary key (clientId)
			 )
		--get ALL association COMMCELL LEVEL check BROWSE
EXEC sec_checkPermissionOnEntity @i_userId, @i_capability /*EV_BROWSE*/, @isAllAssociationsSetBrowse OUTPUT, 1 /*COMMCELL_ENTITY*/, 2
		IF @isAllAssociationsSetBrowse = 0
		BEGIN
			--get ALL association COMMCELL LEVEL check ENDUSER
EXEC sec_checkPermissionOnEntity @i_userId, 24 /*EV_FAST_ENDUSER_SEARCH*/, @isAllAssociationsSetEnduser OUTPUT, 1 /*COMMCELL_ENTITY*/, 2
		END
		--if ALL association is set, get list of associated clients
		IF @isAllAssociationsSetBrowse = 1 OR @isAllAssociationsSetEnduser = 1
		BEGIN
			INSERT INTO #clientEntity
			SELECT DISTINCT C.iD , @isAllAssociationsSetBrowse
			FROM APP_Client C (NOLOCK)
			JOIN APP_Application AP (NOLOCK) ON C.Id = AP.clientId
			JOIN @tblAppTypes t ON AP.appTypeId = t.t_appTypeId
WHERE (status & 0x10000000) = 0  --exclude edge drive clients
		END
		ELSE --if ALL association is NOT set, get list of associated clients
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#flaclientLst1') IS NOT NULL DROP TABLE #flaclientLst1
			CREATE TABLE #flaclientLst1
			(
				t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
			)
			--EV_BROWSE CAPABILITY
EXEC sec_getIdaObjectsForUser @i_userId, 3 /*CLIENT_ENTITY*/ , @i_capability, 0, '#flaclientLst1'
			INSERT INTO #clientEntity (clientId, hasBrowse)
			SELECT DISTINCT t_clientId, 1
			FROM	#flaclientLst1 F
			JOIN APP_Client C (NOLOCK)  ON F.t_clientId = C.id
			JOIN APP_Application AP (NOLOCK) ON C.id = AP.clientId
			JOIN @tblAppTypes t ON AP.appTypeId = t.t_appTypeId
WHERE (C.status & 0x10000000) = 0  --exclude edge drive clients
			DROP TABLE #flaclientLst1
			IF OBJECT_ID('tempdb.dbo.#flaclientLst2') IS NOT NULL DROP TABLE #flaclientLst2
			CREATE TABLE #flaclientLst2
			(
				t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
			)
			--EV_FAST_ENDUSER_SEARCH CAPABILITY
EXEC sec_getIdaObjectsForUser @i_userId, 3 /*CLIENT_ENTITY*/ , 24, 0, '#flaclientLst2'
			--Delete existing clients
			DELETE  F
			FROM #flaclientLst2 F
			JOIN #clientEntity C ON C.clientId= F.t_clientId
			INSERT INTO #clientEntity
			SELECT DISTINCT t_clientId, 0
			FROM	#flaclientLst2 	F
			JOIN APP_Client C (NOLOCK)  ON F.t_clientId = C.id
			JOIN APP_Application AP (NOLOCK) ON C.id = AP.clientId
			JOIN @tblAppTypes t ON AP.appTypeId = t.t_appTypeId
WHERE (C.status & 0x10000000) = 0  --exclude edge drive clients
			DROP TABLE #flaclientLst2
		END
END
--get last analytics job run time for each client for which analytics job is run
IF object_id('tempdb.dbo.#tmpFLASummary') IS NOT null DROP TABLE #tmpFLASummary
	CREATE TABLE #tmpFLASummary (t_clientId INT,  t_pushedItems bigint , t_sizeInBytes bigint)
IF EXISTS (select TOP 1 1 from #clientEntity)
BEGIN
	INSERT INTO #tmpFLASummary
	SELECT DISTINCT C.clientId, pushedItemCount, B.totalUnCompBytes
	FROM #clientEntity C
		INNER JOIN APP_Application APP (NOLOCK) ON C.clientId = APP.clientId
		INNER JOIN ARCHFILE AF (NOLOCK) ON APP.id = AF.appId
		INNER JOIN JMBKPSTATS B (NOLOCK) ON APP.id = B.appId and AF.jobId = B.jobId and af.commCellId = B.commCellId
		INNER JOIN archFLAIndexingInfo FLA (NOLOCK)
				ON AF.id = FLA.archFileId AND pushedItemCount >=0 AND (FLA.flags & 64) >0
		--commcellId check is not needed, to support backup jobs run after client migration
END
--DELETE FROM CLIENTENTITY WHICH ARE ALREADY ANALYZED
DELETE T
FROM #clientEntity T
JOIN #tmpFLASummary L ON T.clientId =L.t_clientId
-- INCLUDE VM LIST FOR VSA ANALYTICS
IF EXISTS (SELECT TOP 1 1 FROM APP_ClientProp CP (NOLOCK) JOIN #clientEntity ON clientId =componentnameId WHERE attrName = 'AnalysisComplete' and attrVal = '1' )
BEGIN
	INSERT INTO #tmpFLASummary (t_clientId)
	SELECT componentNameId
	FROM APP_ClientProp CP (NOLOCK)
		INNER JOIN #tmpFLASummary c on cp.componentNameId =c.t_clientId
	WHERE modified = 0 and attrName = 'AnalysisComplete' and attrVal = '1'
END
DROP TABLE #clientEntity
--SELECT * FROM #tmpFLASummary
SET @o_XMLText = ISNULL(( 	SELECT
							4 AS '@analyticsReqType',
							(
								SELECT
								(SELECT Id FROM APP_CommCell (NOLOCK) WHERE ID =2) AS '@commcellId',
								(SELECT COUNT(DISTINCT t_clientId) FROM #tmpFLASummary) AS '@clientCount',
								(SELECT COUNT(DISTINCT clientGroupId) FROM APP_ClientGroupAssoc CGA (nolock) join #tmpFLASummary t on CGA.clientId = t.t_clientId) AS '@clientGroupCount',
								(SELECT SUM(t_sizeInBytes) FROM #tmpFLASummary) AS '@sizeInBytes',
								(SELECT SUM(t_pushedItems) FROM #tmpFLASummary) AS '@itemsCount'
							FOR XML PATH('analyticsSummary'), TYPE
					 ) FOR XML PATH('DM2ContentIndexing_AnalyticsGroupResp')
					 ),'<DM2ContentIndexing_AnalyticsGroupResp/>')
DROP TABLE #tmpFLASummary
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetFLASummary')
	delete from GxQscripts where name = 'APPGetFLASummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFLASummary')
	delete from GXDBVersions where aliasname = 'APPGetFLASummary'
GO

insert into GXDBVersions values(2, 'APPGetFLASummary',  '00010001000200050000', 'APPGetFLASummary', '00010001000200050000')
GO

