

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetFLAExchangeServers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetFLAExchangeServers.sp,v $ $Id: APPGetFLAExchangeServers.sp,v 1.1.2.5 2018/07/21 22:32:07 pankajkumar Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "APPGetFLAExchangeServers"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetFLAExchangeServers <<<'

IF EXISTS (select * from sysobjects where name='APPGetFLAExchangeServers')
	drop procedure APPGetFLAExchangeServers
IF EXISTS (select * from GxQscripts where name='APPGetFLAExchangeServers')
	delete from GxQscripts where name = 'APPGetFLAExchangeServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFLAExchangeServers')
	delete from GXDBVersions where aliasname = 'APPGetFLAExchangeServers'
GO
print '... Creating Procedure: APPGetFLAExchangeServers'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetFLAExchangeServers
  @i_userId int = 0,
  @i_capability bigint = 13,
  @o_XMLText XML OUTPUT
AS
SET NOCOUNT ON
IF object_id('tempdb.dbo.#tmpClientTbl') IS NOT null DROP TABLE #tmpClientTbl
	CREATE TABLE #tmpClientTbl (clientId	integer,
				clientName  nvarchar(1024),
				clientGroupId	integer,
				clientGroupName nvarchar(1024),
				appTypeId	integer,
				instance  integer,
				lastAnalyticsTime integer,
				hasBrowse	int,
				Primary key (clientId, clientGroupId, appTypeId, instance)
			)
DECLARE @tblApptypes    TABLE (t_appTypeId int)
--Exchange apptypes
INSERT INTO @tblAppTypes VALUES (54)
INSERT INTO @tblAppTypes VALUES (56)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
BEGIN
		DECLARE @isAllAssociationsSetBrowse INT = 0
		DECLARE @isAllAssociationsSetEnduser INT = 0
		IF object_id('tempdb.dbo.#clientEntity') IS NOT null DROP TABLE #clientEntity
		create table  #clientEntity	(
				clientId	integer,
				hasBrowse	integer,   --1-Browse, 0 - Enduser
				Primary key (clientId)
			 )
		--get ALL association COMMCELL LEVEL check BROWSE
EXEC sec_checkPermissionOnEntity @i_userId, @i_capability /*EV_BROWSE*/, @isAllAssociationsSetBrowse OUTPUT, 1 /*COMMCELL_ENTITY*/, 2
		IF @isAllAssociationsSetBrowse = 0
		BEGIN
			--get ALL association COMMCELL LEVEL check ENDUSER
EXEC sec_checkPermissionOnEntity @i_userId, 24 /*EV_FAST_ENDUSER_SEARCH*/, @isAllAssociationsSetEnduser OUTPUT, 1 /*COMMCELL_ENTITY*/, 2
		END
		--if ALL association is set, get list of associated clients
		IF @isAllAssociationsSetBrowse = 1 OR @isAllAssociationsSetEnduser = 1
		BEGIN
			INSERT INTO #clientEntity
			SELECT DISTINCT C.iD , @isAllAssociationsSetBrowse
			FROM APP_Client C (NOLOCK)
			JOIN APP_Application AP (NOLOCK) ON C.Id = AP.clientId
			JOIN @tblAppTypes t ON AP.appTypeId = t.t_appTypeId
WHERE (status & 0x10000000) = 0  --exclude edge drive clients
		END
		ELSE --if ALL association is NOT set, get list of associated clients
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#flaclientLst1') IS NOT NULL DROP TABLE #flaclientLst1
			CREATE TABLE #flaclientLst1
			(
				t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
			)
			--EV_BROWSE CAPABILITY
EXEC sec_getIdaObjectsForUser @i_userId, 3 /*CLIENT_ENTITY*/ , @i_capability, 0, '#flaclientLst1'
			INSERT INTO #clientEntity (clientId, hasBrowse)
			SELECT DISTINCT t_clientId, 1
			FROM	#flaclientLst1 F
			JOIN APP_Client C (NOLOCK)  ON F.t_clientId = C.id
			JOIN APP_Application AP (NOLOCK) ON C.id = AP.clientId
			JOIN @tblAppTypes t ON AP.appTypeId = t.t_appTypeId
WHERE (C.status & 0x10000000) = 0  --exclude edge drive clients
			DROP TABLE #flaclientLst1
			IF OBJECT_ID('tempdb.dbo.#flaclientLst2') IS NOT NULL DROP TABLE #flaclientLst2
			CREATE TABLE #flaclientLst2
			(
				t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
			)
			--EV_FAST_ENDUSER_SEARCH CAPABILITY
EXEC sec_getIdaObjectsForUser @i_userId, 3 /*CLIENT_ENTITY*/ , 24, 0, '#flaclientLst2'
			--Delete existing clients
			DELETE  F
			FROM #flaclientLst2 F
			JOIN #clientEntity C ON C.clientId= F.t_clientId
			INSERT INTO #clientEntity
			SELECT DISTINCT t_clientId, 0
			FROM	#flaclientLst2 	F
			JOIN APP_Client C (NOLOCK)  ON F.t_clientId = C.id
			JOIN APP_Application AP (NOLOCK) ON C.id = AP.clientId
			JOIN @tblAppTypes t ON AP.appTypeId = t.t_appTypeId
WHERE (C.status & 0x10000000) = 0  --exclude edge drive clients
			DROP TABLE #flaclientLst2
		END
END
--get last analytics job run time for each client for which analytics job is run
IF object_id('tempdb.dbo.#lastAnalyticsStartTimeByClient') IS NOT null DROP TABLE #lastAnalyticsStartTimeByClient
	CREATE TABLE #lastAnalyticsStartTimeByClient (t_clientId INT, t_maxAnalyticTime INT Primary key (t_clientId))
IF EXISTS (select top 1 1 from #clientEntity)
BEGIN
	INSERT INTO #lastAnalyticsStartTimeByClient
	SELECT C.clientId, MAX(FLA.indexTime)
	FROM #clientEntity C
		INNER JOIN APP_Application APP WITH (NOLOCK) ON C.clientId = APP.clientId
		INNER JOIN @tblAppTypes ON APP.appTypeId = t_appTypeId
		INNER JOIN ARCHFILE AF WITH (NOLOCK) ON APP.id = AF.appId
		INNER JOIN archFLAIndexingInfo FLA WITH (NOLOCK)
				ON AF.id = FLA.archFileId AND (FLA.flags & 64) >0
		--commcellId check is not needed, to support backup jobs run after client migration
	GROUP BY C.clientId
END
INSERT INTO #tmpClientTbl (clientId, clientGroupId, appTypeId, instance, lastAnalyticsTime,	hasBrowse)
SELECT DISTINCT	APP.clientId, ISNULL(CGA.clientGroupId,0), APP.appTypeId, APP.instance, CC.t_maxAnalyticTime, C.hasBrowse
FROM	APP_application APP (NOLOCK)
		JOIN #lastAnalyticsStartTimeByClient CC ON	APP.clientId = CC.t_clientId
		JOIN #clientEntity C ON CC.t_clientId = C.clientId
		JOIN @tblAppTypes T ON APP.appTypeId = t_appTypeId
		LEFT JOIN  APP_ClientGroupAssoc CGA WITH (NOLOCK) ON APP.clientId = CGA.clientId
DROP TABLE #lastAnalyticsStartTimeByClient
DROP TABLE #clientEntity
IF EXISTS (select top 1 1 from #tmpClientTbl)
BEGIN
		--for new style of exchange pseudo client, get exchange servers name
	   declare @exchSvrName nvarchar(1024)
	   declare @memberServersXml XML
	   declare @clientId INT
	   --get all exchange pseudo clients
	    IF OBJECT_ID('tempdb.dbo.#exchangeServer') IS NOT NULL     DROP TABLE #exchangeServer
	    CREATE  TABLE #exchangeServer ( t_clientId INT, t_exchServersName NVARCHAR(1024) default '', t_memberServers XML, t_isExchDB int)
		INSERT INTO #exchangeServer (t_clientId, t_isExchDB)
		SELECT DISTINCT  clientId, 0
		from APP_ClientProp (NOLOCK), #tmpClientTbl
		where componentNameId =clientId and attrName = 'Exchange Pseudo Client' AND modified = 0
		--if any exchange pseudo (DAG) client exists
		IF EXISTS (SELECT top 1 1  from #exchangeServer)
		BEGIN
			--get exchange server name for exchange database idatype
			UPDATE #exchangeServer
			SET t_exchServersName = CP.attrName,
				t_isExchDB =1
			FROM APP_ClientProp CP (NOLOCK)
			WHERE CP.componentNameId = t_clientId AND CP.attrType =125 AND CP.modified = 0
			--get exchange server name for exchange mailbox idatype
			UPDATE #exchangeServer
			SET t_memberServers = CAST ( substring (P.attrVal, CHARINDEX('<App_MemberServers>',P.attrVal ), LEN(P.attrVal)-CHARINDEX('<App_MemberServers>',P.attrVal) +1)  AS XML)
			FROM APP_IDAProp P (NOLOCK)
			INNER JOIN APP_IDAName N (NOLOCK) ON  P.componentNameId = N.id
			WHERE appTypeId = 137
			   AND attrName = 'OnePass Member Servers' AND p.modified = 0
			   AND N.clientId = t_clientId
		   		AND t_isExchDB =0
			--get comma seperated exchanges servers name
			DECLARE ExchSvrInfoCursor CURSOR
			FOR	SELECT t_clientId, t_memberServers FROM #exchangeServer    WHERE t_isExchDB =0
			OPEN ExchSvrInfoCursor
			FETCH FROM ExchSvrInfoCursor INTO @clientId, @memberServersXml
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @exchSvrName = NULL
				SELECT @exchSvrName =  COALESCE( @exchSvrName + ',', '') +  T.ref.value('@clientName', 'varchar(512)')
						from @memberServersXml.nodes('/App_MemberServers/memberServers/client') T(ref)
				IF @exchSvrName is not null
					UPDATE #exchangeServer
					SET t_exchServersName = @exchSvrName
					WHERE T_clientId = @clientId
				FETCH FROM ExchSvrInfoCursor INTO @clientId, @memberServersXml
			END
			CLOSE ExchSvrInfoCursor
			DEALLOCATE ExchSvrInfoCursor
		END
	--for old style of exchange client, get exchange servers name
		INSERT INTO #exchangeServer (t_clientId, t_exchServersName)
		SELECT DISTINCT  clientId , attrVal
		from APP_InstanceProp (NOLOCK), #tmpClientTbl
		where componentNameId =instance and attrName = 'Server Name'
		and #tmpClientTbl.clientId NOT IN (select t_clientid from #exchangeServer)
	--
	UPDATE #tmpClientTbl
	SET clientName = name
	from APP_Client (nolock)
	where clientid =id
	UPDATE #tmpClientTbl
	SET clientGroupName = t_exchServersName
	from #exchangeServer
	where  t_clientId =clientid
END
--handle exchange server name for reference copy client
UPDATE #tmpClientTbl
SET clientGroupName =C.name
FROM #tmpClientTbl
INNER JOIN App_client C WITH (NOLOCK) ON clientId =C.id AND (C.status & 0x4000000) = 0x4000000
WHERE clientGroupName = ''
--SELECT * FROM #tmpClientTbl
SET @o_XMLText = ISNULL(( 	SELECT
						2 AS '@analyticsReqType',
						(
							SELECT
							clientGroupName AS '@clientGroupName',
							ISNULL(MAX(lastAnalyticsTime),0) AS '@lastAnalyticsTime',
							MAX(hasBrowse) AS '@hasBrowse',
							(SELECT
									T2.clientId AS '@clientId',
									T2.clientName AS '@clientName',
									ISNULL(T2.lastAnalyticsTime,0) AS '@lastAnalyticsTime',
									MAX(hasBrowse) AS '@hasBrowse',
								(SELECT
									T3.appTypeId AS '@applicationId'
									FROM #tmpClientTbl T3
									WHERE T3.clientGroupName = T.clientGroupName AND T3.clientId = T2.clientId
									GROUP BY T3.clientId, T3.appTypeId
									FOR XML PATH('subClients'), TYPE
								)
								FROM #tmpClientTbl T2
								WHERE T2.clientGroupName = T.clientGroupName
								GROUP BY T2.clientId, T2.clientName,  T2.lastAnalyticsTime
								FOR XML PATH('analyticsClients'), TYPE
							)
				FROM #tmpClientTbl T
				GROUP BY T.clientGroupName
				ORDER BY clientGroupName
					FOR XML PATH('analyticsGroups'), TYPE
					) FOR XML PATH('DM2ContentIndexing_AnalyticsGroupResp')
					),'<DM2ContentIndexing_AnalyticsGroupResp/>')
DROP TABLE #tmpClientTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetFLAExchangeServers')
	delete from GxQscripts where name = 'APPGetFLAExchangeServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFLAExchangeServers')
	delete from GXDBVersions where aliasname = 'APPGetFLAExchangeServers'
GO

insert into GXDBVersions values(2, 'APPGetFLAExchangeServers',  '00010001000200050000', 'APPGetFLAExchangeServers', '00010001000200050000')
GO

