

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetFLAClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetFLAClients.sp,v $ $Id: APPGetFLAClients.sp,v 1.1.2.10 2020/04/10 08:59:11 pankajkumar Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "APPGetFLAClients"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetFLAClients')
BEGIN
	print '>>> Drop Stored Procedure: APPGetFLAClients <<<'
	drop procedure APPGetFLAClients
END
IF EXISTS (select * from GxQscripts where name='APPGetFLAClients')
	delete from GxQscripts where name = 'APPGetFLAClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFLAClients')
	delete from GXDBVersions where aliasname = 'APPGetFLAClients'
GO
print '... Creating Procedure: APPGetFLAClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetFLAClients
  @i_userId int = 0,
  @i_clientId int = 0,
  @i_capability bigint = 13,
  @o_XMLText XML OUTPUT
AS
SET NOCOUNT ON
DECLARE @tblApptypes    TABLE (t_appTypeId int)
IF object_id('tempdb.dbo.#tmpClientTbl') IS NOT null DROP TABLE #tmpClientTbl
	CREATE TABLE #tmpClientTbl (clientId	integer,
				clientName  nvarchar(1024),
				appTypeId	integer,
				commcellId  integer,
				lastAnalyticsTime integer,
				hasBrowse	int,
				backupsetId integer default 0,
				Primary key (clientId, appTypeId, commcellId)
			)
--Windows FS apptypes
INSERT INTO @tblAppTypes
VALUES (11),
(42),
(43),
(33),
(43)
--NAS apptypes
INSERT INTO @tblAppTypes VALUES (13)
--VSA apptypes
INSERT INTO @tblAppTypes VALUES (106)
--Unix FS apptypes
INSERT INTO @tblAppTypes
VALUES	(17),
(18),
(17),
(19),
(19),
(20),
(21),
(29),
(38),
(36),
(63),
(64),
(74)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
BEGIN
		DECLARE @isAllAssociationsSetBrowse INT = 0
		DECLARE @isAllAssociationsSetEnduser INT = 0
		IF object_id('tempdb.dbo.#clientEntity') IS NOT null DROP TABLE #clientEntity
		create table  #clientEntity	(
				clientId	integer,
				hasBrowse	integer,   --1-Browse, 0 - Enduser
				Primary key (clientId)
			 )
		--get ALL association COMMCELL LEVEL check BROWSE
EXEC sec_checkPermissionOnEntity @i_userId, @i_capability /*EV_BROWSE*/, @isAllAssociationsSetBrowse OUTPUT, 1 /*COMMCELL_ENTITY*/, 2
		IF @isAllAssociationsSetBrowse = 0
		BEGIN
			--get ALL association COMMCELL LEVEL check ENDUSER
EXEC sec_checkPermissionOnEntity @i_userId, 24 /*EV_FAST_ENDUSER_SEARCH*/, @isAllAssociationsSetEnduser OUTPUT, 1 /*COMMCELL_ENTITY*/, 2
		END
		--if ALL association is set, get list of associated clients
		IF @isAllAssociationsSetBrowse = 1 OR @isAllAssociationsSetEnduser = 1
		BEGIN
			INSERT INTO #clientEntity
			SELECT DISTINCT C.iD , @isAllAssociationsSetBrowse
			FROM APP_Client C (NOLOCK)
			JOIN APP_Application AP (NOLOCK) ON C.Id = AP.clientId
			JOIN @tblAppTypes t ON AP.appTypeId = t.t_appTypeId
WHERE (status & 0x10000000) = 0  --exclude edge drive clients
		END
		ELSE --if ALL association is NOT set, get list of associated clients
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#flaclientLst1') IS NOT NULL DROP TABLE #flaclientLst1
			CREATE TABLE #flaclientLst1
			(
				t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
			)
			--EV_BROWSE CAPABILITY
EXEC sec_getIdaObjectsForUser @i_userId, 3 /*CLIENT_ENTITY*/ , @i_capability, 0, '#flaclientLst1'
			INSERT INTO #clientEntity (clientId, hasBrowse)
			SELECT DISTINCT t_clientId, 1
			FROM	#flaclientLst1 F
			JOIN APP_Client C (NOLOCK)  ON F.t_clientId = C.id
			JOIN APP_Application AP (NOLOCK) ON C.id = AP.clientId
			JOIN @tblAppTypes t ON AP.appTypeId = t.t_appTypeId
WHERE (C.status & 0x10000000) = 0  --exclude edge drive clients
			DROP TABLE #flaclientLst1
			IF OBJECT_ID('tempdb.dbo.#flaclientLst2') IS NOT NULL DROP TABLE #flaclientLst2
			CREATE TABLE #flaclientLst2
			(
				t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
			)
			--EV_FAST_ENDUSER_SEARCH CAPABILITY
EXEC sec_getIdaObjectsForUser @i_userId, 3 /*CLIENT_ENTITY*/ , 24, 0, '#flaclientLst2'
			--Delete existing clients
			DELETE  F
			FROM #flaclientLst2 F
			JOIN #clientEntity C ON C.clientId= F.t_clientId
			INSERT INTO #clientEntity
			SELECT DISTINCT t_clientId, 0
			FROM	#flaclientLst2 	F
			JOIN APP_Client C (NOLOCK)  ON F.t_clientId = C.id
			JOIN APP_Application AP (NOLOCK) ON C.id = AP.clientId
			JOIN @tblAppTypes t ON AP.appTypeId = t.t_appTypeId
WHERE (C.status & 0x10000000) = 0  --exclude edge drive clients
			DROP TABLE #flaclientLst2
		END
END
--if specific client input is provided, delete other client entries
IF @i_clientId > 0
	DELETE FROM #clientEntity WHERE clientId != @i_clientId
--get last analytics job run time for each client for which analytics job is run
IF object_id('tempdb.dbo.#lastAnalyticsStartTimeByClient') IS NOT null DROP TABLE #lastAnalyticsStartTimeByClient
	CREATE TABLE #lastAnalyticsStartTimeByClient (t_clientId INT, t_maxAnalyticTime INT Primary key (t_clientId))
IF EXISTS (select top 1 1 from #clientEntity)
BEGIN
	INSERT INTO #lastAnalyticsStartTimeByClient
	SELECT C.clientId, MAX(FLA.indexTime)
	FROM #clientEntity C
		INNER JOIN APP_Application APP WITH (NOLOCK) ON C.clientId = APP.clientId
		INNER JOIN @tblAppTypes ON APP.appTypeId = t_appTypeId
		INNER JOIN ARCHFILE AF WITH (NOLOCK) ON APP.id = AF.appId
		INNER JOIN archFLAIndexingInfo FLA WITH (NOLOCK)
				ON AF.id = FLA.archFileId AND (FLA.flags & 64) >0
		--commcellId check is not needed, to support backup jobs run after client migration
	GROUP BY C.clientId
END
INSERT INTO #tmpClientTbl (commcellId, clientId, appTypeId, lastAnalyticsTime,	hasBrowse)
SELECT DISTINCT	APP.origCCId, APP.clientId,APP.appTypeId, CC.t_maxAnalyticTime, C.hasBrowse
FROM	APP_application APP (nolock)
		JOIN #lastAnalyticsStartTimeByClient CC ON	APP.clientId = CC.t_clientId
		JOIN #clientEntity C ON CC.t_clientId = C.clientId
		JOIN @tblAppTypes T ON APP.appTypeId = t_appTypeId
--DELETE FROM CLIENTENTITY WHICH ARE ALREADY ANALYZED
DELETE T
FROM #clientEntity T
JOIN #lastAnalyticsStartTimeByClient L ON T.clientId =L.t_clientId
--DEFAULT backupsetId is needed for size distribution report for analyzed clients
UPDATE #tmpClientTbl
SET backupsetId = (SELECT TOP 1 APP.backupSet
					FROM APP_Application APP (NOLOCK)
					JOIN APP_BackupSetName B (NOLOCK) ON APP.backupSet = B.id
WHERE (B.status & 0x00008)> 0 AND APP.ClientId = #tmpClientTbl.clientId )
-- INCLUDE VM LIST FOR VSA ANALYTICS
IF EXISTS (SELECT  TOP 1 1 FROM APP_ClientProp CP WITH (NOLOCK) WHERE attrName = 'AnalysisComplete' and attrVal = '1' )
BEGIN
	INSERT INTO #tmpClientTbl (commcellId, clientId, appTypeId, hasBrowse)
SELECT C.origCCId, CE.clientId,  106, CE.hasBrowse
		FROM #clientEntity CE
        INNER JOIN APP_ClientProp CP (NOLOCK) ON  CE.clientId =CP.componentNameId
		INNER JOIN APP_Client C (NOLOCK) ON  CE.clientId =C.Id
		WHERE attrName ='AnalysisComplete' AND attrVal ='1' and CP.modified = 0
	;WITH CTE
    AS
    (
    SELECT cast (attrVal AS INT) AS LastAnalysisTime, clientId
	FROM APP_ClientProp CP (NOLOCK)
	JOIN #tmpClientTbl ON CP.componentNameId =clientId
WHERE appTypeId = 106 AND modified = 0 and attrName = 'LastAnalysisTime'
    )
	UPDATE #tmpClientTbl
	SET lastAnalyticsTime =LastAnalysisTime
FROM CTE WHERE CTE.clientId =#tmpClientTbl.clientId AND appTypeId = 106
END
DROP TABLE #clientEntity
DROP TABLE #lastAnalyticsStartTimeByClient
UPDATE #tmpClientTbl
SET clientName = name
from APP_Client (nolock)
where clientid =id
--SELECT * FROM #tmpClientTbl
SET @o_XMLText = '<DM2ContentIndexing_AnalyticsGroupResp analyticsReqType="0" />'
IF EXISTS (SELECT TOP 1 1 FROM #tmpClientTbl)
	SET @o_XMLText = ISNULL(( 	SELECT
							0 AS '@i_analyticsReqType',
							( SELECT (
								SELECT
										T2.clientId AS '@clientId',
										T2.clientName AS '@clientName',
										T2.commcelliD AS '@commcellNumber',
										MAX(ISNULL(T2.lastAnalyticsTime,0)) AS '@lastAnalyticsTime',
										MAX(hasBrowse) AS '@hasBrowse',
										0 AS '@sizeInBytes',
									(SELECT DISTINCT
										T3.appTypeId AS '@applicationId',
										T3.backupSetId AS '@backupsetId'
										FROM #tmpClientTbl T3
										WHERE T3.clientId = T2.clientId
										FOR XML PATH('subClients'), TYPE
									)
									FROM #tmpClientTbl T2
									GROUP BY T2.clientId, T2.clientName, T2.commcelliD
									FOR XML PATH('analyticsClients'), TYPE
									)
									FOR XML PATH('analyticsGroups'), TYPE
					 ) FOR XML PATH('DM2ContentIndexing_AnalyticsGroupResp')
					 ),'<DM2ContentIndexing_AnalyticsGroupResp/>')
DROP TABLE #tmpClientTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetFLAClients')
	delete from GxQscripts where name = 'APPGetFLAClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFLAClients')
	delete from GXDBVersions where aliasname = 'APPGetFLAClients'
GO

insert into GXDBVersions values(2, 'APPGetFLAClients',  '00010001000200100000', 'APPGetFLAClients', '00010001000200100000')
GO

