

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetFLAClientList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetFLAClientList.sp,v $ $Id: APPGetFLAClientList.sp,v 1.5.60.2.68.1 2021/01/13 14:35:35 mnatarajan Exp $";
--	+===================================================================+
--	| APPGetFLAClientList - Get Laptop Client list 					|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPGetFLAClientList')
BEGIN
	print '>>> Drop Stored Procedure: APPGetFLAClientList <<<'
	drop procedure APPGetFLAClientList
END
IF EXISTS (select * from GxQscripts where name='APPGetFLAClientList')
	delete from GxQscripts where name = 'APPGetFLAClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFLAClientList')
	delete from GXDBVersions where aliasname = 'APPGetFLAClientList'
GO
print '... Creating Procedure: APPGetFLAClientList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPGetFLAClientList
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @xmlString XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
DECLARE     @function       AS varchar(80)                        = 'APPGetFLAClientList'
DECLARE @errorCode            AS integer                          = 0                                             -- BE OPTIMISTIC
DECLARE @errorString    AS varchar(2048)              = ''
DECLARE @brAlertTrace   AS varchar(256)                     = (select value from gxglobalParam Where name = 'bralertTrace')
DECLARE @dateTime       AS DATETIME                         = getDate()
DECLARE @ATTR_NAME            AS nvarchar(80)                     = N'Associated subclient Policy'
DECLARE @DECOUPLE_SCP_CONTENT_ATTR_NAME   AS Nvarchar(80)   = N'Decouple SCP Content'
DECLARE @ATTR_USE_SCP_FILTERS             AS nvarchar(80)   = N'use SCP filters'
DECLARE @ATTR_CLIENT_GEO_LOCATION         AS nvarchar(80)   = N'Client Geo Location'
DECLARE @ATTR_GEO_LOCATION_DISPLAY_MODE   AS nvarchar(80)   = N'Geo Location Display Mode'
DECLARE @excludeStatusMask int = (cast(0x00002 as int) | cast(0x00004 as int) | cast(0x00010 as int) | cast(0x00020 as int))
DECLARE @ATTR_USE_CS_SETTING_FOR_GF       	AS NVARCHAR(80)   = N'use cs setting for global filters'
DECLARE @ATTR_USE_GLOBAL_FILTERS			AS NVARCHAR(80)   = N'use global filters'
DECLARE @ATTR_USE_QNET_GLOBAL_FILTERS		AS NVARCHAR(80)	= N'Use QNET Global Filters'
DECLARE @ATTR_USE_GLOBAL_FILTERS_FOR_SC		AS NVARCHAR(80)	= N'Use Global Filters for all Subclients'
DECLARE @QNET_GLOBAL_FILTER_PREFIX			AS NVARCHAR(80)	= N'CN_'
DECLARE @ATTR_UNIX_FS_EXCLUDE_FILTERS		AS NVARCHAR(80)	= N'Unix FS Exclude Filters'
DECLARE @ATTR_WIN_FS_EXCLUDE_FILTERS		AS NVARCHAR(80)	= N'Windows FS Exclude Filters'
DECLARE @clientList table (
            cId                           int not null,
            clientName				nvarchar(255),
            hostName				nvarchar(255),
            appId               int not null,
            instId              int not null,
            bSet                    int not null,
            subId                   int not null,
            assocBset               int not null,
            assocSubC               int not null,
            useSCPfilters           int not null,
            lastbkupTime            int not null,
            lastSuccessBkupTime     int Not null,
            nextBkupTime            int Not null,
            backupSize              bigint not null,
            capabilities            bigint not null,
            totalbackupsize         bigint not null,
            isOwner                       int not null,
            vCid                    int not null,
            isArchived              int not null,
            flag                    int not null,
            isDRalertEnabled  int ,
            isDPalertEnabled  int ,
            decoupleSCPcontent      int not null, --Being used for not returning schedule for non-backup VM
            lastOnlineTime			int Not null,
            lastOfflineTime			int Not null,
            lastGeoLocation			xml,
            vmJobId					int,
            contentIndexingEnabled  int,
            useGlobalFilter			int not null,
			lastBkpLevel			int not null,
			lastFullcycleNumber		int not null,
			lastDiffJobEndTimeInCycle int not null,
            lastGeoLocationTime		int,
			geoLocationDisplayMode	int
            )
DECLARE @defaultGeoLocatoinDisplayMode  INT = 2
DECLARE @taskInfo table
(
      taskId int,
      taskName nvarchar(1024),
      subTaskId int,
      subTaskName nvarchar(1024),
      clientId int,
      patternId int,
      patternInfo nvarchar(1024),
      ownerId int,
      ownerName nvarchar(1024),
      subtaskType int
)
DECLARE @vmEntity table
(
	vCid                    int not null,
	vmGUID nvarchar(1024),
	vmName	nvarchar(1024),
	vmHostName	nvarchar(1024)
)
DECLARE @proxyEntity table
(
	instanceId int,
	proxyClientXML xml
)
DECLARE @assocSubClient table
(
	assocSubClientId int,
	clientId      int,
	applicationId  int,
	backupsetId int,
	instanceId int,
	subclientId int
)
DECLARE @content table
(
	subId  int,
	created      int,
	modified  int,
	fileName nvarchar(1024),
	type int
)
DECLARE @SCPcontent table
(
	assocSubId  int,
	created      int,
	modified  int,
	fileName nvarchar(1024),
	type int
)
-----------------------------------------------------------
if @brAlertTrace <> 0
BEGIN
      DECLARE @input varchar(MAX) = CONVERT(varchar(MAX), @xmlString)
      exec br_ntTrace '.. APPGetFLAClientList', 0, @dateTime, 0, 0, @input
END
BEGIN TRY
----------------------------------------------------------
---   HERE IS WHERE WE WILL EXTRACT THE XML TO:          ---
----------------------------------------------------------
DECLARE @userId                           integer = 0
DECLARE @clientId                   integer = 0
DECLARE     @scope                              integer = 1
DECLARE @localeId                   integer = 0
DECLARE @subClientId                integer = 0
DECLARE     @userGUID                     VARCHAR(255)
DECLARE     @mailBoxGuid                  VARCHAR(255)
DECLARE     @clientName                   NVARCHAR(1024)
DECLARE @isUserAdmin            integer =0
DECLARE     @getContent                 integer = 0
DECLARE     @getSchedules                 integer = 0
DECLARE @userMailBox integer = 1
DECLARE @getAllProperties integer = 0
DECLARE @getVMs integer = 0
DECLARE @defaultCommcellId integer = 2
-----------------------------------------------
--- EXTRACT FROM THE XML                              ---
-----------------------------------------------
      SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
      SET @userId = ISNULL (( SELECT ref.value('@userId', 'INT')
                              FROM @xmlString.nodes ('App_LapTopClientListReq/user') R(ref)), @userId)
	  SET @userGUID = (SELECT TOP 1 userGuid FROM UMUsers where id = @userId)
      SET @mailBoxGuid = ISNULL (( SELECT ref.value('@mailBoxGuid', 'VARCHAR(64)')
                              FROM @xmlString.nodes ('App_LapTopClientListReq') R(ref)), @userGUID)
      SET @clientName = ISNULL (( SELECT ref.value('@clientName', 'NVARCHAR(1024)')
                              FROM @xmlString.nodes ('App_LapTopClientListReq/client') R(ref)), '')
      IF @clientName <> ''
            SET @clientId = (SELECT id FROM APP_Client WHERE name = @clientName)
      SET @clientId = ISNULL (( SELECT ref.value('@clientId', 'INT')
                              FROM @xmlString.nodes ('App_LapTopClientListReq/client') R(ref)), @clientId)
      SET @scope = ISNULL (( SELECT ref.value('@scope', 'INT')
                              FROM @xmlString.nodes ('App_LapTopClientListReq') R(ref)), 1)
      SET @getAllProperties = ISNULL (( SELECT ref.value('@getAllProperties', 'INT')
		FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), 0)
      SET @getContent = ISNULL (( SELECT ref.value('@getContent', 'INT')
                              FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), @getAllProperties)
      SET @getSchedules = ISNULL (( SELECT ref.value('@getSchedules', 'INT')
                              FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), @getAllProperties)
      SET @localeId = ISNULL (( SELECT ref.value('@localeId', 'INT')
                              FROM @xmlString.nodes ('App_LapTopClientListReq/locale') R(ref)), 0)
      SET @subClientId = ISNULL (( SELECT ref.value('@subclientId', 'INT')
                              FROM @xmlString.nodes ('App_LapTopClientListReq/filter/subclient') R(ref)), 1)
      DECLARE @getFsLikeClients int
      DECLARE @getMailBoxClients int
      DECLARE @getSharePointClients int
      SET @getFsLikeClients = ISNULL (( SELECT ref.value('@getFsLikeClients', 'INT')
		FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), 0)
      SET @getMailBoxClients = ISNULL (( SELECT ref.value('@getMailBoxClients', 'INT')
		FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), 0)
      SET @getSharePointClients = ISNULL (( SELECT ref.value('@getSharePointClients', 'INT')
		FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), 0)
--    select step='debug1', userId=@userId, clientId=@clientId,
--      scope=@scope, skipContent=@skipContent, skipSchedules=@skipSchedules
	SET @getVMs = ISNULL (( SELECT ref.value('@getVMs', 'INT')
		FROM @xmlString.nodes ('App_LapTopClientListReq/filter') R(ref)), 0)
-------------------------------------------------------------------------
      IF object_id('tempdb.dbo.#tempFLASecurityObjects') IS NOT Null DROP TABLE #tempFLASecurityObjects
create table  #tempFLASecurityObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	  EXEC sec_getUserObjects @userId, 2009, 0, '#tempFLASecurityObjects'
			INSERT @clientList
            SELECT um.clientId, '', '',ida.appTypeId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, um.capabilities, 0, 1, 0, 0, 0, null, null, 0, 0, 0, null,-1, null, 0, 0, 0, 0, null, null
            FROM   UMOwnerCredentials um
             JOIN APP_IDAName ida on ida.clientId = um.clientId AND (  @getFsLikeClients = 1 AND ida.appTypeId in (SELECT appTypeId FROM GetAppTypesForAppGroup(35,0)) and ida.appTypeId <> 13 )
            WHERE um.userId = @userId
			UNION
		        SELECT C.id, '', '',ida.appTypeId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, null, null, 0, 0, 0, null,-1, null, 0, 0, 0, 0, null, null
			    FROM APP_Client C, APP_IDAName ida
				 WHERE C.id = ida.clientId
				 AND EXists (select * from UMUserGroup where groupId in (1,3) and userId = @userId)
				 AND (  @getFsLikeClients = 1 AND ida.appTypeId in (SELECT appTypeId FROM GetAppTypesForAppGroup(35,0)) and ida.appTypeId <> 13 )
			UNION
		        SELECT C.id, '', '',ida.appTypeId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, null, null, 0, 0, 0, null,-1, null, 0, 0, 0, 0, null, null
			    FROM APP_Client C, APP_IDAName ida, #tempFLASecurityObjects t
				WHERE C.id = ida.clientId
				AND c.id = t.clientId
				AND (@getFsLikeClients = 1 AND ida.appTypeId in (SELECT appTypeId FROM GetAppTypesForAppGroup(35,0)) and ida.appTypeId <> 13 )
			DELETE @clientList
			WHERE NOT EXISTS (SELECT 1 FROM dbo.APP_Client WHERE ID = CID)
			DECLARE @hideEDCClients	INT
	        SET @hideEDCClients = ISNULL((SELECT CAST (value AS INT) FROM GXGlobalParam WHERE name = 'FLA_HIDE_CLOUD_CLIENTS'),0)
		    IF @hideEDCClients = 1
				 DELETE @clientList
				 FROM @clientList C, APP_ClientGroup cg, APP_ClientGroupAssoc cga
				 WHERE cg.id = cga.clientGroupId and cga.clientId = C.cId
				 AND ((cg.flag & 0x100 = 0x100) OR (cg.flag & 0x200 =0x200))
			IF(@getSharePointClients = 1) --FOR SHAREPOINT GET ALL THE CLIENT ON WHICH USER HAS RIGHTS
			BEGIN
				INSERT @clientList
				SELECT C.id, '','', i.appTypeId, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, null, null, 0, 0, 0, null, -1, null, 0, 0, 0, 0, null, null
				FROM APP_Client C
				INNER JOIN APP_IDAName i
				ON i.appTypeId in (SELECT appTypeId FROM GetAppTypesForAppGroup(55,0)) and c.id = i.clientId
				DELETE @clientList
				WHERE NOT EXISTS (select * from #tempFLASecurityObjects where clientId In (0, cId))
			END
      -- FILL IN MISSING COLUMNS OF CLIENT TABLE
-----------------------------------------------
--- Summary                              ---
-----------------------------------------------
UPDATE @clientList
        SET bSet = bs.id
        from  @clientList cl
        INNER JOIN APP_Application a on a.appTypeId = cl.appId and a.clientId = cl.cId
        INNER JOIN APP_BackupSetName bs on a.backupSet = bs.id
where bs.status & 0x00008 = 0x00008 and cl.appId <> 106
UPDATE @clientList
            set subId = ISNULL((Select id FROM APP_Application where clientId = cId and backupset=bset and subclientStatus&@excludeStatusMask = 0
and (subClientStatus & 0x00008 = 0x00008 )), 0) where appId <> 106
      UPDATE @clientList
set instId = ISNULL((Select instance FROM APP_Application where id = subId), 0) where appId <> 106
--DELETE @clientList WHERE subId = 0 and appId <> CV_APPTYPE_VIRTUAL_SERVER --vm needs the all the clietns, even though they are not backed up
--UPDATE @clientList  SET cId = ISNULL((Select clientId FROM APP_Application where id = subId), 0)
UPDATE @clientList
	set clientName = c.name, hostname = c.net_hostName from @clientList cl INNER JOIN APP_Client c ON c.Id = cId
IF (@getVMs = 1)
BEGIN
	UPDATE @clientList
			SET lastbkupTime = ISNULL((select CAST(vmProp.attrVal as BIGINT) from APP_VMProp vmProp
												WHERE vmProp.vmClientId = vCid
												AND vmProp.jobId = vmJobId
AND vmProp.attrName = 'vmBackupEndTime'), lastSuccessBkupTime)	where appId  = 106
		UPDATE @clientList
			SET lastSuccessBkupTime = ISNULL((select CAST(vmProp.attrVal as BIGINT) from APP_VMProp vmProp
												WHERE vmProp.vmClientId = vCid
												AND vmProp.jobId = vmJobId
												AND vmProp.attrName = 'vmBackupEndTime'
), lastbkupTime) 	where appId  = 106
		UPDATE @clientList
			SET backupSize = ISNULL((select CAST(vmProp.attrVal as BIGINT) from APP_VMProp vmProp
												WHERE vmProp.vmClientId = vCid
												AND vmProp.jobId = vmJobId
												AND vmProp.attrName = 'vmSize'
), lastbkupTime) 	where appId  = 106
	END
	--ELSE
  --BEGIN
			UPDATE @clientList
                  SET lastSuccessBkupTime = ISNULL((select max(servEndDate) from JMBkpStats
													where status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
													AND JMBkpStats.appId = subId --AND commCellId = @defaultCommcellId
													AND opType <> 14  -- Dont show synthetic full
													--AND datastatus = 0 -- DATA_STATUS_VALID
													), 0)
            UPDATE @clientList
                  SET lastbkupTime = ISNULL((select max(servEndDate) from JMBkpStats
											 where JMBkpStats.appId = subId -- AND commCellId = @defaultCommcellId
											 AND opType <> 14), 0) -- Dont show synthetic full
            UPDATE @clientList
                  SET lastOnlineTime = ISNULL((select top 1 lastOnlineTime from CCRClientToClient where FromClientId = 2 and ToClientId = cId), 0)
            UPDATE @clientList
                  SET lastOfflineTime = ISNULL((select top 1 lastOfflineTime from CCRClientToClient where FromClientId = 2 and ToClientId = cId), 0)
            UPDATE @clientList
				SET backupSize = ISNULL((select totalUncompBytes from JMBkpStats
										 where
										 -- commCellId = @defaultCommcellId AND
										  servEndDate = lastSuccessBkupTime
										 and JMBkpStats.appid = subId), 0)
			UPDATE @clientList
				SET lastBkpLevel = ISNULL((SELECT bkpLevel from JMBkpStats
										  WHERE --commCellId = @defaultCommcellId  AND
										  servEndDate = lastSuccessBkupTime
										  AND JMBkpStats.appid = subId), 0)
			UPDATE @clientList
				SET lastFullcycleNumber = ISNULL((SELECT fullCycleNum from JMBkpStats
												  WHERE --commCellId = @defaultCommcellId AND
												  servEndDate = lastSuccessBkupTime
												  AND JMBkpStats.appid = subId), 0)
			-- This gived the end time of the recent differential job in current cycle if any.
			UPDATE @clientList
				SET lastDiffJobEndTimeInCycle = ISNULL((SELECT top 1 servEndDate from JMBkpStats
														WHERE -- commCellId = @defaultCommcellId AND
														JMBkpStats.appid = subId
														AND bkpLevel = 4 -- DIFFERENTIAL
														AND status IN (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
														AND fullCycleNum = lastFullcycleNumber
														ORDER BY servEndDate desc), 0)
			UPDATE @clientList
				SET totalbackupsize = CASE lastBkpLevel
									-- When last backup is Differential, take last backup size plus the FULL job's size in the cycle
									WHEN 4 THEN backupSize + ISNULL((SELECT TOP 1 totalUncompBytes
																	 FROM JMBkpStats
																	 WHERE JMBkpStats.appId = subId --AND commCellId = @defaultCommcellId
																	 AND bkpLevel IN (1, 64, 128) -- FULL, SYNTHETIC_FULL, SYNTHETIC_FULL_AND_INCR
																	 AND status IN (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
																	 AND dataStatus = 0
																	 AND fullCycleNum = lastFullcycleNumber), 0)
									-- When last backup is incremental
									WHEN 2 THEN
										CASE lastDiffJobEndTimeInCycle
										-- If we dont have a differential job in cycle, simply sum up size of all succeeded jobs in cycle to get total backup size.
										WHEN 0 THEN ISNULL( (SELECT SUM(totalUncompBytes)
															 FROM JMBkpStats
															 WHERE JMBkpStats.appId = subId --AND commCellId = @defaultCommcellId
															 AND bkpLevel IN(1, 2, 64, 128) -- FULL, INCR, SYNTHETIC_FULL, SYNTHETIC_FULL_AND_INCR
															 AND status IN (1, 3, 14)  -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
															 AND dataStatus = 0
															 AND fullCycleNum = lastFullcycleNumber), 0)
										-- If we have a differential job, then add Full job's Size with last diff job's size and all jobs after it.
										ELSE	 	 ISNULL( (SELECT TOP 1 totalUncompBytes
															  FROM JMBkpStats
															  WHERE JMBkpStats.appId = subId --AND commCellId = @defaultCommcellId
															  AND bkpLevel IN(1, 64, 128) -- FULL, SYNTHETIC_FULL, SYNTHETIC_FULL_AND_INCR
															  AND status IN (1, 3 ,14)  -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
															  AND dataStatus = 0
															  AND fullCycleNum = lastFullcycleNumber) , 0)
													+ISNULL( (SELECT SUM(totalUncompBytes)
															  FROM JMBkpStats
															  WHERE JMBkpStats.appId = subId-- AND commCellId = @defaultCommcellId
															  AND bkpLevel IN(2, 4) -- INCR, DIFFERENTIAL
															  AND status IN (1, 3 ,14)  -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
															  AND dataStatus = 0
															  AND fullCycleNum = lastFullcycleNumber
															  AND servEndDate >= lastDiffJobEndTimeInCycle), 0)
										END
									-- When last backup is FULL, SYNTHETIC_FULL, SYNTHETIC_FULL_AND_INCR use current backup size because it is start of cycle
									ELSE backupSize
									END
            UPDATE @clientList
                  SET nextBkupTime = ISNULL((select min(nextTime) from TM_RunTime WITH (NOLOCK) where patternId in (
                                          select patternId from TM_PatternAssoc WITH (NOLOCK) where subTaskId in (
select st.subTaskId from TM_SubTask st WITH (NOLOCK) INNER JOIN TM_SubTaskOptions sto ON sto.subTaskId = st.subTaskId AND sto.optionId = 458405394 AND sto.value IN (1, 2)  where taskId in (
                                                      select taskId from TM_Associations TM_AssocEntity WITH (NOLOCK) where
                                                      --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
						(TM_AssocEntity.subclientId = subId)
						OR
						(TM_AssocEntity.backupsetId = bSet AND TM_AssocEntity.subclientId =0 )
						OR
						(TM_AssocEntity.instanceId = instId AND TM_AssocEntity.backupsetId =0 AND TM_AssocEntity.subclientId =0)
						OR
						(TM_AssocEntity.apptypeId = appId AND TM_AssocEntity.instanceId = 0 AND TM_AssocEntity.backupsetId =0 AND TM_AssocEntity.subclientId =0)
                         OR
						(TM_AssocEntity.clientId = cId AND TM_AssocEntity.apptypeId = 0 AND TM_AssocEntity.instanceId = 0 AND TM_AssocEntity.backupsetId =0 AND TM_AssocEntity.subclientId =0)
						 OR
						(TM_AssocEntity.clientGroupId in (select clientGroupId from APP_ClientGroupAssoc where clientId = cId) and   TM_AssocEntity.clientId = 0 AND TM_AssocEntity.apptypeId = 0 AND TM_AssocEntity.instanceId = 0 AND TM_AssocEntity.backupsetId =0 AND TM_AssocEntity.subclientId =0)
                                          )and processed=0))), 0) WHERE cId <> 0
      UPDATE @clientList
            SET nextBkupTime = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_ClientProp
                                                      WHERE componentNameId=cId AND attrName='Next Run Time In'
                                                      AND (CAST(attrVal AS INT)<nextBkupTime OR nextBkupTime=0) AND modified=0 AND CAST(attrVal AS INT)>0
                                                      ), nextBkupTime)
   -------------------------
   --		Get Details
   -------------------------
     if(@getAllProperties = 1)
     BEGIN
      UPDATE @clientList
            SET isArchived = ISNULL((SELECT CAST(attrVal as int) FROM App_ClientProp
                              WHERE modified = 0 AND attrName = 'Is Client Archived'
                                    AND componentNameId = vCid), 0)            FROM @clientList
            WHERE  vCid <> 0
      UPDATE @clientList
            SET vCid = cId
            FROM @clientList
            WHERE vCid = 0
      --UPDATE @clientList
      --      set bSet = ISNULL((Select backupSet FROM APP_Application where id = subId), 0)
      UPDATE @clientList
            Set assocBset = ISNULL((Select attrVal from app_backupsetProp where componentNameId = bSet and attrName = @ATTR_NAME AND modified = 0), 0)
      UPDATE @clientList
            Set assocSubC = ISNULL((Select attrVal from app_subClientProp where componentNameId = subId and attrName = @ATTR_NAME AND modified = 0  AND cs_attrName = checksum(@ATTR_NAME)), 0)
      UPDATE @clientList
            Set decoupleSCPcontent =  ISNULL((Select attrVal from app_subClientProp where componentNameId = subId and attrName = @DECOUPLE_SCP_CONTENT_ATTR_NAME AND modified = 0  AND cs_attrName = checksum(@DECOUPLE_SCP_CONTENT_ATTR_NAME)), 0)
      UPDATE @clientList
            SET capabilities = ISNULL((
                  SELECT dbo.BitwiseOR(capabilities)
                  from #tempFLASecurityObjects AS sec
                  where sec.clientId=cId OR sec.clientGroupId IN (select AG.clientGroupId from APP_ClientGroupAssoc AG where AG.clientId=cId)OR
                  (sec.commCellId <> 0 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.backupsetId=0
                  AND sec.subClientId=0 AND sec.archGroupId=0 AND sec.complianceReportId=0 AND sec.complianceReportId=0
                  AND sec.archGroupId=0 AND sec.cdPolicyId=0 AND sec.downloadSetId=0 AND sec.ermId=0
                  AND sec.instanceId=0 AND sec.legalHoldId=0 AND sec.libraryId=0 AND sec.mediaAgentId=0
                  AND sec.querySetId=0 AND sec.reviewSetId=0 AND sec.tagId=0
                  AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0)), capabilities)
      UPDATE @clientList
            SET useSCPfilters = ISNULL((SELECT attrVal
                                                      FROM app_subClientProp
                                                      WHERE componentNameId = subId
                                                        AND attrName = @ATTR_USE_SCP_FILTERS
                                                        AND modified = 0
                                                        AND cs_attrName = checksum(@ATTR_USE_SCP_FILTERS)), 1)
----------------------------------------------------------GlobalFilter----------------------------------------------------------------------
	DECLARE @useGlobalFilterForAllSubClients INT = 0
	SET @useGlobalFilterForAllSubClients  = ISNULL((SELECT value FROM GXGlobalParam WHERE name = @ATTR_USE_GLOBAL_FILTERS_FOR_SC AND modified = 0), 0)
	DECLARE @useQNetGlobalFilters INT = 0
	SET @useQNetGlobalFilters  = ISNULL((SELECT value FROM GXGlobalParam WHERE name = @ATTR_USE_QNET_GLOBAL_FILTERS AND modified = 0), 0)
	DECLARE @WindowsGlobalExcludeFilters TABLE
	(
		value NVARCHAR(MAX)
	)
	DECLARE @UnixGlobalExcludeFilters TABLE
	(
		value NVARCHAR(MAX)
	)
	DECLARE @strWindowsGlobalExcludeFilters NVARCHAR(MAX) = N''
	DECLARE @strUnixGlobalExcludeFilters NVARCHAR(MAX) = N''
	SET @strWindowsGlobalExcludeFilters = ISNULL((select value from GXGlobalParam where modified = 0 and name = @ATTR_WIN_FS_EXCLUDE_FILTERS), N'')
	SET @strUnixGlobalExcludeFilters = ISNULL((select value from GXGlobalParam where modified = 0 and name = @ATTR_UNIX_FS_EXCLUDE_FILTERS), N'')
	INSERT @WindowsGlobalExcludeFilters
		SELECT Data FROM SplitString(@strWindowsGlobalExcludeFilters, N' ')  where Data != N''
	INSERT @UnixGlobalExcludeFilters
		SELECT Data FROM SplitString(@strUnixGlobalExcludeFilters, N' ')  where Data != N''
	DECLARE @strQNetWindowsGlobalExcludeFilters NVARCHAR(MAX) = N''
	DECLARE @strQNetUnixGlobalExcludeFilters NVARCHAR(MAX) = N''
	IF (@useQNetGlobalFilters = 1)
	BEGIN
		SET @strQNetWindowsGlobalExcludeFilters = ISNULL((select value from GXGlobalParam where modified = 0 and name = @QNET_GLOBAL_FILTER_PREFIX + @ATTR_WIN_FS_EXCLUDE_FILTERS), N'')
		SET @strQNetUnixGlobalExcludeFilters = ISNULL((select value from GXGlobalParam where modified = 0 and name = @QNET_GLOBAL_FILTER_PREFIX + @ATTR_UNIX_FS_EXCLUDE_FILTERS), N'')
		INSERT @WindowsGlobalExcludeFilters
			SELECT Data FROM SplitString(@strQNetWindowsGlobalExcludeFilters, N' ')  where Data != N''
		INSERT @UnixGlobalExcludeFilters
			SELECT Data FROM SplitString(@strQNetUnixGlobalExcludeFilters, N' ')  where Data != N''
	END
      UPDATE @clientList
            SET useGlobalFilter = ISNULL((SELECT attrVal
                                                      FROM app_subClientProp
                                                      WHERE ((assocSubC = 0 AND componentNameId = subId) OR (assocSubC <> 0 AND componentNameId = assocSubC))
                                                        AND attrName = @ATTR_USE_CS_SETTING_FOR_GF
                                                        AND modified = 0
                                                        AND cs_attrName = checksum(@ATTR_USE_CS_SETTING_FOR_GF)), 1)
      UPDATE @clientList
            SET useGlobalFilter = @useGlobalFilterForAllSubClients
			where useGlobalFilter = 1
      UPDATE @clientList
            SET useGlobalFilter = ISNULL((SELECT attrVal
                                                      FROM app_subClientProp
                                                      WHERE ((assocSubC = 0 AND componentNameId = subId) OR (assocSubC <> 0 AND componentNameId = assocSubC))
                                                        AND attrName = @ATTR_USE_GLOBAL_FILTERS
                                                        AND modified = 0
                                                        AND cs_attrName = checksum(@ATTR_USE_GLOBAL_FILTERS)), @useGlobalFilterForAllSubClients)
			where useGlobalFilter = 0
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------GeoLocatoin----------------------------------------------------------------------------------------------------------
		DECLARE @globalGeoLocatoinDisplayMode   INT
		SET @globalGeoLocatoinDisplayMode = ISNULL((SELECT TOP 1 value FROM GXGlobalParam WHERE modified = 0  AND name = @ATTR_GEO_LOCATION_DISPLAY_MODE), @defaultGeoLocatoinDisplayMode);
		IF (@globalGeoLocatoinDisplayMode IS NULL OR @globalGeoLocatoinDisplayMode < 0 OR @globalGeoLocatoinDisplayMode > 2)
			SET @globalGeoLocatoinDisplayMode = @defaultGeoLocatoinDisplayMode
		UPDATE @clientList
			SET lastGeoLocation = (select REPLACE((SELECT TOP (1) attrVal FROM APP_ClientProp WHERE (modified = 0 AND componentNameId = cId AND attrName = @ATTR_CLIENT_GEO_LOCATION AND attrVal LIKE '<App_GeoLocation%status_code=''SUCCESS''%') ORDER BY created DESC), N'App_GeoLocation', 'lastGeoLocation'))
			, lastGeoLocationTime = ISNULL((SELECT TOP (1) created FROM APP_ClientProp WHERE (modified = 0 AND componentNameId = cId AND attrName = @ATTR_CLIENT_GEO_LOCATION AND attrVal LIKE '<App_GeoLocation%status_code=''SUCCESS''%') ORDER BY created DESC), 0)
			, geoLocationDisplayMode = ISNULL((SELECT TOP (1) created FROM APP_ClientProp WHERE (modified = 0 AND componentNameId = cId AND attrName = @ATTR_GEO_LOCATION_DISPLAY_MODE)), @globalGeoLocatoinDisplayMode)
--------------------------------------------------------------------------------------------------------------------------------------------------------------
      DROP TABLE #tempFLASecurityObjects
      INSERT INTO @assocSubClient
      SELECT a.id, clientId,  a.appTypeId , instId , assocBset , subId
      FROM APP_Application a
      INNER JOIN @clientList cl on cl.assocSubC = a.id
      UPDATE @clientList
      SET contentIndexingEnabled =
      ISNULL((select top 1 CAST(attrVal AS INT) From APP_ClientProp where attrName = 'Content Indexing Enabled' and modified = 0 and componentNameId = cId),0)
--    select debug='Tbld clientList', * from @clientList
      IF (@getSchedules = 1)
      BEGIN
            INSERT INTO @taskInfo
            SELECT DISTINCT ST.taskId, TK.taskName, ST.subTaskId, ST.subTaskName, CL.cId, PT.patternId, '', US.id, US.login,taskType
            FROM @clientList AS CL
            INNER JOIN TM_Associations TA (NOLOCK) ON TA.subclientId = CL.subId OR TA.clientId = 0 OR (TA.clientId=CL.cId AND TA.subclientId=0)
            LEFT OUTER JOIN APP_ClientGroupAssoc CA ON CA.clientId = CL.cId
            INNER JOIN TM_Task TK WITH (NOLOCK) ON TK.taskId = TA.taskId
            INNER JOIN TM_SubTask ST WITH (NOLOCK) ON ST.taskId = TA.taskId
            INNER JOIN TM_PatternAssoc PA WITH (NOLOCK) ON PA.subTaskId = ST.subTaskId
INNER JOIN TM_SubTaskOptions STP WITH (NOLOCK) ON PA.subTaskId = STP.subTaskId AND optionId = 458405394 AND STP.value IN (1, 2)
            INNER JOIN TM_Pattern PT WITH (NOLOCK) ON PT.patternId = PA.patternId
            INNER JOIN UMUsers US WITH (NOLOCK) ON US.id = TK.ownerId
            WHERE (TA.clientId = CL.cId OR (TA.clientId = 0 AND TA.clientGroupId = CA.clientGroupId))
AND ST.subTaskType = 2        --ONLY BACKUP SCHEDULES
			AND TK.disabled = 0 AND TK.deleted = 0 AND TK.uninstalled = 0 -- Only Valid enabled Schedules
AND TK.taskType in (4, 2)
            AND (PT.freq_type&4=4 OR PT.freq_type&8=8 OR PT.freq_type&1024=1024)    --ONLY RETURN DAILY, WEEKLY AND AUTOMATIC SCHEDULES
            AND (CL.flag & 1) = 0 and CL.cId <> 0 --VM CLIENT THAT ARE NOT PART OF ANY SUBCLIENT
            DECLARE @patternId int
            DECLARE @patternInfo TABLE (Info nvarchar(1024))
            DECLARE updatePatternCur CURSOR FOR
                  SELECT patternId FROM @taskInfo
            OPEN updatePatternCur
            FETCH NEXT FROM updatePatternCur INTO @patternId
            WHILE @@FETCH_STATUS = 0
            BEGIN
                  DELETE @patternInfo
                  INSERT INTO @patternInfo
                  EXEC GetSchedulePattern @patternId, @localeId, 1
                  UPDATE @taskInfo SET patternInfo = (SELECT TOP 1 Info FROM @patternInfo)
                  WHERE patternId = @patternId
                  FETCH NEXT FROM updatePatternCur INTO @patternId
            END
            CLOSE updatePatternCur
            DEALLOCATE updatePatternCur
      END
      IF(@getContent=1)
      BEGIN
		INSERT INTO @content
		SELECT subId,created,modified,fileName,
		 CASE WHEN (assocSubC <> 0 AND type = 1) THEN 18
                    WHEN (assocSubC <> 0 AND type = 3) THEN 20   -- ADDED TO SUPPORT EXCLUDE FILTERS
                    ELSE  type END as '@valueType'
		 FROM APP_ScFilterFile sff
		INNER JOIN @clientList cl on sff.componentNameId = cl.subId AND modified = 0
		--associated policy client
		INSERT INTO @SCPcontent
		SELECT assocSubC,created,modified,fileName, type
		 FROM APP_ScFilterFile sff
		INNER JOIN @clientList cl on sff.componentNameId = cl.assocSubC AND modified = 0
		AND (type = 1 OR useSCPfilters <> 0)               -- Conditionally return filters (09May2011)
      END
--    select debug='Tbld taskInfo', * from @taskInfo
------------------------------------------------------
--    SET THE ENABLE/DISABLE MEMBERS BASED ON THE           --
--  .. XMLENTITIES LIST OF THE APPROPRIATE ALERT:     --
------------------------------------------------------
--    Assumption here is that there is only one laptop alert per alertType!
      DECLARE @alertId int
      DECLARE @entities XML
--  DATA PROTECTION:
      SET @alertId = (select top 1 ID from NTnotificationRule where (status & 128) <> 0 and alertTypeId =3)   -- 'NT_STATUS_LAPTOP_ALERT, NT_ALERTTYPE_DATA_PROT
      SET @entities     = (select xmlentityList from NTnotificationRule where id = @alertId)
      UPDATE @clientList
            SET isDPalertEnabled = 1
                  WHERE subId in (
                              SELECT ref.value('@subclientId', 'integer')
                                    FROM @entities.nodes ('/CVGui_CommCellTreeNode[1]/clients[1]/clients[@subclientId!=0]') R(ref)
                                          )
--  DATA RECOVERY:
      SET @alertId = (select top 1 ID from NTnotificationRule where (status & 128) <> 0 and alertTypeId =4)   -- 'NT_STATUS_LAPTOP_ALERT, NT_ALERTTYPE_DATA_RECOV
      SET @entities     = (select xmlentityList from NTnotificationRule where id = @alertId)
      UPDATE @clientList
            SET isDRalertEnabled = 1
                  WHERE subId in (
                              SELECT ref.value('@subclientId', 'integer')
                                    FROM @entities.nodes ('/CVGui_CommCellTreeNode[1]/clients[1]/clients[@subclientId!=0]') R(ref)
                                          )
	END
DECLARE @outputXmlStringFS XML
DECLARE @outputXmlStringMB XML
DECLARE @outputXmlStringSP XML
DECLARE @outputXmlStringVM XML
SET @outputXmlStringFS =
            (SELECT backupSize as '@backupSize', capabilities as '@capabilities', isOwner as '@isOwner', totalbackupsize as '@totalBackupSize',
                              isArchived as '@isVMArchived', isDRalertEnabled as '@isDRalertEnabled', isDPalertEnabled as '@isDPalertEnabled',
                                    decoupleSCPcontent as '@isDecoupledContent', contentIndexingEnabled as '@contentIndexingEnabled',
                                   (select dirDelim  from APP_iDAType where APP_iDAType.type =  cl.appId) as '@dirDelim'
                                    , (CASE WHEN lastGeoLocation IS NULL
												THEN NULL
											WHEN (geoLocationDisplayMode IS NULL OR geoLocationDisplayMode < 0 OR geoLocationDisplayMode > 2)
												THEN @defaultGeoLocatoinDisplayMode
											ELSE
													geoLocationDisplayMode
											END) as '@geoLocationDisplayMode' ,
                  (SELECT lastbkupTime AS '@time', 55 '@_type_' FOR XML PATH ('lastBackupTime'), TYPE),
                  (SELECT lastSuccessBkupTime AS '@time', 55 '@_type_' FOR XML PATH ('lastSuccessBackupTime'), TYPE),
                  (SELECT lastGeoLocation),
                  (SELECT CASE WHEN lastGeoLocation IS NULL THEN NULL
								ELSE
								  (SELECT  lastGeoLocationTime as '@time', 55 '@_type_' FOR XML PATH ('lastGeoLocationTime'), TYPE)
								END),
				  (SELECT lastOnlineTime AS '@time', 55 '@_type_' FOR XML PATH ('lastOnlineTime'), TYPE),
                  (SELECT lastOfflineTime AS '@time', 55 '@_type_' FOR XML PATH ('lastOfflineTime'), TYPE),
                  (SELECT nextBkupTime AS '@time', 55 '@_type_' FOR XML PATH ('nextBackupTime'), TYPE),
                  (SELECT ST.patternInfo AS '@patternInfo',
                        (SELECT ST.subTaskId AS '@subtaskId', ST.subTaskName AS '@subtaskName',
                              ST.taskId AS '@taskId', ST.taskName AS '@taskName'
                              FOR XML PATH ('subTask'), TYPE
                        ),
                        (SELECT ST.ownerId AS '@userId', ST.ownerName AS '@userName'
                              FOR XML PATH ('owner'), TYPE
                        ),
                         (SELECT ST.subtaskType AS '@val'
                              FOR XML PATH ('taskType'), TYPE
                        )
                        FROM @taskInfo ST WHERE ST.clientId=cId
                        FOR XML PATH ('subTasks'), TYPE),
                  (SELECT cId as '@clientId', clientName as '@clientName', hostname as '@hostName', appId as '@applicationId', instId as '@instanceId', bSet as '@backupsetId', subId as '@subclientId', 7 '@_type_'
                  FOR XML PATH ('subClient'), TYPE),
                  (SELECT clientId as '@clientId',  appId as '@applicationId', instanceId as '@instanceId', assocBset as '@backupsetId', subId as '@subclientId', 7 '@_type_'
                        FROM @assocSubClient
                        WHERE assocSubClientId = assocSubC
                        FOR XML PATH ('assocSPsubclient'), TYPE),
 -- CONTENTS:
            (SELECT
                (SELECT
                    created as '@createTime', modified AS '@modifyTime', fileName AS '@value',
                    type as '@valueType'
                    FROM @content c WHERE c.subId = cl.subId
                FOR XML PATH ('content'), TYPE)
            FOR XML PATH ('contents'), TYPE),
            --          FOLLOWING ADDED SO WE CAN "RESTORE" TO SCP CONTENTS
                  (SELECT
                        (SELECT
                              created as '@createTime', modified AS '@modifyTime', fileName AS '@value', type as '@valueType'
                              FROM @SCPcontent c WHERE c.assocSubId = assocSubC
                              --AND decoupleSCPcontent = 0
                        FOR XML PATH ('content'), TYPE)
                  FOR XML PATH ('SCPcontents'), TYPE),
				-- global Filters --'CV_GLOBAL_FILTER = 13,	-- Global filer
					(
						SELECT CASE
								WHEN cl.useGlobalFilter = 1 AND EXISTS( SELECT appTypeId FROM GetAppTypesForAppGroup(22,0) where appTypeId = cl.appId ) --'APPGRP_W2KFileSystem
									THEN	(SELECT [@WindowsGlobalExcludeFilters].value '@value', 13 as '@valueType' FROM @WindowsGlobalExcludeFilters FOR XML PATH('content'), TYPE)
								WHEN  cl.useGlobalFilter = 1 AND EXISTS( SELECT appTypeId FROM GetAppTypesForAppGroup(34,0) where appTypeId = cl.appId) --'APPGRP_UnixFileSystem
									THEN	(SELECT [@UnixGlobalExcludeFilters].value '@value', 13 as '@valueType' FROM @UnixGlobalExcludeFilters FOR XML PATH('content'), TYPE)
								END
						FOR XML PATH('globalContents'), TYPE
                  )
                  FROM @clientList cl
                  WHERE bSet <> 0 and cl.appId in (SELECT appTypeId FROM GetAppTypesForAppGroup(35,0))
				  ORDER BY clientName
                  FOR XML PATH ('clientsFileSystem'))
SET @outputXmlStringSP =
            (SELECT backupSize as '@backupSize', capabilities as '@capabilities', isOwner as '@isOwner', totalbackupsize as '@totalBackupSize',
                              isArchived as '@isVMArchived', isDRalertEnabled as '@isDRalertEnabled', isDPalertEnabled as '@isDPalertEnabled',
                                   (select dirDelim  from APP_iDAType where APP_iDAType.type =  cl.appId) as '@dirDelim',
                  (SELECT lastbkupTime AS '@time', 55 '@_type_' FOR XML PATH ('lastBackupTime'), TYPE),
                  (SELECT lastSuccessBkupTime AS '@time', 55 '@_type_' FOR XML PATH ('lastSuccessBackupTime'), TYPE),
                  (SELECT lastOnlineTime AS '@time', 55 '@_type_' FOR XML PATH ('lastOnlineTime'), TYPE),
                  (SELECT lastOfflineTime AS '@time', 55 '@_type_' FOR XML PATH ('lastOfflineTime'), TYPE),
                  (SELECT nextBkupTime AS '@time', 55 '@_type_' FOR XML PATH ('nextBackupTime'), TYPE),
                  (SELECT ST.patternInfo AS '@patternInfo',
                        (SELECT ST.subTaskId AS '@subtaskId', ST.subTaskName AS '@subtaskName',
                              ST.taskId AS '@taskId', ST.taskName AS '@taskName'
                              FOR XML PATH ('subTask'), TYPE
                        ),
                        (SELECT ST.ownerId AS '@userId', ST.ownerName AS '@userName'
                              FOR XML PATH ('owner'), TYPE
                        ),
                         (SELECT ST.subtaskType AS '@val'
                              FOR XML PATH ('taskType'), TYPE
                        )
                        FROM @taskInfo ST WHERE ST.clientId=cId
                        FOR XML PATH ('subTasks'), TYPE),
                  (SELECT cId as '@clientId', clientName as '@clientName', hostname as '@hostName',  appId as '@applicationId', instId as '@instanceId', bSet as '@backupsetId', subId as '@subclientId', 7 '@_type_'
                  FOR XML PATH ('subClient'), TYPE),
                  (SELECT clientId as '@clientId',  appId as '@applicationId', instanceId as '@instanceId', assocBset as '@backupsetId', subId as '@subclientId', 7 '@_type_'
                        FROM @assocSubClient
                        WHERE assocSubClientId = assocSubC
                        FOR XML PATH ('assocSPsubclient'), TYPE),
            (SELECT
                (SELECT
                    created as '@createTime', modified AS '@modifyTime', fileName AS '@value',
                    type as '@valueType'
                    FROM @content c WHERE c.subId = cl.subId
                FOR XML PATH ('content'), TYPE)
            FOR XML PATH ('contents'), TYPE),
            --          FOLLOWING ADDED SO WE CAN "RESTORE" TO SCP CONTENTS
                  (SELECT
                        (SELECT
                              created as '@createTime', modified AS '@modifyTime', fileName AS '@value', type as '@valueType'
                              FROM @SCPcontent c WHERE c.assocSubId = assocSubC
                        FOR XML PATH ('content'), TYPE)
                  FOR XML PATH ('SCPcontents'), TYPE)
                  FROM @clientList cl
                  WHERE bSet <> 0 and cl.appId in (SELECT appTypeId FROM GetAppTypesForAppGroup(55,0))
				   ORDER BY clientName
                  FOR XML PATH ('clientsSharePointDoc'))
DECLARE @userMailBoxXML XML
IF(@userMailBox = 1 AND @getMailBoxClients = 1)
BEGIN
 EXEC    [dbo].AppGetLaptopUserMailBox @mailBoxGuid ,@userid, @userMailBoxXML OUTPUT
END
 --VM
 SET @outputXmlStringVM =
            (SELECT backupSize as '@backupSize', capabilities as '@capabilities', isOwner as '@isOwner', totalbackupsize as '@totalBackupSize',
                              isArchived as '@isVMArchived', isDRalertEnabled as '@isDRalertEnabled', isDPalertEnabled as '@isDPalertEnabled',
                                    decoupleSCPcontent as '@isDecoupledContent',
           --     if(@getDetailProperties = 1)
                  (SELECT  vmGUID as '@vmGUID', vmName as  '@clientName', vCid as '@clientId', vmHostName as '@hostName' FROM @vmEntity vm WHERE vm.vCid = cl.vCid
                        FOR XML PATH ('vmEntity'), TYPE),
					(SELECT ref.value('client[1]/@clientId','int') AS '@clientId',
						ref.value ('client[1]/@clientName','varchar(1024)')AS '@clientName'
							FROM @proxyEntity vmList
						CROSS APPLY vmList.proxyClientXML.nodes ('App_MemberServers/memberServers') R(ref)  WHERE instanceId = cl.instId  FOR XML PATH ('proxyClient'), TYPE) ,
                   (SELECT lastbkupTime AS '@time', 55 '@_type_' FOR XML PATH ('lastBackupTime'), TYPE),
				   (SELECT lastSuccessBkupTime AS '@time', 55 '@_type_' FOR XML PATH ('lastSuccessBackupTime'), TYPE),
                   (SELECT lastOnlineTime AS '@time', 55 '@_type_' FOR XML PATH ('lastOnlineTime'), TYPE),
                   (SELECT lastOfflineTime AS '@time', 55 '@_type_' FOR XML PATH ('lastOfflineTime'), TYPE),
                   (SELECT nextBkupTime AS '@time', 55 '@_type_' FOR XML PATH ('nextBackupTime'), TYPE),
                  (SELECT ST.patternInfo AS '@patternInfo',
                        (SELECT ST.subTaskId AS '@subtaskId', ST.subTaskName AS '@subtaskName',
                              ST.taskId AS '@taskId', ST.taskName AS '@taskName'
                              FOR XML PATH ('subTask'), TYPE
                        ),
                        (SELECT ST.ownerId AS '@userId', ST.ownerName AS '@userName'
                              FOR XML PATH ('owner'), TYPE
                        )
                        FROM @taskInfo ST WHERE ST.clientId=cId
                        FOR XML PATH ('subTasks'), TYPE),
                  (SELECT cId as '@clientId', clientName as '@clientName', appId as '@applicationId', instId as '@instanceId', bSet as '@backupsetId', subId as '@subclientId', 7 '@_type_'
                  FOR XML PATH ('subClient'), TYPE),
                  (SELECT clientId as '@clientId',  appId as '@applicationId', instanceId as '@instanceId', assocBset as '@backupsetId', subId as '@subclientId', 7 '@_type_'
                        FROM @assocSubClient
                        WHERE assocSubClientId = assocSubC
                        FOR XML PATH ('assocSPsubclient'), TYPE),
 -- CONTENTS:
            (SELECT
                (SELECT
                    created as '@createTime', modified AS '@modifyTime', fileName AS '@value',
                    type as '@valueType'
                    FROM @content c WHERE c.subId = cl.subId
                FOR XML PATH ('content'), TYPE)
            FOR XML PATH ('contents'), TYPE),
            --          FOLLOWING ADDED SO WE CAN "RESTORE" TO SCP CONTENTS
                  (SELECT
                        (SELECT
                              created as '@createTime', modified AS '@modifyTime', fileName AS '@value', type as '@valueType'
                              FROM @SCPcontent c WHERE c.assocSubId = assocSubC
                              --AND decoupleSCPcontent = 0
                        FOR XML PATH ('content'), TYPE)
                  FOR XML PATH ('SCPcontents'), TYPE)
                  FROM @clientList cl
WHERE  appId=106--and cl.appTypeId in (SELECT appTypeId FROM GetAppTypesForAppGroup(35,0))
				   ORDER BY clientName
                  FOR XML PATH ('clientsVMs'))
 SET @xmlString = (select @outputXmlStringFS,@outputXmlStringMB,@outputXmlStringSP,CAST (@userMailBoxXML AS XML),@outputXmlStringVM FOR XML PATH(''),ROOT('App_LapTopClientLstResp'))
 if(@xmlString IS NOT NULL)
	SET @xmlString.modify('delete (//*[empty(./*) and not(./@*)])')
if(@xmlString.exist('/App_LapTopClientLstResp') = 0)
	SET @xmlString = ('<App_LapTopClientLstResp/>')
END TRY
----=====================================================================
----==============  COME HERE IF THERE WAS A PROBLEM!     ===============
----=====================================================================
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode    = ERROR_NUMBER()
    SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
    SET @xmlString = ( SELECT
                ( SELECT @errorCode '@errorCode', @errorString '@errorMessage'
                      FOR XML PATH('error'), TYPE
                )
    FOR XML PATH(''),
    ROOT('App_LapTopClientLstResp'))
END CATCH
SELECT @xmlString
--------------------------------------------
-- SOME CODE, FOR STANDALONE DEBUGGING  ----
--------------------------------------------
/*
IF EXISTS (Select * from sysObjects where name = 'APPGetFLAClientList')
      Drop proc APPGetFLAClientList
GO
DECLARE @xml XML
DECLARE @xmltext nvarchar(max)=
'<App_LapTopClientListReq scope="2">
	<locale localeId="0" />
	<user userId="24" />
	<filter getMailBoxClients="1" getContent="0" getSchedules="0" getSharePointClients="1" getFsLikeClients="1" />
</App_LapTopClientListReq>'SET @xml = @xmltext
exec APPGetLaptopClientProperties @xml
*/
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetFLAClientList')
	delete from GxQscripts where name = 'APPGetFLAClientList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFLAClientList')
	delete from GXDBVersions where aliasname = 'APPGetFLAClientList'
GO

insert into GXDBVersions values(2, 'APPGetFLAClientList',  'v1.5.60.2.68.1', 'APPGetFLAClientList', 'v1.5.60.2.68.1')
GO

