

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetFLAClientGroupList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetFLAClientGroupList.sp,v $ $Id: APPGetFLAClientGroupList.sp,v 1.24.2.18 2020/06/11 20:16:20 pankajkumar Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			CURSOR : "APPGetFLAClientGroupList"			|
--	|									|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION	|
--	| AND RETURNING RESULTS							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetFLAClientGroupList')
BEGIN
	print '>>> Drop Stored Procedure: APPGetFLAClientGroupList <<<'
	drop procedure APPGetFLAClientGroupList
END
IF EXISTS (select * from GxQscripts where name='APPGetFLAClientGroupList')
	delete from GxQscripts where name = 'APPGetFLAClientGroupList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFLAClientGroupList')
	delete from GXDBVersions where aliasname = 'APPGetFLAClientGroupList'
GO
print '... Creating Procedure: APPGetFLAClientGroupList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetFLAClientGroupList
  @i_userId int = 0,
  @i_capability bigint = 13,
  @i_clientGrpId bigint = 0,
  @o_XMLText XML OUTPUT
AS
SET NOCOUNT ON
DECLARE @isAllAssociationsSetBrowse INT = 0
DECLARE @isAllAssociationsSetEnduser INT = 0
DECLARE @tblApptypes    TABLE (t_appTypeId int)
IF OBJECT_ID('tempdb.dbo.#clientGroupEntity') IS NOT NULL     DROP TABLE #clientGroupEntity
CREATE  TABLE #clientGroupEntity (
								clientGroupId INT,
								hasBrowse	integer   --1-Browse, 0 - Enduser
								primary key (clientGroupId)
							)
IF object_id('tempdb.dbo.#tmpClientTbl') IS NOT null DROP TABLE #tmpClientTbl
	CREATE TABLE #tmpClientTbl (
				commcellId INT,
				clientId	integer,
				clientName  nvarchar(2048),
				appTypeId   integer,
				clientGroupId	integer,
				clientGroupName nvarchar(2048),
				lastAnalyticsTime integer,
				hasBrowse	int,
				Primary key (commcellId, clientGroupId, clientId, appTypeId)
			)
--Supported apptypes for file anlaytics
	--Windows FS apptypes
	INSERT INTO @tblAppTypes
VALUES (11), 	(42),	(43),	(33),	(43)
	--NAS apptypes
INSERT INTO @tblAppTypes VALUES (13)
	--VSA apptypes
INSERT INTO @tblAppTypes VALUES (106)
	--Unix FS apptypes
	INSERT INTO @tblAppTypes
VALUES	(17), 		(18),		(17),		(19),		(19),
(20),		(21),		(29),		(38),		(36),
(63),		(64),		(74)
--
BEGIN
	--get ALL association COMMCELL LEVEL check BROWSE
EXEC sec_checkPermissionOnEntity @i_userId, @i_capability /*EV_BROWSE*/, @isAllAssociationsSetBrowse OUTPUT, 1 /*COMMCELL_ENTITY*/, 2
	IF @isAllAssociationsSetBrowse = 0
	BEGIN
		--get ALL association COMMCELL LEVEL check ENDUSER
EXEC sec_checkPermissionOnEntity @i_userId, 24 /*EV_FAST_ENDUSER_SEARCH*/, @isAllAssociationsSetEnduser OUTPUT, 1 /*COMMCELL_ENTITY*/, 2
	END
	--if ALL association is set, get list of associated client groups
	IF @isAllAssociationsSetBrowse = 1 OR @isAllAssociationsSetEnduser = 1
	BEGIN
		INSERT INTO #clientGroupEntity (clientGroupId , hasBrowse)
		SELECT Id, @isAllAssociationsSetBrowse
		FROM APP_ClientGroup (NOLOCK)
	END
	ELSE --if ALL association is NOT set, get list of associated client groups
	BEGIN
		--EV_BROWSE CAPABILITY
		IF OBJECT_ID('tempdb.dbo.#sec_GetEntity') IS NOT NULL     DROP TABLE #sec_GetEntity1
		CREATE  TABLE #sec_GetEntity1 ( entityId INT)
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 28 /*CLIENT_GROUP_ENTITY*/ , @i_capability ,'#sec_GetEntity1'
		IF EXISTS(SELECT TOP 1 1 FROM #sec_GetEntity1)
		BEGIN
			INSERT INTO #clientGroupEntity (clientGroupId, hasBrowse)
			SELECT DISTINCT  entityId, 1
			FROM	#sec_GetEntity1
		END
		DROP TABLE #sec_GetEntity1
		--EV_FAST_ENDUSER_SEARCH CAPABILITY
		IF OBJECT_ID('tempdb.dbo.#sec_GetEntity2') IS NOT NULL     DROP TABLE #sec_GetEntity2
		CREATE  TABLE #sec_GetEntity2 ( entityId INT)
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 28 /*CLIENT_GROUP_ENTITY*/ , 24 ,'#sec_GetEntity2'
		-- delete existing entries, to remove duplicate rows
		DELETE F
		FROM #sec_GetEntity2 F
		INNER JOIN #clientGroupEntity U ON F.entityId = U.clientGroupId
		IF EXISTS (SELECT TOP 1 1 FROM #sec_GetEntity2)
		BEGIN
			INSERT INTO #clientGroupEntity (clientGroupId, hasBrowse)
			SELECT DISTINCT entityId, 0
			FROM	#sec_GetEntity2
		END
		DROP TABLE #sec_GetEntity2
	END
END
--Delete other client groups if clientgroupId input is provided
IF @i_clientGrpId > 0
	DELETE FROM  #clientGroupEntity WHERE clientGroupId != @i_clientGrpId
--get last analytics job run time for each client for which analytics job is run
IF object_id('tempdb.dbo.#lastAnalyticsStartTimeByClient') IS NOT null DROP TABLE #lastAnalyticsStartTimeByClient
    CREATE TABLE #lastAnalyticsStartTimeByClient (t_clientId INT, t_maxAnalyticTime INT Primary key (t_clientId))
	INSERT INTO #lastAnalyticsStartTimeByClient
    SELECT CGA.clientId, MAX(FLA.indexTime)
    FROM #clientGroupEntity C
		INNER JOIN APP_ClientGroupAssoc CGA (NOLOCK) ON C.clientGroupId= CGA.clientGroupId
		INNER JOIN APP_Application APP WITH (NOLOCK) ON CGA.clientId = APP.clientId
		INNER JOIN @tblAppTypes ON APP.appTypeId = t_appTypeId
		INNER JOIN ARCHFILE AF WITH (NOLOCK) ON APP.id = AF.appId AND AF.fileType = 1
		INNER JOIN archFLAIndexingInfo FLA WITH (NOLOCK)
				ON AF.id = FLA.archFileId AND (FLA.flags & 64) >0
			--commcellId check is not needed, to support backup jobs run after client migration
    GROUP BY CGA.clientId
--get other details like apptypeId, clientgroupId,commcellId
INSERT INTO #tmpClientTbl (commcellId, clientId, clientGroupId, appTypeId, lastAnalyticsTime,	hasBrowse)
SELECT DISTINCT  APP.origCCId, CGA.clientId, CGA.ClientGroupId, APP.appTypeId, T.t_maxAnalyticTime, C.hasBrowse
FROM #clientGroupEntity C
INNER JOIN APP_ClientGroupAssoc CGA (NOLOCK) ON c.clientGroupId = CGA.clientGroupId
INNER JOIN #lastAnalyticsStartTimeByClient t ON T.t_clientId = CGA.clientId
INNER JOIN APP_Application APP WITH (NOLOCK) ON CGA.clientId = APP.clientId
INNER JOIN @tblAppTypes ON APP.appTypeId = t_appTypeId
-- INCLUDE VM LIST FOR VSA ANALYTICS
IF EXISTS (SELECT 1 FROM APP_ClientProp CP (NOLOCK) WHERE attrName = 'AnalysisComplete' and attrVal = '1' )
BEGIN
	INSERT INTO #tmpClientTbl (commcellId, clientId, clientGroupId, appTypeId, hasBrowse)
SELECT DISTINCT C.origCCId, CGA.clientId, CGA.ClientGroupId,  106, CE.hasBrowse
		FROM #clientGroupEntity CE
        INNER JOIN APP_ClientGroupAssoc CGA (NOLOCK) ON CE.clientGroupId = CGA.clientGroupId
        INNER JOIN APP_ClientProp CP (NOLOCK) ON  cga.clientId =CP.componentNameId
		INNER JOIN APP_Client C (NOLOCK) ON  CGA.clientId =C.Id
		WHERE attrName ='AnalysisComplete' AND attrVal ='1' and CP.modified = 0
		AND NOT EXISTS (SELECT 1 FROM #tmpClientTbl T WHERE cga.clientId= T.clientId)
IF EXISTS (SELECT TOP 1 1 FROM #tmpClientTbl WHERE appTypeId = 106)
	BEGIN
		;WITH CTE
		AS
		(
			SELECT cast (attrVal AS INT) AS LastAnalysisTime, clientId
			FROM APP_ClientProp CP (NOLOCK)
			JOIN #tmpClientTbl ON CP.componentNameId =clientId
WHERE appTypeId = 106 AND modified = 0 and attrName = 'LastAnalysisTime'
		)
		UPDATE #tmpClientTbl
		SET lastAnalyticsTime =LastAnalysisTime
FROM CTE WHERE CTE.clientId =#tmpClientTbl.clientId AND appTypeId = 106
	END
END
DROP TABLE #clientGroupEntity
DROP TABLE #lastAnalyticsStartTimeByClient
UPDATE #tmpClientTbl
SET clientName = name
from APP_Client (nolock)
where clientid =id
UPDATE #tmpClientTbl
SET clientGroupName = name
from APP_ClientGroup (nolock)
where  clientgroupId =id
--SELECT * FROM #tmpClientTbl
SET @o_XMLText = ISNULL((   SELECT
							1 AS '@analyticsReqType',
							(
                            SELECT
                                clientGroupId AS '@clientGroupId',
                                clientGroupName AS '@clientGroupName',
                                ISNULL(MAX(lastAnalyticsTime),0) AS '@lastAnalyticsTime',
                                MAX(hasBrowse) AS '@hasBrowse',
								0 AS '@sizeInBytes',
                                (SELECT
                                        T2.clientId AS '@clientId',
                                        T2.clientName AS '@clientName',
                                        T2.commcellId AS '@commcellNumber',
                                        ISNULL(T2.lastAnalyticsTime,0) AS '@lastAnalyticsTime',
                                        MAX(hasBrowse) AS '@hasBrowse',
                                    (SELECT
                                        T3.appTypeId AS '@applicationId'
                                        FROM #tmpClientTbl T3
                                        WHERE T3.clientGroupId = T.clientGroupId AND T3.clientId = T2.clientId
                                        GROUP BY T3.clientId, T3.appTypeId
                                        FOR XML PATH('subClients'), TYPE
                                    )
                                    FROM #tmpClientTbl T2
                                    WHERE T2.clientGroupId = T.clientGroupId
                                    GROUP BY T2.clientId, T2.clientName, T2.commcellId, T2.lastAnalyticsTime
                                    FOR XML PATH('analyticsClients'), TYPE
                                )
                    FROM #tmpClientTbl T
                    GROUP BY T.clientGroupId, T.clientGroupName, T.commcellId
                    ORDER BY clientGroupId
                     FOR XML PATH('analyticsGroups'), TYPE
                     ) FOR XML PATH('DM2ContentIndexing_AnalyticsGroupResp')
                     ),'<DM2ContentIndexing_AnalyticsGroupResp/>')
DROP TABLE #tmpClientTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetFLAClientGroupList')
	delete from GxQscripts where name = 'APPGetFLAClientGroupList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetFLAClientGroupList')
	delete from GXDBVersions where aliasname = 'APPGetFLAClientGroupList'
GO

insert into GXDBVersions values(2, 'APPGetFLAClientGroupList',  '00010024000200180000', 'APPGetFLAClientGroupList', '00010024000200180000')
GO

