

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetExpiredAutoProxyVms.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppGetExpiredAutoProxyVms"
--	|	Generates list of VirtualMachineOptions for a given AutoProxy jobId
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetExpiredAutoProxyVms')
BEGIN
	print '>>> Drop Stored Procedure: AppGetExpiredAutoProxyVms <<<'
	drop procedure AppGetExpiredAutoProxyVms
END
IF EXISTS (select * from GxQscripts where name='AppGetExpiredAutoProxyVms')
	delete from GxQscripts where name = 'AppGetExpiredAutoProxyVms'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetExpiredAutoProxyVms')
	delete from GXDBVersions where aliasname = 'AppGetExpiredAutoProxyVms'
GO
print '... Creating Procedure: AppGetExpiredAutoProxyVms'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetExpiredAutoProxyVms
AS
  DECLARE @o_xml XML
BEGIN TRY
	declare @errorCode   int = 0
	declare @errorString  nvarchar(1024)
	IF object_id('tempdb.dbo.#tmpAutoProxyVmsToDelete') IS NOT null DROP TABLE #tmpAutoProxyVmsToDelete
				create table #tmpAutoProxyVmsToDelete(
										clientId		 nvarchar(1024),
										vmguid			 nvarchar(1024),
										vmName			 nvarchar(1024),
										instanceId       int,
										lastPoweredOffTime   bigint,
										policyId		int,
										expirationMinSetInPolicy	int
				)
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	insert into #tmpAutoProxyVmsToDelete (clientId,vmguid,vmName,instanceId,lastPoweredOffTime)
	select C.id, CP2.attrVal, C.name, cast(CP3.attrVal as int), M.LastAccessTime
	from app_client C
	inner join APP_ClientProp CP1 on C.id = CP1.componentNameId and CP1.attrName = 'Auto Proxy Client'
	inner join APP_ClientProp CP2 on C.id = CP2.componentNameId and CP2.attrName = 'Virtual Machine GUID'
	inner join APP_ClientProp CP3 on C.id = CP3.componentNameId and CP3.attrName = 'Virtual Machine Instance ID'
inner join MMPowerMGmtHost M on M.HostId = C.id and M.PowerStatus = 5
	DECLARE @idleTimeOutToPowerOffInMin INT = ISNULL((select value from MMConfigs WITH (NOLOCK) WHERE name = 'MMCONFIG_CLOUD_VM_MANAGEMENT_MA_IDLE_TIME'), 30)
	update #tmpAutoProxyVmsToDelete
	set policyId = cast (attrVal as int) FROM APP_InstanceProp WHERE componentNameId= instanceId AND attrName='Auto Scale Policy'
	update #tmpAutoProxyVmsToDelete
	set expirationMinSetInPolicy = isNull(ref.value('@minutesRetainUntil','int'),60)
	from #tmpAutoProxyVmsToDelete T inner join App_VmAllocationPolicy P on T.policyId = P.id
	OUTER APPLY P.vxml.nodes ('policy') VMP(ref)
	-- remove vms that are not yet expired
	delete vmlist
	from #tmpAutoProxyVmsToDelete vmlist
	where DATEDIFF(mi, dbo.GetDateTimeBig(vmlist.lastPoweredOffTime), GETUTCDATE()) < (expirationMinSetInPolicy - @idleTimeOutToPowerOffInMin)
	-- Return stale vms that are already deleted
	insert into #tmpAutoProxyVmsToDelete (clientId,instanceId)
	select C.id, cast(CP3.attrVal as int)
	from app_client C
	inner join APP_ClientProp CP1 on C.id = CP1.componentNameId and CP1.attrName = 'Auto Proxy Client'
	inner join APP_ClientProp CP2 on C.id = CP2.componentNameId and CP2.attrName = 'Virtual Machine Deletion Time' and isnull(CP2.attrval,0) > 0 and CP2.modified = 0
	inner join APP_ClientProp CP3 on C.id = CP3.componentNameId and CP3.attrName = 'Virtual Machine Instance ID'
	declare @vmOpXml xml
	set  @vmOpXml = (select (select vmlist.instanceId '@instanceId'
					   FOR XML PATH  ('vmAllocPolicy') , TYPE),
					(select
						(select vmlist.vmguid as '@vmGUID', vmlist.vmName as '@vmName', vmlist.clientId as '@clientId'
							  FOR XML PATH ('vm') , type)
							FOR XML PATH  ('vmInfo') , TYPE)
					 FROM  #tmpAutoProxyVmsToDelete vmlist
					 FOR XML PATH ('virtualMachineOption'))
	set @o_xml =(select @vmOpXml FOR XML PATH ('TMMsg_VMProvisioningOption'), TYPE)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @errorCode = ERROR_NUMBER()
SET @errorString = ERROR_MESSAGE()
END CATCH
ERROR_EXIT:
IF @errorCode <> 0
BEGIN
	SET @o_xml = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
                            FOR XML PATH('Ida_GenericResp'), TYPE)
END
select @o_xml as 'o_xml'
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetExpiredAutoProxyVms')
	delete from GxQscripts where name = 'APPGetExpiredAutoProxyVms'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetExpiredAutoProxyVms')
	delete from GXDBVersions where aliasname = 'APPGetExpiredAutoProxyVms'
GO

insert into GXDBVersions values(2, 'APPGetExpiredAutoProxyVms',  '00000000000000000000', 'APPGetExpiredAutoProxyVms', '00000000000000000000')
GO

