

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetExchDbRestoreClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetExchDbRestoreClients.sp,v $ $Id: APPGetExchDbRestoreClients.sp,v 1.1.2.6 2020/09/19 12:59:05 nuppu Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppGetExchDbRestoreClients')
BEGIN
	print '>>> Drop Stored Procedure: AppGetExchDbRestoreClients <<<'
	drop procedure AppGetExchDbRestoreClients
END
IF EXISTS (select * from GxQscripts where name='AppGetExchDbRestoreClients')
	delete from GxQscripts where name = 'AppGetExchDbRestoreClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppGetExchDbRestoreClients')
	delete from GXDBVersions where aliasname = 'AppGetExchDbRestoreClients'
GO
print '... Creating Procedure: AppGetExchDbRestoreClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppGetExchDbRestoreClients
  @i_xml XML
AS
SET NOCOUNT ON
DECLARE @nUserId		INT
DECLARE @x_xmlData      XML
DECLARE @errorCode INTEGER = 0
DECLARE @errorString NVARCHAR(1024) = ''
DECLARE @exchVersion INT
DECLARE @restoreOption INT
DECLARE @apptypeId INT = 53
    SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET 	@exchVersion=ISNULL(( SELECT ref.value('@exchVersion','INTEGER')
				FROM @i_xml.nodes('App_AppGetExchDbRestoreClientsReq') R(ref)) ,0)
	SET		@restoreOption = ISNULL(( SELECT ref.value('@restoreOption','INTEGER')
				FROM @i_xml.nodes('App_AppGetExchDbRestoreClientsReq') R(ref)) ,0)
	SET 	@nUserId = ISNULL((SELECT  ref.value('@userId', 'int') AS client
				FROM @i_xml.nodes('App_AppGetExchDbRestoreClientsReq/processinginstructioninfo/user') R ( ref )),0)
	BEGIN TRY
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#tempMembers') IS NOT NULL	 DROP TABLE #tempMembers
			CREATE TABLE #tempMembers (Dagid INT, DagName NVARCHAR(256), Memberid INT, MemberName NVARCHAR(256), exVersion INT, IsDAG INT)
			IF(@restoreOption = 1)
			BEGIN
			--get All Exchange DAG clients, member servers, standalone clients - that match given version
				-- Get Dag Clients of given Exchange version
				IF OBJECT_ID('tempdb.dbo.#tempDAG') IS NOT NULL
					 DROP TABLE #tempDAG
				CREATE TABLE #tempDAG (id INT, name NVARCHAR (256))
				INSERT INTO #tempDAG  SELECT C.id, C.name FROM APP_Client C
				JOIN APP_IDAName N ON N.clientId = C.id
				JOIN APP_IDAProp P ON P.componentNameId = N.id AND P.attrName = 'DAG Exchange Version' AND P.attrVal = @exchVersion AND P.modified = 0
WHERE (C.status & 0x200000) > 0
				--Get Dag member servers of above DAG clients
				INSERT INTO #tempMembers
				SELECT d.id, d.name, c.id, c.name, @exchVersion, 1
				FROM APP_Client c, #tempDAG d
				JOIN APP_ClientProp cp ON cp.componentNameId = d.id AND cp.attrType = 125
				WHERE c.net_hostname = cp.attrName
				--Get StandAlone servers (clients with Db agents of matching exchange version).
				INSERT INTO #tempMembers
				SELECT C.Id, C.name, C.Id, C.name, @exchVersion, 0
				FROM APP_Client C, APP_IDAName N
				JOIN APP_IDAProp P ON P.componentNameId = N.id AND P.AttrName = 'IDA Version' AND P.attrVal = @exchVersion AND P.modified = 0
				WHERE C.id NOT IN  (select Memberid from #tempMembers where IsDAG = 1) AND C.id = N.clientId AND N.appTypeId = @apptypeId
				IF OBJECT_ID('tempdb.dbo.#tempDAG') IS NOT NULL	DROP TABLE #tempDAG
			END
		ELSE IF (@restoreOption = 2)
			BEGIN
			--get All Exchange physical clients where Exchange Package is installed
				INSERT INTO #tempMembers
				select C.id , C.name, C.id , C.name, 0, 0
				FROM app_client C, simInstalledPackages sim
				WHERE sim.simPackageID = 151 AND sim.ClientId = C.id
			END
		ELSE IF (@restoreOption = 3)
			BEGIN
			--get Exchange DB live browse clients list (clients with Exchange and 3dfs Pkgs).
			INSERT INTO #tempMembers
				select C.id , C.name, C.id , C.name, 0, 0
				FROM app_client C, simInstalledPackages sim, PatchSPVersion psp
				WHERE sim.simPackageID = 151 AND sim.ClientId = C.id AND sim.SPVersionID = psp.id AND psp.Release >= 16 AND psp.SPMajor >= 12
				update #tempMembers
				set IsDAG = 1 --IsDag flag is reused for 3dfs in this case
				where Memberid IN (select sim.ClientId  from simInstalledPackages sim where sim.simPackageID = 56)
			END
		--TODO: Apply security here
		--IF @nUserId > 0
			BEGIN
				-------Begin Apply security -----
				DECLARE @CapCanOutOfPlaceRestore INT
				SET @CapCanOutOfPlaceRestore = 0
SET @CapCanOutOfPlaceRestore = @CapCanOutOfPlaceRestore | POWER(2, 1-1)
SET @CapCanOutOfPlaceRestore = @CapCanOutOfPlaceRestore | POWER(2, 22 -1)
				--Get clients where user has end user access
				IF EXISTS(select * from GXGlobalParam where name = 'EnforceUnixUserPermissionsOnRestore' and value = 1)
				BEGIN
					IF @apptypeId IN (SElECT A.appTypeId from APP_AppTypeGroup G,APP_AppTypeGroupAssoc A where G.groupName = 'APPGRP_UnixFileSystem'
															and A.appGroupId=G.appTypeGroupId)
SET @CapCanOutOfPlaceRestore = @CapCanOutOfPlaceRestore | POWER(2, 24 -1)
				END
				IF object_id('tempdb.dbo.#tempUserObjects') IS NOT Null DROP TABLE #tempUserObjects
create table  #tempUserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @nUserId,  2013 , 0, '#tempUserObjects'
				IF object_id('tempdb.dbo.#tempUserRestoreClients') IS NOT Null DROP TABLE #tempUserRestoreClients
				SELECT DISTINCT U.capabilities, T.MemberId INTO #tempUserRestoreClients
				FROM	#tempMembers T, #tempUserObjects U
				WHERE	U.clientId In (0, T.MemberId) AND U.clientGroupId = 0 AND U.mediaAgentId = 0 AND U.libraryID = 0 AND U.archGroupID = 0
								AND U.vtContainerId=0 AND U.vtPolicyId=0 AND U.vtShelfId=0 AND U.reviewSetId=0 AND U.querySetId=0 AND U.downloadSetId=0 AND U.ermId=0 AND U.legalHoldId=0 AND U.tagId=0 AND U.cdPolicyId=0 AND U.complianceReportId=0 AND U.taskId=0 AND U.workflowId=0 AND U.logMonitoringPolicyId=0 AND U.arrayId=0 AND U.cloudId=0 AND U.userGroupId=0 AND U.providerId=0 AND U.entityId1=0 AND U.entityId2=0 AND U.entityId3=0 AND U.entityId4=0 AND U.entityId5=0	   AND U.entityId6=0 AND U.entityId7=0 AND U.entityId8=0 AND U.entityId9=0								AND U.entityId6=0 AND U.entityId7=0 AND U.entityId8=0 AND U.entityId9=0
				Delete #tempMembers
				FROM #tempMembers T
				WHERE NOT EXISTS (	select * from #tempUserRestoreClients U
									where T.MemberId = U.Memberid AND
										(	(U.capabilities & @CapCanOutOfPlaceRestore) > 0 ))
				DROP TABLE #tempUserObjects
				DROP TABLE #tempUserRestoreClients
				-------End APply Security ------
				SET @x_xmlData = (SELECT (case Members.isDag
												WHEN 0 THEN 'false'
												WHEN 1 THEN 'true'
												ELSE null
										end) AS 'isDag',
										Members.dagId AS 'id', Members.dagName AS 'name',
										Members.memberId AS 'clientId', Members.memberName AS 'clientName'
										FROM #tempMembers Members
								FOR XML PATH('restoreClients'),
								ROOT('App_AppGetExchDbRestoreClientsResp'))
				IF OBJECT_ID('tempdb.dbo.#tempMembers') IS NOT NULL	DROP TABLE #tempMembers
			END
		END
	SELECT ISNULL(@x_xmlData, '<App_AppGetExchDbRestoreClientsResp/>')
	END TRY
	BEGIN CATCH
	SET @errorCode = 1
	SET @errorString = 'Exception  - failed with error :: ' + ERROR_MESSAGE()
	SET @x_xmlData= (SELECT @errorCode as '@errorCode' , @errorString as '@errorMessage' FOR XML PATH ('response') , ROOT('APP_AppGetExchDbRestoreClientsResp') ,TYPE )
	SELECT @x_xmlData
	END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetExchDbRestoreClients')
	delete from GxQscripts where name = 'APPGetExchDbRestoreClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetExchDbRestoreClients')
	delete from GXDBVersions where aliasname = 'APPGetExchDbRestoreClients'
GO

insert into GXDBVersions values(2, 'APPGetExchDbRestoreClients',  '00010001000200060000', 'APPGetExchDbRestoreClients', '00010001000200060000')
GO

