

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetEntitySecurityXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetEntitySecurityXML')
BEGIN
	print '>>> Drop Stored Procedure: APPGetEntitySecurityXML <<<'
	drop procedure APPGetEntitySecurityXML
END
IF EXISTS (select * from GxQscripts where name='APPGetEntitySecurityXML')
	delete from GxQscripts where name = 'APPGetEntitySecurityXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetEntitySecurityXML')
	delete from GXDBVersions where aliasname = 'APPGetEntitySecurityXML'
GO
print '... Creating Procedure: APPGetEntitySecurityXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetEntitySecurityXML
  @xmlText XML OUTPUT
AS
DECLARE	@commcellId		integer
DECLARE @clientId		integer
DECLARE @appTypeId		integer
DECLARE @backupsetId	integer
DECLARE @instanceId		integer
DECLARE @clientGroupId	integer
DECLARE @subclientId	integer
DECLARE @mediaAgentId	integer
DECLARE @libraryId		integer
DECLARE @taskId			integer
DECLARE @storagePolicyId	integer
DECLARE @hasApptype		integer=0
DECLARE @hasInstance	integer=0
DECLARE @type1			integer=0
DECLARE @type2			integer=0
DECLARE @type3			integer=0
DECLARE @type4			integer=0
DECLARE @id1			integer=0
DECLARE @id2			integer=0
DECLARE @id3			integer=0
DECLARE @id4			integer=0
DECLARE @instanceSupported integer=0
DECLARE @backupSetSupported integer=0
DECLARE @ownercaps	XML
DECLARE @userId			integer
DECLARE @authType		integer=1
DECLARE @enableAuthorizeForRestore integer=0
DECLARE @expirationTimeStamp integer = 0
-- IN
-- exec APPGetEntitySecurityXML '<entity clientId="2" appTypeId="42" backupsetId= "3" subclientId="5"/>'
-- OUT
--     <associatedUserGroups userGroupId="1" userGroupName="master" />
--		<associatedUserGroups userGroupId="2" userGroupName="CV_Restricted_Visibility" />
--      <associatedUserGroups userGroupId="3" userGroupName="View All" />
--      <associatedUserGroups userGroupId="4" userGroupName="test" />
--        <associatedUserGroups userGroupId="5" userGroupName="test2" />
--        <associatedUserGroups userGroupId="6" userGroupName="test3" />
--        <associatedUserGroups userGroupId="7" userGroupName="test4" />
--        <clientOwners val="one" />
--        <clientOwners val="two" />
SET @commcellId     =  ISNULL((SELECT  ref.value('@commcellId', 'int') AS client
						   FROM    @xmlText.nodes('entity') R ( ref )),0)
SET @clientId		=  ISNULL((SELECT  ref.value('@clientId', 'int') AS client
							FROM    @xmlText.nodes('entity') R ( ref )),0)
SET @appTypeId		=  ISNULL((SELECT  ref.value('@applicationId', 'int') AS apptype
							FROM    @xmlText.nodes('entity') R ( ref )),0)
IF @appTypeId = 0
	SET @appTypeId		=  ISNULL((SELECT  ref.value('@appTypeId', 'int') AS apptype
								FROM    @xmlText.nodes('entity') R ( ref )),0)
SET @instanceId		=  ISNULL((SELECT  ref.value('@instanceId', 'int') AS instance
							FROM    @xmlText.nodes('entity') R ( ref )),0)
SET @backupsetId	=  ISNULL((SELECT  ref.value('@backupsetId', 'int') AS backupset
							FROM    @xmlText.nodes('entity') R ( ref )),0)
SET @clientGroupId	=  ISNULL((SELECT  ref.value('@clientGroupId', 'int') AS cg
							FROM    @xmlText.nodes('entity') R ( ref )),0)
SET @subclientId	=  ISNULL((SELECT  ref.value('@subclientId', 'int') AS sc
							FROM    @xmlText.nodes('entity') R ( ref )),0)
SET @mediaAgentId	=  ISNULL((SELECT  ref.value('@mediaAgentId', 'int') AS sc
							FROM    @xmlText.nodes('entity') R ( ref )),0)
SET @libraryId		=  ISNULL((SELECT  ref.value('@libraryId', 'int') AS sc
							FROM    @xmlText.nodes('entity') R ( ref )),0)
SET @storagePolicyId	=  ISNULL((SELECT  ref.value('@storagePolicyId', 'int') AS sc
							FROM    @xmlText.nodes('entity') R ( ref )),0)
SET @taskId			=  ISNULL((SELECT  ref.value('@taskId', 'int') AS sc
							FROM    @xmlText.nodes('entity/subtask') R ( ref )),0)
SET @userId		=  ISNULL((SELECT  ref.value('@userId', 'int') AS userId
							FROM    @xmlText.nodes('entity') R ( ref )),0)
IF @commcellId <> 0
BEGIN
SET @type1 = 2018;
	SET @id1 = @commcellId
END
IF @clientGroupId <> 0
BEGIN
SET @type1 = 2572;
	SET @id1 =  @clientGroupId
END
IF @clientId <> 0
BEGIN
SET @type1= 2009;
	SET @id1 = @clientId
END
IF  @mediaAgentId <> 0
BEGIN
SET @type1 = 2048;
	SET @id1 = @mediaAgentId
END
IF @libraryId <> 0
BEGIN
SET @type1 = 2049;
	SET @id1 = @libraryId
END
IF @storagePolicyId <> 0
BEGIN
SET @type1 = 2231;
	SET @id1 = @storagePolicyId
END
IF @taskId <> 0
BEGIN
SET @type1 = 4300;
	SET @id1 = @taskId
END
IF (@appTypeId<> 0) and (@appTypeId<> 103) and (@appTypeId<> 80)
BEGIN
SET @type2 = 2230;
	SET	@id2 = @appTypeId
	SET @hasApptype = 1
END
IF EXISTS (select * from APP_AppTypeGroupAssoc where appGroupId = 96 and appTypeId = @appTypeId)
	SET @instanceSupported = 1
IF EXISTS (select * from APP_AppTypeGroupAssoc where appGroupId = 97 and appTypeId = @appTypeId)
	SET @backupSetSupported = 1
IF (@instanceId <> 0) and (@instanceId <>1) and (@appTypeId<> 106)
and (@appTypeId<> 58) and (@instanceSupported =1)
BEGIN
	IF @hasApptype = 1
	BEGIN
SET @type3 = 2011
		SET	@id3 = @instanceId
	END
	ELSE
	BEGIN
SET @type2 = 2011
		SET	@id3 = @instanceId
	END
	SET @hasInstance = 1
END
IF @backupSetId <> 0
BEGIN
	IF (@hasInstance =1)
	BEGIN
SET @type4 = 2012
			SET @id4 = @backupSetId
	END
	ELSE
	BEGIN
SET @type3 = 2012;
			SET @id3 = @backupSetId
	END
END
IF @subclientId <> 0
BEGIN
SET	@type4=2013;
	SET @id4=@subclientID
END
create table #temp_ug (userGroupId int,
              userGroupName varchar(MAX))
create table #temp_owner (owner nvarchar(MAX))
create table #temp_user_group_owner (owner nvarchar(MAX))
IF dbo.isNewSecurity() = 0
BEGIN
    INSERT INTO #temp_ug
	SELECT UG.id,UG.name
	FROM UMGroupAssociation UGA,UMGroups UG
	where UGA.groupId = UG.id and
			UGA.type1 = @type1 and UGA.id1 = @id1 and
		  UGA.type2 = @type2 and UGA.id2 = @id2 and
		  UGA.type3 = @type3 and UGA.id3 = @id3 and
		  UGA.type4 = @type4 and UGA.id4 = @id4
END
ELSE
BEGIN
	DECLARE @entityType1 INT = 0
	DECLARE @entityId1 INT = @id1
	DECLARE @entityType2 INT = 0
	DECLARE @entityId2 INT = @id2
	DECLARE @entityType3 INT = 0
	DECLARE @entityId3 INT = @id3
	DECLARE @entityType4 INT = 0
	DECLARE @entityId4 INT = @id4
	DECLARE @entityType5 INT = 0
	DECLARE @entityId5 INT = 0
	SET @entityType1 = dbo.sec_ObjectTypeToEntitytype  (@type1)
	SET @entityType2 = dbo.sec_ObjectTypeToEntitytype  (@type2)
	SET @entityType3 = dbo.sec_ObjectTypeToEntitytype  (@type3)
	SET @entityType4 = dbo.sec_ObjectTypeToEntitytype  (@type4)
IF @entityType1 = 3
	BEGIN
		SELECT @entityId1 = clientId, @entityId2 = appTypeId, @entityId3 = instanceId, @entityId4 = backupsetId,
                   @entityId5 = subclientId
        FROM dbo.sec_convert4EntityTypeTo5EntityType(@type1, @type2, @type3, @type4, @id1, @id2, @id3, @id4)
SET @EntityType2 = CASE WHEN @appTypeId = 0 THEN 0 ELSE 4 END
SET @EntityType3 = CASE WHEN @instanceId = 0 THEN 0 ELSE 5 END
SET @EntityType4 = CASE WHEN @backupsetId = 0 THEN 0 ELSE 6 END
SET @EntityType5 = CASE WHEN @subclientId = 0 THEN 0 ELSE 7 END
	END
	INSERT INTO #temp_ug (userGroupId)
		SELECT UMSecurityAssociations.userOrGroupId
		FROM UMSecurityAssociations INNER JOIN (SELECT componentNameId AS userGroupId, CAST(attrVal AS INT) AS roleId
												FROM UMGroupsProp
WHERE attrName =  'SystemCreatedRole_' AND modified = 0) UG
		ON isUser = 0 AND userOrGroupId = UG.userGroupId
		WHERE entityType1 = @entityType1 AND entityId1 = @entityId1 AND
			  entityType2 = @entityType2 AND entityId2 = @entityId2 AND
			  entityType3 = @entityType3 AND entityId3 = @entityId3 AND
			  entityType4 = @entityType4 AND entityId4 = @entityId4 AND
			  entityType5 = @entityType5 AND entityId5 = @entityId5 AND
			  isCreator = 0 AND UMSecurityAssociations.roleId = UG.roleId
	UPDATE Tbl
	SET Tbl.userGroupName = Gp.name
	FROM #temp_ug Tbl INNER JOIN UMGroups Gp
	ON Tbl.userGroupId = Gp.id
END
IF NOT EXISTS(select userGroupName from #temp_ug where #temp_ug.userGroupId=dbo.GetMasterGroupID() or userGroupName ='View All')
BEGIN
INSERT INTO #temp_ug
SELECT UG.id,UG.name
FROM UMGroups UG
where id=dbo.GetMasterGroupID() or name = 'View All'
END
IF @type1 = 2009 AND @clientId <> 0
BEGIN
	INSERT INTO  #temp_owner
		SELECT U.login
		FROM UMUsers U
			 INNER JOIN UMOwners owner
				ON U.id = Owner.userOrGroupId
		WHERE
			owner.entityType = 3 AND owner.entityId = @clientId AND owner.isUser <> 0
	INSERT INTO  #temp_user_group_owner
		SELECT CASE WHEN G.umdsProviderId = 0 THEN G.name ELSE P.domainname + '\' + G.name END
		FROM UMGroups G
			 INNER JOIN UMowners owner
				ON G.id = owner.userOrGroupId
			 LEFT JOIN UMDSProviders P
				ON G.umdsProviderId = P.id
		WHERE
			owner.entityType = 3 AND owner.entityId = @clientID AND owner.isUser = 0
END
IF @type1 IN (2009 , 2572) AND @type2 = 0 AND @type3 = 0 AND @type4 = 0
		EXEC AppGetEntityCapabilityXML @type1,@id1,@ownercaps OUTPUT
IF EXISTS(SELECT 1 FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = @clientId AND attrName='AuthorizationType' AND attrVal = '2' AND modified = 0)
BEGIN
	SET @authType = 2  -- USE_PASSKEY (attrVal = '2')
	DECLARE @authUsers XML = ISNULL((SELECT cast(attrVal as xml) FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId
AND attrName='AuthorizedUsersForRestore' AND modified = 0),'')
	SET @expirationTimeStamp = ISNULL((select T.c.query('..').value('(/authorizedUsers/@expirationTime)[1]','integer') from @authUsers.nodes('/App_AuthorizedUsersForRestore/authorizedUsers/user') AS T(c)
	WHERE T.c.value('@userId','int') = @userId),0)
	IF @expirationTimeStamp > dbo.GetUnixTime(GETUTCDATE())
	BEGIN
		SET @enableAuthorizeForRestore = 1
	END
END
SET @xmlText = (select (select DISTINCT userGroupId as '@userGroupId',
				userGroupName as '@userGroupName',
				--USERGROUP_ENTITY = 15,
				'15' as '@_type_'
				FROM #temp_ug
				FOR XML PATH('associatedUserGroups'),TYPE),
		(select owner as '@val'
				FROM #temp_owner
				FOR XML PATH('clientOwners'),TYPE),
		(select owner as '@val'
				FROM #temp_user_group_owner
				FOR XML PATH('clientUserGroupOwners'),TYPE),
		(select @ownercaps
				FOR XML PATH('ownerCapabilities'),TYPE),
		(SELECT @authType AS '@authType',
					(SELECT @enableAuthorizeForRestore as '@enableAuthorizeForRestore',
					(SELECT @expirationTimeStamp as '@time'
						FOR XML PATH('expirationTime'), TYPE)
					FOR XML PATH('passkeySettings'), TYPE)
					FOR XML PATH('advancedPrivacySettings'),TYPE)
FOR XML PATH(''),TYPE)
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetEntitySecurityXML')
	delete from GxQscripts where name = 'APPGetEntitySecurityXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetEntitySecurityXML')
	delete from GXDBVersions where aliasname = 'APPGetEntitySecurityXML'
GO

insert into GXDBVersions values(2, 'APPGetEntitySecurityXML',  '00000000000000000000', 'APPGetEntitySecurityXML', '00000000000000000000')
GO

