

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetEntityNetworkThrottleXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  APPGetEntityNetworkThrottleXML
--  |
--  | Description:  Procedure to return all the Nw Throttle properties of an entity
--  |
--  |       Input:  XML Containing clientId/ClientGroupId
--  |
--  |      Output:  XML containing Nw Throttle  properties
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1       Shilpa Nagendra					Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetEntityNetworkThrottleXML <<<'

IF EXISTS (select * from sysobjects where name='APPGetEntityNetworkThrottleXML')
	drop procedure APPGetEntityNetworkThrottleXML
IF EXISTS (select * from GxQscripts where name='APPGetEntityNetworkThrottleXML')
	delete from GxQscripts where name = 'APPGetEntityNetworkThrottleXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetEntityNetworkThrottleXML')
	delete from GXDBVersions where aliasname = 'APPGetEntityNetworkThrottleXML'
GO
print '... Creating Procedure: APPGetEntityNetworkThrottleXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetEntityNetworkThrottleXML
  @entityInfo XML	OUTPUT
AS
DECLARE @inputXML XML
DECLARE @clientId INT
DECLARE @clientGroupId INT
DECLARE @nwThrottleOptions XML
DECLARE @nwSharedOptions nvarchar(2);
DECLARE @tempxml as xml
DECLARE @enableNw INTEGER=0
DECLARE @inheritedFromCG XML
SET @clientId = ISNULL((SELECT  ref.value('@clientId', 'INTEGER')
      FROM    @entityInfo.nodes('entity') R ( ref )),0)
SET @clientGroupId = ISNULL((SELECT  ref.value('@clientGroupId', 'INTEGER')
      FROM    @entityInfo.nodes('entity') R ( ref )),0)
SET @nwThrottleOptions = (select NetWorkThrottleOptions.query('/App_ThrottleScheduleOptionList/throttle') from APP_NetworkThrottleOptions
						 WHERE (@clientId <> 0 and clientId = @clientId)
						 OR (@clientGroupId <> 0 and clientGroupId = @clientGroupId))
SET @tempxml = (select NetWorkThrottleOptions from APP_NetworkThrottleOptions
						 WHERE (@clientId <> 0 and clientId = @clientId)
						 OR (@clientGroupId <> 0 and clientGroupId = @clientGroupId))
IF CAST (@nwThrottleOptions as varchar(max) ) = ''
BEGIN
	SET @nwThrottleOptions = (select NetWorkThrottleOptions.query('/EVGui_ThrottleScheduleOptionList/throttle') from APP_NetworkThrottleOptions
						 WHERE (@clientId <> 0 and clientId = @clientId)
						 OR (@clientGroupId <> 0 and clientGroupId = @clientGroupId))
	SET @nwSharedOptions = (select ref.value('@shareBandwidth','NVARCHAR(1)')
						from @tempxml.nodes('EVGui_ThrottleScheduleOptionList') R (ref) )
END
ELSE
BEGIN
	SET @nwSharedOptions = (select ref.value('@shareBandwidth','NVARCHAR(1)')
						from @tempxml.nodes('App_ThrottleScheduleOptionList') R (ref) )
END
IF @clientId <> 0
BEGIN
SET @enableNw = (select  attrVal
				from APP_ClientProp where attrName = 'Network Throttle Enabled'	and modified=0
				and componentNameId = @clientId)
SELECT @inheritedFromCG = (SELECT clientGroupName AS '@clientGroupName', clientGroupId as '@clientGroupId', 28 as '@_type_' FROM ClientParentCGFlags WHERE clientId = @clientId AND clientGroupFlag & 0x0800 <> 0 FOR XML PATH('inheritedFromClientGroup'), TYPE)
END
ELSE IF @clientGroupId <> 0
--CV_FLAG_NETWORK_THROTTLE_ENABLED
SET @enableNw = (select  (case flag & 0x0800
							when 0 then 0
							else 1
							end)
					from APP_ClientGroup where id = @clientGroupId)
SET @inputXML =
(SELECT
		(case @enableNw
							when 1 then 'true'
							else 'false'
							end)  as 'enableThrottle',
		(SELECT Nw.forClientId as '@clientId',
					   C.name as '@clientName'
			   FROM APP_NetworkThrottle Nw Join APP_Client C On Nw.forClientId = C.id
				   WHERE (@clientId <> 0 and Nw.clientId = @clientId)
				   OR (@clientGroupId <> 0 and Nw.clientGroupId = @clientGroupId)
			   AND Nw.forClientId <> 0
			   FOR XML PATH('clientList'),TYPE),
		(SELECT Nw.forClientGroupId as '@clientGroupId',
					   CG.name as '@clientGroupName'
			   FROM APP_NetworkThrottle Nw Join APP_ClientGroup CG On Nw.forClientGroupId = CG.id
			   WHERE (@clientId <> 0 and Nw.clientId = @clientId)
			   OR (@clientGroupId <> 0 and Nw.clientGroupId = @clientGroupId)
			   AND Nw.forClientGroupId <> 0
			   FOR XML PATH('clientGroupList'),TYPE),
		(SELECT @nwSharedOptions as '@shareBandwidth',
                  (SELECT @nwThrottleOptions)
                   for XML path('throttle'),TYPE),
		@inheritedFromCG
FOR XML PATH(''))
SET @entityInfo = @inputXML
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetEntityNetworkThrottleXML')
	delete from GxQscripts where name = 'APPGetEntityNetworkThrottleXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetEntityNetworkThrottleXML')
	delete from GXDBVersions where aliasname = 'APPGetEntityNetworkThrottleXML'
GO

insert into GXDBVersions values(2, 'APPGetEntityNetworkThrottleXML',  '00000000000000000000', 'APPGetEntityNetworkThrottleXML', '00000000000000000000')
GO

