

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetEntityFirewallXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  APPGetEntityFirewallXML
--  |
--  | Description:  Procedure to return all the Firewall properties of an entity
--  |
--  |       Input:  XML Containing clientId/ClientGroupId
--  |
--  |      Output:  XML containing firewall properties
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1       Shilpa Nagendra					Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetEntityFirewallXML')
BEGIN
	print '>>> Drop Stored Procedure: APPGetEntityFirewallXML <<<'
	drop procedure APPGetEntityFirewallXML
END
IF EXISTS (select * from GxQscripts where name='APPGetEntityFirewallXML')
	delete from GxQscripts where name = 'APPGetEntityFirewallXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetEntityFirewallXML')
	delete from GXDBVersions where aliasname = 'APPGetEntityFirewallXML'
GO
print '... Creating Procedure: APPGetEntityFirewallXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetEntityFirewallXML
  @i_userId int,
  @entityInfo XML	OUTPUT
AS
DECLARE @inputXML XML
DECLARE @clientId INT
DECLARE @clientGroupId INT
DECLARE @configureFirewallSettings INT=0
DECLARE @defaultFwOptions INT=0
DECLARE @isCSorMA INT=0
DECLARE @firewallOptions XML
DECLARE @trivialConfXML XML
DECLARE @reachMeVia XML
DECLARE @proxyXML XML
DECLARE @tppm XML
DECLARE @isTrivialConfig INT = 0
DECLARE @componentId integer
DECLARE @componentType integer
DECLARE @extendedPropXML nvarchar(MAX)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF @i_userId <> 0
BEGIN
SET @clientId = ISNULL((SELECT  ref.value('@clientId', 'INTEGER')
      FROM    @entityInfo.nodes('entity') R ( ref )),0)
SET @clientGroupId = ISNULL((SELECT  ref.value('@clientGroupId', 'INTEGER')
      FROM    @entityInfo.nodes('entity') R ( ref )),0)
SET @defaultFwOptions = (SELECT COUNT(*) FROM App_FirewallOptions F
WHERE (@clientId <> 0 and F.clientId = @clientId)
OR (@clientGroupId <> 0 and F.clientGroupId = @clientGroupId and (flag & 4 <> 4)))
SET @configureFirewallSettings = (SELECT ISNULL((SELECT T.isTrivialConfig
  FROM App_FWTrivialConfig T WHERE
										(@clientId <> 0 and clientId = @clientId ) or (@clientGroupId <> 0 and clientGroupId = @clientGroupId)),0))
SET @isCSorMA = ISNULL((select count(*)
						From APP_Platform Where clientId = 	@clientId And platformType IN (1,2) ),0)
IF (@clientId <> 0)
BEGIN
	SET @componentId=@clientId
	SET @componentType=3 --CV_COMPONENT_TYPE_CLIENT
END
ELSE
BEGIN
	SET @componentId=@clientGroupId
	SET @componentType=8 --CV_COMPONENT_TYPE_CLIENTGROUP
END
SET @reachMeVia = CONVERT(XML,REPLACE(ISNULL((SELECT stringVal FROM APP_ComponentProp WHERE componentType = @componentType AND componentId = @componentId AND propertyTypeId = 4000),'<App_ReachMeVia reachMeViaSelected="0"/>'),'App_ReachMeVia','reachMeVia'))
if @configureFirewallSettings = 0
begin
	if @isCSorMA = 0
	SET @isTrivialConfig = 1
	else
	SET @isTrivialConfig = 0
end
else if @configureFirewallSettings = 1
	SET @isTrivialConfig = 1
else if @configureFirewallSettings = 2
	SET @isTrivialConfig = 0
IF(@defaultFwOptions <> 0)
BEGIN
	SET @tppm = (select T.status as '@enable',
			T.tppmType as '@tppmType',
			T.fromPortNumber as 'proxyInformation/@portNumber',
			3 as 'proxyInformation/proxyEntity/@_type_',
			T.fromEntityId as 'proxyInformation/proxyEntity/@clientId',
			C.name as 'proxyInformation/proxyEntity/@clientName',
			C.displayName as 'proxyInformation/proxyEntity/@displayName'
			FROM APP_FirewallTPPM T INNER JOIN APP_Client C
			ON T.fromEntityId = C.id
			WHERE T.toEntityId = @clientId AND @clientGroupId = 0
			AND T.status <> 0
			--AND T.toPortNumber IN (8401,8080) AND T.status = 1
			FOR XML PATH('tppm'),TYPE)
	IF (@clientId <> 0)
		BEGIN
			SET @componentId=@clientId
			SET @componentType=3
			END
	ELSE
		BEGIN
			SET @componentId=@clientGroupId
			SET @componentType=8
		END
    --SET @extendedPropXML = (select stringval FROM APP_ComponentProp WHERE componentType=@componentType AND componentId=@componentId AND propertyTypeId=2101)
	SET @firewallOptions = (select isDMZ as '@isDMZ',
		    keepAliveSeconds as '@keepAliveSeconds',
			tunnelconnectionPort as '@tunnelconnectionPort',
			tunnelInitSeconds as '@tunnelInitSeconds',
			foreceSSL as '@foreceSSL',
			lockDown as '@lockdown',
			bindOpenPortsOnly as '@bindOpenPortsOnly',
			isRoamingClient as '@isRoamingClient',
			CONVERT(nvarchar(max),extendedProperties) as '@extendedProperties',
			@tppm
		    from App_FirewallOptions F
		    WHERE (@clientId <> 0 and F.clientId = @clientId)
OR (@clientGroupId <> 0 and F.clientGroupId = @clientGroupId and (flag & 4 <> 4))
		    FOR XML PATH('firewallOptions'),TYPE)
END
ELSE
BEGIN
	SET @tppm = (select ''
			FOR XML PATH('tppm'),TYPE)
	--SET @tppm = (select 0 as '@enable',
	--		0 as '@tppmType',
	--		0 as 'proxyInformation/@portNumber',
	--		3 as 'proxyInformation/proxyEntity/@_type_',
	--		0 as 'proxyInformation/proxyEntity/@clientId',
	--		0 as 'proxyInformation/proxyEntity/@clientName',
	--		0 as 'proxyInformation/proxyEntity/@displayName'
	--		FOR XML PATH('tppm'),TYPE)
	SET @extendedPropXML='<App_FirewallExtendedProperties configureAutomatically="1" defaultOutgoingProtocol="2" />'
	SET @firewallOptions = (select 'false' as '@isDMZ',
180 as '@keepAliveSeconds',
			(select (case @clientId
					when  0 then '8403'
					else  (select (cvdport+3) from App_Client where id = @clientId)
				 end)
			 )as '@tunnelconnectionPort',
			'30' as '@tunnelInitSeconds',
			'false' as '@foreceSSL',
			(case @clientId
			when 0 then 'true'
			else 'false'
			end)as '@lockdown',
			'false' as '@bindOpenPortsOnly',
			'false' as '@isRoamingClient',
			@extendedPropXML as '@extendedProperties',
			@tppm
		FOR XML PATH('firewallOptions'),TYPE)
END
IF  @configureFirewallSettings <> 0
BEGIN
	SET @inputXML =
	(SELECT
			  (SELECT	F.restrictionType as '@state',
						F.forClientId as 'entity/@clientId',
                        C.name as 'entity/@clientName',
                        C.displayName as 'entity/@displayName'
FROM APP_Firewall F JOIN APP_Client C on F.forClientId = C.id and (flag & 4 <> 4)
				   WHERE F.forClientId <> 0  AND
				   ( (@clientId <> 0 and F.clientId = @clientId)
					  OR (@clientGroupId <> 0 and F.clientGroupId = @clientGroupId) )
			   FOR XML PATH('restrictionTo'),TYPE),
			   (SELECT  F.restrictionType as '@state',
						F.forClientGroupId as 'entity/@clientGroupId',
					   CG.name as 'entity/@clientGroupName'
FROM APP_Firewall F JOIN APP_ClientGroup CG ON F.forClientGroupId = CG.id AND (F.flag & 4 <> 4)
			   WHERE F.forClientGroupId <> 0
					AND ((@clientId <> 0 and F.clientId = @clientId)
					OR (@clientGroupId <> 0 and F.clientGroupId = @clientGroupId))
			   FOR XML PATH('restrictionTo'),TYPE),
		   (SELECT
						 startPort as '@startPort',
						 endPort as '@endPort'
						 FROM APP_FWPortRange
						 WHERE (@clientId <> 0 and clientId = @clientId)
						 OR (@clientGroupId <> 0 and clientGroupId = @clientGroupId)
		   FOR XML PATH('portRange'),TYPE),
		   (SELECT F.forClientId as 'remoteEntity/@clientId',
						   C.name as 'remoteEntity/@clientName',
                           C.displayName as 'remoteEntity/@displayName',
						   --F.fwOutGoingRouteOptions.query('App_FireWallOutGoingRouteOptions/fireWallOutGoingRouteOptions') as 'fireWallOutGoingRouteOptions'
						   CONVERT(XML,REPLACE(CONVERT(NVARCHAR(MAX),F.fwOutGoingRouteOptions),'App_FireWallOutGoingRouteOptions','fireWallOutGoingRouteOptions'))
FROM App_FWOutGoingRoutes F Join APP_Client C on F.forClientId = C.id and (F.flag & 4 <> 4)
						  WHERE ((@clientId <> 0 and F.clientId = @clientId)
								 OR (@clientGroupId <> 0 and F.clientGroupId = @clientGroupId))
								AND F.forClientId <> 0
					 FOR XML PATH('firewallOutGoingRoutes'),TYPE),
		   (SELECT F.forClientGroupId as 'remoteEntity/@clientGroupId',
				   CG.name as 'remoteEntity/@clientGroupName',
				   --F.fwOutGoingRouteOptions.query('App_FireWallOutGoingRouteOptions/fireWallOutGoingRouteOptions') as 'fireWallOutGoingRouteOptions'
				   CONVERT(XML,REPLACE(CONVERT(NVARCHAR(MAX),F.fwOutGoingRouteOptions),'App_FireWallOutGoingRouteOptions','fireWallOutGoingRouteOptions'))
FROM App_FWOutGoingRoutes F Join APP_ClientGroup CG on  F.forClientGroupId = CG.id AND (F.flag & 4 <> 4)
				   WHERE ((@clientId <> 0 and F.clientId = @clientId)
				   OR (@clientGroupId <> 0 and F.clientGroupId = @clientGroupId))
				   AND F.forClientGroupId <> 0
		   FOR XML PATH('firewallOutGoingRoutes'),TYPE)
	FOR XML PATH(''))
END
ELSE
BEGIN
	-- Consider client group level settings, as well as all topologies (including Smart)
	SET @inputXML = ( SELECT  CG.name AS '@val'
						  FROM APP_ClientGroupAssoc CGA, APP_ClientGroup CG
						  WHERE @clientId <> 0
						  AND CGA.clientId = @clientId
						  AND CG.id = CGA.clientGroupId
						  AND CGA.clientGroupId IN ( SELECT clientGroupId
														FROM App_FWTrivialConfig
														WHERE clientId = 0
														AND isTrivialConfig <> 0
															UNION
															SELECT clientGroupId
															FROM App_FirewallOptions
															WHERE clientId = 0
															)
						FOR XML PATH('inheritedFromClientGroup'))
	IF EXISTS (SELECT * FROM App_FirewallOptions AFO
				INNER JOIN ( SELECT clientGroupId FROM APP_ClientGroupAssoc WHERE clientId = @clientId ) TEMP
				ON AFO.clientGroupId = TEMP.clientGroupId
				AND AFO.isDMZ = 1)
	BEGIN
		SET @firewallOptions.modify('
			replace value of (firewallOptions/@isDMZ)[1]
			with	1
			');
	END
	IF @inputXML IS NULL OR @inputXML.exist('*') = 0
	BEGIN
		-- Check if the client is part of any Smart Topology
		DECLARE @topologies TABLE (topologyId INTEGER, topologyName NVARCHAR(256))
		INSERT INTO @topologies
		EXEC AppGetClientSmartTopologies @clientId
		SET @inputXML = ( SELECT  topologyName AS '@val'
							FROM @topologies
						FOR XML PATH('inheritedFromSmartTopology'))
	END
END
-- Security checks.
BEGIN
	IF OBJECT_ID('tempdb.dbo.#clientProxyListTmp') IS NOT NULL
		DROP TABLE #clientProxyListTmp
	CREATE TABLE #clientProxyListTmp
	(
		clientId INT,
		appTypeId INT,
		instanceID INT,
		backupsetID INT,
		subclientID INT
	)
	EXEC sec_getIdaObjectsForUser @i_userId,3,2,0,'#clientProxyListTmp'						-- CLIENT_ENTITY, EV_MANAGE_APPLICATION
	IF OBJECT_ID('tempdb.dbo.#clientGroupProxyListTmp') IS NOT NULL
		DROP TABLE #clientGroupProxyListTmp
	CREATE TABLE #clientGroupProxyListTmp
	(
		clientGroupId INT PRIMARY KEY
	)
	EXEC sec_getNonIdaObjectsForThisUser @i_userId,28,2,'#clientGroupProxyListTmp'			-- CLIENT_GROUP_ENTITY, EV_MANAGE_APPLICATION
	SET @proxyXML = ( SELECT
				(SELECT distinct F.clientId as '@clientId',
				C.name as '@clientName',
				C.displayName as '@displayName'
				FROM App_FirewallOptions F
				INNER JOIN APP_Client C ON C.id = F.clientId
				INNER JOIN #clientProxyListTmp sec ON (sec.clientId = f.clientId)
				WHERE isDMZ =1
				FOR XML PATH('proxyEntities'),TYPE),
				(SELECT distinct F.clientGroupId as '@clientGroupId', --Client group cannot be a proxy, however leaving the code as is
				 CG.name as '@clientGroupName'
				   FROM App_FirewallOptions F
				   INNER JOIN APP_ClientGroup CG ON CG.id = F.clientGroupId
				   INNER JOIN #clientGroupProxyListTmp sec ON sec.clientGroupId = F.clientGroupId
					WHERE isDMZ =1
				   FOR XML PATH('proxyEntities'),TYPE)
				   FOR XML PATH(''),TYPE)
	DROP TABLE #clientProxyListTmp
	DROP TABLE #clientGroupProxyListTmp
END
if(@isTrivialConfig = 1 AND @configureFirewallSettings = 1 )
begin
	if @clientId = 0
	begin
		SET @trivialConfXML =  ( SELECT
					(SELECT    F.networkWithCS as 'firewallTrivialDetailsCS/@networkType',
													F.connectionWithCS as 'firewallTrivialDetailsCS/@connectionType',
						F.proxyClientIdCS as 'firewallTrivialDetailsCS/proxyEntity/@clientId',											C.name as 'firewallTrivialDetailsCS/proxyEntity/@clientName'
						FROM App_FWTrivialConfig F JOIN APP_Client C on F.proxyClientIdCS = C.id
						WHERE F.clientGroupId <> 0  AND
						(@clientGroupId <> 0 and F.clientGroupId = @clientGroupId)
						 FOR XML PATH(''),TYPE),
					(SELECT	F.networkWithMA as 'firewallTrivialDetailsMA/@networkType',
												F.connectionWithMA as 'firewallTrivialDetailsMA/@connectionType',
												F.proxyClientIdMA as 'firewallTrivialDetailsMA/proxyEntity/@clientId',											C.name as 'firewallTrivialDetailsMA/proxyEntity/@clientName'
						FROM App_FWTrivialConfig F JOIN APP_Client C on F.proxyClientIdMA = C.id			   						WHERE F.clientGroupId <> 0  AND
						(@clientGroupId <> 0 and F.clientGroupId = @clientGroupId)
						FOR XML PATH(''),TYPE)
					FOR XML PATH('fwTrivialConfig'),TYPE)
	end
	else
	begin
		SET  @trivialConfXML =   (SELECT
						( SELECT	F.networkWithCS as 'firewallTrivialDetailsCS/@networkType',
											F.connectionWithCS as 'firewallTrivialDetailsCS/@connectionType',
												F.proxyClientIdCS as 'firewallTrivialDetailsCS/proxyEntity/@clientId',
												C.name as 'firewallTrivialDetailsCS/proxyEntity/@clientName',
												C.displayName as 'firewallTrivialDetailsCS/proxyEntity/@displayName'
						FROM App_FWTrivialConfig F JOIN APP_Client C on F.proxyClientIdCS = C.id
						WHERE F.clientId <> 0  AND
						(@clientId <> 0 and F.clientId = @clientId)
						FOR XML PATH(''),TYPE),
						(SELECT	F.networkWithMA as 'firewallTrivialDetailsMA/@networkType',
						F.connectionWithMA as 'firewallTrivialDetailsMA/@connectionType',
												F.proxyClientIdMA as 'firewallTrivialDetailsMA/proxyEntity/@clientId',
												C.name as 'firewallTrivialDetailsMA/proxyEntity/@clientName',
												C.displayName as 'firewallTrivialDetailsMA/proxyEntity/@displayName'
						FROM App_FWTrivialConfig F JOIN APP_Client C on F.proxyClientIdMA = C.id
				   						WHERE F.clientId <> 0  AND
						(@clientId <> 0 and F.clientId = @clientId)
						FOR XML PATH(''),TYPE)
					FOR XML PATH('fwTrivialConfig'),TYPE)
	end
end
else
begin
	SET @trivialConfXML = ( SELECT
				( SELECT	1 as 'firewallTrivialDetailsCS/@networkType',
						1 as 'firewallTrivialDetailsCS/@connectionType',
						1 as 'firewallTrivialDetailsCS/proxyEntity/@clientId',
						'NO CLIENT' as 'firewallTrivialDetailsCS/proxyEntity/@clientName',
						'NO CLIENT' as 'firewallTrivialDetailsCS/proxyEntity/@displayName'
				   FOR XML PATH(''),TYPE),
				( SELECT	1 as 'firewallTrivialDetailsMA/@networkType',
						1 as 'firewallTrivialDetailsMA/@connectionType',
						1 as 'firewallTrivialDetailsMA/proxyEntity/@clientId',
						'NO CLIENT' as 'firewallTrivialDetailsMA/proxyEntity/@clientName',
						'NO CLIENT' as 'firewallTrivialDetailsMA/proxyEntity/@displayName'
				   FOR XML PATH(''),TYPE)
			FOR XML PATH('fwTrivialConfig'),TYPE)
end
SET @inputXML = (SELECT
					(case @configureFirewallSettings
					WHEN 0 THEN 'false'
					ELSE 'true'
					END) as 'configureFirewallSettings',
					(case @isTrivialConfig
					WHEN 0 THEN 'false'
					ELSE 'true'
					END) as 'isTrivialConfig',
					@firewallOptions,
					@inputXML,
					@proxyXML,
					@trivialConfXML,
					@reachMeVia
				FOR XML PATH('') )
END
SET @entityInfo = @inputXML
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetEntityFirewallXML')
	delete from GxQscripts where name = 'APPGetEntityFirewallXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetEntityFirewallXML')
	delete from GXDBVersions where aliasname = 'APPGetEntityFirewallXML'
GO

insert into GXDBVersions values(2, 'APPGetEntityFirewallXML',  '00000000000000000000', 'APPGetEntityFirewallXML', '00000000000000000000')
GO

