

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetEnabledVpnRouters.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--		This SP returns all clients and client groups which are enabled as VPN Routers.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetEnabledVpnRouters <<<'

IF EXISTS (select * from sysobjects where name='APPGetEnabledVpnRouters')
	drop procedure APPGetEnabledVpnRouters
IF EXISTS (select * from GxQscripts where name='APPGetEnabledVpnRouters')
	delete from GxQscripts where name = 'APPGetEnabledVpnRouters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetEnabledVpnRouters')
	delete from GXDBVersions where aliasname = 'APPGetEnabledVpnRouters'
GO
print '... Creating Procedure: APPGetEnabledVpnRouters'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetEnabledVpnRouters
AS
  DECLARE @o_entityId INT
  DECLARE @o_entityName nvarchar(255)
  DECLARE @o_entityDisplayName nvarchar(255)
  DECLARE @o_entityType tinyint-- 0 - client, 1 - client group
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE	@resultTbl				TABLE(id INT, name nvarchar(255), displayName nvarchar(255), type tinyint)
INSERT INTO @resultTbl
SELECT AC.id, AC.name, AC.displayName, 0
FROM APP_ClientProp as ACP
INNER JOIN APP_Client AC ON AC.id = ACP.componentNameId AND ACP.attrName='VPNEnableRouter' AND ACP.attrVal = 1
INSERT INTO @resultTbl
SELECT ACG.id, ACG.name, ACG.name, 1
FROM APP_ClientGroup ACG where (ACG.flag & 0x8000) = 0x8000
SELECT DISTINCT * from @resultTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetEnabledVpnRouters')
	delete from GxQscripts where name = 'APPGetEnabledVpnRouters'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetEnabledVpnRouters')
	delete from GXDBVersions where aliasname = 'APPGetEnabledVpnRouters'
GO

insert into GXDBVersions values(2, 'APPGetEnabledVpnRouters',  '00000000000000000000', 'APPGetEnabledVpnRouters', '00000000000000000000')
GO

