

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetDevicesList_Report.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetDevicesList_Report.sp,v $ $Id: APPGetDevicesList_Report.sp,v 1.1.2.5 2020/05/16 00:47:14 alakra Exp $";
--	+===================================================================+
--	| APPGetDevicesList_Report - Get Laptop Client list 					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetDevicesList_Report')
BEGIN
	print '>>> Drop Stored Procedure: APPGetDevicesList_Report <<<'
	drop procedure APPGetDevicesList_Report
END
IF EXISTS (select * from GxQscripts where name='APPGetDevicesList_Report')
	delete from GxQscripts where name = 'APPGetDevicesList_Report'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetDevicesList_Report')
	delete from GXDBVersions where aliasname = 'APPGetDevicesList_Report'
GO
print '... Creating Procedure: APPGetDevicesList_Report'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetDevicesList_Report
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @xmlString XML OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString VARCHAR(1024) OUTPUT
-----------------------------------------------------------
AS
  DECLARE @r_xmlString XML;
BEGIN
	SET NOCOUNT ON
	-- AEB:	ProdCS incurring high level of blocking waits on JM Tables.
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @function		VARCHAR(80) = 'APPGetDevicesList'
	SET @o_errCode = 0 -- BE OPTIMISTIC
	SET @o_errString = ''
	DECLARE @excludeStatusMask			INT = 48		--(cast(0x00010 AS INT) | cast(0x00020 AS INT))
	DECLARE @excludeStatusMaskForSync	INT = 54		--(cast(0x00002 AS INT) | cast(0x00004 AS INT) | cast(0x00010 AS INT) | cast(0x00020 AS INT))
	IF object_id('tempdb.dbo.#clientList') IS NOT NULL
		DROP TABLE #clientList
	CREATE TABLE #clientList (
		cId INT NOT NULL,
		clientName NVARCHAR(255) DEFAULT '',
		hostName NVARCHAR(255) DEFAULT '',
		appId INT DEFAULT 0,
		instId INT DEFAULT 0,
		bSet INT DEFAULT 0,
		subId INT DEFAULT 0,
		lastbkupTime INT DEFAULT 0,
		lastSuccessBkupTime INT DEFAULT 0,
		nextBkupTime INT DEFAULT 0,
		backupSize BIGINT DEFAULT 0,
		lastDataProtectedTime INT DEFAULT 0,
		capabilities BIGINT DEFAULT 0,
		totalbackupsize BIGINT DEFAULT 0,
		totalbackupSizeSubClient BIGINT DEFAULT 0,
		totalbackupSizeBackupset BIGINT DEFAULT 0,
		isOwner INT DEFAULT 1,
		flag INT DEFAULT 0,
		clientStatus INT DEFAULT 0,
		specialClientFlags INT DEFAULT 0,
		isUserCentricClient INT DEFAULT 0,
		physicalClientID INT DEFAULT 0,
		planId INT DEFAULT 0,
		planName NVARCHAR(255) DEFAULT '',
        activatedMode INT,
		isClientDeconfigured INT DEFAULT 2,
		taskId               INT,
		clientOwners            XML
		)
	CREATE UNIQUE CLUSTERED INDEX ClientList_cId_IDX ON #clientList (cId)
	BEGIN TRY
		-----------------------------------------------
		--- EXTRACT DATA FROM THE XML                              ---
		-----------------------------------------------
		DECLARE @userId		INT = 0
		SELECT @userId = ref.value('@userId', 'INT')
		FROM @xmlString.nodes('App_LapTopClientListReq/user') R(ref)
		DECLARE @clientListType		INT = 3 -- Unique Clients
		DECLARE @filterUserId		INT = 0
		DECLARE @filterProviderId   INT = -1
		SELECT
			@filterUserId = ISNULL(ref.value('@userId', 'INT'), 0)
		FROM @xmlString.nodes('App_LapTopClientListReq/filter/userFilter') R(ref)
		SELECT
			@clientListType = ISNULL(ref.value('@clientListType', 'INT'), 3)
		FROM @xmlString.nodes('App_LapTopClientListReq/filter') R(ref)
		SELECT @filterProviderId = ISNULL(ref.value('@providerId', 'INT'), -1)
			FROM @xmlString.nodes('App_LapTopClientListReq/filter/provider') R(ref)
	IF OBJECT_ID('tempdb.dbo.#appgetdeviceClientList') IS NOT NULL
			DROP TABLE #appgetdeviceClientList
		CREATE TABLE #appgetdeviceClientList (
			clientId INT PRIMARY KEY,
			t_appTypeId INT,
			t_instanceId INT,
			t_backupsetId INT,
			t_subclientId INT
			)
		CREATE INDEX appgetdeviceClientList_idx1 ON #appgetdeviceClientList (clientId)
		IF object_id('tempdb.dbo.#CompanyClients') IS NOT NULL
			DROP TABLE #CompanyClients
		CREATE TABLE #CompanyClients
		(
			clientId	INT
		)
		CREATE UNIQUE CLUSTERED INDEX CompanyClients_Idx ON #CompanyClients(clientId)
		EXEC sec_getIdaObjectsForUser @userId,
3,
			0 /*View*/,
			0,
			'#appgetdeviceClientList'
		IF @filterUserId <> 0
		BEGIN
			DELETE
			FROM #appgetdeviceClientList
			WHERE clientId NOT IN (
					SELECT DISTINCT clientId
					FROM sec_getClientOwnersExpandUG Owners
					WHERE Owners.userId = @filterUserId
					)
		END
		IF @filterProviderId <> -1
		BEGIN
		INSERT INTO #CompanyClients
			SELECT ACGA.clientId from APP_ClientGroupAssoc ACGA WITH(NOLOCK)
				INNER JOIN App_CompanyProp ACP WITH(NOLOCK) ON
ACP.attrValInt=ACGA.clientGroupId AND ACP.attrName='Associated Smart Client Group' AND ACP.componentNameId=@filterProviderId AND ACP.modified=0
		DELETE
		FROM #appgetdeviceClientList
		WHERE clientId NOT IN
					(SELECT clientId FROM #CompanyClients)
		END
		INSERT #clientList (
			Cid,
			clientName,
			hostname,
			clientStatus,
			specialClientFlags,
			appId,
			capabilities,
			planId,
			isUserCentricClient,
			physicalClientID,
			planName,
            activatedMode,
			isClientDeconfigured,
			bSet,
			flag,
			subId,
			instId,
			backupSize,
			totalbackupSizeSubClient,
			totalbackupSizeBackupset,
			lastDataProtectedTime
			)
		SELECT
			c.id,
			c.displayName,
			c.net_hostName,
			c.STATUS,
			c.specialClientFlags,
			AAP.appTypeId,
			0,
			ISNULL(CAST(pid.attrVal AS INT), 0),
			ISNULL(CAST(ucc.attrVal AS INT), 0),
			ISNULL(CAST(pcid.attrVal AS INT), 0),
			ISNULL(p.name, ''),
            ISNULL(acpact.attrVal,0),
			ISNULL(CAST(acpcs.attrVal AS INT), 2),
			ISNULL(AAP.backupSet, 0),
			ISNULL(AAP.subclientStatus, 0),
			ISNULL(AAP.id, 0),
			ISNULL(AAP.instance, 0),
			ISNULL(CAST(ASCP1.attrval AS BIGINT), 0),
			ISNULL(CAST(ASCP2.attrval AS BIGINT), 0),
			ISNULL(CAST(ABP.attrval AS BIGINT), 0),
			ISNULL(CAST(ASCP.attrval AS INT), 0)
		FROM #appgetdeviceClientList um
			INNER JOIN APP_Client c
				ON c.id = um.clientId
AND c.STATUS & 0x1000 = 0x1000
			LEFT OUTER JOIN APP_ClientProp pid ON
				pid.componentNameId = um.clientId
				AND pid.modified = 0
AND pid.attrName = 'Associated Plan'
				AND ISNUMERIC(pid.attrVal) = 1
			LEFT OUTER JOIN APP_ClientProp ucc ON
				ucc.componentNameId = um.clientId
				AND ucc.modified = 0
AND ucc.attrName = 'User Centric Client'
				AND ISNUMERIC(ucc.attrVal) = 1
			LEFT OUTER JOIN APP_ClientProp pcid ON
				pcid.componentNameId = um.clientId
				AND pcid.modified = 0
AND pcid.attrName = 'Physical Client Id'
				AND ISNUMERIC(pcid.attrVal) = 1
			LEFT OUTER JOIN APP_Plan p ON
				pid.attrVal IS NOT NULL
				AND p.id = CAST(pid.attrVal AS INT)
			LEFT OUTER JOIN APP_ClientProp acpact ON
				acpact.componentNameId = um.clientId
				AND acpact.modified = 0
AND acpact.attrName = 'Activated Mode'
				AND ISNUMERIC(acpact.attrVal) = 1
			LEFT OUTER JOIN APP_ClientProp acpcs ON
				acpcs.componentNameId = um.clientId
				AND acpcs.modified = 0
				AND acpcs.attrName = 'PlatformDeleted 4'
				AND ISNUMERIC(acpcs.attrVal) = 1
			INNER JOIN APP_Application AAP
ON (AAP.subClientStatus & 0x00008) = 0x00008 AND AAP.clientId=um.clientId AND AAP.subclientStatus & @excludeStatusMask = 0
			INNER JOIN APP_BackupSetName BS
ON BS.id=AAP.backupSet AND (BS.STATUS & 0x00008) = 0x00008
			INNER JOIN APP_AppTypeGroupAssoc ATGA
				ON AAP.appTypeId=ATGA.appTypeId AND ATGA.appGroupId=35 AND ATGA.typeOfGroup=0
			LEFT OUTER JOIN APP_SubClientProp ASCP
				ON ASCP.componentNameId=AAP.id AND ASCP.attrname='Last Data Protected Time' AND ASCP.modified=0 AND ASCP.cs_attrName = CHECKSUM(N'Last Data Protected Time')
			LEFT OUTER JOIN APP_SubClientProp ASCP1
				ON ASCP1.componentNameId=AAP.id AND ASCP1.attrname='Last Backup Size' AND ASCP1.modified=0 AND ASCP1.cs_attrName = CHECKSUM(N'Last Backup Size')
			LEFT OUTER JOIN APP_SubClientProp ASCP2
				ON ASCP2.componentNameId=AAP.id AND ASCP2.attrname='Application Size' AND ASCP2.modified=0 AND ASCP2.cs_attrName = CHECKSUM(N'Application Size')
			LEFT OUTER JOIN APP_BackupSetProp ABP
				ON ABP.componentNameId=AAP.backupSet AND ABP.attrname='Application Size' AND ABP.modified=0
		WHERE
(c.status & 0x10000000) = 0 -- make sure it is not an edge clients
		IF @clientListType = 1 -- User Only Want Physical Client  - App.x - enum ClientListType
		BEGIN
			DELETE #clientList
			WHERE isUserCentricClient <> 0 -- Physical client don't have UserCentric Client Value Set in App_clientProp
		END
		ELSE IF @clientListType = 2 -- User Only Want User Centric Client  - App.x - enum ClientListType
		BEGIN
			DELETE #clientList
			WHERE isUserCentricClient = 0 -- User Centric client have UserCentric Client Value Set in App_clientProp
		END
		ELSE IF @clientListType = 3 -- Only Unique Client - Remove all clientId which are present as Physical Client Id's in user centric client
		BEGIN
			DELETE #clientList
			WHERE cId IN (
					SELECT cl.physicalClientID
					FROM #clientList cl
					WHERE cl.isUserCentricClient <> 0
					) -- Delete all physical clients for which there is atleaset 1 user centric client
		END
		-- Get Total backup size from subclient and backupset
		UPDATE #clientList SET totalbackupsize=totalbackupSizeSubClient + totalbackupSizeBackupset
		WHERE lastDataProtectedTime > 0
		UPDATE cl
            SET cl.nextBkupTime=-1, cl.taskId=t.taskId
            FROM #clientList cl
            INNER JOIN TM_AssocEntity ae ON
                            --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
                            (ae.subclientId = cl.subId)
                            OR (ae.clientId = cl.cId AND ae.apptypeId = cl.appId AND ae.instanceId = cl.instId  AND ae.backupsetId = cl.bSet AND ae.subclientId = 0)
                            OR (ae.clientId = cl.cId AND ae.apptypeId = cl.appId AND ae.instanceId = cl.instId AND ae.backupsetId = 0 AND ae.subclientId = 0)
                            OR (ae.clientId = cl.cId AND ae.apptypeId = cl.appId AND ae.instanceId = 0 AND ae.backupsetId = 0 AND ae.subclientId = 0)
                            OR (ae.clientId = cl.cId AND ae.apptypeId = 0 AND ae.instanceId = 0 AND ae.backupsetId = 0 AND ae.subclientId = 0)
                            OR (ae.clientGroupId in (select clientGroupId FROM APP_ClientGroupAssoc WHERE clientId = cl.cId) and ae.clientId = 0 AND ae.apptypeId = 0 AND ae.instanceId = 0 AND ae.backupsetId = 0 AND ae.subclientId = 0)
            INNER JOIN TM_Task t ON
                            t.taskId = ae.taskId AND t.disabled = 0 AND t.deleted = 0
            INNER JOIN TM_SubTask st ON
                            ae.taskId = st.taskId
            INNER JOIN TM_SubTaskOptions sto ON
                            sto.subTaskId = st.subTaskId
                            AND sto.optionId = 458405394 -- BACKUPOPTION_BACKUP_LEVEL
                            AND sto.value IN (1, 2) --BACKUP_LEVEL_FULL, BACKUP_LEVEL_INCREMENTAL
            INNER JOIN TM_PatternAssoc pa ON
                            pa.subTaskId = st.subTaskId
            JOIN TM_Pattern p ON
                            p.patternId = pa.patternId
AND ((p.freq_type = 1024) OR (p.freq_type = 4096))
		UPDATE cl
            SET cl.nextBkupTime=0
        FROM #clientList cl
			INNER JOIN TM_AssocEntity TE WITH(NOLOCK)
				ON TE.taskId = cl.taskId AND TE.exclude = 1
					AND TE.clientId = cl.cId
					AND (TE.apptypeId = cl.appId OR TE.apptypeId = 0)
					AND (TE.instanceId = cl.instId OR TE.instanceId = 0)
					AND (TE.backupsetId = cl.bSet OR TE.backupsetId = 0)
					AND (TE.subclientId = cl.subId OR TE.subclientId = 0)
		WHERE cl.taskId>0
		IF OBJECT_ID('tempdb.dbo.#usersAndGroupsVisible ') IS NOT NULL
			DROP TABLE #usersAndGroupsVisible
		CREATE TABLE #usersAndGroupsVisible (
			userOrGroupId INT,
			isUser INT,
			userLogin NVARCHAR(255),
			userName NVARCHAR(255),
			email NVARCHAR(255),
			groupName NVARCHAR(255),
			PRIMARY KEY (
				userOrGroupId,
				isUser
				)
			)
		IF OBJECT_ID('tempdb.dbo.#VisibleUsersAndUserGroups') IS NOT NULL
			DROP TABLE #VisibleUsersAndUserGroups
		CREATE TABLE #VisibleUsersAndUserGroups (userOrGroupId INT)
		EXEC sec_getUsersForThisUser '#VisibleUsersAndUserGroups',
			@userId
		INSERT INTO #usersAndGroupsVisible
		SELECT userOrGroupId, 1, UU.login, UU.name, UU.email, ''
			FROM #VisibleUsersAndUserGroups VU
		INNER JOIN UMUsers UU
			ON VU.userOrGroupId = UU.id
		TRUNCATE TABLE #VisibleUsersAndUserGroups
		EXEC sec_getUserGroupsForThisUser '#VisibleUsersAndUserGroups',
			@userId
		INSERT INTO #usersAndGroupsVisible
		SELECT userOrGroupId, 0, '', '', '', UG.name
			FROM #VisibleUsersAndUserGroups VG
		INNER JOIN UMGroups UG
			ON VG.userOrGroupId = UG.id
		DROP TABLE #VisibleUsersAndUserGroups
		UPDATE CL
			SET CL.clientOwners = (
				SELECT CASE
						WHEN UGV.isUSER = 1
							THEN UGV.userOrGroupId
						END AS '@userId',
					CASE
						WHEN UGV.isUser = 0
							THEN UGV.userOrGroupId
						END AS '@userGroupId',
					CASE
						WHEN UGV.isUSER = 1
							THEN UGV.userLogin
						END AS '@userName',
					CASE
						WHEN UGV.isUSER = 1
							THEN UGV.userName
						END AS '@name',
					CASE
						WHEN UGV.isUSER = 1
							THEN UGV.email
						END AS '@userEmail',
					CASE
						WHEN UGV.isUser = 0
							THEN UGV.groupName
						END AS '@userGroupName',
					CASE
						WHEN UGV.isUSER = 1
							THEN 13
						ELSE 15
						END AS '@_type_'
				FROM UMOwners UMO
				INNER JOIN #usersAndGroupsVisible UGV
					ON UGV.userOrGroupId = UMO.userOrGroupId AND UGV.isUser=UMO.isUser
				WHERE UMO.entityId=CL.cId AND UMO.entityType=3
				FOR XML PATH('owners'),
					TYPE
				)
		FROM #clientList CL
	IF OBJECT_ID('tempdb.dbo.#usersAndGroupsVisible ') IS NOT NULL
			DROP TABLE #usersAndGroupsVisible
	SELECT * FROM #clientList
	END TRY
	----=====================================================================
	----==============  COME HERE IF THERE WAS A PROBLEM!     ===============
	----=====================================================================
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_errCode    = ERROR_NUMBER()
		SET @o_errString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
		SET @xmlString = ( SELECT
					( SELECT @o_errCode '@errorCode', @o_errString '@errorMessage'
						  FOR XML PATH('error'), TYPE
					)
		FOR XML PATH(''),
		ROOT('App_LapTopClientLstResp'))
	END CATCH
	--SELECT @xmlString
	-- drop temp table
	IF object_id('tempdb.dbo.#clientList') IS NOT NULL
		DROP TABLE #clientList
END
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetDevicesList_Report')
	delete from GxQscripts where name = 'APPGetDevicesList_Report'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetDevicesList_Report')
	delete from GXDBVersions where aliasname = 'APPGetDevicesList_Report'
GO

insert into GXDBVersions values(2, 'APPGetDevicesList_Report',  '00010001000200050000', 'APPGetDevicesList_Report', '00010001000200050000')
GO

