

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetDevicesList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetDevicesList.sp,v $ $Id: APPGetDevicesList.sp,v 1.1.2.23 2020/12/16 18:07:13 alakra Exp $";
--	+===================================================================+
--	| APPGetDevicesList - Get Laptop Client list 					|
--	+===================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPGetDevicesList')
BEGIN
	print '>>> Drop Stored Procedure: APPGetDevicesList <<<'
	drop procedure APPGetDevicesList
END
IF EXISTS (select * from GxQscripts where name='APPGetDevicesList')
	delete from GxQscripts where name = 'APPGetDevicesList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetDevicesList')
	delete from GXDBVersions where aliasname = 'APPGetDevicesList'
GO
print '... Creating Procedure: APPGetDevicesList'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPGetDevicesList
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @xmlString XML OUTPUT,
  @o_xmlResp NVARCHAR(MAX) OUTPUT,
  @o_errCode INTEGER OUTPUT,
  @o_errString VARCHAR(1024) OUTPUT
-----------------------------------------------------------
AS
  DECLARE @r_xmlString XML;
BEGIN
	SET NOCOUNT ON
	-- AEB:	ProdCS incurring high level of blocking waits on JM Tables.
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @function		VARCHAR(80) = 'APPGetDevicesList'
	SET @o_errCode = 0 -- BE OPTIMISTIC
	SET @o_errString = ''
	DECLARE @excludeStatusMask			INT = 48		--(cast(0x00010 AS INT) | cast(0x00020 AS INT))
	DECLARE @excludeStatusMaskForSync	INT = 54		--(cast(0x00002 AS INT) | cast(0x00004 AS INT) | cast(0x00010 AS INT) | cast(0x00020 AS INT))
	IF object_id('tempdb.dbo.#clientList') IS NOT NULL
		DROP TABLE #clientList
	CREATE TABLE #clientList (
		cId INT NOT NULL,
		clientName NVARCHAR(255) DEFAULT '',
		hostName NVARCHAR(255) DEFAULT '',
		appId INT DEFAULT 0,
		instId INT DEFAULT 0,
		bSet INT DEFAULT 0,
		subId INT DEFAULT 0,
		lastbkupTime INT DEFAULT 0,
		lastSuccessBkupTime INT DEFAULT 0,
		nextBkupTime INT DEFAULT 0,
		backupSize BIGINT DEFAULT 0,
		lastDataProtectedTime INT DEFAULT 0,
		capabilities BIGINT DEFAULT 0,
		totalbackupsize BIGINT DEFAULT 0,
		totalbackupSizeSubClient BIGINT DEFAULT 0,
		totalbackupSizeBackupset BIGINT DEFAULT 0,
		isOwner INT DEFAULT 1,
		flag INT DEFAULT 0,
		clientStatus INT DEFAULT 0,
		specialClientFlags INT DEFAULT 0,
		isUserCentricClient INT DEFAULT 0,
		physicalClientID INT DEFAULT 0,
		planId INT DEFAULT 0,
		planName NVARCHAR(255) DEFAULT '',
        activatedMode INT,
		isClientDeconfigured INT DEFAULT 2,
		taskId               INT,
		clientOwners            XML,
		bShowActivateOption int DEFAULT 0,
		lastBackupJobInfo XML,
		SLAStatus INT DEFAULT(3), --
		SLACategory INT DEFAULT(0),
		SLACategoryDescription  NVARCHAR(255) DEFAULT '',
		slaMissReasonList XML,
		nwReadiness INT DEFAULT(0),
		nwReadinessUpdatedTime  BIGINT DEFAULT(null),
		lastOnlineTime  BIGINT DEFAULT(null),
		lastOfflineTime BIGINT DEFAULT(null),
		retireClientPhase INT DEFAULT(0)
		)
	CREATE UNIQUE CLUSTERED INDEX ClientList_cId_IDX ON #clientList (cId)
	--Get the list of specific device Ids provided in XML input
	DECLARE @tempLaptopIdList TABLE(
		clientId      int
	);
	insert into @tempLaptopIdList
	SELECT ref.value('@clientId', 'int') AS client
	FROM    @xmlString.nodes('App_LapTopClientListReq/laptops') R ( ref )
	WHERE	ISNULL(ref.value('@clientId', 'int'), 0) > 0
	UNION
	SELECT  ref.value('@clientId', 'int') AS client
	FROM    @xmlString.nodes('App_LapTopClientListReq/client') R ( ref )
	WHERE	ISNULL(ref.value('@clientId', 'int'), 0) > 0
	BEGIN TRY
		-----------------------------------------------
		--- EXTRACT DATA FROM THE XML                              ---
		-----------------------------------------------
		DECLARE @userId		INT = 0
		SELECT @userId = ref.value('@userId', 'INT')
		FROM @xmlString.nodes('App_LapTopClientListReq/user') R(ref)
		DECLARE @clientListType		INT = 3 -- Unique Clients
		DECLARE @filterUserId		INT = 0
		DECLARE @filterProviderId   INT = -1
		DECLARE @localeId INTEGER = 0
		SELECT
			@localeId = ISNULL(ref.value('@localeId', 'INT'), 0)
		FROM @xmlString.nodes('App_LapTopClientListReq/locale') R(ref)
		SELECT
			@filterUserId = ISNULL(ref.value('@userId', 'INT'), 0)
		FROM @xmlString.nodes('App_LapTopClientListReq/filter/userFilter') R(ref)
		SELECT
			@clientListType = ISNULL(ref.value('@clientListType', 'INT'), 3)
		FROM @xmlString.nodes('App_LapTopClientListReq/filter') R(ref)
		SELECT @filterProviderId = ISNULL(ref.value('@providerId', 'INT'), -1)
			FROM @xmlString.nodes('App_LapTopClientListReq/filter/provider') R(ref)
	IF OBJECT_ID('tempdb.dbo.#appgetdeviceClientList') IS NOT NULL
			DROP TABLE #appgetdeviceClientList
		CREATE TABLE #appgetdeviceClientList (
			clientId INT PRIMARY KEY,
			t_appTypeId INT,
			t_instanceId INT,
			t_backupsetId INT,
			t_subclientId INT
			)
		CREATE INDEX appgetdeviceClientList_idx1 ON #appgetdeviceClientList (clientId)
		IF object_id('tempdb.dbo.#CompanyClients') IS NOT NULL
			DROP TABLE #CompanyClients
		CREATE TABLE #CompanyClients
		(
			clientId	INT
		)
		CREATE UNIQUE CLUSTERED INDEX CompanyClients_Idx ON #CompanyClients(clientId)
		--If the caller provided individual clients, retain only those that are laptops.
		IF EXISTS (SELECT TOP 1 1 FROM @tempLaptopIdList)
		BEGIN
		    --Delete all clients which are not laptops
		    DELETE TM
		    FROM @tempLaptopIdList TM LEFT OUTER JOIN APP_Client AC WITH (NOLOCK)
ON AC.id = TM.clientId AND AC.STATUS & 0x1000 = 0x1000
		    WHERE AC.ID IS NULL
		    --If none of the client Ids provided by caller are laptops, exit immediately
		    IF NOT EXISTS (SELECT TOP 1 1 FROM @tempLaptopIdList)
		    BEGIN
		        GOTO ERROR_EXIT
		    END
		END
		--At this point, the only clients (if any) in @tempLaptopIdList would be laptops
DECLARE @isAdminUserId INT = ISNULL((SELECT 1 FROM UMUsers WHERE (id=@userId) AND (flags & 0x040 <> 0)) , 0)
		IF(@isAdminUserId = 0)      --NON-ADMIN user
		BEGIN
		    --If calling user is NOT ADMIN user, firstly get clients from security check stored proc on which user has VIEW capability
EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 1, '#appgetdeviceClientList'
		    --If the caller explictely provided clientIds, only retain those that were provided in the list
		    IF EXISTS (SELECT TOP 1 1 FROM @tempLaptopIdList)
		    BEGIN
		        delete CL
		        from #appgetdeviceClientList CL left outer join @tempLaptopIdList LT on CL.clientId = LT.clientId
		        where LT.clientId is null
		    END
		END
		ELSE            --ADMIN USER
		BEGIN
		    --If the caller explictely provided clientIds, blindly insert those into #appgetdeviceClientList as its admin user
		    IF EXISTS (SELECT TOP 1 1 FROM @tempLaptopIdList)
		    BEGIN
		        insert into #appgetdeviceClientList
		        select distinct LAP.clientId, 0, 0, 0, 0
		        from @tempLaptopIdList LAP INNER JOIN APP_Client AC on LAP.clientId = AC.id
where AC.STATUS & 0x1000 = 0x1000
		    END
		    ELSE
		    BEGIN
		        --Get all clients on which user has view all capability
EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 1, '#appgetdeviceClientList'
		    END
		END
		IF @filterUserId <> 0
		BEGIN
			DELETE
			FROM #appgetdeviceClientList
			WHERE clientId NOT IN (
					SELECT DISTINCT clientId
					FROM sec_getClientOwnersExpandUG Owners
					WHERE Owners.userId = @filterUserId
					)
		END
		IF @filterProviderId <> -1
		BEGIN
		INSERT INTO #CompanyClients
			SELECT ACGA.clientId from APP_ClientGroupAssoc ACGA WITH(NOLOCK)
				INNER JOIN App_CompanyProp ACP WITH(NOLOCK) ON
ACP.attrValInt=ACGA.clientGroupId AND ACP.attrName='Associated Smart Client Group' AND ACP.componentNameId=@filterProviderId AND ACP.modified=0
			DELETE
		FROM #appgetdeviceClientList
		WHERE clientId NOT IN
					(SELECT clientId FROM #CompanyClients)
		END
		IF object_id('tempdb.dbo.#RetireInProgressClientListTbl') IS NOT NULL
			DROP TABLE #RetireInProgressClientListTbl
		CREATE TABLE #RetireInProgressClientListTbl(retireClientId INT)
		--List of clients which are currently getting uninstalled. Shouldn't be a huge table
		INSERT INTO #RetireInProgressClientListTbl
		SELECT DISTINCT JUPDATE.clientId FROM JMQinetixUpdateStatus JUPDATE WITH (NOLOCK)
			INNER JOIN JMAdminJobInfoTable JINFO WITH (NOLOCK) ON JINFO.jobId = JUPDATE.jobId AND JUPDATE.commCellId = JINFO.commCellId
				AND JINFO.opType = 68 -- UNINSTALLCLIENT (JobManager.x)
				AND JINFO.commCellId = 2 /* DEFAULT_COMMCELL_ID */
		INSERT #clientList (
			Cid,
			clientName,
			hostname,
			clientStatus,
			specialClientFlags,
			appId,
			capabilities,
			planId,
			isUserCentricClient,
			physicalClientID,
			planName,
            activatedMode,
			isClientDeconfigured,
			bSet,
			flag,
			subId,
			instId,
			backupSize,
			totalbackupSizeSubClient,
			totalbackupSizeBackupset,
			lastDataProtectedTime
			)
		SELECT
			c.id,
			c.displayName,
			c.net_hostName,
			c.STATUS,
			c.specialClientFlags,
			AAP.appTypeId,
			0,
			ISNULL(CAST(pid.attrVal AS INT), 0),
			ISNULL(CAST(ucc.attrVal AS INT), 0),
			ISNULL(CAST(pcid.attrVal AS INT), 0),
			ISNULL(p.name, ''),
            ISNULL(acpact.attrVal,0),
			ISNULL(CAST(acpcs.attrVal AS INT), 2),
			ISNULL(AAP.backupSet, 0),
			ISNULL(AAP.subclientStatus, 0),
			ISNULL(AAP.id, 0),
			ISNULL(AAP.instance, 0),
			ISNULL(CAST(ASCP1.attrval AS BIGINT), 0),
			ISNULL(CAST(ASCP2.attrval AS BIGINT), 0),
			ISNULL(CAST(ABP.attrval AS BIGINT), 0),
			ISNULL(CAST(ASCP.attrval AS INT), 0)
		FROM #appgetdeviceClientList um
			INNER JOIN APP_Client c
				ON c.id = um.clientId
AND c.STATUS & 0x1000 = 0x1000
			LEFT OUTER JOIN APP_ClientProp pid ON
				pid.componentNameId = um.clientId
				AND pid.modified = 0
AND pid.attrName = 'Associated Plan'
				AND ISNUMERIC(pid.attrVal) = 1
			LEFT OUTER JOIN APP_ClientProp ucc ON
				ucc.componentNameId = um.clientId
				AND ucc.modified = 0
AND ucc.attrName = 'User Centric Client'
				AND ISNUMERIC(ucc.attrVal) = 1
			LEFT OUTER JOIN APP_ClientProp pcid ON
				pcid.componentNameId = um.clientId
				AND pcid.modified = 0
AND pcid.attrName = 'Physical Client Id'
				AND ISNUMERIC(pcid.attrVal) = 1
			LEFT OUTER JOIN APP_Plan p ON
				pid.attrVal IS NOT NULL
				AND p.id = CAST(pid.attrVal AS INT)
			LEFT OUTER JOIN APP_ClientProp acpact ON
				acpact.componentNameId = um.clientId
				AND acpact.modified = 0
AND acpact.attrName = 'Activated Mode'
				AND ISNUMERIC(acpact.attrVal) = 1
			LEFT OUTER JOIN APP_ClientProp acpcs ON
				acpcs.componentNameId = um.clientId
				AND acpcs.modified = 0
				AND acpcs.attrName = 'PlatformDeleted 4'
				AND ISNUMERIC(acpcs.attrVal) = 1
			INNER JOIN APP_Application AAP
ON (AAP.subClientStatus & 0x00008) = 0x00008 AND AAP.clientId=um.clientId AND AAP.subclientStatus & @excludeStatusMask = 0
			INNER JOIN APP_BackupSetName BS
ON BS.id=AAP.backupSet AND (BS.STATUS & 0x00008) = 0x00008
			INNER JOIN APP_AppTypeGroupAssoc ATGA
				ON AAP.appTypeId=ATGA.appTypeId AND ATGA.appGroupId=35 AND ATGA.typeOfGroup=0
			LEFT OUTER JOIN APP_SubClientProp ASCP
				ON ASCP.componentNameId=AAP.id AND ASCP.attrname='Last Data Protected Time' AND ASCP.modified=0 AND ASCP.cs_attrName = CHECKSUM(N'Last Data Protected Time')
			LEFT OUTER JOIN APP_SubClientProp ASCP1
				ON ASCP1.componentNameId=AAP.id AND ASCP1.attrname='Last Backup Size' AND ASCP1.modified=0 AND ASCP1.cs_attrName = CHECKSUM(N'Last Backup Size')
			LEFT OUTER JOIN APP_SubClientProp ASCP2
				ON ASCP2.componentNameId=AAP.id AND ASCP2.attrname='Application Size' AND ASCP2.modified=0 AND ASCP2.cs_attrName = CHECKSUM(N'Application Size')
			LEFT OUTER JOIN APP_BackupSetProp ABP
				ON ABP.componentNameId=AAP.backupSet AND ABP.attrname='Application Size' AND ABP.modified=0
		WHERE
(c.status & 0x10000000) = 0 -- make sure it is not an edge clients
		IF @clientListType = 1 -- User Only Want Physical Client  - App.x - enum ClientListType
		BEGIN
			DELETE #clientList
			WHERE isUserCentricClient <> 0 -- Physical client don't have UserCentric Client Value Set in App_clientProp
		END
		ELSE IF @clientListType = 2 -- User Only Want User Centric Client  - App.x - enum ClientListType
		BEGIN
			DELETE #clientList
			WHERE isUserCentricClient = 0 -- User Centric client have UserCentric Client Value Set in App_clientProp
		END
		ELSE IF @clientListType = 3 -- Only Unique Client - Remove all clientId which are present as Physical Client Id's in user centric client
		BEGIN
			DELETE #clientList
			WHERE cId IN (
					SELECT cl.physicalClientID
					FROM #clientList cl
					WHERE cl.isUserCentricClient <> 0
					) -- Delete all physical clients for which there is atleaset 1 user centric client
		END
		-- Get Total backup size from subclient and backupset
		UPDATE #clientList SET totalbackupsize=totalbackupSizeSubClient + totalbackupSizeBackupset
		WHERE lastDataProtectedTime > 0
		UPDATE cl
            SET cl.nextBkupTime=-1, cl.taskId=t.taskId
			FROM #clientList cl
				INNER JOIN TM_AssocEntity ae ON
                            --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
                            (ae.subclientId = cl.subId)
                            OR (ae.clientId = cl.cId AND ae.apptypeId = cl.appId AND ae.instanceId = cl.instId  AND ae.backupsetId = cl.bSet AND ae.subclientId = 0)
                            OR (ae.clientId = cl.cId AND ae.apptypeId = cl.appId AND ae.instanceId = cl.instId AND ae.backupsetId = 0 AND ae.subclientId = 0)
                            OR (ae.clientId = cl.cId AND ae.apptypeId = cl.appId AND ae.instanceId = 0 AND ae.backupsetId = 0 AND ae.subclientId = 0)
                            OR (ae.clientId = cl.cId AND ae.apptypeId = 0 AND ae.instanceId = 0 AND ae.backupsetId = 0 AND ae.subclientId = 0)
                            OR (ae.clientGroupId in (select clientGroupId FROM APP_ClientGroupAssoc WHERE clientId = cl.cId) and ae.clientId = 0 AND ae.apptypeId = 0 AND ae.instanceId = 0 AND ae.backupsetId = 0 AND ae.subclientId = 0)
            INNER JOIN TM_Task t ON
                            t.taskId = ae.taskId AND t.disabled = 0 AND t.deleted = 0
            INNER JOIN TM_SubTask st ON
                            ae.taskId = st.taskId
            INNER JOIN TM_SubTaskOptions sto ON
                            sto.subTaskId = st.subTaskId
                            AND sto.optionId = 458405394 -- BACKUPOPTION_BACKUP_LEVEL
                            AND sto.value IN (1, 2) --BACKUP_LEVEL_FULL, BACKUP_LEVEL_INCREMENTAL
            INNER JOIN TM_PatternAssoc pa ON
                            pa.subTaskId = st.subTaskId
            JOIN TM_Pattern p ON
                            p.patternId = pa.patternId
AND ((p.freq_type = 1024) OR (p.freq_type = 4096))
		UPDATE cl
            SET cl.nextBkupTime=0
			FROM #clientList cl
			INNER JOIN TM_AssocEntity TE WITH(NOLOCK)
				ON TE.taskId = cl.taskId AND TE.exclude = 1
					AND TE.clientId = cl.cId
					AND (TE.apptypeId = cl.appId OR TE.apptypeId = 0)
					AND (TE.instanceId = cl.instId OR TE.instanceId = 0)
					AND (TE.backupsetId = cl.bSet OR TE.backupsetId = 0)
					AND (TE.subclientId = cl.subId OR TE.subclientId = 0)
		WHERE cl.taskId>0
		IF OBJECT_ID('tempdb.dbo.#usersAndGroupsVisible ') IS NOT NULL
			DROP TABLE #usersAndGroupsVisible
		CREATE TABLE #usersAndGroupsVisible (
			userOrGroupId INT,
			isUser INT,
			userLogin NVARCHAR(255),
			userName NVARCHAR(255),
			email NVARCHAR(255),
			groupName NVARCHAR(255),
			PRIMARY KEY (
				userOrGroupId,
				isUser
				)
			)
		IF OBJECT_ID('tempdb.dbo.#VisibleUsersAndUserGroups') IS NOT NULL
			DROP TABLE #VisibleUsersAndUserGroups
		CREATE TABLE #VisibleUsersAndUserGroups (userOrGroupId INT PRIMARY KEY)
		IF(@isAdminUserId = 0)      --NON-ADMIN user
		BEGIN
			EXEC sec_getUsersForThisUser '#VisibleUsersAndUserGroups',@userId
			INSERT INTO #usersAndGroupsVisible
			SELECT userOrGroupId, 1, UU.login, UU.name, UU.email, ''
				FROM #VisibleUsersAndUserGroups VU
			INNER JOIN UMUsers UU
				ON VU.userOrGroupId = UU.id
		END
		ELSE
		BEGIN
			DECLARE @excludeFlags INT = 0
			DECLARE @includeFlags INT = 1
SET @includeFlags = @includeFlags | CAST (0x001 AS INT)
			SET @excludeFlags = @excludeFlags | dbo.sec_getExcludeFlagsForUser()
			INSERT INTO #usersAndGroupsVisible
			SELECT id,1, login, name, email, ''
			FROM UMUsers with(NOLOCK)
			WHERE flags & @includeFlags <> 0
			AND flags & @excludeFlags = 0
		END
		TRUNCATE TABLE #VisibleUsersAndUserGroups
		IF(@isAdminUserId = 0)      --NON-ADMIN user
		BEGIN
			EXEC sec_getUserGroupsForThisUser '#VisibleUsersAndUserGroups',@userId
			INSERT INTO #usersAndGroupsVisible
			SELECT userOrGroupId, 0, '', '', '', UG.name
				FROM #VisibleUsersAndUserGroups VG
			INNER JOIN UMGroups UG
				ON VG.userOrGroupId = UG.id
		END
		ELSE
		BEGIN
			INSERT INTO #usersAndGroupsVisible
			SELECT UMGroups.Id,0, '', '', '', name
			FROM UMGroups
			WHERE NOT ( (name = 'Common Outlook Add-Ins')
					OR (name = 'CV_Restricted_Visibility')
OR ((groupFlags & 0x0001 = 0) AND (umdsProviderID <> 0))
OR (groupFlags & 0x0010 <> 0)
				)
		END
		DROP TABLE #VisibleUsersAndUserGroups
		UPDATE CL
			SET CL.clientOwners = (
				SELECT CASE
						WHEN UGV.isUSER = 1
							THEN UGV.userOrGroupId
						END AS '@userId',
					CASE
						WHEN UGV.isUser = 0
							THEN UGV.userOrGroupId
						END AS '@userGroupId',
					CASE
						WHEN UGV.isUSER = 1
							THEN UGV.userLogin
						END AS '@userName',
					CASE
						WHEN UGV.isUSER = 1
							THEN UGV.userName
						END AS '@name',
					CASE
						WHEN UGV.isUSER = 1
							THEN UGV.email
						END AS '@userEmail',
					CASE
						WHEN UGV.isUser = 0
							THEN UGV.groupName
						END AS '@userGroupName',
					CASE
						WHEN UGV.isUSER = 1
							THEN 13
						ELSE 15
						END AS '@_type_'
				FROM UMOwners UMO
				INNER JOIN #usersAndGroupsVisible UGV
					ON UGV.userOrGroupId = UMO.userOrGroupId AND UGV.isUser=UMO.isUser
				WHERE UMO.entityId=CL.cId AND UMO.entityType=3
				FOR XML PATH('owners'),
					TYPE
				)
		FROM #clientList CL
	IF OBJECT_ID('tempdb.dbo.#usersAndGroupsVisible ') IS NOT NULL
			DROP TABLE #usersAndGroupsVisible
	UPDATE #clientList set bShowActivateOption =
(CASE WHEN activatedMode=0 AND isUserCentricClient<>1 AND specialClientFlags&0x2=0 THEN 1
WHEN isUserCentricClient=1 AND specialClientFlags&0x2=0x2 AND (physicalClientID=0 OR physicalClientID IS NULL) THEN 1
				ELSE 0 END)
	UPDATE CL
	SET lastBackupJobInfo = AP.attrVal
	FROM #clientList CL
		INNER JOIN APP_IDAName(NOLOCK) A ON A.clientId = CL.cId AND A.apptypeid = CL.appid
		INNER JOIN APP_IDAProp (NOLOCK) AP ON AP.componentNameId = A.id AND AP.attrname = N'Last Backup Job Info' AND AP.modified = 0
	-- Compute SLA
	IF object_id('tempdb..#SLA_EntityInfo') IS NOT NULL DROP TABLE #SLA_EntityInfo
	CREATE TABLE #SLA_EntityInfo (
	clientId INT, appTypeId INT, instanceId INT, backupsetId INT, appId INT, -- entity IDs to set
	status INT, category INT, slaDays INT)
	insert into #SLA_EntityInfo(clientId, appTypeId)
	SELECT  cId, appId
	FROM #clientList
	exec RptGetSLAOfEntities 2
	UPDATE CL
	SET CL.SLAStatus = (CASE WHEN SLA.status = 1 THEN 1 WHEN SLA.status = 2 THEN 2 ELSE 3 END),
		CL.SLACategory = SLA.Category,
		CL.SLACategoryDescription = dbo.WR_GetSLACategoryString(@localeId,SLA.Category)
	FROM #clientList CL
		INNER JOIN #SLA_EntityInfo SLA
			ON CL.cId = SLA.clientId and CL.appId = SLA.appTypeId
	UPDATE CL
	SET CL.SLAStatus = 5,/*MIGHT_MISS_SLA*/
		CL.SLACategoryDescription = '',
		CL.slaMissReasonList = CAST(stringVal AS XML)
	FROM #clientList CL
INNER JOIN APP_ComponentProp Prop ON Prop.componentId = CL.cId AND Prop.componentType =  3 AND Prop.propertyTypeId = 3625 AND Prop.modified = 0
	;WITH nwReadniess(clientId, latestUpdateTime)
	AS
	(
		SELECT ToClientId, MAX(LastUpdateTime) FROM CCRClientToClient WITH(NOLOCK) WHERE FromClientId = 2 AND serviceType = 0 GROUP BY ToClientId
	)
	UPDATE cl
	SET nwReadiness = CASE WHEN CCR.flag IS NULL THEN 0 WHEN CCR.flag = 1 THEN 1 ELSE 2 END, lastOnlineTime = CCR.lastOnlineTime, lastOfflineTime = CCR.lastOfflineTime, nwReadinessUpdatedTime = CCR.lastUpdateTime
	FROM  nwReadniess R
			INNER JOIN CCRClientToClient CCR WITH(NOLOCK)
				ON R.clientId = CCR.ToClientId AND R.latestUpdateTime = CCR.LastUpdateTime
			RIGHT OUTER JOIN #clientList cl
				ON cl.cId = CCR.ToClientId AND FromClientId = 2 AND serviceType = 0
	UPDATE #clientList
	SET retireClientPhase = 1
	WHERE Cid IN (SELECT retireClientId FROM #RetireInProgressClientListTbl)
	ERROR_EXIT:
DECLARE @commCellName NVARCHAR(256)
DECLARE @csGuid NVARCHAR(40)
	SELECT 	@commCellName = aliasName,
			@csGuid = csGUID
	FROM APP_CommCell
	WHERE id = 2
		SET @o_xmlResp = CAST((
				SELECT (
					SELECT backupSize AS '@backupSize',
						capabilities AS '@capabilities',
						isOwner AS '@isOwner',
						totalbackupsize AS '@totalBackupSize',
						flag AS '@subclientStatus',
						clientStatus AS '@clientStatus',
						specialClientFlags AS '@specialClientFlags',
						isUserCentricClient AS '@isUserCentricClient',
						bShowActivateOption AS '@bShowActivateOption',
						SLAStatus AS '@slaStatus',
						SLACategory AS '@slaCategory',
						SLACategoryDescription AS '@slaCategoryDescription',
						(CASE WHEN isClientDeconfigured = 2 THEN NULL ELSE isClientDeconfigured END) AS '@isClientDeconfigured',
						nwReadiness AS '@readinessStatus',
						retireClientPhase AS '@retireClientPhase',
						slaMissReasonList.query('App_MightMissSLAList/reasonList') AS slaMissReasonList,
						(
							CASE
									WHEN planId = 0
										THEN NULL
									ELSE (
											SELECT planId AS '@planId',
												158 '@_type_',
												planName AS '@planName'
											FOR XML PATH('plan'),
												TYPE
											)
									END
							),
						(
							CASE
								WHEN physicalClientID = 0
									THEN NULL
								ELSE (
										SELECT physicalClientID AS '@clientId',
												3 '@_type_',
												ISNULL((select AC.name from  APP_Client AC where AC.id=physicalClientID),'') as '@clientName'
										FOR XML PATH ('physicalClient'),
										TYPE
										)
									END
							),
						(
							SELECT lastDataProtectedTime AS '@time',
								55 '@_type_'
							FOR XML PATH('lastBackupTime'),
								TYPE
							),
						(
							SELECT lastDataProtectedTime AS '@time',
								55 '@_type_'
							FOR XML PATH('lastSuccessBackupTime'),
								TYPE
							),
						(
							SELECT nextBkupTime AS '@time',
								55 '@_type_'
							FOR XML PATH('nextBackupTime'),
								TYPE
							),
						(
							SELECT lastOnlineTime AS '@time',
								55 '@_type_'
							FOR XML PATH('lastOnlineTime'),
								TYPE
							),
						(
							SELECT lastOfflineTime AS '@time',
								55 '@_type_'
							FOR XML PATH('lastOfflineTime'),
								TYPE
							),
						(
							SELECT nwReadinessUpdatedTime AS '@time',
								55 AS '@_type_'
							FOR XML PATH('readinessLastUpdatedTime'),
								TYPE
							),
						(
							SELECT lastDataProtectedTime AS '@time',
								55 '@_type_'
							FOR XML PATH('lastDataProtectedTime'),
								TYPE
							),
						(
							SELECT cId AS '@clientId',
								clientName AS '@clientName',
								hostname AS '@hostName',
								appId AS '@applicationId',
								instId AS '@instanceId',
								bSet AS '@backupsetId',
								subId AS '@subclientId',
7 '@_type_'
							FOR XML PATH('subClient'),TYPE
						),
						(
							SELECT 	cId AS '@clientId',
									clientName AS '@clientName',
3 '@_type_'
							FOR XML PATH('client'),TYPE
						),
						(
							SELECT	@commCellName AS '@commCellName',
									@csGuid AS '@csGUID',
1 '@_type_'
							FOR XML PATH('commCell'),TYPE
						),
						cl.clientOwners,
						(SELECT s.n.query('.') FROM cl.lastBackupJobInfo.nodes('lastBackupJobInfo') s(n))
					FROM #clientList cl
					FOR XML PATH('clientsFileSystem'), TYPE
				),
				( SELECT @o_errCode '@errorCode', @o_errString '@errorMessage'
						  FOR XML PATH('error'), TYPE
				)
				FOR XML PATH('App_LapTopClientLstResp')
			) AS NVARCHAR(MAX))
	END TRY
	----=====================================================================
	----==============  COME HERE IF THERE WAS A PROBLEM!     ===============
	----=====================================================================
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_errCode    = ERROR_NUMBER()
		SET @o_errString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
		SET @o_xmlResp = ( SELECT
					( SELECT @o_errCode '@errorCode', @o_errString '@errorMessage'
						  FOR XML PATH('error'), TYPE
					)
		FOR XML PATH(''),
		ROOT('App_LapTopClientLstResp'))
	END CATCH
	-- drop temp table
	IF object_id('tempdb.dbo.#clientList') IS NOT NULL
		DROP TABLE #clientList
	IF object_id('tempdb.dbo.#RetireInProgressClientListTbl') IS NOT NULL
		DROP TABLE #RetireInProgressClientListTbl
END
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetDevicesList')
	delete from GxQscripts where name = 'APPGetDevicesList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetDevicesList')
	delete from GXDBVersions where aliasname = 'APPGetDevicesList'
GO

insert into GXDBVersions values(2, 'APPGetDevicesList',  '00010001000200230000', 'APPGetDevicesList', '00010001000200230000')
GO

